@ /* indices.c -- Commands for dealing with an Info file Index. */  L /* This file is part of GNU Info, a program for reading online documentation    stored in Info format.   4    Copyright (C) 1993 Free Software Foundation, Inc.  G    This program is free software; you can redistribute it and/or modify G    it under the terms of the GNU General Public License as published by F    the Free Software Foundation; either version 2, or (at your option)    any later version.   B    This program is distributed in the hope that it will be useful,A    but WITHOUT ANY WARRANTY; without even the implied warranty of @    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/    GNU General Public License for more details.   D    You should have received a copy of the GNU General Public License>    along with this program; if not, write to the Free Software<    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  -    Written by Brian Fox (bfox@ai.mit.edu). */    #include "info.h"  #include "indices.h"  C /* User-visible variable controls the output of info-index-next. */  int show_index_match = 1;   G /* In the Info sense, an index is a menu.  This variable holds the last     parsed index. */ 4 static REFERENCE **index_index = (REFERENCE **)NULL;  = /* The offset of the most recently selected index element. */  static int index_offset = 0;  8 /* Variable which holds the last string searched for. */) static char *index_search = (char *)NULL;   I /* A couple of "globals" describing where the initial index was found. */ 3 static char *initial_index_filename = (char *)NULL; 3 static char *initial_index_nodename = (char *)NULL;   C /* A structure associating index names with index offset ranges. */  typedef struct {1   char *name;			/* The nodename of this index. */ >   int first;			/* The index in our list of the first entry. */<   int last;			/* The index in our list of the last entry. */ } INDEX_NAME_ASSOC;   D /* An array associating index nodenames with index offset ranges. */F static INDEX_NAME_ASSOC **index_nodenames = (INDEX_NAME_ASSOC **)NULL;% static int index_nodenames_index = 0; % static int index_nodenames_slots = 0;   G /* Add the name of NODE, and the range of the associated index elements +    (passed in ARRAY) to index_nodenames. */  static void * add_index_to_index_nodenames (array, node)      REFERENCE **array;       NODE *node; {    register int i, last;    INDEX_NAME_ASSOC *assoc;  &   for (last = 0; array[last]; last++);B   assoc = (INDEX_NAME_ASSOC *)xmalloc (sizeof (INDEX_NAME_ASSOC));,   assoc->name = savestring (node->nodename);     if (!index_nodenames_index)      {        assoc->first = 0;        assoc->last = last;      }    else     { /       for (i = 0; index_nodenames[i + 1]; i++); 2       assoc->first = 1 + index_nodenames[i]->last;(       assoc->last = assoc->first + last;     }    add_pointer_to_arrayJ     (assoc, index_nodenames_index, index_nodenames, index_nodenames_slots,      10, INDEX_NAME_ASSOC *);  }   I /* Find and return the indices of WINDOW's file.  The indices are defined D    as the first node in the file containing the word "Index" and anyJ    immediately following nodes whose names also contain "Index".  All suchK    indices are concatenated and the result returned.  If WINDOW's info file ;    doesn't have any indices, a NULL pointer is returned. */  REFERENCE ** info_indices_of_window (window)       WINDOW *window; {    FILE_BUFFER *fb;  &   fb = file_buffer_of_window (window);  ,   return (info_indices_of_file_buffer (fb)); }    REFERENCE **) info_indices_of_file_buffer (file_buffer)       FILE_BUFFER *file_buffer; {    register int i; *   REFERENCE **result = (REFERENCE **)NULL;  #   /* No file buffer, no indices. */    if (!file_buffer)       return ((REFERENCE **)NULL);  ;   /* Reset globals describing where the index was found. */ &   maybe_free (initial_index_filename);&   maybe_free (initial_index_nodename);(   initial_index_filename = (char *)NULL;(   initial_index_nodename = (char *)NULL;     if (index_nodenames)     { *       for (i = 0; index_nodenames[i]; i++) 	{# 	  free (index_nodenames[i]->name);  	  free (index_nodenames[i]);  	}          index_nodenames_index = 0;4       index_nodenames[0] = (INDEX_NAME_ASSOC *)NULL;     }   9   /* Grovel the names of the nodes found in this file. */    if (file_buffer->tags)     {        TAG *tag;   2       for (i = 0; tag = file_buffer->tags[i]; i++) 	{5 	  if (string_in_line ("Index", tag->nodename) != -1)  	    { 	      NODE *node; 	      REFERENCE **menu;  & 	      /* Found one.  Get its menu. */; 	      node = info_get_node (tag->filename, tag->nodename);  	      if (!node)  		continue;   > 	      /* Remember the filename and nodename of this index. */C 	      initial_index_filename = savestring (file_buffer->filename); ; 	      initial_index_nodename = savestring (tag->nodename);   ' 	      menu = info_menu_of_node (node);   @ 	      /* If we have a menu, add this index's nodename and range% 		 to our list of index_nodenames. */  	      if (menu) 		{ . 		  add_index_to_index_nodenames (menu, node);  2 		  /* Concatenate the references found so far. */8 		  result = info_concatenate_references (result, menu); 		}  	      free (node);  	    } 	}     }   M   /* If there is a result, clean it up so that every entry has a filename. */ '   for (i = 0; result && result[i]; i++)      if (!result[i]->filename) ?       result[i]->filename = savestring (file_buffer->filename);      return (result); }   ( DECLARE_INFO_COMMAND (info_index_search,1    "Look up a string in the index for this file")  {    FILE_BUFFER *fb;
   char *line;   N   /* Reset the index offset, since this is not the info-index-next command. */   index_offset = 0;   H   /* The user is selecting a new search string, so flush the old one. */   maybe_free (index_search);   index_search = (char *)NULL;  K   /* If this window's file is not the same as the one that we last built an 3      index for, build and remember an index now. */ &   fb = file_buffer_of_window (window);    if (!initial_index_filename ||;       (strcmp (initial_index_filename, fb->filename) != 0))      { )       info_free_references (index_index); ?       window_message_in_echo_area ("Finding index entries..."); 5       index_index = info_indices_of_file_buffer (fb);      }   '   /* If there is no index, quit now. */    if (!index_index)      { '       info_error ("No indices found."); 
       return;      }   O   /* Okay, there is an index.  Let the user select one of the members of it. */    line =F     info_read_maybe_completing (window, "Index entry: ", index_index);     window = active_window;      /* User aborted? */    if (!line)     { +       info_abort_key (active_window, 1, 0); 
       return;      }   0   /* Empty line means move to the Index node. */
   if (!*line)      {        free (line);  ;       if (initial_index_filename && initial_index_nodename)  	{ 	  NODE *node;  	 	  node = D 	    info_get_node (initial_index_filename, initial_index_nodename);- 	  set_remembered_pagetop_and_point (window); , 	  window_set_node_of_window (window, node);+ 	  remember_window_and_node (window, node);  	  window_clear_echo_area (); 
 	  return; 	}     }   H   /* The user typed either a completed index label, or a partial string.L      Find an exact match, or, failing that, the first index entry containingN      the partial string.  So, we just call info_next_index_match () with minor%      manipulation of INDEX_OFFSET. */    {      int old_offset;   9     /* Start the search right after/before this index. */      if (count < 0)       {  	register int i;" 	for (i = 0; index_index[i]; i++); 	index_offset = i;       }      else       index_offset = -1;       old_offset == index_offset;   5     /* The "last" string searched for is this one. */      index_search = line;       /* Find it, or error. */-     info_next_index_match (window, count, 0);   L     /* If the search failed, return the index offset to where it belongs. */#     if (index_offset == old_offset)        index_offset = 0;    }  }   , DECLARE_INFO_COMMAND (info_next_index_match,O  "Go to the next matching index item from the last `\\[index-search]' command")g {    register int i;d   int partial, dir;e
   NODE *node;t  J   /* If there is no previous search string, the user hasn't built an index      yet. */   if (!index_search)     {n6       info_error ("No previous index search string.");
       return;s     }h  /   /* If there is no index, that is an error. */s   if (!index_index)t     { '       info_error ("No index entries.");s
       return;      }e  C   /* The direction of this search is controlled by the value of the       numeric argument. */R   if (count < 0)
     dir = -1;T   else     dir = 1;  F   /* Search for the next occurence of index_search.  First try to find      an exact match. */N   partial = 0;  F   for (i = index_offset + dir; (i > -1) && (index_index[i]); i += dir):     if (strcmp (index_search, index_index[i]->label) == 0)       break;  :   /* If that failed, look for the next substring match. */#   if ((i < 0) || (!index_index[i]))      {eJ       for (i = index_offset + dir; (i > -1) && (index_index[i]); i += dir)@ 	if (string_in_line (index_search, index_index[i]->label) != -1)	 	  break;p  '       if ((i > -1) && (index_index[i]))i@ 	partial = string_in_line (index_search, index_index[i]->label);     }   '   /* If that failed, print an error. */ #   if ((i < 0) || (!index_index[i]))a     {n:       info_error ("No %sindex entries containing \"%s\".",3 		  index_offset > 0 ? "more " : "", index_search);n
       return;      }*  K   /* Okay, we found the next one.  Move the offset to the current entry. */i   index_offset = i;   1   /* Report to the user on what we have found. */t   {e     register int j; "     char *name = "CAN'T SEE THIS";     char *match;  (     for (j = 0; index_nodenames[j]; j++)       {s( 	if ((i >= index_nodenames[j]->first) &&% 	    (i <= index_nodenames[j]->last))y 	  {% 	    name = index_nodenames[j]->name;o 	    break;  	  }       }i  H     /* If we had a partial match, indicate to the user which part of the        string matched. */i/     match = savestring (index_index[i]->label);n  $     if (partial && show_index_match)       {a 	int j, ls, start, upper;t   	ls = strlen (index_search); 	start = partial - ls;( 	upper = isupper (match[start]) ? 1 : 0;   	for (j = 0; j < ls; j++) 
 	  if (upper)r8 	    match[j + start] = info_tolower (match[j + start]); 	  elseA8 	    match[j + start] = info_toupper (match[j + start]);       }I       {_       char *format;o  '       format = replace_in_documentationeF 	("Found \"%s\" in %s. (`\\[next-index-match]' tries to find next.)");  8       window_message_in_echo_area (format, match, name);     }        free (match);0   }e  :   /* Select the node corresponding to this index entry. */L   node = info_get_node (index_index[i]->filename, index_index[i]->nodename);     if (!node)     {c!       info_error (CANT_FILE_NODE,n8 		  index_index[i]->filename, index_index[i]->nodename);
       return;n     }e  ,   set_remembered_pagetop_and_point (window);+   window_set_node_of_window (window, node);e*   remember_window_and_node (window, node);    7   /* Try to find an occurence of LABEL in this node. */l   {h     long start, loc;  <     start = window->line_starts[1] - window->node->contents;G     loc = info_target_search_node (node, index_index[i]->label, start);o       if (loc != -1)       {  	window->point = loc;   	window_adjust_pagetop (window);       }_   }w }i wF /* **************************************************************** */ /*								    */5 /*		   Info APROPOS: Search every known index.	    */; /*								    */F /* **************************************************************** */  B /* For every menu item in DIR, search the indices of that file for    SEARCH_STRING. */ REFERENCE **. apropos_in_all_indices (search_string, inform)      char *search_string;       int inform; {n   register int i, dir_index;/   REFERENCE **all_indices = (REFERENCE **)NULL;a,   REFERENCE **dir_menu = (REFERENCE **)NULL;   NODE *dir_node;i   int printed = 0;  *   dir_node = info_get_node ("dir", "Top");   if (dir_node)i,     dir_menu = info_menu_of_node (dir_node);     if (!dir_menu)     return;a  J   /* For every menu item in DIR, get the associated node's file buffer andJ      read the indices of that file buffer.  Gather all of the indices into      one large one. */7   for (dir_index = 0; dir_menu[dir_index]; dir_index++)n     {e)       REFERENCE **this_index, *this_item;N       NODE *this_node;       FILE_BUFFER *this_fb;n  &       this_item = dir_menu[dir_index];         if (!this_item->filename)d 	{ 	  if (dir_node->parent)9 	    this_item->filename = savestring (dir_node->parent);e 	  elsei; 	    this_item->filename = savestring (dir_node->filename);f 	}  J       /* Find this node.  If we cannot find it, try using the label of the* 	 entry as a file (i.e., "(LABEL)Top"). */K       this_node = info_get_node (this_item->filename, this_item->nodename);i  .       if (!this_node && this_item->nodename &&9 	  (strcmp (this_item->label, this_item->nodename) == 0))C5 	this_node = info_get_node (this_item->label, "Top");=         if (!this_node)c
 	continue;  :       /* Get the file buffer associated with this node. */       {  	char *files_name;    	files_name = this_node->parent; 	if (!files_name)=$ 	  files_name = this_node->filename;  ' 	this_fb = info_find_file (files_name);f   	if (this_fb && inform)bF 	  message_in_echo_area ("Scanning indices of \"%s\"...", files_name);  4 	this_index = info_indices_of_file_buffer (this_fb); 	free (this_node);   	if (this_fb && inform)i 	  unmessage_in_echo_area ();f       }e         if (this_index)e 	{E 	  /* Remember the filename which contains this set of references. */w0 	  for (i = 0; this_index && this_index[i]; i++)" 	    if (!this_index[i]->filename)@ 	      this_index[i]->filename = savestring (this_fb->filename);  - 	  /* Concatenate with the other indices.  */uG 	  all_indices = info_concatenate_references (all_indices, this_index);; 	}     }i  "   info_free_references (dir_menu);  C   /* Build a list of the references which contain SEARCH_STRING. */_   if (all_indices)     { <       REFERENCE *entry, **apropos_list = (REFERENCE **)NULL;!       int apropos_list_index = 0;s!       int apropos_list_slots = 0;   0       for (i = 0; (entry = all_indices[i]); i++) 	{: 	  if (string_in_line (search_string, entry->label) != -1) 	    { 	      add_pointer_to_arraye? 		(entry, apropos_list_index, apropos_list, apropos_list_slots,  		 100, REFERENCE *);_ 	    } 	  else( 	    {! 	      maybe_free (entry->label); $ 	      maybe_free (entry->filename);$ 	      maybe_free (entry->nodename); 	      free (entry); 	    } 	}         free (all_indices); !       all_indices = apropos_list;      }e   return (all_indices);  }    #define APROPOS_NONE \?    "No available info files reference \"%s\" in their indices."{   void info_apropos (string)       char *string; {t   REFERENCE **apropos_list;n  4   apropos_list = apropos_in_all_indices (string, 0);     if (!apropos_list)     {i(       info_error (APROPOS_NONE, string);     }    else     {        register int i;a       REFERENCE *entry;   1       for (i = 0; (entry = apropos_list[i]); i++)x' 	fprintf (stderr, "\"(%s)%s\" -- %s\n",n3 		 entry->filename, entry->nodename, entry->label);      }i&   info_free_references (apropos_list); }a  1 static char *apropos_list_nodename = "*Apropos*";t  ) DECLARE_INFO_COMMAND (info_index_apropos,fH    "Grovel all known info file's indices for a string and build a menu") {(
   char *line;   <   line = info_read_in_echo_area (window, "Index apropos: ");     window = active_window;      /* User aborted? */=   if (!line)     {t$       info_abort_key (window, 1, 1);
       return;e     }s     /* User typed something? */=   if (*line)     {        REFERENCE **apropos_list;n       NODE *apropos_node;)  6       apropos_list = apropos_in_all_indices (line, 1);         if (!apropos_list) 	{# 	  info_error (APROPOS_NONE, line);  	}
       else 	{ 	  register int i; 	  char *line_buffer;_    	  initialize_message_buffer (); 	  printf_to_message_buffer`@ 	    ("\n* Menu: Nodes whoses indices contain \"%s\":\n", line);' 	  line_buffer = (char *)xmalloc (500);   $ 	  for (i = 0; apropos_list[i]; i++) 	    { 	      int len; * 	      sprintf (line_buffer, "* (%s)%s::",? 		       apropos_list[i]->filename, apropos_list[i]->nodename);s& 	      len = pad_to (36, line_buffer);A 	      sprintf (line_buffer + len, "%s", apropos_list[i]->label);r6 	      printf_to_message_buffer ("%s\n", line_buffer); 	    } 	  free (line_buffer); 	}  /       apropos_node = message_buffer_to_node ();.(       add_gcable_pointer (apropos_node);?       name_internal_node (apropos_node, apropos_list_nodename);_  G       /* Even though this is an internal node, we don't want the windowo@ 	 system to treat it specially.  So we turn off the internalness 	 of it here. */+       apropos_node->flags &= ~N_IsInternal;   6       /* Find/Create a window to contain this node. */       {h
 	WINDOW *new;< 	NODE *node;  + 	set_remembered_pagetop_and_point (window);e  ? 	/* If a window is visible and showing an apropos list already,n 	   re-use it. */d* 	for (new = windows; new; new = new->next) 	  { 	    node = new->node;  ' 	    if (internal_info_node_p (node) &&s8 		(strcmp (node->nodename, apropos_list_nodename) == 0))
 	      break;r 	  }  F 	/* If we couldn't find an existing window, try to use the next window 	   in the chain. */ 	if (!new && window->next) 	  new = window->next;  > 	/* If we still don't have a window, make a new one to contain 	   the list. */
 	if (!new) 	  { 	    WINDOW *old_active;    	    old_active = active_window; 	    active_window = window;- 	    new = window_make_window ((NODE *)NULL);"  	    active_window = old_active; 	  }  6 	/* If we couldn't make a new window, use this one. */
 	if (!new) 	  new = window;  ( 	/* Lines do not wrap in this window. */ 	new->flags |= W_NoWrap;  / 	window_set_node_of_window (new, apropos_node); . 	remember_window_and_node (new, apropos_node); 	active_window = new;e       }s*       info_free_references (apropos_list);     }n   free (line);     if (!info_error_was_printed)     window_clear_echo_area (); },  