I /* info-utils.c -- Useful functions for manipulating Info file quirks. */   L /* This file is part of GNU Info, a program for reading online documentation    stored in Info format.   4    Copyright (C) 1993 Free Software Foundation, Inc.  G    This program is free software; you can redistribute it and/or modify G    it under the terms of the GNU General Public License as published by F    the Free Software Foundation; either version 2, or (at your option)    any later version.   B    This program is distributed in the hope that it will be useful,A    but WITHOUT ANY WARRANTY; without even the implied warranty of @    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/    GNU General Public License for more details.   D    You should have received a copy of the GNU General Public License>    along with this program; if not, write to the Free Software<    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  -    Written by Brian Fox (bfox@ai.mit.edu). */   . #include <stdio.h>		/* For "NULL".  Yechhh! */ #include <ctype.h> #include <sys/types.h> #include <sys/stat.h>  #include "info-utils.h"   F /* When non-zero, various display and input functions handle ISO Latin    character sets correctly. */  int ISO_Latin_p = 0;  F /* Variable which holds the most recent filename parsed as a result of     calling info_parse_xxx (). */* char *info_parsed_filename = (char *)NULL;  F /* Variable which holds the most recent nodename parsed as a result of     calling info_parse_xxx (). */* char *info_parsed_nodename = (char *)NULL;  D /* Functions to remember a filename or nodename for later return. */0 static void save_filename (), saven_filename ();0 static void save_nodename (), saven_nodename ();  4 /* How to get a reference (either menu or cross). *// static REFERENCE **info_references_internal ();   D /* Parse the filename and nodename out of STRING.  If STRING doesn'tC    contain a filename (i.e., it is NOT (FILENAME)NODENAME) then set E    INFO_PARSED_FILENAME to NULL.  If second argument NEWLINES_OKAY is C    non-zero, it says to allow the nodename specification to cross a H    newline boundary (i.e., only `,', `.', or `TAB' can end the spec). */ void' info_parse_node (string, newlines_okay)       char *string;      int newlines_okay;  {    register int i = 0;      /* Default the answer. */    save_filename ((char *)NULL);    save_nodename ((char *)NULL);   8   /* Special case of nothing passed.  Return nothing. */   if (!string || !*string)     return;   %   string += skip_whitespace (string);   %   /* Check for (FILENAME)NODENAME. */    if (*string == '(')      {        i = 0;+       /* Advance past the opening paren. */        string++;   #       /* Find the closing paren. */ +       while (string[i] && string[i] != ')')  	i++;   %       /* Remember parsed filename. */ !       saven_filename (string, i);   +       /* Point directly at the nodename. */        string += i;         if (*string)
 	string++;     }      /* Parse out nodename. */ 3   i = skip_node_characters (string, newlines_okay);    saven_nodename (string, i); 1   canonicalize_whitespace (info_parsed_nodename); 5   if (info_parsed_nodename && !*info_parsed_nodename)      { "       free (info_parsed_nodename);*       info_parsed_nodename = (char *)NULL;     }  }   F /* Return the node addressed by LABEL in NODE (usually one of "Prev:",G    "Next:", "Up:", "File:", or "Node:".  After a call to this function, C    the global INFO_PARSED_NODENAME and INFO_PARSED_FILENAME contain     the information. */ void info_parse_label (label, node)      char *label;       NODE *node; {    register int i;    char *nodeline;   "   /* Default answer to failure. */   save_nodename ((char *)NULL);    save_filename ((char *)NULL);   6   /* Find the label in the first line of this node. */   nodeline = node->contents;'   i = string_in_line (label, nodeline);      if (i == -1)     return;      nodeline += i;)   nodeline += skip_whitespace (nodeline); 1   info_parse_node (nodeline, DONT_SKIP_NEWLINES);  }   F /* **************************************************************** */ /*								    */+ /*		    Finding and Building Menus			    */  /*								    */F /* **************************************************************** */  J /* Return a NULL terminated array of REFERENCE * which represents the menuN    found in NODE.  If there is no menu in NODE, just return a NULL pointer. */ REFERENCE ** info_menu_of_node (node)      NODE *node; {    long position;   SEARCH_BINDING search;(   REFERENCE **menu = (REFERENCE **)NULL;  !   search.buffer = node->contents;    search.start = 0;    search.end = node->nodelen;    search.flags = S_FoldCase;  #   /* Find the start of the menu. */ 7   position = search_forward (INFO_MENU_LABEL, &search);      if (position == -1) !     return ((REFERENCE **) NULL);   G   /* We have the start of the menu now.  Glean menu items from the rest       of the node. */5   search.start = position + strlen (INFO_MENU_LABEL); ;   search.start += skip_line (search.buffer + search.start);    search.start--; #   menu = info_menu_items (&search);    return (menu); }   K /* Return a NULL terminated array of REFERENCE * which represents the cross K    refrences found in NODE.  If there are no cross references in NODE, just     return a NULL pointer. */ REFERENCE ** info_xrefs_of_node (node)       NODE *node; {    SEARCH_BINDING search;  !   search.buffer = node->contents;    search.start = 0;    search.end = node->nodelen;    search.flags = S_FoldCase;      return (info_xrefs (&search)); }   D /* Glean menu entries from BINDING->buffer + BINDING->start until weB    have looked at the entire contents of BINDING.  Return an arrayB    of REFERENCE * that represents each menu item in this range. */ REFERENCE ** info_menu_items (binding)       SEARCH_BINDING *binding;  { E   return (info_references_internal (INFO_MENU_ENTRY_LABEL, binding));  }   E /* Glean cross references from BINDING->buffer + BINDING->start until E    BINDING->end.  Return an array of REFERENCE * that represents each $    cross reference in this range. */ REFERENCE ** info_xrefs (binding)      SEARCH_BINDING *binding;  { ?   return (info_references_internal (INFO_XREF_LABEL, binding));  }   F /* Glean cross references or menu items from BINDING.  Return an array5    of REFERENCE * that represents the items found. */  static REFERENCE ** ) info_references_internal (label, binding)       char *label;       SEARCH_BINDING *binding;  {    SEARCH_BINDING search;(   REFERENCE **refs = (REFERENCE **)NULL;%   int refs_index = 0, refs_slots = 0; #   int searching_for_menu_items = 0;    long position;  "   search.buffer = binding->buffer;    search.start = binding->start;   search.end = binding->end;)   search.flags = S_FoldCase | S_SkipDest;   K   searching_for_menu_items = (stricmp (label, INFO_MENU_ENTRY_LABEL) == 0);   <   while ((position = search_forward (label, &search)) != -1)     {        int offset, start;       char *refdef;        REFERENCE *entry;          search.start = position;E       search.start += skip_whitespace (search.buffer + search.start); ,       start = search.start - binding->start;,       refdef = search.buffer + search.start;,       offset = string_in_line (":", refdef);  @       /* When searching for menu items, if no colon, there is no 	 menu item on this line. */       if (offset == -1)  	{  	  if (searching_for_menu_items) 	    continue; 	  else  	    { 	      int temp;  ! 	      temp = skip_line (refdef); 4 	      offset = string_in_line (":", refdef + temp); 	      if (offset == -1) 		continue;	/* Give up? */ 	      else  		offset += temp;  	    } 	}  8       entry = (REFERENCE *)xmalloc (sizeof (REFERENCE));%       entry->filename = (char *)NULL; %       entry->nodename = (char *)NULL; .       entry->label = (char *)xmalloc (offset);1       strncpy (entry->label, refdef, offset - 1); &       entry->label[offset - 1] = '\0';-       canonicalize_whitespace (entry->label);          refdef += offset;        entry->start = start; ,       entry->end = refdef - binding->buffer;  D       /* If this reference entry continues with another ':' then the' 	 nodename is the same as the label. */o       if (*refdef == ':')i 	{/ 	  entry->nodename = savestring (entry->label);p 	}
       else 	{? 	  /* This entry continues with a specific nodename.  Parse theo) 	     nodename from the specification. */   3 	  refdef += skip_whitespace_and_newlines (refdef);b    	  if (searching_for_menu_items)2 	    info_parse_node (refdef, DONT_SKIP_NEWLINES); 	  elsev- 	    info_parse_node (refdef, SKIP_NEWLINES);h   	  if (info_parsed_filename)9 	    entry->filename = savestring (info_parsed_filename);n   	  if (info_parsed_nodename)9 	    entry->nodename = savestring (info_parsed_nodename);b 	}         add_pointer_to_array8 	(entry, refs_index, refs, refs_slots, 50, REFERENCE *);     }n   return (refs); }s  H /* Get the entry associated with LABEL in MENU.  Return a pointer to the"    REFERENCE if found, or NULL. */ REFERENCE *r. info_get_labeled_reference (label, references)      char *label;.      REFERENCE **references; {    register int i;.   REFERENCE *entry;t  9   for (i = 0; references && (entry = references[i]); i++)i     {n,       if (strcmp (label, entry->label) == 0) 	return (entry);     }n   return ((REFERENCE *)NULL);l }h  D /* A utility function for concatenating REFERENCE **.  Returns a newF    REFERENCE ** which is the concatenation of REF1 and REF2.  The REF1<    and REF2 arrays are freed, but their contents are not. */ REFERENCE **( info_concatenate_references (ref1, ref2)      REFERENCE **ref1, **ref2; {t   register int i, j;   REFERENCE **result;a   int size;/  F   /* With one argument passed as NULL, simply return the other arg. */   if (!ref1)     return (ref2);   else if (!ref2)c     return (ref1);  :   /* Get the total size of the slots that we will need. */   for (i = 0; ref1[i]; i++);   size = i;T   for (i = 0; ref2[i]; i++);   size += i;  E   result = (REFERENCE **)xmalloc ((1 + size) * sizeof (REFERENCE *));M     /* Copy the contents over. */I   for (i = 0; ref1[i]; i++)      result[i] = ref1[i];     j = i;   for (i = 0; ref2[i]; i++)u     result[j++] = ref2[i];      result[j] = (REFERENCE *)NULL;   free (ref1);   free (ref2);   return (result); }s  / /* Free the data associated with REFERENCES. */t void! info_free_references (references)       REFERENCE **references; {    register int i;h   REFERENCE *entry;S     if (references)g     {.=       for (i = 0; references && (entry = references[i]); i++)  	{ 	  maybe_free (entry->label);n  	  maybe_free (entry->filename);  	  maybe_free (entry->nodename);   	  free (entry); 	}         free (references);     }  }e  F /* Search for sequences of whitespace or newlines in STRING, replacingG    all such sequences with just a single space.  Remove whitespace fromf    start and end of string. */ void  canonicalize_whitespace (string)      char *string; {    register int i, j;,   int len, whitespace_found, whitespace_loc;
   char *temp;d     if (!string)     return;r     len = strlen (string);#   temp = (char *)xmalloc (1 + len);   F   /* Search for sequences of whitespace or newlines.  Replace all such9      sequences in the string with just a single space. */p     whitespace_found = 0;o$   for (i = 0, j = 0; string[i]; i++)     { ,       if (whitespace_or_newline (string[i])) 	{ 	  whitespace_found++; 	  whitespace_loc = i; 	  continue; 	}
       else 	{* 	  if (whitespace_found && whitespace_loc) 	    { 	      whitespace_found = 0; 	      temp[j++] = ' ';/ 	    }   	  temp[j++] = string[i];) 	}     }   !   /* Kill trailing whitespace. */i$   if (j && whitespace (temp[j - 1]))     j--;     temp[j] = '\0';/   strcpy (string, temp);   free (temp); }l  L /* String representation of a char returned by printed_representation (). */ static char the_rep[10];  C /* Return a pointer to a string which is the printed representatione.    of CHARACTER if it were printed at HPOS. */ char *( printed_representation (character, hpos)      unsigned char character;       int hpos; {*   register int i = 0;*   int printable_limit;     if (ISO_Latin_p)     printable_limit = 160;   else     printable_limit = 127;     if (character == '\177')     {*       the_rep[i++] = '^';*       the_rep[i++] = '?';t     }e   else if (iscntrl (character))e     {h       switch (character) 	{ 	case '\r':e 	case '\n':u 	  the_rep[i++] = character;	 	  break;*   	case '\t':n 	  { 	    int tw;  % 	    tw = ((hpos + 8) & 0xf8) - hpos;B 	    while (i < tw)E 	      the_rep[i++] = ' '; 	  }	 	  break;h  	 	default:e 	  the_rep[i++] = '^';% 	  the_rep[i++] = (character | 0x40);n 	}     }h'   else if (character > printable_limit)r     {e0       sprintf (the_rep + i, "\\%0o", character);       i = strlen (the_rep);o     }=   else     the_rep[i++] = character;)     the_rep[i] = '\0';     return (the_rep);G }n    F /* **************************************************************** */ /*								    */- /*		    Functions Static To This File		    */u /*								    */F /* **************************************************************** */  G /* Amount of space allocated to INFO_PARSED_FILENAME via xmalloc (). */e$ static int parsed_filename_size = 0;  G /* Amount of space allocated to INFO_PARSED_NODENAME via xmalloc (). */p$ static int parsed_nodename_size = 0;  , static void save_string (), saven_string ();  I /* Remember FILENAME in PARSED_FILENAME.  An empty FILENAME is translated +    to a NULL pointer in PARSED_FILENAME. */= static void  save_filename (filename)      char *filename; {mG   save_string (filename, &info_parsed_filename, &parsed_filename_size);d }   H /* Just like save_filename (), but you pass the length of the string. */ static voidm saven_filename (filename, len)      char *filename;
      int len;  {    saven_string (filename, len,0 		&info_parsed_filename, &parsed_filename_size); }A  I /* Remember NODENAME in PARSED_NODENAME.  An empty NODENAME is translatedI+    to a NULL pointer in PARSED_NODENAME. */  static voidR save_nodename (nodename)      char *nodename; { G   save_string (nodename, &info_parsed_nodename, &parsed_nodename_size);b }i  H /* Just like save_nodename (), but you pass the length of the string. */ static voidn saven_nodename (nodename, len)      char *nodename;
      int len;  {E   saven_string (nodename, len,0 		&info_parsed_nodename, &parsed_nodename_size); }n  M /* Remember STRING in STRING_P.  STRING_P should currently have STRING_SIZE_P J    bytes allocated to it.  An empty STRING is translated to a NULL pointer    in STRING_P. */ static void - save_string (string, string_p, string_size_p)t      char *string;      char **string_p;       int *string_size_p; {r   if (!string || !*string)     {        if (*string_p) 	free (*string_p);         *string_p = (char *)NULL;i       *string_size_p = 0;_     }=   else     {l,       if (strlen (string) >= *string_size_p) 	*string_p = (char *)xreallocs7 	  (*string_p, (*string_size_p = 1 + strlen (string)));   !       strcpy (*string_p, string);      }r }s  G /* Just like save_string (), but you also pass the length of STRING. */r static voidn3 saven_string (string, len, string_p, string_size_p)t      char *string;
      int len;       char **string_p;       int *string_size_p; {e   if (!string)     {i       if (*string_p) 	free (*string_p);         *string_p = (char *)NULL;c       *string_size_p = 0;c     };   else     {         if (len >= *string_size_p)F 	*string_p = (char *)xrealloc (*string_p, (*string_size_p = 1 + len));  '       strncpy (*string_p, string, len);e       (*string_p)[len] = '\0';     }t }   L /* Return a pointer to the part of PATHNAME that simply defines the file. */ char *! filename_non_directory (pathname)       char *pathname; {    char *filename;r  ,   filename = (char *)rindex (pathname, '/');     if (filename)r     filename++;)   else     filename = pathname;     return (filename); }e  @ /* Return non-zero if NODE is one especially created by Info. */ inta internal_info_node_p (node)d      NODE *node; {b
   if (node && -       (node->filename && !*node->filename) &&e&       !node->parent && node->nodename)     return (1);    else     return (0);i }{  < /* Make NODE appear to be one especially created by Info. */ void name_internal_node (node, name)       NODE *node;      char *name; {    if (!node)     return;t     node->filename = "";   node->parent = (char *)NULL;   node->nodename = name;   node->flags |= N_IsInternal; }o  G /* Return the window displaying NAME, the name of an internally createdK    Info window. */ WINDOW * get_internal_info_window (name)e      char *name; {f   WINDOW *win = (WINDOW *)NULL;f  +   for (win = windows; win; win = win->next)s+     if (internal_info_node_p (win->node) &&d+ 	(strcmp (win->node->nodename, name) == 0)),       break;     return (win);  }n