H /* info-utils.h -- Exported functions and variables from info-util.c. */  L /* This file is part of GNU Info, a program for reading online documentation    stored in Info format.   4    Copyright (C) 1993 Free Software Foundation, Inc.  G    This program is free software; you can redistribute it and/or modify G    it under the terms of the GNU General Public License as published by F    the Free Software Foundation; either version 2, or (at your option)    any later version.   B    This program is distributed in the hope that it will be useful,A    but WITHOUT ANY WARRANTY; without even the implied warranty of @    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/    GNU General Public License for more details.   D    You should have received a copy of the GNU General Public License>    along with this program; if not, write to the Free Software<    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  -    Written by Brian Fox (bfox@ai.mit.edu). */    #if !defined (_INFO_UTILS_H_)  #define _INFO_UTILS_H_   #if !defined (HAVE_RINDEX) #undef index
 #undef rindex  #define index strchr #define rindex strrchr #endif   #if !defined (HAVE_BCOPY)  #undef bcopy> #define bcopy(source, dest, count) memcpy(dest, source, count) #endif   #include "nodes.h" #include "window.h"  #include "search.h"   F /* Structure which describes a node reference, such as a menu entry orF    cross reference.  Arrays of such references can be built by calling5    info_menus_of_node () or info_xrefs_of_node (). */  typedef struct {!   char *label;		/* User Label. */ :   char *filename;	/* File where this node can be found. */)   char *nodename;	/* Name of the node. */ D   int start, end;	/* Offsets within the containing node of LABEL. */ } REFERENCE;  F /* When non-zero, various display and input functions handle ISO Latin    character sets correctly. */  extern int ISO_Latin_p;   F /* Variable which holds the most recent filename parsed as a result of     calling info_parse_xxx (). */" extern char *info_parsed_filename;  F /* Variable which holds the most recent nodename parsed as a result of     calling info_parse_xxx (). */" extern char *info_parsed_nodename;  D /* Parse the filename and nodename out of STRING.  If STRING doesn'tC    contain a filename (i.e., it is NOT (FILENAME)NODENAME) then set E    INFO_PARSED_FILENAME to NULL.  If second argument NEWLINES_OKAY is C    non-zero, it says to allow the nodename specification to cross a H    newline boundary (i.e., only `,', `.', or `TAB' can end the spec). */ void info_parse_node ();  J /* Return a NULL terminated array of REFERENCE * which represents the menuN    found in NODE.  If there is no menu in NODE, just return a NULL pointer. */( extern REFERENCE **info_menu_of_node ();  K /* Return a NULL terminated array of REFERENCE * which represents the cross K    refrences found in NODE.  If there are no cross references in NODE, just     return a NULL pointer. */) extern REFERENCE **info_xrefs_of_node ();   E /* Glean cross references from BINDING->buffer + BINDING->start until E    BINDING->end.  Return an array of REFERENCE * that represents each $    cross reference in this range. */! extern REFERENCE **info_xrefs ();   J /* Get the entry associated with LABEL in REFERENCES.  Return a pointer to&    the reference if found, or NULL. */0 extern REFERENCE *info_get_labeled_reference ();  D /* Glean menu entries from BINDING->buffer + BINDING->start until weB    have looked at the entire contents of BINDING.  Return an arrayB    of REFERENCE * that represents each menu item in this range. */& extern REFERENCE **info_menu_items ();  D /* A utility function for concatenating REFERENCE **.  Returns a newF    REFERENCE ** which is the concatenation of REF1 and REF2.  The REF1<    and REF2 arrays are freed, but their contents are not. */+ REFERENCE **info_concatenate_references ();   / /* Free the data associated with REFERENCES. */ $ extern void info_free_references ();  F /* Search for sequences of whitespace or newlines in STRING, replacingG    all such sequences with just a single space.  Remove whitespace from     start and end of string. */  void canonicalize_whitespace ();  C /* Return a pointer to a string which is the printed representation .    of CHARACTER if it were printed at HPOS. */' extern char *printed_representation ();   L /* Return a pointer to the part of PATHNAME that simply defines the file. */' extern char *filename_non_directory ();   @ /* Return non-zero if NODE is one especially created by Info. */# extern int internal_info_node_p ();   N /* Make NODE appear to be one especially created by Info, and give it NAME. */" extern void name_internal_node ();  G /* Return the window displaying NAME, the name of an internally created     Info window. */+ extern WINDOW *get_internal_info_window ();   F /* Return the node addressed by LABEL in NODE (usually one of "Prev:",G    "Next:", "Up:", "File:", or "Node:".  After a call to this function, C    the global INFO_PARSED_NODENAME and INFO_PARSED_FILENAME contain     the information. */1 extern void info_parse_label (/* label, node */);    #define info_label_was_found \A    (info_parsed_nodename != NULL || info_parsed_filename != NULL)   H #define info_file_label_of_node(n) info_parse_label (INFO_FILE_LABEL, n)H #define info_next_label_of_node(n) info_parse_label (INFO_NEXT_LABEL, n)F #define info_up_label_of_node(n)   info_parse_label (INFO_UP_LABEL, n)$ #define info_prev_label_of_node(n) \   do { \,     info_parse_label (INFO_PREV_LABEL, n); \      if (!info_label_was_found) \1       info_parse_label (INFO_ALTPREV_LABEL, n); \ 
   } while (0)    #endif /* !_INFO_UTILS_H_ */