@ /* info.c -- Display nodes of Info files in multiple windows. */  L /* This file is part of GNU Info, a program for reading online documentation    stored in Info format.   4    Copyright (C) 1993 Free Software Foundation, Inc.  G    This program is free software; you can redistribute it and/or modify G    it under the terms of the GNU General Public License as published by F    the Free Software Foundation; either version 2, or (at your option)    any later version.   B    This program is distributed in the hope that it will be useful,A    but WITHOUT ANY WARRANTY; without even the implied warranty of @    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/    GNU General Public License for more details.   D    You should have received a copy of the GNU General Public License>    along with this program; if not, write to the Free Software<    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  -    Written by Brian Fox (bfox@ai.mit.edu). */    #include "info.h"  #include "dribble.h" #include "getopt.h"   2 /* The version numbers of this version of Info. */ int info_major_version = 2;  int info_minor_version = 10; int info_patch_level = 1;   B /* Non-zero means search all indices for APROPOS_SEARCH_STRING. */ static int apropos_p = 0;   N /* Variable containing the string to search for when apropos_p is non-zero. */2 static char *apropos_search_string = (char *)NULL;  - /* Non-zero means print version info only. */  static int print_version_p = 0;   > /* Non-zero means print a short description of the options. */ static int print_help_p = 0;  K /* Array of the names of nodes that the user specified with "--node" on the     command line. */ - static char **user_nodenames = (char **)NULL; $ static int user_nodenames_index = 0;$ static int user_nodenames_slots = 0;  I /* String specifying the first file to load.  This string can only be set :    by the user specifying "--file" on the command line. */* static char *user_filename = (char *)NULL;  J /* String specifying the name of the file to dump nodes to.  This value isB    filled if the user speficies "--output" on the command line. */1 static char *user_output_filename = (char *)NULL;   H /* Non-zero indicates that when "--output" is specified, all of the menuF    items of the specified nodes (and their subnodes as well) should beH    dumped in the order encountered.  This basically can print a book. */ int dump_subnodes = 0;  N /* Structure describing the options that Info accepts.  We pass this structureN    to getopt_long ().  If you add or otherwise change this structure, you must.    also change the string which follows it. */ #define APROPOS_OPTION 1 #define DRIBBLE_OPTION 2 #define RESTORE_OPTION 3' static struct option long_options[] = { &   { "apropos", 1, 0, APROPOS_OPTION },   { "directory", 1, 0, 'd' },    { "node", 1, 0, 'n' },   { "file", 1, 0, 'f' },'   { "subnodes", 0, &dump_subnodes, 1 },    { "output", 1, 0, 'o' },"   { "help", 0, &print_help_p, 1 },(   { "version", 0, &print_version_p, 1 },&   { "dribble", 1, 0, DRIBBLE_OPTION },&   { "restore", 1, 0, RESTORE_OPTION },   {NULL, 0, NULL, 0} };  O /* String describing the shorthand versions of the long options found above. */ ) static char *short_options = "d:n:f:o:s";   A /* When non-zero, the Info window system has been initialized. */ # int info_windows_initialized_p = 0;   " /* Some "forward" declarations. */H static void usage (), info_short_help (), remember_info_program_name ();    F /* **************************************************************** */ /*								    */2 /*		  Main Entry Point to the Info Program		    */ /*								    */F /* **************************************************************** */   int  main (argc, argv)       int argc;      char **argv;  { @   int getopt_long_index;	/* Index returned by getopt_long (). */7   NODE *initial_node;		/* First node loaded by Info. */   & #if defined (NeXT) && defined (NOTDEF)   malloc_debug (0x0ffffffff);  #endif /* NeXT && NOTDEF */   '   remember_info_program_name (argv[0]);      while (1)      {        int option_character;   $       option_character = getopt_long? 	(argc, argv, short_options, long_options, &getopt_long_index);   K       /* getopt_long () returns EOF when there are no more long options. */ "       if (option_character == EOF) 	break;   G       /* If this is a long option, then get the short version of it. */ M       if (option_character == 0 && long_options[getopt_long_index].flag == 0) 8 	option_character = long_options[getopt_long_index].val;  5       /* Case on the option that we have received. */        switch (option_character)  	{ 	case 0:	 	  break;   ' 	  /* User wants to add a directory. */ 
 	case 'd':, 	  info_add_path (optarg, INFOPATH_PREPEND);	 	  break;   . 	  /* User is specifying a particular node. */
 	case 'n':F 	  add_pointer_to_array (optarg, user_nodenames_index, user_nodenames,& 				user_nodenames_slots, 10, char *);	 	  break;   3 	  /* User is specifying a particular Info file. */ 
 	case 'f': 	  if (user_filename)  	    free (user_filename);  ' 	  user_filename = savestring (optarg); 	 	  break;   < 	  /* User is specifying the name of a file to output to. */
 	case 'o': 	  if (user_output_filename)! 	    free (user_output_filename); . 	  user_output_filename = savestring (optarg);	 	  break;   @ 	  /* User is specifying that she wishes to dump the subnodes of& 	     the node that she is dumping. */
 	case 's': 	  dump_subnodes = 1; 	 	  break;   ? 	  /* User has specified a string to search all indices for. */  	case APROPOS_OPTION:  	  apropos_p = 1; & 	  maybe_free (apropos_search_string);/ 	  apropos_search_string = savestring (optarg); 	 	  break;   A 	  /* User has specified a dribble file to receive keystrokes. */  	case DRIBBLE_OPTION:  	  close_dribble_file ();  	  open_dribble_file (optarg);	 	  break;   6 	  /* User has specified an alternate input stream. */ 	case RESTORE_OPTION: % 	  info_set_input_from_file (optarg); 	 	  break;   	 	default:  	  usage (); 	}     }   H   /* If the user specified --version, then show the version and exit. */   if (print_version_p)     { <       printf ("GNU Info, Version %s.\n", version_string ());       exit (0);      }   C   /* If the `--help' option was present, show the help and exit. */    if (print_help_p)      {        info_short_help ();        exit (0);      }    J   /* If the user hasn't specified a path for Info files, default that path      now. */   if (!infopath)     { &       char *path_from_env, *getenv ();  *       path_from_env = getenv ("INFOPATH");         if (path_from_env) 	info_add_path (path_from_env); 
       else" 	info_add_path (DEFAULT_INFOPATH);     }   F   /* If the user specified a particular filename, add the path of that)      file to the contents of INFOPATH. */    if (user_filename)     { "       char *directory_name, *temp;  2       directory_name = savestring (user_filename);5       temp = filename_non_directory (directory_name);   !       if (temp != directory_name)  	{
 	  *temp = 0; 4 	  info_add_path (directory_name, INFOPATH_PREPEND); 	}         free (directory_name);     }   F   /* If the user wants to search every known index for a given string,,      do that now, and report the results. */   if (apropos_p)     { +       info_apropos (apropos_search_string);        exit (0);      }   J   /* Get the initial Info node.  It is either "(dir)Top", or what the userA      specifed with values in user_filename and user_nodenames. */    if (user_nodenames) D     initial_node = info_get_node (user_filename, user_nodenames[0]);   else?     initial_node = info_get_node (user_filename, (char *)NULL);   E   /* If we couldn't get the initial node, this user is in trouble. */    if (!initial_node)     { !       if (info_recent_file_error) % 	info_error (info_recent_file_error); 
       else 	info_error @ 	  (CANT_FIND_NODE, user_nodenames ? user_nodenames[0] : "Top");       exit (1);      }   I   /* Special cases for when the user specifies multiple nodes.  If we are L      dumping to an output file, dump all of the nodes specified.  Otherwise,N      attempt to create enough windows to handle the nodes that this user wants      displayed. */   if (user_nodenames_index > 1)i     {s       free (initial_node);         if (user_output_filename)o 	dump_nodes_to_fileTH 	  (user_filename, user_nodenames, user_output_filename, dump_subnodes);
       elseD 	begin_multiple_window_info_session (user_filename, user_nodenames);         exit (0);;     }   G   /* If there are arguments remaining, they are the names of menu itemssG      in sequential info files starting from the first one loaded.  ThatAG      file name is either "dir", or the contents of user_filename if one       was specified. */   while (optind != argc)     {        REFERENCE **menu;        REFERENCE *entry;c       NODE *node;        char *arg;  8       /* Remember the name of the menu entry we want. */       arg = argv[optind++];I  C       /* Build and return a list of the menu items in this node. */ .       menu = info_menu_of_node (initial_node);  E       /* If there wasn't a menu item in this node, stop here, but lets? 	 the user continue to use Info.  Perhaps they wanted this noder 	 and didn't realize it. */h       if (!menu) 	{  	  begin_info_session_with_error6 	    (initial_node, "There is no menu in this node."); 	  exit (0); 	}  )       /* Find the specified menu item. */p5       entry = info_get_labeled_reference (arg, menu);(  J       /* If the item wasn't found, search the list sloppily.  Perhaps this: 	 user typed "buffer" when they really meant "Buffers". */       if (!entry)s 	{ 	  register int i;  $ 	  for (i = 0; entry = menu[i]; i++)9 	    if (strnicmp (entry->label, arg, strlen (arg)) == 0)a
 	      break;t 	}  H       /* If we failed to find the reference, start Info with the current0 	 node anyway.  It is probably a misspelling. */       if (!entry)f 	{F 	  char *error_message = "There is no menu item \"%s\" in this node.";   	  info_free_references (menu);t  9 	  /* If we were supposed to dump this node, complain. */i 	  if (user_output_filename)% 	    info_error (error_message, arg);f 	  else F 	    begin_info_session_with_error (initial_node, error_message, arg);   	  exit (0); 	}  G       /* We have found the reference that the user specified.  Clean it  	 up a little bit. */p       if (!entry->filename)o 	{ 	  if (initial_node->parent)9 	    entry->filename = savestring (initial_node->parent);  	  elseu; 	    entry->filename = savestring (initial_node->filename);I 	}  G       /* Find this node.  If we can find it, then turn the initial_noderB 	 into this one.  If we cannot find it, try using the label of theC 	 entry as a file (i.e., "(LABEL)Top").  Otherwise the Info file is B 	 malformed in some way, and we will just use the current value of 	 initial node. */>       node = info_get_node (entry->filename, entry->nodename);  %       if (!node && entry->nodename && 1 	  (strcmp (entry->label, entry->nodename) == 0))", 	node = info_get_node (entry->label, "Top");         if (node), 	{ 	  free (initial_node);  	  initial_node = node;E 	  info_free_references (menu);R 	}
       else 	{* 	  char *temp = savestring (entry->label); 	  char *error_message;   C 	  error_message = "Unable to find the node referenced by \"%s\".";:   	  info_free_references (menu);n  C 	  /* If we were trying to dump the node, then give up.  Otherwise,d1 	     start the session with an error message. */t 	  if (user_output_filename)& 	    info_error (error_message, temp); 	  else*G 	    begin_info_session_with_error (initial_node, error_message, temp);	   	  exit (0); 	}     }y  H   /* If the user specified that this node should be output, then do that?      now.  Otherwise, start the Info session with this node. */r   if (user_output_filename) J     dump_node_to_file (initial_node, user_output_filename, dump_subnodes);   else&     begin_info_session (initial_node);     exit (0);. }   = /* Return a string describing the current version of Info. */f char * version_string ()  {D&   static char *vstring = (char *)NULL;     if (!vstring)l     { %       vstring = (char *)xmalloc (50); I       sprintf (vstring, "%d.%d", info_major_version, info_minor_version);i       if (info_patch_level) @ 	sprintf (vstring + strlen (vstring), "-p%d", info_patch_level);     }*   return (vstring);c }a rF /* **************************************************************** */ /*								    */' /*		   Error Handling for Info			    */l /*								    */F /* **************************************************************** */  ) static char *program_name = (char *)NULL;t   static voide% remember_info_program_name (fullpath)       char *fullpath; {    char *filename;s  /   filename = filename_non_directory (fullpath);a'   program_name = savestring (filename);  }   . /* Non-zero if an error has been signalled. */ int info_error_was_printed = 0;   2 /* Non-zero means ring terminal bell on errors. */  int info_error_rings_bell_p = 1;  J /* Print FORMAT with ARG1 and ARG2.  If the window system was initialized,I    then the message is printed in the echo area.  Otherwise, a message iss    output to stderr. */b void info_error (format, arg1, arg2)n      char *format;      void *arg1, *arg2;  {    info_error_was_printed = 1;e  7   if (!info_windows_initialized_p || display_inhibited)t     {p-       fprintf (stderr, "%s: ", program_name);t+       fprintf (stderr, format, arg1, arg2);        fprintf (stderr, "\n");/       fflush (stderr);     }=   else     {        if (!echo_area_is_active)r 	{ 	  if (info_error_rings_bell_p)c 	    terminal_ring_bell ();p4 	  window_message_in_echo_area (format, arg1, arg2); 	}
       else 	{ 	  NODE *temp;  2 	  temp = build_message_node (format, arg1, arg2); 	  if (info_error_rings_bell_p). 	    terminal_ring_bell (); ( 	  inform_in_echo_area (temp->contents); 	  free (temp->contents);  	  free (temp);s 	}     }a }l  I /* Produce a very brief descripton of the available options and exit with     an error. */e static voidu usage () {e)   fprintf (stderr,"%s\n%s\n%s\n%s\n%s\n",iN "Usage: info [-d dir-path] [-f info-file] [-o output-file] [-n node-name]...",N "            [--directory dir-path] [--file info-file] [--node node-name]...",G "            [--help] [--output output-file] [--subnodes] [--version]",i= "            [--dribble dribble-file] [--restore from-file]", $ "            [menu-selection ...]");   exit (1);s }   I /* Produce a scaled down description of the available options to Info. */p static void  info_short_help () {n   printf ("%s", "\F Here is a quick description of Info's options.  For a more complete\n\< description of how to use Info, type `info info options'.\n\ \n\_+    --directory DIR		Add DIR to INFOPATH.\n\i2    --file FILENAME		Specify Info file to visit.\n\@    --node NODENAME		Specify nodes in first visited Info file.\n\;    --output FILENAME		Output selected nodes to FILENAME.\n\e?    --dribble FILENAME		Remember user keystrokes in FILENAME.\n\r@    --restore FILENAME		Read initial keystrokes from FILENAME.\n\1    --subnodes			Recursively output menu items.\n\O%    --help			Get this help message.\n\t5    --version			Display Info's version information.\n\e \n\k? Remaining arguments to Info are treated as the names of menu\n\rA items in the initial node visited.  You can easily move to the\n\eB node of your choice by specifying the menu names which describe\n\? the path to that node.  For example, `info emacs buffers'.\n");      exit (0);u }_