> /* infohelp.c -- Functions which build documentation nodes. */  L /* This file is part of GNU Info, a program for reading online documentation    stored in Info format.   4    Copyright (C) 1993 Free Software Foundation, Inc.  G    This program is free software; you can redistribute it and/or modify G    it under the terms of the GNU General Public License as published by F    the Free Software Foundation; either version 2, or (at your option)    any later version.   B    This program is distributed in the hope that it will be useful,A    but WITHOUT ANY WARRANTY; without even the implied warranty of @    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/    GNU General Public License for more details.   D    You should have received a copy of the GNU General Public License>    along with this program; if not, write to the Free Software<    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  -    Written by Brian Fox (bfox@ai.mit.edu). */    #include "info.h"   F /* **************************************************************** */ /*								    */! /*			  Info Help Windows			    */  /*								    */F /* **************************************************************** */  3 /* The name of the node used in the help window. */ 0 static char *info_help_nodename = "*Info Help*";  E /* A node containing printed key bindings and their documentation. */ 4 static NODE *internal_info_help_node = (NODE *)NULL;  C /* The static text which appears in the internal info help node. */ * static char *info_internal_help_text[] = {#   "Basic Commands in Info Windows", #   "******************************",    "", $   "  h   Invoke the Info tutorial.",   "",    "Selecting other nodes:",    "----------------------", 2   "  n   Move to the \"next\" node of this node.",6   "  p   Move to the \"previous\" node of this node.",&   "  u   Move \"up\" from this node.",,   "  m   Pick menu item specified by name.",B   "      Picking a menu item causes another node to be selected.",>   "  f   Follow a cross reference.  Reads name of reference.",5   "  l   Move to the last node seen in this window.", A   "  d   Move to the `directory' node.  Equivalent to `g(DIR)'.",    "",    "Moving within a node:",   "---------------------",!   "  SPC Scroll forward a page.", "   "  DEL Scroll backward a page.",,   "  b   Go to the beginning of this node.",&   "  e   Go to the end of this node.",   "",    "\"Advanced\" commands:",    "--------------------",    "  q   Quit Info.", *   "  1   Pick first item in node's menu.",5   "  2-9 Pick second ... ninth item in node's menu.", )   "  0   Pick last item in node's menu.", *   "  g   Move to node specified by name.",H   "      You may include a filename as well, as in (FILENAME)NODENAME.",@   "  s   Search through this Info file for a specified string,",E   "      and select the node in which the next occurrence is found.",    (char *)NULL };   void( dump_map_to_message_buffer (prefix, map)      char *prefix;      Keymap map; {    register int i;      for (i = 0; i < 256; i++)      {         if (map[i].type == ISKMAP) 	{ 	  char *new_prefix, *keyname;    	  keyname = pretty_keyname (i); 	  new_prefix = (char *)6 	    xmalloc (3 + strlen (prefix) + strlen (keyname));H 	  sprintf (new_prefix, "%s%s%s ", prefix, *prefix ? " " : "", keyname);  D 	  dump_map_to_message_buffer (new_prefix, (Keymap)map[i].function); 	  free (new_prefix);  	}       else if (map[i].function)  	{ 	  register int last;  	  char *doc, *name;  2 	  doc = function_documentation (map[i].function);* 	  name = function_name (map[i].function);  
 	  if (!*doc)  	    continue;  A 	  /* Find out if there is a series of identical functions, as in  	     ea_insert (). */) 	  for (last = i + 1; last < 256; last++) & 	    if ((map[last].type != ISFUNC) ||* 		(map[last].function != map[i].function))
 	      break;    	  if (last - 1 != i)  	    { 	      printf_to_message_buffer + 		("%s%s .. ", prefix, pretty_keyname (i));  	      printf_to_message_buffer 0 		("%s%s\t", prefix, pretty_keyname (last - 1)); 	      i = last - 1; 	    } 	  else E 	    printf_to_message_buffer ("%s%s\t", prefix, pretty_keyname (i));    #if defined (NAMED_FUNCTIONS) A 	  /* Print the name of the function, and some padding before the ) 	     documentation string is printed. */  	  { 	    int length_so_far; = 	    int desired_doc_start = 40;	/* Must be multiple of 8. */   - 	    printf_to_message_buffer ("(%s)", name); 8 	    length_so_far = message_buffer_length_this_line ();  A 	    if ((desired_doc_start + strlen (doc)) >= the_screen->width) , 	      printf_to_message_buffer ("\n     ");	 	    else  	      {+ 		while (length_so_far < desired_doc_start)  		  { & 		    printf_to_message_buffer ("\t");= 		    length_so_far += character_width ('\t', length_so_far);  		  }  	      } 	  } #endif /* NAMED_FUNCTIONS */* 	  printf_to_message_buffer ("%s\n", doc); 	}     }  }   , /* How to create internal_info_help_node. */ static void ! create_internal_info_help_node ()  {    register int i;      initialize_message_buffer ();   .   for (i = 0; info_internal_help_text[i]; i++)B     printf_to_message_buffer ("%s\n", info_internal_help_text[i]);  9   printf_to_message_buffer ("---------------------\n\n"); =   printf_to_message_buffer ("The current search path is:\n"); 4   printf_to_message_buffer ("  \"%s\"\n", infopath);9   printf_to_message_buffer ("---------------------\n\n"); G   printf_to_message_buffer ("Commands available in Info windows:\n\n"); /   dump_map_to_message_buffer ("", info_keymap); 9   printf_to_message_buffer ("---------------------\n\n"); H   printf_to_message_buffer ("Commands available in the echo area:\n\n");4   dump_map_to_message_buffer ("", echo_area_keymap);     {      char *message;  &     message = replace_in_documentationF       ("--- Use `\\[history-node]' or `\\[kill-node]' to exit ---\n");-     printf_to_message_buffer ("%s", message);    }   6   internal_info_help_node = message_buffer_to_node ();9   add_gcable_pointer (internal_info_help_node->contents); C   name_internal_node (internal_info_help_node, info_help_nodename);   C   /* Even though this is an internal node, we don't want the window C      system to treat it specially.  So we turn off the internalness       of it here. */ 2   internal_info_help_node->flags &= ~N_IsInternal; }   D /* Return a window which is the window showing help in this Info. */ static WINDOW * " info_find_or_create_help_window () {    WINDOW *help_window;  >   help_window = get_internal_info_window (info_help_nodename);  :   /* If we couldn't find the help window, then make it. */   if (!help_window)      { 1       WINDOW *window, *eligible = (WINDOW *)NULL;        int max = 0;  ;       for (window = windows; window; window = window->next)  	{ 	  if (window->height > max) 	    { 	      max = window->height; 	      eligible = window;  	    } 	}         if (!eligible) 	return ((WINDOW *)NULL); 
       else 	{B 	  /* Make a new node containing the help text.  Split the largestF 	     window into 2 windows, and show the help text in that window. */  	  if (!internal_info_help_node)' 	    create_internal_info_help_node ();    	  if (eligible->height > 30)  	    {  	      active_window = eligible;B 	      help_window = window_make_window (internal_info_help_node); 	    } 	  else  	    {8 	      set_remembered_pagetop_and_point (active_window);  	      window_set_node_of_window+ 		(active_window, internal_info_help_node); # 	      help_window = active_window;  	    }  = 	  remember_window_and_node (help_window, help_window->node);  	}     }    return (help_window);  }   ( /* Create or move to the help window. */C DECLARE_INFO_COMMAND (info_get_help_window, "Display help message")  {    WINDOW *help_window;  3   help_window = info_find_or_create_help_window ();    if (help_window)     { "       active_window = help_window;-       active_window->flags |= W_UpdateWindow;      }    else     { "       info_error (CANT_MAKE_HELP);     }  }   I /* Show the Info help node.  This means that the "info" file is installed 2    where it can easily be found on your system. */N DECLARE_INFO_COMMAND (info_get_info_help_node, "Visit Info node `(info)Help'") {e
   NODE *node;c   char *nodename;e  H   /* If there is a window on the screen showing the node "(info)Help" orF      the node "(info)Help-Small-Screen", simply select that window. */   {      WINDOW *win;  -     for (win = windows; win; win = win->next)b       {e( 	if (win->node && win->node->filename &&
 	    (stricmpoE 	     (filename_non_directory (win->node->filename), "info") == 0) && 4 	    ((strcmp (win->node->nodename, "Help") == 0) ||@ 	     (strcmp (win->node->nodename, "Help-Small-Screen") == 0))) 	  { 	    active_window = win;  	    return; 	  }       }i   }e  C   /* If the current window is small, show the small screen help. */ !   if (active_window->height < 24)t#     nodename = "Help-Small-Screen";F   else     nodename = "Help";  *   /* Try to get the info file for Info. */*   node = info_get_node ("Info", nodename);     if (!node)     { !       if (info_recent_file_error)*% 	info_error (info_recent_file_error); 
       else/ 	info_error (CANT_FILE_NODE, "Info", nodename);	     }/   else     {*E       /* If the current window is very large (greater than 45 lines), 9 	 then split it and show the help node in another window._' 	 Otherwise, use the current window. */d  %       if (active_window->height > 45)i+ 	active_window = window_make_window (node);n
       else 	{4 	  set_remembered_pagetop_and_point (active_window);3 	  window_set_node_of_window (active_window, node);e 	}  5       remember_window_and_node (active_window, node);      }* }* *F /* **************************************************************** */ /*								    */0 /*		     Groveling Info Keymaps and Docs		    */ /*								    */F /* **************************************************************** */  I /* Return the documentation associated with the Info command FUNCTION. */p char *! function_documentation (function)       VFunction *function;  {s   register int i;   .   for (i = 0; function_doc_array[i].func; i++)/     if (function == function_doc_array[i].func)        break;  @   return (replace_in_documentation (function_doc_array[i].doc)); }    #if defined (NAMED_FUNCTIONS)-C /* Return the user-visible name of the function associated with theS    Info command FUNCTION. */ char * function_name (function)        VFunction *function;d {    register int i;   .   for (i = 0; function_doc_array[i].func; i++)/     if (function == function_doc_array[i].func)i       break;  +   return (function_doc_array[i].func_name);e }n  2 /* Return a pointer to the function named NAME. */ VFunction *g named_function (name)e      char *name; {    register int i;f  .   for (i = 0; function_doc_array[i].func; i++)<     if (strcmp (function_doc_array[i].func_name, name) == 0)       break;  &   return (function_doc_array[i].func); }s #endif /* NAMED_FUNCTIONS */  : /* Return the documentation associated with KEY in MAP. */ char * key_documentation (key, map)      char key;      Keymap map; {;*   VFunction *function = map[key].function;     if (function)n/     return (function_documentation (function));m   else     return ((char *)NULL); }x  B DECLARE_INFO_COMMAND (describe_key, "Print documentation for KEY") {    char keyname[50];r   int keyname_index = 0;   unsigned char keystroke;   char *rep;
   Keymap map;p     keyname[0] = '\0';   map = window->keymap;      while (1).     {n9       message_in_echo_area ("Describe key: %s", keyname);d)       keystroke = info_get_input_char ();n        unmessage_in_echo_area ();  <       if (Meta_p (keystroke) && (!ISO_Latin_p || key < 160)) 	{ 	  if (map[ESC].type != ISKMAP)n 	    {" 	      window_message_in_echo_area@ 		("ESC %s is undefined.", pretty_keyname (UnMeta (keystroke))); 	      return; 	    }  , 	  strcpy (keyname + keyname_index, "ESC ");$ 	  keyname_index = strlen (keyname);" 	  keystroke = UnMeta (keystroke);# 	  map = (Keymap)map[ESC].function;) 	}  G       /* Add the printed representation of KEYSTROKE to our keyname. */ '       rep = pretty_keyname (keystroke);e,       strcpy (keyname + keyname_index, rep);'       keyname_index = strlen (keyname);i  7       if (map[keystroke].function == (VFunction *)NULL)n 	{6 	  message_in_echo_area ("%s is undefined.", keyname);
 	  return; 	}-       else if (map[keystroke].type == ISKMAP)d 	{) 	  map = (Keymap)map[keystroke].function;  	  strcat (keyname, " ");f$ 	  keyname_index = strlen (keyname); 	  continue; 	}
       else 	{) 	  char *message, *fundoc, *funname = "";l   #if defined (NAMED_FUNCTIONS) 5 	  funname = function_name (map[keystroke].function);  #endif /* NAMED_FUNCTIONS */  = 	  fundoc = function_documentation (map[keystroke].function);r   	  message = (char *)xmallocB 	    (10 + strlen (keyname) + strlen (fundoc) + strlen (funname));   #if defined (NAMED_FUNCTIONS)i? 	  sprintf (message, "%s (%s): %s.", keyname, funname, fundoc);  #elsei> 	  sprintf (message, "%s is defined to %s.", keyname, fundoc); #endif /* !NAMED_FUNCTIONS */t  / 	  window_message_in_echo_area ("%s", message);i 	  free (message);	 	  break;] 	}     }  }n  : /* How to get the pretty printable name of a character. */ static char rep_buffer[30];-   char * pretty_keyname (key)      unsigned char key;( {e   char *rep;     if (Meta_p (key))n     {e       char temp[20];  *       rep = pretty_keyname (UnMeta (key));  $       sprintf (temp, "ESC %s", rep);        strcpy (rep_buffer, temp);       rep = rep_buffer;n     }    else if (Control_p (key))"     {k       switch (key) 	{ 	case '\n': rep = "LFD"; break;- 	case '\t': rep = "TAB"; break;u 	case '\r': rep = "RET"; break;e 	case ESC:  rep = "ESC"; break;e  	 	default:(1 	  sprintf (rep_buffer, "C-%c", UnControl (key));  	  rep = rep_buffer; 	}     }n   else     {"       switch (key) 	{ 	case ' ': rep = "SPC"; break; 	case DEL: rep = "DEL"; break;	 	default:  	  rep_buffer[0] = key;e 	  rep_buffer[1] = '\0'; 	  rep = rep_buffer; 	}     }b   return (rep);n }i  D /* Replace the names of functions with the key that invokes them. */0 static char *where_is (), *where_is_internal ();   char *! replace_in_documentation (string)       char *string; {i   register int i, start, next;%   static char *result = (char *)NULL;      maybe_free (result);1   result = (char *)xmalloc (1 + strlen (string));i     i = next = start = 0;l  8   /* Skip to the beginning of a replaceable function. */!   for (i = start; string[i]; i++)n     { =       /* Is this the start of a replaceable function name? */ 4       if (string[i] == '\\' && string[i + 1] == '[') 	{ 	  char *fun_name, *rep; 	  VFunction *function;d   	  /* Copy in the old text. */6 	  strncpy (result + next, string + start, i - start); 	  next += (i - start);  	  start = i + 2;-  . 	  /* Move to the end of the function name. */9 	  for (i = start; string[i] && (string[i] != ']'); i++);i  . 	  fun_name = (char *)xmalloc (1 + i - start);1 	  strncpy (fun_name, string + start, i - start);S 	  fun_name[i - start] = '\0';  C 	  /* Find a key which invokes this function in the info_keymap. */n( 	  function = named_function (fun_name);  = 	  /* If the internal documentation string fails, there is a  B 	     serious problem with the associated command's documentation.6 	     We croak so that it can be fixed immediately. */ 	  if (!function)e 	    abort ();  * 	  rep = where_is (info_keymap, function); 	  strcpy (result + next, rep);n 	  next = strlen (result);  
 	  start = i;t 	  if (string[i])}
 	    start++;_ 	}     }n)   strcpy (result + next, string + start);    return (result); }w  E /* Return a string of characters which could be typed from the keymapM    MAP to invoke FUNCTION. */s) static char *where_is_rep = (char *)NULL;n" static int where_is_rep_index = 0;! static int where_is_rep_size = 0;p  
 static char *  where_is (map, function)      Keymap map;      VFunction *function;a {i   char *rep;     if (!where_is_rep_size)e=     where_is_rep = (char *)xmalloc (where_is_rep_size = 100);e   where_is_rep_index = 0;o  *   rep = where_is_internal (map, function);  2   /* If it couldn't be found, return "M-x Foo". */   if (!rep)p     {"       char *name;n  &       name = function_name (function);         if (name) ( 	sprintf (where_is_rep, "M-x %s", name);         rep = where_is_rep;t     }    return (rep);- }e  B /* Return the printed rep of FUNCTION as found in MAP, or NULL. */
 static char * ! where_is_internal (map, function)i      Keymap map;      VFunction *function;( {i   register int i;m   L   /* If the function is directly invokable in MAP, return the representation      of that keystroke. */   for (i = 0; i < 256; i++)o?     if ((map[i].type == ISFUNC) && map[i].function == function)w       { G 	sprintf (where_is_rep + where_is_rep_index, "%s", pretty_keyname (i));o 	return (where_is_rep);*       }(  7   /* Okay, search subsequent maps for this function. */r   for (i = 0; i < 256; i++)=     {;        if (map[i].type == ISKMAP) 	{( 	  int saved_index = where_is_rep_index;
 	  char *rep;   5 	  sprintf (where_is_rep + where_is_rep_index, "%s ",i 		   pretty_keyname (i));_  . 	  where_is_rep_index = strlen (where_is_rep);? 	  rep = where_is_internal ((Keymap)map[i].function, function);r   	  if (rep)e 	    return (where_is_rep);e  $ 	  where_is_rep_index = saved_index; 	}     }t     return ((char *)NULL); }t  # extern char *read_function_name ();i  $ DECLARE_INFO_COMMAND (info_where_is,2    "Show what to type to execute a given command") {r   char *command_name;o  C   command_name = read_function_name ("Where is command: ", window);)     if (!command_name)     {_1       info_abort_key (active_window, count, key);*
       return;*     }*     if (*command_name)     {*       VFunction *function;  /       function = named_function (command_name);/         if (function)* 	{ 	  char *location;  9 	  location = where_is (active_window->keymap, function);o   	  if (!location)d 	    {< 	      info_error ("`%s' is not on any keys", command_name); 	    } 	  elseV 	    {. 	      if (strncmp (location, "M-x ", 4) == 0) 		window_message_in_echo_areac? 		  ("%s can only be invoked via %s.", command_name, location);r 	      elseu 		window_message_in_echo_areau: 		  ("%s can be invoked via %s.", command_name, location); 	    } 	}
       else> 	info_error ("There is no function named `%s'", command_name);     }C     free (command_name); }m     