$ /* infomap.c -- Keymaps for Info. */  L /* This file is part of GNU Info, a program for reading online documentation    stored in Info format.   4    Copyright (C) 1993 Free Software Foundation, Inc.  G    This program is free software; you can redistribute it and/or modify G    it under the terms of the GNU General Public License as published by F    the Free Software Foundation; either version 2, or (at your option)    any later version.   B    This program is distributed in the hope that it will be useful,A    but WITHOUT ANY WARRANTY; without even the implied warranty of @    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/    GNU General Public License for more details.   D    You should have received a copy of the GNU General Public License>    along with this program; if not, write to the Free Software<    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  -    Written by Brian Fox (bfox@ai.mit.edu). */    #include "stdio.h" #include "ctype.h" #include "infomap.h" #include "funs.h"   H /* Return a new keymap which has all the uppercase letters mapped to run0    the function info_do_lowercase_version (). */ Keymap keymap_make_keymap ()  {    register int i;    Keymap keymap;  9   keymap = (Keymap)xmalloc (256 * sizeof (KEYMAP_ENTRY));      for (i = 0; i < 256; i++)      {        keymap[i].type = ISFUNC;-       keymap[i].function = (VFunction *)NULL;      }   #   for (i = 'A'; i < ('Z' + 1); i++)      {        keymap[i].type = ISFUNC;5       keymap[i].function = info_do_lowercase_version;      }      return (keymap); }   1 /* Return a new keymap which is a copy of MAP. */  Keymap keymap_copy_keymap (map)      Keymap map; {    register int i;    Keymap keymap;  !   keymap = keymap_make_keymap ();      for (i = 0; i < 256; i++)      { #       keymap[i].type = map[i].type; +       keymap[i].function = map[i].function;      }    return (keymap); }   + /* Free the keymap and it's descendents. */  void keymap_discard_keymap (map)       Keymap (map); {    register int i;      if (!map)      return;      for (i = 0; i < 256; i++)      {        switch (map[i].type) 	{
 	case ISFUNC: 	 	  break;   
 	case ISKMAP: 3 	  keymap_discard_keymap ((Keymap)map[i].function); 	 	  break;    	}     }  }   + /* Initialize the standard info keymaps. */   " Keymap info_keymap = (Keymap)NULL;' Keymap echo_area_keymap = (Keymap)NULL;    void initialize_info_keymaps () {    register int i; 
   Keymap map;      if (!info_keymap)      { *       info_keymap = keymap_make_keymap ();%       info_keymap[ESC].type = ISKMAP; E       info_keymap[ESC].function = (VFunction *)keymap_make_keymap (); /       info_keymap[Control ('x')].type = ISKMAP; O       info_keymap[Control ('x')].function = (VFunction *)keymap_make_keymap (); /       echo_area_keymap = keymap_make_keymap (); *       echo_area_keymap[ESC].type = ISKMAP;J       echo_area_keymap[ESC].function = (VFunction *)keymap_make_keymap ();4       echo_area_keymap[Control ('x')].type = ISKMAP;0       echo_area_keymap[Control ('x')].function =$ 	(VFunction *)keymap_make_keymap ();     }   K   /* Bind numeric arg functions for both echo area and info window maps. */ !   for (i = '0'; i < '9' + 1; i++)      { 8       ((Keymap) info_keymap[ESC].function)[i].function =8 	((Keymap) echo_area_keymap[ESC].function)[i].function =! 	  info_add_digit_to_numeric_arg;      } 6   ((Keymap) info_keymap[ESC].function)['-'].function ==     ((Keymap) echo_area_keymap[ESC].function)['-'].function = $       info_add_digit_to_numeric_arg;  $   /* Bind the echo area routines. */   map = echo_area_keymap;   +   /* Bind the echo area insert routines. */    for (i = 0; i < 160; i++)      if (isprint (i))"       map[i].function = ea_insert;  /   map[Control ('a')].function = ea_beg_of_line; ,   map[Control ('b')].function = ea_backward;*   map[Control ('d')].function = ea_delete;/   map[Control ('e')].function = ea_end_of_line; +   map[Control ('f')].function = ea_forward; )   map[Control ('g')].function = ea_abort; *   map[Control ('h')].function = ea_rubout;-   map[Control ('k')].function = ea_kill_line; 4   map[Control ('l')].function = info_redraw_display;1   map[Control ('q')].function = ea_quoted_insert; 3   map[Control ('t')].function = ea_transpose_chars; 8   map[Control ('u')].function = info_universal_argument;(   map[Control ('y')].function = ea_yank;  !   map[LFD].function = ea_newline; !   map[RET].function = ea_newline; "   map[SPC].function = ea_complete;"   map[TAB].function = ea_complete;.   map['?'].function = ea_possible_completions;    map[DEL].function = ea_rubout;  &   /* Bind the echo area ESC keymap. *//   map = (Keymap)echo_area_keymap[ESC].function;   )   map[Control ('g')].function = ea_abort; =   map[Control ('v')].function = ea_scroll_completions_window; '   map['b'].function = ea_backward_word; #   map['d'].function = ea_kill_word; &   map['f'].function = ea_forward_word; #if defined (NAMED_FUNCTIONS) 1   /* map['x'].function = info_execute_command; */  #endif /* NAMED_FUNCTIONS */"   map['y'].function = ea_yank_pop;.   map['?'].function = ea_possible_completions;$   map[TAB].function = ea_tab_insert;,   map[DEL].function = ea_backward_kill_word;  ,   /* Bind the echo area Control-x keymap. */9   map = (Keymap)echo_area_keymap[Control ('x')].function;   '   map['o'].function = info_next_window; ,   map[DEL].function = ea_backward_kill_line;  .   /* Bind commands for Info window keymaps. */   map = info_keymap;-   map[TAB].function = info_move_to_next_xref; 6   map[LFD].function = info_select_reference_this_line;6   map[RET].function = info_select_reference_this_line;*   map[SPC].function = info_scroll_forward;7   map[Control ('a')].function = info_beginning_of_line; 3   map[Control ('b')].function = info_backward_char; 1   map[Control ('e')].function = info_end_of_line; 2   map[Control ('f')].function = info_forward_char;/   map[Control ('g')].function = info_abort_key; 5   map[Control ('h')].function = info_get_help_window; 4   map[Control ('l')].function = info_redraw_display;/   map[Control ('n')].function = info_next_line; /   map[Control ('p')].function = info_prev_line; 1   map[Control ('r')].function = isearch_backward; 0   map[Control ('s')].function = isearch_forward;8   map[Control ('u')].function = info_universal_argument;4   map[Control ('v')].function = info_scroll_forward;,   map[','].function = info_next_index_match;  !   for (i = '1'; i < '9' + 1; i++) &     map[i].function = info_menu_digit;*   map['0'].function = info_last_menu_item;  &   map['<'].function = info_first_node;%   map['>'].function = info_last_node; +   map['?'].function = info_get_help_window; ,   map['['].function = info_global_prev_node;,   map[']'].function = info_global_next_node;  -   map['b'].function = info_beginning_of_node; $   map['d'].function = info_dir_node;'   map['e'].function = info_end_of_node; %   map['f'].function = info_xref_item; %   map['g'].function = info_goto_node; .   map['h'].function = info_get_info_help_node;(   map['i'].function = info_index_search;(   map['l'].function = info_history_node;%   map['m'].function = info_menu_item; %   map['n'].function = info_next_node; %   map['p'].function = info_prev_node;     map['q'].function = info_quit;%   map['r'].function = info_xref_item; "   map['s'].function = info_search;$   map['t'].function = info_top_node;#   map['u'].function = info_up_node; +   map[DEL].function = info_scroll_backward;   5   /* Bind members in the ESC map for Info windows. */ *   map = (Keymap)info_keymap[ESC].function;4   map[Control ('f')].function = info_show_footnotes;/   map[Control ('g')].function = info_abort_key; -   map[TAB].function = info_move_to_prev_xref; 9   map[Control ('v')].function = info_scroll_other_window; -   map['<'].function = info_beginning_of_node; '   map['>'].function = info_end_of_node; )   map['b'].function = info_backward_word; (   map['f'].function = info_forward_word;/   map['r'].function = info_move_to_window_line; +   map['v'].function = info_scroll_backward;  #if defined (NAMED_FUNCTIONS) +   map['x'].function = info_execute_command;  #endif /* NAMED_FUNCTIONS */  ;   /* Bind members in the Control-X map for Info windows. */o4   map = (Keymap)info_keymap[Control ('x')].function;  3   map[Control ('b')].function = list_visited_nodes;r*   map[Control ('c')].function = info_quit;/   map[Control ('f')].function = info_view_file;//   map[Control ('g')].function = info_abort_key;r/   map[Control ('v')].function = info_view_file;o)   map['0'].function = info_delete_window; +   map['1'].function = info_keep_one_window;i(   map['2'].function = info_split_window;'   map['^'].function = info_grow_window;R*   map['b'].function = select_visited_node;%   map['k'].function = info_kill_node;A'   map['o'].function = info_next_window;l(   map['t'].function = info_tile_windows;'   map['w'].function = info_toggle_wrap;  }e     