8 /* session.c -- The user windowing interface to Info. */  L /* This file is part of GNU Info, a program for reading online documentation    stored in Info format.   4    Copyright (C) 1993 Free Software Foundation, Inc.  G    This program is free software; you can redistribute it and/or modify G    it under the terms of the GNU General Public License as published by F    the Free Software Foundation; either version 2, or (at your option)    any later version.   B    This program is distributed in the hope that it will be useful,A    but WITHOUT ANY WARRANTY; without even the implied warranty of @    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/    GNU General Public License for more details.   D    You should have received a copy of the GNU General Public License>    along with this program; if not, write to the Free Software<    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  -    Written by Brian Fox (bfox@ai.mit.edu). */    #include "info.h"  #include <sys/file.h>  #include <sys/ioctl.h> #include <fcntl.h>   #if defined (HAVE_SYS_TIME_H)  #  include <sys/time.h>  #  define HAVE_STRUCT_TIMEVAL  #endif /* HAVE_SYS_TIME_H */  C static void info_clear_pending_input (), info_set_pending_input (); # static void info_handle_pointer ();   F /* **************************************************************** */ /*								    */) /*		     Running an Info Session			    */  /*								    */F /* **************************************************************** */  / /* The place that we are reading input from. */ . static FILE *info_input_stream = (FILE *)NULL;    /* The last executed command. */: VFunction *info_last_executed_command = (VFunction *)NULL;  ; /* Becomes non-zero when 'q' is typed to an Info window. */  int quit_info_immediately = 0;  G /* Array of structures describing for each window which nodes have been     visited in that window. */ 2 INFO_WINDOW **info_windows = (INFO_WINDOW **)NULL;  : /* Where to add the next window, if we need to add one. */" static int info_windows_index = 0;  0 /* Number of slots allocated to INFO_WINDOWS. */" static int info_windows_slots = 0;  = void remember_window_and_node (), forget_window_and_nodes (); 1 void initialize_info_session (), info_session (); * void display_startup_message_and_start ();  O /* Begin an info session finding the nodes specified by FILENAME and NODENAMES. N    For each loaded node, create a new window.  Always split the largest of the    available windows. */ void8 begin_multiple_window_info_session (filename, nodenames)      char *filename;      char **nodenames; {    register int i; "   WINDOW *window = (WINDOW *)NULL;      for (i = 0; nodenames[i]; i++)     {        NODE *node;   4       node = info_get_node (filename, nodenames[i]);         if (!node) 	break;   C       /* If this is the first node, initialize the info session. */        if (!window) 	{" 	  initialize_info_session (node); 	  window = active_window; 	}
       else 	{E 	  /* Find the largest window in WINDOWS, and make that be the active A 	     one.  Then split it and add our window and node to the list A 	     of remembered windows and nodes.  Then tile the windows. */ 3 	  register WINDOW *win, *largest = (WINDOW *)NULL;  	  int max_height = 0;  , 	  for (win = windows; win; win = win->next)" 	    if (win->height > max_height) 	      { 		max_height = win->height;  		largest = win; 	      }   	  if (!largest) 	    {( 	      display_update_display (windows);# 	      info_error (CANT_FIND_WIND);  	      info_session ();  	      exit (0); 	    }   	  active_window = largest; & 	  window = window_make_window (node); 	  if (window) 	    {, 	      window_tile_windows (TILE_INTERNALS);/ 	      remember_window_and_node (window, node);  	    } 	  else  	    {( 	      display_update_display (windows);" 	      info_error (WIN_TOO_SMALL); 	      info_session ();  	      exit (0); 	    } 	}     } '   display_startup_message_and_start ();  }   L /* Start an info session with INITIAL_NODE, and an error message in the echo$    area made from FORMAT and ARG. */ void9 begin_info_session_with_error (initial_node, format, arg)       NODE *initial_node;      char *format;      void *arg;  { )   initialize_info_session (initial_node); )   info_error (format, arg, (void *)NULL);    info_session (); }   . /* Start an info session with INITIAL_NODE. */ void! begin_info_session (initial_node)       NODE *initial_node; { )   initialize_info_session (initial_node); '   display_startup_message_and_start ();  }    void$ display_startup_message_and_start () {    char *format;   #   format = replace_in_documentation L     ("Welcome to Info version %s.  Type \"\\[get-help-window]\" for help.");  :   window_message_in_echo_area (format, version_string ());   info_session (); }   F /* Run an info session with an already initialized window and node. */ void info_session ()  {    terminal_prep_terminal ();#   display_update_display (windows); 1   info_last_executed_command = (VFunction *)NULL;    info_read_and_dispatch ();   terminal_unprep_terminal ();   close_dribble_file (); }   C /* Here is a window-location dependent event loop.  Called from the C    functions info_session (), and from read_xxx_in_echo_area (). */  void info_read_and_dispatch ()  {    unsigned char key;   int done;    done = 0;   )   while (!done && !quit_info_immediately)      { 
       int lk;   ?       /* If we haven't just gone up or down a line, there is no ! 	 goal column for this window. */ ;       if ((info_last_executed_command != info_next_line) && 2 	  (info_last_executed_command != info_prev_line))! 	active_window->goal_column = -1;          if (echo_area_is_active) 	{( 	  lk = echo_area_last_command_was_kill; 	  echo_area_prep_read (); 	}  (       if (!info_any_buffered_input_p ())" 	display_update_display (windows);  .       display_cursor_at_point (active_window);%       info_initialize_numeric_arg ();          initialize_keyseq (); #       key = info_get_input_char ();   J       /* No errors yet.  We just read a character, that's all.  Only clear1 	 the echo_area if it is not currently active. */        if (!echo_area_is_active)  	window_clear_echo_area ();   !       info_error_was_printed = 0;   $       /* Do the selected command. */8       info_dispatch_on_key (key, active_window->keymap);         if (echo_area_is_active) 	{? 	  /* Echo area commands that do killing increment the value of < 	     ECHO_AREA_LAST_COMMAND_WAS_KILL.  Thus, if there is no< 	     change in the value of this variable, the last command) 	     executed was not a kill command. */ - 	  if (lk == echo_area_last_command_was_kill) ) 	    echo_area_last_command_was_kill = 0;   0 	  if (ea_last_executed_command == ea_newline || 	      info_aborted_echo_area) 	    {4 	      ea_last_executed_command = (VFunction *)NULL; 	      done = 1; 	    }  / 	  if (info_last_executed_command == info_quit)  	    quit_info_immediately = 1;  	}7       else if (info_last_executed_command == info_quit) 
 	done = 1;     }  }    /* Found in signals.c */. extern void initialize_info_signal_handler ();  F /* Initialize the first info session by starting the terminal, window,    and display systems. */ void initialize_info_session (node)      NODE *node; {    char *getenv (), *term_name;     term_name = getenv ("TERM");+   terminal_initialize_terminal (term_name);      if (terminal_is_dumb_p)      {        if (!term_name)  	term_name = "dumb";  ,       info_error (TERM_TOO_DUMB, term_name);       exit (1);      }    terminal_clear_screen ();    initialize_info_keymaps (); 8   window_initialize_windows (screenwidth, screenheight);$   initialize_info_signal_handler ();9   display_initialize_display (screenwidth, screenheight); 0   info_set_node_of_window (active_window, node);  F   /* Tell the window system how to notify us when a window needs to beF      asynchronously deleted (e.g., user resizes window very small). */5   window_deletion_notifier = forget_window_and_nodes;   F   /* If input has not been redirected yet, make it come from STDIN. */   if (!info_input_stream)s     info_input_stream = stdin;  !   info_windows_initialized_p = 1;i }a  < /* Tell Info that input is coming from the file FILENAME. */ void# info_set_input_from_file (filename)1      char *filename; {i   FILE *stream;i  !   stream = fopen (filename, "r");e     if (!stream)     return;   !   if (info_input_stream != stdin)l     fclose (info_input_stream);      info_input_stream = stream;e     if (stream != stdin)     display_inhibited = 1; }n  K /* Return the INFO_WINDOW containing WINDOW, or NULL if there isn't one. */t static INFO_WINDOW *" get_info_window_of_window (window)      WINDOW *window; {    register int i;C.   INFO_WINDOW *info_win = (INFO_WINDOW *)NULL;  @   for (i = 0; info_windows && (info_win = info_windows[i]); i++)#     if (info_win->window == window)g       break;     return (info_win); }F  G /* Reset the remembered pagetop and point of WINDOW to WINDOW's current F    values if the window and node are the same as the current one being    displayed. */ void) set_remembered_pagetop_and_point (window)       WINDOW *window; {I   INFO_WINDOW *info_win;  0   info_win = get_info_window_of_window (window);     if (!info_win)     return;n     if (info_win->nodes_index &&;       (info_win->nodes[info_win->current] == window->node))      {*>       info_win->pagetops[info_win->current] = window->pagetop;:       info_win->points[info_win->current] = window->point;     }	 }	   void' remember_window_and_node (window, node)*      WINDOW *window;      NODE *node; {e   INFO_WINDOW *info_win;  7   /* See if we already have this window in our list. */ 0   info_win = get_info_window_of_window (window);  H   /* If the window wasn't already on our list, then make a new entry. */   if (!info_win)     {o?       info_win = (INFO_WINDOW *)xmalloc (sizeof (INFO_WINDOW));d        info_win->window = window;&       info_win->nodes = (NODE **)NULL;'       info_win->pagetops = (int *)NULL;O&       info_win->points = (long *)NULL;       info_win->current = 0;        info_win->nodes_index = 0;        info_win->nodes_slots = 0;  G       add_pointer_to_array (info_win, info_windows_index, info_windows,m. 			    info_windows_slots, 10, INFO_WINDOW *);     }   E   /* If this node, the current pagetop, and the current point are themF      same as the last saved node and pagetop, don't really add this to"      the list of history nodes. */   {e'     int ni = info_win->nodes_index - 1;w       if ((ni != -1) &&t5 	(info_win->nodes[ni]->contents == node->contents) &&o/ 	(info_win->pagetops[ni] == window->pagetop) &&f) 	(info_win->points[ni] == window->point))i     return;    }D  I   /* Remember this node, the currently displayed pagetop, and the current H      location of point in this window.  Because we are updating pagetopsC      and points as well as nodes, it is more efficient to avoid thet(      add_pointer_to_array macro here. */9   if (info_win->nodes_index + 2 >= info_win->nodes_slots)      {w!       info_win->nodes = (NODE **)i 	xrealloc (info_win->nodes,O5 		  (info_win->nodes_slots += 20) * sizeof (NODE *));t  "       info_win->pagetops = (int *)E 	xrealloc (info_win->pagetops, info_win->nodes_slots * sizeof (int));*  !       info_win->points = (long *) D 	xrealloc (info_win->points, info_win->nodes_slots * sizeof (long));     }   0   info_win->nodes[info_win->nodes_index] = node;>   info_win->pagetops[info_win->nodes_index] = window->pagetop;:   info_win->points[info_win->nodes_index] = window->point;.   info_win->current = info_win->nodes_index++;8   info_win->nodes[info_win->nodes_index] = (NODE *)NULL;0   info_win->pagetops[info_win->nodes_index] = 0;.   info_win->points[info_win->nodes_index] = 0; }n  % #define DEBUG_FORGET_WINDOW_AND_NODES + #if defined (DEBUG_FORGET_WINDOW_AND_NODES)  static void ! consistency_check_info_windows ()p {    register int i;i   INFO_WINDOW *info_win;  *   for (i = 0; i < info_windows_index; i++)     {        WINDOW *win;  /       for (win = windows; win; win = win->next) $ 	if (win == info_windows[i]->window)	 	  break;a         if (!win)a
 	abort ();     }T }d* #endif /* DEBUG_FORGET_WINDOW_AND_NODES */  G /* Remove WINDOW and its associated list of nodes from INFO_WINDOWS. */; void  forget_window_and_nodes (window)      WINDOW *window; {    register int i;m.   INFO_WINDOW *info_win = (INFO_WINDOW *)NULL;  @   for (i = 0; info_windows && (info_win = info_windows[i]); i++)#     if (info_win->window == window)i       break;  5   /* If we found the window to forget, then do so. */_   if (info_win)n     { $       while (i < info_windows_index)% 	info_windows[i] = info_windows[++i];          info_windows_index--;t=       info_windows[info_windows_index] = (INFO_WINDOW *)NULL;i         if (info_win->nodes) 	{' 	  for (i = 0; info_win->nodes[i]; i++)n3 	    if (internal_info_node_p (info_win->nodes[i]))i! 	      free (info_win->nodes[i]);o 	  free (info_win->nodes);  # 	  maybe_free (info_win->pagetops);l! 	  maybe_free (info_win->points);d 	}         free (info_win);     }=+ #if defined (DEBUG_FORGET_WINDOW_AND_NODES)h$   consistency_check_info_windows ();* #endif /* DEBUG_FORGET_WINDOW_AND_NODES */ }n  H /* Set WINDOW to show NODE.  Remember the new window in our list of InfoL    windows.  If we are doing automatic footnote display, also try to display$    the footnotes for this window. */ void& info_set_node_of_window (window, node)      WINDOW *window;      NODE *node; { &   /* Put this node into the window. */+   window_set_node_of_window (window, node);   B   /* Remember this node and window in our list of info windows. */*   remember_window_and_node (window, node);  K   /* If doing auto-footnote display/undisplay, show the footnotes belonginga      to this window's node. */   if (auto_footnotes_p)e*     info_get_or_remove_footnotes (window); }n   fF /* **************************************************************** */ /*								    */* /*		       Info Movement Commands			    */ /*								    */F /* **************************************************************** */  L /* Change the pagetop of WINDOW to DESIRED_TOP, perhaps scrolling the screen    to do so. */c void( set_window_pagetop (window, desired_top)      WINDOW *window;      int desired_top;  {o   int point_line, old_pagetop;     if (desired_top < 0)     desired_top = 0;,   else if (desired_top > window->line_count))     desired_top = window->line_count - 1;c  %   if (window->pagetop == desired_top)t     return;       old_pagetop = window->pagetop;    window->pagetop = desired_top;  4   /* Make sure that point appears in this window. */-   point_line = window_line_of_point (window);i'   if ((point_line < window->pagetop) || <       ((point_line - window->pagetop) > window->height - 1))     window->point =eD       window->line_starts[window->pagetop] - window->node->contents;  "   window->flags |= W_UpdateWindow;  F   /* Find out which direction to scroll, and scroll the window in thatF      direction.  Do this only if there would be a savings in redisplayH      time.  This is true if the amount to scroll is less than the heightH      of the window, and if the number of lines scrolled would be greater)      than 10 % of the window's height. */,    if (old_pagetop < desired_top)     {d       int start, end, amount;)  )       amount = desired_top - old_pagetop;e  '       if ((amount >= window->height) || 7 	  (((window->height - amount) * 10) < window->height))m 	return;  )       start = amount + window->first_row;_/       end = window->height + window->first_row;,  3       display_scroll_display (start, end, -amount);r     }    else     {i       int start, end, amount;i  )       amount = old_pagetop - desired_top;;  '       if ((amount >= window->height) ||i7 	  (((window->height - amount) * 10) < window->height))  	return;          start = window->first_row;:       end = (window->first_row + window->height) - amount;2       display_scroll_display (start, end, amount);     }i }   E /* Immediately make WINDOW->point visible on the screen, and move thed    terminal cursor there. */ static voide info_show_point (window)      WINDOW *window; {u   int old_pagetop;      old_pagetop = window->pagetop;!   window_adjust_pagetop (window);T%   if (old_pagetop != window->pagetop)f     {E       int new_pagetop;  $       new_pagetop = window->pagetop;$       window->pagetop = old_pagetop;/       set_window_pagetop (window, new_pagetop);)     }e  %   if (window->flags & W_UpdateWindow)n'     display_update_one_window (window);   #   display_cursor_at_point (window);t }m  ? /* Move WINDOW->point from OLD line index to NEW line index. */N static voidg# move_to_new_line (old, new, window)*      int old, new;      WINDOW *window; {w   if (old == -1)     {O#       info_error (CANT_FIND_POINT);      }N   else     {        int goal;L  /       if (new >= window->line_count || new < 0)o 	return;  -       goal = window_get_goal_column (window); !       window->goal_column = goal;   H       window->point = window->line_starts[new] - window->node->contents;M       window->point += window_chars_to_goal (window->line_starts[new], goal);d       info_show_point (window);d     }p }d  < /* Move WINDOW's point down to the next line if possible. */C DECLARE_INFO_COMMAND (info_next_line, "Move down to the next line")f {i   int old_line, new_line;n     if (count < 0))     info_prev_line (window, -count, key);t   else     {d/       old_line = window_line_of_point (window);c"       new_line = old_line + count;4       move_to_new_line (old_line, new_line, window);     }	 }   > /* Move WINDOW's point up to the previous line if possible. */E DECLARE_INFO_COMMAND (info_prev_line, "Move up to the previous line")r {y   int old_line, new_line;s     if (count < 0))     info_next_line (window, -count, key);*   else     {w/       old_line = window_line_of_point (window); "       new_line = old_line - count;4       move_to_new_line (old_line, new_line, window);     }  }   6 /* Move WINDOW's point to the end of the true line. */F DECLARE_INFO_COMMAND (info_end_of_line, "Move to the end of the line") {=   register int point, len;   register char *buffer;  "   buffer = window->node->contents;   len = window->node->nodelen;     for (point = window->point;o0        (point < len) && (buffer[point] != '\n');        point++);     if (point != window->point)s     {t       window->point = point;       info_show_point (window);s     }s }a  < /* Move WINDOW's point to the beginning of the true line. */N DECLARE_INFO_COMMAND (info_beginning_of_line, "Move to the start of the line") {=   register int point;o   register char *buffer;  "   buffer = window->node->contents;   point = window->point;  :   for (; (point) && (buffer[point - 1] != '\n'); point--);  .   /* If at a line start alreay, do nothing. */   if (point != window->point)      {c       window->point = point;       info_show_point (window);s     }a }p  % /* Move point forward in the node. */eD DECLARE_INFO_COMMAND (info_forward_char, "Move forward a character") {n   if (count < 0)-     info_backward_char (window, -count, key);w   else     {D       window->point += count;d  1       if (window->point >= window->node->nodelen)E+ 	window->point = window->node->nodelen - 1;          info_show_point (window);_     }d }s  & /* Move point backward in the node. */F DECLARE_INFO_COMMAND (info_backward_char, "Move backward a character") {z   if (count < 0),     info_forward_char (window, -count, key);   else     {o       window->point -= count;i         if (window->point < 0) 	window->point = 0;-         info_show_point (window);n     }> }r  A #define alphabetic(c) (islower (c) || isupper (c) || isdigit (c))e  ' /* Move forward a word in this node. */f? DECLARE_INFO_COMMAND (info_forward_word, "Move forward a word")x { 
   long point;n   char *buffer;N
   int end, c;      if (count < 0)     {I/       info_backward_word (window, -count, key);_
       return;p     }      point = window->point;"   buffer = window->node->contents;   end = window->node->nodelen;     while (count);     {        if (point + 1 >= end)n 	return;  C       /* If we are not in a word, move forward until we are in one.n@ 	 Then, move forward until we hit a non-alphabetic character. */       c = buffer[point];         if (!alphabetic (c)) 	{ 	  while (++point < end) 	    { 	      c = buffer[point];  	      if (alphabetic (c)) 		break; 	    } 	}         if (point >= end) return;*         while (++point < end)n 	{ 	  c = buffer[point];n 	  if (!alphabetic (c))n 	    break;w 	}       --count;     }    window->point = point;   info_show_point (window);_ }   A DECLARE_INFO_COMMAND (info_backward_word, "Move backward a word")i {w
   long point;d   char *buffer;    int c;     if (count < 0)     {w.       info_forward_word (window, -count, key);
       return;(     }n  "   buffer = window->node->contents;   point = window->point;     while (count)_     {_       if (point == 0)  	break;f  >       /* Like info_forward_word (), except that we look at the" 	 characters just before point. */         c = buffer[point - 1];         if (!alphabetic (c)) 	{ 	  while (--point) 	    { 	      c = buffer[point - 1];_ 	      if (alphabetic (c)) 		break; 	    } 	}         while (point)t 	{ 	  c = buffer[point - 1];  	  if (!alphabetic (c))t 	    break;w 	  elseI
 	    --point;a 	}       --count;     }a   window->point = point;   info_show_point (window);/ }o  L /* Here is a list of time counter names which correspond to ordinal numbers.0    It is used to print "once" instead of "1". */  static char *counter_names[] = {@   "not at all", "once", "twice", "three", "four", "five", "six",   (char *)NULL };  = /* Buffer used to return values from times_description (). */t static char td_buffer[50];  H /* Function returns a static string fully describing the number of times    present in COUNT. */o
 static char *i times_description (count)*      int count;* {*   register int i;*     td_buffer[0] = '\0';  $   for (i = 0; counter_names[i]; i++)     if (count == i)	       break;     if (counter_names[i])*M     sprintf (td_buffer, "%s%s", counter_names[i], count > 2 ? " times" : "");D   else+     sprintf (td_buffer, "%d times", count);.     return (td_buffer);g }p  G /* Variable controlling the behaviour of default scrolling when you are N    already at the bottom of a node.  Possible values are defined in session.h.    The meanings are:  A    IS_Continuous	Try to get first menu item, or failing that, the 2 			"Next:" pointer, or failing that, the "Up:" and 			"Next:" of the up.w-    IS_NextOnly		Try to get "Next:" menu item. :    IS_PageOnly		Simply give up at the bottom of a node. */  * int info_scroll_behaviour = IS_Continuous;  J /* Choices used by the completer when reading a value for the user-visible"    variable "scroll-behaviour". */ char *info_scroll_choices[] = {[6   "Continuous", "Next Only", "Page Only", (char *)NULL };  D /* Move to 1st menu item, Next, Up/Next, or error in this window. */ static voidw/ forward_move_node_structure (window, behaviour)w      WINDOW *window;      int behaviour;  {s   switch (behaviour)     {o     case IS_PageOnly:g"       info_error (AT_NODE_BOTTOM);       break;       case IS_NextOnly:r-       info_next_label_of_node (window->node); 9       if (!info_parsed_nodename && !info_parsed_filename)d3 	info_error ("No \"Next\" pointer for this node.");p
       else 	{> 	  window_message_in_echo_area ("Following \"Next\" node...");( 	  info_handle_pointer ("Next", window); 	}       break;       case IS_Continuous:        {d@ 	/* First things first.  If this node contains a menu, move down 	   into the menu. */  	{ 	  REFERENCE **menu;  + 	  menu = info_menu_of_node (window->node);o   	  if (menu) 	    {# 	      info_free_references (menu);iD 	      window_message_in_echo_area ("Selecting first menu item...");( 	      info_menu_digit (window, 1, '1'); 	      return; 	    } 	}  > 	/* Okay, this node does not contain a menu.  If it contains a! 	   "Next:" pointer, use that. */*( 	info_next_label_of_node (window->node); 	if (info_label_was_found) 	  {@ 	    window_message_in_echo_area ("Selecting \"Next\" node...");* 	    info_handle_pointer ("Next", window); 	    return; 	  }  D 	/* Okay, there wasn't a "Next:" for this node.  Move "Up:" until weB 	   can move "Next:".  If that isn't possible, complain that there 	   are no more nodes. */  	{ 	  int up_counter, old_current;  	  INFO_WINDOW *info_win;w  0 	  /* Remember the current node and location. */1 	  info_win = get_info_window_of_window (window);o# 	  old_current = info_win->current;n  F 	  /* Back up through the "Up:" pointers until we have found a "Next:"G 	     that isn't the same as the first menu item found in that node. */e 	  up_counter = 0;" 	  while (!info_error_was_printed) 	    {, 	      info_up_label_of_node (window->node);  	      if (info_label_was_found) 		{e' 		  info_handle_pointer ("Up", window);t 		  if (info_error_was_printed)o 		    continue;)   		  up_counter++;l  + 		  info_next_label_of_node (window->node);w  0 		  /* If no "Next" pointer, keep backing up. */ 		  if (!info_label_was_found) 		    continue;n  @ 		  /* If this node's first menu item is the same as this node's( 		     Next pointer, keep backing up. */ 		  if (!info_parsed_filename) 		    {A 		      REFERENCE **menu;o 		      char *next_nodename;  < 		      /* Remember the name of the Next node, since reading. 			 the menu can overwrite the contents of the 			 info_parsed_xxx strings. */w: 		      next_nodename = savestring (info_parsed_nodename);  0 		      menu = info_menu_of_node (window->node); 		      if (menu &&i 			  (strcmp/ 			   (menu[0]->nodename, next_nodename) == 0))D 			{! 			  info_free_references (menu);s 			  free (next_nodename); 			  continue; 			} 		      else 			{0 			  /* Restore the world to where it was before% 			     reading the menu contents. */ ! 			  info_free_references (menu);n 			  free (next_nodename);, 			  info_next_label_of_node (window->node); 			} 		    }I  8 		  /* This node has a "Next" pointer, and it is not the9 		     same as the first menu item found in this node. */= 		  window_message_in_echo_areae* 		    ("Moving \"Up\" %s, then \"Next\".",' 		     times_description (up_counter));e  ) 		  info_handle_pointer ("Next", window);  		  return;) 		}b 	      else! 		{': 		  /* No more "Up" pointers.  Print an error, and call it 		     quits. */ 		  register int i;   $ 		  for (i = 0; i < up_counter; i++) 		    {   		      info_win->nodes_index--;6 		      free (info_win->nodes[info_win->nodes_index]);> 		      info_win->nodes[info_win->nodes_index] = (NODE *)NULL; 		    } $ 		  info_win->current = old_current;0 		  window->node = info_win->nodes[old_current];6 		  window->pagetop = info_win->pagetops[old_current];2 		  window->point = info_win->points[old_current];% 		  recalculate_line_starts (window); $ 		  window->flags |= W_UpdateWindow;" 		  info_error ("No more nodes."); 		}  	    } 	} 	break;r       }n     }e }E  > /* Move Prev, Up or error in WINDOW depending on BEHAVIOUR. */ static voido0 backward_move_node_structure (window, behaviour)      WINDOW *window;      int behaviour;  {c   switch (behaviour)     {o     case IS_PageOnly:d       info_error (AT_NODE_TOP);n       break;       case IS_NextOnly:o-       info_prev_label_of_node (window->node);k9       if (!info_parsed_nodename && !info_parsed_filename)h+ 	info_error ("No \"Prev\" for this node.");o
       else 	{C 	  window_message_in_echo_area ("Moving \"Prev\" in this window.");>( 	  info_handle_pointer ("Prev", window); 	}       break;       case IS_Continuous:o-       info_prev_label_of_node (window->node);b  9       if (!info_parsed_nodename && !info_parsed_filename)v 	{( 	  info_up_label_of_node (window->node);6 	  if (!info_parsed_nodename && !info_parsed_filename)9 	    info_error ("No \"Prev\" or \"Up\" for this node.");f 	  else  	    {E 	      window_message_in_echo_area ("Moving \"Up\" in this window."); * 	      info_handle_pointer ("Up", window); 	    } 	}
       else 	{ 	  REFERENCE **menu;# 	  int inhibit_menu_traversing = 0;   A 	  /* Watch out!  If this node's Prev is the same as the Up, thenoC 	     move Up.  Otherwise, we could move Prev, and then to the last ? 	     menu item in the Prev.  This would cause the user to loop / 	     through a subsection of the info file. */ 5 	  if (!info_parsed_filename && info_parsed_nodename)p 	    { 	      char *pnode;}  1 	      pnode = savestring (info_parsed_nodename);l, 	      info_up_label_of_node (window->node);  ; 	      if (!info_parsed_filename && info_parsed_nodename && . 		  strcmp (info_parsed_nodename, pnode) == 0) 		{n: 		  /* The nodes are the same.  Inhibit moving to the last 		     menu item. */ 		  free (pnode);   		  inhibit_menu_traversing = 1; 		}n 	      elsew 		{  		  free (pnode); + 		  info_prev_label_of_node (window->node);n 		}  	    }  C 	  /* Move to the previous node.  If this node now contains a menu, @ 	     and we have not inhibited movement to it, move to the node- 	     corresponding to the last menu item. */rC 	  window_message_in_echo_area ("Moving \"Prev\" in this window."); ( 	  info_handle_pointer ("Prev", window);    	  if (!inhibit_menu_traversing) 	    {( 	      while (!info_error_was_printed &&1 		     (menu = info_menu_of_node (window->node)))o 		{   		  info_free_references (menu); 		  window_message_in_echo_areat/ 		    ("Moving to \"Prev\"'s last menu item."); % 		  info_menu_digit (window, 1, '0');o 		}* 	    } 	}       break;     }a }   M /* Move continuously forward through the node structure of this info file. */", DECLARE_INFO_COMMAND (info_global_next_node,7 		      "Move forwards or down through node structure"), {    if (count < 0)0     info_global_prev_node (window, -count, key);   else     { .       while (count && !info_error_was_printed) 	{7 	  forward_move_node_structure (window, IS_Continuous);e 	  count--;. 	}     }c }a  N /* Move continuously backward through the node structure of this info file. */, DECLARE_INFO_COMMAND (info_global_prev_node,6 		      "Move backwards or up through node structure") {o   if (count < 0)0     info_global_next_node (window, -count, key);   else     {i.       while (count && !info_error_was_printed) 	{8 	  backward_move_node_structure (window, IS_Continuous); 	  count--;  	}     }u }f  , /* Show the next screen of WINDOW's node. */K DECLARE_INFO_COMMAND (info_scroll_forward, "Scroll forward in this window")i {    if (count < 0)/     info_scroll_backward (window, -count, key);t   else     {t       int desired_top;  D       /* Without an explicit numeric argument, scroll the bottom two? 	 lines to the top of this window,  Or, if at bottom of window,oA 	 and the user wishes to scroll through nodes get the "Next" nodeo 	 for this window. */t+       if (!info_explicit_arg && count == 1)  	{8 	  desired_top = window->pagetop + (window->height - 2);  > 	  /* If there are no more lines to scroll here, error, or get: 	     another node, depending on INFO_SCROLL_BEHAVIOUR. */( 	  if (desired_top > window->line_count) 	    {- 	      int behaviour = info_scroll_behaviour;;  C 	      /* Here is a hack.  If the key being used is not SPC, do thea 		 PageOnly behaviour. */($ 	      if (key != SPC && key != DEL) 		behaviour = IS_PageOnly;  7 	      forward_move_node_structure (window, behaviour);s 	      return; 	    } 	}
       else' 	desired_top = window->pagetop + count;s  ,       if (desired_top >= window->line_count)& 	desired_top = window->line_count - 2;  (       if (window->pagetop > desired_top) 	return;
       else* 	set_window_pagetop (window, desired_top);     }s }r  0 /* Show the previous screen of WINDOW's node. */M DECLARE_INFO_COMMAND (info_scroll_backward, "Scroll backward in this window")o {n   if (count < 0).     info_scroll_forward (window, -count, key);   else     {o       int desired_top;  G       /* Without an explicit numeric argument, scroll the top two lines A 	 to the bottom of this window, or move to the previous, or Up'tha
 	 node. */+       if (!info_explicit_arg && count == 1)* 	{8 	  desired_top = window->pagetop - (window->height - 2);  3 	  if ((desired_top < 0) && (window->pagetop == 0))l 	    {- 	      int behaviour = info_scroll_behaviour;N  B 	      /* Same kind of hack as in info_scroll_forward.  If the key? 		 used to invoke this command is not DEL, do only the PageOnlyh 		 behaviour. */$ 	      if (key != DEL && key != SPC) 		behaviour = IS_PageOnly;  8 	      backward_move_node_structure (window, behaviour); 	      return; 	    } 	}
       else' 	desired_top = window->pagetop - count;          if (desired_top < 0) 	desired_top = 0;   /       set_window_pagetop (window, desired_top);      }u }a  ( /* Move to the beginning of the node. */O DECLARE_INFO_COMMAND (info_beginning_of_node, "Move to the start of this node")_ {_&   window->pagetop = window->point = 0;"   window->flags |= W_UpdateWindow; }_  " /* Move to the end of the node. */G DECLARE_INFO_COMMAND (info_end_of_node, "Move to the end of this node")n {),   window->point = window->node->nodelen - 1;   info_show_point (window);	 }*  F /* **************************************************************** */ /*								    */0 /*		   Commands for Manipulating Windows		    */ /*								    */F /* **************************************************************** */  = /* Make the next window in the chain be the active window. */mA DECLARE_INFO_COMMAND (info_next_window, "Select the next window")  {    if (count < 0)     {e-       info_prev_window (window, -count, key);*
       return;t     }m  &   /* If no other window, error now. */-   if (!windows->next && !echo_area_is_active);     {        info_error (ONE_WINDOW);
       return;o     }      while (count--)D     {        if (window->next)  	window = window->next;_
       else 	{7 	  if (window == the_echo_area || !echo_area_is_active)  	    window = windows; 	  else  	    window = the_echo_area; 	}     }i     if (active_window != window)     {n       if (auto_footnotes_p)t' 	info_get_or_remove_footnotes (window);   &       window->flags |= W_UpdateWindow;       active_window = window;s     }t }f  A /* Make the previous window in the chain be the active window. */eE DECLARE_INFO_COMMAND (info_prev_window, "Select the previous window")n {p   if (count < 0)     {h-       info_next_window (window, -count, key); 
       return;s     }'     /* Only one window? */  -   if (!windows->next && !echo_area_is_active)/     {e       info_error (ONE_WINDOW);
       return;r     }      while (count--)o     {oL       /* If we are in the echo area, or if the echo area isn't active and we@ 	 are in the first window, find the last window in the chain. */$       if (window == the_echo_area ||/ 	  (window == windows && !echo_area_is_active))  	{ 	  register WINDOW *win, *last;o  , 	  for (win = windows; win; win = win->next) 	    last = win;   	  window = last;i 	}
       else 	{ 	  if (window == windows)d 	    window = the_echo_area; 	  elsed 	    window = window->prev;e 	}     }      if (active_window != window)     {o       if (auto_footnotes_p)V' 	info_get_or_remove_footnotes (window);e  &       window->flags |= W_UpdateWindow;       active_window = window;      }  }t  D /* Split WINDOW into two windows, both showing the same node.  If we@    are automatically tiling windows, re-tile after the split. */D DECLARE_INFO_COMMAND (info_split_window, "Split the current window") {p   WINDOW *split, *old_active;"   int pagetop;  K   /* Remember the current pagetop of the window being split.  If it doesn't"B      change, we can scroll its contents around after the split. */   pagetop = window->pagetop;     /* Make the new window. */   old_active = active_window;    active_window = window;m,   split = window_make_window (window->node);   active_window = old_active;   
   if (!split)_     {e!       info_error (WIN_TOO_SMALL);f     }    else     {r! #if defined (SPLIT_BEFORE_ACTIVE) >       /* Try to scroll the old window into its new postion. */%       if (pagetop == window->pagetop)i 	{ 	  int start, end, amount;   	  start = split->first_row;  	  end = start + window->height; 	  amount = split->height + 1;/ 	  display_scroll_display (start, end, amount);  	}  #else /* !SPLIT_BEFORE_ACTIVE */?       /* Make sure point still appears in the active window. */s       info_show_point (window); ! #endif /* !SPLIT_BEFORE_ACTIVE */o  J       /* If the window just split was one internal to Info, try to display 	 something else in it. */-       if (internal_info_node_p (split->node))  	{ 	  register int i, j;( 	  INFO_WINDOW *iw;  	  NODE *node = (NODE *)NULL;  	  char *filename;  ) 	  for (i = 0; iw = info_windows[i]; i++)) 	    {, 	      for (j = 0; j < iw->nodes_index; j++)+ 		if (!internal_info_node_p (iw->nodes[j]))  		  {n 		    if (iw->nodes[j]->parent)n( 		      filename = iw->nodes[j]->parent;
 		    else* 		      filename = iw->nodes[j]->filename;  > 		    node = info_get_node (filename, iw->nodes[j]->nodename); 		    if (node)u	 		      {n+ 			window_set_node_of_window (split, node);t 			i = info_windows_index - 1;	 			break; 	 		      }* 		  }w 	    } 	}'       split->pagetop = window->pagetop;w         if (auto_tiling_p)+ 	window_tile_windows (DONT_TILE_INTERNALS);e
       else 	window_adjust_pagetop (split);r  4       remember_window_and_node (split, split->node);     }o })  G /* Delete WINDOW, forgetting the list of last visited nodes.  If we aretC    automatically displaying footnotes, show or remove the footnotesiE    window.  If we are automatically tiling windows, re-tile after theM    deletion. */fF DECLARE_INFO_COMMAND (info_delete_window, "Delete the current window") {A   if (!windows->next)d     { "       info_error (CANT_KILL_LAST);     }u*   else if (window->flags & W_WindowIsPerm)     {v6       info_error ("Cannot delete a permanent window");     }t   else     {_+       info_delete_window_internal (window);u         if (auto_footnotes_p) . 	info_get_or_remove_footnotes (active_window);         if (auto_tiling_p)+ 	window_tile_windows (DONT_TILE_INTERNALS);O     }D }n  A /* Do the physical deletion of WINDOW, and forget this window andc    associated nodes. */  void$ info_delete_window_internal (window)      WINDOW *window; { ?   if (windows->next && ((window->flags & W_WindowIsPerm) == 0))o     {_J       /* We not only delete the window from the display, we forget it from$ 	 our list of remembered windows. */'       forget_window_and_nodes (window);,$       window_delete_window (window);         if (echo_area_is_active)- 	echo_area_inform_of_deleted_window (window);      }  }n  , /* Just keep WINDOW, deleting all others. */G DECLARE_INFO_COMMAND (info_keep_one_window, "Delete all other windows"), {r;   int num_deleted;		/* The number of windows we deleted. */h   int pagetop, start, end;  I   /* Remember a few things about this window.  We may be able to speed up{2      redisplay later by scrolling its contents. */   pagetop = window->pagetop;   start = window->first_row;   end = start + window->height;      num_deleted = 0;     while (1)/     {        WINDOW *win;  G       /* Find an eligible window and delete it.  If no eligible windows ? 	 are found, we are done.  A window is eligible for deletion ifa/ 	 is it not permanent, and it is not WINDOW. */P/       for (win = windows; win; win = win->next) ; 	if (win != window && ((win->flags & W_WindowIsPerm) == 0)) 	 	  break;          if (!win)e 	break;d  (       info_delete_window_internal (win);       num_deleted++;     }_  H   /* Scroll the contents of this window into the right place so that theJ      user doesn't have to wait any longer than necessary for redisplay. */   if (num_deleted)     {        int amount;   +       amount = (window->first_row - start);o,       amount -= (window->pagetop - pagetop);2       display_scroll_display (start, end, amount);     }o  "   window->flags |= W_UpdateWindow; }n  * /* Scroll the "other" window of WINDOW. */J DECLARE_INFO_COMMAND (info_scroll_other_window, "Scroll the other window") {r   WINDOW *other;  $   /* If only one window, give up. */   if (!windows->next)n     {*       info_error (ONE_WINDOW);
       return;w     }t     other = window->next;o  
   if (!other)-     other = window->prev;   *   info_scroll_forward (other, count, key); }   * /* Change the size of WINDOW by AMOUNT. */G DECLARE_INFO_COMMAND (info_grow_window, "Grow (or shrink) this window")e {g.   window_change_window_height (window, count); }k  I /* When non-zero, tiling takes place automatically when info_split_window     is called. */ int auto_tiling_p = 0;  & /* Tile all of the visible windows. */( DECLARE_INFO_COMMAND (info_tile_windows,B     "Divide the available screen space among the visible windows") {_'   window_tile_windows (TILE_INTERNALS);n }g  : /* Toggle the state of this window's wrapping of lines. */' DECLARE_INFO_COMMAND (info_toggle_wrap, A 	      "Toggle the state of line wrapping in the current window")W {o   window_toggle_wrap (window); }  eF /* **************************************************************** */ /*								    */  /*			Info Node Commands			    */ /*								    */F /* **************************************************************** */  I /* Using WINDOW for various defaults, select the node referenced by ENTRYWJ    in it.  If the node is selected, the window and node are remembered. */ void% info_select_reference (window, entry)e      WINDOW *window;      REFERENCE *entry; { 
   NODE *node;M0   char *filename, *nodename, *file_system_error;  #   file_system_error = (char *)NULL;n     filename = entry->filename;e   if (!filename)$     filename = window->node->parent;   if (!filename)&     filename = window->node->filename;     if (filename) %     filename = savestring (filename);o     if (entry->nodename),     nodename = savestring (entry->nodename);   else"     nodename = savestring ("Top");  ,   node = info_get_node (filename, nodename);  J   /* Try something a little weird.  If the node couldn't be found, and theL      reference was of the form "foo::", see if the entry->label can be found(      as a file, with a node of "Top". */   if (!node)     {U!       if (info_recent_file_error) 9 	file_system_error = savestring (info_recent_file_error);c  K       if (entry->nodename && (strcmp (entry->nodename, entry->label) == 0))  	{. 	  node = info_get_node (entry->label, "Top");' 	  if (!node && info_recent_file_error)  	    {& 	      maybe_free (file_system_error);? 	      file_system_error = savestring (info_recent_file_error);  	    } 	}     }r     if (!node)     {e       if (file_system_error)  	info_error (file_system_error);
       else' 	info_error (CANT_FIND_NODE, nodename);n     }   !   maybe_free (file_system_error);t   maybe_free (filename);   maybe_free (nodename);     if (node)(     {=0       set_remembered_pagetop_and_point (window);-       info_set_node_of_window (window, node);w     }  }   M /* Parse the node specification in LINE using WINDOW to default the filename.wI    Select the parsed node in WINDOW and remember it, or error if the nodei    couldn't be found. */ static voide$ info_parse_and_select (line, window)      char *line;      WINDOW *window; {t   REFERENCE entry;  -   info_parse_node (line, DONT_SKIP_NEWLINES);i  (   entry.nodename = info_parsed_nodename;(   entry.filename = info_parsed_filename;*   entry.label = "*info-parse-and-select*";  )   info_select_reference (window, &entry);L }_  I /* Given that the values of INFO_PARSED_FILENAME and INFO_PARSED_NODENAMEpF    are previously filled, try to get the node represented by them intoH    WINDOW.  The node should have been pointed to by the LABEL pointer of    WINDOW->node. */r static void/# info_handle_pointer (label, window)*      char *label;w      WINDOW *window; {v3   if (info_parsed_filename || info_parsed_nodename)d     {_        char *filename, *nodename;       NODE *node;   )       filename = nodename = (char *)NULL;(         if (info_parsed_filename) . 	filename = savestring (info_parsed_filename);
       else 	{ 	  if (window->node->parent)2 	    filename = savestring (window->node->parent);# 	  else if (window->node->filename)s4 	    filename = savestring (window->node->filename); 	}         if (info_parsed_nodename) . 	nodename = savestring (info_parsed_nodename);
       else 	nodename = savestring ("Top");*  0       node = info_get_node (filename, nodename);         if (node)o 	{ 	  INFO_WINDOW *info_win;S  1 	  info_win = get_info_window_of_window (window);  	  if (info_win) 	    {? 	      info_win->pagetops[info_win->current] = window->pagetop;n; 	      info_win->points[info_win->current] = window->point;  	    }- 	  set_remembered_pagetop_and_point (window);c* 	  info_set_node_of_window (window, node); 	}
       else 	{ 	  if (info_recent_file_error)) 	    info_error (info_recent_file_error);d 	  elsen5 	    info_error (CANT_FILE_NODE, filename, nodename);	 	}         free (filename);       free (nodename);     }i   else     {d%       info_error (NO_POINTER, label);e     }( }e  C /* Make WINDOW display the "Next:" node of the node currently being_    displayed. */? DECLARE_INFO_COMMAND (info_next_node, "Select the `Next' node")  { )   info_next_label_of_node (window->node);p'   info_handle_pointer ("Next", window);l }_  C /* Make WINDOW display the "Prev:" node of the node currently beingd    displayed. */? DECLARE_INFO_COMMAND (info_prev_node, "Select the `Prev' node")  { )   info_prev_label_of_node (window->node); '   info_handle_pointer ("Prev", window);t }t  A /* Make WINDOW display the "Up:" node of the node currently being.    displayed. */; DECLARE_INFO_COMMAND (info_up_node, "Select the `Up' node")  {L'   info_up_label_of_node (window->node);l%   info_handle_pointer ("Up", window);n }s  : /* Make WINDOW display the last node of this info file. */J DECLARE_INFO_COMMAND (info_last_node, "Select the last node in this file") {e   register int i;n3   FILE_BUFFER *fb = file_buffer_of_window (window);d   NODE *node = (NODE *)NULL;     if (fb && fb->tags)      {e$       for (i = 0; fb->tags[i]; i++);E       node = info_get_node (fb->filename, fb->tags[i - 1]->nodename);)     }      if (!node)7     info_error ("This window has no additional nodes");n   else     {e0       set_remembered_pagetop_and_point (window);-       info_set_node_of_window (window, node);-     }& }w  ; /* Make WINDOW display the first node of this info file. */ L DECLARE_INFO_COMMAND (info_first_node, "Select the first node in this file") {r3   FILE_BUFFER *fb = file_buffer_of_window (window);)   NODE *node = (NODE *)NULL;     if (fb && fb->tags)c?     node = info_get_node (fb->filename, fb->tags[0]->nodename);      if (!node)7     info_error ("This window has no additional nodes");O   else     {k0       set_remembered_pagetop_and_point (window);-       info_set_node_of_window (window, node);      }. }h  E /* Make WINDOW display the previous node displayed in this window. */d( DECLARE_INFO_COMMAND (info_history_node,1 		      "Select the most recently selected node")o {    INFO_WINDOW *info_win;  3   /* Find the INFO_WINDOW which contains WINDOW. */ 0   info_win = get_info_window_of_window (window);     if (!info_win)     {F6       info_error ("Requested window is not present!");
       return;o     }   ,   set_remembered_pagetop_and_point (window);   if (!info_win->current)d     {n$       if (info_win->nodes_index > 1) 	{ 	  window_message_in_echo_area5 	    ("Now wrapped around to beginning of history."); - 	  info_win->current = info_win->nodes_index;  	}
       else 	{3 	  info_error ("No earlier nodes in this window.");S
 	  return; 	}     }h     info_win->current--;I   window_set_node_of_window (window, info_win->nodes[info_win->current]);f:   window->pagetop = info_win->pagetops[info_win->current];8   window->point   = info_win->points[info_win->current];"   window->flags |= W_UpdateWindow;   if (auto_footnotes_p)l*     info_get_or_remove_footnotes (window); }d  0 /* Select the last menu item in WINDOW->node. */* DECLARE_INFO_COMMAND (info_last_menu_item,.    "Select the last item in this node's menu") {i#   info_menu_digit (window, 1, '0');I }n  D /* Use KEY (a digit) to select the Nth menu item in WINDOW->node. */? DECLARE_INFO_COMMAND (info_menu_digit, "Select this menu item")e {o   register int i, item;t$   register REFERENCE *entry, **menu;  *   menu = info_menu_of_node (window->node);     if (!menu)     {M        info_error (NO_MENU_NODE);
       return;      }o  B   /* We have the menu.  See if there are this many items in it. */   item = key - '0';   >   /* Special case.  Item "0" is the last item in this menu. */   if (item == 0)"     for (i = 0; menu[i + 1]; i++);   else     {b'       for (i = 0; entry = menu[i]; i++)o 	if (i == item - 1)D	 	  break;v     }      if (menu[i]),     info_select_reference (window, menu[i]);   else=     info_error ("There aren't %d items in this menu.", item);p     info_free_references (menu);	   return;t }l  D /* Read a menu or followed reference from the user defaulting to theB    reference found on the current line, and select that node.  TheA    reading is done with completion.  BUILDER is the function used B    to build the list of references.  ASK_P is non-zero if the user=    should be prompted, or zero to select the default item. */* static void : info_menu_or_ref_item (window, count, key, builder, ask_p)      WINDOW *window;      int count;       unsigned char key;b      REFERENCE **(*builder) ();e      int ask_p;y { :   REFERENCE **menu, *entry, *defentry = (REFERENCE *)NULL;
   char *line;i  #   menu = (*builder) (window->node);      if (!menu)     { '       if (builder == info_menu_of_node)e 	info_error (NO_MENU_NODE); 
       else 	info_error (NO_XREF_NODE);f
       return;i     }=  H   /* Default the selected reference to the one which is on the line that      point is in.  */-   {n*     REFERENCE **refs = (REFERENCE **)NULL;     int point_line;o  /     point_line = window_line_of_point (window);o       if (point_line != -1)        {m 	SEARCH_BINDING binding;   	binding.start = 0;o2 	binding.buffer = window->line_starts[point_line];) 	if (window->line_starts[point_line + 1]) F 	  binding.end = window->line_starts[point_line + 1] - binding.buffer; 	elsen 	  binding.end =G 	    (window->node->contents + window->node->nodelen) - binding.buffer;r 	binding.flags = 0;p  " 	if (builder == info_menu_of_node) 	  { 	    if (point_line) 	      { 		binding.buffer--;i 		binding.end++;  $ 		refs = info_menu_items (&binding); 	      } 	  } 	elser  	  refs = info_xrefs (&binding);  
 	if (refs) 	  {2 	    if ((strcmp (refs[0]->label, "Menu") != 0) ||" 		(builder == info_xrefs_of_node)) 	      {7 		defentry = (REFERENCE *)xmalloc (sizeof (REFERENCE));I0 		defentry->label = savestring (refs[0]->label);) 		defentry->filename = refs[0]->filename; ) 		defentry->nodename = refs[0]->nodename;    		if (defentry->filename)g9 		  defentry->filename = savestring (defentry->filename);n 		if (defentry->nodename) 9 		  defentry->nodename = savestring (defentry->nodename);a 	      }! 	    info_free_references (refs);  	  }       }e   }r  >   /* If we are going to ask the user a question, do it now. */   if (ask_p)     {c       char *prompt;   $       /* Build the prompt string. */       if (defentry) : 	prompt = (char *)xmalloc (20 + strlen (defentry->label));
       else 	prompt = (char *)xmalloc (20);a  '       if (builder == info_menu_of_node)  	{ 	  if (defentry); 	    sprintf (prompt, "Menu item (%s): ", defentry->label);G 	  else % 	    sprintf (prompt, "Menu item: ");I 	}
       else 	{ 	  if (defentry)= 	    sprintf (prompt, "Follow xref (%s): ", defentry->label);O 	  elseo' 	    sprintf (prompt, "Follow xref: ");E 	}  F       line = info_read_completing_in_echo_area (window, prompt, menu);       free (prompt);         window = active_window;   #       /* User aborts, just quit. */e       if (!line) 	{ 	  maybe_free (defentry);n 	  info_free_references (menu); ! 	  info_abort_key (window, 0, 0);(
 	  return; 	}  C       /* If we had a default and the user accepted it, use that. */        if (!*line)  	{ 	  free (line);) 	  if (defentry)) 	    line = savestring (defentry->label);  	  elsew 	    line = (char *)NULL;l 	}     }e   else     {>I       /* Not going to ask any questions.  If we have a default entry, uset 	 that, otherwise return. */       if (!defentry) 	return;
       else% 	line = savestring (defentry->label);e     }a     if (line)f     {o6       /* Find the selected label in the references. */6       entry = info_get_labeled_reference (line, menu);         if (!entry && defentry)w7 	info_error ("The reference disappeared! (%s).", line);[
       else 	{ 	  NODE *orig;   	  orig = window->node;e) 	  info_select_reference (window, entry);eA 	  if ((builder == info_xrefs_of_node) && (window->node != orig))e 	    { 	      long offset;r 	      long start;  " 	      if (window->line_count > 0): 		start = window->line_starts[1] - window->node->contents; 	      else  		start = 0;   	      offset =e> 		info_target_search_node (window->node, entry->label, start);   	      if (offset != -1) 		{" 		  window->point = offset;e# 		  window_adjust_pagetop (window);C 		}D 	    } 	}         free (line);       if (defentry)o 	{ 	  free (defentry->label);# 	  maybe_free (defentry->filename);w# 	  maybe_free (defentry->nodename);y 	  free (defentry);t 	}     }r     info_free_references (menu);     if (!info_error_was_printed)     window_clear_echo_area (); }   B /* Read a line (with completion) which is the name of a menu item,    and select that item. */IM DECLARE_INFO_COMMAND (info_menu_item, "Read a menu item and select its node")L {_C   info_menu_or_ref_item (window, count, key, info_menu_of_node, 1);a }_  D /* Read a line (with completion) which is the name of a reference to"    follow, and select the node. */ DECLARE_INFO_COMMANDL   (info_xref_item, "Read a footnote or cross reference and select its node") { D   info_menu_or_ref_item (window, count, key, info_xrefs_of_node, 1); }   ; /* Position the cursor at the start of this node's menu. */ N DECLARE_INFO_COMMAND (info_find_menu, "Move to the start of this node's menu") {>   SEARCH_BINDING binding;    long position;  *   binding.buffer = window->node->contents;   binding.start  = 0; &   binding.end = window->node->nodelen;*   binding.flags = S_FoldCase | S_SkipDest;  0   position = search (INFO_MENU_LABEL, &binding);     if (position == -1)t     info_error (NO_MENU_NODE);   else     {f       window->point = position; %       window_adjust_pagetop (window); &       window->flags |= W_UpdateWindow;     }= }O  I /* Visit as many menu items as is possible, each in a separate window. */ & DECLARE_INFO_COMMAND (info_visit_menu,1   "Visit as many menu items at once as possible")d {)   register int i;    REFERENCE *entry, **menu;a  *   menu = info_menu_of_node (window->node);     if (!menu)     info_error (NO_MENU_NODE);  B   for (i = 0; (!info_error_was_printed) && (entry = menu[i]); i++)     {A       WINDOW *new;  .       new = window_make_window (window->node);+       window_tile_windows (TILE_INTERNALS);n         if (!new)h 	info_error (WIN_TOO_SMALL);
       else 	{ 	  active_window = new;w& 	  info_select_reference (new, entry); 	}     }R }e  E /* Read a line of input which is a node name, and go to that node. */dG DECLARE_INFO_COMMAND (info_goto_node, "Read a node name and select it")f {n
   char *line;n
   NODE *node;    #define GOTO_COMPLETES #if defined (GOTO_COMPLETES):   /* Build a completion list of all of the known nodes. */   {d     register int fbi, i;     FILE_BUFFER *current;r+     REFERENCE **items = (REFERENCE **)NULL;}     int items_index = 0;     int items_slots = 0;  -     current = file_buffer_of_window (window);r  E     for (fbi = 0; info_loaded_files && info_loaded_files[fbi]; fbi++)i       {n 	FILE_BUFFER *fb;n 	REFERENCE *entry; 	int this_is_the_current_fb;   	fb = info_loaded_files[fbi];l* 	this_is_the_current_fb = (current == fb);  3 	entry = (REFERENCE *)xmalloc (sizeof (REFERENCE));/2 	entry->filename = entry->nodename = (char *)NULL;< 	entry->label = (char *)xmalloc (4 + strlen (fb->filename));/ 	sprintf (entry->label, "(%s)*", fb->filename);t   	add_pointer_to_arraym= 	  (entry, items_index, items, items_slots, 10, REFERENCE *);e   	if (fb->tags) 	  {" 	    for (i = 0; fb->tags[i]; i++) 	      {4 		entry = (REFERENCE *)xmalloc (sizeof (REFERENCE));3 		entry->filename = entry->nodename = (char *)NULL;r! 		entry->label = (char *) xmalloc A 		  (4 + strlen (fb->filename) + strlen (fb->tags[i]->nodename)); " 		sprintf (entry->label, "(%s)%s",) 			 fb->filename, fb->tags[i]->nodename);n   		add_pointer_to_array? 		  (entry, items_index, items, items_slots, 100, REFERENCE *); 
 	      }		    	    if (this_is_the_current_fb) 	      { 		for (i = 0; fb->tags[i]; i++)i 		  { 8 		    entry = (REFERENCE *)xmalloc (sizeof (REFERENCE));7 		    entry->filename = entry->nodename = (char *)NULL; 8 		    entry->label = savestring (fb->tags[i]->nodename);6 		    add_pointer_to_array (entry, items_index, items,& 					  items_slots, 100, REFERENCE *); 		  }n 	      } 	  }       } E     line = info_read_maybe_completing (window, "Goto Node: ", items);t!     info_free_references (items);K   }  #else /* !GOTO_COMPLETES */l8   line = info_read_in_echo_area (window, "Goto Node: "); #endif /* !GOTO_COMPLETES */  &   /* If the user aborted, quit now. */   if (!line)     { $       info_abort_key (window, 0, 0);
       return;R     }(  !   canonicalize_whitespace (line);      if (*line))     info_parse_and_select (line, window);      free (line);   if (!info_error_was_printed)     window_clear_echo_area (); }   * /* Move to the "Top" node in this file. */J DECLARE_INFO_COMMAND (info_top_node, "Select the node `Top' in this file") { (   info_parse_and_select ("Top", window); }o  " /* Move to the node "(dir)Top". */? DECLARE_INFO_COMMAND (info_dir_node, "Select the node `(dir)'")N {;-   info_parse_and_select ("(dir)Top", window);o }i  L /* Try to delete the current node appearing in this window, showing the most,    recently selected node in this window. */7 DECLARE_INFO_COMMAND (info_kill_node, "Kill this node")_ {r   register int iw, i; !   register INFO_WINDOW *info_win;p    char *nodename = (char *)NULL;   NODE *temp = (NODE *)NULL;  H   /* Read the name of a node to kill.  The list of available nodes comesE      from the nodes appearing in the current window configuration. */i   {n*     REFERENCE **menu = (REFERENCE **)NULL;'     int menu_index = 0, menu_slots = 0;n$     char *default_nodename, *prompt;  3     for (iw = 0; info_win = info_windows[iw]; iw++)        {( 	REFERENCE *entry;  3 	entry = (REFERENCE *)xmalloc (sizeof (REFERENCE)); > 	entry->label = savestring (info_win->window->node->nodename);2 	entry->filename = entry->nodename = (char *)NULL;   	add_pointer_to_array]: 	  (entry, menu_index, menu, menu_slots, 10, REFERENCE *);       }e  B     default_nodename = savestring (active_window->node->nodename);>     prompt = (char *)xmalloc (40 + strlen (default_nodename));;     sprintf (prompt, "Kill node (%s): ", default_nodename);r  H     nodename = info_read_completing_in_echo_area (window, prompt, menu);     free (prompt);      info_free_references (menu);     if (nodename && !*nodename)d       {p 	free (nodename);  	nodename = default_nodename;        }      else       free (default_nodename);   }p  2   /* If there is no nodename to kill, quit now. */   if (!nodename)     { $       info_abort_key (window, 0, 0);
       return;s     }e  ;   /* If there is a nodename, find it in our window list. */)1   for (iw = 0; info_win = info_windows[iw]; iw++)nM     if (strcmp (nodename, info_win->nodes[info_win->current]->nodename) == 0)r       break;     if (!info_win)     {e       if (*nodename)4 	info_error ("Cannot kill the node `%s'", nodename);
       else 	window_clear_echo_area ();   
       return;b     }u  L   /* If there are no more nodes left anywhere to view, complain and exit. */C   if (info_windows_index == 1 && info_windows[0]->nodes_index == 1)      { /       info_error ("Cannot kill the last node");u
       return;      }(  D   /* INFO_WIN contains the node that the user wants to stop viewing.E      Delete this node from the list of nodes previously shown in this       window. */ =   for (i = info_win->current; i < info_win->nodes_index; i++)t.     info_win->nodes[i] = info_win->nodes[i++];  =   /* There is one less node in this window's history list. */>   info_win->nodes_index--;  ;   /* Make this window show the most recent history node. */s0   info_win->current = info_win->nodes_index - 1;  F   /* If there aren't any nodes left in this window, steal one from the      next window. */   if (info_win->current < 0)     {;       INFO_WINDOW *stealer;        int which, pagetop;i       long point;i         if (info_windows[iw + 1])&  	stealer = info_windows[iw + 1];
       else 	stealer = info_windows[0];;  G       /* If the node being displayed in the next window is not the mostw; 	 recently loaded one, get the most recently loaded one. */o9       if ((stealer->nodes_index - 1) != stealer->current)a" 	which = stealer->nodes_index - 1;  I       /* Else, if there is another node behind the stealers current node,C 	 use that one. */$       else if (stealer->current > 0) 	which = stealer->current - 1;  B       /* Else, just use the node appearing in STEALER's window. */
       else 	which = stealer->current;         /* Copy this node. */(       {  	NODE *copy;   	temp = stealer->nodes[which];  	point = stealer->points[which];$ 	pagetop = stealer->pagetops[which];  ( 	copy = (NODE *)xmalloc (sizeof (NODE));! 	copy->filename = temp->filename;_ 	copy->parent = temp->parent;e! 	copy->nodename = temp->nodename;r! 	copy->contents = temp->contents;e 	copy->nodelen = temp->nodelen;  	copy->flags = temp->flags;i  
 	temp = copy;e       }o  9       window_set_node_of_window (info_win->window, temp);        window->point = point;        window->pagetop = pagetop;8       remember_window_and_node (info_win->window, temp);     }_   else     {10       temp = info_win->nodes[info_win->current];9       window_set_node_of_window (info_win->window, temp);      }o   if (!info_error_was_printed)     window_clear_echo_area (); }   9 /* Read the name of a file and select the entire file. */ N DECLARE_INFO_COMMAND (info_view_file, "Read the name of a file and select it") {_
   char *line;i  8   line = info_read_in_echo_area (window, "Find file: ");   if (!line)     {1+       info_abort_key (active_window, 1, 0); 
       return;d     }n     if (*line)     {i       NODE *node;   '       node = info_get_node (line, "*");W       if (!node) 	{ 	  if (info_recent_file_error)) 	    info_error (info_recent_file_error);  	  elseN. 	    info_error ("Cannot find \"%s\".", line); 	}
       else 	{4 	  set_remembered_pagetop_and_point (active_window);* 	  info_set_node_of_window (window, node); 	}       free (line);     }      if (!info_error_was_printed)     window_clear_echo_area (); }t  F /* **************************************************************** */ /*								    */* /*		   Dumping and Printing Nodes			    */ /*								    */F /* **************************************************************** */   #define VERBOSE_NODE_DUMPING$ static void write_node_to_stream ();# static void dump_node_to_stream (); " static void initialize_dumping ();  G /* Dump the nodes specified by FILENAME and NODENAMES to the file named"F    in OUTPUT_FILENAME.  If DUMP_SUBNODES is non-zero, recursively dump=    the nodes which appear in the menu of each node dumped. */t voidH dump_nodes_to_file (filename, nodenames, output_filename, dump_subnodes)      char *filename;      char **nodenames;      char *output_filename;       int dump_subnodes;  {u   register int i;_   FILE *output_stream;  E   /* Get the stream to print the nodes to.  Special case of an output :      filename of "-" means to dump the nodes to stdout. */)   if (strcmp (output_filename, "-") == 0)[     output_stream = stdout;f   else1     output_stream = fopen (output_filename, "w");o     if (!output_stream)>     {eK       info_error ("Could not create output file \"%s\".", output_filename);e
       return;)     }r  "   /* Print each node to stream. */   initialize_dumping ();    for (i = 0; nodenames[i]; i++)O     dump_node_to_stream (filename, nodenames[i], output_stream, dump_subnodes);-     if (output_stream != stdout)     fclose (output_stream);f  " #if defined (VERBOSE_NODE_DUMPING)   info_error ("Done.");U! #endif /* VERBOSE_NODE_DUMPING */l }   / /* A place to remember already dumped nodes. */[- static char **dumped_already = (char **)NULL;)$ static int dumped_already_index = 0;$ static int dumped_already_slots = 0;   static voidm initialize_dumping ()l {,   dumped_already_index = 0;} }   G /* Get and print the node specified by FILENAME and NODENAME to STREAM.+H    If DUMP_SUBNODES is non-zero, recursively dump the nodes which appear&    in the menu of each node dumped. */ static void ? dump_node_to_stream (filename, nodename, stream, dump_subnodes)d      char *filename, *nodename;i      FILE *stream;      int dump_subnodes;N {*   register int i;}
   NODE *node;   ,   node = info_get_node (filename, nodename);     if (!node)     {t!       if (info_recent_file_error)K% 	info_error (info_recent_file_error); 
       else 	{$ 	  if (filename && *nodename != '(') 	    info_error_E 	      (CANT_FILE_NODE, filename_non_directory (filename), nodename);  	  else + 	    info_error (CANT_FIND_NODE, nodename);n 	}
       return;o     }e  A   /* If we have already dumped this node, don't dump it again. */,,   for (i = 0; i < dumped_already_index; i++)8     if (strcmp (node->nodename, dumped_already[i]) == 0)       {e
 	free (node);t 	return;       }RM   add_pointer_to_array (node->nodename, dumped_already_index, dumped_already,o% 			dumped_already_slots, 50, char *);   " #if defined (VERBOSE_NODE_DUMPING)K   /* Maybe we should print some information about the node being output. */p   if (node->filename)T-     info_error ("Writing node \"(%s)%s\"...",e; 		filename_non_directory (node->filename), node->nodename);l   else:     info_error ("Writing node \"%s\"...", node->nodename);! #endif /* VERBOSE_NODE_DUMPING */i  &   write_node_to_stream (node, stream);  I   /* If we are dumping subnodes, get the list of menu items in this node, &      and dump each one recursively. */   if (dump_subnodes)     {m,       REFERENCE **menu = (REFERENCE **)NULL;  F       /* If this node is an Index, do not dump the menu references. */9       if (string_in_line ("Index", node->nodename) == -1)e! 	menu = info_menu_of_node (node);          if (menu)  	{ 	  for (i = 0; menu[i]; i++) 	    {? 	      /* We don't dump Info files which are different than the) 		 current one. */ 	      if (!menu[i]->filename) 		dump_node_to_stream>9 		  (filename, menu[i]->nodename, stream, dump_subnodes);t 	    } 	  info_free_references (menu);n 	}     },     free (node); }   I /* Dump NODE to FILENAME.  If DUMP_SUBNODES is non-zero, recursively dump =    the nodes which appear in the menu of each node dumped. */  void1 dump_node_to_file (node, filename, dump_subnodes)       NODE *node;      char *filename;      int dump_subnodes;t {e   FILE *output_stream;   char *nodes_filename;s  E   /* Get the stream to print this node to.  Special case of an output :      filename of "-" means to dump the nodes to stdout. */"   if (strcmp (filename, "-") == 0)     output_stream = stdout;i   else*     output_stream = fopen (filename, "w");     if (!output_stream)0     { D       info_error ("Could not create output file \"%s\".", filename);
       return;      }      if (node->parent)n"     nodes_filename = node->parent;   else$     nodes_filename = node->filename;     initialize_dumping ();   dump_node_to_stream C     (nodes_filename, node->nodename, output_stream, dump_subnodes);      if (output_stream != stdout)     fclose (output_stream);e  " #if defined (VERBOSE_NODE_DUMPING)   info_error ("Done."); ! #endif /* VERBOSE_NODE_DUMPING */f }n  ) #if !defined (DEFAULT_INFO_PRINT_COMMAND)e* #  define DEFAULT_INFO_PRINT_COMMAND "lpr"( #endif /* !DEFAULT_INFO_PRINT_COMMAND */  & DECLARE_INFO_COMMAND (info_print_node,=  "Pipe the contents of this node through INFO_PRINT_COMMAND")  {m   print_node (window->node); }w  @ /* Print NODE on a printer piping it into INFO_PRINT_COMMAND. */ void print_node (node)       NODE *node; {]"   char *print_command, *getenv ();   FILE *printer_pipe;t  0   print_command = getenv ("INFO_PRINT_COMMAND");  (   if (!print_command || !*print_command)/     print_command = DEFAULT_INFO_PRINT_COMMAND;   ,   printer_pipe = popen (print_command, "w");     if (!printer_pipe)     {w@       info_error ("Cannot open pipe to \"%s\".", print_command);
       return;      }N  " #if defined (VERBOSE_NODE_DUMPING)K   /* Maybe we should print some information about the node being output. */=   if (node->filename) .     info_error ("Printing node \"(%s)%s\"...",; 		filename_non_directory (node->filename), node->nodename);e   else;     info_error ("Printing node \"%s\"...", node->nodename); ! #endif /* VERBOSE_NODE_DUMPING */)  ,   write_node_to_stream (node, printer_pipe);   pclose (printer_pipe);  " #if defined (VERBOSE_NODE_DUMPING)   info_error ("Done."); ! #endif /* VERBOSE_NODE_DUMPING */s }l   static void)# write_node_to_stream (node, stream)       NODE *node;      FILE *stream; {i4   fwrite (node->contents, 1, node->nodelen, stream); }r ;F /* **************************************************************** */ /*								    */* /*		      Info Searching Commands			    */ /*								    */F /* **************************************************************** */  G /* Variable controlling the garbage collection of files briefly visited>D    during searches.  Such files are normally gc'ed, unless they wereC    compressed to begin with.  If this variable is non-zero, it says I    to gc even those file buffer contents which had to be uncompressed. */> int gc_compressed_files = 0;  $ static void info_gc_file_buffers ();  * static char *search_string = (char *)NULL;# static int search_string_index = 0;-" static int search_string_size = 0;! static int isearch_is_active = 0;w  < /* Return the file buffer which belongs to WINDOW's node. */
 FILE_BUFFER *r file_buffer_of_window (window)      WINDOW *window; {n?   /* If this window has no node, then it has no file buffer. */a   if (!window->node)!     return ((FILE_BUFFER *)NULL);e     if (window->node->parent)o3     return (info_find_file (window->node->parent));a     if (window->node->filename) 5     return (info_find_file (window->node->filename));O     return ((FILE_BUFFER *)NULL);_ }e  H /* Search for STRING in NODE starting at START.  Return -1 if the stringH    was not found, or the location of the string if it was.  If WINDOW isH    passed as non-null, set the window's node to be NODE, its point to beG    the found string, and readjust the window's pagetop.  Final argument D    DIR says which direction to search in.  If it is positive, search    forward, else backwards. */ long6 info_search_in_node (string, node, start, window, dir)      char *string;      NODE *node;      long start;      WINDOW *window;
      int dir;* {*   SEARCH_BINDING binding;*   long offset;  "   binding.buffer = node->contents;   binding.start = start;   binding.end = node->nodelen;   binding.flags = S_FoldCase;t     if (dir < 0)     {g       binding.end = 0;"       binding.flags |= S_SkipDest;     }e     if (binding.start < 0)     return (-1);  I   /* For incremental searches, we always wish to skip past the string. */    if (isearch_is_active)      binding.flags |= S_SkipDest;  %   offset = search (string, &binding);e     if (offset != -1 && window)a     {e0       set_remembered_pagetop_and_point (window);       if (window->node != node)i* 	window_set_node_of_window (window, node);       window->point = offset;p%       window_adjust_pagetop (window);      }m   return (offset); }t  L /* Search NODE, looking for the largest possible match of STRING.  Start theI    search at START.  Return the absolute position of the match, or -1, if(+    no part of the string could be found. */C long- info_target_search_node (node, string, start))      NODE *node;      char *string;      long start; {m   register int i;d   long offset;   char *target;e     target = savestring (string);    i = strlen (target);  G   /* Try repeatedly searching for this string while removing words fromo      the end of it. */   while (i)V     {N       target[i] = '\0';rL       offset = info_search_in_node (target, node, start, (WINDOW *)NULL, 1);         if (offset != -1)  	break;a  -       /* Delete the last word from TARGET. */dH       for (; i && (!whitespace (target[i]) && (target[i] != ',')); i--);     }n   free (target);   return (offset); }y  I /* Search for STRING starting in WINDOW at point.  If the string is foundAL    in this node, set point to that position.  Otherwise, get the file bufferL    associated with WINDOW's node, and search through each node in that file.G    If the search fails, return non-zero, else zero.  Side-effect window,D    leaving the node and point where the string was found current. */5 static char *last_searched_for_string = (char *)NULL;(
 static int* info_search_internal (string, window, dir)      char *string;      WINDOW *window;
      int dir;r {)   register int i;    FILE_BUFFER *file_buffer;!   char *initial_nodename;    long ret, start = 0;  /   file_buffer = file_buffer_of_window (window);s,   initial_nodename = window->node->nodename;  4   if ((info_last_executed_command == info_search) &&#       (last_searched_for_string) &&i7       (strcmp (last_searched_for_string, string) == 0))      {c       ret = info_search_in_nodey: 	(string, window->node, window->point + dir, window, dir);     }n   else     {o       ret = info_search_in_nodex4 	(string, window->node, window->point, window, dir);     }   (   maybe_free (last_searched_for_string);1   last_searched_for_string = savestring (string);b     if (ret != -1)     {e       /* We won! */o5       if (!echo_area_is_active && !isearch_is_active)d 	window_clear_echo_area ();d       return (0);l     }   E   /* The string wasn't found in the current node.  Search through the_>      window's file buffer, iff the current node is not "*". */<   if (!file_buffer || (strcmp (initial_nodename, "*") == 0))     return (-1);  E   /* If this file has tags, search through every subfile, starting atEA      this node's subfile and node.  Otherwise, search through then      file's node list. */e   if (file_buffer->tags)     {_/       register int current_tag, number_of_tags;n       char *last_subfile;        TAG *tag;   0       /* Find number of tags and current tag. */"       last_subfile = (char *)NULL;,       for (i = 0; file_buffer->tags[i]; i++)D 	if (strcmp (initial_nodename, file_buffer->tags[i]->nodename) == 0) 	  { 	    current_tag = i;b3 	    last_subfile = file_buffer->tags[i]->filename;} 	  }         number_of_tags = i;*  >       /* If there is no last_subfile, our tag wasn't found. */       if (!last_subfile)
 	return (-1);m  D       /* Search through subsequent nodes, wrapping around to the top= 	 of the info file until we find the string or return to thist 	 window's node and point. */u       while (1)h 	{ 	  NODE *node;  = 	  /* Allow C-g to quit the search, failing it if pressed. */n 	  return_if_control_g (-1);   	  current_tag += dir;   	  if (current_tag < 0)(& 	    current_tag = number_of_tags - 1;* 	  else if (current_tag == number_of_tags) 	    current_tag = 0;   ( 	  tag = file_buffer->tags[current_tag];  ? 	  if (!echo_area_is_active && (last_subfile != tag->filename))n 	    {" 	      window_message_in_echo_area! 		("Searching subfile \"%s\"...", + 		 filename_non_directory (tag->filename));t  $ 	      last_subfile = tag->filename; 	    }  ? 	  node = info_get_node (file_buffer->filename, tag->nodename);   
 	  if (!node)a 	    {% 	      /* If not doing i-search... */i  	      if (!echo_area_is_active) 		{o 		  if (info_recent_file_error)B* 		    info_error (info_recent_file_error); 		  else! 		    info_error (CANT_FILE_NODE,_3 				filename_non_directory (file_buffer->filename),N 				tag->nodename);R 		}O 	      return (-1);n 	    }   	  if (dir < 0)f 	    start = tag->nodelen;   	  ret =< 	    info_search_in_node (string, node, start, window, dir);  - 	  /* Did we find the string in this node? */d 	  if (ret != -1)  	    { 	      /* Yes!  We win. *// 	      remember_window_and_node (window, node);   	      if (!echo_area_is_active) 		window_clear_echo_area (); 	      return (0); 	    }  ? 	  /* No.  Free this node, and make sure that we haven't passede 	     our starting point. */ 	  free (node);r  5 	  if (strcmp (initial_nodename, tag->nodename) == 0)% 	    return (-1);d 	}     }e   return (-1); }i  E DECLARE_INFO_COMMAND (info_search, "Read a string and search for it")t {    char *line, *prompt;   int result, old_pagetop;   int direction;     if (count < 0)     direction = -1;e   else     direction = 1;  L   /* Read a string from the user, defaulting the search to SEARCH_STRING. */   if (!search_string)f     {BA       search_string = (char *)xmalloc (search_string_size = 100);;       search_string[0] = '\0';     }e  9   prompt = (char *)xmalloc (50 + strlen (search_string));   *   sprintf (prompt, "%s for string [%s]: ",1 	   direction < 0 ? "Search backward" : "Search",d 	   search_string);;  1   line = info_read_in_echo_area (window, prompt);e   free (prompt);     if (!line)     {*       info_abort_key ();
       return;/     }	     if (*line)     {n1       if (strlen (line) + 1 > search_string_size)* 	search_string = (char *)*H 	  xrealloc (search_string, (search_string_size += 50 + strlen (line)));  #       strcpy (search_string, line);e*       search_string_index = strlen (line);       free (line);     }e  '   old_pagetop = active_window->pagetop;iJ   result = info_search_internal (search_string, active_window, direction);  -   if (result != 0 && !info_error_was_printed)e"     info_error ("Search failed.");1   else if (old_pagetop != active_window->pagetop)N     {t       int new_pagetop;  +       new_pagetop = active_window->pagetop; +       active_window->pagetop = old_pagetop;r6       set_window_pagetop (active_window, new_pagetop);       if (auto_footnotes_p)w. 	info_get_or_remove_footnotes (active_window);     }w  G   /* Perhaps free the unreferenced file buffers that were searched, but       not retained. */*   info_gc_file_buffers (); }>  F /* **************************************************************** */ /*								    */# /*			Incremental Searching			    */d /*								    */F /* **************************************************************** */  " static void incremental_search ();  & DECLARE_INFO_COMMAND (isearch_forward,; 		      "Search interactively for a string as you type it")n {,*   incremental_search (window, count, key); }   ' DECLARE_INFO_COMMAND (isearch_backward,i; 		      "Search interactively for a string as you type it")  {s+   incremental_search (window, -count, key);a }   7 /* Incrementally search for a string as it is typed. */,2 /* The last accepted incremental search string. */2 static char *last_isearch_accepted = (char *)NULL;  , /* The current incremental search string. */+ static char *isearch_string = (char *)NULL;t$ static int isearch_string_index = 0;# static int isearch_string_size = 0;g8 static unsigned char isearch_terminate_search_key = ESC;  D /* Structure defining the current state of an incremental search. */ typedef struct {7   WINDOW_STATE_DECL;	/* The node, pagetop and point. */ G   int search_index;	/* Offset of the last char in the search string. */ D   int direction;	/* The direction that this search is heading in. */8   int failing;		/* Whether or not this search failed. */ } SEARCH_STATE;w   /* Array of search states. */e= static SEARCH_STATE **isearch_states = (SEARCH_STATE **)NULL;o$ static int isearch_states_index = 0;$ static int isearch_states_slots = 0;  $ /* Push the state of this search. */ static void 7 push_isearch (window, search_index, direction, failing)       WINDOW *window;*      int search_index, direction, failing; {    SEARCH_STATE *state;  :   state = (SEARCH_STATE *)xmalloc (sizeof (SEARCH_STATE));#   window_get_state (window, state); %   state->search_index = search_index;d   state->direction = direction;e   state->failing = failing;r  D   add_pointer_to_array (state, isearch_states_index, isearch_states,- 			isearch_states_slots, 20, SEARCH_STATE *);d }   J /* Pop the state of this search to WINDOW, SEARCH_INDEX, and DIRECTION. */ static void(6 pop_isearch (window, search_index, direction, failing)      WINDOW *window;-      int *search_index, *direction, *failing;* {    SEARCH_STATE *state;     if (isearch_states_index)]     {)       isearch_states_index--;t3       state = isearch_states[isearch_states_index];a'       window_set_state (window, state);i*       *search_index = state->search_index;$       *direction = state->direction;        *failing = state->failing;         free (state);hB       isearch_states[isearch_states_index] = (SEARCH_STATE *)NULL;     }o }S  - /* Free the memory used by isearch_states. */  static voidi free_isearch_states () {t   register int i;r  ,   for (i = 0; i < isearch_states_index; i++)     {c       free (isearch_states[i]); /       isearch_states[i] = (SEARCH_STATE *)NULL;t     }    isearch_states_index = 0;E }F  2 /* Display the current search in the echo area. */ static void , show_isearch_prompt (dir, string, failing_p)
      int dir;t      unsigned char *string;n      int failing_p;f {a   register int i;     char *prefix, *prompt, *p_rep;*   int prompt_len, p_rep_index, p_rep_size;     if (dir < 0)#     prefix = "I-search backward: ";    else     prefix = "I-search: ";     p_rep_index = p_rep_size = 0;n   p_rep = (char *)NULL;e   for (i = 0; string[i]; i++)c     {d       char *rep;         switch (string[i]) 	{ 	case ' ': rep = " "; break; 	case LFD: rep = "\\n"; break; 	case TAB: rep = "\\t"; break;	 	default:n$ 	  rep = pretty_keyname (string[i]); 	}9       if ((p_rep_index + strlen (rep) + 1) >= p_rep_size)_5 	p_rep = (char *)xrealloc (p_rep, p_rep_size += 100);)  (       strcpy (p_rep + p_rep_index, rep);"       p_rep_index += strlen (rep);     }   2   prompt_len = strlen (prefix) + p_rep_index + 20;(   prompt = (char *)xmalloc (prompt_len);A   sprintf (prompt, "%s%s%s", failing_p ? "Failing " : "", prefix,a 	   p_rep ? p_rep : "");  -   window_message_in_echo_area ("%s", prompt);e   maybe_free (p_rep);s   free (prompt);*   display_cursor_at_point (active_window); }-   static void * incremental_search (window, count, ignore)      WINDOW *window;      int count;       unsigned char ignore; {b   unsigned char key;-   int last_search_result, search_result, dir; #   SEARCH_STATE mystate, orig_state;      if (count < 0)
     dir = -1;,   else     dir = 1;  )   last_search_result = search_result = 0;b  )   window_get_state (window, &orig_state);i     isearch_string_index = 0;o   if (!isearch_string_size)h@     isearch_string = (char *)xmalloc (isearch_string_size = 50);  0   /* Show the search string in the echo area. */.   isearch_string[isearch_string_index] = '\0';;   show_isearch_prompt (dir, isearch_string, search_result);      isearch_is_active = 1;     while (isearch_is_active)D     {;*       VFunction *func = (VFunction *)NULL;       int quoted = 0;   J       /* If a recent display was interrupted, then do the redisplay now if 	 it is convenient. */E       if (!info_any_buffered_input_p () && display_was_interrupted_p)c 	{& 	  display_update_one_window (window);+ 	  display_cursor_at_point (active_window);v 	}  0       /* Read a character and dispatch on it. */#       key = info_get_input_char ();h*       window_get_state (window, &mystate);         if (key == DEL)t 	{2 	  /* User wants to delete one level of search? */ 	  if (!isearch_states_index)r 	    { 	      terminal_ring_bell ();! 	      continue; 	    } 	  elsei 	    { 	      pop_isearch8 		(window, &isearch_string_index, &dir, &search_result);3 	      isearch_string[isearch_string_index] = '\0';	@ 	      show_isearch_prompt (dir, isearch_string, search_result); 	      goto after_search;) 	    } 	}$       else if (key == Control ('q')) 	{  	  key = info_get_input_char (); 	  quoted = 1; 	}  L       /* We are about to search again, or quit.  Save the current search. */F       push_isearch (window, isearch_string_index, dir, search_result);         if (quoted)w 	goto insert_and_search;  6       if (!Meta_p (key) || (ISO_Latin_p && key < 160)) 	{' 	  func = window->keymap[key].function;r  E 	  /* If this key invokes an incremental search, then this means thatv? 	     we will either search again in the same direction, search ? 	     again in the reverse direction, or insert the last search @ 	     string that was accepted through incremental searching. */; 	  if (func == isearch_forward || func == isearch_backward)i 	    {2 	      if ((func == isearch_forward && dir > 0) ||* 		  (func == isearch_backward && dir < 0)) 		{ ; 		  /* If the user has typed no characters, then insert thel@ 		     last successful search into the current search string. */" 		  if (isearch_string_index == 0) 		    {a; 		      /* Of course, there must be something to insert. */ " 		      if (last_isearch_accepted) 			{. 			  if (strlen (last_isearch_accepted) + 1 >= 			      isearch_string_size)t  			    isearch_string = (char *)" 			      xrealloc (isearch_string,  					isearch_string_size += 10 +% 					strlen (last_isearch_accepted));(4 			  strcpy (isearch_string, last_isearch_accepted);4 			  isearch_string_index = strlen (isearch_string); 			  goto search_now;n 			} 		      else 			continue; 		    }e 		  else 		    {g@ 		      /* Search again in the same direction.  This means start: 			 from a new place if the last search was successful. */ 		      if (search_result == 0)  			window->point += dir; 		    }g 		}i 	      elsei 		{e. 		  /* Reverse the direction of the search. */ 		  dir = -dir;( 		}t 	    }7 	  else if (isprint (key) || func == (VFunction *)NULL)d 	    { 	    insert_and_search:c  ; 	      if (isearch_string_index + 2 >= isearch_string_size) # 		isearch_string = (char *)xrealloc 1 		  (isearch_string, isearch_string_size += 100);   4 	      isearch_string[isearch_string_index++] = key;3 	      isearch_string[isearch_string_index] = '\0';e 	      goto search_now;w 	    }# 	  else if (func == info_abort_key)u 	    {C 	      /* If C-g pressed, and the search is failing, pop the searchs- 		 stack back to the last unfailed search. */*8 	      if (isearch_states_index && (search_result != 0)) 		{e 		  terminal_ring_bell ();8 		  while (isearch_states_index && (search_result != 0)) 		    pop_isearch*> 		      (window, &isearch_string_index, &dir, &search_result);0 		  isearch_string[isearch_string_index] = '\0';= 		  show_isearch_prompt (dir, isearch_string, search_result);h
 		  continue;, 		}; 	      elseR 		goto exit_search;c 	    } 	  else  	    goto exit_search; 	}
       else 	{
 	exit_search:sC 	  /* The character is not printable, or it has a function which isyD 	     non-null.  Exit the search, remembering the search string.  IfB 	     the key is not the same as the isearch_terminate_search_key,) 	     then push it into pending input. */ 6 	  if (isearch_string_index && func != info_abort_key) 	    {* 	      maybe_free (last_isearch_accepted);; 	      last_isearch_accepted = savestring (isearch_string);a 	    }  + 	  if (key != isearch_terminate_search_key)n" 	    info_set_pending_input (key);   	  if (func == info_abort_key) 	    {  	      if (isearch_states_index)) 		window_set_state (window, &orig_state);  	    }   	  if (!echo_area_is_active) 	    window_clear_echo_area ();i   	  if (auto_footnotes_p)2 	    info_get_or_remove_footnotes (active_window);   	  isearch_is_active = 0;A 	  continue; 	}  6       /* Search for the contents of isearch_string. */     search_now:t?       show_isearch_prompt (dir, isearch_string, search_result);t         if (search_result == 0)i 	{B 	  /* Check to see if the current search string is right here.  If@ 	     we are looking at it, then don't bother calling the search 	     function. */ 	  if (((dir < 0) &&: 	       (strnicmp (window->node->contents + window->point,3 			 isearch_string, isearch_string_index) == 0)) ||c 	      ((dir > 0) &&8 	       ((window->point - isearch_string_index) >= 0) &&+ 	       (strnicmp (window->node->contents +e2 			  (window->point - (isearch_string_index - 1)),2 			  isearch_string, isearch_string_index) == 0))) 	    { 	      if (dir > 0)S 		window->point++; 	    } 	  elsecH 	    search_result = info_search_internal (isearch_string, window, dir); 	}  K       /* If this search failed, and we didn't already have a failed search,t! 	 then ring the terminal bell. */ 8       if (search_result != 0 && last_search_result == 0) 	terminal_ring_bell ();_       after_search:w?       show_isearch_prompt (dir, isearch_string, search_result);_         if (search_result == 0)> 	{( 	  if ((mystate.node == window->node) &&, 	      (mystate.pagetop != window->pagetop)) 	    {$ 	      int newtop = window->pagetop;) 	      window->pagetop = mystate.pagetop;e+ 	      set_window_pagetop (window, newtop);s 	    }& 	  display_update_one_window (window);$ 	  display_cursor_at_point (window); 	}  )       last_search_result = search_result;c     }s  ;   /* Free the memory used to remember each search state. */0   free_isearch_states ();r  %   /* Perhaps GC some file buffers. */v   info_gc_file_buffers ();  ?   /* After searching, leave the window in the correct state. */n   if (!echo_area_is_active)      window_clear_echo_area (); }p  E /* GC some file buffers.  A file buffer can be gc-ed if there we have G    no nodes in INFO_WINDOWS that reference this file buffer's contents. B    Garbage collecting a file buffer means to free the file buffers    contents. */g static void  info_gc_file_buffers ()  { %   register int fb_index, iw_index, i;p   register FILE_BUFFER *fb;p   register INFO_WINDOW *iw;r     if (!info_loaded_files)n     return;e  B   for (fb_index = 0; fb = info_loaded_files[fb_index]; fb_index++)     {_       int fb_referenced_p = 0;  )       /* If already gc-ed, do nothing. */t       if (!fb->contents)
 	continue;  G       /* If this file had to be uncompressed, check to see if we shouldpA 	 gc it.  This means that the user-variable "gc-compressed-files"t 	 is non-zero. */,?       if ((fb->flags & N_IsCompressed) && !gc_compressed_files) 
 	continue;  =       /* If this file's contents are not gc-able, move on. */r!       if (fb->flags & N_CannotGC)o
 	continue;  J       /* Check each INFO_WINDOW to see if it has any nodes which reference 	 this file. */ A       for (iw_index = 0; iw = info_windows[iw_index]; iw_index++)e 	{. 	  for (i = 0; iw->nodes && iw->nodes[i]; i++) 	    {B 	      if ((strcmp (fb->fullpath, iw->nodes[i]->filename) == 0) ||9 		  (strcmp (fb->filename, iw->nodes[i]->filename) == 0))= 		{  		  fb_referenced_p = 1;
 		  break; 		}i 	    } 	}  E       /* If this file buffer wasn't referenced, free its contents. */(       if (!fb_referenced_p)g 	{ 	  free (fb->contents);  	  fb->contents = (char *)NULL;/ 	}     }_ }i iF /* **************************************************************** */ /*								    */1 /*		  Traversing and Selecting References		    */_ /*								    */F /* **************************************************************** */  @ /* Move to the next or previous cross reference in this node. */ static void + info_move_to_xref (window, count, key, dir)i      WINDOW *window;      int count;c      unsigned char key;n
      int dir;w {    long firstmenu, firstxref;   long nextmenu, nextxref;   long placement = -1;   long start = 0;    NODE *node = window->node;     if (dir < 0)     start = node->nodelen;  E   /* This search is only allowed to fail if there is no menu or crossoF      reference in the current node.  Otherwise, the first menu or xref      found is moved to. */  !   firstmenu = info_search_in_nodep>     (INFO_MENU_ENTRY_LABEL, node, start, (WINDOW *)NULL, dir);  K   /* FIRSTMENU may point directly to the line defining the menu.  Skip that_*      and go directly to the first item. */     if (firstmenu != -1)     { .       char *text = node->contents + firstmenu;  I       if (strncmp (text, INFO_MENU_LABEL, strlen (INFO_MENU_LABEL)) == 0)u  	firstmenu = info_search_in_nodeG 	  (INFO_MENU_ENTRY_LABEL, node, firstmenu + dir, (WINDOW *)NULL, dir);      }a  
   firstxref = L     info_search_in_node (INFO_XREF_LABEL, node, start, (WINDOW *)NULL, dir);  )   if (firstmenu == -1 && firstxref == -1)>     {k7       info_error ("No cross references in this node.");l
       return;h     }s  F   /* There is at least one cross reference or menu entry in this node.0      Try hard to find the next available one. */      nextmenu = info_search_in_nodeL     (INFO_MENU_ENTRY_LABEL, node, window->point + dir, (WINDOW *)NULL, dir);      nextxref = info_search_in_nodeF     (INFO_XREF_LABEL, node, window->point + dir, (WINDOW *)NULL, dir);  &   /* Ignore "Menu:" as a menu item. */   if (nextmenu != -1)h     {s-       char *text = node->contents + nextmenu;c  I       if (strncmp (text, INFO_MENU_LABEL, strlen (INFO_MENU_LABEL)) == 0)  	nextmenu = info_search_in_node F 	  (INFO_MENU_ENTRY_LABEL, node, nextmenu + dir, (WINDOW *)NULL, dir);     }   J   /* If there is both a next menu entry, and a next xref entry, choose theF      one which occurs first.  Otherwise, select the one which actually-      appears in this node following point. */_'   if (nextmenu != -1 && nextxref != -1)h     {,2       if (((dir == 1) && (nextmenu < nextxref)) ||* 	  ((dir == -1) && (nextmenu > nextxref))) 	placement = nextmenu + 1;
       else 	placement = nextxref;     }    else if (nextmenu != -1)     placement = nextmenu + 1;s   else if (nextxref != -1)     placement = nextxref;s  K   /* If there was neither a menu or xref entry appearing in this node after J      point, choose the first menu or xref entry appearing in this node. */   if (placement == -1)     { -       if (firstmenu != -1 && firstxref != -1)) 	{1 	  if (((dir == 1) && (firstmenu < firstxref)) ||i0 	      ((dir == -1) && (firstmenu > firstxref))) 	    placement = firstmenu + 1;o 	  elsei 	    placement = firstxref;_ 	}       else if (firstmenu != -1)n 	placement = firstmenu + 1;e
       else 	placement = firstxref;i     }x   window->point = placement;!   window_adjust_pagetop (window); "   window->flags |= W_UpdateWindow; }C  - DECLARE_INFO_COMMAND (info_move_to_prev_xref,a/ 		      "Move to the previous cross reference")* {    if (count < 0)1     info_move_to_prev_xref (window, -count, key);e   else/     info_move_to_xref (window, count, key, -1);( }r  - DECLARE_INFO_COMMAND (info_move_to_next_xref,n+ 		      "Move to the next cross reference")u {;   if (count < 0)1     info_move_to_next_xref (window, -count, key);p   else.     info_move_to_xref (window, count, key, 1); },  B /* Select the menu item or reference that appears on this line. */6 DECLARE_INFO_COMMAND (info_select_reference_this_line,? 		      "Select reference or menu item appearing on this line")  { 
   char *line;i
   NODE *orig;e  <   line = window->line_starts[window_line_of_point (window)];   orig = window->node;  ;   /* If this line contains a menu item, select that one. */ #   if (strncmp ("* ", line, 2) == 0)_E     info_menu_or_ref_item (window, count, key, info_menu_of_node, 0);l   elseF     info_menu_or_ref_item (window, count, key, info_xrefs_of_node, 0); }c eF /* **************************************************************** */ /*								    */, /*		    Miscellaneous Info Commands			    */ /*								    */F /* **************************************************************** */  1 /* What to do when C-g is pressed in a window. */ A DECLARE_INFO_COMMAND (info_abort_key, "Cancel current operation")_ {iD   /* If error printing doesn't oridinarily ring the bell, do it now,G      since C-g always rings the bell.  Otherwise, let the error printer_      do it. */   if (!info_error_rings_bell_p)l     terminal_ring_bell ();   info_error ("Quit");  !   info_initialize_numeric_arg ();e   info_clear_pending_input ();1   info_last_executed_command = (VFunction *)NULL;  }d  8 /* Move the cursor to the desired line of the window. *// DECLARE_INFO_COMMAND (info_move_to_window_line,d9    "Move to the cursor to a specific line of the window")n {    int line;g  I   /* With no numeric argument of any kind, default to the center line. */>'   if (!info_explicit_arg && count == 1) 2     line = (window->height / 2) + window->pagetop;   else     {d       if (count < 0)3 	line = (window->height + count) + window->pagetop;e
       else  	line = window->pagetop + count;     }   A   /* If the line doesn't appear in this window, make it do so. */r1   if ((line - window->pagetop) >= window->height)(2     line = window->pagetop + (window->height - 1);  .   /* If the line is too small, make it fit. */   if (line < window->pagetop)c     line = window->pagetop;   K   /* If the selected line is past the bottom of the node, force it back. */ !   if (line >= window->line_count)g"     line = window->line_count - 1;  G   window->point = (window->line_starts[line] - window->node->contents);n }_  G /* Clear the screen and redraw its contents.  Given a numeric argument, H    move the line the cursor is on to the COUNT'th line of the window. */@ DECLARE_INFO_COMMAND (info_redraw_display, "Redraw the display") {a@   if ((!info_explicit_arg && count == 1) || echo_area_is_active)     {u       terminal_clear_screen ();s*       display_clear_display (the_display);2       window_mark_chain (windows, W_UpdateWindow);'       display_update_display (windows);p     }G   else     {f#       int desired_line, point_line;h       int new_pagetop;  C       point_line = window_line_of_point (window) - window->pagetop;a         if (count < 0)' 	desired_line = window->height + count;n
       else 	desired_line = count;         if (desired_line < 0)i 	desired_line = 0;  )       if (desired_line >= window->height)t# 	desired_line = window->height - 1;o  %       if (desired_line == point_line)n 	return;  B       new_pagetop = window->pagetop + (point_line - desired_line);  /       set_window_pagetop (window, new_pagetop);h     }t } G /* This command does nothing.  It is the fact that a key is bound to itoD    that has meaning.  See the code at the top of info_session (). */3 DECLARE_INFO_COMMAND (info_quit, "Quit using Info"), {}   fF /* **************************************************************** */ /*								    */1 /*		 Reading Keys and Dispatching on Them		    */  /*								    */F /* **************************************************************** */  B /* Declaration only.  Special cased in info_dispatch_on_key (). */4 DECLARE_INFO_COMMAND (info_do_lowercase_version, "") {}   static voids dispatch_error (keyseq)       char *keyseq; {p   char *rep;     rep = pretty_keyseq (keyseq);      if (!echo_area_is_active)n.     info_error ("Unknown command (%s).", rep);   else     {        char *temp;}  M       temp = (char *)xmalloc (1 + strlen (rep) + strlen ("\"\" is invalid"));   /       sprintf (temp, "\"%s\" is invalid", rep);t       terminal_ring_bell ();!       inform_in_echo_area (temp);*       free (temp);     }* }*  % /* Keeping track of key sequences. */	( static char *info_keyseq = (char *)NULL; static char keyseq_rep[100];! static int info_keyseq_index = 0;*  static int info_keyseq_size = 0;' static int info_keyseq_displayed_p = 0;u  8 /* Initialize the length of the current key sequence. */ void initialize_keyseq () {r   info_keyseq_index = 0;   info_keyseq_displayed_p = 0; }r  0 /* Add CHARACTER to the current key sequence. */ void add_char_to_keyseq (character)      char character; {g0   if (info_keyseq_index + 2 >= info_keyseq_size)I     info_keyseq = (char *)xrealloc (info_keyseq, info_keyseq_size += 10);t  /   info_keyseq[info_keyseq_index++] = character;e(   info_keyseq[info_keyseq_index] = '\0'; }e  A /* Return the pretty printable string which represents KEYSEQ. */n char * pretty_keyseq (keyseq)      char *keyseq; {W   register int i;      keyseq_rep[0] = '\0';c     for (i = 0; keyseq[i]; i++).     {t8       sprintf (keyseq_rep + strlen (keyseq_rep), "%s%s",' 	       strlen (keyseq_rep) ? " " : "",t$ 	       pretty_keyname (keyseq[i]));     }t     return (keyseq_rep); }   F /* Display the current value of info_keyseq.  If argument EXPECTING isC    non-zero, input is expected to be read after the key sequence is J    displayed, so add an additional prompting character to the sequence. */ void, display_info_keyseq (expecting_future_input)       int expecting_future_input; {o   char *rep;  $   rep = pretty_keyseq (info_keyseq);   if (expecting_future_input)i     strcat (rep, "-");     if (echo_area_is_active)     inform_in_echo_area (rep);   else     {o(       window_message_in_echo_area (rep);.       display_cursor_at_point (active_window);     },   info_keyseq_displayed_p = 1; }f  9 /* Called by interactive commands to read a keystroke. */o
 unsigned charD info_get_another_input_char () {n   int ready = 0;  >   /* If there isn't any input currently available, then wait a?      moment looking for input.  If we don't get it fast enough,t:      prompt a little bit with the current key sequence. */!   if (!info_keyseq_displayed_p &&d&       !info_any_buffered_input_p () &&       !info_input_pending_p ())      {m #if defined (FD_SET)       struct timeval timer;o       fd_set readfds;          FD_ZERO (&readfds);c4       FD_SET (fileno (info_input_stream), &readfds);       timer.tv_sec = 1;1       timer.tv_usec = 750;K       ready = select (1, &readfds, (fd_set *)NULL, (fd_set *)NULL, &timer);t #endif /* FD_SET */p     }t  
   if (!ready)      display_info_keyseq (1);  "   return (info_get_input_char ()); }   K /* Do the command associated with KEY in MAP.  If the associated command istI    really a keymap, then read another key, and dispatch into that map. */n void info_dispatch_on_key (key, map)t      unsigned char key;r      Keymap map; { G   if (Meta_p (key) && (!ISO_Latin_p || map[key].function != ea_insert))      {{"       if (map[ESC].type == ISKMAP) 	{# 	  map = (Keymap)map[ESC].function;( 	  add_char_to_keyseq (ESC); 	  key = UnMeta (key);# 	  info_dispatch_on_key (key, map);t 	}
       else 	{  	  dispatch_error (info_keyseq); 	}
       return;e     }      switch (map[key].type)     {      case ISFUNC:       {m 	VFunction *func;s   	func = map[key].function; 	if (func != (VFunction *)NULL)  	  {5 	    /* Special case info_do_lowercase_version (). */ + 	    if (func == info_do_lowercase_version)( 	      {, 		info_dispatch_on_key (tolower (key), map);	 		return;l 	      }   	    add_char_to_keyseq (key);  ! 	    if (info_keyseq_displayed_p)( 	      display_info_keyseq (0);    	    { 	      WINDOW *where;"   	      where = active_window;o 	      (*map[key].function)cA 		(active_window, info_numeric_arg * info_numeric_arg_sign, key);;  F 	      /* If we have input pending, then the last command was a prefix> 		 command.  Don't change the value of the last function vars.; 		 Otherwise, remember the last command executed in the var 9 		 appropriate to the window in which it was executed. */t$ 	      if (!info_input_pending_p ()) 		{g 		  if (where == the_echo_area)l3 		    ea_last_executed_command = map[key].function;( 		  else5 		    info_last_executed_command = map[key].function;, 		}t 	    } 	  } 	elseo 	  { 	    add_char_to_keyseq (key);" 	    dispatch_error (info_keyseq); 	    return; 	  }       }*       break;       case ISKMAP:       add_char_to_keyseq (key);*1       if (map[key].function != (VFunction *)NULL)	 	{ 	  unsigned char newkey;  + 	  newkey = info_get_another_input_char ();*< 	  info_dispatch_on_key (newkey, (Keymap)map[key].function); 	}
       else 	{  	  dispatch_error (info_keyseq);
 	  return; 	}       break;     }I }r  F /* **************************************************************** */ /*								    */ /*			Numeric Arguments			    */n /*								    */F /* **************************************************************** */  B /* Handle C-u style numeric args, as well as M--, and M-digits. */  C /* Non-zero means that an explicit argument has been passed to thisd    command, as in C-u C-v. */e int info_explicit_arg = 0;  ' /* The sign of the numeric argument. */_ int info_numeric_arg_sign = 1;  ' /* The value of the argument itself. */n int info_numeric_arg = 1;m  8 /* Add the current digit to the argument in progress. */4 DECLARE_INFO_COMMAND (info_add_digit_to_numeric_arg,9 		      "Add this digit to the current numeric argument")  {f/   info_numeric_arg_digit_loop (window, 0, key);w }o  @ /* C-u, universal argument.  Multiply the current argument by 4.A    Read a key.  If the key has nothing to do with arguments, thenrD    dispatch on it.  If the key is the abort character then abort. */. DECLARE_INFO_COMMAND (info_universal_argument,@ 		      "Start (or multiply by 4) the current numeric argument") {    info_numeric_arg *= 4;-   info_numeric_arg_digit_loop (window, 0, 0);t }o    /* Create a default argument. */ void info_initialize_numeric_arg () {=/   info_numeric_arg = info_numeric_arg_sign = 1;n   info_explicit_arg = 0; }o  6 DECLARE_INFO_COMMAND (info_numeric_arg_digit_loop, "") {s   unsigned char pure_key; !   Keymap keymap = window->keymap;r     while (1)e     {t       if (key) 	pure_key = key;
       else 	{B 	  if (display_was_interrupted_p && !info_any_buffered_input_p ())& 	    display_update_display (windows);  & 	  if (active_window != the_echo_area)- 	    display_cursor_at_point (active_window);   3 	  pure_key = key = info_get_another_input_char ();    	  if (Meta_p (key)) 	    add_char_to_keyseq (ESC);  % 	  add_char_to_keyseq (UnMeta (key));h 	}         if (Meta_p (key))  	key = UnMeta (key);  '       if (keymap[key].type == ISFUNC && 3 	  keymap[key].function == info_universal_argument)t 	{ 	  info_numeric_arg *= 4;d 	  key = 0;; 	  continue; 	}         if (isdigit (key)) 	{ 	  if (info_explicit_arg)e> 	    info_numeric_arg = (info_numeric_arg * 10) + (key - '0'); 	  elsee$ 	    info_numeric_arg = (key - '0'); 	  info_explicit_arg = 1;w 	}
       else 	{( 	  if (key == '-' && !info_explicit_arg) 	    {" 	      info_numeric_arg_sign = -1; 	      info_numeric_arg = 1; 	    } 	  elseh 	    { 	      info_keyseq_index--; / 	      info_dispatch_on_key (pure_key, keymap);  	      return; 	    } 	}       key = 0;     }g }f ,F /* **************************************************************** */ /*								    */, /*			Input Character Buffering       	    */ /*								    */F /* **************************************************************** */  ( /* Character waiting to be read next. */' static int pending_input_character = 0;/  , /* How to make there be no pending input. */ static void  info_clear_pending_input ()( {s   pending_input_character = 0; }r  - /* How to set the pending input character. */f static voidi info_set_pending_input (key)      unsigned char key;p {     pending_input_character = key; }   / /* How to see if there is any pending input. */r
 unsigned charn info_input_pending_p ()t {t#   return (pending_input_character);  }e  ? /* Largest number of characters that we can read in advance. */e$ #define MAX_INFO_INPUT_BUFFERING 512  ) static int pop_index = 0, push_index = 0;eA static unsigned char info_input_buffer[MAX_INFO_INPUT_BUFFERING];_  5 /* Add KEY to the buffer of characters to be read. */t static voide info_push_typeahead (key)*      unsigned char key;  { ;   /* Flush all pending input in the case of C-g pressed. */n   if (key == Control ('g'))k     {i       push_index = pop_index;A-       info_set_pending_input (Control ('g'));d     }t   else     {c,       info_input_buffer[push_index++] = key;3       if (push_index >= sizeof (info_input_buffer))  	push_index = 0;     }y },  N /* Return the amount of space available in INFO_INPUT_BUFFER for new chars. */
 static int$ info_input_buffer_space_available () {r   if (pop_index > push_index)h$     return (pop_index - push_index);   elseC     return (sizeof (info_input_buffer - (push_index - pop_index)));r }0  6 /* Get a key from the buffer of characters to be read.    Return the key in KEY.lB    Result is non-zero if there was a key, or 0 if there wasn't. */
 static int! info_get_key_from_typeahead (key)       unsigned char *key; {    if (push_index == pop_index)     return (0);a  (   *key = info_input_buffer[pop_index++];  .   if (pop_index >= sizeof (info_input_buffer))     pop_index = 0;  
   return (1);p }g   intt info_any_buffered_input_p () {p   info_gather_typeahead ();t#   return (push_index != pop_index);_ }u  F /* Push KEY into the *front* of the input buffer.  Returns non-zero if?    successful, zero if there is no space left in the buffer. */a
 static int# info_replace_key_to_typeahead (key)       unsigned char key;e {_+   if (info_input_buffer_space_available ())n     {v       pop_index--;       if (pop_index < 0), 	pop_index = sizeof (info_input_buffer) - 1;)       info_input_buffer[pop_index] = key;n       return (1);t     })
   return (0);d }   M /* If characters are available to be read, then read them and stuff them into 0    info_input_buffer.  Otherwise, do nothing. */ void info_gather_typeahead () {h   int tty, space_avail;/   long chars_avail;d0   unsigned char input[MAX_INFO_INPUT_BUFFERING];  #   tty = fileno (info_input_stream);    chars_avail = 0;  5   space_avail = info_input_buffer_space_available ();f  M   /* If we can just find out how many characters there are to read, do so. */a #if defined (FIONREAD)   {1(     ioctl (tty, FIONREAD, &chars_avail);  "     if (chars_avail > space_avail)        chars_avail = space_avail;       if (chars_avail))       read (tty, &input[0], chars_avail);    }  #else /* !FIONREAD */p #  if defined (O_NDELAY)   {o     int flags;  $     flags = fcntl (tty, F_GETFL, 0);  -     fcntl (tty, F_SETFL, (flags | O_NDELAY));e7       chars_avail = read (tty, &input[0], space_avail);n      fcntl (tty, F_SETFL, flags);       if (chars_avail == -1)       chars_avail = 0;   }_ #  endif /* O_NDELAY */i #endif /* !FIONREAD */  C   /* Store the input characters just read into our input buffer. */u   {n     register int i;y  %     for (i = 0; i < chars_avail; i++)f%       info_push_typeahead (input[i]);    }e }{  % /* How to read a single character. */ 
 unsigned char  info_get_input_char () {t   unsigned char keystroke;     info_gather_typeahead ();s     if (pending_input_character)     { *       keystroke = pending_input_character;"       pending_input_character = 0;     } 9   else if (info_get_key_from_typeahead (&keystroke) == 0)o     {c       int rawkey;k  (       rawkey = getc (info_input_stream);       keystroke = rawkey;          if (rawkey == EOF) 	{" 	  if (info_input_stream != stdin) 	    {" 	      fclose (info_input_stream);! 	      info_input_stream = stdin;p 	      display_inhibited = 0;d( 	      display_update_display (windows);/ 	      display_cursor_at_point (active_window); ) 	      rawkey = getc (info_input_stream);a 	      keystroke = rawkey; 	    }   	  if (rawkey == EOF)h 	    {# 	      terminal_unprep_terminal ();  	      close_dribble_file ();  	      exit (0); 	    } 	}     }      if (info_dribble_file)     dribble (keystroke);     return (keystroke);	 } 