 /* Getopt for GNU.G    NOTE: getopt is now part of the C library, so if you don't know what I    "Keep this file name-space clean" means, talk to roland@gnu.ai.mit.edu     before changing it!  /    Copyright (C) 1987, 88, 89, 90, 91, 92, 1993 "    	Free Software Foundation, Inc.  J    This program is free software; you can redistribute it and/or modify itH    under the terms of the GNU General Public License as published by theF    Free Software Foundation; either version 2, or (at your option) any    later version.   B    This program is distributed in the hope that it will be useful,A    but WITHOUT ANY WARRANTY; without even the implied warranty of @    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/    GNU General Public License for more details.   D    You should have received a copy of the GNU General Public License>    along with this program; if not, write to the Free Software:    Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */  @ /* NOTE!!!  AIX requires this to be the first thing in the file.%    Do not put ANYTHING before it!  */ ) #if !defined (__GNUC__) && defined (_AIX)   #pragma alloca  #endif   #ifdef HAVE_CONFIG_H #include "config.h"  #endif   #ifdef __GNUC__  #define alloca __builtin_alloca  #else /* not __GNUC__ */| #if defined (HAVE_ALLOCA_H) || (defined(sparc) && (defined(sun) || (!defined(USG) && !defined(SVR4) && !defined(__svr4__)))) #include <alloca.h>  #else  #ifndef _AIX char *alloca (); #endif #endif /* alloca.h */  #endif /* not __GNUC__ */   * #if !__STDC__ && !defined(const) && IN_GCC
 #define const  #endif  L /* This tells Alpha OSF/1 not to define a getopt prototype in <stdio.h>.  */ #ifndef _NO_PROTO  #define _NO_PROTO  #endif   #include <stdio.h>  K /* Comment out all this code if we are using the GNU C Library, and are not I    actually compiling the library itself.  This code is part of the GNU C I    Library, but also included in many other GNU distributions.  Compiling C    and linking in this code is a waste when using the GNU C library H    (especially if it is a shared library).  Rather than having every GNUL    program understand `configure --with-gnu-libc' and omit the object files,F    it is simpler to just do this in the source for each such file.  */  1 #if defined (_LIBC) || !defined (__GNU_LIBRARY__)     1 /* This needs to come after some library #include &    to get __GNU_LIBRARY__ defined.  */ #ifdef	__GNU_LIBRARY__
 #undef	alloca F /* Don't include stdlib.h for non-GNU C libraries because some of them1    contain conflicting prototypes for getopt.  */  #include <stdlib.h>  #else	/* Not GNU C library.  */  #define	__alloca	alloca  #endif	/* GNU C library.  */  C /* If GETOPT_COMPAT is defined, `+' as well as `--' can introduce a C    long-named option.  Because this is not POSIX.2 compliant, it is     being phased out.  */ /* #define GETOPT_COMPAT */   M /* This version of `getopt' appears to the caller like standard Unix `getopt' D    but it behaves differently for the user, since it allows the user7    to intersperse the options with the other arguments.   ?    As `getopt' works, it permutes the elements of ARGV so that, B    when it is done, all the options precede everything else.  ThusK    all application programs are extended to handle flexible argument order.   I    Setting the environment variable POSIXLY_CORRECT disables permutation. ,    Then the behavior is completely standard.  E    GNU application programs can use a third alternative mode in which N    they can distinguish the relative order of options and other arguments.  */   #include "getopt.h"   1 /* For communication from `getopt' to the caller. 8    When `getopt' finds an option that takes an argument,'    the argument value is returned here. ,    Also, when `ordering' is RETURN_IN_ORDER,5    each non-option ARGV-element is returned here.  */    char *optarg = 0;   3 /* Index in ARGV of the next element to be scanned. 8    This is used for communication to and from the caller>    and for communication between successive calls to `getopt'.  G    On entry to `getopt', zero means this is the first call; initialize.   C    When `getopt' returns EOF, this is the index of the first of the :    non-option elements that the caller should itself scan.  =    Otherwise, `optind' communicates from one call to the next 0    how much of ARGV has been scanned so far.  */  6 /* XXX 1003.2 says this must be 1 before any call.  */ int optind = 0;   4 /* The next char to be scanned in the option-element<    in which the last option character we returned was found.8    This allows us to pick up the scan where we left off.  >    If this is zero, or a null string, it means resume the scan-    by advancing to the next ARGV-element.  */    static char *nextchar;  7 /* Callers store zero here to inhibit the error message      for unrecognized options.  */   int opterr = 1;   5 /* Set to an option character which was unrecognized. C    This must be initialized on some systems to avoid linking in the *    system's own getopt implementation.  */   int optopt = '?';   J /* Describe how to deal with options that follow non-option ARGV-elements.  *    If the caller did not specify anything,;    the default is REQUIRE_ORDER if the environment variable 1    POSIXLY_CORRECT is defined, PERMUTE otherwise.   7    REQUIRE_ORDER means don't recognize them as options; <    stop option processing when the first non-option is seen.    This is what Unix does.G    This mode of operation is selected by either setting the environment @    variable POSIXLY_CORRECT, or using `+' as the first character$    of the list of option characters.  G    PERMUTE is the default.  We permute the contents of ARGV as we scan, N    so that eventually all the non-options are at the end.  This allows optionsH    to be given in any order, even with programs that were not written to    expect this.   G    RETURN_IN_ORDER is an option available to programs that were written M    to expect options and other ARGV-elements in any order and that care about E    the ordering of the two.  We describe each non-option ARGV-element A    as if it were the argument of an option with character code 1. D    Using `-' as the first character of the list of option characters"    selects this mode of operation.  H    The special argument `--' forces an end of option-scanning regardlessD    of the value of `ordering'.  In the case of RETURN_IN_ORDER, onlyC    `--' can cause `getopt' to return EOF with `optind' != ARGC.  */    static enum  { )   REQUIRE_ORDER, PERMUTE, RETURN_IN_ORDER  } ordering;    #ifdef	__GNU_LIBRARY__@ /* We want to avoid inclusion of string.h with non-GNU libraries4    because there are many ways it can cause trouble.D    On some systems, it contains special magic macros that don't work    in GCC.  */ #include <string.h>  #define	my_index	strchr 8 #define	my_bcopy(src, dst, n)	memcpy ((dst), (src), (n)) #else   0 /* Avoid depending on library functions or files$    whose names are inconsistent.  */   char *getenv ();  
 static char *  my_index (str, chr)       const char *str; 
      int chr;  {    while (*str)     {        if (*str == chr) 	return (char *) str;        str++;     }    return 0;  }    static void  my_bcopy (from, to, size)       const char *from;      char *to;      int size; {    int i;   for (i = 0; i < size; i++)     to[i] = from[i]; }  #endif				/* GNU C library.  */   ' /* Handle permutation of arguments.  */   @ /* Describe the part of ARGV that contains non-options that haveK    been skipped.  `first_nonopt' is the index in ARGV of the first of them; 9    `last_nonopt' is the index after the last of them.  */    static int first_nonopt; static int last_nonopt;   . /* Exchange two adjacent subsequences of ARGV.9    One subsequence is elements [first_nonopt,last_nonopt) D    which contains all the non-options that have been skipped so far.A    The other is elements [last_nonopt,optind), which contains all >    the options processed since those non-options were skipped.  G    `first_nonopt' and `last_nonopt' are relocated so that they describe G    the new indices of the non-options in ARGV after they are moved.  */C   static void  exchange (argv)a      char **argv;i {nD   int nonopts_size = (last_nonopt - first_nonopt) * sizeof (char *);2   char **temp = (char **) __alloca (nonopts_size);  4   /* Interchange the two blocks of data in ARGV.  */  G   my_bcopy ((char *) &argv[first_nonopt], (char *) temp, nonopts_size);rF   my_bcopy ((char *) &argv[last_nonopt], (char *) &argv[first_nonopt],/ 	    (optind - last_nonopt) * sizeof (char *));o   my_bcopy ((char *) temp,9 	    (char *) &argv[first_nonopt + optind - last_nonopt],t 	    nonopts_size);b  A   /* Update records for the slots the non-options now occupy.  */R  )   first_nonopt += (optind - last_nonopt);O   last_nonopt = optind;r }P iE /* Scan elements of ARGV (whose length is ARGC) for option charactersh    given in OPTSTRING.  I    If an element of ARGV starts with '-', and is not exactly "-" or "--",d@    then it is an option element.  The characters of this elementC    (aside from the initial '-') are option characters.  If `getopt' N    is called repeatedly, it returns successively each of the option characters$    from each of the option elements.  I    If `getopt' finds another option character, it returns that character,aI    updating `optind' and `nextchar' so that the next call to `getopt' canpG    resume the scan with the following option character or ARGV-element.v  B    If there are no more option characters, `getopt' returns `EOF'.?    Then `optind' is the index in ARGV of the first ARGV-elementi@    that is not an option.  (The ARGV-elements have been permuted5    so that those that are not options now come last.)o  E    OPTSTRING is a string containing the legitimate option characters. B    If an option character is seen that is not listed in OPTSTRING,F    return '?' after printing an error message.  If you set `opterr' toA    zero, the error message is suppressed but we still return '?'.n  M    If a char in OPTSTRING is followed by a colon, that means it wants an arg,eO    so the following text in the same ARGV-element, or the text of the followingrI    ARGV-element, is returned in `optarg'.  Two colons mean an option thatnG    wants an optional arg; if there is text in the current ARGV-element,fA    it is returned in `optarg', otherwise `optarg' is set to zero.B  H    If OPTSTRING starts with `-' or `+', it requests different methods of)    handling the non-option ARGV-elements.LC    See the comments about RETURN_IN_ORDER and REQUIRE_ORDER, above.r  5    Long-named options begin with `--' instead of `-'.yG    Their names may be abbreviated as long as the abbreviation is unique*A    or is an exact match for some defined option.  If they have an K    argument, it follows the option name in the same ARGV-element, separated C    from the option name by a `=', or else the in next ARGV-element.eI    When `getopt' finds a long-named option, it returns 0 if that option'seA    `flag' field is nonzero, the value of the option's `val' fieldi    if the `flag' field is zero.a  E    The elements of ARGV aren't really const, because we permute them. A    But we pretend they're const in the prototype to be compatible     with other systems.  ;    LONGOPTS is a vector of `struct option' terminated by anp+    element containing a name which is zero.e  G    LONGIND returns the index in LONGOPT of the long-named option found.pG    It is only valid when a long-named option has been found by the mosti    recent call.a  =    If LONG_ONLY is nonzero, '-' as well as '--' can introduce     long-named options.  */   inttF _getopt_internal (argc, argv, optstring, longopts, longind, long_only)      int argc;      char *const *argv;'      const char *optstring;n#      const struct option *longopts;r      int *longind;      int long_only;i {E   int option_index;c  
   optarg = 0;-  >   /* Initialize the internal data when the first call is made.G      Start processing options with ARGV-element 1 (since ARGV-element 0t=      is the program name); the sequence of previously skippedc+      non-option ARGV-elements is empty.  */`     if (optind == 0)     {h.       first_nonopt = last_nonopt = optind = 1;         nextchar = NULL;  L       /* Determine how to handle the ordering of options and nonoptions.  */         if (optstring[0] == '-') 	{ 	  ordering = RETURN_IN_ORDER; 	  ++optstring;A 	}#       else if (optstring[0] == '+')X 	{ 	  ordering = REQUIRE_ORDER; 	  ++optstring;n 	}2       else if (getenv ("POSIXLY_CORRECT") != NULL) 	ordering = REQUIRE_ORDER;
       else 	ordering = PERMUTE;     }   ,   if (nextchar == NULL || *nextchar == '\0')     {l       if (ordering == PERMUTE) 	{H 	  /* If we have just processed some options following some non-options,7 	     exchange them so that the options come first.  */e  < 	  if (first_nonopt != last_nonopt && last_nonopt != optind) 	    exchange ((char **) argv); " 	  else if (last_nonopt != optind) 	    first_nonopt = optind;u  ) 	  /* Now skip any additional non-optionsnA 	     and extend the range of non-options previously skipped.  */o   	  while (optind < argco9 		 && (argv[optind][0] != '-' || argv[optind][1] == '\0'). #ifdef GETOPT_COMPAT 		 && (longopts == NULL < 		     || argv[optind][0] != '+' || argv[optind][1] == '\0') #endif				/* GETOPT_COMPAT */P 		 ) 	    optind++; 	  last_nonopt = optind; 	}  B       /* Special ARGV-element `--' means premature end of options. 	 Skip it like a null option,wB 	 then exchange with previous non-options as if it were an option,2 	 then skip everything else like a non-option.  */  9       if (optind != argc && !strcmp (argv[optind], "--"))c 	{ 	  optind++;  < 	  if (first_nonopt != last_nonopt && last_nonopt != optind) 	    exchange ((char **) argv);h( 	  else if (first_nonopt == last_nonopt) 	    first_nonopt = optind;n 	  last_nonopt = argc;   	  optind = argc;t 	}  =       /* If we have done all the ARGV-elements, stop the scan A 	 and back over any non-options that we skipped and permuted.  */-         if (optind == argc)t 	{8 	  /* Set the next-arg-index to point at the non-optionsE 	     that we previously skipped, so the caller will digest them.  */ # 	  if (first_nonopt != last_nonopt)h 	    optind = first_nonopt;  	  return EOF; 	}  @       /* If we have come to a non-option and did not permute it,G 	 either stop the scan or describe it to the caller and pass it by.  */g  =       if ((argv[optind][0] != '-' || argv[optind][1] == '\0')p #ifdef GETOPT_COMPAT 	  && (longopts == NULL < 	      || argv[optind][0] != '+' || argv[optind][1] == '\0') #endif				/* GETOPT_COMPAT */L 	  ) 	{! 	  if (ordering == REQUIRE_ORDER)r 	    return EOF; 	  optarg = argv[optind++];a 	  return 1; 	}  3       /* We have found another option-ARGV-element.a$ 	 Start decoding its characters.  */  "       nextchar = (argv[optind] + 14 		  + (longopts != NULL && argv[optind][1] == '-'));     }t     if (longopts != NULL!       && ((argv[optind][0] == '-'i- 	   && (argv[optind][1] == '-' || long_only))  #ifdef GETOPT_COMPAT 	  || argv[optind][0] == '+' #endif				/* GETOPT_COMPAT */r 	  ))      {r       const struct option *p;        char *s = nextchar;t       int exact = 0;       int ambig = 0;)       const struct option *pfound = NULL;r       int indfound;c         while (*s && *s != '=')  	s++;t  L       /* Test all options for either exact match or abbreviated matches.  */3       for (p = longopts, option_index = 0; p->name;t 	   p++, option_index++)0 	if (!strncmp (p->name, nextchar, s - nextchar)) 	  {* 	    if (s - nextchar == strlen (p->name)) 	      { 		/* Exact match found.  */m
 		pfound = p;n 		indfound = option_index; 		exact = 1; 		break; 	      } 	    else if (pfound == NULL)o 	      {$ 		/* First nonexact match found.  */
 		pfound = p;e 		indfound = option_index; 	      }	 	    elset* 	      /* Second nonexact match found.  */ 	      ambig = 1;d 	  }         if (ambig && !exact) 	{ 	  if (opterr)7 	    fprintf (stderr, "%s: option `%s' is ambiguous\n",e 		     argv[0], argv[optind]);! 	  nextchar += strlen (nextchar);r 	  optind++; 	  return '?'; 	}         if (pfound != NULL)o 	{ 	  option_index = indfound;m 	  optind++;
 	  if (*s) 	    {C 	      /* Don't test has_arg with >, because some C compilers don't $ 		 allow it to be used on enums.  */ 	      if (pfound->has_arg)o 		optarg = s + 1;  	      elseh 		{t 		  if (opterr)d 		    {G' 		      if (argv[optind - 1][1] == '-')t 			/* --option */t 			fprintf (stderr, 5 				 "%s: option `--%s' doesn't allow an argument\n",[ 				 argv[0], pfound->name); 		      else 			/* +option or -option */o 			fprintf (stderr, 8 			     "%s: option `%c%s' doesn't allow an argument\n",4 			     argv[0], argv[optind - 1][0], pfound->name); 		    }o" 		  nextchar += strlen (nextchar); 		  return '?';n 		}a 	    }! 	  else if (pfound->has_arg == 1)  	    { 	      if (optind < argc)  		optarg = argv[optind++]; 	      else  		{n 		  if (opterr) @ 		    fprintf (stderr, "%s: option `%s' requires an argument\n",# 			     argv[0], argv[optind - 1]);m" 		  nextchar += strlen (nextchar);+ 		  return optstring[0] == ':' ? ':' : '?';c 		}t 	    }! 	  nextchar += strlen (nextchar);, 	  if (longind != NULL)e 	    *longind = option_index;  	  if (pfound->flag) 	    {% 	      *(pfound->flag) = pfound->val;t 	      return 0; 	    } 	  return pfound->val; 	}J       /* Can't find it as a long option.  If this is not getopt_long_only,8 	 or the option starts with '--' or is not a valid short 	 option, then it's an error. / 	 Otherwise interpret it as a short option.  */e.       if (!long_only || argv[optind][1] == '-' #ifdef GETOPT_COMPAT 	  || argv[optind][0] == '+' #endif				/* GETOPT_COMPAT */ . 	  || my_index (optstring, *nextchar) == NULL) 	{ 	  if (opterr) 	    {" 	      if (argv[optind][1] == '-') 		/* --option */6 		fprintf (stderr, "%s: unrecognized option `--%s'\n", 			 argv[0], nextchar);  	      elser 		/* +option or -option */6 		fprintf (stderr, "%s: unrecognized option `%c%s'\n",( 			 argv[0], argv[optind][0], nextchar); 	    } 	  nextchar = (char *) ""; 	  optind++; 	  return '?'; 	}     }w  6   /* Look at and handle the next option-character.  */     {      char c = *nextchar++;d)     char *temp = my_index (optstring, c);a  J     /* Increment `optind' when we start to process its last character.  */     if (*nextchar == '\0')       ++optind;a  !     if (temp == NULL || c == ':')N       {w 	if (opterr) 	  { #if 0  	    if (c < 040 || c >= 0177)H 	      fprintf (stderr, "%s: unrecognized option, character code 0%o\n", 		       argv[0], c);o	 	    elseLG 	      fprintf (stderr, "%s: unrecognized option `-%c'\n", argv[0], c);  #elsea8 	    /* 1003.2 specifies the format of this message.  */@ 	    fprintf (stderr, "%s: illegal option -- %c\n", argv[0], c); #endif 	  } 	optopt = c; 	return '?';       }t     if (temp[1] == ':')        {m 	if (temp[2] == ':') 	  {B 	    /* This is an option that accepts an argument optionally.  */ 	    if (*nextchar != '\0')  	      { 		optarg = nextchar; 		optind++;t 	      }	 	    else  	      optarg = 0; 	    nextchar = NULL;e 	  } 	else  	  {8 	    /* This is an option that requires an argument.  */ 	    if (*nextchar != '\0')y 	      { 		optarg = nextchar;> 		/* If we end this ARGV-element by taking the rest as an arg,1 		   we must advance to the next element now.  */  		optind++;L 	      } 	    else if (optind == argc)e 	      {
 		if (opterr)p 		  {  #if 0 A 		    fprintf (stderr, "%s: option `-%c' requires an argument\n",n 			     argv[0], c); #elses9 		    /* 1003.2 specifies the format of this message.  */ A 		    fprintf (stderr, "%s: option requires an argument -- %c\n",o 			     argv[0], c); #endif 		  }g
 		optopt = c;c 		if (optstring[0] == ':') 		  c = ':'; 		else 		  c = '?'; 	      }	 	    else / 	      /* We already incremented `optind' once;p@ 		 increment it again when taking next ARGV-elt as argument.  */ 	      optarg = argv[optind++];  	    nextchar = NULL;i 	  }       }l
     return c;A   }l }n   int  getopt (argc, argv, optstring)      int argc;      char *const *argv;t      const char *optstring;* { 1   return _getopt_internal (argc, argv, optstring,l  			   (const struct option *) 0, 			   (int *) 0,	 			   0);D }r  + #endif	/* _LIBC or not __GNU_LIBRARY__.  */n p #ifdef TEST   ? /* Compile with -DTEST to make an executable for use in testing (    the above definition of `getopt'.  */   int  main (argc, argv)d      int argc;      char **argv;i {n   int c;   int digit_optind = 0;L     while (1)N     {o3       int this_option_optind = optind ? optind : 1;M  2       c = getopt (argc, argv, "abc:d:0123456789");       if (c == EOF)  	break;i         switch (c) 	{
 	case '0':
 	case '1':
 	case '2':
 	case '3':
 	case '4':
 	case '5':
 	case '6':
 	case '7':
 	case '8':
 	case '9':? 	  if (digit_optind != 0 && digit_optind != this_option_optind)t? 	    printf ("digits occur in two different argv-elements.\n");=% 	  digit_optind = this_option_optind;  	  printf ("option %c\n", c); 	 	  break;n  
 	case 'a': 	  printf ("option a\n");n	 	  break;y  
 	case 'b': 	  printf ("option b\n");o	 	  break;g  
 	case 'c':1 	  printf ("option c with value `%s'\n", optarg);O	 	  break;   
 	case '?':	 	  break;   	 	default:n< 	  printf ("?? getopt returned character code 0%o ??\n", c); 	}     }      if (optind < argc)     {o,       printf ("non-option ARGV-elements: ");       while (optind < argc)d  	printf ("%s ", argv[optind++]);       printf ("\n");     }i     exit (0);- }i   #endif /* TEST */o