< /* Makeinfo -- convert texinfo format files into info files.  @    Copyright (C) 1987, 1992, 1993 Free Software Foundation, Inc.  !    This file is part of GNU Info.   >    Makeinfo is distributed in the hope that it will be useful,>    but WITHOUT ANY WARRANTY.  No author or distributor acceptsC    responsibility to anyone for the consequences of using it or for F    whether it serves any particular purpose or works at all, unless heE    says so in writing.  Refer to the GNU Emacs General Public License     for full details.  B    Everyone is granted permission to copy, modify and redistributeE    Makeinfo, but only under the conditions described in the GNU Emacs B    General Public License.   A copy of this license is supposed toC    have been given to you along with GNU Emacs so you can know your F    rights and responsibilities.  It should be in a file named COPYING.C    Among other things, the copyright notice and this notice must be     preserved on all copies.  */   F /* This is Makeinfo version 1.55.  If you change the version number of<    Makeinfo, please change it here and at the lines reading:       int major_version = 1;     int minor_version = 55;       in the code below.   :    Makeinfo is authored by Brian Fox (bfox@ai.mit.edu). */  C /* You can change some of the behaviour of Makeinfo by changing the     following defines: */  E /* Define INDENT_PARAGRAPHS_IN_TABLE if you want the paragraphs which D    appear within an @table, @ftable, or @itemize environment to haveF    standard paragraph indentation.  Without this, such paragraphs have    no starting indentation. */( /* #define INDENT_PARAGRAPHS_IN_TABLE */  I /* Define DEFAULT_INDENTATION_INCREMENT as an integer which is the amount J    that @example should increase indentation by.  This incremement is used8    for all insertions which indent the enclosed text. */' #define DEFAULT_INDENTATION_INCREMENT 5   E /* Define PARAGRAPH_START_INDENT to be the amount of indentation that C    the first lines of paragraphs receive by default, where no other H    value has been specified.  Users can change this value on the commandG    line, with the +paragraph-indent option, or within the texinfo file, (    with the @paragraphindent command. */  #define PARAGRAPH_START_INDENT 3  I /* Define DEFAULT_PARAGRAPH_SPACING as the number of blank lines that you J    wish to appear between paragraphs.  A value of 1 creates a single blankL    line between paragraphs.  Paragraphs are defined by 2 or more consecutiveA    newlines in the input file (i.e., one or more blank lines). */ # #define DEFAULT_PARAGRAPH_SPACING 1   F /* **************************************************************** */ /*								    */, /*			Include File Declarations       	    */ /*								    */F /* **************************************************************** */  ? /* Indent #pragma so that older Cpp's don't try to parse it. */  #if defined (_AIX)  # pragma alloca #endif /* _AIX */    #include <stdio.h> #include <sys/types.h> #include <ctype.h> #include <sys/stat.h>  #include <ctype.h> #include <pwd.h> #include <errno.h> #if defined (HAVE_VARARGS_H) #include <varargs.h> #endif /* HAVE_VARARGS_H */  #include "getopt.h"    #if defined (VMS)  #include <perror.h>  #endif   #if defined (HAVE_STRING_H)  #include <string.h>  #else  #include <strings.h> #endif /* !HAVE_STRING_H */    #if defined (TM_IN_SYS_TIME) #include <sys/time.h>  #else  #include <time.h>  #endif /* !TM_IN_SYS_TIME */   #if defined (HAVE_SYS_FCNTL_H) #include <sys/fcntl.h> #else  #include <fcntl.h> #endif /* !HAVE_SYS_FCNTL_H */   #include <sys/file.h>    #if defined (__GNUC__) #define alloca __builtin_alloca  #else  #if defined(HAVE_ALLOCA_H) #include <alloca.h>  #else /* !HAVE_ALLOCA_H */ #if !defined (_AIX)  extern char *alloca ();  #endif /* !_AIX */ #endif /* !HAVE_ALLOCA_H */  #endif /* !__GNUC__ */   void *xmalloc (), *xrealloc ();   static void isolate_nodename ();  A /* Non-zero means that we are currently hacking the insides of an 3    insertion which would use a fixed width font. */ # static int in_fixed_width_font = 0;   F /* Non-zero means that start_paragraph () MUST be called before we pay0    any attention to close_paragraph () calls. */ int must_start_paragraph = 0;   8 /* Some systems don't declare this function in pwd.h. */ struct passwd *getpwnam ();     F /* **************************************************************** */ /*								    */$ /*			      Global Defines  			    */ /*								    */F /* **************************************************************** */   /* Error levels */ #define NO_ERROR 0 #define SYNTAX	 2  #define FATAL	 4  3 /* How to allocate permanent storage for STRING. */  #define savestring(x) \ B   ((char *)strcpy ((char *)xmalloc (1 + ((x) ? strlen (x) : 0)), \ 		   (x) ? (x) : ""))   I /* C's standard macros don't check to make sure that the characters being ?    changed are within range.  So I have to check explicitly. */   I /* GNU Library doesn't have toupper().  Until GNU gets this fixed, I will     have to do it. */ #ifndef toupper  #define toupper(c) ((c) - 32)  #endif  < #define coerce_to_upper(c) ((islower(c) ? toupper(c) : (c)))< #define coerce_to_lower(c) ((isupper(c) ? tolower(c) : (c)))  @ #define control_character_bit 0x40 /* %01000000, must be off. */= #define meta_character_bit 0x080/* %10000000, must be on.  */ / #define CTL(c) ((c) & (~control_character_bit)) = #define UNCTL(c) coerce_to_upper(((c)|control_character_bit)) , #define META(c) ((c) | (meta_character_bit))/ #define UNMETA(c) ((c) & (~meta_character_bit))   5 #define whitespace(c) (((c) == '\t') || ((c) == ' ')) B #define sentence_ender(c) ((c) == '.' || (c) == '?' || (c) == '!')L #define cr_or_whitespace(c) (((c) == '\t') || ((c) == ' ') || ((c) == '\n'))   #ifndef isletterN #define isletter(c) (((c) >= 'A' && (c) <= 'Z') || ((c) >= 'a' && (c) <= 'z')) #endif   #ifndef isupper - #define isupper(c) ((c) >= 'A' && (c) <= 'Z')  #endif   #ifndef isdigit . #define isdigit(c)  ((c) >= '0' && (c) <= '9') #endif   #ifndef digit_value " #define digit_value(c) ((c) - '0') #endif  , #define member(c, s) (strchr (s, c) != NULL)   #define COMMAND_PREFIX '@'  & /* Stuff for splitting large files. */L #define SPLIT_SIZE_THRESHOLD 70000  /* What's good enough for Stallman... */I #define DEFAULT_SPLIT_SIZE 50000    /* Is probably good enough for me. */ 2 int splitting = 1;		    /* Always true for now. */  : typedef int FUNCTION ();	/* So I can say FUNCTION *foo; */    F /* **************************************************************** */ /*								    */" /*			    Global Variables			    */ /*								    */F /* **************************************************************** */    /* Global pointer to argv[0]. */ char *progname;   # /* The current input file state. */  char *input_filename;  char *input_text;  int size_of_input_text;  int input_text_offset; int line_number;  / #define curchar() input_text[input_text_offset]   . #define command_char(c) ((!whitespace(c)) && \ 			 ((c) != '\n') && \ 			 ((c) != '{') && \  			 ((c) != '}') && \  			 ((c) != '='))   J #define skip_whitespace() while (input_text_offset != size_of_input_text \ 				 && whitespace(curchar()))\    input_text_offset++   K /* Return non-zero if STRING is the text at input_text + input_text_offset,     else zero. */ #define looking_at(string) \J   (strncmp (input_text + input_text_offset, string, strlen (string)) == 0)    /* And writing to the output. */   /* The output file name. */ % char *output_filename = (char *)NULL;  char *pretty_output_filename;   M /* Name of the output file that the user elected to pass on the command line. I    Such a name overrides any name found with the @setfilename command. */ - char *command_output_filename = (char *)NULL;   E /* A colon separated list of directories to search for files included N    with @include.  This can be controlled with the `-I' option to makeinfo. */( char *include_files_path = (char *)NULL;   /* Current output stream. */ FILE *output_stream;  " /* Position in the output file. */ int output_position;   /* Output paragraph buffer. */  unsigned char *output_paragraph;  # /* Offset into OUTPUT_PARAGRAPH. */r int output_paragraph_offset;  8 /* The output paragraph "cursor" horizontal position. */ int output_column = 0;  4 /* Non-zero means output_paragraph contains text. */ int paragraph_is_open = 0;  $ #define INITIAL_PARAGRAPH_SPACE 50003 int paragraph_buffer_len = INITIAL_PARAGRAPH_SPACE;y   /* Filling.. */ D /* Non-zero indicates that filling will take place on long lines. */ int filling_enabled = 1;  K /* Non-zero means that words are not to be split, even in long lines.  Thisn    gets changed for cm_w (). */o int non_splitting_words = 0;  G /* Non-zero indicates that filling a line also indents the new line. */  int indented_fill = 0;  0 /* The column at which long lines are broken. */ int fill_column = 72;   C /* The amount of indentation to apply at the start of each line. */r int current_indent = 0;t  @ /* The amount of indentation to add at the starts of paragraphs.A    0 means don't change existing indentation at paragraph starts. -    > 0 is amount to indent new paragraphs by.hH    < 0 means indent to column zero by removing indentation if necessary.  G    This is normally zero, but some people prefer paragraph starts to beaD    somewhat more indented than paragraph bodies.  A pretty value for    this is 3. */4 int paragraph_start_indent = PARAGRAPH_START_INDENT;  F /* Non-zero means that the use of paragraph_start_indent is inhibited.F    @example uses this to line up the left columns of the example text.J    A negative value for this variable is incremented each time it is used.I    @noindent uses this to inhibit indentation for a single paragraph.  */R& int inhibit_paragraph_indentation = 0;  I /* Indentation that is pending insertion.  We have this for hacking lines G    which look blank, but contain whitespace.  We want to treat those as_    blank lines. */ int pending_indent = 0;P  9 /* The amount that indentation increases/decreases by. */fB int default_indentation_increment = DEFAULT_INDENTATION_INCREMENT;  D /* Non-zero indicates that indentation is temporarily turned off. */ int no_indent = 1;  : /* Non-zero means forcing output text to be flushright. */ int force_flush_right = 0;  F /* Non-zero means that the footnote style for this document was set on;    the command line, which overrides any other settings. */w int footnote_style_preset = 0;  E /* Non-zero means that we automatically number footnotes that have no     specified marker. */  int number_footnotes = 1;l  E /* The current footnote number in this node.  Each time a new node is !    started this is reset to 1. */*  int current_footnote_number = 1;  2 /* Command name in the process of being hacked. */ char *command;  ; /* The index in our internal command table of the currently*    executing command. */ int command_index;  F /* A stack of file information records.  If a new file is read in withC    "@input", we remember the old input file state on this stack. *// typedef struct fstackp {>   struct fstack *next;   char *filename;>
   char *text;.   int size;<
   int offset;e   int line_number;	 } FSTACK;e  $ FSTACK *filestack = (FSTACK *) NULL;   /* Stuff for nodes. */" /* The current nodes node name. */" char *current_node = (char *)NULL;  & /* The current nodes section level. */ int current_section = 0;  C /* The filename of the current input file.  This is never freed. *//# char *node_filename = (char *)NULL;   % /* What we remember for each node. */e typedef struct tentryi {u   struct tentry *next_ent;'   char *node;		/* name of this node. */T3   char *prev;		/* name of "Prev:" for this node. */U3   char *next;		/* name of "Next:" for this node. */e1   char *up;		/* name of "Up:" for this node.   */*9   int position;		/* output file position of this node. */c3   int line_no;		/* defining line in source file. */*=   char *filename;	/* The file that this node was found in. */ C   int touched;		/* non-zero means this node has been referenced. */r@   int flags;		/* Room for growth.  Right now, contains 1 bit. */ } TAG_ENTRY;  J /* If node-a has a "Next" for node-b, but node-b has no "Prev" for node-a,H    we turn on this flag bit in node-b's tag entry.  This means that whenE    it is time to validate node-b, we don't report an additional error'#    if there was no "Prev" field. */  #define PREV_ERROR 0x1 #define NEXT_ERROR 0x2 #define UP_ERROR   0x4 #define NO_WARN	   0x8 #define IS_TOP 	   0x10   * TAG_ENTRY *tag_table = (TAG_ENTRY *) NULL;   #define HAVE_MACROS* #if defined (HAVE_MACROS)*2 /* Macro definitions for user-defined commands. */ typedef struct {(   char *name;			/* Name of the macro. */+   char *definition;		/* Definition text. */S:   char *filename;		/* File where this macro is defined. */2   int lineno;			/* Line number within FILENAME. */ } MACRO_DEF;  $ void add_macro (), execute_macro ();+ MACRO_DEF *find_macro (), *delete_macro ();c #endif /* HAVE_MACROS */  > /* Menu reference, *note reference, and validation hacking. */  0 /* The various references that we know about. */ enum reftype { $   menu_reference, followed_reference };  E /* A structure to remember references with.  A reference to a node is(H    either an entry in a menu, or a cross-reference made with [px]ref. */ typedef struct node_ref  {0   struct node_ref *next;/   char *node;			/* Name of node referred to. */0F   char *containing_node;	/* Name of node containing this reference. */>   int line_no;			/* Line number where the reference occurs. */@   int section;			/* Section level where the reference occurs. */A   char *filename;		/* Name of file where the reference occurs. */|C   enum reftype type;		/* Type of reference, either menu or note. */  } NODE_REF;)  ) /* The linked list of such structures. */|. NODE_REF *node_references = (NODE_REF *) NULL;  ? /* Flag which tells us whether to examine menu lines or not. */' int in_menu = 0;  5 /* Flags controlling the operation of the program. */'  0 /* Default is to notify users of bad choices. */ int print_warnings = 1;   * /* Default is to check node references. */ int validating = 1;(  D /* Non-zero means do not output "Node: Foo" for node separations. */ int no_headers = 0;F  ; /* Number of errors that we tolerate on a given fileset. */_ int max_error_level = 100;  G /* Maximum number of references to a single node before complaining. */I# int reference_warning_limit = 1000;n  F /* Non-zero means print out information about what is going on when it    is going on. */ int verbose_mode = 0;   : /* The list of commands that we hack in texinfo.  Each oneF    has an associated function.  When the command is encountered in theF    text, the associated function is called with START as the argument.F    If the function expects arguments in braces, it remembers itself onE    the stack.  When the corresponding close brace is encountered, thet2    function is called with END as the argument. */   #define START 0 
 #define END 1a   typedef struct brace_element {    struct brace_element *next;i   FUNCTION *proc;	   int pos, line; } BRACE_ELEMENT;  4 BRACE_ELEMENT *brace_stack = (BRACE_ELEMENT *) NULL;   /* Forward declarations. */   & int insert_self (), cm_ignore_line ();   int&A   cm_tex (), cm_asterisk (), cm_dots (), cm_bullet (), cm_TeX (),-A   cm_copyright (), cm_code (), cm_samp (), cm_file (), cm_kbd (),eH   cm_key (), cm_ctrl (), cm_var (), cm_dfn (), cm_emph (), cm_strong (),J   cm_cite (), cm_italic (), cm_bold (), cm_roman (), cm_title (), cm_w (),    cm_refill (), cm_titlefont ();   intr=   cm_chapter (), cm_unnumbered (), cm_appendix (), cm_top (),e8   cm_section (), cm_unnumberedsec (), cm_appendixsec (),A   cm_subsection (), cm_unnumberedsubsec (), cm_appendixsubsec (), J   cm_subsubsection (), cm_unnumberedsubsubsec (), cm_appendixsubsubsec (),J   cm_heading (), cm_chapheading (), cm_subheading (), cm_subsubheading (),?   cm_majorheading (), cm_raisesections (), cm_lowersections ();i  . /* All @defxxx commands map to cm_defun (). */ int cm_defun ();   intoN   cm_node (), cm_menu (), cm_xref (), cm_ftable (), cm_vtable (), cm_pxref (),?   cm_inforef (), cm_quotation (), cm_display (), cm_itemize (),aO   cm_enumerate (), cm_table (), cm_itemx (), cm_noindent (), cm_setfilename (),hK   cm_br (), cm_sp (), cm_page (), cm_group (), cm_center (), cm_include (),pD   cm_bye (), cm_item (), cm_end (), cm_infoinclude (), cm_ifinfo (),G   cm_kindex (), cm_cindex (), cm_findex (), cm_pindex (), cm_vindex (), J   cm_tindex (), cm_asis (), cm_synindex (), cm_printindex (), cm_minus (),D   cm_footnote (), cm_force_abbreviated_whitespace (), cm_example (),M   cm_smallexample (), cm_lisp (), cm_format (), cm_exdent (), cm_defindex (), K   cm_defcodeindex (), cm_sc (), cm_result (), cm_expansion (), cm_equiv (), F   cm_print (), cm_error (), cm_point (), cm_today (), cm_flushleft (),@   cm_flushright (), cm_smalllisp (), cm_finalout (), cm_math (),/   cm_cartouche (), cm_ignore_sentence_ender ();T   /* Conditionals. */nD int cm_set (), cm_clear (), cm_ifset (), cm_ifclear (), cm_value ();   #if defined (HAVE_MACROS)tA /* Define a user-defined command which is simple substitution. */g int cm_macro (), cm_unmacro ();  #endif /* HAVE_MACROS */   /* Options. *// int cm_paragraphindent (), cm_footnotestyle ();i   /* Internals. */- int do_nothing (), command_name_condition ();p' int misplaced_brace (), cm_obsolete ();s   typedef struct { 
   char *name;b   FUNCTION *proc;l   int argument_in_braces;n
 } COMMAND;  - /* Stuff for defining commands on the fly. */z1 COMMAND **user_command_array = (COMMAND **) NULL;  int user_command_array_len = 0;    #define NO_BRACE_ARGS 0  #define BRACE_ARGS 1  ! static COMMAND CommandTable[] = { 3   { "!", cm_ignore_sentence_ender, NO_BRACE_ARGS },e&   { "'", insert_self, NO_BRACE_ARGS },&   { "*", cm_asterisk, NO_BRACE_ARGS },3   { ".", cm_ignore_sentence_ender, NO_BRACE_ARGS },i:   { ":", cm_force_abbreviated_whitespace, NO_BRACE_ARGS },3   { "?", cm_ignore_sentence_ender, NO_BRACE_ARGS },a%   { "|", do_nothing, NO_BRACE_ARGS },e&   { "@", insert_self, NO_BRACE_ARGS },&   { " ", insert_self, NO_BRACE_ARGS },'   { "\n", insert_self, NO_BRACE_ARGS },T    { "TeX", cm_TeX, BRACE_ARGS },&   { "`", insert_self, NO_BRACE_ARGS },-   { "appendix", cm_appendix, NO_BRACE_ARGS },r7   { "appendixsection", cm_appendixsec, NO_BRACE_ARGS },c3   { "appendixsec", cm_appendixsec, NO_BRACE_ARGS },n9   { "appendixsubsec", cm_appendixsubsec, NO_BRACE_ARGS },,?   { "appendixsubsubsec", cm_appendixsubsubsec, NO_BRACE_ARGS },e"   { "asis", cm_asis, BRACE_ARGS },   { "b", cm_bold, BRACE_ARGS },a!   { "br", cm_br, NO_BRACE_ARGS }, &   { "bullet", cm_bullet, BRACE_ARGS },#   { "bye", cm_bye, NO_BRACE_ARGS }, )   { "c", cm_ignore_line, NO_BRACE_ARGS },s/   { "cartouche", cm_cartouche, NO_BRACE_ARGS },;)   { "center", cm_center, NO_BRACE_ARGS }, 3   { "chapheading", cm_chapheading, NO_BRACE_ARGS },e+   { "chapter", cm_chapter, NO_BRACE_ARGS },u)   { "cindex", cm_cindex, NO_BRACE_ARGS },A"   { "cite", cm_cite, BRACE_ARGS },'   { "clear", cm_clear, NO_BRACE_ARGS },t"   { "code", cm_code, BRACE_ARGS },/   { "comment", cm_ignore_line, NO_BRACE_ARGS },>,   { "contents", do_nothing, NO_BRACE_ARGS },,   { "copyright", cm_copyright, BRACE_ARGS },"   { "ctrl", cm_ctrl, BRACE_ARGS },5   { "defcodeindex", cm_defcodeindex, NO_BRACE_ARGS },s-   { "defindex", cm_defindex, NO_BRACE_ARGS },*    { "dfn", cm_dfn, BRACE_ARGS },   /* The `def' commands. */v'   { "deffn", cm_defun, NO_BRACE_ARGS },e(   { "deffnx", cm_defun, NO_BRACE_ARGS },'   { "defun", cm_defun, NO_BRACE_ARGS }, (   { "defunx", cm_defun, NO_BRACE_ARGS },(   { "defmac", cm_defun, NO_BRACE_ARGS },)   { "defmacx", cm_defun, NO_BRACE_ARGS },e)   { "defspec", cm_defun, NO_BRACE_ARGS },	*   { "defspecx", cm_defun, NO_BRACE_ARGS },'   { "defvr", cm_defun, NO_BRACE_ARGS },d(   { "defvrx", cm_defun, NO_BRACE_ARGS },(   { "defvar", cm_defun, NO_BRACE_ARGS },)   { "defvarx", cm_defun, NO_BRACE_ARGS },i(   { "defopt", cm_defun, NO_BRACE_ARGS },)   { "defoptx", cm_defun, NO_BRACE_ARGS }, +   { "deftypefn", cm_defun, NO_BRACE_ARGS },n,   { "deftypefnx", cm_defun, NO_BRACE_ARGS },,   { "deftypefun", cm_defun, NO_BRACE_ARGS },-   { "deftypefunx", cm_defun, NO_BRACE_ARGS },e+   { "deftypevr", cm_defun, NO_BRACE_ARGS }, ,   { "deftypevrx", cm_defun, NO_BRACE_ARGS },,   { "deftypevar", cm_defun, NO_BRACE_ARGS },-   { "deftypevarx", cm_defun, NO_BRACE_ARGS },p'   { "defcv", cm_defun, NO_BRACE_ARGS }, (   { "defcvx", cm_defun, NO_BRACE_ARGS },)   { "defivar", cm_defun, NO_BRACE_ARGS },R*   { "defivarx", cm_defun, NO_BRACE_ARGS },'   { "defop", cm_defun, NO_BRACE_ARGS },A(   { "defopx", cm_defun, NO_BRACE_ARGS },+   { "defmethod", cm_defun, NO_BRACE_ARGS },o,   { "defmethodx", cm_defun, NO_BRACE_ARGS },/   { "deftypemethod", cm_defun, NO_BRACE_ARGS }, 0   { "deftypemethodx", cm_defun, NO_BRACE_ARGS },'   { "deftp", cm_defun, NO_BRACE_ARGS },d(   { "deftpx", cm_defun, NO_BRACE_ARGS },$ /* The end of the `def' commands. */  +   { "display", cm_display, NO_BRACE_ARGS }, "   { "dots", cm_dots, BRACE_ARGS },$   { "dmn", do_nothing, BRACE_ARGS },"   { "emph", cm_emph, BRACE_ARGS },#   { "end", cm_end, NO_BRACE_ARGS },f/   { "enumerate", cm_enumerate, NO_BRACE_ARGS }, $   { "equiv", cm_equiv, BRACE_ARGS },$   { "error", cm_error, BRACE_ARGS },+   { "example", cm_example, NO_BRACE_ARGS },t)   { "exdent", cm_exdent, NO_BRACE_ARGS },e,   { "expansion", cm_expansion, BRACE_ARGS },"   { "file", cm_file, BRACE_ARGS },)   { "findex", cm_findex, NO_BRACE_ARGS },*,   { "finalout", do_nothing, NO_BRACE_ARGS },/   { "flushleft", cm_flushleft, NO_BRACE_ARGS }, 1   { "flushright", cm_flushright, NO_BRACE_ARGS },e)   { "format", cm_format, NO_BRACE_ARGS },c)   { "ftable", cm_ftable, NO_BRACE_ARGS }, '   { "group", cm_group, NO_BRACE_ARGS },n+   { "heading", cm_heading, NO_BRACE_ARGS },r0   { "headings", cm_ignore_line, NO_BRACE_ARGS },!   { "i", cm_italic, BRACE_ARGS },R.   { "iappendix", cm_appendix, NO_BRACE_ARGS },8   { "iappendixsection", cm_appendixsec, NO_BRACE_ARGS },4   { "iappendixsec", cm_appendixsec, NO_BRACE_ARGS },:   { "iappendixsubsec", cm_appendixsubsec, NO_BRACE_ARGS },@   { "iappendixsubsubsec", cm_appendixsubsubsec, NO_BRACE_ARGS },,   { "ichapter", cm_chapter, NO_BRACE_ARGS },+   { "ifclear", cm_ifclear, NO_BRACE_ARGS }, )   { "ifinfo", cm_ifinfo, NO_BRACE_ARGS },0'   { "ifset", cm_ifset, NO_BRACE_ARGS },e5   { "iftex", command_name_condition, NO_BRACE_ARGS }, 6   { "ignore", command_name_condition, NO_BRACE_ARGS },+   { "include", cm_include, NO_BRACE_ARGS }, (   { "inforef", cm_inforef, BRACE_ARGS },)   { "input", cm_include, NO_BRACE_ARGS }, ,   { "isection", cm_section, NO_BRACE_ARGS },2   { "isubsection", cm_subsection, NO_BRACE_ARGS },8   { "isubsubsection", cm_subsubsection, NO_BRACE_ARGS },%   { "item", cm_item, NO_BRACE_ARGS },a+   { "itemize", cm_itemize, NO_BRACE_ARGS },m'   { "itemx", cm_itemx, NO_BRACE_ARGS },s2   { "iunnumbered", cm_unnumbered, NO_BRACE_ARGS },8   { "iunnumberedsec", cm_unnumberedsec, NO_BRACE_ARGS },>   { "iunnumberedsubsec", cm_unnumberedsubsec, NO_BRACE_ARGS },D   { "iunnumberedsubsubsec", cm_unnumberedsubsubsec, NO_BRACE_ARGS },    { "kbd", cm_kbd, BRACE_ARGS },    { "key", cm_key, BRACE_ARGS },)   { "kindex", cm_kindex, NO_BRACE_ARGS },C7   { "lowersections", cm_lowersections, NO_BRACE_ARGS }, %   { "lisp", cm_lisp, NO_BRACE_ARGS },n'   { "macro", cm_macro, NO_BRACE_ARGS },(5   { "majorheading", cm_majorheading, NO_BRACE_ARGS },e"   { "math", cm_math, BRACE_ARGS },%   { "menu", cm_menu, NO_BRACE_ARGS },)$   { "minus", cm_minus, BRACE_ARGS },,   { "need", cm_ignore_line, NO_BRACE_ARGS },%   { "node", cm_node, NO_BRACE_ARGS },f-   { "noindent", cm_noindent, NO_BRACE_ARGS },('   { "nwnode", cm_node, NO_BRACE_ARGS },o4   { "overfullrule", cm_ignore_line, NO_BRACE_ARGS },(   { "page", do_nothing, NO_BRACE_ARGS },)   { "pindex", cm_pindex, NO_BRACE_ARGS },s$   { "point", cm_point, BRACE_ARGS },$   { "print", cm_print, BRACE_ARGS },1   { "printindex", cm_printindex, NO_BRACE_ARGS },s$   { "pxref", cm_pxref, BRACE_ARGS },/   { "quotation", cm_quotation, NO_BRACE_ARGS },*    { "r", cm_roman, BRACE_ARGS },7   { "raisesections", cm_raisesections, NO_BRACE_ARGS },n!   { "ref", cm_xref, BRACE_ARGS },v)   { "refill", cm_refill, NO_BRACE_ARGS },_&   { "result", cm_result, BRACE_ARGS },"   { "samp", cm_samp, BRACE_ARGS },   { "sc", cm_sc, BRACE_ARGS },+   { "section", cm_section, NO_BRACE_ARGS },p#   { "set", cm_set, NO_BRACE_ARGS },_9   { "setchapternewpage", cm_ignore_line, NO_BRACE_ARGS },c7   { "setchapterstyle", cm_ignore_line, NO_BRACE_ARGS },f3   { "setfilename", cm_setfilename, NO_BRACE_ARGS },)0   { "settitle", cm_ignore_line, NO_BRACE_ARGS },1   { "shortcontents", do_nothing, NO_BRACE_ARGS },w>   { "shorttitlepage", command_name_condition, NO_BRACE_ARGS },1   { "smallbook", cm_ignore_line, NO_BRACE_ARGS },d5   { "smallexample", cm_smallexample, NO_BRACE_ARGS },,/   { "smalllisp", cm_smalllisp, NO_BRACE_ARGS },i!   { "sp", cm_sp, NO_BRACE_ARGS },,&   { "strong", cm_strong, BRACE_ARGS },1   { "subheading", cm_subheading, NO_BRACE_ARGS },g1   { "subsection", cm_subsection, NO_BRACE_ARGS },n7   { "subsubheading", cm_subsubheading, NO_BRACE_ARGS },v7   { "subsubsection", cm_subsubsection, NO_BRACE_ARGS },d3   { "summarycontents", do_nothing, NO_BRACE_ARGS }, 1   { "syncodeindex", cm_synindex, NO_BRACE_ARGS }, -   { "synindex", cm_synindex, NO_BRACE_ARGS },,    { "t", cm_title, BRACE_ARGS },'   { "table", cm_table, NO_BRACE_ARGS },_3   { "tex", command_name_condition, NO_BRACE_ARGS },))   { "tindex", cm_tindex, NO_BRACE_ARGS }, ,   { "titlefont", cm_titlefont, BRACE_ARGS },9   { "titlepage", command_name_condition, NO_BRACE_ARGS },z9   { "titlespec", command_name_condition, NO_BRACE_ARGS },s$   { "today", cm_today, BRACE_ARGS },$   { "top", cm_top, NO_BRACE_ARGS  },+   { "unmacro", cm_unmacro, NO_BRACE_ARGS },!1   { "unnumbered", cm_unnumbered, NO_BRACE_ARGS }, 7   { "unnumberedsec", cm_unnumberedsec, NO_BRACE_ARGS }, =   { "unnumberedsubsec", cm_unnumberedsubsec, NO_BRACE_ARGS },RC   { "unnumberedsubsubsec", cm_unnumberedsubsubsec, NO_BRACE_ARGS }, $   { "value", cm_value, BRACE_ARGS },    { "var", cm_var, BRACE_ARGS },)   { "vindex", cm_vindex, NO_BRACE_ARGS },O)   { "vtable", cm_vtable, NO_BRACE_ARGS },A   { "w", cm_w, BRACE_ARGS },"   { "xref", cm_xref, BRACE_ARGS },&   { "{", insert_self, NO_BRACE_ARGS },&   { "}", insert_self, NO_BRACE_ARGS },      /* Some obsoleted commands. */,   { "infotop", cm_obsolete, NO_BRACE_ARGS },3   { "infounnumbered", cm_obsolete, NO_BRACE_ARGS },S6   { "infounnumberedsec", cm_obsolete, NO_BRACE_ARGS },9   { "infounnumberedsubsec", cm_obsolete, NO_BRACE_ARGS },_<   { "infounnumberedsubsubsec", cm_obsolete, NO_BRACE_ARGS },1   { "infoappendix", cm_obsolete, NO_BRACE_ARGS },R4   { "infoappendixsec", cm_obsolete, NO_BRACE_ARGS },7   { "infoappendixsubsec", cm_obsolete, NO_BRACE_ARGS },N:   { "infoappendixsubsubsec", cm_obsolete, NO_BRACE_ARGS },0   { "infochapter", cm_obsolete, NO_BRACE_ARGS },0   { "infosection", cm_obsolete, NO_BRACE_ARGS },3   { "infosubsection", cm_obsolete, NO_BRACE_ARGS }, 6   { "infosubsubsection", cm_obsolete, NO_BRACE_ARGS },  4   /* Now @include does what this was supposed to. */3   { "infoinclude", cm_infoinclude, NO_BRACE_ARGS },eA   { "footnote", cm_footnote, NO_BRACE_ARGS}, /* self-arg eater */ 7   { "footnotestyle", cm_footnotestyle, NO_BRACE_ARGS },G;   { "paragraphindent", cm_paragraphindent, NO_BRACE_ARGS },   5   {(char *) NULL, (FUNCTION *) NULL}, NO_BRACE_ARGS};f   int major_version = 1; int minor_version = 55;A   struct option long_options[] = { 4   { "error-limit", 1, 0, 'e' },			/* formerly -el */4   { "fill-column", 1, 0, 'f' },			/* formerly -fc */6   { "footnote-style", 1, 0, 's' },		/* formerly -ft */E   { "no-headers", 0, &no_headers, 1 },		/* Do not output Node: foo */NB   { "no-pointer-validate", 0, &validating, 0 }, /* formerly -nv */;   { "no-validate", 0, &validating, 0 },		/* formerly -nv */N7   { "no-split", 0, &splitting, 0 },		/* formerly -ns */,;   { "no-warn", 0, &print_warnings, 0 },		/* formerly -nw */_2   { "number-footnotes", 0, &number_footnotes, 1 },5   { "no-number-footnotes", 0, &number_footnotes, 0 },}   { "output", 1, 0, 'o' },8   { "paragraph-indent", 1, 0, 'p' },		/* formerly -pi */7   { "reference-limit", 1, 0, 'r' },		/* formerly -rl */ >   { "verbose", 0, &verbose_mode, 1 },		/* formerly -verbose */   { "version", 0, 0, 'V' },    {NULL, 0, NULL, 0} };  5 /* Values for calling handle_variable_internal (). */G
 #define SET	1y #define CLEAR	2, #define IFSET	3p #define IFCLEAR	4e  F /* **************************************************************** */ /*								    */% /*			Main ()  Start of code  		    */f /*					        		    */ F /* **************************************************************** */  C /* For each file mentioned in the command line, process it, turning >    texinfo commands into wonderfully formatted output text. */ main (argc, argv)d      int argc;      char **argv;A {    extern int errors_printed;   char *filename_part ();"
   int c, ind;B  A   /* The name of this program is the last filename in argv[0]. */c%   progname = filename_part (argv[0]);"  1   /* Parse argument flags from the input line. */E   while ((c = getopt_longp; 	  (argc, argv, "D:U:I:f:o:p:e:r:s:V", long_options, &ind))e	 	 != EOF)c     {r0       if (c == 0 && long_options[ind].flag == 0) 	c = long_options[ind].val;r         switch (c) 	{1 	  /* User specified variable to set or clear? */n
 	case 'D':
 	case 'U':? 	  handle_variable_internal ((c == 'D') ? SET : CLEAR, optarg);"	 	  break;B  * 	  /* User specified include file path? */
 	case 'I': 	  if (!include_files_path)O+ 	    include_files_path = savestring (".");,    	  include_files_path = (char *)" 	    xrealloc (include_files_path,; 		      2 + strlen (include_files_path) + strlen (optarg));f$ 	  strcat (include_files_path, ":");' 	  strcat (include_files_path, optarg);g	 	  break;n  $ 	  /* User specified fill_column? */
 	case 'f':0 	  if (sscanf (optarg, "%d", &fill_column) != 1) 	    usage ();	 	  break;p  $ 	  /* User specified output file? */
 	case 'o':1 	  command_output_filename = savestring (optarg); 	 	  break;s  A 	  /* User specified paragraph indent (paragraph_start_index)? */A
 	case 'p':) 	  if (set_paragraph_indent (optarg) < 0)s 	    usage ();	 	  break;i  $ 	  /* User specified error level? */
 	case 'e':4 	  if (sscanf (optarg, "%d", &max_error_level) != 1) 	    usage ();	 	  break;   0 	  /* User specified reference warning limit? */
 	case 'r':< 	  if (sscanf (optarg, "%d", &reference_warning_limit) != 1) 	    usage ();	 	  break;   ' 	  /* User specified footnote style? */ 
 	case 's':' 	  if (set_footnote_style (optarg) < 0)c 	    usage (); 	  footnote_style_preset = 1;m	 	  break;O  % 	  /* User requested version info? */s
 	case 'V': 	  print_version_info ();e 	  exit (NO_ERROR);i	 	  break;E  
 	case '?': 	  usage (); 	}     }_     if (optind == argc)c
     usage ();R   else if (verbose_mode)     print_version_info ();  9   /* Remaining arguments are file names of texinfo files.n!      Convert them, one by one. */B   while (optind != argc)     convert (argv[optind++]);c     if (errors_printed)i     exit (SYNTAX);   else     exit (NO_ERROR); }E  > /* Display the version info of this invocation of Makeinfo. */ print_version_info ()" {m;   fprintf (stderr, "This is GNU Makeinfo version %d.%d.\n",i" 	   major_version, minor_version); }l  F /* **************************************************************** */ /*								    */ /*			Generic Utilities			    */  /*								    */F /* **************************************************************** */  E /* Just like malloc, but kills the program in case of fatal error. */d void * xmalloc (nbytes)      int nbytes; { (   void *temp = (void *) malloc (nbytes);  %   if (nbytes && temp == (void *)NULL)f%     memory_error ("xmalloc", nbytes);      return (temp); }i  > /* Like realloc (), but barfs if there isn't enough memory. */ void * xrealloc (pointer, nbytes)      void *pointer;n      int nbytes; { 
   void *temp;m     if (!pointer)C$     temp = (void *)xmalloc (nbytes);   else-     temp = (void *)realloc (pointer, nbytes);S     if (nbytes && !temp)&     memory_error ("xrealloc", nbytes);     return (temp); }R  ) memory_error (callers_name, bytes_wanted)       char *callers_name;      int bytes_wanted; {"   char printable_string[80];     sprintf (printable_string,; 	   "Virtual memory exhausted in %s ()!  Needed %d bytes.",N  	   callers_name, bytes_wanted);     error (printable_string);h   abort ();, }_  , /* Tell the user how to use this program. */ usage () {o:   fprintf (stderr, "Usage: %s [options] texinfo-file...\n\ \n\_C This program accepts as input files of texinfo commands and text\n\ 9 and outputs a file suitable for reading with GNU Info.\n\i \n\g The options are:\n\iN `-I DIR'              to add DIR to the directory search list for including\n\;                       files with the `@include' command.\n\l> -D VAR                to define a variable, as with `@set'.\n\B -U VAR                to undefine a variable, as with `@clear'.\n\E `--no-validate'       to suppress node cross reference validation.\n\_P `--no-warn'           to suppress warning messages (errors are still output).\n\B `--no-split'          to suppress the splitting of large files.\n\E `--no-headers'        to suppress the output of Node: Foo headers.\n\_G `--verbose'           to print information about what is being done.\n\cA `--version'           to print the version number of Makeinfo.\n\  `--output FILE' or `-o FILE'\n\NJ                       to specify the output file.  When you specify the\n\K                       output file in this way, any `@setfilename' in the\n\R/                       input file is ignored.\n\t `--paragraph-indent NUM'\n\tI                       to set the paragraph indent to NUM (default %d).\n\uG `--fill-column NUM'   to set the filling column to NUM (default %d).\n\ND `--error-limit NUM'   to set the error limit to NUM (default %d).\n\ `--reference-limit NUM'\n\P                       to set the reference warning limit to NUM (default %d).\n\ `--footnote-style STYLE'\n\ J                       to set the footnote style to STYLE.  STYLE should\n\M                       either be `separate' to place footnotes in their own\n\}M                       node, or `end', to place the footnotes at the end of\n\iM                       the node in which they are defined (the default).\n\n",m% 	   progname, paragraph_start_indent,,; 	   fill_column, max_error_level, reference_warning_limit);l   exit (FATAL);S }S  F /* **************************************************************** */ /*								    */% /*			Manipulating Lists      		    */m /*					        		    */eF /* **************************************************************** */   typedef struct generic_list {e   struct generic_list *next; } GENERIC_LIST;   @ /* Reverse the chain of structures in LIST.  Output the new headC    of the chain.  You should always assign the output value of this 8    function to something, or you will lose the chain. */ GENERIC_LIST * reverse_list (list)C!      register GENERIC_LIST *list;, {_   register GENERIC_LIST *next;6   register GENERIC_LIST *prev = (GENERIC_LIST *) NULL;     while (list)     {l       next = list->next;       list->next = prev;       prev = list;       list = next;     }o   return (prev); }o    F /* **************************************************************** */ /*								    */, /*			Pushing and Popping Files       	    */ /*								    */F /* **************************************************************** */  > /* Find and load the file named FILENAME.  Return a pointer to5    the loaded file, or NULL if it can't be loaded. */f char * find_and_load (filename)      char *filename; {e   struct stat fileinfo; !   int file = -1, n, i, count = 0; 5   char *fullpath, *result, *get_file_info_in_path ();e  #   result = fullpath = (char *)NULL;d  M   fullpath = get_file_info_in_path (filename, include_files_path, &fileinfo);y     if (!fullpath)     goto error_exit;     filename = fullpath;  #   file = open (filename, O_RDONLY);f   if (file < 0)      goto error_exit;     /* Load the file. */2   result = (char *)xmalloc (1 + fileinfo.st_size);  A   /* VMS stat lies about the st_size value.  The actual number of'?      readable bytes is always less than this value.  The arcane	=      mysteries of VMS/RMS are too much to probe, so this hack,$     suffices to make things work. */ #if defined (VMS)_A   while ((n = read (file, result + count, fileinfo.st_size)) > 0)p     count += n;	   if (n == -1) #else /* !VMS */     count = fileinfo.st_size;*B     if (read (file, result, fileinfo.st_size) != fileinfo.st_size) #endif /* !VMS */ 
   error_exit:*     {*       if (result)* 	free (result);*         if (fullpath)F 	free (fullpath);n         if (file != -1)r 	close (file);         return ((char *) NULL);e     }f   close (file);e  (   /* Set the globals to the new file. */   input_text = result;   size_of_input_text = count; )   input_filename = savestring (fullpath); (   node_filename = savestring (fullpath);   input_text_offset = 0;   line_number = 1;J   /* Not strictly necessary.  This magic prevents read_token () from doingL      extra unnecessary work each time it is called (that is a lot of times).F      The SIZE_OF_INPUT_TEXT is one past the actual end of the text. */(   input_text[size_of_input_text] = '\n';   return (result); }/  / /* Save the state of the current input file. */s pushfile ()  {::   FSTACK *newstack = (FSTACK *) xmalloc (sizeof (FSTACK));&   newstack->filename = input_filename;   newstack->text = input_text;&   newstack->size = size_of_input_text;'   newstack->offset = input_text_offset; &   newstack->line_number = line_number;   newstack->next = filestack;      filestack = newstack;_   push_node_filename (); })  H /* Make the current file globals be what is on top of the file stack. */
 popfile () {k   extern int executing_string;   FSTACK *temp = filestack;      if (!filestack),5     abort ();			/* My fault.  I wonder what I did? *//  @   /* Make sure that commands with braces have been satisfied. */   if (!executing_string)     discard_braces ();  2   /* Get the top of the stack into the globals. */'   input_filename = filestack->filename;i   input_text = filestack->text;('   size_of_input_text = filestack->size;r(   input_text_offset = filestack->offset;'   line_number = filestack->line_number;      /* Pop the stack. */   filestack = filestack->next;   free (temp);   pop_node_filename ();n }o  - /* Flush all open files on the file stack. */  flush_file_stack ()  {    while (filestack)f     {        free (input_filename);       free (input_text);       popfile ();e     }  }o  " int node_filename_stack_index = 0;! int node_filename_stack_size = 0;?+ char **node_filename_stack = (char **)NULL;    push_node_filename ()b {k?   if (node_filename_stack_index + 1 > node_filename_stack_size)c     {        if (!node_filename_stack)d 	node_filename_stack =5 	  (char **)xmalloc ((node_filename_stack_size += 10)x 			    * sizeof (char *));
       else 	node_filename_stack =* 	  (char **)xrealloc (node_filename_stack,' 			     (node_filename_stack_size + 10)X 			     * sizeof (char *));R     }   A   node_filename_stack[node_filename_stack_index] = node_filename;n   node_filename_stack_index++; }s   pop_node_filename () {oC   node_filename = node_filename_stack[--node_filename_stack_index];* }*  8 /* Return just the simple part of the filename; i.e. the8    filename without the path information, or extensions."    This conses up a new string. */ char * filename_part (filename)      char *filename; {    char *basename;l  %   basename = strrchr (filename, '/');d   if (!basename)     basename = filename;   else     basename++;d  #   basename = savestring (basename); & #if defined (REMOVE_OUTPUT_EXTENSIONS)  B   /* See if there is an extension to remove.  If so, remove it. */   {a     char *temp;t  #     temp = strrchr (basename, '.');o
     if (temp)        *temp = '\0';    }i% #endif /* REMOVE_OUTPUT_EXTENSIONS */(   return (basename); }o  > /* Return the pathname part of filename.  This can be NULL. */ char * pathname_part (filename)      char *filename; {x   char *expand_filename ();n   char *result = (char *) NULL;l   register int i;t  ,   filename = expand_filename (filename, "");     i = strlen (filename) - 1;  !   while (i && filename[i] != '/')n     i--;   if (filename[i] == '/')%     i++;     if (i)     { '       result = (char *)xmalloc (1 + i); $       strncpy (result, filename, i);       result[i] = '\0';t     }h   free (filename);   return (result); }d  ' /* Return the expansion of FILENAME. */\ char *& expand_filename (filename, input_name)!      char *filename, *input_name;u {t   char *full_pathname ();n&   filename = full_pathname (filename);     if (filename[0] == '.')      return (filename);  1   if (filename[0] != '/' && input_name[0] == '/')      {e0       /* Make it so that relative names work. */       char *result;a&       int i = strlen (input_name) - 1;  M       result = (char *)xmalloc (1 + strlen (input_name) + strlen (filename));s"       strcpy (result, input_name);  #       while (result[i] != '/' && i)r 	i--;n         if (result[i] == '/')o 	i++;\  $       strcpy (&result[i], filename);       free (filename);       return (result);     }o   return (filename); }o  ' /* Return the full path to FILENAME. */  char * full_pathname (filename)      char *filename; {i   int initial_character;  2   if (filename && (initial_character = *filename))     {'#       if (initial_character == '/')y  	return (savestring (filename));#       if (initial_character != '~')t 	{" 	  return (savestring (filename)); 	}
       else 	{ 	  if (filename[1] == '/') 	    {I 	      /* Return the concatenation of HOME and the rest of the string. */h 	      char *temp_home;d 	      char *temp_name;M  , 	      temp_home = (char *) getenv ("HOME");9 	      temp_name = (char *)xmalloc (strlen (&filename[2])  					   + 1\( 					   + temp_home ? strlen (temp_home)
 					   : 0);s 	      if (temp_home)g  		strcpy (temp_name, temp_home);  ( 	      strcat (temp_name, &filename[2]); 	      return (temp_name); 	    } 	  elseY 	    {! 	      struct passwd *user_entry;b 	      int i, c;. 	      char *username = (char *)xmalloc (257); 	      char *temp_name;p  ( 	      for (i = 1; c = filename[i]; i++) 		{  		  if (c == '/')i 		    break; 		  else 		    username[i - 1] = c; 		}a
 	      if (c)t 		username[i - 1] = '\0';m  ( 	      user_entry = getpwnam (username);   	      if (!user_entry) ! 		return (savestring (filename));*  C 	      temp_name = (char *)xmalloc (1 + strlen (user_entry->pw_dir) ! 					   + strlen (&filename[i])); . 	      strcpy (temp_name, user_entry->pw_dir);( 	      strcat (temp_name, &filename[i]); 	      return (temp_name); 	    } 	}     }s   else     {E%       return (savestring (filename));t     }s }   F /* **************************************************************** */ /*								    */ /*			Error Handling				    */  /*								    */F /* **************************************************************** */  # /* Number of errors encountered. */L int errors_printed = 0;N  7 /* Print the last error gotten from the file system. */  fs_error (filename)l      char *filename; {e   remember_error ();   perror (filename);
   return (0);  }e  / /* Print an error message, and return false. */*7 #if defined (HAVE_VARARGS_H) && defined (HAVE_VFPRINTF)/   intP error (va_alist)      va_dcl	 {    char *format;    va_list args;*     remember_error ();   va_start (args);!   format = va_arg (args, char *);e"   vfprintf (stderr, format, args);   va_end (args);   fprintf (stderr, "\n");' }e  < /* Just like error (), but print the line number as well. */ int  line_error (va_alist)n      va_dcli {=   char *format;=   va_list args;l     remember_error ();   va_start (args);!   format = va_arg (args, char *);L;   fprintf (stderr, "%s:%d: ", input_filename, line_number);i"   vfprintf (stderr, format, args);   fprintf (stderr, ".\n");   va_end (args);   return ((int) 0);o }    intm warning (va_alist)      va_dcl  {    char *format;    va_list args;i     va_start (args);!   format = va_arg (args, char *);;   if (print_warnings)a     {eH       fprintf (stderr, "%s:%d: Warning: ", input_filename, line_number);&       vfprintf (stderr, format, args);       fprintf (stderr, ".\n");     },   va_end (args);   return ((int) 0);i }   . #else /* !(HAVE_VARARGS_H && HAVE_VFPRINTF) */   inte, error (format, arg1, arg2, arg3, arg4, arg5)      char *format; {-   remember_error ();9   fprintf (stderr, format, arg1, arg2, arg3, arg4, arg5);    fprintf (stderr, "\n");f   return ((int) 0);  }S  < /* Just like error (), but print the line number as well. */ int 1 line_error (format, arg1, arg2, arg3, arg4, arg5)f      char *format; {(   remember_error ();;   fprintf (stderr, "%s:%d: ", input_filename, line_number);g9   fprintf (stderr, format, arg1, arg2, arg3, arg4, arg5);o   fprintf (stderr, ".\n");   return ((int) 0);r }    intt. warning (format, arg1, arg2, arg3, arg4, arg5)      char *format; {;   if (print_warnings)      {sH       fprintf (stderr, "%s:%d: Warning: ", input_filename, line_number);=       fprintf (stderr, format, arg1, arg2, arg3, arg4, arg5);m       fprintf (stderr, ".\n");     }e   return ((int) 0);o }h  / #endif /* !(HAVE_VARARGS_H && HAVE_VFPRINTF) */;  A /* Remember that an error has been printed.  If this is the firstl@    error printed, then tell them which program is printing them.@    If more than max_error_level have been printed, then exit the    program. */ remember_error ()k {i   errors_printed++;x<   if (max_error_level && (errors_printed > max_error_level))     { 7       fprintf (stderr, "Too many errors!  Gave up.\n");t       flush_file_stack ();       cm_bye ();       exit (1);u     }i }g aF /* **************************************************************** */ /*								    */' /*			Hacking Tokens and Strings		    */f /*								    */F /* **************************************************************** */  : /* Return the next token as a string pointer.  We cons the
    string. */i char *
 read_token ()* {t   int i, character;    char *result;   D   /* If the first character to be read is self-delimiting, then that      is the command itself. */   character = curchar ();e"   if (self_delimiting (character))     {e       input_text_offset++;        result = savestring (" ");       *result = character;       return (result);     }m  8   for (i = 0; ((input_text_offset != size_of_input_text)# 	       && (character = curchar ())f% 	       && command_char (character));i!        i++, input_text_offset++); #   result = (char *)xmalloc (i + 1); 9   memcpy (result, &input_text[input_text_offset - i], i);e   result[i] = '\0';i   return (result); })  6 /* Return non-zero if CHARACTER is self-delimiting. */ int_ self_delimiting (character)c      int character;  {f1   return (member (character, "{}:.@*'`,!?; \n"));  }h  8 /* Clear whitespace from the front and end of string. */ canon_white (string)      char *string; {s   int len = strlen (string);   int x;     if (!len)      return;e     for (x = 0; x < len; x++)      {f(       if (!cr_or_whitespace (string[x])) 	{ 	  strcpy (string, string + x);_	 	  break;  	}     }n   len = strlen (string);
   if (len)
     len--;4   while (len > -1 && cr_or_whitespace (string[len]))
     len--;   string[len + 1] = '\0';t }s  @ /* Bash STRING, replacing all whitespace with just one space. */ fix_whitespace (string).      char *string; {e5   char *temp = (char *)xmalloc (strlen (string) + 1);a   int string_index = 0;*   int temp_index = 0;e   int c;     canon_white (string);b     while (string[string_index])     {e6       c = temp[temp_index++] = string[string_index++];  -       if (c == ' ' || c == '\n' || c == '\t')* 	{ 	  temp[temp_index - 1] = ' ';4 	  while ((c = string[string_index]) && (c == ' ' || 						c == '\t' || 						c == '\n'))  	    string_index++; 	}     }    temp[temp_index] = '\0';   strcpy (string, temp);   free (temp); }   A /* Discard text until the desired string is found.  The string isr%    included in the discarded text. */  discard_until (string)      char *string; { 8   int temp = search_forward (string, input_text_offset);  D   int tt = (temp < 0) ? size_of_input_text : temp + strlen (string);   int from = input_text_offset;'  %   /* Find out what line we are on. */%   while (from != tt)#     if (input_text[from++] == '\n')l       line_number++;     if (temp < 0)n     {;?       input_text_offset = size_of_input_text - strlen (string);(  %       if (strcmp (string, "\n") != 0)f 	{( 	  line_error ("Expected `%s'", string);
 	  return; 	}     }c   else     input_text_offset = temp;r  '   input_text_offset += strlen (string);h }e  7 /* Read characters from the file until we are at MATCH.e)    Place the characters read into STRING._7    On exit input_text_offset is after the match string.v0    Return the offset where the string starts. */ intt get_until (match, string)       char *match, **string;( { ,   int len, current_point, x, new_point, tem;  (   current_point = x = input_text_offset;8   new_point = search_forward (match, input_text_offset);     if (new_point < 0)#     new_point = size_of_input_text; "   len = new_point - current_point;  2   /* Keep track of which line number we are at. */)   tem = new_point + (strlen (match) - 1);u   while (x != tem)      if (input_text[x++] == '\n')       line_number++;  &   *string = (char *)xmalloc (len + 1);  4   memcpy (*string, &input_text[current_point], len);   (*string)[len] = '\0';  :   /* Now leave input_text_offset in a consistent state. */   input_text_offset = tem;  -   if (input_text_offset > size_of_input_text) +     input_text_offset = size_of_input_text;E     return (new_point);n }*  F /* Read characters from the file until we are at MATCH or end of line.-    Place the characters read into STRING.  */=! get_until_in_line (match, string)[      char *match, **string;  {p   int real_bottom, temp;  #   real_bottom = size_of_input_text;g2   temp = search_forward ("\n", input_text_offset);     if (temp < 0)m     temp = size_of_input_text;     size_of_input_text = temp;   get_until (match, string);#   size_of_input_text = real_bottom;e }m   get_rest_of_line (string)       char **string;p {    get_until ("\n", string);m   canon_white (*string);  D   if (curchar () == '\n')	/* as opposed to the end of the file... */     {        line_number++;       input_text_offset++;     }e }n  D /* Backup the input pointer to the previous character, keeping track!    of the current line number. */* backup_input_pointer ()r {t   if (input_text_offset)     {f       input_text_offset--;       if (curchar () == '\n')r 	line_number--;      }a }   H /* Read characters from the file until we are at MATCH or closing brace.-    Place the characters read into STRING.  */ # get_until_in_braces (match, string)*      char *match, **string;* {*   int i, brace = 0; !   int match_len = strlen (match); 
   char *temp;   :   for (i = input_text_offset; i < size_of_input_text; i++)     {*       if (input_text[i] == '{')n	 	brace++; $       else if (input_text[i] == '}')	 	brace--;o%       else if (input_text[i] == '\n')e 	line_number++;          if (brace < 0 ||C 	  (brace == 0 && strncmp (input_text + i, match, match_len) == 0))P 	break;r     }s  $   match_len = i - input_text_offset;)   temp = (char *)xmalloc (2 + match_len);/<   strncpy (temp, input_text + input_text_offset, match_len);   temp[match_len] = '\0';e   input_text_offset = i;   *string = temp;= }_  F /* **************************************************************** */ /*								    */% /*			Converting the File     		    */, /*								    */F /* **************************************************************** */  C /* Convert the file named by NAME.  The output is saved on the filer8    named as the argument to the @setfilename command. */ static char *suffixes[] = {    "",m
   ".texinfo",n
   ".texi",   ".txinfo",   (char *)NULL };   convert (name)      char *name; {iE   char *real_output_filename, *expand_filename (), *filename_part ();m8   char *filename = (char *)xmalloc (strlen (name) + 50);   register int i;)     init_tag_table ();   init_indices ();   init_internals ();   init_paragraph ();  J   /* Try to load the file specified by NAME.  If the file isn't found, andI      there is no suffix in NAME, then try NAME.texinfo, and NAME.texi. */    for (i = 0; suffixes[i]; i++)N     {        strcpy (filename, name);%       strcat (filename, suffixes[i]);;  #       if (find_and_load (filename))s 	break;r  5       if (!suffixes[i][0] && strrchr (filename, '.'))" 	{ 	  fs_error (filename);  	  free (filename);r
 	  return; 	}     }n     if (!suffixes[i])n     {e       fs_error (name);       free (filename);
       return;a     }      input_filename = filename;  M   /* Search this file looking for the special string which starts conversion.g'      Once found, we may truly begin. */s  9   input_text_offset = search_forward ("@setfilename", 0);r     if (input_text_offset < 0)     { #       if (!command_output_filename)n 	{3 	  error ("No `@setfilename' found in `%s'", name);i 	  goto finished;_ 	}     }    else1     input_text_offset += strlen ("@setfilename");m  &   real_output_filename = (char *)NULL;     if (!command_output_filename)/'     get_until ("\n", &output_filename);    else     {h"       if (input_text_offset != -1) 	discard_until ("\n");
       else 	input_text_offset = 0;r  G       real_output_filename = output_filename = command_output_filename;e-       command_output_filename = (char *)NULL;      }r      canon_white (output_filename);G   printf ("Making info file `%s' from `%s'.\n", output_filename, name);,     if (verbose_mode)eB     fprintf (stderr, "  The input file contains %d characters.\n", 	     size_of_input_text);     if (real_output_filename &&*.       strcmp (real_output_filename, "-") == 0)     {	       output_stream = stdout;      }*   else     {         if (!real_output_filename)@ 	real_output_filename = expand_filename (output_filename, name);  8       output_stream = fopen (real_output_filename, "w");     }n     if (output_stream == NULL)     {*&       fs_error (real_output_filename);       goto finished;     },  G   /* Make the displayable filename from output_filename.  Only the basef2      portion of the filename need be displayed. */;   pretty_output_filename = filename_part (output_filename);l  E   /* For this file only, count the number of newlines from the top ofeC      the file to here.  This way, we keep track of line numbers forfD      error reporting.  Line_number starts at 1, since the user isn't      zero-based. */h   {x     int temp = 0;      line_number = 1;%     while (temp != input_text_offset)e%       if (input_text[temp++] == '\n')) 	line_number++;-   }i     if (!no_headers)     {gN       add_word_args ("This is Info file %s, produced by Makeinfo-%d.%d from ",6 		     output_filename, major_version, minor_version);=       add_word_args ("the input file %s.\n", input_filename);r     }      close_paragraph ();n   reader_loop ();i  	 finished:;   close_paragraph ();e   flush_file_stack ();   if (output_stream != NULL)     {_       output_pending_notes ();       free_pending_notes ();       if (tag_table != NULL) 	{6 	  tag_table = (TAG_ENTRY *) reverse_list (tag_table); 	  if (!no_headers)p 	    write_tag_table (); 	}  "       if (output_stream != stdout) 	fclose (output_stream);  C       /* If validating, then validate the entire file right now. */a       if (validating)*1 	validate_file (real_output_filename, tag_table);n  /       /* This used to test  && !errors_printed. A 	 But some files might have legit warnings.  So split anyway.  */        if (splitting)& 	split_file (real_output_filename, 0);     }  }(   free_and_clear (pointer)      char **pointer; {p"   if ((*pointer) != (char *) NULL)     {t       free (*pointer);       *pointer = (char *) NULL;      }) }     /* Initialize some state. */  init_internals ()= {0!   free_and_clear (&current_node);e$   free_and_clear (&output_filename);   free_and_clear (&command);#   free_and_clear (&input_filename);s   free_node_references ();   init_insertion_stack ();   init_brace_stack ();   command_index = 0;   in_menu = 0; };   init_paragraph ()< { %   free_and_clear (&output_paragraph);tE   output_paragraph = (unsigned char *)xmalloc (paragraph_buffer_len);a   output_position = 0;   output_paragraph[0] = '\0';o   output_paragraph_offset = 0;   output_column = 0;   paragraph_is_open = 0;   current_indent = 0;u }e  B /* Okay, we are ready to start the conversion.  Call the reader onD    some text, and fill the text as it is output.  Handle commands byI    remembering things like open braces and the current file position on a)G    stack, and when the corresponding close brace is found, you can calla-    the function with the proper arguments. */t reader_loop () {i   int character;   int done = 0;r   int dash_count = 0;s     while (!done)n     {_2       if (input_text_offset >= size_of_input_text) 	{ 	  if (filestack)t 	    { 	      free (input_filename);_ 	      free (input_text);e 	      popfile (); 	    } 	  elsec 	    break;_ 	}         character = curchar ();   !       if (!in_fixed_width_font &&e- 	  (character == '\'' || character == '`') &&c2 	  input_text[input_text_offset + 1] == character) 	{ 	  input_text_offset++;  	  character = '"';  	}         if (character == '-')  	{ 	  dash_count++;/ 	  if (dash_count == 2 && !in_fixed_width_font)( 	    { 	      input_text_offset++;l 	      continue; 	    } 	}
       else 	{ 	  dash_count = 0; 	}  I       /* If this is a whitespace character, then check to see if the line 6 	 is blank.  If so, advance to the carriage return. */!       if (whitespace (character))) 	{* 	  register int i = input_text_offset + 1;  ? 	  while (i < size_of_input_text && whitespace (input_text[i])) 	 	    i++;=  8 	  if (i == size_of_input_text || input_text[i] == '\n') 	    {# 	      if (i == size_of_input_text)l 		i--;   	      input_text_offset = i;s 	      character = curchar (); 	    } 	}         if (character == '\n') 	{ 	  line_number++;i  > 	  /* Check for a menu entry here, since the "escape sequence"+ 	     that begins menu entrys is "\n* ". */_= 	  if (in_menu && input_text_offset + 1 < size_of_input_text)r 	    {+ 	      char *glean_node_from_menu (), *tem;=  > 	      /* Note that the value of TEM is discarded, since it is8 		 gauranteed to be NULL when glean_node_from_menu () is& 		 called with a non-zero argument. */& 	      tem = glean_node_from_menu (1); 	    } 	}         switch (character) 	{ 	case COMMAND_PREFIX:_ 	  read_command (); $ 	  if (strcmp (command, "bye") == 0) 	    { 	      done = 1; 	      continue; 	    }	 	  break;h  
 	case '{':  F 	  /* Special case.  I'm not supposed to see this character by itself.B 	     If I do, it means there is a syntax error in the input text.D 	     Report the error here, but remember this brace on the stack so$ 	     you can ignore its partner. */    	  line_error ("Misplaced `{'");$ 	  remember_brace (misplaced_brace);  ; 	  /* Don't advance input_text_offset since this happens in] 	     remember_brace (). 	     input_text_offset++;
            */u	 	  break;   
 	case '}': 	  pop_and_call_brace ();  	  input_text_offset++;m	 	  break;_  	 	default:  	  add_char (character); 	  input_text_offset++;f 	}     }p }(  < /* Find the command corresponding to STRING.  If the command?    is found, return a pointer to the data structure.  Otherwiseu    return (-1). */	 COMMAND *  get_command_entry (string)      char *string; {*   register int i;*  (   for (i = 0; CommandTable[i].name; i++)3     if (strcmp (CommandTable[i].name, string) == 0)*        return (&CommandTable[i]);  B   /* This command is not in our predefined command table.  Perhaps%      it is a user defined command. */d.   for (i = 0; i < user_command_array_len; i++)      if (user_command_array[i] &&5 	(strcmp (user_command_array[i]->name, string) == 0)) %       return (user_command_array[i]);   -   /* Nope, we never heard of this command. */_   return ((COMMAND *) -1); }m  > /* input_text_offset is right at the command prefix character.2    Read the next token to determine what to do. */ read_command ()r {s   COMMAND *entry;a   input_text_offset++;   free_and_clear (&command);   command = read_token ();   #if defined (HAVE_MACROS)nI   /* Check to see if this command is a macro.  If so, execute it here. */;   {N     MACRO_DEF *def;y       def = find_macro (command);i       if (def)       {  	execute_macro (def);  	return;       }k   }  #endif /* HAVE_MACROS */  &   entry = get_command_entry (command);     if ((int) entry == -1)     {)8       line_error ("Unknown info command `%s'", command);
       return;r     };      if (entry->argument_in_braces)!     remember_brace (entry->proc);f     (*(entry->proc)) (START);l }o  D /* Return the string which invokes PROC; a pointer to a function. */ char * find_proc_name (proc)n      FUNCTION *proc; {f   register int i;m  (   for (i = 0; CommandTable[i].name; i++)%     if (proc == CommandTable[i].proc)e$       return (CommandTable[i].name);   return ("NO_NAME!"); }g   init_brace_stack ()  { '   brace_stack = (BRACE_ELEMENT *) NULL;" }t   remember_brace (proc)t      FUNCTION *proc; {L   if (curchar () != '{')0     line_error ("@%s expected `{..}'", command);   else     input_text_offset++;3   remember_brace_1 (proc, output_paragraph_offset);  }e  8 /* Remember the current output position here.  Save PROC-    along with it so you can call it later. */ ! remember_brace_1 (proc, position))      FUNCTION *proc;      int position; {aJ   BRACE_ELEMENT *new = (BRACE_ELEMENT *) xmalloc (sizeof (BRACE_ELEMENT));   new->next = brace_stack;   new->proc = proc;"   new->pos = position;   new->line = line_number;   brace_stack = new; }   C /* Pop the top of the brace stack, and call the associated function=     with the args END and POS. */ pop_and_call_brace ()l {    BRACE_ELEMENT *temp;   FUNCTION *proc;r
   int pos;  ,   if (brace_stack == (BRACE_ELEMENT *) NULL)2     return (line_error ("Unmatched close brace"));     pos = brace_stack->pos;u   proc = brace_stack->proc;    temp = brace_stack->next;i   free (brace_stack);n   brace_stack = temp;M  7   return ((*proc) (END, pos, output_paragraph_offset));e }s  N /* You call discard_braces () when you shouldn't have any braces on the stack.K    I used to think that this happens for commands that don't take argumentseN    in braces, but that was wrong because of things like @code{foo @@}.  So now1    I only detect it at the beginning of nodes. */u discard_braces ()i { %   int temp_line_number = line_number;    char *proc_name;     if (!brace_stack);     return;t     while (brace_stack)e     { &       line_number = brace_stack->line;5       proc_name = find_proc_name (brace_stack->proc);d8       line_error ("@%s missing close brace", proc_name);%       line_number = temp_line_number;a       pop_and_call_brace ();     }d }o   get_char_len (character)      int character;r { 3   /* Return the printed length of the character. */ 
   int len;     switch (character)     {_     case '\t':'       len = (output_column + 8) & 0xf7;        if (len > fill_column)# 	len = fill_column - output_column;(
       else 	len = len - output_column;A       break;       case '\n':(       len = fill_column - output_column;       break;       default:       if (character < ' ')	 	len = 2;_
       else	 	len = 1;      }i   return (len);  }   7 #if defined (HAVE_VARARGS_H) && defined (HAVE_VSPRINTF)t   add_word_args (va_alist)      va_dcln {    char buffer[1000];   char *format;p   va_list args;o     va_start (args);!   format = va_arg (args, char *); "   vsprintf (buffer, format, args);   va_end (args);   add_word (buffer); }r  . #else /* !(HAVE_VARARGS_H && HAVE_VSPRINTF) */  4 add_word_args (format, arg1, arg2, arg3, arg4, arg5)      char *format; {t   char buffer[1000];9   sprintf (buffer, format, arg1, arg2, arg3, arg4, arg5);s   add_word (buffer); }r  / #endif /* !(HAVE_VARARGS_H && HAVE_VSPRINTF) */a  % /* Add STRING to output_paragraph. */e add_word (string)f      char *string; {_   while (*string)n     add_char (*string++);n }b  N /* Non-zero if the last character inserted has the syntax class of NEWLINE. */ int last_char_was_newline = 1;  G /* The actual last inserted character.  Note that this may be somethinge<    other than NEWLINE even if last_char_was_newline is 1. */  int last_inserted_character = 0;  ; /* Non-zero means that a newline character has already been==    inserted, so close_paragraph () should insert one less. */l int line_already_broken = 0;  L /* When non-zero we have finished an insertion (see end_insertion ()) and we8    want to ignore false continued paragraph closings. */# int insertion_paragraph_closed = 0;b  E /* Add the character to the current paragraph.  If filling_enabled is*(    non-zero, then do filling as well. */ add_char (character)      int character;  {h@   /* If we are avoiding outputting headers, and we are currently&      in a menu, then simply return. */   if (no_headers && in_menu)     return;   <   /* If we are adding a character now, then we don't have to1      ignore close_paragraph () calls any more. */f0   if (must_start_paragraph && character != '\n')     {a       must_start_paragraph = 0;nB       line_already_broken = 0;	/* The line is no longer broken. */)       if (current_indent > output_column)e 	{+ 	  indent (current_indent - output_column);n" 	  output_column = current_indent; 	}     }   9   if (non_splitting_words && member (character, " \t\n"))l     character = ' ' | 0x80;}  !   insertion_paragraph_closed = 0;c     switch (character)     {t     case '\n':       if (!filling_enabled)c 	{ 	  insert ('\n');    	  if (force_flush_right)) 	    { 	      close_paragraph ();? 	      /* Hack to force single blank lines out in this mode. */n 	      flush_output ();= 	    }   	  output_column = 0;t  ' 	  if (!no_indent && paragraph_is_open)i- 	    indent (output_column = current_indent);i	 	  break;f 	}>       else /* CHARACTER is newline, and filling is enabled. */ 	{0 	  if (sentence_ender (last_inserted_character)) 	    { 	      insert (' '); 	      output_column++; + 	      last_inserted_character = character;  	    } 	}          if (last_char_was_newline) 	{ 	  close_paragraph (); 	  pending_indent = 0; 	}
       else 	{ 	  last_char_was_newline = 1;f 	  insert (' '); 	  output_column++;a 	}       break;       default:       {($ 	int len = get_char_len (character); 	int suppress_insert = 0;n  3 	if ((character == ' ') && (last_char_was_newline))e 	  { 	    if (!paragraph_is_open) 	      { 		pending_indent++; 	 		return;b 	      } 	  }   	if (!paragraph_is_open) 	  { 	    start_paragraph ();  B 	    /* If the paragraph is supposed to be indented a certain way,B 	       then discard all of the pending whitespace.  Otherwise, we# 	       let the whitespace stay. */r! 	    if (!paragraph_start_indent)  	      indent (pending_indent);e 	    pending_indent = 0; 	  }  * 	if ((output_column += len) > fill_column) 	  { 	    if (filling_enabled)c 	      {% 		int temp = output_paragraph_offset; 6 		while (--temp > 0 && output_paragraph[temp] != '\n') 		  { = 		    /* If we have found a space, we have the place to breakt 		       the line. */k( 		    if (output_paragraph[temp] == ' ')	 		      {t0 			/* Remove trailing whitespace from output. */: 			while (temp && whitespace (output_paragraph[temp - 1])) 			  temp--;  # 			output_paragraph[temp++] = '\n';   5 			/* We have correctly broken the line where we want 7 			   to.  What we don't want is spaces following where07 			   we have decided to break the line.  We get rid ofe 			   them. */ 			{ 			  int t1 = temp;m   			  for (;; t1++) 			    {+ 			      if (t1 == output_paragraph_offset)P 				{ ! 				  if (whitespace (character))* 				    suppress_insert = 1; 				  break; 				} 0 			      if (!whitespace (output_paragraph[t1]))
 				break; 			    }   			  if (t1 != temp) 			    {3 			      strncpy ((char *) &output_paragraph[temp],f* 				       (char *) &output_paragraph[t1],+ 				       (output_paragraph_offset - t1));e0 			      output_paragraph_offset -= (t1 - temp); 			    } 			}  1 			/* Filled, but now indent if that is right. */a' 			if (indented_fill && current_indent)r 			  {9 			    int buffer_len = ((output_paragraph_offset - temp)S 					      + current_indent);o8 			    char *temp_buffer = (char *)xmalloc (buffer_len); 			    int indentation = 0;   2 			    /* We have to shift any markers that are in% 			       front of the wrap point. */  			    {5 			      register BRACE_ELEMENT *stack = brace_stack;m   			      while (stack) 				{) 				  if (stack->pos >= temp)k% 				    stack->pos += current_indent;  				  stack = stack->next; 				}a 			    }  # 			    while (current_indent > 0 &&o% 				   indentation != current_indent)o* 			      temp_buffer[indentation++] = ' ';  6 			    strncpy ((char *) &temp_buffer[current_indent],* 				     (char *) &output_paragraph[temp],& 				     buffer_len - current_indent);  / 			    if (output_paragraph_offset + buffer_len  				>= paragraph_buffer_len)
 			      {  				unsigned char *tt = xrealloc 				  (output_paragraph,- 				   (paragraph_buffer_len += buffer_len));b 				output_paragraph = tt;
 			      }1 			    strncpy ((char *) &output_paragraph[temp],c" 				     temp_buffer, buffer_len);1 			    output_paragraph_offset += current_indent;p 			    free (temp_buffer); 			  } 			output_column = 0;t) 			while (temp < output_paragraph_offset)t 			  output_column +=e/ 			    get_char_len (output_paragraph[temp++]);F 			output_column += len;	 			break;a	 		      }L 		  }n 	      } 	  }   	if (!suppress_insert) 	  { 	    insert (character);) 	    last_inserted_character = character;s 	  } 	last_char_was_newline = 0;m 	line_already_broken = 0;        }P     }t }o  - /* Insert CHARACTER into OUTPUT_PARAGRAPH. */o insert (character)      int character;_ {_:   output_paragraph[output_paragraph_offset++] = character;6   if (output_paragraph_offset == paragraph_buffer_len)     {        output_paragraph =< 	xrealloc (output_paragraph, (paragraph_buffer_len += 100));     }e }a  6 /* Remove upto COUNT characters of whitespace from the8    the current output line.  If COUNT is less than zero,"    then remove until none left. */ kill_self_indent (count)      int count;s {l#   /* Handle infinite case first. */    if (count < 0)     {s       output_column = 0;%       while (output_paragraph_offset)u 	{B 	  if (whitespace (output_paragraph[output_paragraph_offset - 1])) 	    output_paragraph_offset--;o 	  else  	    break;s 	}     }    else     {u0       while (output_paragraph_offset && count--)@ 	if (whitespace (output_paragraph[output_paragraph_offset - 1])) 	  output_paragraph_offset--;l 	else 	 	  break;m     }d }o  ; /* Non-zero means do not honor calls to flush_output (). */o  static int flushing_ignored = 0;  > /* Prevent calls to flush_output () from having any effect. */ inhibit_output_flushing () {)   flushing_ignored++;  }   A /* Allow calls to flush_output () to write the paragraph data. */  uninhibit_output_flushing () {a   flushing_ignored--;o }u   flush_output ()7 {    register int i;l  3   if (!output_paragraph_offset || flushing_ignored)l     return;n  /   for (i = 0; i < output_paragraph_offset; i++)      {e?       if (output_paragraph[i] == (unsigned char)(' ' | 0x80) || 9 	  output_paragraph[i] == (unsigned char)('\t' | 0x80) || 9 	  output_paragraph[i] == (unsigned char)('\n' | 0x80) ||_1 	  sentence_ender (UNMETA (output_paragraph[i])))_ 	output_paragraph[i] &= 0x7f;r     }[  G   fwrite (output_paragraph, 1, output_paragraph_offset, output_stream);=  -   output_position += output_paragraph_offset;m   output_paragraph_offset = 0; }_  C /* How to close a paragraph controlling the number of lines between      this one and the last one. */  I /* Paragraph spacing is controlled by this variable.  It is the number ofbF    blank lines that you wish to appear between paragraphs.  A value of7    1 creates a single blank line between paragraphs. */*2 int paragraph_spacing = DEFAULT_PARAGRAPH_SPACING;  G /* Close the current paragraph, leaving no blank lines between them. */n close_single_paragraph ()l { !   close_paragraph_with_lines (0);l }   5 /* Close a paragraph after an insertion has ended. */a close_insertion_paragraph () {o"   if (!insertion_paragraph_closed)     {a;       /* Close the current paragraph, breaking the line. */s        close_single_paragraph ();  L       /* Start a new paragraph here, inserting whatever indention is correctD 	 for the now current insertion level (one above the one that we are
 	 ending). */w       start_paragraph ();n  H       /* Tell close_paragraph () that the previous line has already been2 	 broken, so it should insert one less newline. */       line_already_broken = 1;  L       /* Let functions such as add_char () know that we have already found a
 	 newline. */h       ignore_blank_line ();      }    else     {oI       /* If the insertion paragraph is closed already, then we are seeing C 	 two `@end' commands in a row.  Note that the first one we saw wasaD 	 handled in the first part of this if-then-else clause, and at thatD 	 time start_paragraph () was called, partially to handle the properB 	 indentation of the current line.  However, the indentation levelD 	 may have just changed again, so we may have to outdent the current' 	 line to the new indentation level. */ )       if (current_indent < output_column)u3 	kill_self_indent (output_column - current_indent);p     }_  !   insertion_paragraph_closed = 1;l }   " close_paragraph_with_lines (lines)      int lines;s {=&   int old_spacing = paragraph_spacing;   paragraph_spacing = lines;   close_paragraph ();s"   paragraph_spacing = old_spacing; }t  ) /* Close the currently open paragraph. */  close_paragraph () {e   register int i;   4   /* The insertion paragraph is no longer closed. */!   insertion_paragraph_closed = 0;d  1   if (paragraph_is_open && !must_start_paragraph)n     {e       register int tindex, c;   '       tindex = output_paragraph_offset;n  F       /* Back up to last non-newline/space character, forcing all such< 	 subsequent characters to be newlines.  This isn't strictlyD 	 necessary, but a couple of functions use the presence of a newline 	 to make decisions. */oG       for (tindex = output_paragraph_offset - 1; tindex >= 0; --tindex)r 	{  	  c = output_paragraph[tindex];   	  if (c == ' '|| c == '\n')% 	    output_paragraph[tindex] = '\n';l 	  elsec 	    break;a 	}  /       /* All trailing whitespace is ignored. */=)       output_paragraph_offset = ++tindex;   2       /* Break the line if that is appropriate. */!       if (paragraph_spacing >= 0)  	insert ('\n');s  I       /* Add as many blank lines as is specified in PARAGRAPH_SPACING. */d       if (!force_flush_right)  	{B 	  for (i = 0; i < (paragraph_spacing - line_already_broken); i++) 	    insert ('\n');e 	}  @       /* If we are doing flush right indentation, then do it now- 	 on the paragraph (really a single line). */        if (force_flush_right) 	do_flush_right_indentation ();e         flush_output ();       paragraph_is_open = 0;       no_indent = 0;       output_column = 0;     }n   ignore_blank_line ();e }v  E /* Make the last line just read look as if it were only a newline. */  ignore_blank_line () {m!   last_inserted_character = '\n';e   last_char_was_newline = 1; }   E /* Align the end of the text in output_paragraph with fill_column. */- do_flush_right_indentation ()+ { 
   char *temp;    int temp_len;      kill_self_indent (-1);  "   if (output_paragraph[0] != '\n')     {o7       output_paragraph[output_paragraph_offset] = '\0';   0       if (output_paragraph_offset < fill_column) 	{ 	  register int i;  + 	  if (fill_column >= paragraph_buffer_len)r 	    output_paragraph =	" 	      xrealloc (output_paragraph,* 			(paragraph_buffer_len += fill_column));  0 	  temp_len = strlen ((char *)output_paragraph);) 	  temp = (char *)xmalloc (temp_len + 1);m5 	  memcpy (temp, (char *)output_paragraph, temp_len);a  > 	  for (i = 0; i < fill_column - output_paragraph_offset; i++) 	    output_paragraph[i] = ' ';e  9 	  memcpy ((char *)output_paragraph + i, temp, temp_len);  	  free (temp);l) 	  output_paragraph_offset = fill_column;	 	}     }e }i   /* Begin a new paragraph. */ start_paragraph () { !   /* First close existing one. */    if (paragraph_is_open)     close_paragraph ();u  D   /* In either case, the insertion paragraph is no longer closed. */!   insertion_paragraph_closed = 0;s  '   /* However, the paragraph is open! */o   paragraph_is_open = 1;  J   /* If we MUST_START_PARAGRAPH, that simply means that start_paragraph ()J      had to be called before we would allow any other paragraph operations      to have an effect. */   if (!must_start_paragraph)     {u       int amount_to_indent = 0;n  E       /* If doing indentation, then insert the appropriate amount. */        if (!no_indent)) 	{% 	  if (inhibit_paragraph_indentation)h 	    {) 	      amount_to_indent = current_indent; - 	      if (inhibit_paragraph_indentation < 0)p" 		inhibit_paragraph_indentation++; 	    }' 	  else if (paragraph_start_indent < 0)t' 	    amount_to_indent = current_indent;	 	  elsea@ 	    amount_to_indent = current_indent + paragraph_start_indent;  ) 	  if (amount_to_indent >= output_column)r 	    {) 	      amount_to_indent -= output_column; ! 	      indent (amount_to_indent);u) 	      output_column += amount_to_indent;  	    } 	}     }o   else     must_start_paragraph = 0;a }p  1 /* Insert the indentation specified by AMOUNT. */e indent (amount)p      int amount; {u,   register BRACE_ELEMENT *elt = brace_stack;  L   /* For every START_POS saved within the brace stack which will be affected9      by this indentation, bump that start pos forward. */w
   while (elt)m     {_.       if (elt->pos >= output_paragraph_offset) 	elt->pos += amount;       elt = elt->next;     }(     while (--amount >= 0)t     insert (' ');p }g  + /* Search forward for STRING in input_text. %    FROM says where where to start. */h search_forward (string, from)p      char *string;      int from; {r   int len = strlen (string);  #   while (from < size_of_input_text)U     {a8       if (strncmp (input_text + from, string, len) == 0) 	return (from); 
       from++;t     }o   return (-1); }   ( /* Whoops, Unix doesn't have stricmp. */  & /* Case independent string compare. */ stricmp (string1, string2)      char *string1, *string2;  {h   char ch1, ch2;  
   for (;;)     {i       ch1 = *string1++;a       ch2 = *string2++;f         if (!(ch1 | ch2))a 	return (0);  "       ch1 = coerce_to_upper (ch1);"       ch2 = coerce_to_upper (ch2);         if (ch1 != ch2)n 	return (ch1 - ch2);     }_ }a  @ enum insertion_type { menu, quotation, lisp, smalllisp, example,F   smallexample, display, itemize, format, enumerate, cartouche, table,N   ftable, vtable, group, ifinfo, flushleft, flushright, ifset, ifclear, deffn,;   defun, defmac, defspec, defvr, defvar, defopt, deftypefn,fF   deftypefun, deftypevr, deftypevar, defcv, defivar, defop, defmethod,#   deftypemethod, deftp, bad_type };*  = char *insertion_type_names[] = { "menu", "quotation", "lisp", ?   "smalllisp", "example", "smallexample", "display", "itemize",rK   "format", "enumerate", "cartouche", "table", "ftable", "vtable", "group",rC   "ifinfo", "flushleft", "flushright", "ifset", "ifclear", "deffn",n<   "defun", "defmac", "defspec", "defvr", "defvar", "defopt",@   "deftypefn", "deftypefun", "deftypevr", "deftypevar", "defcv",<   "defivar", "defop", "defmethod", "deftypemethod", "deftp",   "bad_type" };a   int insertion_level = 0; typedef struct istack_elta {    struct istack_elt *next;   char *item_function;   int line_number;   int filling_enabled;   int indented_fill;    enum insertion_type insertion;   int inhibited; } INSERTION_ELT;  8 INSERTION_ELT *insertion_stack = (INSERTION_ELT *) NULL;   init_insertion_stack ()b {h+   insertion_stack = (INSERTION_ELT *) NULL;l }s  / /* Return the type of the current insertion. */u enum insertion_types current_insertion_type ()r {a   if (!insertion_level)p     return (bad_type);   else(     return (insertion_stack->insertion); }   F /* Return a pointer to the string which is the function to wrap around    items. */ char * current_item_function () {a   register int level, done;e   register INSERTION_ELT *elt;     level = insertion_level;   elt = insertion_stack;   done = 0;t  N   /* Skip down through the stack until we find a non-conditional insertion. */   while (!done)n     {g       switch (elt->insertion)n 	{
 	case ifinfo:  	case ifset: 	case ifclear: 	case cartouche: 	  elt = elt->next;  	  level--;w	 	  break;r  	 	default:) 	  done = 1; 	}     }_  
   if (!level)      return ((char *) NULL);    else      return (elt->item_function); }n   char * get_item_function () {e   char *item_function;$   get_rest_of_line (&item_function);   backup_input_pointer ();   canon_white (item_function);   return (item_function);  }   <  /* Push the state of the current insertion on the stack. */$ push_insertion (type, item_function)      enum insertion_type type;      char *item_function;n {eJ   INSERTION_ELT *new = (INSERTION_ELT *) xmalloc (sizeof (INSERTION_ELT));  %   new->item_function = item_function;r)   new->filling_enabled = filling_enabled;o%   new->indented_fill = indented_fill;e   new->insertion = type;!   new->line_number = line_number; 1   new->inhibited = inhibit_paragraph_indentation;u   new->next = insertion_stack;   insertion_stack = new;   insertion_level++; }p  8  /* Pop the value on top of the insertion stack into the     global variables. */ pop_insertion () { (   INSERTION_ELT *temp = insertion_stack;  %   if (temp == (INSERTION_ELT *) NULL)a     return;   2   inhibit_paragraph_indentation = temp->inhibited;*   filling_enabled = temp->filling_enabled;&   indented_fill = temp->indented_fill;*   free_and_clear (&(temp->item_function));*   insertion_stack = insertion_stack->next;   free (temp);   insertion_level--; }g  .  /* Return a pointer to the print name of this     enumerated type. */a char * insertion_type_pname (type)       enum insertion_type type; {o"   if ((int) type < (int) bad_type).     return (insertion_type_names[(int) type]);   else3     return ("Broken-Type in insertion_type_pname");e }   2 /* Return the insertion_type associated with NAME.@    If the type is not one of the known ones, return BAD_TYPE. */ enum insertion_typei find_type_from_name (name)      char *name; {i   int index = 0;    while (index < (int) bad_type)     {t:       if (strcmp (name, insertion_type_names[index]) == 0)$ 	return (enum insertion_type) index;       index++;     }o   return (bad_type); }a  
 do_nothing ()0 {  }s   intn defun_insertion (type)      enum insertion_type type; {    return     ((type == deffn)      || (type == defun){      || (type == defmac)      || (type == defspec)y      || (type == defvr)r      || (type == defvar)      || (type == defopt)      || (type == deftypefn)w      || (type == deftypefun)      || (type == deftypevr)(      || (type == deftypevar)      || (type == defcv)       || (type == defivar)       || (type == defop)       || (type == defmethod)u      || (type == deftypemethod)e      || (type == deftp));M }   F /* MAX_NS is the maximum nesting level for enumerations.  I picked 100F    which seemed reasonable.  This doesn't control the number of items,&    just the number of nested lists. */ #define max_stack_depth 100  #define ENUM_DIGITS 1u #define ENUM_ALPHA  2+ typedef struct {   int enumtype;n   int enumval; } DIGIT_ALPHA;  ' DIGIT_ALPHA enumstack[max_stack_depth];o int enumstack_offset = 0;t int current_enumval = 1;# int current_enumtype = ENUM_DIGITS;f% char *enumeration_arg = (char *)NULL;    start_enumerating (at, type)      int at, type; { 0   if ((enumstack_offset + 1) == max_stack_depth)     { 0       line_error ("Enumeration stack overflow");
       return;n     } :   enumstack[enumstack_offset].enumtype = current_enumtype;8   enumstack[enumstack_offset].enumval = current_enumval;   enumstack_offset++;<   current_enumval = at;a   current_enumtype = type; }_   stop_enumerating ()  {m   --enumstack_offset;a   if (enumstack_offset < 0)      enumstack_offset = 0;u  8   current_enumval = enumstack[enumstack_offset].enumval;:   current_enumtype = enumstack[enumstack_offset].enumtype; }e  6 /* Place a letter or digits into the output stream. */ enumerate_item ()* {    char temp[10];  %   if (current_enumtype == ENUM_ALPHA)/     {eG       if (current_enumval == ('z' + 1) || current_enumval == ('Z' + 1))  	{@ 	  current_enumval = ((current_enumval - 1) == 'z' ? 'a' : 'A');E 	  warning ("Lettering overflow, restarting at %c", current_enumval);  	}.       sprintf (temp, "%c. ", current_enumval);     }t   else,     sprintf (temp, "%d. ", current_enumval);  =   indent (output_column += (current_indent - strlen (temp)));e   add_word (temp);   current_enumval++; }_  7 /* This is where the work for all the "insertion" style{9    commands is done.  A huge switch statement handles theh8    various setups, and generic code is on both sides. */ begin_insertion (type)      enum insertion_type type; {t   int no_discard = 0;      if (defun_insertion (type))      {_-       push_insertion (type, savestring (""));d       no_discard++;_     }n   else0     push_insertion (type, get_item_function ());     switch (type)      {n     case menu:       if (!no_headers) 	close_paragraph ();  &       filling_enabled = no_indent = 0;(       inhibit_paragraph_indentation = 1;         if (!no_headers) 	add_word ("* Menu:\n");         in_menu++;       no_discard++;A       break;  3       /* I think @quotation is meant to do filling.i2 	 If you don't want filling, then use @example. */     case quotation:t        close_single_paragraph ();,       last_char_was_newline = no_indent = 0;*       indented_fill = filling_enabled = 1;(       inhibit_paragraph_indentation = 1;6       current_indent += default_indentation_increment;       break;       case display:F     case example:e     case smallexample:     case lisp:     case smalllisp:r3       /* Just like @example, but no indentation. */;     case format:          close_single_paragraph ();(       inhibit_paragraph_indentation = 1;       in_fixed_width_font++;       filling_enabled = 0;        last_char_was_newline = 0;         if (type != format)*1 	current_indent += default_indentation_increment;n         break;       case table:s     case ftable:     case vtable:     case itemize:         close_single_paragraph ();6       current_indent += default_indentation_increment;*       filling_enabled = indented_fill = 1;( #if defined (INDENT_PARAGRAPHS_IN_TABLE)(       inhibit_paragraph_indentation = 0; #else (       inhibit_paragraph_indentation = 1;( #endif /* !INDENT_PARAGRAPHS_IN_TABLE */  F       /* Make things work for losers who forget the itemize syntax. */       if (type == itemize) 	{* 	  if (!(*insertion_stack->item_function)) 	    {- 	      free (insertion_stack->item_function);p? 	      insertion_stack->item_function = savestring ("@bullet");  	    } 	}       break;       case enumerate:t        close_single_paragraph ();       no_indent = 0;( #if defined (INDENT_PARAGRAPHS_IN_TABLE)(       inhibit_paragraph_indentation = 0; #elset(       inhibit_paragraph_indentation = 1;( #endif /* !INDENT_PARAGRAPHS_IN_TABLE */  6       current_indent += default_indentation_increment;*       filling_enabled = indented_fill = 1;  %       if (isdigit (*enumeration_arg))y9 	start_enumerating (atoi (enumeration_arg), ENUM_DIGITS);p
       else2 	start_enumerating (*enumeration_arg, ENUM_ALPHA);       break;  -       /* Does nothing special in makeinfo. */      case group:oI       /* Only close the paragraph if we are not inside of an @example. */m#       if (!insertion_stack->next ||i/ 	  insertion_stack->next->insertion != example)i 	close_single_paragraph ();N       break;  H       /* Insertions that are no-ops in info, but do something in TeX. */     case ifinfo:     case ifset:n     case ifclear:i     case cartouche:n       if (in_menu) 	no_discard++;       break;       case deffn:y     case defun:      case defmac:     case defspec:      case defvr:      case defvar:     case defopt:     case deftypefn:d     case deftypefun:     case deftypevr:o     case deftypevar:     case defcv:      case defivar:N     case defop:e     case defmethod:;     case deftypemethod:;     case deftp: (       inhibit_paragraph_indentation = 1;*       filling_enabled = indented_fill = 1;6       current_indent += default_indentation_increment;       no_indent = 0;       break;       case flushleft:h        close_single_paragraph ();(       inhibit_paragraph_indentation = 1;6       filling_enabled = indented_fill = no_indent = 0;       break;       case flushright:        close_single_paragraph ();6       filling_enabled = indented_fill = no_indent = 0;(       inhibit_paragraph_indentation = 1;       force_flush_right++;       break;     }n     if (!no_discard)     discard_until ("\n");h }u  4 /* Try to end the insertion with the specified TYPE.<    TYPE, with a value of bad_type,  gets translated to match+    the value currently on top of the stack.EC    Otherwise, if TYPE doesn't match the top of the insertion stack,n    give error. */  end_insertion (type)      enum insertion_type type; {e    enum insertion_type temp_type;     if (!insertion_level)n     return;n  (   temp_type = current_insertion_type ();     if (type == bad_type)n     type = temp_type;      if (type != temp_type)     {o       line_error9 	("`%cend' expected `%s', but saw `%s'.", COMMAND_PREFIX, A 	 insertion_type_pname (temp_type), insertion_type_pname (type)); 
       return;c     }      pop_insertion ();E     switch (type)e     { D       /* Insertions which have no effect on paragraph formatting. */     case ifinfo:     case ifset:t     case ifclear:e       break;       case menu:0       in_menu--;		/* No longer hacking menus. */       if (!no_headers) 	close_insertion_paragraph ();       break;       case enumerate:n       stop_enumerating ();#       close_insertion_paragraph ();p6       current_indent -= default_indentation_increment;       break;       case flushleft:u     case group:e     case cartouche: #       close_insertion_paragraph ();n       break;       case format:     case display:_     case example:h     case smallexample:     case lisp:     case smalllisp:A     case quotation:r  F       /* @quotation is the only one of the above without a fixed width
 	 font. */       if (type != quotation) 	in_fixed_width_font--;a  C       /* @format is the only fixed_width insertion without a changen 	 in indentation. */       if (type != format);1 	current_indent -= default_indentation_increment;t  ?       /* The ending of one of these insertions always marks thee 	 start of a new paragraph. */#       close_insertion_paragraph ();|       break;       case table:p     case ftable:     case vtable:     case itemize:=6       current_indent -= default_indentation_increment;       break;       case flushright:       force_flush_right--;#       close_insertion_paragraph ();        break;  E       /* Handle the @defun style insertions with a default clause. */      default:6       current_indent -= default_indentation_increment;#       close_insertion_paragraph ();e       break;     }0 }   K /* Insertions cannot cross certain boundaries, such as node beginnings.  InhK    code that creates such boundaries, you should call discard_insertions ()TK    before doing anything else.  It prints the errors for you, and cleans upa    the insertion stack. */ discard_insertions ()c {e%   int real_line_number = line_number;    while (insertion_stack)u     {n1       if (insertion_stack->insertion == ifinfo ||a) 	  insertion_stack->insertion == ifset || + 	  insertion_stack->insertion == ifclear ||e+ 	  insertion_stack->insertion == cartouche)e 	break;E
       else 	{ 	  char *offender = (char *)7 	    insertion_type_pname (insertion_stack->insertion);e  . 	  line_number = insertion_stack->line_number;H 	  line_error ("This `%s' doesn't have a matching `%cend %s'", offender," 		      COMMAND_PREFIX, offender); 	  pop_insertion (); 	}     }f!   line_number = real_line_number;  }   % /* The actual commands themselves. */m  ' /* Commands which insert themselves. */  insert_self () {=   add_word (command);f }]  ' /* Force a line break in the output. */t cm_asterisk () {t   close_single_paragraph ();% #if !defined (ASTERISK_NEW_PARAGRAPH)n   cm_noindent ();A% #endif /* ASTERISK_NEW_PARAGRAPH */  = }z   /* Insert ellipsis. */
 cm_dots (arg) 
      int arg;e {v   if (arg == START)l     add_word ("...");' }    cm_bullet (arg)i
      int arg;s {t   if (arg == START)n     add_char ('*');p }t   cm_minus (arg)
      int arg;; {    if (arg == START)i     add_char ('-');r }t   /* Insert "TeX". */( cm_TeX (arg)
      int arg;e {-   if (arg == START)      add_word ("TeX");r }_   cm_copyright (arg)
      int arg;e {r   if (arg == START)i     add_word ("(C)");  }d   cm_today (arg)
      int arg;d {    static char * months [12] =nE     { "January", "February", "March", "April", "May", "June", "July",t< 	"August", "September", "October", "November", "December" };   if (arg == START)_     {        long timer = (time (0));+       struct tm *ts = (localtime (&timer));e       add_word_args(
 	("%d %s %d",f 	 (ts -> tm_mday), 	 (months [ts -> tm_mon]), 	 ((ts -> tm_year) + 1900));     }o }p  
 cm_code (arg) 
      int arg;b {    extern int printing_index;     if (printing_index)      return;f     if (arg == START)r     {e       in_fixed_width_font++;       add_char ('`');      }a   else     {I       add_word ("'");a       in_fixed_width_font--;     }n }i  
 cm_samp (arg)e
      int arg;  {e   cm_code (arg); }l  
 cm_file (arg)a
      int arg;a {c   cm_code (arg); }i   cm_kbd (arg)
      int arg;  {i   cm_code (arg); }    cm_key (arg)
      int arg;o {  }   1 /* Convert the character at position into CTL. */; cm_ctrl (arg, position)e      int arg, position;p {e   if (arg == END)mF     output_paragraph[position - 1] = CTL (output_paragraph[position]); }t  0 /* Small Caps in makeinfo just does all caps. */ cm_sc (arg, start_pos, end_pos)i!      int arg, start_pos, end_pos;  {n   if (arg == END);     { !       while (start_pos < end_pos)a 	{  	  output_paragraph[start_pos] =3 	    coerce_to_upper (output_paragraph[start_pos]);c 	  start_pos++;  	}     }  }a  0 /* @var in makeinfo just uppercases the text. */  cm_var (arg, start_pos, end_pos)!      int arg, start_pos, end_pos;t {    if (arg == END)_     {n!       while (start_pos < end_pos)d 	{  	  output_paragraph[start_pos] =3 	    coerce_to_upper (output_paragraph[start_pos]);  	  start_pos++;  	}     }a }p   cm_dfn (arg, position)      int arg, position;_ {L   add_char ('"');k }h  
 cm_emph (arg)e
      int arg;h {t   add_char ('*');  }    cm_strong (arg, position)i      int arg, position;e {u   cm_emph (arg); }    cm_cite (arg, position)t      int arg, position;s {i   if (arg == START)o     add_word ("`");l   else     add_word ("'");a }   ! /* Current text is italicized. */i cm_italic (arg, start, end)i      int arg, start, end;D {_ }A  " /* Current text is highlighted. */ cm_bold (arg, start, end)t      int arg, start, end;n {t   cm_italic (arg); }I  $ /* Current text is in roman font. */ cm_roman (arg, start, end)      int arg, start, end;i {n }n  $ /* Current text is in roman font. */ cm_titlefont (arg, start, end)      int arg, start, end;m {t }_   /* Italicize titles. */  cm_title (arg, start, end)      int arg, start, end;; {    cm_italic (arg); }D   /* @refill is a NOP. */i cm_refill () {e }o  = /* Prevent the argument from being split across two lines. */n cm_w (arg, start, end)      int arg, start, end;i {    if (arg == START)t     non_splitting_words++;   else     non_splitting_words--; };    A /* Explain that this command is obsolete, thus the user shouldn'tX    do anything with it. */ cm_obsolete (arg, start, end)i      int arg, start, end;  {f   if (arg == START)r7     warning ("The command `@%s' is obsolete", command);  }   H /* Insert the text following input_text_offset up to the end of the lineB    in a new, separate paragraph.  Directly underneath it, insert a>    line of WITH_CHAR, the same length of the inserted text. */! insert_and_underscore (with_char)f      int with_char;f {e   int len, i, old_no_indent;   int starting_pos, ending_pos; 
   char *temp;l     close_paragraph ();l'   filling_enabled =  indented_fill = 0;n   old_no_indent = no_indent;   no_indent = 1;   get_rest_of_line (&temp);t  ;   starting_pos = output_position + output_paragraph_offset;n    execute_string ("%s\n", temp);9   ending_pos = output_position + output_paragraph_offset;a   free (temp);  (   len = (ending_pos - starting_pos) - 1;   for (i = 0; i < len; i++)      add_char (with_char);i   insert ('\n');   close_paragraph ();_   filling_enabled = 1;   no_indent = old_no_indent; })  @ /* Here is a structure which associates sectioning commands with>    an integer, hopefully to reflect the `depth' of the current    section. */ struct {
   char *name;y   int level; } section_alist[] = {    { "unnumberedsubsubsec", 5 },t   { "unnumberedsubsec", 4 },   { "unnumberedsec", 3 },t   { "unnumbered", 2 },   { "appendixsubsubsec", 5 },i   { "appendixsubsec", 4 },   { "appendixsec", 3 },e   { "appendixsection", 3 },n   { "appendix", 2 },   { "subsubsec", 5 },e   { "subsubsection", 5 },    { "subsection", 4 },   { "section", 3 },e   { "chapter", 2 },p   { "top", 1 },a     { (char *)NULL, 0 }  };  D /* Amount to offset the name of sectioning commands to levels by. */ int section_alist_offset = 0;t  0 /* Shift the meaning of @section to @chapter. */ cm_raisesections ()f {t   discard_until ("\n");    section_alist_offset--;a }i  0 /* Shift the meaning of @chapter to @section. */ cm_lowersections ()- {	   discard_until ("\n");s   section_alist_offset++;) }c  J /* Return an integer which identifies the type section present in TEXT. */ inte what_section (text)s      char *text; {    register int i, j;
   char *t;    find_section_command::   for (j = 0; text[j] && cr_or_whitespace (text[j]); j++);   if (text[j] != '@')      return (-1);     text = text + j + 1;  3   /* We skip @c, @comment, and @?index commands. */a=   if ((strncmp (text, "comment", strlen ("comment")) == 0) ||i7       (text[0] == 'c' && cr_or_whitespace (text[1])) ||o(       (strcmp (text + 1, "index") == 0))     {t       while (*text++ != '\n');        goto find_section_command;     }@  .   /* Handle italicized sectioning commands. */   if (*text == 'i')a     text++;   ;   for (j = 0; text[j] && !cr_or_whitespace (text[j]); j++);i  -   for (i = 0; t = section_alist[i].name; i++)      {o7       if (j == strlen (t) && strncmp (t, text, j) == 0)  	{ 	  int return_val;  @ 	  return_val = (section_alist[i].level + section_alist_offset);   	  if (return_val < 0) 	    return_val = 0; 	  else if (return_val > 5)n 	    return_val = 5; 	  return (return_val);  	}     }_   return (-1); }   < /* Treat this just like @unnumbered.  The only difference is    in node defaulting. */n	 cm_top ()f {t!   static int top_encountered = 0;u   cm_unnumbered ();l  2   /* It is an error to have more than one @top. */   if (top_encountered)     { !       TAG_ENTRY *tag = tag_table;r  F       line_error ("There already is a node having @top as a section");  &       while (tag != (TAG_ENTRY *)NULL) 	{ 	  if ((tag->flags & IS_TOP))e 	    {) 	      int old_line_number = line_number; 1 	      char *old_input_filename = input_filename;   " 	      line_number = tag->line_no;& 	      input_filename = tag->filename;- 	      line_error ("Here is the @top node.");o+ 	      input_filename = old_input_filename;|% 	      line_number = old_line_number;c 	      return; 	    } 	  tag = tag->next_ent;c 	}     }k   else     {        top_encountered = 1;  ;       /* The most recently defined node is the top node. */        if (tag_table) 	tag_table->flags |= IS_TOP;  C       /* Now set the logical hierarchical level of the Top node. */        {O% 	int orig_offset = input_text_offset;i  = 	input_text_offset = search_forward ("\n@node", orig_offset);T   	if (input_text_offset > 0)* 	  { 	    int this_section;  ; 	    /* Move to the end of this line, and find out what the]& 	       sectioning command is here. */2 	    while (input_text[input_text_offset] != '\n') 	      input_text_offset++;W  0 	    if (input_text_offset < size_of_input_text) 	      input_text_offset++;*  B 	    this_section = what_section (input_text + input_text_offset);  C 	    /* If we found a sectioning command, then give the top sections' 	       a level of this section - 1. */( 	    if (this_section != -1) 	      { 		register int i;   ) 		for (i = 0; section_alist[i].name; i++)s3 		  if (strcmp (section_alist[i].name, "Top") == 0)f 		    {S2 		      section_alist[i].level = this_section - 1; 		      break; 		    }  	      } 	  }! 	input_text_offset = orig_offset;        }(     }  }i  L /* Organized by level commands.  That is, "*" == chapter, "=" == section. */" char *scoring_characters = "*=-.";   void sectioning_underscore (command)e      char *command;  {f   char character;    int level;  !   level = what_section (command);t
   level -= 2;i     if (level < 0)     level = 0;  (   character = scoring_characters[level];  $   insert_and_underscore (character); }1  B /* The remainder of the text on this line is a chapter heading. */
 cm_chapter (); { %   sectioning_underscore ("@chapter");  }f  B /* The remainder of the text on this line is a section heading. */
 cm_section ()a { %   sectioning_underscore ("@section");  }   E /* The remainder of the text on this line is a subsection heading. */  cm_subsection () { (   sectioning_underscore ("@subsection"); }d  H /* The remainder of the text on this line is a subsubsection heading. */ cm_subsubsection ()a {o+   sectioning_underscore ("@subsubsection");i }i  F /* The remainder of the text on this line is an unnumbered heading. */ cm_unnumbered () {u   cm_chapter (); }o  N /* The remainder of the text on this line is an unnumbered section heading. */ cm_unnumberedsec ()s {a   cm_section (); }s  : /* The remainder of the text on this line is an unnumbered    subsection heading. */t cm_unnumberedsubsec () {t   cm_subsection ();o }=  : /* The remainder of the text on this line is an unnumbered    subsubsection heading. */ cm_unnumberedsubsubsec ()p {a   cm_subsubsection (); }r  D /* The remainder of the text on this line is an appendix heading. */ cm_appendix () {    cm_chapter (); }s  L /* The remainder of the text on this line is an appendix section heading. */ cm_appendixsec ()s {    cm_section (); }}  O /* The remainder of the text on this line is an appendix subsection heading. */" cm_appendixsubsec () {e   cm_subsection ();  }d  8 /* The remainder of the text on this line is an appendix    subsubsection heading. */ cm_appendixsubsubsec ()g {o   cm_subsubsection (); }i  C /* Compatibility functions substitute for chapter, section, etc. */_ cm_majorheading () {C   cm_chapheading (); }.   cm_chapheading ()  {r   cm_chapter (); }g  
 cm_heading ()_ {A   cm_section (); }s   cm_subheading () {l   cm_subsection ();  }    cm_subsubheading ()  {    cm_subsubsection (); }*    F /* **************************************************************** */ /*								    */, /*		   Adding nodes, and making tags		    */ /*								    */F /* **************************************************************** */   /* Start a new tag table. */ init_tag_table ()r {e)   while (tag_table != (TAG_ENTRY *) NULL)i     { "       TAG_ENTRY *temp = tag_table;       free (temp->node);       free (temp->prev);       free (temp->next);       free (temp->up);&       tag_table = tag_table->next_ent;       free (temp);     }  }e   write_tag_table () {-<   return (write_tag_table_internal (0));	/* Not indirect. */ }e   write_tag_table_indirect ()t {t(   return (write_tag_table_internal (1)); }t  4 /* Write out the contents of the existing tag table./    INDIRECT_P says how to format the output. */ % write_tag_table_internal (indirect_p)t      int indirect_p; {o   TAG_ENTRY *node = tag_table;   int old_indent = no_indent;t     no_indent = 1;   filling_enabled = 0;   must_start_paragraph = 0;t   close_paragraph ();c     if (!indirect_p)     {t       no_indent = 1;       insert ('\n');     }t  K   add_word_args ("\037\nTag Table:\n%s", indirect_p ? "(Indirect)\n" : "");n  $   while (node != (TAG_ENTRY *) NULL)     { E       add_word_args ("Node: %s\177%d\n", node->node, node->position);g       node = node->next_ent;     }r  %   add_word ("\037\nEnd Tag Table\n");e   flush_output ();   no_indent = old_indent;a }r   char * get_node_token ()  {    char *string;   #   get_until_in_line (",", &string);      if (curchar () == ',')     input_text_offset++;     canon_white (string);   %   /* Allow things like @@nodename. */_   normalize_node_name (string);r     return (string); }e  E /* Given a node name in STRING, remove double @ signs, replacing themf;    with just one.  Convert "top" and friends into "Top". */  normalize_node_name (string)      char *string; {s&   register int i, l = strlen (string);     for (i = 0; i < l; i++)      {n3       if (string[i] == '@' && string[i + 1] == '@')a 	{/ 	  strncpy (string + i, string + i + 1, l - i);a 	  l--;c 	}     }n#   if (stricmp (string, "Top") == 0)c     strcpy (string, "Top");, }}  ; /* Look up NAME in the tag table, and return the associated,>    tag_entry.  If the node is not in the table return NULL. */ TAG_ENTRY *  find_node (name)      char *name; {l   TAG_ENTRY *tag = tag_table;s  #   while (tag != (TAG_ENTRY *) NULL)c     { (       if (strcmp (tag->node, name) == 0) 	return (tag);       tag = tag->next_ent;     }    return ((TAG_ENTRY *) NULL); }t  # /* Remember NODE and associates. */-@ remember_node (node, prev, next, up, position, line_no, no_warn)#      char *node, *prev, *next, *up; $      int position, line_no, no_warn; {e0   /* Check for existence of this tag already. */   if (validating)      {;1       register TAG_ENTRY *tag = find_node (node);&       if (tag) 	{E 	  line_error ("Node `%s' multiply defined (%d is first definition)",x 		      node, tag->line_no);
 	  return; 	}     }c  *   /* First, make this the current node. */   current_node = node;     /* Now add it to the list. */_   {i@     TAG_ENTRY *new = (TAG_ENTRY *) xmalloc (sizeof (TAG_ENTRY));     new->node = node;e     new->prev = prev;o     new->next = next;;     new->up = up;n     new->position = position;n     new->line_no = line_no; "     new->filename = node_filename;0     new->touched = 0;		/* not yet referenced. */     new->flags = 0;l     if (no_warn)       new->flags |= NO_WARN;     new->next_ent = tag_table;     tag_table = new;   }; }   6 /* The order is: nodename, nextnode, prevnode, upnode.I    If all of the NEXT, PREV, and UP fields are empty, they are defaulted.vB    You must follow a node command which has those fields defaultedM    with a sectioning command (e.g. @chapter) giving the "level" of that node.c    It is an error not to do so. ;    The defaults come from the menu in this nodes parent. */m
 cm_node () {     char *node, *prev, *next, *up;:   int new_node_pos, defaulting, this_section, no_warn = 0;.   extern int already_outputting_pending_notes;  &   if (strcmp (command, "nwnode") == 0)     no_warn = 1;  D   /* Get rid of unmatched brace arguments from previous commands. */   discard_braces ();  G   /* There also might be insertions left lying around that haven't been !      ended yet.  Do that also. */n   discard_insertions ();  (   if (!already_outputting_pending_notes)     {t       close_paragraph ();f       output_pending_notes ();       free_pending_notes ();     }c  &   filling_enabled = indented_fill = 0;!   new_node_pos = output_position;    current_footnote_number = 1;     node = get_node_token ();n   next = get_node_token ();    prev = get_node_token ();b   up = get_node_token ();      no_indent = 1;   if (!no_headers)N     add_word_args ("\037\nFile: %s,  Node: %s", pretty_output_filename, node);  F   /* Check for defaulting of this node's next, prev, and up fields. */'   defaulting = ((strlen (next) == 0) &&e 		(strlen (prev) == 0) &&h 		(strlen (up) == 0));  ?   this_section = what_section (input_text + input_text_offset);i  A   /* If we are defaulting, then look at the immediately following+?      sectioning command (error if none) to determine the node'spF      level.  Find the node that contains the menu mentioning this nodeF      that is one level up (error if not found).  That node is the "Up"C      of this node.  Default the "Next" and "Prev" from the menu. */t   if (defaulting)      {{,       NODE_REF *last_ref = (NODE_REF *)NULL;&       NODE_REF *ref = node_references;         if (this_section < 0)0 	{% 	  char *polite_section_name = "top";l	 	  int i;t  * 	  for (i = 0; section_alist[i].name; i++)7 	    if (section_alist[i].level == current_section + 1)  	      {. 		polite_section_name = section_alist[i].name; 		break; 	      }  
 	  line_errorr; 	    ("Node `%s' requires a sectioning command (e.g. @%s)",a! 	     node, polite_section_name);h 	}
       else 	{" 	  if (stricmp (node, "Top") == 0) 	    {? 	      /* Default the NEXT pointer to be the first menu item inc1 		 this node, if there is a menu in this node. */d 	      { 		int orig_offset, orig_size;d  		char *glean_node_from_menu ();  " 		orig_offset = input_text_offset;7 		orig_size = search_forward ("\n@node ", orig_offset);m   		if (orig_size < 0)# 		  orig_size = size_of_input_text;s  > 		input_text_offset = search_forward ("\n@menu", orig_offset); 		if (input_text_offset > -1)s 		  {s. 		    char *nodename_from_menu = (char *)NULL;   		    input_text_offset =s3 		      search_forward ("\n* ", input_text_offset);h  " 		    if (input_text_offset != -1)6 		      nodename_from_menu = glean_node_from_menu (0);   		    if (nodename_from_menu)m	 		      {h 			free (next);n 			next = nodename_from_menu;  			prev = savestring ("(DIR)");r 			up = savestring ("(DIR)"); 	 		      }  		  }n" 		input_text_offset = orig_offset; 	      } 	    }   	  while (ref) 	    {0 	      if (ref->section == (this_section - 1) &&" 		  ref->type == menu_reference &&" 		  strcmp (ref->node, node) == 0) 		{ 1 		  char *containing_node = ref->containing_node;e   		  free (up);& 		  up = savestring (containing_node);   		  if (last_ref &&u+ 		      last_ref->type == menu_reference &&*+ 		      (strcmp (last_ref->containing_node, ! 			       containing_node) == 0))) 		    {m 		      free (next);+ 		      next = savestring (last_ref->node);  		    }s  0 		  while ((ref->section == this_section - 1) && 			 (ref->next) &&( 			 (ref->next->type != menu_reference)) 		    ref = ref->next;  3 		  if (ref->next && ref->type == menu_reference &&), 		      (strcmp (ref->next->containing_node,! 			       containing_node) == 0))i 		    {g 		      free (prev);, 		      prev = savestring (ref->next->node); 		    }i 		  else if (!ref->next &&1 			   stricmp (ref->containing_node, "Top") == 0)C 		    {a 		      free (prev);1 		      prev = savestring (ref->containing_node);a 		    } 
 		  break; 		}( 	      last_ref = ref; 	      ref = ref->next;) 	    } 	}     }h     if (!no_headers)     {c       if (*next)% 	add_word_args (",  Next: %s", next);*         if (*prev)% 	add_word_args (",  Prev: %s", prev);d         if (*up)! 	add_word_args (",  Up: %s", up);      }*     close_paragraph ();*   no_indent = 0;  
   if (!*node)/     {SG       line_error ("No node name specified for `@%s' command", command);T       free (node);       free (next);       free (prev);       free (up);     }e   else     {(7       if (!*next) { free (next); next = (char *)NULL; }>7       if (!*prev) { free (prev); prev = (char *)NULL; }(1       if (!*up) { free (up); up = (char *)NULL; }uO       remember_node (node, prev, next, up, new_node_pos, line_number, no_warn);i     }t  B   /* Change the section only if there was a sectioning command. */   if (this_section >= 0)#     current_section = this_section;      filling_enabled = 1; }_   /* Validation of an info file.F    Scan through the list of tag entrys touching the Prev, Next, and UpI    elements of each.  It is an error not to be able to touch one of them,pC    except in the case of external node references, such as "(DIR)".   (    If the Prev is different from the Up,=    then the Prev node must have a Next pointing at this node.   )    Every node except Top must have an Up.AF    The Up node must contain some sort of reference, other than a Next,    to this node.  4    If the Next is different from the Next of the Up,@    then the Next node must have a Prev pointing at this node. */# validate_file (filename, tag_table)t      char *filename;      TAG_ENTRY *tag_table; { ,   char *old_input_filename = input_filename;   TAG_ENTRY *tags = tag_table;  $   while (tags != (TAG_ENTRY *) NULL)     {@#       register TAG_ENTRY *temp_tag;   &       input_filename = tags->filename;"       line_number = tags->line_no;  F       /* If this is a "no warn" node, don't validate it in any way. */        if (tags->flags & NO_WARN) 	{ 	  tags = tags->next_ent;r 	  continue; 	} 	iI       /* If this node has a Next, then make sure that the Next exists. */(       if (tags->next)i 	{0 	  validate (tags->next, tags->line_no, "Next");  < 	  /* If the Next node exists, and there is no Up, then make4 	     sure that the Prev of the Next points back. */) 	  if (temp_tag = find_node (tags->next))t 	    { 	      char *prev;  % 	      if (temp_tag->flags & NO_WARN)  		{ 9 		  /* Do nothing if we aren't supposed to issue warnings  		     about this node. */ 		}  	      else  		{E 		  prev = temp_tag->prev;2 		  if (!prev || (strcmp (prev, tags->node) != 0)) 		    {aA 		      line_error ("Node `%s''s Next field not pointed back to",* 				  tags->node);( 		      line_number = temp_tag->line_no;, 		      input_filename = temp_tag->filename; 		      line_error6 			("This node (`%s') is the one with the bad `Prev'", 			 temp_tag->node);( 		      input_filename = tags->filename;$ 		      line_number = tags->line_no;& 		      temp_tag->flags |= PREV_ERROR; 		    }l 		}r 	    } 	}  H       /* Validate the Prev field if there is one, and we haven't alreadyA 	 complained about it in some way.  You don't have to have a Preve 	 field at this stage. */;4       if (!(tags->flags & PREV_ERROR) && tags->prev) 	{< 	  int valid = validate (tags->prev, tags->line_no, "Prev");   	  if (!valid) 	    tags->flags |= PREV_ERROR;  	  else  	    {< 	      /* If the Prev field is not the same as the Up field,7 		 then the node pointed to by the Prev field must havet- 		 a Next field which points to this node. */-< 	      if (tags->up && (strcmp (tags->prev, tags->up) != 0)) 		{e& 		  temp_tag = find_node (tags->prev);  8 		  /* If we aren't supposed to issue warnings about the" 		     target node, do nothing. */1 		  if (!temp_tag || (temp_tag->flags & NO_WARN))d 		    {u 		      /* Do nothing. */  		    }  		  else 		    {t 		      if (!temp_tag->next ||0 			  (strcmp (temp_tag->next, tags->node) != 0)) 			{ 			  line_error 5 			    ("Node `%s''s Prev field not pointed back to",n 			     tags->node);% 			  line_number = temp_tag->line_no; ) 			  input_filename = temp_tag->filename;s 			  line_error : 			    ("This node (`%s') is the one with the bad `Next'", 			     temp_tag->node);% 			  input_filename = tags->filename;d! 			  line_number = tags->line_no;p# 			  temp_tag->flags |= NEXT_ERROR;s 			} 		    }e 		}s 	    } 	}  :       if (!tags->up && (stricmp (tags->node, "Top") != 0))A 	line_error ("Node `%s' is missing an \"Up\" field", tags->node);t       else if (tags->up) 	{8 	  int valid = validate (tags->up, tags->line_no, "Up");  C 	  /* If node X has Up: Y, then warn if Y fails to have a menu itemd= 	     or note pointing at X, if Y isn't of the form "(Y)". */o! 	  if (valid && *tags->up != '(')_ 	    {$ 	      NODE_REF *nref, *tref, *list;( 	      NODE_REF *find_node_reference ();    	      tref = (NODE_REF *) NULL; 	      list = node_references;   	      for (;;)  		{:9 		  if (!(nref = find_node_reference (tags->node, list)))u 		    break;  6 		  if (strcmp (nref->containing_node, tags->up) == 0) 		    {)) 		      if (nref->type != menu_reference)s 			{ 			  tref = nref;h 			  list = nref->next;  			} 		      else	 			break;) 		    }* 		  list = nref->next; 		}o   	      if (!nref)  		{w$ 		  temp_tag = find_node (tags->up);$ 		  line_number = temp_tag->line_no;" 		  filename = temp_tag->filename; 		  if (!tref) 		    line_error (C "`%s' has an Up field of `%s', but `%s' has no menu item for `%s'", 0 				tags->node, tags->up, tags->up, tags->node);  		  line_number = tags->line_no; 		  filename = tags->filename; 		}= 	    } 	}       tags = tags->next_ent;     }f  .   validate_other_references (node_references);C   /* We have told the user about the references which didn't exist.i=      Now tell him about the nodes which aren't referenced. */e     tags = tag_table; $   while (tags != (TAG_ENTRY *) NULL)     {n9       /* If this node is a "no warn" node, do nothing. */'        if (tags->flags & NO_WARN) 	{ 	  tags = tags->next_ent;s 	  continue; 	}  ?       /* Special hack.  If the node in question appears to have A          been referenced more than REFERENCE_WARNING_LIMIT times,           give a warning. */h2       if (tags->touched > reference_warning_limit) 	{# 	  input_filename = tags->filename;	 	  line_number = tags->line_no; 5 	  warning ("Node `%s' has been referenced %d times",m  		   tags->node, tags->touched); 	}         if (tags->touched == 0)u 	{# 	  input_filename = tags->filename;, 	  line_number = tags->line_no;o  @ 	  /* Notice that the node "Top" is special, and doesn't have to 	     be referenced. */e( 	  if (stricmp (tags->node, "Top") != 0)4 	    warning ("Unreferenced node `%s'", tags->node); 	}       tags = tags->next_ent;     }_&   input_filename = old_input_filename; }e  7 /* Return 1 if tag correctly validated, or 0 if not. */_ validate (tag, line, label)(      char *tag;       int line;      char *label;  {	   TAG_ENTRY *result;  F   /* If there isn't a tag to verify, or if the tag is in another file,      then it must be okay. */-#   if (!tag || !*tag || *tag == '(')c     return (1);(  &   /* Otherwise, the tag must exist. */   result = find_node (tag);n     if (!result)     {;       line_number = line;a       line_error (I "Validation error.  `%s' field points to node `%s', which doesn't exist",r 		  label, tag);       return (0);      }o   result->touched++;
   return (1);  }   F /* Split large output files into a series of smaller files.  Each fileE    is pointed to in the tag table, which then gets written out as the H    original file.  The new files have the same name as the original fileH    with a "-num" attached.  SIZE is the largest number of bytes to allow    in any single split file. */i split_file (filename, size)	      char *filename;      int size; {r&   char *root_filename, *root_pathname;$   char *the_file, *filename_part ();   struct stat fileinfo;"   char *the_header;	   int header_size;  2   /* Can only do this to files with tag tables. */   if (!tag_table)      return;l     if (size == 0)     size = DEFAULT_SPLIT_SIZE;  *   if ((stat (filename, &fileinfo) != 0) ||0       (fileinfo.st_size < SPLIT_SIZE_THRESHOLD))     return;(  &   the_file = find_and_load (filename);   if (!the_file)     return;r  +   root_filename = filename_part (filename);a+   root_pathname = pathname_part (filename);e     if (!root_pathname)r$     root_pathname = savestring ("");  8   /* Start splitting the file.  Walk along the tag table;      outputting sections of the file.  When we have written(:      all of the nodes in the tag table, make the top-level7      pointer file, which contains indirect pointers and       tags for the nodes. */u   {c     int which_file = 1;e      TAG_ENTRY *tags = tag_table;'     char *indirect_info = (char *)NULL;   H     /* Remember the `header' of this file.  The first tag in the file isE        the bottom of the header; the top of the file is the start. */nF     the_header = (char *)xmalloc (1 + (header_size = tags->position));/     memcpy (the_header, the_file, header_size);        while (tags)       {i 	int file_top, file_bot, limit;h  % 	/* Have to include the Control-_. */e& 	file_top = file_bot = tags->position; 	limit = file_top + size;f  3 	/* If the rest of this file is only one node, thene" 	   that is the entire subfile. */ 	if (!tags->next_ent)  	  {  	    int i = tags->position + 1;" 	    char last_char = the_file[i];  ! 	    while (i < fileinfo.st_size)h 	      {  		if ((the_file[i] == '\037') && 		    ((last_char == '\n') ||v 		     (last_char == '\014')))
 		  break; 		else 		  last_char = the_file[i]; 		i++; 	      } 	    file_bot = i; 	    tags = tags->next_ent;e 	    goto write_region;  	  }  ? 	/* Otherwise, find the largest number of nodes that can fit in  	   this subfile. */$ 	for (; tags; tags = tags->next_ent) 	  { 	    if (!tags->next_ent)e 	      {= 		/* This entry is the last node.  Search forward for the enda> 	           of this node, and that is the end of this file. */ 		int i = tags->position + 1;c 		char last_char = the_file[i];s   		while (i < fileinfo.st_size) 		  { $ 		    if ((the_file[i] == '\037') && 			((last_char == '\n') || 			 (last_char == '\014')))  		      break;
 		    else  		      last_char = the_file[i];
 		    i++; 		  }h 		file_bot = i;t   		if (file_bot < limit)m 		  {  		    tags = tags->next_ent; 		    goto write_region; 		  }i 		else 		  {a= 		    /* Here we want to write out everything before the lasto9 		       node, and then write the last node out in a filee 		       by itself. */  		    file_bot = tags->position; 		    goto write_region; 		  }  	      }  * 	    if (tags->next_ent->position > limit) 	      {! 		if (tags->position == file_top)  		  tags = tags->next_ent;   		file_bot = tags->position;   	      write_region: 		{  		  int fd;  		  char *split_filename;e  % 		  split_filename = (char *) xmalloc>= 		    (10 + strlen (root_pathname) + strlen (root_filename));n 		  sprintf> 		    (split_filename,< 		     "%s%s-%d", root_pathname, root_filename, which_file);  
 		  fd = openr; 		    (split_filename, O_WRONLY | O_TRUNC | O_CREAT, 0666);d   		  if ((fd < 0) || ? 		      (write (fd, the_header, header_size) != header_size) || = 		      (write (fd, the_file + file_top, file_bot - file_top)d% 		       != (file_bot - file_top)) ||  		      ((close (fd)) < 0))  		    {f  		      perror (split_filename); 		      if (fd != -1)P 			close (fd); 		      exit (FATAL);l 		    }e   		  if (!indirect_info)e 		    {l, 		      indirect_info = the_file + file_top;5 		      sprintf (indirect_info, "\037\nIndirect:\n");r0 		      indirect_info += strlen (indirect_info); 		    }>  * 		  sprintf (indirect_info, "%s-%d: %d\n",+ 			   root_filename, which_file, file_top);n   		  free (split_filename);, 		  indirect_info += strlen (indirect_info); 		  which_file++;.
 		  break; 		}	 	      } 	  }       }   C     /* We have sucessfully created the subfiles.  Now write out the)7        original again.  We must use `output_stream', or K        write_tag_table_indirect () won't know where to place the output. */n*     output_stream = fopen (filename, "w");     if (!output_stream)        {T 	perror (filename);e 	exit (FATAL);       },       { .       int distance = indirect_info - the_file;4       fwrite (the_file, 1, distance, output_stream);         /* Inhibit newlines. */}       paragraph_is_open = 0;  "       write_tag_table_indirect ();       fclose (output_stream);r       free (the_header);       free (the_file);
       return;      }    }- })  E /* Some menu hacking.  This is used to remember menu references whilefF    reading the input file.  After the output file has been written, ifE    validation is on, then we use the contents of NODE_REFERENCES as at     list of nodes to validate. */ char * reftype_type_string (type)      enum reftype type;r {e   switch (type)e     {D     case menu_reference:       return ("Menu");     case followed_reference:$       return ("Followed-Reference");     default:-       return ("Internal-bad-reference-type");i     }, }g  7 /* Remember this node name for later validation use. */r* remember_node_reference (node, line, type)      char *node;      int line;      enum reftype type;	 {i<   NODE_REF *temp = (NODE_REF *) xmalloc (sizeof (NODE_REF));     temp->next = node_references;e!   temp->node = savestring (node);i   temp->line_no = line;m"   temp->section = current_section;   temp->type = type;4   temp->containing_node = savestring (current_node);!   temp->filename = node_filename;a     node_references = temp;  }s  $ validate_other_references (ref_list)!      register NODE_REF *ref_list;t {-,   char *old_input_filename = input_filename;  '   while (ref_list != (NODE_REF *) NULL)h     {a*       input_filename = ref_list->filename;2       validate (ref_list->node, ref_list->line_no,( 		reftype_type_string (ref_list->type));        ref_list = ref_list->next;     } &   input_filename = old_input_filename; }o   /* Find NODE in REF_LIST. */
 NODE_REF *$ find_node_reference (node, ref_list)      char *node;!      register NODE_REF *ref_list;n {e   while (ref_list)     { -       if (strcmp (node, ref_list->node) == 0)G 	break;m        ref_list = ref_list->next;     }    return (ref_list); }e   free_node_references ()i {t!   register NODE_REF *list, *temp;n     list = node_references;      while (list)     {b       temp = list;       free (list->node);#       free (list->containing_node);>       list = list->next;       free (temp);     }e&   node_references = (NODE_REF *) NULL; }/  I   /* This function gets called at the start of every line while inside ofnG      a menu.  It checks to see if the line starts with "* ", and if so,r;      remembers the node reference that this menu refers to.nB      input_text_offset is at the \n just before the line start. */ #define menu_starter "* "d char *) glean_node_from_menu (remember_reference)       int remember_reference; { )   int i, orig_offset = input_text_offset;    char *nodename;'  2   if (strncmp (&input_text[input_text_offset + 1], 	       menu_starter,a$ 	       strlen (menu_starter)) != 0)     return ((char *)NULL);   else3     input_text_offset += strlen (menu_starter) + 1;(  %   get_until_in_line (":", &nodename);i   if (curchar () == ':')     input_text_offset++;   canon_white (nodename);o     if (curchar () == ':')     goto save_node;g     free (nodename);   get_rest_of_line (&nodename);   >   /* Special hack: If the nodename follows the menu item name,?      then we have to read the rest of the line in order to findh=      out what the nodename is.  But we still have to read thesA      line later, in order to process any formatting commands that.E      might be present.  So un-count the carriage return that has justf      been counted. */i   line_number--;     isolate_nodename (nodename);  
 save_node:"   input_text_offset = orig_offset;!   normalize_node_name (nodename);    i = strlen (nodename);"   if (i && nodename[i - 1] == ':')     nodename[i - 1] = '\0';o     if (remember_reference)      {gF       remember_node_reference (nodename, line_number, menu_reference);       free (nodename);       return ((char *)NULL);     }i   else     return (nodename); })   static void  isolate_nodename (nodename)(      char *nodename; {l   register int i, c;   int paren_seen, paren;     if (!nodename)     return;      canon_white (nodename);    paren_seen = paren = i = 0;o  %   if (*nodename == '.' || !*nodename)a     {t       *nodename = '\0';g
       return;      }t     if (*nodename == '(')e     {        paren++;       paren_seen++;e
       i++;     }      for (; c = nodename[i]; i++)     {i       if (paren) 	{ 	  if (c == '(')
 	    paren++;o 	  else if (c == ')') 
 	    paren--;e   	  continue; 	}  I       /* If the character following the close paren is a space, then thish4 	 node has no more characters associated with it. */       if (c == '\t' || 	  c == '\n' ||p 	  c == ','  ||h- 	  ((paren_seen && nodename[i - 1] == ')') &&( 	   (c == ' ' || c == '.')) || 	  (c == '.' &&( 	   ((!nodename[i + 1] ||r- 	     (cr_or_whitespace (nodename[i + 1])) ||l" 	     (nodename[i + 1] == ')'))))) 	break;d     }o   nodename[i] = '\0';  }i  
 cm_menu () {s   begin_insertion (menu);  }e    F /* **************************************************************** */ /*								    */% /*			Cross Reference Hacking			    */t /*								    */F /* **************************************************************** */   char * get_xref_token ()e {l   char *string;&  %   get_until_in_braces (",", &string);(   if (curchar () == ',')     input_text_offset++;   fix_whitespace (string);   return (string); }o  ; int px_ref_flag = 0;		/* Controls initial output string. */    /* Make a cross reference. */a
 cm_xref (arg)  {e   if (arg == START)      {s-       char *arg1, *arg2, *arg3, *arg4, *arg5;)         arg1 = get_xref_token ();        arg2 = get_xref_token ();l       arg3 = get_xref_token ();        arg4 = get_xref_token ();n       arg5 = get_xref_token ();/  >       add_word_args ("%s", px_ref_flag ? "*note " : "*Note ");         if (*arg5 || *arg4)s 	{ 	  char *node_name;t   	  if (!*arg2) 	    { 	      if (*arg3)\ 		node_name = arg3;r 	      else  		node_name = arg1;  	    } 	  elsea 	    node_name = arg2;  8 	  execute_string ("%s: (%s)%s", node_name, arg4, arg1);
 	  return; 	}
       elseA 	remember_node_reference (arg1, line_number, followed_reference);	         if (*arg3) 	{ 	  if (!*arg2)+ 	    execute_string ("%s: %s", arg3, arg1);  	  else + 	    execute_string ("%s: %s", arg2, arg1); 
 	  return; 	}         if (*arg2)' 	execute_string ("%s: %s", arg2, arg1); 
       else 	execute_string ("%s::", arg1);i     }    else     {s  L       /* Check to make sure that the next non-whitespace character is eitherL          a period or a comma. input_text_offset is pointing at the "}" which,          ended the xref or pxref command. */'       int temp = input_text_offset + 1;r  A       if (output_paragraph[output_paragraph_offset - 2] == ':' &&%8 	  output_paragraph[output_paragraph_offset - 1] == ':') 	return;'       while (temp < size_of_input_text)  	{+ 	  if (cr_or_whitespace (input_text[temp]))  	    temp++; 	  else  	    {% 	      if (input_text[temp] == '.' ||e 		  input_text[temp] == ',' || 		  input_text[temp] == '\t')f	 		return;i 	      else  		{  		  line_error (A 		"Cross-reference must be terminated with a period or a comma");  		  return;e 		}; 	    } 	}     }A }l   cm_pxref (arg)
      int arg;n {e   if (arg == START)n     {i       px_ref_flag++;       cm_xref (arg);       px_ref_flag--;     }c   else     add_char ('.');f }=   cm_inforef (arg)
      int arg;  {	   if (arg == START)n     {-        char *node, *pname, *file;         node = get_xref_token ();(        pname = get_xref_token ();       file = get_xref_token ();   =       execute_string ("*note %s: (%s)%s", pname, file, node);      }a }s  F /* **************************************************************** */ /*								    */% /*			Insertion Command Stubs			    */b /*								    */F /* **************************************************************** */   cm_quotation ()( {t   begin_insertion (quotation); }l  
 cm_example ()F {L   begin_insertion (example); }    cm_smallexample () {-!   begin_insertion (smallexample);  }d  
 cm_lisp () {t   begin_insertion (lisp);n }i   cm_smalllisp ()a {p   begin_insertion (smalllisp); }a  > /* @cartouche/@end cartouche draws box with rounded corners in3    TeX output.  Right now, just a NOP insertion. */  cm_cartouche ()* {m   begin_insertion (cartouche); }m   cm_format () {e   begin_insertion (format);t }l  
 cm_display ()p {f   begin_insertion (display); }d  
 cm_itemize ()  {u   begin_insertion (itemize); }S   cm_enumerate ()n {s"   do_enumeration (enumerate, "1"); }s  E /* Start an enumeration insertion of type TYPE.  If the user supplied M    no argument on the line, then use DEFAULT_STRING as the initial string. */ % do_enumeration (type, default_string)e      int type;      char *default_string; {y,   get_until_in_line (".", &enumeration_arg);    canon_white (enumeration_arg);     if (!*enumeration_arg)     {,       free (enumeration_arg);i4       enumeration_arg = savestring (default_string);     }O  B   if (!isdigit (*enumeration_arg) && !isletter (*enumeration_arg))     { O       warning ("%s requires a letter or a digit", insertion_type_pname (type));r         switch (type)y 	{ 	case enumerate: 	  default_string = "1";	 	  break;o 	}4       enumeration_arg = savestring (default_string);     }e   begin_insertion (type);r }r   cm_table ()) {    begin_insertion (table); }t   cm_ftable () {n   begin_insertion (ftable);; }    cm_vtable () {=   begin_insertion (vtable);  }    cm_group ()e {r   begin_insertion (group); }a   cm_ifinfo () {    begin_insertion (ifinfo);_ }e  D /* Begin an insertion where the lines are not filled or indented. */ cm_flushleft ()o {i   begin_insertion (flushleft); }i  F /* Begin an insertion where the lines are not filled, and each line is0    forced to the right-hand side of the page. */ cm_flushright () {    begin_insertion (flushright);_ }t    F /* **************************************************************** */ /*								    */$ /*			  Conditional Handling			    */ /*								    */F /* **************************************************************** */  5 /* A structure which contains `defined' variables. */t typedef struct _defines {    struct _defines *next;
   char *name;    char *value;	 } DEFINE;N  ' /* The linked list of `set' defines. */g! DEFINE *defines = (DEFINE *)NULL;n  , /* Add NAME to the list of `set' defines. */ set (name, value)t      char *name;      char *value;e {t   DEFINE *temp;   /   for (temp = defines; temp; temp = temp->next)i'     if (strcmp (name, temp->name) == 0)/       {  	free (temp->value);" 	temp->value = savestring (value); 	return;       }i  -   temp = (DEFINE *)xmalloc (sizeof (DEFINE));=   temp->next = defines;h!   temp->name = savestring (name);n#   temp->value = savestring (value);    defines = temp;  }   1 /* Remove NAME from the list of `set' defines. */) clear (name)      char *name; {e   register DEFINE *temp, *last;      last = (DEFINE *)NULL;   temp = defines;(     while (temp)     {n)       if (strcmp (temp->name, name) == 0)) 	{ 	  if (last) 	    last->next = temp->next;e 	  elser 	    defines = temp->next;   	  free (temp->name);  	  free (temp->value); 	  free (temp);t	 	  break;m 	}       last = temp;       temp = temp->next;     }  }e  K /* Return the value of NAME.  The return value is NULL if NAME is unset. */  char * set_p (name)      char *name; {t   register DEFINE *temp;  /   for (temp = defines; temp; temp = temp->next)h'     if (strcmp (temp->name, name) == 0)i       return (temp->value);e     return ((char *)NULL); }   < /* Conditionally parse based on the current command name. */ command_name_condition ()a {;   char *discarder;  5   discarder = (char *)xmalloc (8 + strlen (command));e  ,   sprintf (discarder, "\n@end %s", command);   discard_until (discarder);   discard_until ("\n");      free (discarder);  }e  J /* Create a variable whose name appears as the first word on this line. */	 cm_set ()_ {e   handle_variable (SET); }n  J /* Remove a variable whose name appears as the first word on this line. */ cm_clear ()n {    handle_variable (CLEAR); }    cm_ifset ()r {=   handle_variable (IFSET); }'  
 cm_ifclear ()a {    handle_variable (IFCLEAR); }   " cm_value (arg, start_pos, end_pos)!      int arg, start_pos, end_pos;  {    if (arg == END)      {;       char *name, *value;d2       name = (char *)&output_paragraph[start_pos];'       output_paragraph[end_pos] = '\0';        name = savestring (name);n       value = set_p (name); +       output_column -= end_pos - start_pos;e*       output_paragraph_offset = start_pos;         if (value)%         execute_string ("%s", value);'
       else/ 	add_word_args ("{No Value For \"%s\"}", name);          free (name);     }= }.  4 /* Set, clear, or conditionalize based on ACTION. */ handle_variable (action)      int action; { 
   char *name;      get_rest_of_line (&name);    backup_input_pointer ();   canon_white (name); *   handle_variable_internal (action, name);   free (name); }*  ' handle_variable_internal (action, name)*      int action;      char *name; {c
   char *temp; -   int delimiter, additional_text_present = 0;*  3   /* Only the first word of NAME is a valid tag. */_   temp = name;   delimiter = 0;5   while (*temp && (delimiter || !whitespace (*temp)))c     {= #if defined (SET_WITH_EQUAL)(       if (*temp == '"' || *temp == '\'') 	{ 	  if (*temp == delimiter) 	    delimiter = 0;t 	  elset 	    delimiter = *temp;  	} #endif /* SET_WITH_EQUAL */g
       temp++;r     }A     if (*temp)     additional_text_present++;     *temp = '\0';   
   if (!*name)_0     line_error ("@%s requires a name", command);   else     {e       switch (action)4 	{
 	case SET: 	  { 	    char *value;x   #if defined (SET_WITH_EQUAL)F 	    /* Allow a value to be saved along with a variable.  The value isE 	       the text following an `=' sign in NAME, if any is present. */*  : 	    for (value = name; *value && *value != '='; value++);   	    if (*value) 	      *value++ = '\0';   ) 	    if (*value == '"' || *value == '\'')  	      {
 		value++;# 		value[strlen (value) - 1] = '\0';f 	      }   #else /* !SET_WITH_EQUAL */e; 	    /* The VALUE of NAME is the remainder of the line sanss 	       whitespace. */! 	    if (additional_text_present)n 	      { 		value = temp + 1;r 		canon_white (value); 	      }	 	    elsen 	      value = ""; #endif /* !SET_WITH_VALUE */   	    set (name, value);  	  }	 	  break;s   	case CLEAR: 	  clear (name);	 	  break;    	case IFSET: 	case IFCLEAR:B 	  /* If IFSET and NAME is not set, or if IFCLEAR and NAME is set,< 	     read lines from the the file until we reach a matching= 	     "@end CONDITION".  This means that we only take note ofg, 	     "@ifset/clear" and "@end" commands. */ 	  { 	    char condition[8];g 	    int condition_len;    	    if (action == IFSET) # 	      strcpy (condition, "ifset");r	 	    else % 	      strcpy (condition, "ifclear");e  ( 	    condition_len = strlen (condition);  , 	  if ((action == IFSET && !set_p (name)) ||+ 	      (action == IFCLEAR && set_p (name)))e 	    { 	      int level = 0, done = 0;f   	      while (!done) 		{h 		  char *freeable_line, *line;u  & 		  get_rest_of_line (&freeable_line);  ; 		  for (line = freeable_line; whitespace (*line); line++);   " 		  if (*line == COMMAND_PREFIX &&< 		      (strncmp (line + 1, condition, condition_len) == 0)) 		    level++;, 		  else if (strncmp (line, "@end", 4) == 0) 		    {  		      char *cname = line + 4;l 		      char *temp;t  - 		      while (*cname && whitespace (*cname)); 			cname++;= 		      temp = cname;   , 		      while (*temp && !whitespace (*temp))
 			temp++; 		      *temp = '\0';*  + 		      if (strcmp (cname, condition) == 0)* 			{ 			  if (!level) 			    { 			      done = 1; 			    }	 			  else  			    level--;  			} 		    }* 		  free (freeable_line);* 		}*@ 	      /* We found the end of a false @ifset/ifclear.  If we are; 		 in a menu, back up over the newline that ends the ifset,p< 		 since that newline may also begin the next menu entry. */
 	      break;  	    } 	  else  	    { 	      if (action == IFSET)a 		begin_insertion (ifset); 	      elsei 		begin_insertion (ifclear); 	    } 	  }	 	  break;  	}     }n }   F /* **************************************************************** */ /*								    */ /*			@itemx, @item				    */ /*								    */F /* **************************************************************** */  D /* Non-zero means a string is in execution, as opposed to a file. */ int executing_string = 0;e  H /* Execute the string produced by formatting the ARGs with FORMAT.  This2    is like submitting a new file with @include. */6 #if defined (HAVE_VARARGS_H) && defined(HAVE_VSPRINTF)   execute_string (va_alist)a      va_dcl  {     static char temp_string[4000];   char *format;n   va_list args;      va_start (args);!   format = va_arg (args, char *); '   vsprintf (temp_string, format, args);e   va_end (args);  . #else /* !(HAVE_VARARGS_H && HAVE_VSPRINTF) */  5 execute_string (format, arg1, arg2, arg3, arg4, arg5)s      char *format; {g    static char temp_string[4000];>   sprintf (temp_string, format, arg1, arg2, arg3, arg4, arg5);  / #endif /* !(HAVE_VARARGS_H && HAVE_VSPRINTF) */t  !   strcat (temp_string, "@bye\n");    pushfile ();   input_text_offset = 0;   input_text = temp_string;o/   input_filename = savestring (input_filename);t,   size_of_input_text = strlen (temp_string);     executing_string++;    reader_loop ();   
   popfile ();    executing_string--;o     free_and_clear (&command);#   command = savestring ("not bye");i }n   int itemx_flag = 0;    cm_itemx ()n {t   itemx_flag++;e
   cm_item ();d   itemx_flag--;  }f  
 cm_item () { !   char *rest_of_line, *item_func;   ;   /* Can only hack "@item" while inside of an insertion. */h   if (insertion_level)     {t-       INSERTION_ELT *stack = insertion_stack; %       int original_input_text_offset;          skip_whitespace ();*5       original_input_text_offset = input_text_offset;	  '       get_rest_of_line (&rest_of_line);/!       canon_white (rest_of_line);*+       item_func = current_item_function ();*  G       /* Okay, do the right thing depending on which insertion function  	 is active. */        switch_top:        switch (stack->insertion)a 	{
 	case ifinfo:  	case ifset: 	case ifclear: 	case cartouche: 	  stack = stack->next;L 	  if (!stack) 	    goto no_insertion;f 	  else  	    goto switch_top; 	 	  break;;   	case menu:l 	case quotation: 	case example: 	case smallexample:m 	case lisp:p
 	case format:f 	case display: 	case group:G 	  line_error ("The `@%s' command is meaningless within a `@%s' block",  		      command,: 		      insertion_type_pname (current_insertion_type ()));	 	  break;n   	case itemize: 	case enumerate: 	  if (itemx_flag) 	    {E 	      line_error ("@itemx is not meaningful inside of a `%s' block",o7 			  insertion_type_pname (current_insertion_type ()));  	    } 	  else  	    { 	      start_paragraph (); 	      kill_self_indent (-1); + 	      filling_enabled = indented_fill = 1;>  0 	      if (current_insertion_type () == itemize) 		{e0 		  indent (output_column = current_indent - 2);  8 		  /* I need some way to determine whether this command8 		     takes braces or not.  I believe the user can type8 		     either "@bullet" or "@bullet{}".  Of course, they> 		     can also type "o" or "#" or whatever else they want. */  		  if (item_func && *item_func) 		    {  		      if (*item_func == '@')0 			if (item_func[strlen (item_func) - 1] != '}')( 			  execute_string ("%s{}", item_func); 			else & 			  execute_string ("%s", item_func); 		      else$ 			execute_string ("%s", item_func); 		    }_ 		  insert (' ');  		  output_column++; 		}  	      elsec 		enumerate_item ();  D 	      /* Special hack.  This makes close paragraph ignore you until6 		 the start_paragraph () function has been called. */  	      must_start_paragraph = 1;  F 	      /* Ultra special hack.  It appears that some people incorrectly@ 		 place text directly after the @item, instead of on a new line= 		 by itself.  This happens to work in TeX, so I make it work  		 here. */v 	      if (*rest_of_line)i 		{( 		  line_number--;3 		  input_text_offset = original_input_text_offset;r 		}  	    }	 	  break;m   	case table:
 	case ftable:)
 	case vtable:  	  {' 	    /* Get rid of extra characters. */  	    kill_self_indent (-1);e  A 	    /* close_paragraph () almost does what we want.  The problempA 	       is when paragraph_is_open, and last_char_was_newline, and > 	       the last newline has been turned into a space, because- 	       filling_enabled. I handle it here. */;G 	    if (last_char_was_newline && filling_enabled && paragraph_is_open)  	      insert ('\n');l 	    close_paragraph ();  ( #if defined (INDENT_PARAGRAPHS_IN_TABLE)C 	    /* Indent on a new line, but back up one indentation level. */) 	    {
 	      int t;   ) 	      t = inhibit_paragraph_indentation; ) 	      inhibit_paragraph_indentation = 1; D 	      /* At this point, inserting any non-whitespace character will2 		 force the existing indentation to be output. */ 	      add_char ('i');) 	      inhibit_paragraph_indentation = t;, 	    }' #else /* !INDENT_PARAGRAPHS_IN_TABLE */i 	    add_char ('i');( #endif /* !INDENT_PARAGRAPHS_IN_TABLE */   	    output_paragraph_offset--;r: 	    kill_self_indent (default_indentation_increment + 1);  + 	    /* Add item's argument to the line. */  	    filling_enabled = 0;e! 	    if (item_func && *item_func) ;  	      execute_string ("%s{%s}", item_func, rest_of_line); 
  	    else,  	      execute_string ("%s", rest_of_line);  - 	    if (current_insertion_type () == ftable) 5 	      execute_string ("@findex %s\n", rest_of_line);e  - 	    if (current_insertion_type () == vtable) 5 	      execute_string ("@vindex %s\n", rest_of_line);)  4 	    /* Start a new line, and let start_paragraph ()* 	       do the indenting of it for you. */ 	    close_single_paragraph ();r) 	    indented_fill = filling_enabled = 1;e 	  } 	}       free (rest_of_line);     }u   else     {u     no_insertion: F       line_error ("@%s found outside of an insertion block", command);     }a })    F /* **************************************************************** */ /*								    */% /*			Defun and Friends       		    */a /*								    */F /* **************************************************************** */  & #define DEFUN_SELF_DELIMITING(c)					\   (((c) == '(')								\    || ((c) == ')')							\    || ((c) == '[')							\    || ((c) == ']'))    struct token_accumulator {c   unsigned int length;   unsigned int index;N   char **tokens; };   void* initialize_token_accumulator (accumulator)+      struct token_accumulator *accumulator;n {O   (accumulator->length) = 0;   (accumulator->index) = 0;f   (accumulator->tokens) = NULL;/ }    void% accumulate_token (accumulator, token)n+      struct token_accumulator *accumulator;s      char *token;i {t4   if ((accumulator->index) >= (accumulator->length))     { "       (accumulator->length) += 10;0       (accumulator->tokens) = (char **) xrealloc@ 	(accumulator->tokens, (accumulator->length * sizeof (char *)));     }=2   accumulator->tokens[accumulator->index] = token;   accumulator->index += 1; }	   char * copy_substring (start, end)       char *start;e      char *end;p { $   char *result, *scan, *scan_result;  0   result = (char *) xmalloc ((end - start) + 1);   scan_result = result;0   scan = start;;     while (scan < end)     *scan_result++ = *scan++;      *scan_result = '\0';   return (result); }*  F /* Given `string' pointing at an open brace, skip forward and return a4    pointer to just past the matching close brace. */ int % scan_group_in_string (string_pointer)\      char **string_pointer;n {,   register int c;    register char *scan_string;{"   register unsigned int level = 1;  &   scan_string = (*string_pointer) + 1;     while (1)b     {)       if (level == 0)f 	{# 	  (*string_pointer) = scan_string;I 	  return (1); 	}       c = (*scan_string++);t       if (c == '\0') 	{3 	  /* Tweak line_number to compensate for fact that 6 	     we gobbled the whole line before coming here. */ 	  line_number -= 1;* 	  line_error ("Missing `}' in @def arg"); 	  line_number += 1;) 	  (*string_pointer) = (scan_string - 1);  	  return (0); 	}       if (c == '{')* 	level += 1;       if (c == '}')* 	level -= 1;     }@ }m  9 /* Return a list of tokens from the contents of `string'.*>    Commands and brace-delimited groups count as single tokens.<    Contiguous whitespace characters are converted to a token#    consisting of a single space. */e char **r args_from_string (string)G      char *string; { '   struct token_accumulator accumulator;u&   register char *scan_string = string;    char *token_start, *token_end;  .   initialize_token_accumulator (&accumulator);      while ((*scan_string) != '\0')     {a;       /* Replace arbitrary whitespace by a single space. */c$       if (whitespace (*scan_string)) 	{ 	  scan_string += 1;$ 	  while (whitespace (*scan_string)) 	    scan_string += 1;9 	  accumulate_token ((&accumulator), (savestring (" ")));a 	  continue; 	}  ,       /* Commands count as single tokens. */+       if ((*scan_string) == COMMAND_PREFIX); 	{ 	  token_start = scan_string;A 	  scan_string += 1;& 	  if (self_delimiting (*scan_string)) 	    scan_string += 1; 	  else; 	    { 	      register int c; 	      while (1) 		{s 		  c = *scan_string++;   7  		  if ((c == '\0') || (c == '{') || (whitespace (c)))_ 		    {  		      scan_string -= 1;o 		      break; 		    }t 		}-   	      if (*scan_string == '{')  		{m 		  char *s = scan_string;% 		  (void) scan_group_in_string (&s);e 		  scan_string = s; 		}e 	    } 	  token_end = scan_string;f 	}  9       /* Parentheses and brackets are self-delimiting. */n4       else if (DEFUN_SELF_DELIMITING (*scan_string)) 	{ 	  token_start = scan_string;  	  scan_string += 1; 	  token_end = scan_string;n 	}  A       /* Open brace introduces a group that is a single token. */n#       else if (*scan_string == '{')s 	{ 	  char *s = scan_string;(, 	  int balanced = scan_group_in_string (&s);  ! 	  token_start = scan_string + 1;m 	  scan_string = s; : 	  token_end = balanced ? (scan_string - 1) : scan_string; 	}  C       /* Otherwise a token is delimited by whitespace, parentheses,i> 	 brackets, or braces.  A token is also ended by a command. */
       else 	{ 	  token_start = scan_string;c   	  while (1) 	    { 	      register int c;   	      c = *scan_string++;   	      if (!c ||3 		  (whitespace (c) || DEFUN_SELF_DELIMITING (c) ||s 		   c == '{' || c == '}'))s 		{p 		  scan_string--;
 		  break; 		}h  < 	      /* If we encounter a command imbedded within a token, 		 then end the token. */_ 	      if (c == COMMAND_PREFIX)e 		{; 		  scan_string--;
 		  break; 		}  	    } 	  token_end = scan_string;{ 	}         accumulate_token9 	(&accumulator, copy_substring (token_start, token_end));t     }m(   accumulate_token (&accumulator, NULL);   return (accumulator.tokens); }g   void+ process_defun_args (defun_args, auto_var_p)i      char **defun_args;l      int auto_var_p; {e   int pending_space = 0;     while (1)	     {t&       char *defun_arg = *defun_args++;         if (defun_arg == NULL) 	break;t         if (defun_arg[0] == ' ') 	{ 	  pending_space = 1;u 	  continue; 	}         if (pending_space) 	{ 	  add_char (' '); 	  pending_space = 0;" 	}  /       if (DEFUN_SELF_DELIMITING (defun_arg[0]))f 	add_char (defun_arg[0]); #       else if (defun_arg[0] == '&')i 	add_word (defun_arg);.       else if (defun_arg[0] == COMMAND_PREFIX)" 	execute_string ("%s", defun_arg);       else if (auto_var_p)( 	execute_string ("@var{%s}", defun_arg);
       else 	add_word (defun_arg);     }	 }u   char *% next_nonwhite_defun_arg (arg_pointer)t      char ***arg_pointer;  {k   char **scan = (*arg_pointer);o   char *arg = (*scan++);  "   if ((arg != 0) && (*arg == ' '))     arg = *scan++;     if (arg == 0)      scan -= 1;     *arg_pointer = scan;  !   return ((arg == 0) ? "" : arg);a }t  ! /* Make the defun type insertion. %    TYPE says which insertion this is.a8    X_P says not to start a new insertion if non-zero. */ void defun_internal (type, x_p)      enum insertion_type type;
      int x_p;n {i    enum insertion_type base_type;!   char **defun_args, **scan_args;t9   char *category, *defined_name, *type_name, *type_name2;a     {*     char *line;f     get_rest_of_line (&line);_+     defun_args = (args_from_string (line));r     free (line);   }      scan_args = defun_args;h     switch (type)      {      case defun:e       category = "Function";       base_type = deffn;       break;     case defmac:       category = "Macro";i       base_type = deffn;       break;     case defspec:         category = "Special Form";       base_type = deffn;       break;     case defvar:       category = "Variable";       base_type = defvr;       break;     case defopt:       category = "User Option";i       base_type = defvr;       break;     case deftypefun:       category = "Function";       base_type = deftypefn;       break;     case deftypevar:       category = "Variable";       base_type = deftypevr;       break;     case defivar:s%       category = "Instance Variable";        base_type = defcv;       break;     case defmethod:        category = "Method";       base_type = defop;       break;     case deftypemethod:;       category = "Method";        base_type = deftypemethod;       break;     default:6       category = next_nonwhite_defun_arg (&scan_args);       base_type = type;)       break;     }      if ((base_type == deftypefn)!       || (base_type == deftypevr)t       || (base_type == defcv)u       || (base_type == defop)_&       || (base_type == deftypemethod))5     type_name = next_nonwhite_defun_arg (&scan_args);s  !   if (base_type == deftypemethod) 6     type_name2 = next_nonwhite_defun_arg (&scan_args);  6   defined_name = next_nonwhite_defun_arg (&scan_args);  G   /* This hack exists solely for the purposes of formatting the texinfooC      manual.  I couldn't think of a better way.  The token might berI      a simple @@ followed immediately by more text.  If this is the case,*K      then the next defun arg is part of this one, and we should concatenate	
      them. */D?   if (*scan_args && **scan_args && !whitespace (**scan_args) &&*)       (strcmp (defined_name, "@@") == 0))*     {*>       char *tem = (char *)xmalloc (3 + strlen (scan_args[0]));  *       sprintf (tem, "@@%s", scan_args[0]);         free (scan_args[0]);       scan_args[0] = tem;a       scan_args++;       defined_name = tem;n     }i     if (!x_p)*     begin_insertion (type);i  &   /* Write the definition header line.5      This should start at the normal indentation.  */t2   current_indent -= default_indentation_increment;   start_paragraph ();U     switch (base_type)     {k     case deffn:t     case defvr:c     case deftp:o<       execute_string (" -- %s: %s", category, defined_name);       break;     case deftypefn:      case deftypevr:tJ       execute_string (" -- %s: %s %s", category, type_name, defined_name);       break;     case defcv:lM       execute_string (" -- %s of %s: %s", category, type_name, defined_name);        break;     case defop: M       execute_string (" -- %s on %s: %s", category, type_name, defined_name);e       break;     case deftypemethod:rM       execute_string (" -- %s on %s: %s %s", category, type_name, type_name2,u 		      defined_name);       break;     })2   current_indent += default_indentation_increment;  0   /* Now process the function arguments, if any.F      If these carry onto the next line, they should be indented by twoD      increments to distinguish them from the body of the definition,,      which is indented by one increment.  */2   current_indent += default_indentation_increment;     switch (base_type)     {      case deffn:n     case defop:t(       process_defun_args (scan_args, 1);       break;     case deftp:_     case deftypefn:g     case deftypemethod: (       process_defun_args (scan_args, 0);       break;     }a2   current_indent -= default_indentation_increment;   close_single_paragraph ();  /   /* Make an entry in the appropriate index. */o   switch (base_type)     {;     case deffn:+     case deftypefn:n4       execute_string ("@findex %s\n", defined_name);       break;     case defvr:      case deftypevr:l     case defcv:@4       execute_string ("@vindex %s\n", defined_name);       break;     case defop:r     case deftypemethod:tE       execute_string ("@findex %s on %s\n", defined_name, type_name);o       break;     case deftp:n4       execute_string ("@tindex %s\n", defined_name);       break;     }   "   /* Deallocate the token list. */   scan_args = defun_args;_   while (1)n     {h"       char * arg = (*scan_args++);       if (arg == NULL) 	break;m       free (arg);      }_   free (defun_args); }   I /* Add an entry for a function, macro, special form, variable, or option.sH    If the name of the calling command ends in `x', then this is an extraB    entry included in the body of an insertion of the same type. */ cm_defun ()i {(
   int x_p;   enum insertion_type type;m$   char *temp = savestring (command);  /   x_p = (command[strlen (command) - 1] == 'x');k  
   if (x_p)#     temp[strlen (temp) - 1] = '\0';i  $   type = find_type_from_name (temp);   free (temp);  F   /* If we are adding to an already existing insertion, then make sure9      that we are already in an insertion of type TYPE. */|   if (x_p &&?       (!insertion_level || insertion_stack->insertion != type))      {	F       line_error ("Must be in a `%s' insertion in order to use `%s'x", 		  command, command);       discard_until ("\n");r
       return;      }      defun_internal (type, x_p);  }   # /* End existing insertion block. */d	 cm_end ()* { 
   char *temp;D   enum insertion_type type;t     if (!insertion_level)=     {t.       line_error ("Unmatched `@%s'", command);
       return;      }      get_rest_of_line (&temp);p   canon_white (temp);.     if (strlen (temp) == 0)r;     line_error ("`@%s' needs something after it", command);   $   type = find_type_from_name (temp);     if (type == bad_type)      {_;       line_error ("Bad argument to `%s', `%s', using `%s'",cE 	   command, temp, insertion_type_pname (current_insertion_type ()));,     }h   end_insertion (type);a   free (temp); }s   eF /* **************************************************************** */ /*								    */& /*			Other Random Commands		   	    */ /*								    */F /* **************************************************************** */  B /* This says to inhibit the indentation of the next paragraph, but#    not of following paragraphs.  */m cm_noindent () { %   if (!inhibit_paragraph_indentation) '     inhibit_paragraph_indentation = -1;  }n  = /* I don't know exactly what to do with this.  Should I allow{B    someone to switch filenames in the middle of output?  Since theD    file could be partially written, this doesn't seem to make sense.?    Another option: ignore it, since they don't *really* want tos9    switch files.  Finally, complain, or at least warn. */i cm_setfilename ()  {n   char *filename;;   get_rest_of_line (&filename);hH   /* warning ("`@%s %s' encountered and ignored", command, filename); */   free (filename); }]   cm_ignore_line ()i {s   discard_until ("\n");  }   J /* @br can be immediately followed by `{}', so we have to read those here.+    It should simply close the paragraph. */g cm_br () {c   if (looking_at ("{}"))     input_text_offset += 2;'     if (curchar () == '\n')      {e       input_text_offset++;       line_number++;     }s     close_paragraph ();e }   ;  /* Insert the number of blank lines passed as argument. */l cm_sp () {    int lines;
   char *line;h     get_rest_of_line (&line);a  '   if (sscanf (line, "%d", &lines) != 1)k     {rO       line_error ("%csp requires a positive numeric argument", COMMAND_PREFIX);      })   else     {a       if (lines < 0) 	lines = 0;-         while (lines--)s 	add_char ('\n');a     })   free (line); }   . /* Start a new line with just this text on it.     Then center the line of text.-    This always ends the current paragraph. */  cm_center () {n    register int i, start, length;   int fudge_factor = 1;t   unsigned char *line;     close_paragraph ();h&   filling_enabled = indented_fill = 0;   cm_noindent ();n"   start = output_paragraph_offset;   inhibit_output_flushing ();e$   get_rest_of_line ((char **)&line);    execute_string ((char *)line);   free (line);   uninhibit_output_flushing ();   "   i = output_paragraph_offset - 1;8   while (i > (start - 1) && output_paragraph[i] == '\n') 	i--;       output_paragraph_offset = ++i;+   length = output_paragraph_offset - start;;  ,   if (length < (fill_column - fudge_factor))     {p3       line = (unsigned char *)xmalloc (1 + length); @       memcpy (line, (char *)(output_paragraph + start), length);  4       i = (fill_column - fudge_factor - length) / 2;&       output_paragraph_offset = start;         while (i--)  	insert (' ');  "       for (i = 0; i < length; i++) 	insert (line[i]);         free (line);     }f     insert ('\n');   close_paragraph ();    filling_enabled = 1; }   & /* Show what an expression returns. */ cm_result (arg)V
      int arg;  {a   if (arg == END)      add_word ("=>"); }e  $ /* What an expression expands to. */ cm_expansion (arg)
      int arg;  {    if (arg == END);     add_word ("==>");h };  / /* Indicates two expressions are equivalent. */  cm_equiv (arg)
      int arg;x {o   if (arg == END)s     add_word ("=="); }p  # /* What an expression may print. */f cm_print (arg)
      int arg;  {|   if (arg == END)y     add_word ("-|"); }p   /* An error signaled. */ cm_error (arg)
      int arg;e {p   if (arg == END))     add_word ("error-->"); }_  6 /* The location of point in an example of a buffer. */ cm_point (arg)
      int arg;w {e   if (arg == END)r     add_word ("-!-");= }x  . /* Start a new line with just this text on it.2    The text is outdented one level if possible. */ cm_exdent () {n
   char *line;t   int i = current_indent;e     if (current_indent)s4     current_indent -= default_indentation_increment;     get_rest_of_line (&line);t   close_single_paragraph ();   execute_string ("%s", line);   current_indent = i;a   free (line);   close_single_paragraph (); })  
 cm_include ()m {d   cm_infoinclude (); }*  1 /* Remember this file, and move onto the next. */e cm_infoinclude ()  {    char *filename;@     close_paragraph ();    get_rest_of_line (&filename);c   pushfile ();  C   /* In verbose mode we print info about including another file. */p   if (verbose_mode)o     {)       register int i = 0;t)       register FSTACK *stack = filestack;   F       for (i = 0, stack = filestack; stack; stack = stack->next, i++);  
       i *= 2;a         printf ("%*s", i, "");>       printf ("%c%s %s\n", COMMAND_PREFIX, command, filename);       fflush (stdout);     }%      if (!find_and_load (filename))     {a!       extern char *sys_errlist[];d!       extern int errno, sys_nerr;        popfile ();g  :       /* Cannot "@include foo", in line 5 of "/wh/bar". */E       line_error ("`%c%s %s': %s", COMMAND_PREFIX, command, filename,d 		  ((errno < sys_nerr) ? 8 		   sys_errlist[errno] : "Unknown file system error"));     }    free (filename); })  / /* The other side of a malformed expression. */x misplaced_brace () {n   line_error ("Misplaced `}'");  }e  C /* Don't let the filling algorithm insert extra whitespace here. */t" cm_force_abbreviated_whitespace () {  }N  B /* Do not let this character signify the end of a sentence, thoughC    if it was seen without the command prefix it normally would.  Wei9    do this by turning on the 8th bit of the character. */  cm_ignore_sentence_ender ()/ {    add_char (META ((*command)));t }_  ; /* Signals end of processing.  Easy to make this happen. */ 	 cm_bye ()p { )   input_text_offset = size_of_input_text;  }   
 cm_asis () {d }p  
 cm_math () {y }n    F /* **************************************************************** */ /*								    */ /*			Indexing Stuff				    */e /*								    */F /* **************************************************************** */     /* An index element... */) typedef struct index_elt {    struct index_elt *next;x.   char *entry;			/* The index entry itself. */3   char *node;			/* The node from whence it came. */ 5   int code;			/* Non-zero means add `@code{...}' whene  				   printing this element. */E   int defining_line;		/* Line number where this entry was written. */  } INDEX_ELT;  K /* A list of short-names for each index, and the index to that index in our@K    index array, the_indices.  In addition, for each index, it is rememberedeH    whether that index is a code index or not.  Code indices have @code{}K    inserted around the first word when they are printed with printindex. */  typedef struct {u
   char *name;    int index;   int code;i } INDEX_ALIST;  7 INDEX_ALIST **name_index_alist = (INDEX_ALIST **) NULL;n  A /* An array of pointers.  Each one is for a different index.  TheeA    "synindex" command changes which array slot is pointed to by a     given "index". */. INDEX_ELT **the_indices = (INDEX_ELT **) NULL;  $ /* The number of defined indices. */ int defined_indices = 0;   /* We predefine these. */1 #define program_index 0n #define function_index 1 #define concept_index 2  #define variable_index 3 #define datatype_index 4 #define key_index 5    init_indices ()n {s   int i;  +   /* Create the default data structures. */_     /* Initialize data space. */   if (!the_indices)      {iC       the_indices = (INDEX_ELT **) xmalloc ((1 + defined_indices) *o 					    sizeof (INDEX_ELT *));n8       the_indices[defined_indices] = (INDEX_ELT *) NULL;  J       name_index_alist = (INDEX_ALIST **) xmalloc ((1 + defined_indices) *! 						   sizeof (INDEX_ALIST *)); ?       name_index_alist[defined_indices] = (INDEX_ALIST *) NULL;m     }`  <   /* If there were existing indices, get rid of them now. */'   for (i = 0; i < defined_indices; i++)(+     undefindex (name_index_alist[i]->name);n      /* Add the default indices. */   defindex ("pg", 0);f3   defindex ("fn", 1);		/* "fn" is a code index.  */    defindex ("cp", 0);a   defindex ("vr", 0);u   defindex ("tp", 0);n   defindex ("ky", 0);_   }   A /* Find which element in the known list of indices has this name.r%    Returns -1 if NAME isn't found. */* int* find_index_offset (name)      char *name; {    register int i;*'   for (i = 0; i < defined_indices; i++)	     if (name_index_alist[i] &&/ 	strcmp (name, name_index_alist[i]->name) == 0) *       return (name_index_alist[i]->index);   return (-1); }r  A /* Return a pointer to the entry of (name . index) for this name. -    Return NULL if the index doesn't exist. */i
 INDEX_ALIST *e find_index (name)       char *name; {c(   int offset = find_index_offset (name);   if (offset > -1)&     return (name_index_alist[offset]);   else"     return ((INDEX_ALIST *) NULL); }h  G /* Given an index name, return the offset in the_indices of this index,n&    or -1 if there is no such index. */ translate_index (name)      char *name; {s)   INDEX_ALIST *which = find_index (name);e     if (which)     return (which->index);   else     return (-1); }o  2 /* Return the index list which belongs to NAME. */ INDEX_ELT *i index_list (name)r      char *name; { %   int which = translate_index (name);    if (which < 0)     return ((INDEX_ELT *) - 1);s   else      return (the_indices[which]); }   % /* Please release me, let me go... */o free_index (index)      INDEX_ELT *index; {    INDEX_ELT *temp;  .   while ((temp = index) != (INDEX_ELT *) NULL)     {r       free (temp->entry);t       free (temp->node);       index = index->next;       free (temp);     }h }*   /* Flush an index by name. */n undefindex (name)f      char *name; {    int i;'   int which = find_index_offset (name);p     if (which < 0)     return (which);)  %   i = name_index_alist[which]->index;e       free_index (the_indices[i]);&   the_indices[i] = (INDEX_ELT *) NULL;  '   free (name_index_alist[which]->name);i!   free (name_index_alist[which]);e1   name_index_alist[which] = (INDEX_ALIST *) NULL;r }   = /* Define an index known as NAME.  We assign the slot number.;6    CODE if non-zero says to make this a code index. */ defindex (name, code)       char *name;      int code; {    register int i, slot;r  '   /* If it already exists, flush it. */p   undefindex (name);  "   /* Try to find an empty slot. */   slot = -1;'   for (i = 0; i < defined_indices; i++)i     if (!name_index_alist[i])        {r
 	slot = i; 	break;        }>     if (slot < 0)p     {g8       /* No such luck.  Make space for another index. */       slot = defined_indices;_       defined_indices++;  )       name_index_alist = (INDEX_ALIST **)p$ 	xrealloc ((char *)name_index_alist,4 		  (1 + defined_indices) * sizeof (INDEX_ALIST *));"       the_indices = (INDEX_ELT **) 	xrealloc ((char *)the_indices, 2 		  (1 + defined_indices) * sizeof (INDEX_ELT *));     }   )   /* We have a slot.  Start assigning. */ J   name_index_alist[slot] = (INDEX_ALIST *) xmalloc (sizeof (INDEX_ALIST));3   name_index_alist[slot]->name = savestring (name);_'   name_index_alist[slot]->index = slot;s&   name_index_alist[slot]->code = code;  )   the_indices[slot] = (INDEX_ELT *) NULL;o }(  G /* Add the arguments to the current index command to the index NAME. */  index_add_arg (name)      char *name; {_   int which;   char *index_entry;   INDEX_ALIST *tem;u     tem = find_index (name);      which = tem ? tem->index : -1;  "   get_rest_of_line (&index_entry);   ignore_blank_line ();.     if (which < 0)     {i8       line_error ("Unknown index reference `%s'", name);       free (index_entry);/     }r   else     {iB       INDEX_ELT *new = (INDEX_ELT *) xmalloc (sizeof (INDEX_ELT));%       new->next = the_indices[which];o       new->entry = index_entry;        new->node = current_node;D       new->code = tem->code;+       new->defining_line = line_number - 1;n       the_indices[which] = new;e     }i }o  $ #define INDEX_COMMAND_SUFFIX "index"  : /* The function which user defined index commands call. */ gen_index () {-$   char *name = savestring (command);(   if (strlen (name) >= strlen ("index"))2     name[strlen (name) - strlen ("index")] = '\0';   index_add_arg (name);e   free (name); }i  8 /* Define a new index command.  Arg is name of index. */ cm_defindex () {m   gen_defindex (0);m }    cm_defcodeindex () {f   gen_defindex (1);h }*   gen_defindex (code)a      int code; {_
   char *name;f   get_rest_of_line (&name);      if (find_index (name))     {a5       line_error ("Index `%s' already exists", name);        free (name);
       return;      }e   else     {sJ       char *temp = (char *) alloca (1 + strlen (name) + strlen ("index"));&       sprintf (temp, "%sindex", name);/       define_user_command (temp, gen_index, 0);s       defindex (name, code);       free (name);     }t }t  : /* Append LIST2 to LIST1.  Return the head of the list. */ INDEX_ELT *s index_append (head, tail)n      INDEX_ELT *head, *tail; {f$   register INDEX_ELT *t_head = head;     if (!t_head)     return (tail);     while (t_head->next)     t_head = t_head->next;   t_head->next = tail;   return (head); }   C /* Expects 2 args, on the same line.  Both are index abbreviations.iD    Make the first one be a synonym for the second one, i.e. make the6    first one have the same index as the second one. */ cm_synindex () {e   int redirector, redirectee; 
   char *temp;.     skip_whitespace ();d!   get_until_in_line (" ", &temp); (   redirectee = find_index_offset (temp);   skip_whitespace ();t   free_and_clear (&temp);n!   get_until_in_line (" ", &temp); (   redirector = find_index_offset (temp);   free (temp);'   if (redirector < 0 || redirectee < 0)h     {A-       line_error ("Unknown index reference");s     }E   else     {sG       /* I think that we should let the user make indices synonymous to I          each other without any lossage of info.  This means that one can*J          say @synindex cp dt anywhere in the file, and things that used to%          be in cp will go into dt. */ M       INDEX_ELT *i1 = the_indices[redirectee], *i2 = the_indices[redirector];A         if (i1 || i2)  	{
 	  if (i1)5 	    the_indices[redirectee] = index_append (i1, i2);; 	  else 5 	    the_indices[redirectee] = index_append (i2, i1);m 	}  +       name_index_alist[redirectee]->index =n% 	name_index_alist[redirector]->index;n     }e }e  # cm_pindex ()			/* Pinhead index. */u {r   index_add_arg ("pg");t }.  $ cm_vindex ()			/* Variable index. */ {m   index_add_arg ("vr");e }d   cm_kindex ()			/* Key index. */a {y   index_add_arg ("ky");o }f  # cm_cindex ()			/* Concept index. */e {r   index_add_arg ("cp");e }r  $ cm_findex ()			/* Function index. */ {e   index_add_arg ("fn");h }t  % cm_tindex ()			/* Data Type index. */e {    index_add_arg ("tp");  }    /* Sorting the index. */* index_element_compare (element1, element2)&      INDEX_ELT **element1, **element2; { 9   /* This needs to ignore leading non-text characters. */"<   return (stricmp ((*element1)->entry, (*element2)->entry)); }   8 /* Sort the index passed in INDEX, returning an array of=    pointers to elements.  The array is terminated with a NULLi<    pointer.  We call qsort because it's supposed to be fast.    I think this looks bad. */d INDEX_ELT ** sort_index (index)      INDEX_ELT *index; {a   INDEX_ELT *temp = index;   INDEX_ELT **array;   int count = 0;  $   while (temp != (INDEX_ELT *) NULL)     {_       count++;       temp = temp->next;     }d  +   /* We have the length.  Make an array. */*  F   array = (INDEX_ELT **) xmalloc ((count + 1) * sizeof (INDEX_ELT *));   count = 0;   temp = index;]  $   while (temp != (INDEX_ELT *) NULL)     {t       array[count++] = temp;       temp = temp->next;     }s?   array[count] = (INDEX_ELT *) NULL;	/* terminate the array. */      /* Sort the array. */ D   qsort (array, count, sizeof (INDEX_ELT *), index_element_compare);     return (array);i }_  D /* Non-zero means that we are in the middle of printing an index. */ int printing_index = 0;   4 /* Takes one arg, a short name of an index to print.9    Outputs a menu of the sorted elements of the index. */v cm_printindex () {(   int item;    INDEX_ELT *index;    INDEX_ELT **array;   char *index_name;l6   int old_inhibitions = inhibit_paragraph_indentation;7   int previous_filling_enabled_value = filling_enabled;      close_paragraph ();t!   get_rest_of_line (&index_name);i  "   index = index_list (index_name);   if ((int) index == -1)     {l9       line_error ("Unknown index name `%s'", index_name);d       free (index_name);
       return;o     }o   else     free (index_name);     array = sort_index (index);h     filling_enabled = 0;$   inhibit_paragraph_indentation = 1;   close_paragraph ();    add_word ("* Menu:\n\n");t     printing_index = 1;-/   for (item = 0; (index = array[item]); item++)e     {e)       int real_line_number = line_number;n  E       /* Let errors generated while making the index entry point back1* 	 at the line which contains the entry. */)       line_number = index->defining_line;L  F       /* If this particular entry should be printed as a "code" index,+ 	 then wrap the entry with "@code{...}". */        if (index->code)0 	execute_string ("* @code{%s}: ", index->entry);
       else) 	execute_string ("* %s: ", index->entry);n  :       /* Pad the front of the destination nodename so that 	 the output looks nice. */[1       if (fill_column > 40 && output_column < 40)* 	indent (40 - output_column);D  ,       execute_string ("%s.\n", index->node);  %       line_number = real_line_number;        flush_output ();     })     printing_index = 0;e   free (array);    close_single_paragraph ();3   filling_enabled = previous_filling_enabled_value;e2   inhibit_paragraph_indentation = old_inhibitions; }h    F /* **************************************************************** */ /*								    */, /*		    Making User Defined Commands		    */ /*								    */F /* **************************************************************** */  0 define_user_command (name, proc, needs_braces_p)      char *name;      FUNCTION *proc;      int needs_braces_p; {o$   int slot = user_command_array_len;   user_command_array_len++;t     if (!user_command_array)G     user_command_array = (COMMAND **) xmalloc (1 * sizeof (COMMAND *));i  A   user_command_array = (COMMAND **) xrealloc (user_command_array,x) 					      (1 + user_command_array_len) *  					      sizeof (COMMAND *));   D   user_command_array[slot] = (COMMAND *) xmalloc (sizeof (COMMAND));5   user_command_array[slot]->name = savestring (name); (   user_command_array[slot]->proc = proc;@   user_command_array[slot]->argument_in_braces = needs_braces_p; }+  J /* Make ALIAS run the named FUNCTION.  Copies properties from FUNCTION. */ define_alias (alias, function)      char *alias, *function; {  }   K /* Set the paragraph indentation variable to the value specified in STRING.d    Values can be:(-    `asis': Don't change existing indentation. '    `none': Remove existing indentation.s9       NUM: Indent NUM spaces at the starts of paragraphs.a6            Note that if NUM is zero, we assume `none'.  L    Returns 0 if successful, or non-zero if STRING isn't one of the above. */ intn set_paragraph_indent (string)L      char *string; {g#   if (strcmp (string, "asis") == 0)o     paragraph_start_indent = 0;r(   else if (strcmp (string, "none") == 0)      paragraph_start_indent = -1;   else     { >       if (sscanf (string, "%d", &paragraph_start_indent) != 1)
 	return (-1);_
       else 	{# 	  if (paragraph_start_indent == 0)f! 	    paragraph_start_indent = -1;r 	}     }n
   return (0);e }s   cm_paragraphindent ()n {_   char *arg;     get_rest_of_line (&arg);&   if (set_paragraph_indent (arg) != 0)4     line_error ("Bad argument to @paragraphindent");  
   free (arg);t }=  ! /* Some support for footnotes. */r  H /* Footnotes are a new construct in Info.  We don't know the best methodA    of implementing them for sure, so we present two possiblities.       SeparateNode:< 	Make them look like followed references, with the reference1 	destinations in a makeinfo manufactured node or,n      EndNode: @ 	Make them appear at the bottom of the node that they originally 	appeared in. */ #define SeparateNode 0 #define EndNode 1a   int footnote_style = EndNode; ! int first_footnote_this_node = 1;  int footnote_count = 0;_  D /* Set the footnote style based on he style identifier in STRING. */ int_ set_footnote_style (string)d      char *string; { ,   if ((stricmp (string, "separate") == 0) ||$       (stricmp (string, "MN") == 0))"     footnote_style = SeparateNode;,   else if ((stricmp (string, "end") == 0) ||" 	   (stricmp (string, "EN") == 0))     footnote_style = EndNode;e   else     return (-1);    return (0); }"   cm_footnotestyle ()  {i   char *arg;     get_rest_of_line (&arg);  $   if (set_footnote_style (arg) != 0)2     line_error ("Bad argument to @footnotestyle");  
   free (arg);  }t   typedef struct fnn {_   struct fn *next;   char *marker;*
   char *note;f }  FN;    FN *pending_notes = (FN *) NULL;  G /* A method for remembering footnotes.  Note that this list gets outputh%    at the end of the current node. */e remember_note (marker, note)      char *marker, *note;  {h*   FN *temp = (FN *) xmalloc (sizeof (FN));  %   temp->marker = savestring (marker);e!   temp->note = savestring (note);a   temp->next = pending_notes;    pending_notes = temp;    footnote_count++;e }   + /* How to get rid of existing footnotes. */_ free_pending_notes ()m {    FN *temp;e  /   while ((temp = pending_notes) != (FN *) NULL)t     {e       free (temp->marker);       free (temp->note);*       pending_notes = pending_notes->next;       free (temp);     }i   first_footnote_this_node = 1;    footnote_count = 0;( }k  4 /* What to do when you see a @footnote construct. */    /* Handle a "footnote"."     footnote *{this is a footnote}7     where "*" is the marker character for this note. */s cm_footnote () {*   char *marker;y
   char *note;y     get_until ("{", &marker);h   canon_white (marker);n  $   /* Read the argument in braces. */   if (curchar () != '{')     {*i       line_error ("`@%s' expected more than just `%s'.  It needs something in `{...}'", command, marker);x       free (marker);
       return;e     }s   else     {i       int braces = 1; %       int temp = ++input_text_offset;]       int len;         while (braces) 	{" 	  if (temp == size_of_input_text) 	    {A 	      line_error ("No closing brace for footnote `%s'", marker);/ 	      return; 	    }   	  if (input_text[temp] == '{')m 	    braces++;$ 	  else if (input_text[temp] == '}') 	    braces--;% 	  else if (input_text[temp] == '\n')  	    line_number ++;  
 	  temp++; 	}  +       len = (temp - input_text_offset) - 1;r'       note = (char *)xmalloc (len + 1);T:       strncpy (note, &input_text[input_text_offset], len);       note[len] = '\0';l       input_text_offset = temp;)     }I  &   if (!current_node || !*current_node)     {e:       line_error ("Footnote defined without parent node");       free (marker);       free (note);
       return;*     }h     if (!*marker)N     {t       free (marker);         if (number_footnotes)a 	{! 	  marker = (char *)xmalloc (10);r3 	  sprintf (marker, "%d", current_footnote_number);  	  current_footnote_number++;N 	}
       else 	marker = savestring ("*");T     };     remember_note (marker, note);   2   /* Your method should at least insert MARKER. */   switch (footnote_style)      {      case SeparateNode:%       add_word_args ("(%s)", marker);e#       if (first_footnote_this_node)a 	{ 	  char *temp_string;(   	  temp_string = (char *)LE 	    xmalloc ((strlen (current_node)) + (strlen ("-Footnotes")) + 1);)  ; 	  add_word_args (" (*note %s-Footnotes::)", current_node);-& 	  strcpy (temp_string, current_node);& 	  strcat (temp_string, "-Footnotes");J 	  remember_node_reference (temp_string, line_number, followed_reference); 	  free (temp_string);  	  first_footnote_this_node = 0; 	}       break;       case EndNode:f%       add_word_args ("(%s)", marker);d       break;       default:       break;     }d   free (marker);   free (note); }e  D /* Non-zero means that we are currently in the process of outputting    footnotes. */) int already_outputting_pending_notes = 0;e  C /* Output the footnotes.  We are at the end of the current node. */o output_pending_notes ()= {l   FN *footnote = pending_notes;p     if (!pending_notes)e     return;)     switch (footnote_style)n     {e       case SeparateNode:       {l' 	char *old_current_node = current_node;%* 	char *old_command = savestring (command);  $ 	already_outputting_pending_notes++;J 	execute_string ("@node %s-Footnotes,,,%s\n", current_node, current_node);$ 	already_outputting_pending_notes--;! 	current_node = old_current_node;d 	free (command); 	command = old_command;-       }i       break;       case EndNode:m       close_paragraph ();l       in_fixed_width_font++;=       execute_string ("---------- Footnotes ----------\n\n");i       in_fixed_width_font--;       break;     }/  .   /* Handle the footnotes in reverse order. */   {*H     FN **array = (FN **) xmalloc ((footnote_count + 1) * sizeof (FN *));  (     array[footnote_count] = (FN *) NULL;  !     while (--footnote_count > -1)c       {"" 	array[footnote_count] = footnote; 	footnote = footnote->next;n       }        filling_enabled = 1;     indented_fill = 1;  .     while (footnote = array[++footnote_count])       {    	switch (footnote_style) 	  { 	  case SeparateNode:) 	  case EndNode:C 	    execute_string ("(%s)  %s", footnote->marker, footnote->note);b 	    close_paragraph (); 	    break;  	  }       }x     close_paragraph ();      free (array);g   }( }     F /* **************************************************************** */F /*                                                                  */@ /*              User definable Macros (text substitution)	    */F /*                                                                  */F /* **************************************************************** */   #if defined (HAVE_MACROS)e  & /* Array of macros and definitions. */, MACRO_DEF **macro_list = (MACRO_DEF **)NULL;  2 int macro_list_len = 0;		/* Number of elements. */8 int macro_list_size = 0;	/* Number of slots in total. */  I /* Return the macro definition of NAME or NULL if NAME is not defined. */M MACRO_DEF *l find_macro (name)r      char *name; {    register int i;l   register MACRO_DEF *def;     def = (MACRO_DEF *)NULL;7   for (i = 0; macro_list && (def = macro_list[i]); i++) &     if (strcmp (def->name, name) == 0)       break;     return (def);y }o  A /* Add the macro NAME with DEFINITION to macro_list.  FILENAME ise?    the name of the file where this definition can be found, and B    LINENO is the line number within that file.  If a macro alreadyB    exists with NAME, then a warning is produced, and that previous     definition is overwritten. */ void. add_macro (name, definition, filename, lineno)      char *name, *definition;e      char *filename;      int lineno; {:   register MACRO_DEF *def;     def = find_macro (name);     if (!def)      {z0       if (macro_list_len + 2 >= macro_list_size)$ 	macro_list = (MACRO_DEF **)xreallocB 	  (macro_list, ((macro_list_size += 10) * sizeof (MACRO_DEF *)));  M       macro_list[macro_list_len] = (MACRO_DEF *)xmalloc (sizeof (MACRO_DEF)); 9       macro_list[macro_list_len + 1] = (MACRO_DEF *)NULL;r  '       def = macro_list[macro_list_len];s       macro_list_len += 1;$       def->name = savestring (name);     }    else     { +       char *temp_filename = input_filename;h"       int temp_line = line_number;  >       warning ("The macro `%s' is previously defined.", name);  %       input_filename = def->filename;r        line_number = def->lineno;  A       warning ("Here is the previous definition of `%s'.", name);*  %       input_filename = temp_filename;o       line_number = temp_line;         free (def->filename);h       free (def->definition);      }o  (   def->filename = savestring (filename);   def->lineno = lineno;i,   def->definition = savestring (definition); }i    H /* Delete the macro with name NAME.  The macro is deleted from the list,C    but it is also returned.  If there was no macro defined, NULL isd    returned. */e MACRO_DEF *n delete_macro (name)o      char *name; {    register int i;t   register MACRO_DEF *def;     def = (MACRO_DEF *)NULL;7   for (i = 0; macro_list && (def = macro_list[i]); i++)n&     if (strcmp (def->name, name) == 0)       {n, 	memcpy (macro_list + i, macro_list + i + 1,; 	       ((macro_list_len + 1) - i) * sizeof (MACRO_DEF *));y 	break;r       }    return (def);m }s  @ /* Execute the macro passed in DEF, a pointer to a MACRO_DEF. */ void execute_macro (def)l      MACRO_DEF *def; {r     if (def != (MACRO_DEF *)NULL)(     {        char *line, *string;         get_until ("\n", &line);  H       if (curchar () == '\n')	/* as opposed to the end of the file... */ 	{ 	  line_number++;y 	  input_text_offset++;t 	}N       string = (char *)xmalloc (1 + strlen (def->definition) + strlen (line));'       strcpy (string, def->definition);o       strcat (string, line);       free (line);  &       execute_string ("%s\n", string);       free (string);     }a }m   int* cm_macro ()  {*   register int i;o    char *line, *name, *expansion;     get_rest_of_line (&line);p   canon_white (line);t  5   for (i = 0; line[i] && !whitespace (line[i]); i++);e   name = (char *)xmalloc (i);    strncpy (name, line, i);   name[i] = '\0';      while (whitespace (line[i]))     i++;  >   add_macro (name, line + i, input_filename, line_number - 1);   free (line);   free (name); }p   int;
 cm_unmacro ()_ {e   register int i;n   char *line, *name;   MACRO_DEF *def;_     get_rest_of_line (&line);t   canon_white (line);   5   for (i = 0; line[i] && !whitespace (line[i]); i++);/   name = (char *)xmalloc (i);t   strncpy (name, line, i);   name[i] = '\0';e     def = delete_macro (name);  
   if (def)     {        free (def->filename);*       free (def->name);"       free (def->definition);r       free (def);      }u     free (line);   free (name); }! #endif /* HAVE_MACROS */  F /* **************************************************************** */F /*                                                                  */F /*                  Looking For Include Files                       */F /*                                                                  */F /* **************************************************************** */  F /* Given a string containing units of information separated by colons,I    return the next one pointed to by INDEX, or NULL if there are no more. 5    Advance INDEX to the character after the colon. */+ char *" extract_colon_unit (string, index)      char *string;      int *index; {h   int i, start;   
   i = *index;n  (   if (!string || (i >= strlen (string)))     return ((char *)NULL);  F   /* Each call to this routine leaves the index pointing at a colon ifE      there is more to the path.  If I is > 0, then increment past thetI      `:'.  If I is 0, then the path has a leading colon.  Trailing colons D      are handled OK by the `else' part of the if statement; an empty(      string is returned in that case. */   if (i && string[i] == ':')     i++;     start = i;  ,   while (string[i] && string[i] != ':') i++;  
   *index = i;      if (i == start)      {        if (string[i]) 	(*index)++;  4       /* Return "" in the case of a trailing `:'. */       return (savestring (""));      }S   else     {        char *value;  0       value = (char *)xmalloc (1 + (i - start));3       strncpy (value, &string[start], (i - start));h       value [i - start] = '\0';r         return (value);F     }s }   A /* Return the full pathname for FILENAME by searching along PATH.-=    When found, return the stat () info for FILENAME in FINFO.g;    If PATH is NULL, only the current directory is searched.n<    If the file could not be found, return a NULL pointer. */ char *- get_file_info_in_path (filename, path, finfo)e      char *filename, *path;g      struct stat *finfo; {r   char *dir;   int result, index = 0;     if (path == (char *)NULL)o     path = ".";n  =   /* Handle absolute pathnames. "./foo", "/foo", "../foo". */    if (*filename == '/' ||_       (*filename == '.' &&        (filename[1] == '/' || . 	(filename[1] == '.' && filename[2] == '/'))))     {i&       if (stat (filename, finfo) == 0)  	return (savestring (filename));
       else 	return ((char *)NULL);e     }n  1   while (dir = extract_colon_unit (path, &index))o     {e       char *fullpath;%         if (!*dir) 	{ 	  free (dir); 	  dir = savestring ("."); 	}  H       fullpath = (char *)xmalloc (2 + strlen (dir) + strlen (filename));1       sprintf (fullpath, "%s/%s", dir, filename);        free (dir);_  &       result = stat (fullpath, finfo);         if (result == 0) 	return (fullpath); 
       else 	free (fullpath);a     })   return ((char *)NULL); }+