9 %% $Id: xyguide.man,v 2.12 1994/10/25 11:34:25 kris Exp $  %% %% ``XY-pic User's Guide''. < %% Copyright (c) 1991-1994	Kristoffer H. Rose	<kris@diku.dk> %%J %% This file is part of the XY-pic package for graphs and diagrams in TeX.F %% See the companion README and INSTALL files for further information.< %% Copyright (c) 1991-1994	Kristoffer H. Rose	<kris@diku.dk> %%M %% The XY-pic package is free software; you can redistribute it and/or modify K %% it under the terms of the GNU General Public License as published by the I %% Free Software Foundation; either version 2 of the License, or (at your  %% option) any later version.  %%L %% The XY-pic package is distributed in the hope that it will be useful, butM %% WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY K %% or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License  %% for more details. %%J %% You should have received a copy of the GNU General Public License alongJ %% with this package; if not, write to the Free Software Foundation, Inc.,* %% 675 Mass Ave, Cambridge, MA 02139, USA. %%( \documentstyle[twocolumn,xydoc]{article}H \def\LaTeXe{{\LaTeX\kern.15em$2_{\textstyle\varepsilon}$}} % avoid `bug' \CompileAllDiagrams{xyguide-}  \begin{document}   % TOPMATTER    \title{	\XY-pic User's Guide }7 \author{ Kristoffer H. Rose\quad<kris@diku.dk>\thanks{% : 		DIKU (Computer Science dept.), University of Copenhagen,> 		Universitetsparken~1, DK--2100 K{\o}benhavn {\O}, Denmark.}}. \date{Version \xyversion, \printdate{\xydate}}
 \maketitle   \begin{abstract}E 	\XY-pic is a package for typesetting graphs and diagrams using plain B 	\TeX, \LaTeX, \AMS-\LaTeX, and \AMS-\TeX.  Several modes of input9 	are supported; this guide concentrates on how to typeset D 	`matrix-like' diagrams like "commutative diagrams" in the following 	style:  %  \begin{code} \diagram  U \ddrto_y \drto \drrto^x \\ ,   & X \times_Z Y \dto^q \rto_p & X \dto_f \\"   & Y \rto^g                   & Z \enddiagram 
 \end{code} $$\docode$$  % ' 	was typeset by the \XY-pic input lines  %  \displaycode	 \noindent  % 2 	Such diagrams have the following characteristics: %  \begin{itemize}  \item C 	Specified as a matrix of entries that are automatically aligned in  	rows and columns. \item A 	Any entry may be connected to any other entry using a variety of 4 	arrow styles all rotated and stretched as required. \item A 	Arrows may be decorated with labels that are tied to a specified < 	point along the arrow and extend in a particular direction. \item D 	Arrows may be paired, cross each other, and visit/bend around other 	entries `on the way'. \item C 	Complete `low-level' graphic language for drawing independently of  	the matrix structure.
 \end{itemize}  % B 	\REMARK: \XY-pic release \xyversion\ is also a $\beta$-release of> 	\XY-pic version~3, referred to here as "v3".  This is greatlyF 	enhanced and extended relative to version~2.  Many features described? 	in this document are therefore obsolete but remain valid (as a E 	special `compatibility' mode).  We remark it at the end of a section 9 	whenever this is the case; look in the \XY-pic Reference , 	Manual~\cite{R94:XY-picRM} for the details.   \end{abstract}   \tableofcontents \listoffigures
 \goodbreak   % TEXT       \section*{Introduction}  % @ 	This guide explains some features of \XY-pic version~2 that areF 	related to diagram typesetting -- newer features are described in the< 	reference manual~\cite{R94:XY-picRM} (some are mentioned inC 	italicised comments).  It assumes that you have some experience in 3 	using \TeX\ for typesetting mathematics, \eg, have D 	studied~\cite[ch.~16--19]{K84:TeXbook}, \cite[sec.~3.3]{L94:LaTeX}, 	or~\cite{S90:JoyT}.  : 	The first section describes what you need to get started.F 	Section~??[arrows] and~??[entries] explain advanced use of arrows andC 	entries, respectively.  Section~??[avail] explains where and under ; 	what conditions \XY-pic is available and points to further F 	information.  Throughout we give exercises that you should be able toC 	solve as you go along; all exercises are answered at the end, just  	prior to the bibliography.        \section{Basics} ??=[basics]  % F 	This section explains the \XY-diagram construction concepts needed to7 	get started with typesetting category theory diagrams.      \subsection{Loading} ??=[basics.loading]  % 7 	\XY-pic is loaded by inserting a line with the command  % 
 \begin{defs1}   ??c![\input xypic]  \end{defs1}  \noindent\unskip % 4 	in the definitions part of your document (after anyA 	??c![\documentstyle] line).\footnote{This will load \XY-pic in a E 	special `compatibility mode' which defines the commands described in @ 	this guide as they have been available since version 2.4 of the7 	package.  Other modes are available; see the Reference ) 	Manual~\cite{R94:XY-picRM} for details.}  %  \begin{quote}\it< 	This describes loading in compatibility mode -- in "v3" the9 	individual features of \XY-pic can be loaded separately.  \end{quote}      \subsection{Entries} ??=[basics.entries]  % % 	A diagram is created by the commands  % 
 \begin{defs1} '  ??c![\diagram]~\dots~??c![\enddiagram]  \end{defs1}  \noindent\unskip % B 	where the `\dots' should be replaced by "entries"??w[entry] to be$ 	"aligned in rows and columns" where %  \begin{itemize}  \item . 	entries in a row are separated by ??c![&] and \item   	rows are separated by ??c![\\].
 \end{itemize}  % 
 	For example,  \begin{code} \diagram"   A &\sum_{i=n}^m {i^2} \framed \\     & \bullet & D \ulto  \enddiagram 
 \end{code} $$\docode$$  %  	was typeset by  %  \displaycode % 	 \noindent  	Notice the following: %  \begin{itemize}  \item 6 	entries are typeset as mathematics (in `text style'), \item  	all entries are centered, \item D 	the separation between rows and columns is usually quite large in a	 	diagram,  \item C 	entries at the end of rows that are empty may be omitted, and most 
 	importantly:  \item C 	``\XY-commands'' (like |\framed| and |\ulto| here) can decorate an F 	entry and connect it with others without changing the diagram layout.
 \end{itemize}  % 9 	The style and spacing can be changed; we discuss that in  	section~??[entries].  %  \begin{quote}\itA 	In "v3" several matrices can be typeset in the same picture (and = 	refer to each other's entries), and matrices can be rotated.  \end{quote}      \subsection{Arrows}  ??=[basics.arrows] % A 	An `??w![arrow]' in an \XY-pic diagram is a generic term for the D 	drawn decorations that are added to the basic matrix structure.  InE 	\XY-pic all arrows must be specified along with the entry they start D 	in; this is called their "??w![base entry]".  Each particular arrow4 	then refers explicitly to its "??w![target entry]".  F 	The most commonly used arrows have names starting with either~??c![u]E 	or ??c![d] for up or down, followed by either ??c![l] or ??c![r] for B 	left and right, \eg, the arrow |\drto| reads `down and then rightF 	to'.  Figure~??[f:directions] shows the possible straight arrows, allE 	leaving the entry "base" and ending at the entry with their name in. C 	The relative coordinates specified in this way are purely logical, D 	\eg, if the diagram contains very wide entries then the arrows willD 	be nearly horizontal.  All the constructed arrows are aligned alongB 	the line between the centers of the base and target entries; theyC 	will not automatically disappear under entries that they cross (we : 	discuss how this is achieved in section~??[arrows.pass]).   \begin{figure*}  $$\let\1=\relax 	  \diagram T    \1??c![\uullto]&\1??c![\uulto]	&\1??c![\uuto]	&\1??c![\uurto]  &\1??c![\uurrto]\\Y    \1??c![\ullto]&\1??c![\ulto]\ulto&\1??c![\uto]\uto&\1??c![\urto]\urto&\1??c![\urrto]\\ &    \1??c![\llto]	&\1??c![\lto]\lto	&\1    		\uulto				\uurto		 &    \ullto	\ulto 		\uto 		\urto		\urrto    		\lto       	"base"		\rto &    \dllto	\dlto 		\dto 		\drto		\drrto 		\ddlto				\ddrto( 						&\1??c![\rto]\rto	&\1??c![\rrto]\\Y    \1??c![\dllto]&\1??c![\dlto]\dlto&\1??c![\dto]\dto&\1??c![\drto]\drto&\1??c![\drrto]\\ Q    \1??c![\ddllto]&\1??c![\ddlto]	&\1??c![\ddto]	&\1??c![\ddrto]	&\1??c![\ddrrto] 
 \enddiagram$$ 2 \caption{Standard directions for straight arrows.} ??=[f:directions] 
 \end{figure*}   C 	If you are making large diagrams where the above predefined arrows B 	are not sufficient then you can always resort to the general formA 	|\xto[|"hop"|]|??c[\xto] where "hop" should be a sequence of the C 	letters |dulr| as described above, \eg, |\xto[u]| is equivalent to 8 	|\uto| but |\xto[uuulll]| has no short-form equivalent.  D 	The directions also exist with |to| replaced by various other basic
 	line styles:  $$-  \spreaddiagramcolumns{-2pc}\objectwidth{3pc} 	  \diagram #   \relax ??c![to]\xto+<1pc,-2pc>*{} )    &\relax ??c![line]\xline+<1pc,-2pc>*{} .     &\relax ??c![dashed]\xdashed+<1pc,-2pc>*{}/      &\relax ??c![dotted]\xdotted+<1pc,-2pc>*{} 0       &\relax ??c![double]\xdouble+<1pc,-2pc>*{}
        &\\  \enddiagram $$   \begin{exercise} \begin{code} \diagram   \bullet \ddashed\drdouble\rline 	 & \bullet \ddotted \\   \bullet & \bullet \lto  \enddiagram 
 \end{code} %  	Typeset $$ \docode  $$ \answercode ( \answertext{The author did \displaycode} \end{exercise} %  \begin{quote}\itE 	In "v3" mnemonic names are used for arrows, \eg, the five basic line E 	styles above correspond to arrows |{->}|, |{-}|, |{--}|, |{..}|, and  	|{=}|.  \end{quote}      \subsection{Labels}  ??=[basics.labels]E 	You can put labels on arrows.  Labels are conceptualized as sub- and > 	superscripts on arrows such that they are placed in the usualD 	positions (as `limits'), \ie, |^| reads `above' and |_| below on anF 	arrow pointing "right" but the positions depend only on the direction 	of the arrow.  For example, \begin{code} \diagram  X \rto^a_b & Y & Z \lto^A_B \enddiagram 
 \end{code} \displaycode %  \noindent will set %  $$\docode$$  % A 	Labels that do not consist of a single letter, digit, or control - 	sequence, should be enclosed in |{|\dots|}|.   A 	The placement of the labels only depends on the direction of the = 	arrow: it is placed perpendicular to the center of the arrow F 	(measured from the centers of the objects at the ends).  More details: 	concerning labels are given in section~??[arrows.labels].   \begin{exercise} \begin{code}
 $$\diagram  A \rto^f \drto_{f;g}    & B \dto^g \drto^{g;h} \\    & C \rto_h & D \enddiagram  \qquad(2)$$ 
 \end{code} % / 	Typeset the second axiom of category theory as  %  \docode  %  \answercode 5 \answertext{The author used the display \displaycode}  \end{exercise}     \subsection{Breaks}  ??=[basics.breaks]? 	It is also possible to `break' an arrow with a label using the  	character~??c![|]:  %  \begin{code}! \diagram A \rto|f & B \enddiagram 
 \end{code} \displaycode	 \noindent 	 	will set  %  $$\docode$$  % G 	If you just want an empty break you should use the special ??c![\hole]  	break: the arrow  \begin{code}% \diagram A \rto|\hole & B \enddiagram 
 \end{code} % 0 	{\docode} was typeset by including \thecode\ in@ 	the text.  You may mix a break with other labels, but the break3 	should always be last.  There is more on breaks in  	section~??[arrows.tips].    \begin{exercise} \begin{code}
 $$\diagram*  A \dto_f \rto^f & B \dlto|{i_B} \dto^g \\  B        \rto_g & C \enddiagram  \qquad(1)$$ 
 \end{code} % : 	Typeset the first axiom of category theory as the display % 
 {\docode}% %  \answercode ) \answertext{The author used \displaycode}  \end{exercise}     \subsection{Bends} ??=[basics.bends]  % F 	There are special versions of |to|-arrows that go `around' a neighborB 	entry and point to something `behind' it: here are the horizontal 	ones: %  $$ \spreaddiagramcolumns{-1pc}  \diagram \\+   \relax \txt\tt{ \string\lltou\string^a \\  	  	  \string\lltod\string^a }  &{\Box}'  &\relax \txt\it{entry\\with\\commands}  		\lltou^a \rrtou^a  		\lltod^a \rrtod^a   &{\Box}+  &\relax \txt\tt{ \string\rrtou\string^a \\  	   	  \string\rrtod\string^a }  \\&  \enddiagram  $$ % B 	There are similar vertical ones named ??c![\ddtol], ??c![\ddtor],E 	??c![\uutol], and ??c![\uutor], and there is a special set of `self'  	arrows: $$ \spreaddiagramrows{-1pc} \diagram \\0  \relax|\toul^a|\toul^a &\relax |\tour^a|\tour^a \\0  \relax|\todl^a|\todl^a &\relax |\todr^a|\todr^a \\&  \enddiagram  $$) ??c[\toul]??c[\tour]??c[\todl]??c[\todr]%  	and $$ \spreaddiagramrows{-1pc} \diagram \\1  \relax |\tolu^a|\tolu^a &\relax |\toru^a|\toru^a  \\1  \relax |\told^a|\told^a &\relax |\tord^a|\tord^a  \\&  \enddiagram  $$) ??c[\told]??c[\tord]??c[\tolu]??c[\toru]%  % E 	These only exist for the |to| line style. In section~??[arrows.bend] 2 	we explain how other variants can be constructed.   \begin{exercise} 	Typeset %  \begin{code} \diagram#  x \rrtou|f && f(x) \lltod|{f^{-1}}  \enddiagram 
 \end{code} $$ \docode  $$ \answercode ( \answertext{The author did \displaycode} \end{exercise}    $ \subsection{Speeding up typesetting} ??=[basics.speeding] % D 	One thing that you will notice is that \XY-pic is sometimes slow inD 	typesetting diagrams (this is to be expected considering the numberC 	of drawing operations performed as reflected by the number last in @ 	each |xymatrix| message).  You can instruct \XY-pic to save theF 	details of a particular diagram in a file "name"|.xyc| (for `compiledE 	\XY-pic') every time the diagram changes by replacing the |\diagram| 
 	command with  % 
 \begin{defs1}  |\diagramcompileto{|"name"|}|  \end{defs1}  \noindent\unskip % E 	This will cut the typesetting time considerably whenever the diagram  	is retypeset without change.   > 	\NOTE: this is only safe for diagrams that obey the followingD 	restriction: "all entries should start with a non-expandable token"< 	like an ordinary (non-active) character, |\relax|, or |{}|. %  \begin{quote}\it= 	This is a "v3" feature mentioned here because it is a common 
 	question. \end{quote}         \section{More Arrows and Labels} ??=[arrows]  % ? 	In this section we explain a number of variations of the arrow 2 	commands that are useful in commutative diagrams.    + \subsection{Explicit positioning of labels}  ??=[arrows.labels] % D 	The label commands explained in section~??[basics.labels] place the@ 	label text near the center of the arrow.  This, however, may beF 	changed by inserting a "??w![place]" between the ??c![^], ??c![_], or> 	??c![|], and the actual label.  In general you may insert the 	following:  %  \begin{itemize}  \item A 	??c![<] will place the label at the point where the actual arrow / 	begins, \ie, `appears from under' the base, so  %  \begin{code}# \diagram A \rto^<{+} &B \enddiagram 
 \end{code} % " 	\thecode\ will typeset {\docode}.   \item F 	Similarly, ??c![>] will place the label at the point where the actual3 	arrow ends, \ie, `disappears below' the target, so  %  \begin{code}# \diagram A \rto^>{+} &B \enddiagram 
 \end{code} %   	\thecode\ will typeset \docode.   \item E 	??c![<<] and ??c![>>] will place the following label at a point just D 	a bit\footnote{`A bit' is in fact a \TeX\ {\tt\string\jot} which is; 	3pt.}\ further from the beginning and end of the arrow, so  %  \begin{code}$ \diagram A \rto^>>{+} &B \enddiagram
 \end{code} % ? 	\thecode\ will typeset \docode.  Using more |<|s will move the  	label further in.   \item > 	More |<|s and |>|s may be given to make this distance larger: %  \begin{code}% \diagram A \rto^>>>{+} &B \enddiagram 
 \end{code} %   	\thecode\ will typeset \docode.   \item D 	A factor in ??c![()]s: $|(|a|)|$ indicates that the label should beE 	`tied' to the point $a$ of the way from the center of the base entry B 	(called ??c![(0)]) to the center of the target (called ??c![(1)]) 	instead of in the middle, so  %  \begin{code}& \diagram A \rto^(.3){+} &B \enddiagram
 \end{code} %   	\thecode\ will typeset \docode.   \item A 	A factor can be given "after" some |<| or |>|s: in that case the E 	place is computed as if the base was the place specified by the |<|s 0 	and the target the place specified by the |>|s: %  \begin{code}& \diagram A \rto^<(0){+} &B \enddiagram
 \end{code} %2" 	\thecode\ will typeset {\docode}.   \item-A 	Finally, a ??c![-] means the same as |<>(.5)|, \ie, place at the	B 	"middle of the arrow" rather than the middle between the base and 	target, sog %s \begin{code} \diagram'  A\times B\times C\times D \rto^-{+} &Be \enddiagram.
 \end{code} %( 	 \docode\ was typeset byR %	 \displaycode %% 	It becomesi %a \diagram&  A\times B\times C\times D \rto^{+} &B \enddiagram  %i 	without~|-|~.  
 \end{itemize}r   \begin{exercise} \begin{code} \diagram#  A \dto ^>>\ast ^b \drto ^>>\ast ^co    \rto ^>>\ast ^d  & D \\#  B                  & C \enddiagram 
 \end{code} %i 	Typeset $$ \docoded $$ \answercode 5 \answertext{The author used the display \displaycode}t \end{exercise}   r \subsection{Extra tips}  ??=[arrows.tips]- 	You can use the `break' feature described iniD 	section~??[basics.breaks] to add extra arrow tips.  This is done by7 	using special `standard tip' labels shown as $\ell$ inp& 	$|\drto|\,\ell$ in figure~??[f.tips].   \begin{figure*}, $$F  \spreaddiagramrows{-1pc} \spreaddiagramcolumns{1pc} \objectwidth{3pc}	  \diagraml/   \relax |\tip| \POS[]+DL\xto[]+<3pc,-2pc>|\tipa2   &\relax |\stop| \POS[]+DL\xto[]+<3pc,-2pc>|\stop  \\   \\g1   \relax |\atip| \POS[]+DL\xto[]+<3pc,-2pc>|\atipr4   &\relax |\astop| \POS[]+DL\xto[]+<3pc,-2pc>|\astop5    &\relax |\ahook| \POS[]+DL\xto[]+<3pc,-2pc>|\ahooks6     &\relax |\aturn| \POS[]+DL\xto[]+<3pc,-2pc>|\aturn  \\h  \\\1   \relax |\btip| \POS[]+DL\xto[]+<3pc,-2pc>|\btipe4   &\relax |\bstop| \POS[]+DL\xto[]+<3pc,-2pc>|\bstop5    &\relax |\bhook| \POS[]+DL\xto[]+<3pc,-2pc>|\bhookl6     &\relax |\bturn| \POS[]+DL\xto[]+<3pc,-2pc>|\bturn$ 	\save \go+<3pc,-2pc>\Drop{}\restore  \\e  \\e=   \relax |{\tip\stop}| \POS[]+DL\xto[]+<3pc,-2pc>|{\tip\stop}tB   &\relax |{\rotate\tip}| \POS[]+DL\xto[]+<3pc,-2pc>|{\rotate\tip}#    &\relax |{\rotate(1)\tip\astop}| 2 	\POS[]+DL\xto[]+<3pc,-2pc>|{\rotate(1)\tip\astop}B     &\relax |{\squash{+}}| \POS[]+DL\xto[]+<3pc,-2pc>|{\squash{+}}(      \save \go+<3pc,-2pc>\Drop{}\restore  \\   \enddiagram $$ \caption{Standard tips.} ??=[f.tips]o
 \end{figure*}e  E 	Tips with more than one component must be enclosed in |{}|, and tips D 	can be rotated $180^\circ$ by the |\rotate| prefix or optionally by5 	the factor $|(|f|)|$, ${-2}\lt f\le 2$, to rotate ityF 	$f\times90^\circ$ clockwise.  Furthermore you can enclose any math inB 	$|\squash{|\dots|}|$ to make it of zero size and use it as a tip;@ 	|\squash| attempts to center it but sometimes you might have to9 	`help' by adding spacing (\eg, using |\,| and |\strut|).u  C 	An arrow may have several breaks.  They must, however, be given in A 	the same order as they appear from the base to the target of thed 	arrow as illustrated here:- $$ \spreaddiagramcolumns{1pc} \begin{tabular}{ll} L  |\rto||a||>\stop|\quad &{\diagram{\Box} \rto|a|>\stop	&{\Box}\enddiagram}\\L  |\rto||<\stop||a|\quad &{\diagram{\Box} \rto|<\stop|a	&{\Box}\enddiagram}\\  |\rto||<\hole||<<\stop|\quad < 	&{\diagram{\Box} \rto|<\hole|<<\stop		&{\Box}\enddiagram}\\G  |\rto||>>\tip|\quad &{\diagram{\Box} \rto|>>\tip	&{\Box}\enddiagram}\\e  |\rto||<\hole||<<\ahook|\quad< 	&{\diagram{\Box}\rto|<\hole|<<\ahook		&{\Box}\enddiagram}\\  |\rto||<<\hole||<<<\tip|\quad> 	&{\diagram{\Box} \rto|<<\hole|<<<\tip 		&{\Box}\enddiagram}\\  |\rto||>{\squash\circ}|\quado? 	&{\diagram{\Box} \rto|>{\squash\circ}	  	&{\Box}\enddiagram}\\r  |\rto||<{\rotate\tip}|\quad= 	&{\diagram{\Box} \rto|<{\rotate\tip} 		&{\Box}\enddiagram}\\ "  |\rline||>{\rotate(.6)\tip}|\quad? 	&{\diagram{\Box} \rline|>{\rotate(.6)\tip}	&{\Box}\enddiagram}e
 \end{tabular}i $$F 	Notice how we use an extra |||<\hole| break to shorten arrows to makeF 	space for `large' tails like hooks that have most of their ink on theB 	wrong side.\footnote{In version 2.6 and before this was automatic> 	with a |||<<| break but this was a bug which has been fixed.}  @ 	The above tips work with the basic arrow types |to| (as shown),E 	|line|, |dashed|, and |dotted|, however, only |\stop| works with all @ 	arrows, \ie, also with |double|.  If you want an arrowhead on a) 	|double| arrow then you must use |\Tip|:  $$ \begin{tabular}{ll}a  |\rdouble||>\Tip|\quad 7   &{\diagram{\Box} \rdouble|>\Tip &{\Box}\enddiagram}\\ '  |\rdouble||<\stop||>>\Tip||>\Tip|\quadeE   &{\diagram{\Box} \rdouble|<\stop|>>\Tip|>\Tip &{\Box}\enddiagram}\\\
 \end{tabular}d $$ %e \begin{quote}\itA 	The "v3" arrow command uses a much simpler scheme: it interprets 3 	arrow generic definitions, \eg, |{||-->>}| becomeso 	\xygraph{[]:@{|-->>}[r]}. \end{quote}y   i$ \subsection{Sliding arrows sideways} ??=[arrows.sliding]tB 	It is often desirable to have several arrows between two objects.E 	This can be done by sliding either or both arrows sideways by givingmB 	the distance as an optional \TeX\ dimension enclosed in |<>|s: it= 	specifies how far `sideways' the arrow should be moved, \eg,n %m \begin{code} \diagram  A \drto<1ex>^a_{.} \\    & B \ulto<1ex>^b \rto<1ex>^ca      & C \lto<1ex>^d_{.} \enddiagramo
 \end{code} \displaycode \noindent will typeset $$\docode$$t %cF 	A positive distance will slide the arrow in the `|^|-direction', \eg,A 	the two arrows above are slid in the direction of the labels~$a$pC 	and~$b$, respectively; a negative distance in the `|_|-direction'.e? 	The distance |<1ex>| is often appropriate since it corresponds E 	roughly to the height of letters like `x', independently of the used  	type size.a %e \begin{quote}\itA 	In "v3" it is also possible to curve arrows and there is specialt 	support for 2-cells.c \end{quote}d     \subsection{More targets}d ??=[arrows.targets]d % A 	In the general arrow constructions |\xto|, |\xline|, |\xdashed|,eA 	|\xdotted|, and |\xdouble|, the target address can be given in ae? 	large number of formats called "positions".  The full range ofs, 	possibilities is described in the referenceF 	manual~\cite{R94:XY-picRM}; here is a number of useful possibilities: %a \begin{itemize}` \itemm@ 	$|[|r|,|c|]|$~, where $r,c$ are integers, denotes the "relative@ 	entry" found $r$~rows below and $c$~columns to the right of theE 	current entry (the current entry itself is thus |[0,0]|).  Each suchh2 	pair corresponds to a |[|"hop"|]| as described in@ 	section~??[basics.arrows], \eg, |[1,2]| is the same as |[drr]|.   \itemr? 	$|"|r|,|c|"|$~, where $r,c$ are positive integers, denotes theo@ 	"absolute entry" found in the $r$th row and $c$th column of the( 	diagram; the top left entry is |"1,1"|.   \itemoE 	$t'|;|t$~, where $t'$ is any target, changes the ??!w[base entry] of.F 	the present arrow to $t'$ and then sets the target to $t$ relative to! 	the original base.  For example,w %a \begin{code} \diagram  A \\r  B & C \ulto    <1ex>i        \ulto;[] <1ex>  \enddiagramT
 \end{code} \displaycode %h \noindent typesets $$ \docodec $$C 	\ie~the |\ulto| arrow "starts" at the |[ul]| entry and ends in theo> 	current entry (remember from \S??[basics.arrows] that |\ulto| 	is the same as |\xto[ul]|).  
 \end{itemize}e %sA 	Composite targets may be constructed: any complete target can be  	followed by %e \begin{itemize}e \itemvD 	??c![+]"vector" or ??c![-]"vector" which changes the target to be aE 	zero-sized one at the position obtained by adding or subtracting ther 	"vector" to its center, or    \itemeF 	??c![!]"vector" which moves the center of the target by the "vector";
 \end{itemize}l %o& 	where a "vector" should have the form %t \begin{itemize}  \itemsA 	$|<|D_x|,|D_y|>|$ , where $D_x,D_y$ are \TeX\ dimensions, is the* 	vector with those coordinates,    \item[A 	the following `corner offsets' of a target are vectors as shown:r  $$\I \def\[#1]{\POS"box"+0;"box"+#1 **\dir{-} ?>*\dir{>} +/1pc/ *\hbox{\tt#1}}\ %c, \xy 0.(-11,-6).(11,6)!C="box"*\frm{.},"box";G  "box"+L**\dir{.}, "box"+R**\dir{.}, "box"+D**\dir{.}, "box"+U**\dir{.}  %	  \[L] \[R] \[D] \[U]  \[DL]\[DR]\[UL]\[UR]	 \endxy $$, 	(they must be specified in upper case), and   \item\ 	|0| is the zero vector.  
 \end{itemize}l %\C 	These constructions are useful for pointing to corners of entries,[ 	\eg,] %? \begin{code} \diagram   \left[\sum^i\right] & j \lto+UR \enddiagrama
 \end{code} \displaycode %t \noindent will typeset $$ \docodee $$   \begin{exercise} % D 	What is the difference between a target $t$ and the target $t$|+0|?4 \answertext{The size: $t$|+0| always has zero size.} \end{exercise} %o \begin{quote}\itD 	The position language of "v3" is much richer than this: there it isF 	possible to build stacks of positions, typeset material in the middle 	of locating a position, etc.  \end{quote}n   o! \subsection{Arrows passing under}s ??=[arrows.pass] %tE 	The `|x|-form' of the morphisms may pass under any other entry: Just E 	insert $|'|t$, \ie, a quote character followed by a target, for each-B 	entry that should be visited except the last, `ordinary \& final' 	entry:o %d \begin{code} \diagram  \circ   \xdashed '[dr] ^a |<\stop< 	   '[rr]+D ^b 	    [drrr] ^c |>\tip !        & \circ & \circ & \circ \\}  \circ & \circ & \circ & \circ \enddiagram 
 \end{code} \displaycode %u	 \noindentl	 	typesetse $$ \docodee $$7 	As you see, labels are set separately on each segment.e   \begin{exercise} \begin{code} \diagram&  & \lambda\omega \rrline\xline'[d][dd]    & & \lambda C \ddline \\  \lambda2\urline \rrline\ddlines  & & \lambda P2 \urline\ddline \\)  & \lambda\underline\omega \xline'[r][rr]      & & \lambda P\underline\omega \\  \lambda{\to} \rrline\urline  & & \lambda P \urline \enddiagramc
 \end{code} %s 	Typeset the `lambda cube' $$ \docodet $$@ 	"Hint": `going under' an empty entry leaves a small gap at that
 	location. %d \answercode * \answertext{The author typed \displaycode} \end{exercise}   d  \subsection{More bending arrows} ??=[arrows.bend] %dE 	Finally, the |x|-form of arrows may bend around entries: just insertyA 	$|`|d\,t$, \ie, a backquote, direction $d$, target $t$, for each B 	`turn' that starts out in the $d$-direction and ends in a quarter 	turn towards the target~$t$.   / 	The possible directions are named like "hop"s:d $$ \xy *[o]\cir<1pc>{}="c",8   "c"; (-1,-1)**{},p+/4pc/ *+{|dl|} **\dir{-}?>*\dir{>},8   "c"; ( 0,-1)**{},p+/4pc/ *+{|d|}  **\dir{-}?>*\dir{>},8   "c"; ( 1,-1)**{},p+/4pc/ *+{|dr|} **\dir{-}?>*\dir{>},8   "c"; ( 1, 0)**{},p+/4pc/ *+{|r|}  **\dir{-}?>*\dir{>},8   "c"; ( 1, 1)**{},p+/4pc/ *+{|ur|} **\dir{-}?>*\dir{>},8   "c"; ( 0, 1)**{},p+/4pc/ *+{|u|}  **\dir{-}?>*\dir{>},8   "c"; (-1, 1)**{},p+/4pc/ *+{|ul|} **\dir{-}?>*\dir{>},8   "c"; (-1, 0)**{},p+/4pc/ *+{|l|}  **\dir{-}?>*\dir{>}, \endxy $$F 	and the possible targets include all those discussed above and in the& 	reference manual~\cite{R94:XY-picRM}.  B 	Actually the direction letter is only required for the first in aE 	series of turns since the final direction of one turn is the defaultwD 	for the following turn.  The quarter turns will have radius 10pt by= 	default, but this can be changed to any dimension $R$ from acF 	particular turn and onwards by inserting $|/|R$ immediately after theF 	|'| of the turn.  Here is an example involving all of these features: %h \begin{code} \diagram  \circ \xto `r[d] ^a
 	    `[rr] ^bi 	    `/4pt[rr] ^c 
 	    `[rrr]^dr 	    `[drrr]^e 	     [drrr]^f!        & \circ & \circ & \circ \\_  \circ & \circ & \circ & \circ \enddiagram 
 \end{code} \displaycode %u	 	typesetse $$ \docode  $$. 	The example illustrates the following points: %l \begin{itemize}% \itemaG 	If the segment can not be made as short as required then it will point ? 	`past' the target.  This is useful for `going around' entries.l   \item E 	Each target appears as many times as there are quarter turns towardsnD 	it, except the last target that appears both as the last |`|-target; 	and once as an `ordinary' target to set the final stretch.\   \item\3 	The sizes of the intermediate targets are ignored.x  
 \end{itemize}i %\D 	The bending arrows in section~??[basics.bends] are special cases of9 	the above construction.  There are several more advancedt< 	possibilities described in~\cite{R94:XY-picRM}, notably the# 	possibility for non-quarter turns.c %d \begin{quote}\it= 	The "v3" reference manual explains how the in- and out-goinga9 	direction and orientation of each turn can be specified.| \end{quote}^   e% \subsection{Defining new arrow types}^ ??=[arrows.defining] %a? 	All of the above arrows are really defined using the primitive?$ 	|\morphism| that is used like this: %-
 \begin{defs1} +  |\morphism| <line type> <tip> <tip> <path>| \end{defs1}  \noindent\unskip %d 	where %| \begin{itemize}  \iteme< 	<line type> is one of the following (shown above a sample): $$ \spreaddiagramcolumns{-1pc}l \spreaddiagramrows{-1pc} \diagram;  \relax|\solid|\go+DL\morphism\solid\notip\notip+<3pc,-2pc>g<  &\relax|\Solid|\go+DL\morphism\Solid\notip\notip+<3pc,-2pc>>  &\relax|\Ssolid|\go+DL\morphism\Ssolid\notip\notip+<3pc,-2pc>  & \\ \\=  \relax|\dashed|\go+DL\morphism\dashed\notip\notip+<3pc,-2pc>s>  &\relax|\Dashed|\go+DL\morphism\Dashed\notip\notip+<3pc,-2pc>@  &\relax|\Ddashed|\go+DL\morphism\Ddashed\notip\notip+<3pc,-2pc> \\ \\=  \relax|\dotted|\go+DL\morphism\dotted\notip\notip+<3pc,-2pc> >  &\relax|\Dotted|\go+DL\morphism\Dotted\notip\notip+<3pc,-2pc>@  &\relax|\Ddotted|\go+DL\morphism\Ddotted\notip\notip+<3pc,-2pc>  \null\\ \enddiagrami $$< 	or the special $|{\dottedwith{|x|}}|$ (where $x$ may be any$ 	math formula) to typeset lines like $$? \xy \morphism{\dottedwith{x}}\notip\notip +<3pc,-2pc>*{} \endxy  $$   \itemi@ 	The first <tip> specifies what to do with the target end of the? 	connection, the second with the base end.  Each must be eithere< 	|\notip| if no tip is desired, one of the tips described inB 	section~??[arrows.tips], or several such tips grouped together in@ 	|{|\dots|}| (\eg, use |{\tip\stop}| to get the tip of $\diagramD 	\morphism\solid{\tip\stop}\notip[0,1] & \enddiagram$).  Remember to4 	use the special |\Tip| with |\Solid| and |\Dashed|.
 \end{itemize}  % 1 	As an example, the |\ddrto| command described in = 	section~??[basics.arrows] is really just an abbreviation forr. 	|\morphism| |\solid| |\tip| |\notip| |[ddr]|.  E 	You can also define new `straight arrow types' that are available inl3 	all the standard directions shown in the figure in?D 	section~??[basics.arrows] as well as the `|x|-form'.  The following) 	uses this for a new arrow type |mapsto|:n %  \begin{code}& \definemorphism{mapsto}\solid\tip\stop \diagram(  A \rmapsto^f & A\times A \dlmapsto_g \\  B \umapstoi \enddiagramg
 \end{code} \displaycode \noindent\unskip %a	 	typesetsp $$ \docodee $$D 	You should only use |\definemorphism| if you need it, though, since2 	it defines many control sequences.  The referenceF 	manual~\cite{R94:XY-picRM} describes how to define your own groups of= 	bent arrows and how to make double and triple tips.  It alsow: 	describes a much more general way of defining new arrows. %} \begin{quote}\itC 	The "v3" arrow and directional commands make this obsolete in that.= 	most arrows can be specified directly in a very compact way.e \end{quote}j       \section{More Entries} ??=[entries] %{B 	This section explains what can go in an entry and how the general* 	form of the entries??w[entry] is changed.   \ \subsection{Text}a ??=[entries.text]   > 	The simplest form of text in diagrams is set with the |\text|	 	command:r %r \begin{code} \diagram"  \text{Program} \rto & \text{Code} \enddiagramr
 \end{code} \displaycode %r \noindent will typeset $$ \docoded $$  B 	If your text contains several centered lines, you can use |\Text|	 	instead:| %  \begin{code} \diagram'  \Text{A very long and stupid\\program}h  \rrto^-{\Text{weird\\arrow}}s'    && \Text<2pc>{Com\-pli\-cated\\Code}e \enddiagrame
 \end{code} \displaycode %d \noindent will typeset $$ \NoCompileAllDiagrams\docode $$F 	which illustrates that |\text| and |\Text| can also be used to formatF 	labels; in particular notice how the |-| place specifier is useful inF 	this context.  Lines will be broken where you have specified |\\| and? 	if they are longer than any \TeX\ dimension specified in |<>|sc' 	between |\Text| and the text in |{}|s.r %  \begin{quote}\itC  	In "v3" many variations are allowed, provided the DVI-driver can  : 	support them. This includes rotation and scaling of text. \end{quote}h   e- \subsection{Extra entries outside the matrix}  ??=[entries.extra] % B 	It is possible to put extra entries in your diagrams that are notD 	part of any `entry' of the matrix created by |&| and |\\|.  This is" 	done with the `excursion command' %\
 \begin{defs1}d9  |\save| $t$ |\Drop| |{|"stuff"|}| \dots |\restore| \dotse \end{defs1}n \noindent\unskip %\@ 	where $t$ should be a target in one of the formats described in@ 	section~??[arrows.targets] and "stuff" may be anything that can 	appear in an ordinary entry.e  C 	This will create a `pseudo entry' at $t$ containing |{|"stuff"|}|: E 	any \XY-pic commands following before |\restore| will be relative toaA 	the pseudo entry rather than to the entry hosting the excursion.i@ 	Here is an example, using an entry relative position as target: %\ \begin{code} \diagram
  A \drline  & \save +<3cm,0cm>n     \Drop{\Text<8pc>{%"      This is a very big commentary%      but it does not otherwise affect       the diagram.}}]     \lto \dto \restore \\  & B \rline & C \rline & D \enddiagramp
 \end{code} \displaycode %x \noindent will typeset $$ \NoCompileAllDiagrams\docode $$E 	It illustrates how a `down' arrow does not necessarily have to point+E 	particularly straight down---in this case because it is based in theuF 	displaced pseudo entry.  There is a variant of |\Drop| called |\drop|C 	that will set the argument formula without any surrounding margin.  %S \begin{quote}\itB 	The "v3" position language makes excursions much simpler and more	 	general.o \end{quote}r   r! \subsection{Resizing and spacing}\ ??=[entries.resizing]< %,A 	Entries can have their size and spacing changed in the following- 	ways: %t \begin{itemize}x \itema@ 	|\grow{|"formula"|}| is the same as "formula" except that it is: 	made the current "objectmargin" larger in all directions.   \item+@ 	|\grow<|$D$|>{|"formula"|}|, where $D$ is a \TeX\ dimension, is4 	similar except that $D$ is used for the enlargement( 	instead---negative $D$ means shrink it.   \itemeA 	|\squarify{|"formula"|}| will make "formula" square by extendingtA 	the smaller of its vertical/horizontal size equal to the larger.2   \itemaD 	|\squarify<|$D$|>{|"formula"|}|, where $D$ is a \TeX\ dimension, is4 	similar except the square will be $D$ on each side.  
 \end{itemize}  %;C 	You can change the "??!w[objectmargin]" from the default jot using` 	the command %p
 \begin{defs1}n  |\objectmargin| |{|<dimen>|}| \end{defs1}s  ? 	The usual spacing between the rows and columns can be adjusteds 	relative to the default 2pc by  %g
 \begin{defs1}r&  |\spreaddiagramrows| |{|<dimen>|}|\cr)  |\spreaddiagramcolumns| |{|<dimen>|}|\crr \end{defs1}| \noindent\unskip %}E 	that will increase the row/column separation by the specified amountm0 	(similar to |\spreadmatrixlines| of \AMS-\TeX).  A 	Finally, the ??!w[minimal width] and ??!w[minimal height] of allo 	objects can be set by %>
 \begin{defs1}i! 	|\objectwidth| |{|<dimen>|}| \crd" 	|\objectheight| |{|<dimen>|}| \cr \end{defs1}i %a \begin{quote}\itC 	With the "v3" matrix feature an individual entry can be readjusted\F 	and resized without affecting the overall structure.  Also the entire 	matrix can be rotated.i \end{quote}r   \ \subsection{Style} ??=[entries.style] %rE 	As mentioned above, the entries of a diagram are set in math mode inx; 	text style.  You may change this by redefinining the macrogE 	|\objectstyle|, and the label style by redefining |\labelstyle|.  WeiE 	can combine this with the above to get `small diagrams', \eg, typing  %e \begin{code} $\left(i  \spreaddiagramrows{-1.2pc}o  \spreaddiagramcolumns{-1.2pc}  \def\objectstyle{\scriptstyle}r  \def\labelstyle{\scriptstyle}	  \diagramb   A \rto^{a}  & B \dto^{b} \\n   A'\uto^{a'} & B'\lto_{b'}o  \enddiagram \right)$
 \end{code} \displaycode %e2 \noindent in a paragraph will typeset ``\docode''.  @ 	You can even abandon the use of math mode entirely: the commandF 	|\def| |\objectstyle| |{\hbox}|\ will change the format of entries to 	plain text. %b \begin{quote}\it? 	With the "v3" matrix command the style and shape of individualb 	entries can be changed. \end{quote}d   m! \subsection{Framing and circling}  ??=[entries.framing] %e@ 	You can put a box around an entry in a diagram by inserting the@ 	|\framed| command anywhere in the entry; if you prepend a \TeX\F 	dimension in |<>|s then the box will have rounded corners with radiusD 	as the \TeX\ dimension.  There is also |\Framed| that does the same1 	but makes a double box.  Here are some examples:w $$3 \spreaddiagramrows{-1pc}\spreaddiagramcolumns{-1pc}r \diagram  \relax|\framed|\frameda  &\relax|\Framed|\Framed \\!  \relax|\framed<5pt>|\framed<5pt>i@   &\relax~\Text{|\Framed<100pt>|\\(with maximum)}~\Framed<100pt> \enddiagramr $$E 	As you can see, the radius is scaled down to be useable; furthermore<F 	none of these commands are guaranteed to produce curves with a radius 	of more than 40pt.  %p \begin{quote}\it( 	In "v3" many more frames are available. \end{quote}t  E 	In case you want `perfect' circles there are |\circle| and |\Circle|eC 	commands that will just use half the width of the current entry ascF 	their outer radius unless an explicit radius is given in |<>|s.  They& 	should be used with |\squarify|; \eg, %t \begin{code} \spreaddiagramrows{-1pc} \diagram    \rto^>(.5){\text{start}}u,  & \squarify<1em>{0} \circled \toru^b \rto_a,  & \squarify<1em>{1} \circled \rto^b \tord_a$  & \squarify<1em>{2} \circled \rto^b     \xto `r+D `[l]  _a `[l]   [l]  & \squarify<1em>{3} \Circled|"    \xto `r+U `[lll]^b `[lll] [lll]!    \xto `r+D `[ll] _a `[ll]  [ll]  \enddiagram 
 \end{code} \displaycode %. \noindent will typeset $$ \NoCompileAllDiagrams\docode $$6 	Many more frames types are described in the reference 	manual~\cite{R94:XY-picRM}. %i \begin{quote}\it$ 	In "v3" objects can be truly round. \end{quote}t   e, \subsection{Naming for later use as targets} ??=[entries.naming]f %eE 	If you build an entry with a long and complicated excursion then youh@ 	might wish to be able to refer to it later.  \XY-pic provides a# 	mechanism for this: if you specifya %a
 \begin{defs1}i*  |\save| \dots |\go="|"name"|"| |\restore| \end{defs1}  \noindent\unskip %uF 	then the last pseudo entry (target with the last object |\Drop|'ed on> 	it) build within the \dots\ excursion will be saved for later= 	referencing as |"|"name"|"|; however, it is only possible towD 	reference it `after' the naming, that is, from entries right of theE 	base entry in the current row and below it.  We need this if we want + 	to point to objects created in excursions:  %d \begin{code} \diagram
  A \drline'  & \save \go+<3cm,0cm>\Drop{\Text<8pc>{t+      This is still just a big commentary.}}s&    \lto \dto \go="comment" \restore \\!  & B \rline & C \xto"comment" & Di \enddiagram 
 \end{code} \displaycode %e \noindent typesets $$ \NoCompileAllDiagrams\docode $$ %g \begin{quote}\it& 	In "v3" naming of labels is possible. \end{quote}"   ? \subsection{Grouping objects}  ??=[entries.grouping]i % F 	Sometimes you wish to frame or otherwise treat a rectangle of objectsF 	as a single object.  This is possible with special excursions of this 	form: %y
 \begin{defs1} ,  |\save| $t$ |\merge| \dots |\restore| \dots \end{defs1}  \noindent\unskip % E 	will make the entire rectangle of entries with the host entry in onehA 	corner and the target entry~$t$ in the other corner the `currentnB 	entry' until the |\restore|.  Here is an example where we frame a, 	couple of objects and point from the frame: \begin{code} \diagram
  0,{-1} & 0,06!   \save\go[1,2]\merge\framed<5pt>*)    \xto[0,-1]\xto[1,-1]\xto[0,3]\xto[1,3],
   \restore 	      & 0,1 & 0,2 & 0,3 \\[+  1,{-1} & 1,0 & 1,1 & 1,2 & 1,3 \enddiagramy
 \end{code} \displaycode \noindent will typeset $$ \docodee $$B 	As you can see, the center of the |\merge|d object is the same as% 	the one of the target preceeding it.   > 	Here is a more advanced example where we create two |\merge|dC 	objects with center in their center, name them and then connect tod 	them: \begin{code}
 \def\g#1{%  \save*   \go[dr]\merge\go+C\merge\go="g#1"\framed
  \restore} %0 \diagram+ \g1 A\rto & B\dto  & \g2 A'\rto & B'\dto \\}(     C\uto & D\lto  &     C'\uto & D'\lto,   \save \go"g1" \xdotted"1,4"|>\tip \restore,   \save \go"2,1"\xdashed"g2" |>\tip \restore \enddiagrams
 \end{code} $$ \NoCompileAllDiagrams\docode $$ 	can be typeset by %o \displaycode %eE 	The centering trick is achieved by using |\merge| twice in~|\g|: thetE 	second just merges with a dummy object with center where we want the,E 	final merged object to be centered!  Then we can make arrows from/tob? 	the two frames by using the two new targets |"g1"| and |"g2"|.g %c \begin{quote}\it/ 	Merging is part of the "v3" position language.b \end{quote}    \  . \section{Availability and Further Information}
 ??=[avail]   \subsection{Getting \XY-pic}  = 	The latest version of \XY-pic can be retrieved from Internet E 	anonymous ftp host {\tt ftp.diku.dk} in {\tt /diku\slash users\slashcA 	kris\slash TeX} as well as from {\tt ftp.mpce.mq.edu.au} in {\tt]F 	/pub\slash maths\slash TeX} in files starting with |xy|.  It has alsoD 	been contributed to the CTAN archives where it is located (unpackedF 	only) in the directory {\tt macros\slash generic\slash diagrams\slash 	xypic}.   \paragraph*{License:}c %eE 	\XY-pic is free software in the sense that it is available under theo 	following license conditions: %s \begin{quotation}l $$ \xy 0  *+\txt{\XY-pic: Graphs and Diagrams with \TeX\\/ 	\copyright~1991--1994\quad Kristoffer H. Rose}e	  *\frm{-}r \endxy $$E 	The \XY-pic package is free software; you can redistribute it and/ors? 	modify it under the terms of the GNU General Public License aseC 	published by the Free Software Foundation; either version 2 of thed0 	License, or (at your option) any later version.  ? 	The \XY-pic package is distributed in the hope that it will be1F 	useful, but "without any warranty"; without even the implied warrantyE 	of "merchantability" or "fitness for a particular purpose".  See the*- 	GNU General Public License for more details.;  H 	You should have received a copy of the GNU General Public License alongH 	with this package; if not, write to the Free Software Foundation, Inc.,( 	675 Mass Ave, Cambridge, MA 02139, USA. \end{quotation}r %?A 	In practice this means that you are free to use \Xy-pic for your,D 	documents but if you send parts of the "source code" of \Xy-pic (orC 	modified versions of it) to someone then you are obliged to ensurehB 	that the full source text of \Xy-pic is available to that someone= 	(the full text of the license explains this in somewhat morer 	detail~\smiley~).  3 \subsection{The future and backwards compatibility}  % 9 	\XY-pic version~3 is currently under development throughaF 	collaboration between the author and Ross Moore.  Partial funding forB 	this project has been provided by a Macquarie University ResearchF 	Grant (MURG), by the Australian Research Council (ARC), and through aA 	research agreement with the Digital Equipment Corporation (DEC).i  C 	We invite all users of \XY-pic to participate in this venture withe> 	suggestions for adding features, eliminating misfeatures, andD 	anything else that might improve the usefulness of \XY-pic.  PleaseE 	contact the author for further information or if you want to be keptn! 	up to date with the development.e  F 	This does mean, however, that from time to time features may turn outA 	to be redundant because they can be implemented in a better way.eE 	This is currently the case for the following features of version~2.6t6 	and earlier versions; in each case a fix is proposed: %h \begin{itemize}r \itemeC 	Automatic `shortening' of arrow tails by ??c![|<<] break was a bugaA 	and has been `fixed' so it does not work any more.  "Fix": Put arD 	|||<\hole| break before it as described in section~??[arrows.tips]. \itemtD 	The version~2.6 ??c![*] position operator is not available.  "Fix":E 	Use the |:| and |::| operators (described in detail in the referencei 	manual~\cite{R94:XY-picRM}).  \itemsE 	Using $t_1|;|t_2|:(|x|,|y|)|$ as the target of an arrow command does 3 	not work.  "Fix": Enclose it in braces, \ie, writee 	$|{|t_1|;|t_2|:(|x|,|y|)}|$.t \item|D 	The older ??c![\pit], ??c![\apit], and ??c![\bpit] commands are not= 	defined.  "Fix": Use |\dir{>}| (or |\tip|) with variants and 
 	rotation. \itemgD 	The obsolete notation where an argument in braces to |\rto| and the@ 	others was automatically taken to be a `tail' is not supported./ 	"Fix": Use the supported |||<|\dots\ notation.s
 \end{itemize}p %pD 	Finally note that sometimes the spacing with version~\xyversion\ is@ 	slightly different from that of earlier versions which had some 	spacing bugs.  < 	Please report all other things that do not work the same in+ 	version~2.6 and~\xyversion\ to the author.i   c   \ANSWERS
 \BIBLIOGRAPHYg   \end{document}   % $Log: xyguide.man,v $ + % Revision 2.12  1994/10/25  11:34:25  krisd> % Interim release just before v3 [works with AMS-LaTeX 1.2]... %o+ % Revision 2.10  1994/06/15  12:55:07  krisL" % Second 3beta release: bug fixes. %>* % Revision 2.9  1994/06/09  14:59:19  kris % Release 3beta. %}* % Revision 2.8  1994/04/08  04:30:00  kris" % Second (bug fix) 3alpha release. %d* % Revision 2.7  1994/03/08  02:06:01  kris % Release 3alpha.  %e. % Revision 2.6.9.1  1994/03/07  04:22:46  kris+ % Last internal 3alpha and pre-2.7 release.e %s1 % Reformatted for LaTeX with companion xydoc.sty.s+ % Renamed from xypicman.doc to xyguide.man.i %?. % Revision 2.6.1.1  1992/07/01  07:08:24  kris % Send to EuroTeX '92... %u* % Revision 2.6  1992/06/24  01:23:34  kris % Reorganised...M % Documented new features: hooks, triple lines, positions, and LaTeXdiagrams.i %|* % Revision 2.5  1992/02/24  03:30:54  kris' % Documented changes in xypic.doc[2.5].r %d* % Revision 2.4  1992/01/22  02:15:10  kris8 % Cosmetic changes; removed \pit and introduced \rotate. %p* % Revision 2.3  1992/01/13  01:51:02  kris$ % Changed to use `pure' XPPT [1.20].M % Several cosmetic changes, e.g., corrected definition of \ddtor in footnote.r %]* % Revision 2.2  1992/01/09  04:05:40  kris: % Patched to fix problem with \text and support AMS-LaTeX. %d* % Revision 2.1  1992/01/02  14:54:07  kris % Release version. %i* % Revision 1.7  1991/12/17  04:53:23  kris1 % Version distributed as `final draft' on Usenet.aD % Added bent arrows properly; support for double tips; proper \Text; % fixed name clashes...s& % This version is for bug fixes only!! %T* % Revision 1.6  1991/12/06  08:53:06  kris' % Draft ready for wider distribution... 4 % Fits xypic.doc[1.39]; still needs better examples. %a* % Revision 1.5  1991/12/03  07:53:28  kris@ % Extended with the xypic.doc[1.37] possibility for exotic arrow) % tips; also added description of \merge.a % * % Revision 1.4  1991/12/02  06:08:42  kris- % Fixed various things; fits xypic.doc[1.36].i %M* % Revision 1.3  1991/12/01  07:40:07  kris! % Corresponds to xypic.doc[1.35].a %h* % Revision 1.2  1991/11/28  04:42:49  kris! % Corresponds to xypic.doc[1.34].eL % Cleaned up a lot; now only bending arrows are missing...and good examples. %e* % Revision 1.1  1991/11/27  06:48:17  kris % Initial: \beta-test on DIKU. %C2 % Based on version in DIKU student report 91-7-10.    C % Tell Emacs that this is a LaTeX document and how it is formatted:c % Local Variables: % mode:latex % fill-prefix:"\t" % fill-column:77N % paragraph-separate:"^[ \t\f]*$\\|^[^\t]\\|\\\\\\\\\\|\\$\\$\\|[^\n\\\\][%&]"K % paragraph-start:"^[ \t\f]*$\\|^[^\t]\\|\\\\\\\\\\|\\$\\$\\|[^\n\\\\][%&]"e % End: