 /*E  *   This program converts AFM files to TeX TFM files, and optionally G  *   to TeX VPL files that retain all kerning and ligature information. I  *   Both files make the characters not normally encoded by TeX available )  *   by character codes greater than 127.   */   C /*   (Modified by Don Knuth from Tom Rokicki's pre-VPL version.) */ @ /*   VM/CMS port by J. Hafner (hafner@almaden.ibm.com), based on>  *   the port by Alessio Guglielmi (guglielmi@ipisnsib.bitnet)7  *   and Marco Prevedelli (prevedelli@ipisnsva.bitnet). 6  *   This port is still in test state.  No guarantees.C  *   11/3/92: more corrections to VM/CMS port. Now it looks correct (  *   and will be supported by J. Hafner.  * */   #include <stdio.h> #if defined(OS2) #include <stdlib.h>  #endifm #if defined(SYSV) || defined(VMS) || defined(__THINK__) || defined(MSDOS) || defined(OS2) || defined(ATARIST)  #include <string.h>  #else  #include <strings.h> #endif #include <math.h>  #ifdef ATARIST #include <float.h> #endif  C /* JLH: added these to make the code easier to read and remove some !    ascii<->ebcdic dependencies */  #define ASCII_A 65 #define ASCII_Z 90 #define ASCII_a 97 #define ASCII_z 122  #define ASCII_0 48 #define ASCII_9 57   #ifdef VMCMSG #define interesting lookstr  /* for 8 character truncation conflicts */  #include "dvipscms.h"  extern FILE *cmsfopen() ;  extern char ebcdic2ascii[] ; extern char ascii2ebcdic[] ; #ifdef fopen #undef fopen #endif #define fopen cmsfopen #endif    #if defined MSDOS || defined OS2 #define WRITEBIN "wb"  #else  #ifdef VMCMS* #define WRITEBIN "wb, lrecl=1024, recfm=f" #else  #define WRITEBIN "w" #endif #endif  R #if (defined(MSDOS) && defined(__TURBOC__)) || (defined(OS2) && defined(_MSC_VER)) #define SMALLMALLOC  #endif   struct encoding {     char *name ;     char *vec[256] ;  } ; " struct encoding staticencoding = {
   "TeX text", <   {"Gamma", "Delta", "Theta", "Lambda", "Xi", "Pi", "Sigma",K    "Upsilon", "Phi", "Psi", "Omega", "arrowup", "arrowdown", "quotesingle", J    "exclamdown", "questiondown", "dotlessi", "dotlessj", "grave", "acute",K    "caron", "breve", "macron", "ring", "cedilla", "germandbls", "ae", "oe", O    "oslash", "AE", "OE", "Oslash", "space", "exclam", "quotedbl", "numbersign", M    "dollar", "percent", "ampersand", "quoteright", "parenleft", "parenright", K    "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", L    "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon",L    "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C",M    "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", F    "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash",O    "bracketright", "circumflex", "underscore", "quoteleft", "a", "b", "c", "d", M    "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", G    "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", K    "tilde", "dieresis", "", "", "", "", "", "", "", "", "", "", "", "", "", K     "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", K     "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", K     "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", K     "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", K     "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", K     "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", $     "", "", "", "", "", "", "" } } ; /*D  *   It's easier to put this in static storage and parse it as we go,  *   than to build the structures ourselves.  */  char *staticligkern[] = { 7    "% LIGKERN space l =: lslash ; space L =: Lslash ;", 4    "% LIGKERN question quoteleft =: questiondown ;",0    "% LIGKERN exclam quoteleft =: exclamdown ;",C    "% LIGKERN hyphen hyphen =: endash ; endash hyphen =: emdash ;", 5    "% LIGKERN quoteleft quoteleft =: quotedblleft ;", 8    "% LIGKERN quoteright quoteright =: quotedblright ;",A    "% LIGKERN space {} * ; * {} space ; zero {} * ; * {} zero ;", ;    "% LIGKERN one {} * ; * {} one ; two {} * ; * {} two ;", A    "% LIGKERN three {} * ; * {} three ; four {} * ; * {} four ;", =    "% LIGKERN five {} * ; * {} five ; six {} * ; * {} six ;", C    "% LIGKERN seven {} * ; * {} seven ; eight {} * ; * {} eight ;", '    "% LIGKERN nine {} * ; * {} nine ;",  /*>  *   These next are only included for deficient afm files that6  *   have the lig characters but not the lig commands.  */ A    "% LIGKERN f i =: fi ; f l =: fl ; f f =: ff ; ff i =: ffi ;",     "% LIGKERN ff l =: ffl ;",     0 } ; /*J  *   The above layout corresponds to TeX Typewriter Type and is compatibleC  *   with TeX Text because the position of ligatures is immaterial.   */ " struct encoding *outencoding = 0 ;! struct encoding *inencoding = 0 ; O char *outenname, *inenname ;/* the file names for input and output encodings */ 8 int boundarychar = -1 ;     /* the boundary character */M int ignoreligkern ;         /* do we look at ligkern info in the encoding? */  /*)  *   This is what we store Adobe data in.   */  struct adobeinfo {    struct adobeinfo *next ;      int adobenum, texnum, width ;    char *adobename ;    int llx, lly, urx, ury ;     struct lig *ligs ;     struct kern *kerns ;     struct pcc *pccs ;     int wptr, hptr, dptr, iptr ; . } *adobechars, *adobeptrs[256], *texptrs[256],$   *uppercase[256], *lowercase[256] ;H int nexttex[256] ; /* for characters encoded multiple times in output */ /*J  *   These are the eight ligature ops, in VPL terms and in METAFONT terms.  */  char *vplligops[] = { K    "LIG", "/LIG", "/LIG>", "LIG/", "LIG/>", "/LIG/", "/LIG/>", "/LIG/>>", 0  } ;  char *encligops[] = { C    "=:", "|=:", "|=:>", "=:|", "=:|>", "|=:|", "|=:|>", "|=:|>>", 0  } ;  struct lig {    struct lig *next ;     char *succ, *sub ;     short op, boundleft ; } ; 
 struct kern {     struct kern *next ;    char *succ ;     int delta ; } ;  struct pcc {    struct pcc *next ;     char * partname ;    int xoffset, yoffset ;  } ;    FILE *afmin, *vplout, *tfmout ; F char inname[200], outname[200] ; /* names of input and output files */= char buffer[255]; /* input buffer (modified while parsing) */ 9 char obuffer[255] ; /* unmodified copy of input buffer */ 4 char *param ; /* current position in input buffer */ char *fontname = "Unknown" ;$ char *codingscheme = "Unspecified" ; #ifdef VMCMS char *ebfontname ; char *ebcodingscheme ; #endif float italicangle = 0.0 ;  char fixedpitch ;  char makevpl ; char pedantic ;  int xheight = 400 ;  int fontspace ;  int bc, ec ; long cksum ;" float efactor = 1.0, slant = 0.0 ; float capheight = 0.8 ; ! char *efactorparam, *slantparam ;  double newslant ;  char titlebuf[500] ;   void error(s) register char *s ; {     extern void exit() ;   %    (void)fprintf(stderr, "%s\n", s) ;     if (obuffer[0]) {.       (void)fprintf(stderr, "%s\n", obuffer) ;       while (param > buffer) {%          (void)fprintf(stderr, " ") ;           param-- ;       } $       (void)fprintf(stderr, "^\n") ;    }    if (*s == '!')        exit(1) ;  }    int  transform(x,y)    register int x,y ;  {     register double acc ;!    acc = efactor * x + slant *y ; :    return (int)(acc>=0? floor(acc+0.5) : ceil(acc-0.5) ) ; }    int  getline() {     register char *p ;     register int c ;       param = buffer ; O    for (p=buffer; (c=getc(afmin)) != EOF && c != '\n';)/* changed 10 to '\n' */        *p++ = c ;    *p = 0 ; "    (void)strcpy(obuffer, buffer) ;    if (p == buffer && c == EOF)        return(0) ;     else        return(1) ;  }   B char *interesting[] = { "FontName", "ItalicAngle", "IsFixedPitch",9    "XHeight", "C", "KPX", "CC", "EncodingScheme", NULL} ;  #define FontName (0) #define ItalicAngle (1)  #define IsFixedPitch (2) #define XHeight (3) 
 #define C (4)  #define KPX (5)  #define CC (6) #define EncodingScheme (7) #define NONE (-1)  int  interest(s) 	 char *s ;  {     register char **p ;    register int n ;   )    for (p=interesting, n=0; *p; p++, n++)        if (strcmp(s, *p)==0)           return(n) ;    return(NONE) ;  }    char *
 mymalloc(len)  unsigned long len ;  {     register char *p ; 
    int i ; #ifndef IBM6000   #if defined MSDOS || defined OS2    extern void *malloc() ; #else     extern char *malloc() ; #endif #endif   #ifdef SMALLMALLOC    if (len > 65500L)0       error("! can't allocate more than 64K!") ; #endif    p = malloc((unsigned)len) ;    if (p==NULL)         error("! out of memory") ;    for (i=0; i<len; i++)       p[i] = 0 ;    return(p) ; }    char * newstring(s)	 char *s ;  { 7    char *q = mymalloc((unsigned long)(strlen(s) + 1)) ;     (void)strcpy(q, s) ; 
    return q ;  }    char * paramnewstring() {    register char *p, *q ;       p = param ;    while (*p > ' ')        p++ ;     if (*p != 0)        *p++ = 0 ;    q = newstring(param) ;     while (*p && *p <= ' ')       p++ ;     param = p ;    return(q) ; }    char * paramstring() {     register char *p, *q ;       p = param ;    while (*p > ' ')        p++ ;     q = param ;    if (*p != 0)        *p++ = 0 ;    while (*p && *p <= ' ')       p++ ;     param = p ;    return(q) ; }    int  paramnum() {    register char *p ; 
    int i ;      p = paramstring() ;     if (sscanf(p, "%d", &i) != 1)#       error("! integer expected") ;     return(i) ; }    float  paramfloat() {    register char *p ;     float i ;      p = paramstring() ;     if (sscanf(p, "%f", &i) != 1)"       error("! number expected") ;    return(i) ; }    struct adobeinfo * newchar() { "    register struct adobeinfo *ai ;  O    ai = (struct adobeinfo *)mymalloc((unsigned long)sizeof(struct adobeinfo)) ;     ai->adobenum = -1 ;    ai->texnum = -1 ;    ai->width = -1 ;     ai->adobename = NULL ;     ai->llx = -1 ;     ai->lly = -1 ;     ai->urx = -1 ;     ai->ury = -1 ;     ai->ligs = NULL ;    ai->kerns = NULL ;     ai->pccs = NULL ;    ai->next = adobechars ;    adobechars = ai ;    return(ai) ;  }   
 struct kern *  newkern() {     register struct kern *nk ;   E    nk = (struct kern *)mymalloc((unsigned long)sizeof(struct kern)) ;     nk->next = NULL ;    nk->succ = NULL ;    nk->delta = 0 ;    return(nk) ;  }    struct pcc *
 newpcc() {    register struct pcc *np ;  C    np = (struct pcc *)mymalloc((unsigned long)sizeof(struct pcc)) ;     np->next = NULL ;    np->partname = NULL ;    np->xoffset = 0 ;    np->yoffset = 0 ;    return(np) ;  }    struct lig *
 newlig() {    register struct lig *nl ;  C    nl = (struct lig *)mymalloc((unsigned long)sizeof(struct lig)) ;     nl->next = NULL ;    nl->succ = NULL ;    nl->sub = NULL ; '    nl->op = 0 ; /* the default =: op */     nl->boundleft = 0 ;    return(nl) ;  }    void	 expect(s) 	 char *s ;  { '    if (strcmp(paramstring(), s) != 0) { 1       (void)fprintf(stderr, "%s expected: ", s) ;        error("! syntax error") ;     } }    void3 handlechar() { /* an input line beginning with C */ "    register struct adobeinfo *ai ;    register struct lig *nl ;      ai = newchar() ;     ai->adobenum = paramnum() ;    expect(";") ;    expect("WX") ; (    ai->width = transform(paramnum(),0) ;1    if (ai->adobenum >= 0 && ai->adobenum < 256) { $       adobeptrs[ai->adobenum] = ai ;    }    expect(";") ;    expect("N") ;%    ai->adobename = paramnewstring() ;     expect(";") ;    expect("B") ;    ai->llx = paramnum() ;     ai->lly = paramnum() ; *    ai->llx = transform(ai->llx, ai->lly) ;    ai->urx = paramnum() ;     ai->ury = paramnum() ; *    ai->urx = transform(ai->urx, ai->ury) ;E /* We need to avoid negative heights or depths. They break accents in %    math mode, among other things.  */     if (ai->lly > 0)        ai->lly = 0 ;     if (ai->ury < 0)        ai->ury = 0 ;     expect(";") ;G /* Now look for ligatures (which aren't present in fixedpitch fonts) */ )    while (*param == 'L' && !fixedpitch) {        expect("L") ;        nl = newlig() ; #       nl->succ = paramnewstring() ; "       nl->sub = paramnewstring() ;       nl->next = ai->ligs ;        ai->ligs = nl ;        expect(";") ;     } }    struct adobeinfo * findadobe(p)	 char *p ;  { "    register struct adobeinfo *ai ;  )    for (ai=adobechars; ai; ai = ai->next) &       if (strcmp(p, ai->adobename)==0)          return(ai) ;     return(NULL) ;  }      /*D  *   The following comment no longer applies; we rely on the LIGKERNE  *   entries to kill space kerns.  Also, the same applies to numbers.   *E  * We ignore kerns before and after space characters, because (1) TeX >  * is using the space only for Polish ligatures, and (2) TeX's@  * boundarychar mechanisms are not oriented to kerns (they apply@  * to both spaces and punctuation) so we don't want to use them.  */  void5 handlekern() { /* an input line beginning with KPX */ "    register struct adobeinfo *ai ;    register char *p ;     register struct kern *nk ;       p = paramstring() ;    ai = findadobe(p) ;    if (ai == NULL)$       error("kern char not found") ;	    else {        nk = newkern() ;#       nk->succ = paramnewstring() ; +       nk->delta = transform(paramnum(),0) ;        nk->next = ai->kerns ;       ai->kerns = nk ;     }  }    void9 handleconstruct() { /* an input line beginning with CC */ "    register struct adobeinfo *ai ;    register char *p ;     register struct pcc *np ;    register int n ;     struct pcc *npp = NULL;      p = paramstring() ;    ai = findadobe(p) ;    if (ai == NULL)5       error("! composite character name not found") ;     n = paramnum() ;     expect(";") ;    while (n--) {4       if (strcmp(paramstring(),"PCC") != 0) return ;K         /* maybe I should expect("PCC") instead, but I'm playing it safe */        np = newpcc() ; '       np->partname = paramnewstring() ; 1       if (findadobe(np->partname)==NULL) return ;         np->xoffset = paramnum() ;        np->yoffset = paramnum() ;9       np->xoffset = transform(np->xoffset, np->yoffset) ;        if (npp) npp->next = np ;        else ai->pccs = np ;       npp = np ;       expect(";") ;     } }   ! struct encoding *readencoding() ;    void makeaccentligs() {(    register struct adobeinfo *ai, *aci ;    register char *p ;     register struct lig *nl ;)    for (ai=adobechars; ai; ai=ai->next) {        p = ai->adobename ;        if (strlen(p)>2)=          if ((aci=findadobe(p+1)) && (aci->adobenum > 127)) {              nl = newlig() ; 3             nl->succ = mymalloc((unsigned long)2) ; !             *(nl->succ + 1) = 0 ;              *(nl->succ) = *p ;%             nl->sub = ai->adobename ; "             nl->next = aci->ligs ;             aci->ligs = nl ;
          }    } }    void
 readadobe() {     struct adobeinfo *ai ;  #ifdef VMCMS
     int i; #endif   /*-  *   We allocate a placeholder boundary char.   */     ai = newchar() ;     ai->adobenum = -1 ;7    ai->adobename = "||" ; /* boundary character name */     while (getline()) {'       switch(interest(paramstring())) {  case FontName:&          fontname = paramnewstring() ; #ifdef VMCMSD /* fontname comes in as ebcdic but we need it asciified for tfm file;    so we save it in ebfontname and change it in fontname */ %    ebfontname = newstring(fontname) ;     i=0;     while(fontname[i] != '\0') { ,       fontname[i]=ebcdic2ascii[fontname[i]];
       i++;    };  #endif          break ; case EncodingScheme:*          codingscheme = paramnewstring() ; #ifdef VMCMS= /* for codingscheme, we do the same as we did for fontname */ -    ebcodingscheme = newstring(codingscheme) ;     i=0; #    while(codingscheme[i] != '\0') { 4       codingscheme[i]=ebcdic2ascii[codingscheme[i]];
       i++;    } #endif          break ; case ItalicAngle: %          italicangle = paramfloat() ;           break ; case IsFixedPitch:,          if (*param == 't' || *param == 'T')             fixedpitch = 1 ;
          else              fixedpitch = 0 ;          break ;
 case XHeight:           xheight = paramnum() ;           break ; case C:           handlechar() ;           break ;	 case KPX:           handlekern() ;           break ; case CC:          handleconstruct() ;          break ; default:          break ;       }h    }    fclose(afmin) ;    afmin = 0 ; }n /*A  *   Re-encode the adobe font.  Assumes that the header file willi/  *   also contain the appropriate instructions!   */  void handlereencoding() {    if (inenname) {
       int i ;i       struct adobeinfo *ai ;       char *p ;@         ignoreligkern = 1 ;*+       inencoding = readencoding(inenname) ;p       for (i=0; i<256; i++)o&          if (0 != (ai=adobeptrs[i])) {             ai->adobenum = -1 ;s!             adobeptrs[i] = NULL ;/
          }       for (i=0; i<256; i++) { !          p = inencoding->vec[i] ;p3          if (p && *p && 0 != (ai = findadobe(p))) {i             ai->adobenum = i ;             adobeptrs[i] = ai ;|
          }       }n'       codingscheme = inencoding->name ;d    }    ignoreligkern = 0 ;    if (outenname) {e-       outencoding = readencoding(outenname) ;a    } else {f-       outencoding = readencoding((char *)0) ;     } }s   /*G  *   This routine reverses a list.  We use it because we accumulate thei?  *   adobeinfo list in reverse order, but when we go to map the7G  *   characters, we would prefer to use the original ordering.  It justV  *   makes more sense.  */k struct adobeinfo *revlist(p) struct adobeinfo *p ;c {e     struct adobeinfo *q = 0, *t ;      while (p) {       t = p->next ;        p->next = q ;d
       q = p ;f
       p = t ;p    }    return (void *)q ;f }n   void assignchars() {S    register char **p ;    register int i, j ;(    register struct adobeinfo *ai, *pai ;    int nextfree = 128 ;     struct pcc *pcp ;   /*5  *   First, we assign all those that match perfectly.)  */(1    for (i=0, p=outencoding->vec; i<256; i++, p++)LJ       if ((ai=findadobe(*p)) && (ai->adobenum >= 0 || ai->pccs != NULL)) {          if (ai->texnum >= 0)o7             nexttex[i] = ai->texnum ; /* linked list */L          ai->texnum = i ;,          texptrs[i] = ai ;       },    if (pedantic)       return ; /*L  *   Next, we assign all the others, retaining the adobe positions, possibly#  *   multiply assigning characters.g  */e'    for (ai=adobechars; ai; ai=ai->next)sL       if (ai->adobenum >= 0 && ai->texnum < 0 && texptrs[ai->adobenum]==0) {$          ai->texnum = ai->adobenum ;%          texptrs[ai->adobenum] = ai ;        }i /*K  *   Finally, we map all remaining characters into free locations beginningrH  *   with 128, if we know how to construct those characters.  We need to/  *   make sure the component pieces are mapped."  */,%    adobechars = revlist(adobechars) ; '    for (ai=adobechars; ai; ai=ai->next)QB       if (ai->texnum<0 && (ai->adobenum>=0 || ai->pccs != NULL)) {$          while (texptrs[nextfree]) {'             nextfree=(nextfree+1)&255 ;"C             if (nextfree==128) goto finishup ; /* all slots full */"
          }           ai->texnum = nextfree ;!          texptrs[nextfree] = ai ;"       }i	 finishup:" /*A  *   We now check all of the composite characters.  If any of the A  *   components are not mapped, we unmap the composite character."  */     for (i=0; i<256; i++) {       ai = texptrs[i] ; 6       if (ai && ai->pccs != NULL && ai->texnum >= 0) {5          for (pcp = ai->pccs; pcp; pcp = pcp->next) { ,             pai = findadobe(pcp->partname) ;1             if (pai == NULL || pai->texnum < 0) { (                texptrs[ai->texnum] = 0 ;                 ai->texnum = -1 ;                break ;
             }"
          }       }"    } /*F  *   Now, if any of the characters are encoded multiple times, we wantG  *   ai->texnum to be the first one assigned, since that is most likely B  *   to be the most important one.  So we reverse the above lists.  */:'    for (ai=adobechars; ai; ai=ai->next)e       if (ai->texnum >= 0) {          j = -1 ;o+          while (nexttex[ai->texnum] >= 0) {n%             i = nexttex[ai->texnum] ;d%             nexttex[ai->texnum] = j ;l             j = ai->texnum ;             ai->texnum = i ;
          }"          nexttex[ai->texnum] = j ;       }p }    voidH upmap() { /* Compute uppercase mapping, when making a small caps font */'    register struct adobeinfo *ai, *Ai ;     register char *p, *q ;u!    register struct pcc *np, *nq ; 
    int i ;    char lwr[50] ;"  D /* JLH: changed some lines below to be ascii<->ebcdic independent */( /* any reason we don't use 'isupper'? */)    for (Ai=adobechars; Ai; Ai=Ai->next) {        p = Ai->adobename ;*
 #ifndef VMCMS '       if (*p>=ASCII_A && *p<=ASCII_Z) {  #else C       if (ebcdic2ascii[*p]>=ASCII_A && ebcdic2ascii[*p]<=ASCII_Z) {I #endif          q = lwr ;          for (; *p; p++)
 #ifndef VMCMSd@             *q++ = ((*p>=ASCII_A && *p<=ASCII_Z) ? *p+32 : *p) ; #elsee1             *q++ = ((ebcdic2ascii[*p]>=ASCII_A &&t5                         ebcdic2ascii[*p]<=ASCII_Z ) ?nE                             ascii2ebcdic[ebcdic2ascii[*p]+32] : *p) ;u #endif-          *q = '\0';   /* changed this too! */b  (          if (0 != (ai=findadobe(lwr))) {8             for (i = ai->texnum; i >= 0; i = nexttex[i])"                uppercase[i] = Ai ;8             for (i = Ai->texnum; i >= 0; i = nexttex[i])"                lowercase[i] = ai ;
          }       }e    }< /* Note that, contrary to the normal true/false conventions,B  * uppercase[i] is NULL and lowercase[i] is non-NULL when i is theM  * ASCII code of an uppercase letter; and vice versa for lowercase letters */o  )    if (0 != (ai=findadobe("germandbls")))r@       if (0 != (Ai=findadobe("S"))) { /* we also construct SS */3          for (i=ai->texnum; i >= 0; i = nexttex[i])m             uppercase[i] = ai ;           ai->adobenum = -1 ;%          ai->width = Ai->width << 1 ;>          ai->llx = Ai->llx ;          ai->lly = Ai->lly ;(          ai->urx = Ai->width + Ai->urx ;          ai->ury = Ai->ury ;           ai->kerns = Ai->kerns ;          np = newpcc() ;          np->partname = "S" ;           nq = newpcc() ;          nq->partname = "S" ; "          nq->xoffset = Ai->width ;          np->next = nq ;          ai->pccs = np ;       } "    if ((ai=findadobe("dotlessi")))0       for (i=ai->texnum; i >= 0; i = nexttex[i])(          uppercase[i] = findadobe("I") ;"    if ((ai=findadobe("dotlessj")))0       for (i=ai->texnum; i >= 0; i = nexttex[i])(          uppercase[i] = findadobe("J") ; }pN /* The logic above seems to work well enough, but it leaves useless charactersA  * like `fi' and `fl' in the font if they were present initially,eJ  * and it omits characters like `dotlessj' if they are absent initially */  + /* Now we turn to computing the TFM file */o  , int lf, lh, nw, nh, nd, ni, nl, nk, ne, np ;   void
 write16(what)0 register short what ;. { #    (void)fputc(what >> 8, tfmout) ; $    (void)fputc(what & 255, tfmout) ; }    void writearr(p, n) register long *p ; register int n ; {     while (n) {"       write16((short)(*p >> 16)) ;$       write16((short)(*p & 65535)) ;       p++ ;b       n-- ;     } }p   void makebcpl(p, s, n)( register long *p ; register char *s ; register int n ; {     register long t ;    register long sc ;i      if (strlen(s) < n)t       n = strlen(s) ;n    t = ((long)n) << 24 ;    sc = 16 ;    while (n > 0) {2       t |= ((long)(*(unsigned char *)s++)) << sc ;       sc -= 8 ;o       if (sc < 0) {-          *p++ = t ;           t = 0 ;          sc = 24 ;       }e       n-- ;     }
    *p++ = t ;  }f   int source[257] ;( int unsort[257] ;    /*G  *   Next we need a routine to reduce the number of distinct dimensionsrE  *   in a TFM file. Given an array what[0]...what[oldn-1], we want to0J  *   group its elements into newn clusters, in such a way that the maximumF  *   difference between elements of a cluster is as small as possible.G  *   Furthermore, what[0]=0, and this value must remain in a cluster byfI  *   itself. Data such as `0 4 6 7 9' with newn=3 shows that an iterative E  *   scheme in which 6 is first clustered with 7 will not work. So we D  *   borrow a neat algorithm from METAFONT to find the true optimum.F  *   Memory location what[oldn] is set to 0x7fffffffL for convenience.  */0E long nextd ; /* smallest value that will give a different mincover */n intnM mincover(what,d) /* tells how many clusters result, given max difference d */i register long d ;d long *what ; {t    register int m ;     register long l ;    register long *p ;e      nextd = 0x7fffffffL ;    p = what+1 ;0
    m = 1 ;    while (*p<0x7fffffffL) {a       m++ ;e       l = *p ;       while (*++p <= l+d) ;p&       if (*p-l < nextd) nextd = *p-l ;    }    return (m) ;  })   void remap(what, oldn, newn); long *what ; int oldn, newn ; {*    register int i, j ;    register long d, l ;t      what[oldn] = 0x7fffffffL ;(    for (i=oldn-1; i>0; i--) {        d = what[i] ;g#       for (j=i; what[j+1]<d; j++) {           what[j] = what[j+1] ;"          source[j] = source[j+1] ;       }+       what[j] = d ;i       source[j] = i ;(J    } /* Tom, don't let me ever catch you using bubblesort again! -- Don */      i = mincover(what, 0L) ;     d = nextd ;+    while (mincover(what,d+d)>newn) d += d ; ,    while (mincover(what,d)>newn) d = nextd ;  
    i = 1 ;
    j = 0 ;    while (i<oldn) {        j++ ;r       l = what[i] ;)       unsort[source[i]] = j ;         while (what[++i] <= l+d) {           unsort[source[i]] = j ;&          if (i-j == oldn-newn) d = 0 ;       }e!       what[j] = (l+what[i-1])/2 ;     } }a   long checksum() {s
    int i ;    long s1 = 0, s2 = 0 ;    char *p ;    struct adobeinfo *ai ;&      for (i=0; i<256; i++)#       if (0 != (ai=adobeptrs[i])) { %          s1 = (s1 << 1) ^ ai->width ;r'          for (p=ai->adobename; *p; p++) 
 #ifndef VMCMSf              s2 = (s2 * 3) + *p ; #else .             s2 = (s2 * 3) + ebcdic2ascii[*p] ; #endif       }a    s1 = (s1 << 1) ^ s2 ;    return s1 ; }    /*.  *   The next routine simply scales something.F  *   Input is in 1000ths of an em.  Output is in FIXFACTORths of 1000.  */-; #define FIXFACTOR (0x100000L) /* 2^{20}, the unit fixnum */i long scale(what)  long what ;t {r!    return(((what / 1000) << 20) +u1           (((what % 1000) << 20) + 500) / 1000) ;u }g  K long *header, *charinfo, *width, *height, *depth, *ligkern, *kern, *tparam,       *italic ; long *tfmdata ;    void buildtfm() {    register int i, j ;"    register struct adobeinfo *ai ;      header = tfmdata ;l    cksum = checksum() ;     header[0] = cksum ;0    header[1] = 0xa00000 ; /* 10pt design size */)    makebcpl(header+2, codingscheme, 39) ; &    makebcpl(header+12, fontname, 19) ;    lh = 17 ;    charinfo = header + lh ;a  0    for (i=0; i<256 && adobeptrs[i]==NULL; i++) ;    bc = i ; 1    for (i=255; i>=0 && adobeptrs[i]==NULL; i--) ;o
    ec = i;    if (ec < bc)*&       error("! no Adobe characters") ;  %    width = charinfo + (ec - bc + 1) ;     width[0] = 0 ;a	    nw++ ;,    for (i=bc; i<=ec; i++)p#       if (0 != (ai=adobeptrs[i])) {           width[nw]=ai->width ;.          for (j=1; width[j]!=ai->width; j++) ;          ai->wptr = j ;           if (j==nw)o             nw++ ;       }u    if (nw>256)2       error("! 256 chars with different widths") ;    depth = width + nw ;p    depth[0] = 0 ;-    nd = 1 ;s    for (i=bc; i<=ec; i++) #       if (0 != (ai=adobeptrs[i])) {2          depth[nd] = -ai->lly ;n-          for (j=0; depth[j]!=-ai->lly; j++) ;N          ai->dptr = j ;p          if (j==nd)              nd++ ;       })    if (nd > 16) {r       remap(depth, nd, 16) ;       nd = 16 ;l       for (i=bc; i<=ec; i++)$          if (0 != (ai=adobeptrs[i])))             ai->dptr = unsort[ai->dptr] ;o    }    height = depth + nd ;    height[0] = 0 ;    nh = 1 ;e    for (i=bc; i<=ec; i++) #       if (0 != (ai=adobeptrs[i])) {*          height[nh]=ai->ury ; -          for (j=0; height[j]!=ai->ury; j++) ;>          ai->hptr = j ;)          if (j==nh)i             nh++ ;       }     if (nh > 16) {)       remap(height, nh, 16) ;&       nh = 16 ;        for (i=bc; i<=ec; i++)$          if (0 != (ai=adobeptrs[i])))             ai->hptr = unsort[ai->hptr] ;i    }    italic  = height + nh ;    italic[0] = 0 ;    ni = 1 ;     for (i=bc; i<=ec; i++) #       if (0 != (ai=adobeptrs[i])) {r+          italic[ni] = ai->urx - ai->width ;;          if (italic[ni]<0)             italic[ni] = 0 ;0          for (j=0; italic[j]!=italic[ni]; j++) ;          ai->iptr = j ;           if (j==ni)l             ni++ ;       }i    if (ni > 64) {L       remap(italic, ni, 64) ;a       ni = 64 ;t       for (i=bc; i<=ec; i++)$          if (0 != (ai=adobeptrs[i])))             ai->iptr = unsort[ai->iptr] ;     }      for (i=bc; i<=ec; i++)a!       if (0 != (ai=adobeptrs[i]))a2          charinfo[i-bc] = ((long)(ai->wptr)<<24) +3                            ((long)(ai->hptr)<<20) +o4                             ((long)(ai->dptr)<<16) +5                              ((long)(ai->iptr)<<10) ;*      ligkern = italic + ni ;A    nl = 0 ; /* ligatures and kerns omitted from raw Adobe font */i    kern = ligkern + nl ;    nk = 0 ;   O    newslant = (double)slant - efactor * tan(italicangle*(3.1415926535/180.0)) ;=    tparam = kern + nk ; 3    tparam[0] = (long)(FIXFACTOR * newslant + 0.5) ;e'    tparam[1] = scale((long)fontspace) ; B    tparam[2] = (fixedpitch ? 0 : scale((long)(300*efactor+0.5))) ;B    tparam[3] = (fixedpitch ? 0 : scale((long)(100*efactor+0.5))) ;%    tparam[4] = scale((long)xheight) ;g0    tparam[5] = scale((long)(1000*efactor+0.5)) ;    np = 6 ;g };   void writesarr(what, len) long *what ;	 int len ;o {!    register long *p ;m
    int i ;  
    p = what ;m    i = len ;    while (i) {       *p = scale(*p) ;A       (void)scale(*p) ; /* need this kludge for some compilers */o       p++ ;C       i-- ;b    }    writearr(what, len) ; }p   void writetfm() {H    lf = 6 + lh + (ec - bc + 1) + nw + nh + nd + ni + nl + nk + ne + np ;    write16(lf) ;    write16(lh) ;    write16(bc) ;    write16(ec) ;    write16(nw) ;    write16(nh) ;    write16(nd) ;    write16(ni) ;    write16(nl) ;    write16(nk) ;    write16(ne) ;    write16(np) ;    writearr(header, lh) ;      writearr(charinfo, ec-bc+1) ;    writesarr(width, nw) ;c    writesarr(height, nh) ;    writesarr(depth, nd) ;     writesarr(italic, ni) ;    writearr(ligkern, nl) ;    writesarr(kern, nk) ;    writearr(tparam, np) ;i }d  E /* OK, the TFM file is done! Now for our next trick, the VPL file. */(  D /* For TeX we want to compute a character height that works properlyN  * with accents. The following list of accents doesn't need to be complete. */ /*;  *   We only do this if the xheight has a reasonable value. 
  *   (>50)  */eB char *accents[] = { "acute", "tilde", "caron", "dieresis", NULL} ; into
 texheight(ai)  register struct adobeinfo *ai ;i {f    register char **p;d*    register struct adobeinfo *aci, *acci ;@    if (xheight <= 50 || *(ai->adobename + 1)) return (ai->ury) ;I                                            /* that was the simple case */(I    for (p=accents; *p; p++)  /* otherwise we look for accented letters */n%       if (0 != (aci=findadobe(*p))) {S'          strcpy(buffer,ai->adobename) ;e          strcat(buffer,*p) ;+          if (0 != (acci=findadobe(buffer)))i5             return (acci->ury - aci->ury + xheight) ;        }     return (ai->ury) ;  }'  0 /* modified tgr to eliminate varargs problems */  # #define vout(s)  fprintf(vplout, s)eL int level ; /* the depth of parenthesis nesting in VPL file being written */ void vlevout() {    register int l = level ;w    while (l--) vout("   ") ; }n void vlevnlout() {    vout("\n") ;     vlevout() ; }c; #define voutln(str) {fprintf(vplout,"%s\n",str);vlevout();}i7 #define voutln2(f,s) {fprintf(vplout,f,s);vlevnlout();}e; #define voutln3(f,a,b) {fprintf(vplout,f,a,b);vlevnlout();} ? #define voutln4(f,a,b,c) {fprintf(vplout,f,a,b,c);vlevnlout();}' void vleft()  {)    level++ ;    vout("(") ; }    void vright() {     level-- ;    voutln(")") ; }k   int forceoctal = 0 ;   char vcharbuf[6] ; char *vchar(c) int c ;  {e    if (forceoctal == 0 && 3 /* changed below to ascii<->ebcdic independence: */(( /* any reason we don't use 'isalnum'? */F          ( (c>=ASCII_0 && c<=ASCII_9) || (c>=ASCII_A && c<=ASCII_Z) ||4                       (c>=ASCII_a && c<=ASCII_z) ) )%       (void) sprintf(vcharbuf,"C %c",e
 #ifndef VMCMSe
       c) ; #elsea       ascii2ebcdic[c]) ; #endif6    else (void) sprintf(vcharbuf,"O %o", (unsigned)c) ;    return (vcharbuf) ; }    void
 writevpl() {;    register int i, j, k ; "    register struct adobeinfo *ai ;    register struct lig *nlig ;     register struct kern *nkern ;    register struct pcc *npcc ;)    struct adobeinfo *asucc, *asub, *api ;     int xoff, yoff, ht ;     char unlabeled ;   0    voutln2("(VTITLE Created by %s)", titlebuf) ;F    voutln("(COMMENT Please edit that VTITLE if you edit this file)") ;2    (void)sprintf(obuffer, "TeX-%s%s%s%s", outname,9       (efactor==1.0? "" : "-E"), (slant==0.0? "" : "-S"),--                  (makevpl==1? "" : "-CSC")) ;oL    if (strlen(obuffer)>19) { /* too long, will retain first 9 and last 10 */       register char *p, *q ;N       for (p = &obuffer[9], q = &obuffer[strlen(obuffer)-10] ; p<&obuffer[19];!               p++, q++) *p = *q ;e       obuffer[19] = '\0' ;    }%    voutln2("(FAMILY %s)" , obuffer) ;w    {       char tbuf[300] ;  1       sprintf(tbuf, "%s + %s", outencoding->name,k
 #ifndef VMCMSn          codingscheme) ; #else*          ebcodingscheme) ; #endif       if (strlen(tbuf) > 39) {H          error("Coding scheme too long; shortening to 39 characters.") ;          tbuf[39] = 0 ;        }d*       voutln2("(CODINGSCHEME %s)", tbuf) ;    }"    voutln("(DESIGNSIZE R 10.0)") ;#    voutln("(DESIGNUNITS R 1000)") ;e7    voutln("(COMMENT DESIGNSIZE (1 em) IS IN POINTS)") ;sJ    voutln("(COMMENT OTHER DIMENSIONS ARE MULTIPLES OF DESIGNSIZE/1000)") ;3    voutln2("(CHECKSUM O %lo)",cksum ^ 0xffffffff) ;a    if (boundarychar >= 0)sD       voutln2("(BOUNDARYCHAR O %lo)", (unsigned long)boundarychar) ;"    vleft() ; voutln("FONTDIMEN") ;    if (newslant))       voutln2("(SLANT R %f)", newslant) ;,'    voutln2("(SPACE D %d)", fontspace) ;*    if (! fixedpitch) {3       voutln2("(STRETCH D %d)", transform(200,0)) ;*2       voutln2("(SHRINK D %d)", transform(100,0)) ;    }'    voutln2("(XHEIGHT D %d)", xheight) ;d.    voutln2("(QUAD D %d)", transform(1000,0)) ;M    voutln2("(EXTRASPACE D %d)", fixedpitch ? fontspace : transform(111, 0)) ;u
    vright() ; #    vleft() ; voutln("MAPFONT D 0");m&    voutln2("(FONTNAME %s)", outname) ;:    voutln2("(FONTCHECKSUM O %lo)", (unsigned long)cksum) ;
    vright() ;n    if (makevpl>1) {e&       vleft() ; voutln("MAPFONT D 1");)       voutln2("(FONTNAME %s)", outname) ; =       voutln2("(FONTAT D %d)", (int)(1000.0*capheight+0.5)) ;&=       voutln2("(FONTCHECKSUM O %lo)", (unsigned long)cksum) ;p       vright() ;    }  .    for (i=0; i<256 && texptrs[i]==NULL; i++) ;    bc = i ;2/    for (i=255; i>=0 && texptrs[i]==NULL; i--) ; 
    ec = i;  !    vleft() ; voutln("LIGTABLE") ;x    ai = findadobe("||") ;     unlabeled = 1 ;-    for (nlig=ai->ligs; nlig; nlig=nlig->next)t/       if (0 != (asucc=findadobe(nlig->succ))) {p.          if (0 != (asub=findadobe(nlig->sub)))!             if (asucc->texnum>=0)=%                if (asub->texnum>=0) {s"                   if (unlabeled) {5                      voutln("(LABEL BOUNDARYCHAR)") ; $                      unlabeled = 0 ;                   }aC                   for (j = asucc->texnum; j >= 0; j = nexttex[j]) {=A                      voutln4("(%s %s O %o)", vplligops[nlig->op], <                          vchar(j), (unsigned)asub->texnum) ;                   }e                }        }&    if (! unlabeled) voutln("(STOP)") ;    for (i=bc; i<=ec; i++)t/       if ((ai=texptrs[i]) && ai->texnum == i) {w          unlabeled = 1 ;M          if (uppercase[i]==NULL) /* omit ligatures from smallcap lowercase */ 6             for (nlig=ai->ligs; nlig; nlig=nlig->next)6                if (0 != (asucc=findadobe(nlig->succ)))7                   if (0 != (asub=findadobe(nlig->sub)))n*                      if (asucc->texnum>=0).                         if (asub->texnum>=0) {+                            if (unlabeled) {mJ                               for (j = ai->texnum; j >= 0; j = nexttex[j])B                                  voutln2("(LABEL %s)", vchar(j)) ;-                               unlabeled = 0 ;h                            }L                            for (j = asucc->texnum; j >= 0; j = nexttex[j]) {J                               voutln4("(%s %s O %o)", vplligops[nlig->op],F                                    vchar(j), (unsigned)asub->texnum) ;2                               if (nlig->boundleft)(                                  break ;                            }                         }CG          for (nkern = (uppercase[i] ? uppercase[i]->kerns : ai->kerns);2-                     nkern; nkern=nkern->next) 4             if (0 != (asucc=findadobe(nkern->succ)))@                for (j = asucc->texnum; j >= 0; j = nexttex[j]) {+                   if (uppercase[j]==NULL) { %                      if (unlabeled) { D                         for (k = ai->texnum; k >= 0; k = nexttex[k])<                            voutln2("(LABEL %s)", vchar(k)) ;'                         unlabeled = 0 ;e                      }(                      if (uppercase[i]) {+                         if (lowercase[j]) {aO                            for (k=lowercase[j]->texnum; k >= 0; k = nexttex[k])eB                               voutln3("(KRN %s R %.1f)", vchar(k),=                                     capheight*nkern->delta) ;"9                         } else voutln3("(KRN %s R %.1f)",nD                                  vchar(j), capheight*nkern->delta) ;                      } else { :                         voutln3("(KRN %s R %d)", vchar(j),/                                 nkern->delta) ;=)                         if (lowercase[j])AO                            for (k=lowercase[j]->texnum; k >= 0; k = nexttex[k])-B                               voutln3("(KRN %s R %.1f)", vchar(k),9                                 capheight*nkern->delta) ;n                      }                   }                 },          if (! unlabeled) voutln("(STOP)") ;       }=
    vright() ;       for (i=bc; i<=ec; i++)b!       if (0 != (ai=texptrs[i])) {l>          vleft() ; fprintf(vplout, "CHARACTER %s", vchar(i)) ;          if (*vcharbuf=='C') {             voutln("") ;          } elsew5             voutln2(" (comment %s)", ai->adobename) ;f          if (uppercase[i]) {             ai=uppercase[i] ;aA             voutln2("(CHARWD R %.1f)", capheight * (ai->width)) ; (             if (0 != (ht=texheight(ai)));                voutln2("(CHARHT R %.1f)", capheight * ht) ;o             if (ai->lly)A                voutln2("(CHARDP R %.1f)", -capheight * ai->lly) ;d$             if (ai->urx > ai->width)N                voutln2("(CHARIC R %.1f)", capheight * (ai->urx - ai->width)) ;          } else {(1             voutln2("(CHARWD R %d)", ai->width) ; (             if (0 != (ht=texheight(ai)))-                voutln2("(CHARHT R %d)", ht) ;i             if (ai->lly)3                voutln2("(CHARDP R %d)", -ai->lly) ; $             if (ai->urx > ai->width)>                voutln2("(CHARIC R %d)", ai->urx - ai->width) ;
          }1          if (ai->adobenum != i || uppercase[i]) { %             vleft() ; voutln("MAP") ; :             if (uppercase[i]) voutln("(SELECTFONT D 1)") ;/             if (ai->pccs && ai->adobenum < 0) { $                xoff = 0 ; yoff = 0 ;;                for (npcc = ai->pccs; npcc; npcc=npcc->next) ;                   if (0 != (api=findadobe(npcc->partname)))[*                      if (api->texnum>=0) {4                         if (npcc->xoffset != xoff) {.                            if (uppercase[i]) {;                               voutln2("(MOVERIGHT R %.1f)",,K                                       capheight * (npcc->xoffset - xoff)) ;6=                            } else voutln2("(MOVERIGHT R %d)",h=                                       npcc->xoffset - xoff) ; 1                            xoff = npcc->xoffset ;i                         }w4                         if (npcc->yoffset != yoff) {.                            if (uppercase[i]) {8                               voutln2("(MOVEUP R %.1f)",K                                       capheight * (npcc->yoffset - yoff)) ;g:                            } else voutln2("(MOVEUP R %d)",=                                       npcc->yoffset - yoff) ; 1                            yoff = npcc->yoffset ;                          } L                         voutln2("(SETCHAR O %o)", (unsigned)api->adobenum) ;=                         xoff += texptrs[api->texnum]->width ;                       }F             } else voutln2("(SETCHAR O %o)", (unsigned)ai->adobenum) ;             vright() ;
          }          vright() ;i       } <    if (level) error("! I forgot to match the parentheses") ; }   
 void usage(f)]	 FILE *f ;+ {;    (void)fprintf(f,t>  "afm2tfm 7.8, Copyright 1990-93 by Radical Eye Software\n") ;    (void)fprintf(f,b<  "Usage: afm2tfm foo[.afm] [-O] [-u] [-v|-V bar[.vpl]]\n") ;    (void)fprintf(f,(A  "                 [-e expansion] [-s slant] [-c capheight]\n") ;)    (void)fprintf(f,=<  "                 [-p|-t|-T encodingfile] [foo[.tfm]]\n") ; }h   void openfiles(argc, argv)]
 int argc ; char *argv[] ; {]    register int lastext ;[    register int i ;     int arginc ;l    extern void exit() ;e      tfmout = (FILE *)NULL ;    if (argc == 1) {o       usage(stdout) ;t       exit(0) ;=    }  6 #if defined(MSDOS) || defined(OS2) || defined(ATARIST);    /* Make VPL file identical to that created under Unix */ 3    (void)sprintf(titlebuf, "afm2tfm %s", argv[1]) ;i #elsen #ifdef VMCMS;    /* Make VPL file identical to that created under Unix */ 3    (void)sprintf(titlebuf, "afm2tfm %s", argv[1]) ;  #elsea7    (void)sprintf(titlebuf, "%s %s", argv[0], argv[1]) ;  #endif #endif"    (void)strcpy(inname, argv[1]) ;    lastext = -1 ;     for (i=0; inname[i]; i++)       if (inname[i] == '.')I          lastext = i ;4       else if (inname[i] == '/' || inname[i] == ':')          lastext = -1 ;h4    if (lastext == -1) (void)strcat(inname, ".afm") ;  $    while (argc>2 && *argv[2]=='-') {       arginc = 2 ;       i = argv[2][1] ;       if (i == '/') 5          i = argv[2][2] - 32 ; /* /a ==> A for VMS */        switch (i) { case 'V': makevpl++ ;o case 'v': makevpl++ ;e)          (void)strcpy(outname, argv[3]) ;           lastext = -1 ;h#          for (i=0; outname[i]; i++)s"             if (outname[i] == '.')                lastext = i ;<             else if (outname[i] == '/' || outname[i] == ':')                lastext = -1 ; ;          if (lastext == -1) (void)strcat(outname, ".vpl") ; 
 #ifndef VMCMS= #ifndef ATARIST 5          if ((vplout=fopen(outname, WRITEBIN))==NULL)r #else)0          if ((vplout=fopen(outname, "w"))==NULL) #endif #else 0          if ((vplout=fopen(outname, "w"))==NULL) #endif3             error("! can't open vpl output file") ;           break ;A case 'e': if (sscanf(argv[3], "%f", &efactor)==0 || efactor<0.01)j-             error("! Bad extension factor") ;>!          efactorparam = argv[3] ;           break ;	 case 'c':hD          if (sscanf(argv[3], "%f", &capheight)==0 || capheight<0.01).             error("! Bad small caps height") ;          break ;/ case 's': if (sscanf(argv[3], "%f", &slant)==0)>,             error("! Bad slant parameter") ;          slantparam = argv[3] ;;          break ;	 case 'P':r	 case 'p':a          inenname = argv[3] ;1          break ;	 case 'T': )          inenname = outenname = argv[3] ;           break ;	 case 't':[          outenname = argv[3] ;          break ;	 case 'O':0          forceoctal = 1 ;=          arginc = 1 ;           break ;	 case 'u':*          pedantic = 1 ;>          arginc = 1 ;=          break ;I default: (void)fprintf(stderr, "Unknown option %s %s will be ignored.\n",h,                          argv[2], argv[3]) ;       }         for (i=0; i<arginc; i++) {E          (void)sprintf(titlebuf + strlen(titlebuf), " %s", argv[2]) ;           argv++ ;r          argc-- ;}       }i    }  (    if ((afmin=fopen(inname, "r"))==NULL),       error("! can't open afm input file") ;  .    if (argc>3 || (argc==3 && *argv[2]=='-')) {       usage(stderr) ; "       error("! incorrect usage") ;    }  1    if (argc == 2) (void)strcpy(outname, inname) ; (    else (void)strcpy(outname, argv[2]) ;      lastext = -1 ;     for (i=0; outname[i]; i++)        if (outname[i] == '.')          lastext = i ;L       else if (outname[i] == '/' || outname[i] == ':' || outname[i] == '\\')          lastext = -1 ;[    if (argc == 2) {        outname[lastext] = 0 ;       lastext = -1 ;    }    if (lastext == -1) {-!       lastext = strlen(outname) ; %       (void)strcat(outname, ".tfm") ;)    }A    if (tfmout == NULL && (tfmout=fopen(outname, WRITEBIN))==NULL) -       error("! can't open tfm output file") ;     outname[lastext] = 0 ;  /*C  *   Now we strip off any directory information, so we only use therH  *   base name in the vf file.  We accept any of /, :, or \ as directoryB  *   delimiters, so none of these are available for use inside the,  *   base name; this shouldn't be a problem.  */ (    for (i=0, lastext=0; outname[i]; i++)G       if (outname[i] == '/' || outname[i] == ':' || outname[i] == '\\')           lastext = i + 1 ;    if (lastext)0*       strcpy(outname, outname + lastext) ; }x /*?  *   Some routines to remove kerns that match certain patterns.   */  struct kern *rmkernmatch(k, s) struct kern *k ;	 char *s ;! {     struct kern *nk ;  %    while (k && strcmp(k->succ, s)==0);       k = k->next ;     if (k) {*%       for (nk = k; nk; nk = nk->next)h9          while (nk->next && strcmp(nk->next->succ, s)==0)b'             nk->next = nk->next->next ;o    }
    return k ;l }  /*  *   Recursive to one level.  */  void rmkern(s1, s2, ai)  char *s1, *s2 ;  struct adobeinfo *ai ; {6    if (ai == 0) {e!       if (strcmp(s1, "*") == 0) {n/          for (ai=adobechars; ai; ai = ai->next)e              rmkern(s1, s2, ai) ;          return ;e       } else {          ai = findadobe(s1) ;r          if (ai == 0)              return ;       }w    }    if (strcmp(s2, "*")==0)2       ai->kerns = 0 ; /* drop them on the floor */    elsek.       ai->kerns = rmkernmatch(ai->kerns, s2) ; }p int sawligkern ; /*G  *   Reads a ligkern line, if this is one.  Assumes the first character*  *   passed is `%'.o  */  void checkligkern(s)	 char *s ;p {y    char *oparam = param ;o    char *mlist[5] ;d
    int n ;      s++ ;    while (*s && *s <= ' ')       s++ ;h%    if (strncmp(s, "LIGKERN", 7)==0) {5       sawligkern = 1 ;       s += 7 ;       while (*s && *s <= ' ')L          s++ ;       param = s ;r       while (*param) {          for (n=0; n<5;) {             if (*param == 0)                break ;&             mlist[n] = paramstring() ;+             if (strcmp(mlist[n], ";") == 0)                 break ;             n++ ;*
          }          if (n > 4)/=             error("! too many parameters in lig kern data") ;c          if (n < 3) <             error("! too few parameters in lig kern data") ;J          if (n == 3 && strcmp(mlist[1], "{}") == 0) { /* rmkern command */?             rmkern(mlist[0], mlist[2], (struct adobeinfo *)0) ; <          } else if (n == 3 && strcmp(mlist[0], "||") == 0 &&L                               strcmp(mlist[1], "=") == 0) { /* bc command */4             struct adobeinfo *ai = findadobe("||") ;  #             if (boundarychar != -1)eA                error("! multiple boundary character commands?") ;v0             if (sscanf(mlist[2], "%d", &n) != 1)H                error("! expected number assignment for boundary char") ;!             if (n < 0 || n > 255){D                error("! boundary character number must be 0..255") ;             boundarychar = n ;             if (ai == 0)9                error("! internal error: boundary char") ;lM             ai->texnum = n ; /* prime the pump, so to speak, for lig/kerns */*          } else if (n == 4) {f             int op = -1 ;g"             struct adobeinfo *ai ;  (             for (n=0; encligops[n]; n++)7                if (strcmp(mlist[2], encligops[n])==0) {I                   op = n ;                   break ;                 }             if (op < 0)h5                error("! bad ligature op specified") ; 2             if (0 != (ai = findadobe(mlist[0]))) {                 struct lig *lig ;  I                if (findadobe(mlist[2]))     /* remove coincident kerns */ 2                   rmkern(mlist[0], mlist[1], ai) ;/                if (strcmp(mlist[3], "||") == 0);G                   error("! you can't lig to the boundary character!") ; G                if (! fixedpitch) { /* fixed pitch fonts get *0* ligs */ :                   for (lig=ai->ligs; lig; lig = lig->next):                      if (strcmp(lig->succ, mlist[1]) == 0)A                         break ; /* we'll re-use this structure */(!                   if (lig == 0) { %                      lig = newlig() ; 6                      lig->succ = newstring(mlist[1]) ;+                      lig->next = ai->ligs ;q%                      ai->ligs = lig ;u                   }12                   lig->sub = newstring(mlist[3]) ;                    lig->op = op ;2                   if (strcmp(mlist[1], "||")==0) {)                      lig->boundleft = 1 ;f3                      if (strcmp(mlist[0], "||")==0) M                         error("! you can't lig boundarychar boundarychar!") ;l                   } else)                      lig->boundleft = 0 ;t                }
             }u          } else 4             error("! bad form in LIGKERN command") ;       }l    }    param = oparam ;  }v /*M  *   Here we get a token from the AFM file.  We parse just as much PostScriptSL  *   as we expect to find in an encoding file.  We allow commented lines and:  *   names like 0, .notdef, _foo_.  We do not allow //abc.  */ ( char smbuffer[100] ;    /* for tokens */ char *gettoken() {    char *p, *q ;      while (1) {)       while (param == 0 || *param == 0) {n          if (getline() == 0)7             error("! premature end in encoding file") ;*           for (p=buffer; *p; p++)             if (*p == '%') {&                if (ignoreligkern == 0)#                   checkligkern(p) ;v                *p = 0 ;x                break ;
             }r       }0%       while (*param && *param <= ' ')"          param++ ;       if (*param) { .          if (*param == '[' || *param == ']' ||.              *param == '{' || *param == '}') {$             smbuffer[0] = *param++ ;             smbuffer[1] = 0 ;v             return smbuffer ;eF          } else if (*param == '/' || *param == '-' || *param == '_' ||$                     *param == '.' ||7                     ('0' <= *param && *param <= '9') ||O7                     ('a' <= *param && *param <= 'z') ||t7                     ('A' <= *param && *param <= 'Z')) {)"             smbuffer[0] = *param ;)             for (p=param+1, q=smbuffer+1; >                         *p == '-' || *p == '_' || *p == '.' ||3                         ('0' <= *p && *p <= '9') ||i3                         ('a' <= *p && *p <= 'z') ||>;                         ('A' <= *p && *p <= 'Z'); p++, q++)                 *q = *p ;             *q = 0 ;             param = p ;              return smbuffer ;)
          }       }     } }( void getligkerndefaults() { 
    int i ;  %    for (i=0; staticligkern[i]; i++) { (       strcpy(buffer, staticligkern[i]) ;)       strcpy(obuffer, staticligkern[i]) ;        param = buffer ;       checkligkern(buffer) ;    } }  /*H  *   This routine reads in an encoding file, given the name.  It returnsL  *   the final total structure.  It performs a number of consistency checks.  */e" struct encoding *readencoding(enc) char *enc ;  {i    char *p ;
    int i ;    struct encoding *e =aK       (struct encoding *)mymalloc((unsigned long)sizeof(struct encoding)) ;n      sawligkern = 0 ;g
    if (afmin) -       error("! oops; internal afmin error") ;c
    if (enc) {        afmin = fopen(enc, "r") ;n       param = 0 ;        if (afmin == 0)c6          error("! couldn't open that encoding file") ;       p = gettoken() ;!       if (*p != '/' || p[1] == 0) K          error("! first token in encoding must be literal encoding name") ;         e->name = newstring(p+1) ;       p = gettoken() ;       if (strcmp(p, "[")) E          error("! second token in encoding must be mark ([) token") ;        for (i=0; i<256; i++) {>          p = gettoken() ; $          if (*p != '/' || p[1] == 0)J             error("! tokens 3 to 257 in encoding must be literal names") ;%          e->vec[i] = newstring(p+1) ;        }        p = gettoken() ;       if (strcmp(p, "]")) B          error("! token 258 in encoding must be make-array (])") ;       while (getline()) {k           for (p=buffer; *p; p++)             if (*p == '%') {&                if (ignoreligkern == 0)#                   checkligkern(p) ;b                *p = 0 ;                 break ;
             }j       }x       fclose(afmin) ;        afmin = 0 ;=0       if (ignoreligkern == 0 && sawligkern == 0)          getligkerndefaults() ;a    } else {>       e = &staticencoding ;        getligkerndefaults() ;    }    param = 0 ;
    return e ;  }  /*L  *   This routine prints out the line that needs to be added to psfonts.map.  */{ void conspsfonts() {!    (void)printf("%s %s", outname, 
 #ifndef VMCMS     fontname) ;; #else /* VM/CMS: fontname is ascii, so we use ebfontname */     ebfontname) ; #endif0    if (slantparam || efactorparam || inenname) {       (void)printf(" \"") ;        if (slantparam) 4          (void)printf(" %s SlantFont", slantparam) ;       if (efactorparam)j7          (void)printf(" %s ExtendFont", efactorparam) ;        if (inenname) =          (void)printf(" %s ReEncodeFont", inencoding->name) ;        (void)printf(" \"") ;        if (inenname) )          (void)printf(" <%s", inenname) ;     }    (void)printf("\n") ;  }= #ifndef VMSe void #endif main(argc, argv)
 int argc ; char *argv[] ; {,
    int i ;    extern void exit() ;       for (i=0; i<256; i++);       nexttex[i] = -1 ; /* encoding chains have length 0 */ 6    tfmdata = (long *)mymalloc((unsigned long)40000L) ;    openfiles(argc, argv) ;    readadobe() ;    if (fontspace == 0) {       struct adobeinfo *ai ;  )       if (0 != (ai = findadobe("space")))i           fontspace = ai->width ;       else if (adobeptrs[32]) +          fontspace = adobeptrs[32]->width ;t
       else(          fontspace = transform(500, 0) ;    }    handlereencoding() ;a    buildtfm() ;t    writetfm() ;1    conspsfonts() ;    if (makevpl) {        assignchars() ;e       if (makevpl>1) upmap() ;       writevpl() ;    }    exit(0) ;    /*NOTREACHED*/i }l