 /*--> vaxvms.h */ H /***********************************************************************H This file provides alternative functions for several VMS VMS  C  libraryH routines which either unacceptable, or incorrect, implementations.  TheyH have  been developed and  tested under VMS Version  4.4, but indicationsH are  that they apply  to  earlier versions, back to 3.2  at least.  They2 should be retested with each new release of VMS C.  H Some of these (memxxx(), strxxx(),  and system()) are available with VMS5 C 2.3 or later, but these versions should still work.   	 Contents:  	EXIT  	FSEEK 	FTELL 	GETCHAR 	GETENV  	READ  	UNGETC ! 	getjpi		-- system-service access 	 	getlogin  	SYSTEM  	tell  	unlink  	utime 	memchr  	memcmp  	memcpy  	memmove 	memset  	stricmp 	strtok  	strtol   H The VAX VMS  file system record  structure has  unfortunate consequences for random access files.  H By default, text  files written by most system  utilities, and languagesH other than C, have a variable  length record format,  in  which a 16-bitH character count is  aligned on an  even-byte boundary in the  disk blockI b(always 512 bytes   in VMS, independent  of  record and  file  formats), H followed by  <count> bytes of data.   Binary files, such  as .EXE, .OBJ,H and  TeX .DVI  and font  files, all use a  512-byte  fixed record formatH which  has no explicit  length  field.  No  file  byte count  is stored;H instead, the block count,  and the  offset of the  last data byte in theH last block are recorded in the file header  (do ``DUMP/HEADER filespec''H to see it).  For binary files with fixed-length  records, the last blockH is normally  assumed to be  full,  and  consequently, file   transfer ofH binary data from other machines  via Kermit, FTP, or DCL  COPY from ANSIH tapes, generally fails because  the input file length is  not a multiple of 512.   H This record organization may  be contrasted with  the STREAM, STREAM_LF,H and STREAM_CR organizations supported from Version 4.0; in  these,  diskH blocks contain a continuous byte stream in which nothing, or  LF, or CR,H is recognized as a record terminator.  These formats are similar to  theH Unix  and TOPS-20 file system  formats  which also use continuous   byte streams.  H For C, this  means that a  program operating on a file  in record formatH cannot count input characters and expect that count to be the same valueH as the  offset parameter passed  to fseek(),  which  numerous C programsH assume to  be the case.  The draft  ANSI C  standard,  and  Harbison andH Steele's ``C Reference Manual'', emphasize that only  values returned byH ftell() should be used as arguments to fseek(),  allowing the program toH return to  a position previously read or  written.  UNFORTUNATELY, VMS CH ftell()  DOES NOT  RETURN   A CORRECT  OFFSET VALUE FOR   RECORD  FILES.H Instead, for record files, it returns the byte  offset  of the start  ofH the current record, no matter where in that  record the current positionH may  be.   This  misbehavior  is  completely unnecessary,   since    theD replacements below perform correctly, and are written entirely in C.  H Another problem is that ungetc(char c,  FILE*  fp) is unreliable.  VMS CH implements  characters  as  signed 8-bit integers  (so  do many other  CH implementations).  fgetc(FILE*  fp) returns an int,  not  a  char, whoseH value is EOF (-1) in the event of end-of-file;  however, this value willH also  be returned for  a   character  0xFF, so  it  is essential  to useH feof(FILE  *fp) to test  for a  true end-of-file condition  when  EOF isH returned.   ungetc() checks the sign of  its argument c,  and  if it  isH negative (which it will be for 128 of the 256 signed  bytes), REFUSES TOH PUT IT BACK IN THE INPUT STREAM, on the assumption that c is really EOF.H This  too can  be fixed;   ungetc()  should only  do   nothing if feof()H indicates  a  true  end-of-file  condition.   The   overhead of  this isH trivial, since feof() is   actually implemented  as a macro   which does6 nothing more than a logical AND and compare-with-zero.  H getchar()  waits for a <CR> to  be typed when stdin is  a terminal;  the( replacement vms_getchar() remedies this.  H Undoubtedly  other  deficiencies  in   VMS  C will   reveal  themselves.  H VMS read() returns   only  a  single  disk   block on  each call.    ItsH replacment, vms_read(), will  return  the  requested number of bytes, if	 possible.   A [29-Apr-87] Brendan Mackay (munnari!anucsd.oz!bdm@seismo.CSS.GOV) H This fix has been incorporated in vms_read() below.  Here are  Brendan's	 comments: H >> The code for vms_read() has problems.  One is that you don't test forH >> end of file.  The other is that there is a bug in the C library whichH >> prevents you  asking for  more than  65535 bytes  at a  time.  It  isH >> documented that no more  than 65535 bytes will  be returned, but  notH >> that you can't ask for more.  If you do, it reduces your request  mod	 >> 65536!   H There are also a  few Unix standard  functions which are  unimplemented.H qsort() is not provided.  getlogin()  and unlink() have VMS  equivalentsH provided below.  tell() is considered obsolete, since its  functionalityH is available from lseek(), but it is still seen in a few programs, so isH provided below.   getenv()  fails if  the  name contains  a  colon;  its replacement allows the colon.   H In the interest  of  minimal source perturbation,  replacements  for VMSH functions   are  given   the same  names,    but prefixed  "vms_".   ForH readability,   the original names  are  preserved,  but are converted to upper-case:    	#define FSEEK vms_fseek 	#define FTELL vms_ftell 	#define GETCHAR vms_getchar 	#define GETENV vms_getenv 	#define UNGETC vms_ungetc  H These  are  only defined to work   correctly for fixed  length  512-byteH records, and no check is made that the file has that organization (it isH possible, but   not without  expensive calls to    fstat(), or access to internal library structures).   G [02-Apr-87]  --	Nelson   H.F.  Beebe,  University  of Utah  Center  for  		Scientific ComputingG [13-Apr-88]  -- added memxxx(), strxxx(), fixed return code in system() B [05-Apr-91]  TH Darmstadt, Institut fuer Kernphysik, Chr. Spieler:A 	     -- removed qsort function. This function was identically to 8 		QSORT.C and was used in all Operating Systems (not VAX 		specific!)A 	     -- splitted the VAXVMS.C file into severall smaller modules : 		(named VAXVMS0.C, VAXVMS1.C ...) to allow the VMS linker0 		discart unused code from the executable files.? 	     -- VMS C 3.1 is ANSI conformant. Therefore the memxxx and < 		strxxx functions are no longer needed. These functions are7 		put into VAXVMS8.C, VAXVMS9.C and are no longer bound  		into UNIXCLIB.OLB.B [09-May-91]  TH Darmstadt, Institut fuer Kernphysik, Chr. Spieler:D 	     -- changed name of function system() to vms-system (and define< 		it as uppercase SYSTEM ) to eliminate duplicate linking of6 		VMS supplied routine in module C$UNIX in VAXCRTL.OLBA 	     -- added a few include files for correct system service and # 		VMS runtime library declarations. B [06-Jul-92]  TH Darmstadt, Institut fuer Kernphysik, Chr. Spieler:E 	     --	corrected code of FTELL function: do not add offset in block < 		to pos when VAX C ftell already returned correct position.2 		(This makes FTELL compatible with stream files.)B 	     -- correction to FSEEK function to enable compatibility with; 		stream files: Removed the "(*fp)->_cnt = 0;" line after a ; 		move to a new block. This is done automatically for fixed > 		length record mode files; and for stream files the buffer is 		already filled by fseek().B [09-Sep-93]  TH Darmstadt, Institut fuer Kernphysik, Chr. Spieler:B 	     --	ported to OpenVMS for Alpha AXP, DEC C compiler (ANSI C):  		Cleaned up ANSI compatibility.A 	     --	The interface to FSEEK and UNGETC was changed to make it + 		more compatible to other implementations. B 	     --	In utime(), a type cast was added for ANSI compatibility.B [30-Nov-93]  TH Darmstadt, Institut fuer Kernphysik, Chr. Spieler:? 	     --	The runtime library for DEC C in OpenVMS (AXP) 1.5 and : 		OpenVMS (VAX) 6.0 finally supply versions of fseek() and; 		ftell() that work correctly on fixed length record files. 8 		When compiling for DEC C 1.3 or newer, the replacement1 		functions in this library are no longer needed. B [31-Dec-93]  TH Darmstadt, Institut fuer Kernphysik, Chr. Spieler:B 	     --	corrected the SEEK_END mode of vms_fseek(); file position7 		was set one character in front of requested position. D 	     -- vms_fseek() does now clear the EOF flag before a successful	 		return. B 	     --	reenabled the vms_ftell() replacement for DEC C (__DECC).9 		The DEC C 1.3 (for Alpha AXP) ftell() function does not 8 		work at EOF position when EOF flag is not yet set. The? 		buffer refill in the replacement function cures this problem. . 		The offset correction is bypassed for DEC C.H ***********************************************************************/   #define ANSI_PROTOTYPES	1   - #if ANSI_PROTOTYPES		/* VMS C 2.3 or later */  #define VOIDP	void* ! #else				/* prior to VMS C 2.3 */ 0 #define VOIDP	char*		/* char* prior to ANSI C */8 #define const			/* const is a type modifier in ANSI C */ #endif   #define EXIT	vms_exit 
 #ifdef __DECC  #define FSEEK	fseek  #else /* !__DECC */  #define FSEEK	vms_fseek  #endif /* ?__DECC */ #define FTELL	vms_ftell  #define GETENV	vms_getenv  #define GETCHAR vms_getchar  #define READ	vms_read  #define SYSTEM	vms_system  #define UNGETC	vms_ungetc    #include <stdio.h>   #if ANSI_PROTOTYPES  #include <stddef.h>  #include <stdlib.h> B #include <string.h>		/* stupid VMS gets type of memchr() wrong! */ #include <unixio.h>  #include <unixlib.h> #else  char*	strchr();  char*	getenv();  #endif   #include <types.h> #include <ctype.h>* #include <errno.h>		/* need for utime() */ #include <stat.h> ( #include <rms.h>		/* need for utime() */ #include <descrip.h>0 #include <iodef.h>		/* need for vms_getchar() */4 #include <lib$routines.h>	/* declares all lib$... */8 #include <libdef.h>		/* declares all lib$... messages */ #include <ssdef.h>4 #include <starlet.h>		/* declares system services */) #include <time.h>		/* need for utime() */    extern void  EXIT(int code); extern long  FTELL(FILE *fp); . extern int   FSEEK(FILE *fp, long n, int dir);% extern int   UNGETC(int c, FILE *fp);  extern int   GETCHAR(void); ; extern int   READ(int file_desc, char *buffer, int nbytes); & extern char *GETENV(const char *name); extern char *getlogin(void); extern long  tell(int handle);$ extern int   unlink(char *filename);