 /*--> vaxvms1.c */H /***********************************************************************H This file provides alternative functions for several VMS VMS  C  libraryH routines which either unacceptable, or incorrect, implementations.  TheyH have  been developed and  tested under VMS Version  4.4, but indicationsH are  that they apply  to  earlier versions, back to 3.2  at least.  They2 should be retested with each new release of VMS C.H ***********************************************************************/  ? #include "vaxvms.h"		/* common definitions and documentation */    #ifndef __DECCH /**********************************************************************/ /*-->FSEEK*/  F /* VMS fseek() and ftell() on fixed-length record files work correctlyF only at block boundaries.  This replacement code patches in the offsetC within	the  block.  Directions	 from	current	  position   and  from F end-of-file are converted to absolute positions, and then the code for that case is invoked. */   int  FSEEK(FILE *fp,long n,int dir) {      long k,m,pos,oldpos;     int val;     struct stat buffer;   -     for (;;)			/* loops only once or twice */      {        switch (dir)       {        case 0:			/* from BOF */< 	  oldpos = FTELL(fp);	/* get current byte offset in file *// 	  k = n & 511;		/* offset in 512-byte block */ 3 	  m = n >> 9;		/* relative block number in file */ G 	  if (((*fp)->_cnt) && ((oldpos >> 9) == m)) /* still in same block */  	  { 	    val = 0;		/* success */G 	    (*fp)->_ptr = ((*fp)->_base) + k;	/* reset pointer and count to */ 1 	    (*fp)->_cnt = 512 - k;		/* requested byte */  	  } 	  else  	  {N 	    val = fseek(fp,m << 9,0); /* move to start of requested 512-byte block */  	    if (val == 0)	/* success */ 	    {4 	      (void)fgetc(fp);	/* force refill of buffer */O 	      (*fp)->_ptr = ((*fp)->_base) + k;	/* reset pointers to requested byte */  	      (*fp)->_cnt = 512 - k; 4 	      (*fp)->_flag &= ~_IOEOF;	/* reset EOF flag */ 	    } 	  } 	  return(val);   &       case 1:			/* from current pos */ 	  pos = FTELL(fp); # 	  if (pos == EOF)	/* then error */  	    return (EOF); 	  n += pos; 	  dir = 0;  	  break;		/* go do case 0 */          case 2:			/* from EOF */# 	  val = fstat(fileno(fp),&buffer); # 	  if (val == EOF)	/* then error */  	    return (EOF);A 	  n += buffer.st_size;	/* add filesize to requested offset to */ ! 				/* get the absolute offset */  	  dir = 0;  	  break;		/* go do case 0 */   2       default:			/* illegal direction parameter */ 	  return (EOF);       }      }  }  #endif /* !__DECC */  H /**********************************************************************/ /*-->FTELL*/  D /* With fixed-length record files, ftell() returns the offset of theA start of block.	 To get the true position, this must be biased by  the offset within the block. */    long FTELL(FILE *fp)  {      char c; 
     long pos;      int val;:     if ((*fp)->_cnt == 0)	/* buffer empty--force refill */     {  	c = fgetc(fp);  	val = UNGETC(c,fp); 	if (val != c), 	    return (EOF);	/* should never happen */     } 
 #ifdef __DECC F     return (ftell(fp));		/* ftell() returns correct offset in block */ #else /* !__DECC */ I     pos = ftell(fp);		/* this returns multiple of 512 (start of block) */ >     if (pos >= 0		/* then success--patch in offset in block */B 	&& !(pos&511))		/* do not patch if pos already contains offset */,       pos += ((*fp)->_ptr) - ((*fp)->_base);     return (pos);  #endif /* ?__DECC */ } 