 /*--> vaxvms2.c */H /***********************************************************************H This file provides alternative functions for several VMS VMS  C  libraryH routines which either unacceptable, or incorrect, implementations.  TheyH have  been developed and  tested under VMS Version  4.4, but indicationsH are  that they apply  to  earlier versions, back to 3.2  at least.  They2 should be retested with each new release of VMS C.H ***********************************************************************/  ? #include "vaxvms.h"		/* common definitions and documentation */   H /**********************************************************************/ /*-->GETCHAR*/  B static int tt_channel = -1;	/* terminal channel for image QIO's */  @ #define FAILED(status) (~(status) & 1) /* failure if LSB is 0 */   int 
 GETCHAR(void)  { +     int ret_char;		/* character returned */ -     int status;			/* system service status */ %     static $DESCRIPTOR(sys_in,"TT:");   ?     if (tt_channel == -1)	/* then first call--assign channel */      { . 	status = sys$assign(&sys_in,&tt_channel,0,0); 	if (FAILED(status)) 	    lib$stop(status);     }      ret_char = 0; F     status = sys$qiow(0,tt_channel,IO$_TTYREADALL | IO$M_NOECHO,0,0,0, 	&ret_char,1,0,0,0,0);     if (FAILED(status))          lib$stop(status);        return (ret_char); }     H /**********************************************************************/
 /*-->UNGETC*/  int  UNGETC(int c, FILE *fp) F 	     /* VMS ungetc() is a no-op if c < 0 (which is half the time!) */ {        if ((c == EOF) && feof(fp)) 4 	return (EOF);		/* do nothing at true end-of-file */P     else if ((*fp)->_cnt >= 512)/* buffer full--no fgetc() done in this block!*/8 	return (EOF);		/* must be user error if this happens */5     else			/* put the character back in the buffer */      { =       (*fp)->_cnt++;		/* increase count of characters left */ A       (*fp)->_ptr--;		/* backup pointer to next available char */ 8       *((*fp)->_ptr) = (char)c;	/* save the character */&       return (c);		/* and return it */     }  }   H /**********************************************************************/
 /*-->GETENV*/  char*  GETENV(const char *name) {      char* p;     char* result;      char ucname[256];        p = ucname; <     while (*name)	/* VMS logical names must be upper-case */     { 5       *p++ = islower(*name) ? toupper(*name) : *name; 
       ++name;      }      *p = '\0';  1     p = strchr(ucname,':');		/* colon in name? */ 2     if (p == (char *)NULL)		/* no colon in name */          result = getenv(ucname);,     else				/* try with and without colon */     {  	result = getenv(ucname);  	if (result == (char *)NULL) 	{ 	    *p = '\0';  	    result = getenv(ucname);  	    *p = ':'; 	}     }      return (result); } 