 /*--> vaxvms5.c */H /***********************************************************************H This file provides alternative functions for several VMS VMS  C  libraryH routines which either unacceptable, or incorrect, implementations.  TheyH have  been developed and  tested under VMS Version  4.4, but indicationsH are  that they apply  to  earlier versions, back to 3.2  at least.  They2 should be retested with each new release of VMS C.H ***********************************************************************/  ? #include "vaxvms.h"		/* common definitions and documentation */   H /**********************************************************************/
 /*-->getjpi*/   H /***********************************************************************H Return  a system job/process value  obtained   from the VMS  system callH LIB$GETJPI.   This call   can return  either 32-bit   integer values, orH strings.  The  obtained value is stored in  an  internal  static  buffer) which is overwritten on subsequent calls.   H The function return is a (char*) pointer to  that buffer, which must  beH coerced to  (long*) if an integer value is  obtained.  String values are9 guaranteed to be NUL terminated, with no trailing blanks.   C The argument, jpi_code, is one of the values defined in <jpidef.h>.   H In the event of an error return from LIB$GETJPI, (char*)NULL is returned instead.   [30-Oct-87] H ***********************************************************************/   #ifndef __LIBDEF_LOADED D #define LIB$_INVARG 0x158234		/* not defined in standard .h files */ #endif   #ifndef __LIB$ROUTINES_LOADED  unsigned long int lib$getjpi();  #endif   char* A getjpi(int jpi_code)		/* jpi_code values defined in <jpidef.h> */    {      short retlen = 0;      long retval;D     static char buffer[256];		/* space for up to 255-char results */&     static $DESCRIPTOR(strdes,buffer);  N     strdes.dsc$w_length = sizeof(buffer)-1; /* $DESCRIPTOR doesn't set this */  A     /* lib$getjpi() will normally return a string representation. F        Try first to get the integer representation, then if an invalid?        argument is signalled, get the string representation. */   1     retval = lib$getjpi(&jpi_code,0L,0L,&buffer);      if (retval == LIB$_INVARG)     { E         retval = lib$getjpi(&jpi_code,0L,0L,&buffer,&strdes,&retlen); @         buffer[retlen] = '\0';		/* terminate any string value */2 	while ((retlen > 0) && (buffer[--retlen] == ' ')) 	    buffer[retlen] = '\0';      }   E     return ((retval == SS$_NORMAL) ? (char*)(&buffer) : (char*)NULL);  } 