 /*B  *   These routines do most of the communicating with the printer.  *E  *   LINELENGTH tells the maximum line length to send out.  It's been E  *   reduced to 72 because sometimes PostScript files are included in :  *   mail messages and many mailers mutilate longer lines.  */  #define LINELENGTH (72) K #include "dvips.h" /* The copyright notice in that file is included too! */  #include <ctype.h>  
 #ifdef OS2 #include <stdlib.h>  #ifdef _MSC_VER / #define popen(pcmd, pmode)  _popen(pcmd, pmode) ( #define pclose(pstream) _pclose(pstream) #endif #endif /*'  *   The external routines called here:   */  extern void error() ;  extern void send_headers() ; extern int add_header() ;  extern FILE *search() ;  extern char *getenv() ;  extern void makepsname() ; extern void handlepapersize() ;  extern void findbb() ; /*=  *   These are the external variables used by these routines.   */  extern integer hh, vv ;  extern fontdesctype *curfnt ;  extern FILE *bitfile ; extern char *oname ; extern Boolean secure ;  extern Boolean reverse ; extern Boolean removecomments ; = extern Boolean sendcontrolD, disablecomments, multiplesects ; ) extern Boolean usesPSfonts, headers_off ;  extern Boolean safetyenclose ; extern Boolean cropmarks ; extern Boolean tryepsf ; extern Boolean compressed ;  extern int numcopies ; extern int collatedcopies ;  extern integer pagecopies ;  extern int totalpages ;  extern integer pagenum ; extern Boolean manualfeed ;  extern int landscape ; extern int quiet ; extern int prettycolumn ; " extern int actualdpi, vactualdpi ;! extern char *iname, *nextstring ;  extern char *paperfmt ;  extern char *headerpath ;  extern char errbuf[] ; extern shalfword linepos ; extern char *figpath ;* extern struct header_list *ps_fonts_used ; extern char banner[] ; extern int gargc ; extern char **gargv ;   extern struct papsiz *papsizes ;' extern integer hpapersize, vpapersize ; : char preamblecomment[256] ; /* usually "TeX output ..." */ /*2  *   We need a few statics to take care of things.  */  static integer rhh, rvv ;  static int instring ;   static Boolean lastspecial = 1 ; static shalfword d ; static Boolean popened = 0 ;D int lastfont ; /* exported to dospecial to fix rotate.tex problem */H static void chrcmd();                   /* just a forward declaration */< static char strbuffer[LINELENGTH + 20], *strbp = strbuffer ;! static struct papsiz *finpapsiz ; " static struct papsiz defpapsiz = {(    0, 40258437L, 52099154L, "letter", "" } ;  #ifdef CREATIONDATE b #if (!defined(VMS) && !defined(MSDOS) && !(defined(OS2) && defined(_MSC_VER)) && !defined(ATARIST))  /* VAXC/MSDOS don't like/need this !! */  #include <sys/types.h>8 #include <sys/time.h> /* time(), at least on BSD Unix */ #endifG #include <time.h> /* asctime() and localtime(), at least on BSD Unix */  static time_t jobtime; #endif /*D  *   This routine copies a file down the pipe.  Search path uses the  *   header path.   *9  *   We add code to handle the case of MS-DOS font files.   *D  *   Format:  80 {01,02} four byte length in littleendian order data&  *   repeated possibly multiple times.  */ * static char *hxdata = "0123456789ABCDEF" ; static int infigure ;  extern char *infont ; - static char *begbinary = "\n%%BeginBinary:" ;  void copyfile(s)          char *s ;  {     FILE *f = NULL ;     int c, prevc = '\n' ;
    long len ;     char *bbmatch = begbinary ;    /* begin DOS EPS code */     int doseps = 0;,    unsigned long dosepsbegin, dosepsend = 0;    /* end DOS EPS code */  #ifdef VMCMS    register char *lastdirsep ;    register char *trunc_s ;     trunc_s = s ; #endif #ifdef MVSXA    register char *lastdirsep ;    register char *trunc_s ;     trunc_s = s ; #endif      switch (infigure) {
    case 1: /*E  *   Look in headerpath too, just in case.  This allows common header =  *   or figure files to be installed in the .../ps directory.   */ $       f = search(figpath, s, READ) ;       if (f == 0) *          f = search(headerpath, s, READ) ; #ifdef VMCMS$       lastdirsep = strrchr(s, '/') ;:       if ( NULL != lastdirsep ) trunc_s = lastdirsep + 1 ;       (void)sprintf(errbuf, M    "Couldn't find figure file %s with CMS name %s; continuing", s, trunc_s) ;  #else  #ifdef MVSXA$       lastdirsep = strrchr(s, '/') ;:       if ( NULL != lastdirsep ) trunc_s = lastdirsep + 1 ;       (void)sprintf(errbuf, N     "Couldn't find figure file %s with MVS name %s; continuing", s, trunc_s) ; #else L       (void)sprintf(errbuf, "Couldn't find figure file %s; continuing", s) ; #endif #endif
       break ;     default: '       f = search(headerpath, s, READ) ; B       (void)sprintf(errbuf, "! Couldn't find header file %s", s) ;
       break ; 
 #ifndef VMCMS 
 #ifndef MVSXA  #ifndef VMS 
 #ifndef MSDOS  #ifndef ATARIST  #ifndef __THINK__ 
    case 2:
 #ifdef SECURE J       (void)sprintf(errbuf, "<%s>: Tick filename execution disabled", s) ; #else 
 #ifdef OS2        if (_osmode == OS2_MODE) { #endif       if (secure == 0)          f = popen(s, "r") ;
 #ifdef OS2       }  #endifE       (void)sprintf(errbuf, "Failure to execute %s; continuing", s) ;  #endif       break; #endif #endif #endif #endif #endif #endif    }    if (f==NULL)        error(errbuf) ; 	    else {        if (! quiet) {5          if (strlen(s) + prettycolumn > STDOUTSIZE) { #             fprintf(stderr, "\n") ;              prettycolumn = 0 ;
          } #ifdef VMCMS1          (void)fprintf(stderr, "<%s>", trunc_s) ;  #else  #ifdef MVSXA1          (void)fprintf(stderr, "<%s>", trunc_s) ;  #else +          (void)fprintf(stderr, "<%s>", s) ;  #endif #endif          (void)fflush(stderr) ; (          prettycolumn += 2 + strlen(s) ;       }        if (linepos != 0) $          (void)putc('\n', bitfile) ;       if (! disablecomments)          if (infigure)B             (void)fprintf(bitfile, "%%%%BeginDocument: %s\n", s) ;          else if (infont) C             (void)fprintf(bitfile, "%%%%BeginFont: %s\n", infont) ; 
          else A             (void)fprintf(bitfile, "%%%%BeginProcSet: %s\n", s) ;        c = getc(f) ;        if (c == 0x80) {4 #if defined MSDOS || defined OS2 || defined(ATARIST)7          (void)fclose(f) ;  /* close MSDOS font file */ J          f = search(headerpath, s, READBIN) ;  /* reopen in BINARY mode */E          (void)sprintf(errbuf, "! Couldn't find header file %s", s) ;           if (f==NULL)             error(errbuf) ;          c = getc(f);  #endif          while (1) {             c = getc(f) ;              switch(c) {  case 1:  case 2:                 len = getc(f) ;&                len += getc(f) * 256L ;(                len += getc(f) * 65536L ;.                len += getc(f) * 256L * 65536 ;                if (c == 1) {#                   while (len > 0) { "                      c = getc(f) ;$                      if (c == EOF) {D                         error("premature EOF in MS-DOS font file") ;!                         len = 0 ;                       } else { $                         if (c == 13)6                            (void)putc('\n', bitfile) ;                         else3                            (void)putc(c, bitfile) ;                          len-- ;                       }                   }                 } else { '                   putc('\n', bitfile) ;                    prevc = 0 ; #                   while (len > 0) { "                      c = getc(f) ;$                      if (c == EOF) {D                         error("premature EOF in MS-DOS font file") ;!                         len = 0 ;                       } else { =                         (void)putc(hxdata[c >> 4], bitfile) ; =                         (void)putc(hxdata[c & 15], bitfile) ;                          len-- ; $                         prevc += 2 ;*                         if (prevc >= 76) {0                            putc('\n', bitfile) ;&                            prevc = 0 ;                         }                       }                   }                 }                break ; case 3:                 goto msdosdone ;  default:L                error("saw type other than 1, 2, or 3 in MS-DOS font file") ;                break ;
             }              c = getc(f) ;              if (c == EOF)                 break ;             if (c != 0x80) {A                error("saw non-MSDOS header in MSDOS font file") ;                 break ;
             } 
          }
 msdosdone:          prevc = 0 ;       } else { /* begin DOS EPS code */          if (c == 'E'+0x80) { :             if ((getc(f)=='P'+0x80) && (getc(f)=='S'+0x80)6 	                            && (getc(f)=='F'+0x80)) {  #if defined MSDOS || defined OS2:                (void)fclose(f) ;  /* close DOS EPS file */3                f = search(headerpath, s, READBIN) ; N                                                    /* reopen in BINARY mode */K                (void)sprintf(errbuf, "! Couldn't find header file %s", s) ;                 if (f==NULL)                    error(errbuf) ;                fseek(f, 4L, 0);  #endif                doseps = 1;&                dosepsbegin = getc(f) ;.                dosepsbegin += getc(f) * 256L ;0                dosepsbegin += getc(f) * 65536L ;6                dosepsbegin += getc(f) * 256L * 65536 ;$                dosepsend = getc(f) ;,                dosepsend += getc(f) * 256L ;.                dosepsend += getc(f) * 65536L ;4                dosepsend += getc(f) * 256L * 65536 ;(                dosepsend += dosepsbegin;  #if defined MSDOS || defined OS2:                (void)fclose(f) ;  /* close DOS EPS file */K                f = search(headerpath, s, READ) ;  /* reopen in TEXT mode */ K                (void)sprintf(errbuf, "! Couldn't find header file %s", s) ;                 if (f==NULL)                    error(errbuf) ; #endif(                fseek(f, dosepsbegin, 0);                c = getc(f); 
             }              else {                rewind(f);                 c = getc(f); 
             } 
          } /* end DOS EPS code */          if (c != EOF) {             while (1) { #                if (c == *bbmatch) {                    bbmatch++ ; )                   if (*bbmatch == '\0') { '                      integer size = 0 ;   (                      if (removecomments)9                         (void)fputs(begbinary, bitfile) ; -                      (void)putc(c, bitfile) ;                        while (1) {%                         c = getc(f) ; %                         if (c == ' ') 3                            (void)putc(c, bitfile) ;                          else"                            break ;                      }3                      while ('0' <= c && c <= '9') { 4                         size = size * 10 + c - '0' ;0                         (void)putc(c, bitfile) ;%                         c = getc(f) ;                       }5                      while (c != '\r' && c != '\n') { %                         if (c == EOF) D                            error("! bad BeginBinary line in epsf") ;0                         (void)putc(c, bitfile) ;%                         c = getc(f) ;                       }-                      (void)putc(c, bitfile) ; -                      for (; size>0; size--) { %                         c = getc(f) ; %                         if (c == EOF) O                            error("! premature end of file in binary section") ; 0                         (void)putc(c, bitfile) ;                      }"                      c = getc(f) ;2                      if (c == '\n' || c == '\r') {0                         (void)putc(c, bitfile) ;%                         c = getc(f) ;                       }"                      if (c != '%')O                         error("! expected to see %%EndBinary at end of data") ;                        while (1) {0                         (void)putc(c, bitfile) ;3                         if (c == '\r' || c == '\n') "                            break ;%                         c = getc(f) ; %                         if (c == EOF) O                            error("! premature end of file in binary section") ;                       }"                      c = getc(f) ;                   }                 } else '                   bbmatch = begbinary ; A                if (removecomments && c == '%' && prevc == '\n') { ,                          /* skip comments */7 		         /* revised:  only skip %% and %! comments */                    c = getc(f) ; -                   if (c == '%' || c == '!') { /                      while ((c=getc(f))!=EOF) { 5                         if (c == '\n' || c == '\r') { %                            c = '\n' ; "                            break ;                         }                       } 		  } else {! 		     (void)putc('%', bitfile) ;  		     if (c != EOF)0                         (void)putc(c, bitfile) ; 		  }  #ifdef VMCMS'                } else if (c != 0x37 ) {  #else  #ifdef MVSXA'                } else if (c != 0x37 ) {  #else #                } else if (c != 4) {  #endif #endif*                   (void)putc(c, bitfile) ;                }                prevc = c ; /* begin DOS EPS code */3                if (doseps && (ftell(f)>=dosepsend)) M                   break;      /* stop at end of DOS EPS PostScript section */  /* end DOS EPS code */                c = getc(f) ;                if (c == EOF)                   break ; "                else if (c == '\r')                   c = '\n' ;
             } 
          }       }        if (prevc != '\n')$          (void)putc('\n', bitfile) ;       linepos = 0 ; 
 #ifndef VMCMS 
 #ifndef MVSXA  #ifndef VMS 
 #ifndef MSDOS  #ifndef ATARIST  #ifndef __THINK__        if (infigure == 2)
 #ifdef OS2
          {$             if (_osmode == OS2_MODE)                 (void)pclose(f) ;
          } #else           (void)pclose(f) ; #endif
       else #endif #endif #endif #endif #endif #endif          (void)fclose(f) ;       if (!disablecomments)           if (infigure)9             (void)fprintf(bitfile, "%%%%EndDocument\n") ;           else if (infont) 5             (void)fprintf(bitfile, "%%%%EndFont\n") ; 
          else 8             (void)fprintf(bitfile, "%%%%EndProcSet\n") ;    } }    /*D  *   For included PostScript graphics, we use the above routine, but!  *   with no fatal error message.   */  void figcopyfile(s, systemtype) 	 char *s ;  int systemtype ; { "    infigure = systemtype ? 2 : 1 ;    copyfile(s) ;    infigure = 0 ;  }  /*G  *   This next routine writes out a `special' character.  In this case, E  *   we simply put it out, since any special character terminates the   *   preceding token.   */  void
 specialout(c)          char c ; {     if (linepos >= LINELENGTH) { !       (void)putc('\n', bitfile) ;        linepos = 0 ;     }    (void)putc(c, bitfile) ;     linepos++ ;    lastspecial = 1 ; }    void stringend()  { .    if (linepos + instring >= LINELENGTH - 2) {!       (void)putc('\n', bitfile) ;        linepos = 0 ;     }    (void)putc('(', bitfile) ;     *strbp = 0 ; $    (void)fputs(strbuffer, bitfile) ;    (void)putc(')', bitfile) ;     linepos += instring + 2 ;    lastspecial = 1 ;    instring = 0 ;     strbp = strbuffer ; }    void% scout(c)   /* string character out */          char c ; {  /*B  *   Is there room in the buffer?  LINELENGTH-6 is used because weB  *   need room for (, ), and a possible four-byte string \000, for:  *   instance.  If it is too long, we send out the string.  */ !    if (instring > LINELENGTH-6) {        stringend() ;        chrcmd('p') ;     }: /*  changed next line to hex representation for VMCMS port%    if (c<' ' || c > 126 || c=='%' ) {  */)    if ( c<0x20 || c>= 0x7F || c==0x25 ) {        *strbp++ = '\\' ; '       *strbp++ = '0' + ((c >> 6) & 3) ; '       *strbp++ = '0' + ((c >> 3) & 7) ;         *strbp++ = '0' + (c & 7) ;       instring += 4 ;     } else {  #ifdef VMCMS      c = ascii2ebcdic[c];  #else  #ifdef MVSXA      c = ascii2ebcdic[c];  #endif #endif-      if (c == '(' || c == ')' || c == '\\') {         *strbp++ = '\\' ;        *strbp++ = c ;         instring += 2 ;
      } else {         *strbp++ = c ;m        instring++ ;i      }    } }e   void	 cmdout(s)N         char *s ;u {i
    int l ;      /* hack added by dorab */    if (instring) {         stringend();         chrcmd('p');    }    l = strlen(s) ;7    if ((! lastspecial && linepos >= LINELENGTH - 20) ||H'            linepos + l >= LINELENGTH) {h!       (void)putc('\n', bitfile) ;o       linepos = 0 ;p       lastspecial = 1 ;u    } else if (! lastspecial) {        (void)putc(' ', bitfile) ;       linepos++ ;d    }    (void)fputs(s, bitfile) ;    linepos += l ;     lastspecial = 0 ; }t     static void 	 chrcmd(c)e         char c ; {x7    if ((! lastspecial && linepos >= LINELENGTH - 20) ||x"        linepos + 2 > LINELENGTH) {!       (void)putc('\n', bitfile) ;e       linepos = 0 ;d       lastspecial = 1 ;v    } else if (! lastspecial) {        (void)putc(' ', bitfile) ;       linepos++ ;*    }    (void)putc(c, bitfile) ;n    linepos++ ;    lastspecial = 0 ; }t   void floatout(n)o         float n ;e {s    char buf[20] ;o  "    (void)sprintf(buf, "%.2f", n) ;    cmdout(buf) ; }o   void	 numout(n)d         integer n ;p {e    char buf[10] ;e   #ifdef SHORTINTd!    (void)sprintf(buf, "%ld", n) ;c #else      (void)sprintf(buf, "%d", n) ; #endif    cmdout(buf) ; }o   void mhexout(p, len)n register unsigned char *p ;c register long len ;e {i$    register char *hexchar = hxdata ;    register int n, k ;      while (len > 0) {%       if (linepos > LINELENGTH - 2) {;$          (void)putc('\n', bitfile) ;          linepos = 0 ;       } '       k = (LINELENGTH - linepos) >> 1 ;r       if (k > len)          k = len ;       len -= k ;       linepos += (k << 1) ;x       while (k--) {s          n = *p++ ;a/          (void)putc(hexchar[n >> 4], bitfile) ; /          (void)putc(hexchar[n & 15], bitfile) ;n       }a    } }x   void
 fontout(n)         int n ;n {t    char buf[6] ;      if (instring) {       stringend() ;*       chrcmd('p') ;.    }    makepsname(buf, n) ;s    cmdout(buf) ; }f   void hvpos()t {c    if (rvv != vv) {        if (instring) {           stringend() ;          numout(hh) ;o          numout(vv) ;p          chrcmd('y') ;       } else if (rhh != hh) {o          numout(hh) ;           numout(vv) ;)          chrcmd('a') ;L       } else { /* hard to get this case, but it's there when you need it! */          numout(vv - rvv) ;a          chrcmd('x') ;       }        rvv = vv ;    } else if (rhh != hh) {       if (instring) {           stringend() ;,          if (hh - rhh < 5 && rhh - hh < 5) {@ #ifdef VMCMS /*  should replace 'p' in non-VMCMS line as well */:             chrcmd(ascii2ebcdic[(char)(112 + hh - rhh)]) ; #else/@ #ifdef MVSXA /*  should replace 'p' in non-MVSXA line as well */:             chrcmd(ascii2ebcdic[(char)(112 + hh - rhh)]) ; #elset,             chrcmd((char)('p' + hh - rhh)) ; #endif #endif;          } else if (hh - rhh < d + 5 && rhh - hh < 5 - d) {*@ #ifdef VMCMS /* should replace 'g' in non-VMCMS line as well  */>             chrcmd(ascii2ebcdic[(char)(103 + hh - rhh - d)]) ; #elser@ #ifdef MVSXA /* should replace 'g' in non-MVSXA line as well  */>             chrcmd(ascii2ebcdic[(char)(103 + hh - rhh - d)]) ; #elsec0             chrcmd((char)('g' + hh - rhh - d)) ; #endif #endif             d = hh - rhh ;          } else {t             numout(hh - rhh) ;             chrcmd('b') ;i             d = hh - rhh ;
          }       } else {          numout(hh - rhh) ;n          chrcmd('w') ;       }P    }
    rhh = hh ;C }    /*I  *   initprinter opens the bitfile and writes the initialization sequencee  *   to it.M  */  void newline() {a    if (linepos != 0) {$       (void)fprintf(bitfile, "\n") ;       linepos = 0 ;f    }    lastspecial = 1 ; }L   void nlcmdout(s),         char *s ;s {l    newline() ;    cmdout(s) ;    newline() ; }a /*F  *   Is the dimension close enough for a match?  We use a quarter inchB  *   as a match; this is 65536*72.27/4 or 1,184,072 scaled points.  */C static int indelta(i)s integer i ;) { 
    if (i < 0)        i = -i ;    return (i <= 1184072) ; }  /*&  *   A case-irrelevant string compare.  */e
 int mlower(c)M int c ;; {n    if ('A' <= c && c <= 'Z')       return c - 'A' + 'a' ;    elser       return c ; }  int ncstrcmp(a, b)
 char *a, *b ;  {t    while (*a && (*a == *b ||1                        mlower(*a) == mlower(*b)))h       a++, b++ ;    if (*a == 0 && *b == 0)       return 0 ;    elseb       return 1 ; }g /*  *   Find the paper size.   */f void findpapersize() {    if (finpapsiz == 0) {       struct papsiz *ps ;   "       if (tryepsf && !landscape) {!          finpapsiz = &defpapsiz ; '          hpapersize = defpapsiz.xsize ;X'          vpapersize = defpapsiz.ysize ;           return ;_       }        if (cropmarks) { /*C  *   If user wanted crop marks, we increase the size of the page by   *   a half inch all around.  */(2          if (hpapersize == 0 || vpapersize == 0) {             error(O  "warning: -k crop marks wanted, but no paper size specified; using default") ;t             if (landscape) {-                hpapersize = defpapsiz.ysize ;f-                vpapersize = defpapsiz.xsize ;              } else {-                hpapersize = defpapsiz.xsize ;i-                vpapersize = defpapsiz.ysize ; 
             }t
          }!          hpapersize += 2368143L ;0!          vpapersize += 2368143L ; !          add_header(CROPHEADER) ;u       } "       if (paperfmt && *paperfmt) {/          for (ps = papsizes; ps; ps = ps->next) 0             if (ncstrcmp(paperfmt, ps->name)==0)                finpapsiz = ps ;e          if (finpapsiz == 0)-             error("no match for papersize") ;        } ?       if (finpapsiz == 0 && hpapersize > 0 && vpapersize > 0) { /          for (ps=papsizes; ps; ps = ps->next) {(0             if (indelta(ps->xsize-hpapersize) &&0                 indelta(ps->ysize-vpapersize)) {                landscape = 0 ;                break ;
             }i
          }          if (ps == 0) { 2             for (ps=papsizes; ps; ps = ps->next) {3                if (indelta(ps->ysize-hpapersize) &&T3                    indelta(ps->xsize-vpapersize)) {n!                   landscape = 1 ;d                   break ;e                }
             }(             if (ps == 0) {5                for (ps=papsizes; ps; ps = ps->next) { 7                   if (ps->ysize == 0 && ps->xsize == 0)d                      break ;                }                if (ps == 0) { 9                   landscape = (hpapersize > vpapersize) ;                    error(M                     "no match for special paper size found; using default") ;                 }
             } 
          }          finpapsiz = ps ;n       }        if (finpapsiz == 0) {(          if (papsizes)"             finpapsiz = papsizes ;
          elsep$             finpapsiz = &defpapsiz ; /*;  *   But change xsize/ysize to match so bounding box works.   */ (          if (hpapersize && vpapersize) {             if (landscape) {.                finpapsiz->ysize = hpapersize ;.                finpapsiz->xsize = vpapersize ;             } else {.                finpapsiz->xsize = hpapersize ;.                finpapsiz->ysize = vpapersize ;
             }c
          }       }  /*F  *   Here, there was no papersize special.  We set the paper size fromD  *   the selected paper format.  If the selected paper format has no   *   sizes, we use the defaults.  */F/       if (hpapersize == 0 || vpapersize == 0) { >          if (finpapsiz->xsize == 0 || finpapsiz->ysize == 0) {0             finpapsiz->xsize = defpapsiz.xsize ;0             finpapsiz->ysize = defpapsiz.ysize ;
          }          if (landscape) { +             vpapersize = finpapsiz->xsize ; +             hpapersize = finpapsiz->ysize ;           } else {p+             hpapersize = finpapsiz->xsize ; +             vpapersize = finpapsiz->ysize ; 
          } /*@  *   Here, there was a papersize special, but the selected paperA  *   format has 0 0 for sizes.  We set the sizes here so that the   *   bounding box works.  */ B       } else if (finpapsiz->xsize == 0 || finpapsiz->ysize == 0) {(          finpapsiz->xsize = hpapersize ;(          finpapsiz->ysize = vpapersize ; /*=  *   Here, the user specified a size with -t, and there was aO=  *   papersize special, and its sizes were greater than zero. C  *   We make sure the sizes are okay.  Note that the user must have{,  *   specified landscape if this is desired.  */x)       } else if (paperfmt && *paperfmt) {           if (landscape) { :             if (!indelta(vpapersize - finpapsiz->xsize) ||:                 !indelta(hpapersize - finpapsiz->ysize)) {3                if (vpapersize > finpapsiz->xsize ||e1                    hpapersize > finpapsiz->ysize) H                   error("warning: -t selected paper may be too small") ;                elseoE                   error("note: -t selected paper may be too large") ; 
             }r          } else { :             if (!indelta(hpapersize - finpapsiz->xsize) ||:                 !indelta(vpapersize - finpapsiz->ysize)) {3                if (hpapersize > finpapsiz->xsize ||g1                    vpapersize > finpapsiz->ysize)nH                   error("warning: -t selected paper may be too small") ;                else E                   error("note: -t selected paper may be too large") ; 
             }e
          }       }*    } }  /*B  *   Convert scaled points to PostScript points.  This is the same?  *   as return (i * 72 / (65536 * 72.27)), which is the same as 3  *   dividing by 65781.76, but we want to round up.o  */n static int topoints(i) integer i ;s {n    i += 65780L ;>    return (i / 6578176L)*100 + (i % 6578176) * 100 / 6578176 ; }  /*B  *   Send out the special paper stuff.  If `hed' is non-zero, onlyD  *   send out lines starting with `!' else send all other lines out.  */  void paperspec(s, hed)	 char *s ; 	 int hed ;t {)    int sendit ;       while (*s) {d       s++ ;        if (*s == '\0')O          return ;h       if (*s == '!') {          s++ ;           while (*s == ' ') s++ ;          sendit = hed ;        } else          sendit = ! hed ;        if (sendit) { !          while (*s && *s != '\n')v'             (void)putc(*s++, bitfile) ;)          putc('\n', bitfile) ;       } else {!          while (*s && *s != '\n')              s++ ;e       }     } }  char *epsftest() {?    if (tryepsf && totalpages == 1 && paperfmt == 0 && *iname) {        findbb() ;       return nextstring ;     }
    return 0 ;  }  static char *isepsf = 0 ;; static int endprologsent ; void initprinter(n)/ int n ; /* number of pages if greater than 0 */  {     void tell_needed_fonts() ;   %    n *= pagecopies * collatedcopies ;l    if (*oname != 0) {  /*<  *   We check to see if the first character is a exclamation  *   point, and popen if so.  */ +       if (*oname == '!' || *oname == '|') {  #ifdef MSDOS/             error("! can't open output pipe") ;  #else 
 #ifdef VMS/             error("! can't open output pipe") ;  #else  #ifdef VMCMS/             error("! can't open output pipe") ;p #elseb #ifdef MVSXA/             error("! can't open output pipe") ;  #else  #ifdef __THINK__/             error("! can't open output pipe") ;  #else  #ifdef ATARIST/             error("! can't open output pipe") ;o #else 
 #ifdef OS2#          if (_osmode != OS2_MODE) { /             error("! can't open output pipe") ;g          } else {  #endif;          if (secure || (bitfile=popen(oname+1, "w"))==NULL)i2             error("! couldn't open output pipe") ;
          else              popened = 1 ; 
 #ifdef OS2
          } #endif #endif #endif #endif #endif #endif #endif       } else {.          if ((bitfile=fopen(oname,"w"))==NULL)6             error("! couldn't open PostScript file") ;       }     } else {=       bitfile = stdout ;    }    findpapersize() ;    if (disablecomments)        (void)fprintf(bitfile,E              "%%!PS (but not EPSF; comments have been disabled)\n") ;r	    else {l       if (multiplesects)          (void)fprintf(bitfile, A              "%%!PS (but not EPSF because of memory limits)\n") ;s       else {          isepsf = epsftest() ;          if (isepsf)B             (void)fprintf(bitfile, "%%!PS-Adobe-2.0 EPSF-2.0\n") ;
          elsee9             (void)fprintf(bitfile, "%%!PS-Adobe-2.0\n") ;s       } !       if (tryepsf && isepsf == 0) 8          error("We tried, but couldn't make it EPSF.") ;=       (void)fprintf(bitfile, "%%%%Creator: %s", banner + 8) ;        if (*iname)';          (void)fprintf(bitfile, "%%%%Title: %s\n", iname) ;  #ifdef CREATIONDATE        jobtime=time(0);4       (void)fprintf(bitfile, "%%%%CreationDate: %s",@                                  asctime(localtime(&jobtime))) ; #endif       if (! isepsf) {  /*8  *   Normally, we wouldn't want to add that second field<  *   indicating that the page order is reversed, as per page<  *   644 of the Red book.  But we have to, for many existing  *   spoolers.  */iI         (void)fprintf(bitfile, "%%%%Pages: %d%s\n", (n ? n : totalpages),nI                                                     (reverse?" -1":"")) ; M         (void)fprintf(bitfile, "%%%%PageOrder: %sscend\n", reverse?"De":"A");e       }S       if (landscape) {;          fprintf(bitfile, "%%%%Orientation: Landscape\n") ; 9          fprintf(bitfile, "%%%%BoundingBox: 0 0 %d %d\n", G               topoints(finpapsiz->xsize), topoints(finpapsiz->ysize)) ;=       } else if (isepsf)<          fprintf(bitfile, "%%%%BoundingBox: %s\n", isepsf) ;
       else9          fprintf(bitfile, "%%%%BoundingBox: 0 0 %d %d\n",HG               topoints(finpapsiz->xsize), topoints(finpapsiz->ysize)) ;(       tell_needed_fonts() ; (       paperspec(finpapsiz->specdat, 1) ;3       (void)fprintf(bitfile, "%%%%EndComments\n") ;e    }    {       int i, len ;       char *p ;    /*C  *   Here, too, we have to be careful not to exceed the line length)  *   limitation, if possible.f  */"5       (void)fprintf(bitfile, "%%DVIPSCommandLine:") ;        len = 18 ;       for (i=0; i<gargc; i++) {           p = gargv[i] ;           while (*p > ' ')%             p++ ;           if (*p)             len += 2 ;&          len += strlen(gargv[i]) + 1 ;           if (len > LINELENGTH) {-             (void)fprintf(bitfile, "\n%%+") ;h(             len = strlen(gargv[i]) + 3 ;             if (*p)1                len += 2 ;f
          }E          (void)fprintf(bitfile, (*p ? " \"%s\"" : " %s"), gargv[i]) ;t       } H       (void)fprintf(bitfile, "\n%%DVIPSParameters: dpi=%d", actualdpi) ;"       if (actualdpi != vactualdpi)4          (void)fprintf(bitfile, "x%d", vactualdpi) ;       if (compressed) 1          (void)fprintf(bitfile, ", compressed") ;        if (removecomments)i7          (void)fprintf(bitfile, ", comments removed") ; "       (void)fputc('\n', bitfile) ;    }G #ifdef VMCMS  /* convert preamblecomment to ebcdic so we can read it */     {
       int i ;d,       for ( i=0 ; preamblecomment[i] ; i++ )A           preamblecomment[i] = ascii2ebcdic[preamblecomment[i]] ;     } #elsen  #ifdef MVSXA   /* IBM: MVS/XA */    {
       int i ; ,       for ( i=0 ; preamblecomment[i] ; i++ )A           preamblecomment[i] = ascii2ebcdic[preamblecomment[i]] ;r    } #endif  /* VMCMS */L #endifC    (void)fprintf(bitfile, "%%DVIPSSource: %s\n", preamblecomment) ;     linepos = 0 ;    endprologsent = 0 ;    if (safetyenclose)t=       (void)fprintf(bitfile, "/SafetyEnclosure save def\n") ;i    if (! headers_off)d       send_headers() ; }  void setup() {    newline() ;0    if (endprologsent == 0 && !disablecomments) {1       (void)fprintf(bitfile, "%%%%EndProlog\n") ; 2       (void)fprintf(bitfile, "%%%%BeginSetup\n") ;"       if (vactualdpi == actualdpi)C          (void)fprintf(bitfile, "%%%%Feature: *Resolution %ddpi\n",i7                                            actualdpi) ;c
       elseF          (void)fprintf(bitfile, "%%%%Feature: *Resolution %dx%ddpi\n",C                                            actualdpi, vactualdpi) ; 3       if (multiplesects && *(finpapsiz->specdat)) {s4          (void)fprintf(bitfile, "TeXDict begin\n") ;+          paperspec(finpapsiz->specdat, 0) ;h*          (void)fprintf(bitfile, "end\n") ;       }        if (manualfeed) D          (void)fprintf(bitfile, "%%%%Feature: *ManualFeed True\n") ;       if (multiplesects)3          (void)fprintf(bitfile, "%%%%EndSetup\n") ;l    }*    if (multiplesects && ! disablecomments)7       (void)fprintf(bitfile, "%%DVIPSBeginSection\n") ;}    cmdout("TeXDict") ;    cmdout("begin") ;@    if (endprologsent || disablecomments || multiplesects == 0) {$       (void)fprintf(bitfile, "\n") ;(       paperspec(finpapsiz->specdat, 0) ;    }*    if (manualfeed) cmdout("@manualfeed") ;(    if (landscape) cmdout("@landscape") ;    if (numcopies != 1) {"       numout((integer)numcopies) ;       cmdout("@copies") ;     }0    if (endprologsent == 0 && !disablecomments) {       newline() ;i       endprologsent = 1 ;*       if (! multiplesects)3          (void)fprintf(bitfile, "%%%%EndSetup\n") ;     } }a /*9  *   cleanprinter is the antithesis of the above routine.d  */n void cleanprinter() {c!    (void)fprintf(bitfile, "\n") ;dE    (void)fprintf(bitfile, "userdict /end-hook known{end-hook}if\n") ;(    if (safetyenclose),;       (void)fprintf(bitfile, "SafetyEnclosure restore\n") ;c    if (!disablecomments)+       (void)fprintf(bitfile, "%%%%EOF\n") ;c    if (sendcontrolD)       (void)putc(4, bitfile) ;    if (ferror(bitfile))n@       error("Problems with file writing; probably disk full.") ;
 #ifndef MSDOS  #ifndef VMS\
 #ifndef MVSXA 
 #ifndef VMCMSs #ifndef __THINK__  #ifndef ATARISTT
 #ifdef OS2    if (_osmode == OS2_MODE)  #endif       if (popened)           (void)pclose(bitfile) ; #endif #endif #endif #endif #endif #endif    if (popened == 0)       (void)fclose(bitfile) ;     bitfile = NULL ;c }[  7 /* this tells dvips that it has no clue where it is. */) static int thispage = 0 ;c static integer rulex, ruley ;) void psflush() {+    rulex = ruley = rhh = rvv = -314159265 ;n    lastfont = -1 ; }u /*/  *   pageinit initializes the output variables.   */  void
 pageinit() {     psflush() ;    newline() ;    thispage++ ;     if (!disablecomments)       if (multiplesects) #ifdef SHORTINT G          (void)fprintf(bitfile, "%%DVIPSSectionPage: %ld\n", pagenum) ;a       else if (! isepsf)J          (void)fprintf(bitfile, "%%%%Page: %ld %d\n", pagenum, thispage) ; #else F          (void)fprintf(bitfile, "%%DVIPSSectionPage: %d\n", pagenum) ;       else if (! isepsf)I          (void)fprintf(bitfile, "%%%%Page: %d %d\n", pagenum, thispage) ;) #endif    linepos = 0 ;    numout((integer)pagenum) ;      numout((integer)thispage-1) ;    cmdout("bop") ;
    d = 0 ; };       /*  *   This routine ends a page.  */n void	 pageend()s {l    if (instring) {       stringend() ;a       chrcmd('p') ;;    }    cmdout("eop") ; }(   /*5  *   drawrule draws a rule at the specified position.(:  *   It does nothing to save/restore the current position,:  *   or even draw the current string.  (Rules are normally7  *   set below the baseline anyway, so this saves us onr   *   output size almost always.)  */  void drawrule(rw, rh)         integer rw, rh ; {e    numout((integer)hh) ;    numout((integer)vv) ;"    if (rw == rulex && rh == ruley)       chrcmd('V') ;f	    else {        numout((integer)rw) ;e       numout((integer)rh) ;        chrcmd('v') ;        rulex = rw ;       ruley = rh ;    } }    /*:  *   drawchar draws a character at the specified position.  */) void drawchar(c, cc)r         chardesctype *c ;i         int cc ; {b    hvpos() ;$    if (lastfont != curfnt->psname) {$       fontout((int)curfnt->psname) ;!       lastfont = curfnt->psname ;p    }    scout(cc) ;,    rhh = hh + c->pixelwidth ; /* rvv = rv */ }; /*7  *   This routine sends out the document fonts comment.e  */  void tell_needed_fonts() {+    struct header_list *hl = ps_fonts_used ;h    char *q ;    int roomleft = -1 ;    extern char *get_name() ;      if (hl == 0)7       return ;#    while (0 != (q=get_name(&hl))) {e'       if ((int)strlen(q) >= roomleft) {;          if (roomleft != -1) {)             fprintf(bitfile, "\n%%%%+") ;.'             roomleft = LINELENGTH - 3 ;i          } else { 4             fprintf(bitfile, "%%%%DocumentFonts:") ;(             roomleft = LINELENGTH - 16 ;
          }       }("       fprintf(bitfile, " %s", q) ;!       roomleft -= strlen(q) + 1 ;     }    fprintf(bitfile, "\n") ;  }=