 /*7  * Copyright (c) 1994 Paul Vojta.  All rights reserved.   *E  * Redistribution and use in source and binary forms, with or without E  * modification, are permitted provided that the following conditions   * are met: D  * 1. Redistributions of source code must retain the above copyrightC  *    notice, this list of conditions and the following disclaimer. G  * 2. Redistributions in binary form must reproduce the above copyright I  *    notice, this list of conditions and the following disclaimer in the J  *    documentation and/or other materials provided with the distribution.  *I  * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND H  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THEM  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE J  * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLEM  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL J  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODSH  * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)M  * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT L  * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAYI  * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF   * SUCH DAMAGE.   *  * NOTE:D  *	xdvi is based on prior work, as noted in the modification history
  *	in xdvi.c.   */    #include <ctype.h> #include "xdvi.h"  #include "dvi.h"  6 #if	NeedVarargsPrototypes		/* this is for tell_oops */ #include <stdarg.h>  #else  #include <varargs.h> #endif  = #ifdef	DOPRNT	/* define this if vfprintf gives you trouble */ F #define	vfprintf(stream, message, args)	_doprnt(message, args, stream) #endif  5 static	struct frame	frame0;		/* dummy head of list */ 
 #ifdef	TEXXET > static	struct frame	*scan_frame;	/* head frame for scanning */ #endif   #ifndef	DVI_BUFFER_LEN #define	DVI_BUFFER_LEN	512 #endif  ( static	ubyte	dvi_buffer[DVI_BUFFER_LEN];# static	struct frame	*current_frame;    #ifndef	TEXXET
 #define	DIR	1  #else  #define	DIR	currinf.dir  #endif   /*)  *	Explanation of the following constant: 5  *	offset_[xy]   << 16:	margin (defaults to one inch) -  *	shrink_factor << 16:	one pixel page border /  *	shrink_factor << 15:	rounding for pixel_conv   */ = #define OFFSET_X	(offset_x << 16) + (shrink_factor * 3 << 15) = #define OFFSET_Y	(offset_y << 16) + (shrink_factor * 3 << 15)    #ifndef	BMLONG #ifndef	BMSHORT  BMUNIT	bit_masks[9] = {  	0x0,	0x1,	0x3,	0x7, 	0xf,	0x1f,	0x3f,	0x7f,  	0xff  }; #else	/* BMSHORT */  BMUNIT	bit_masks[17] = { 	0x0,	0x1,	0x3,	0x7, 	0xf,	0x1f,	0x3f,	0x7f,  	0xff,	0x1ff,	0x3ff,	0x7ff,  	0xfff,	0x1fff,	0x3fff,	0x7fff,  	0xffff  }; #endif	/* BMSHORT */ #else	/* BMLONG */ BMUNIT	bit_masks[33] = { 	0x0,		0x1,		0x3,		0x7,  	0xf,		0x1f,		0x3f,		0x7f, 	0xff,		0x1ff,		0x3ff,		0x7ff," 	0xfff,		0x1fff,		0x3fff,		0x7fff,$ 	0xffff,		0x1ffff,	0x3ffff,	0x7ffff,' 	0xfffff,	0x1fffff,	0x3fffff,	0x7fffff, + 	0xffffff,	0x1ffffff,	0x3ffffff,	0x7ffffff, / 	0xfffffff,	0x1fffffff,	0x3fffffff,	0x7fffffff,  	0xffffffff  }; #endif	/* BMLONG */   
 #ifdef	VMS #define	off_t	int  #endif extern	off_t	lseek();   D #ifndef	SEEK_SET	/* if <unistd.h> is not provided (or for <X11R5) */ #define	SEEK_SET	0 #define	SEEK_CUR	1 #define	SEEK_END	2 #endif   static	void	draw_part();   /*  *	X routines.  */    /*!  *	Put a rectangle on the screen.   */    static	void  put_rule(x, y, w, h) 	int		x, y;  	unsigned int	w, h;  { B 	if (x < max_x && x + w >= min_x && y < max_y && y + h >= min_y) {2 	    if (--event_counter == 0) read_events(False);. 	    XFillRectangle(DISP, currwin.win, ruleGC,@ 		x - currwin.base_x, y - currwin.base_y, w ? w : 1, h ? h : 1); 	} }    static	void  put_bitmap(bitmap, x, y)  	register struct bitmap *bitmap; 	register int x, y;  {    	if (debug & DBG_BITMAP)? 		Printf("X(%d,%d)\n", x - currwin.base_x, y - currwin.base_y); 1 	if (x < max_x && x + (int) bitmap->w >= min_x && 1 	    y < max_y && y + (int) bitmap->h >= min_y) { / 		if (--event_counter == 0) read_events(False);  		image->width = bitmap->w;  		image->height = bitmap->h; 		image->data = bitmap->bits; - 		image->bytes_per_line = bitmap->bytes_wide; - 		XPutImage(DISP, currwin.win, foreGC, image,  			0, 0,* 			x - currwin.base_x, y - currwin.base_y, 			bitmap->w, bitmap->h);  		if (foreGC2)2 		    XPutImage(DISP, currwin.win, foreGC2, image, 			0, 0,* 			x - currwin.base_x, y - currwin.base_y, 			bitmap->w, bitmap->h);  	} }    #ifdef	GREY  static	void  put_image(img, x, y) 	register XImage *img; 	register int x, y;  { , 	if (x < max_x && x + img->width >= min_x &&- 	    y < max_y && y + img->height >= min_y) {   3 	    if (--event_counter == 0) read_events (False);   . 	    XPutImage(DISP, currwin.win, foreGC, img, 		    0, 0, - 		    x - currwin.base_x, y - currwin.base_y, = 		    (unsigned int) img->width, (unsigned int) img->height);  	} }  #endif	/* GREY */    /*0  *	Draw the border of a rectangle on the screen.  */    void& put_border(x, y, width, height, ourGC) 	int		x, y;  	unsigned int	width, height; 	GC		ourGC;  {   	 	--width; 
 	--height;
 	/* top */: 	XFillRectangle(DISP, currwin.win, ourGC, x, y, width, 1); 	/* right */I 	XFillRectangle(DISP, currwin.win, ourGC, x + (int) width, y, 1, height); 
 	/* bottom */ B 	XFillRectangle(DISP, currwin.win, ourGC, x + 1, y + (int) height, 	    width, 1);  	/* left */ ? 	XFillRectangle(DISP, currwin.win, ourGC, x, y + 1, 1, height);  }      /*&  *	Byte reading routines for dvi file.  */   = #define	xtell(pos)	(lseek(fileno(dvi_file), 0L, SEEK_CUR) - \  			    (currinf.end - (pos)))    static	ubyte xxone()  {  	if (currinf.virtual) {  	    ++currinf.pos;  	    return EOP; 	} 	currinf.end = dvi_buffer + @ 	    read(fileno(dvi_file), (char *) (currinf.pos = dvi_buffer), 		DVI_BUFFER_LEN);: 	return currinf.end > dvi_buffer ? *(currinf.pos)++ : EOF; }   H #define	xone()  (currinf.pos < currinf.end ? *(currinf.pos)++ : xxone())   static	unsigned long
 xnum(size) 	register ubyte size;  {  	register long x = 0;   & 	while (size--) x = (x << 8) | xone();
 	return x; }    static	long  xsnum(size)  	register ubyte size;  {  	register long x;    #if	__STDC__ 	x = (signed char) xone(); #else  	x = xone(); 	if (x & 0x80) x -= 0x100; #endif& 	while (--size) x = (x << 8) | xone();
 	return x; }    #define	xsfour()	xsnum(4)    static	void 
 xskip(offset) 
 	long	offset;  {  	currinf.pos += offset; 3 	if (!currinf.virtual && currinf.pos > currinf.end) G 	    (void) lseek(fileno(dvi_file), (long) (currinf.pos - currinf.end),  		SEEK_CUR); }    #if	NeedVarargsPrototypes  static	NORETURN void% tell_oops(_Xconst char *message, ...)  #else 
 /* VARARGS */  static	NORETURN void tell_oops(va_alist)  	va_dcl  #endif {  #if	!NeedVarargsPrototypes 	_Xconst char *message;  #endif 	va_list	args;   	Fprintf(stderr, "%s: ", prog);  #if	NeedVarargsPrototypes  	va_start(args, message);  #else  	va_start(args);( 	message = va_arg(args, _Xconst char *); #endif( 	(void) vfprintf(stderr, message, args); 	va_end(args); 	if (currinf.virtual) I 	    Fprintf(stderr, " in virtual font %s\n", currinf.virtual->fontname);  	else ? 	    Fprintf(stderr, ", offset %ld\n", xtell(currinf.pos - 1));  #if	PS 	ps_destroy(); #endif	 	exit(1);  }      /*  *	Code for debugging options.  */    static	void  print_bitmap(bitmap)  	register struct bitmap *bitmap; { 0 	register BMUNIT *ptr = (BMUNIT *) bitmap->bits; 	register int x, y, i;  A 	if (ptr == NULL) oops("print_bitmap called with null pointer."); , 	Printf("w = %d, h = %d, bytes wide = %d\n",/ 	    bitmap->w, bitmap->h, bitmap->bytes_wide); ( 	for (y = 0; y < (int) bitmap->h; ++y) {A 	    for (x = bitmap->bytes_wide; x > 0; x -= BYTES_PER_BMUNIT) {  #ifndef	MSBITFIRST' 		for (i = 0; i < BITS_PER_BMUNIT; ++i)  #else , 		for (i = BITS_PER_BMUNIT - 1; i >= 0; --i) #endif- 		    Putchar((*ptr & (1 << i)) ? '@' : ' ');  		++ptr; 	    } 	    Putchar('\n');  	} }    static	void  print_char(ch, g)g
 	ubyte ch; 	struct glyph *g;g {  	Printf("char %d", ch);r 	if (isprint(ch))s 	    Printf(" (%c)", ch);h 	Putchar('\n');m? 	Printf("x = %d, y = %d, dvi = %ld\n", g->x, g->y, g->dvi_adv);  	print_bitmap(&g->bitmap); }u  % static	_Xconst	char	*dvi_table1[] = {e9 	"SET1", NULL, NULL, NULL, "SETRULE", "PUT1", NULL, NULL,o? 	NULL, "PUTRULE", "NOP", "BOP", "EOP", "PUSH", "POP", "RIGHT1",e< 	"RIGHT2", "RIGHT3", "RIGHT4", "W0", "W1", "W2", "W3", "W4",9 	"X0", "X1", "X2", "X3", "X4", "DOWN1", "DOWN2", "DOWN3",t3 	"DOWN4", "Y0", "Y1", "Y2", "Y3", "Y4", "Z0", "Z1",t 	"Z2", "Z3", "Z4"};T  % static	_Xconst	char	*dvi_table2[] = {B@ 	"FNT1", "FNT2", "FNT3", "FNT4", "XXX1", "XXX2", "XXX3", "XXX4",G 	"FNTDEF1", "FNTDEF2", "FNTDEF3", "FNTDEF4", "PRE", "POST", "POSTPOST",D+ 	"SREFL", "EREFL", NULL, NULL, NULL, NULL};S   static	void 
 print_dvi(ch) 
 	ubyte ch; {I 	_Xconst	char	*s;*  " 	Printf("%4d %4d ", PXL_H, PXL_V);& 	if (ch <= (ubyte) (SETCHAR0 + 127)) {* 	    Printf("SETCHAR%-3d", ch - SETCHAR0); 	    if (isprint(ch))E 		Printf(" (%c)", ch); 	    Putchar('\n');  	    return; 	}1 	else if (ch < FNTNUM0) s = dvi_table1[ch - 128];R) 	else if (ch <= (ubyte) (FNTNUM0 + 63)) { ( 	    Printf("FNTNUM%d\n", ch - FNTNUM0); 	    return; 	}* 	else s = dvi_table2[ch - (FNTNUM0 + 64)]; 	if (s) Puts(s); 	elseE) 	    tell_oops("unknown op-code %d", ch);  }      /*?  *	Count the number of set bits in a given region of the bitmaps  */   G char	sample_count[]	= {0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};v  
 static	int( sample(bits, bytes_wide, bit_skip, w, h) 	BMUNIT	*bits;  	int	bytes_wide, bit_skip, w, h; {g 	BMUNIT	*ptr, *endp; 	register BMUNIT *cp;i 	int	bits_left;y  	register int n, bit_shift, wid;  ) 	ptr = bits + bit_skip / BITS_PER_BMUNIT;s" 	endp = ADD(bits, h * bytes_wide); 	bits_left = w;m #ifndef	MSBITFIRST( 	bit_shift = bit_skip % BITS_PER_BMUNIT; #else/: 	bit_shift = BITS_PER_BMUNIT - bit_skip % BITS_PER_BMUNIT; #endif 	n = 0;U 	while (bits_left) { #ifndef	MSBITFIRST' 	    wid = BITS_PER_BMUNIT - bit_shift;m #elsee 	    wid = bit_shift;E #endif* 	    if (wid > bits_left) wid = bits_left; 	    if (wid > 4) wid = 4; #ifdef	MSBITFIRSTn 	    bit_shift -= wid; #endif8 	    for (cp = ptr; cp < endp; cp = ADD(cp, bytes_wide))9 		n += sample_count[(*cp >> bit_shift) & bit_masks[wid]];g #ifndef	MSBITFIRST 	    bit_shift += wid;( 	    if (bit_shift == BITS_PER_BMUNIT) { 		bit_shift = 0; 		++ptr; 	    } #elsen 	    if (bit_shift == 0) { 		bit_shift = BITS_PER_BMUNIT; 		++ptr; 	    } #endif 	    bits_left -= wid; 	}
 	return n; }    static	voide shrink_glyph(g)  	register struct glyph *g; {0' 	int		shrunk_bytes_wide, shrunk_height; ! 	int		rows_left, rows, init_cols;f 	int		cols_left; 	register int	cols;  	BMUNIT		*old_ptr, *new_ptr; 	register BMUNIT	m, *cp;@ 	int	min_sample = shrink_factor * shrink_factor * density / 100;  G 	/* These machinations ensure that the character is shrunk according tof= 	   its hot point, rather than its upper left-hand corner. */	 	g->x2 = g->x / shrink_factor;* 	init_cols = g->x - g->x2 * shrink_factor;0 	if (init_cols <= 0) init_cols += shrink_factor; 	else ++g->x2;I 	g->bitmap2.w = g->x2 + ROUNDUP((int) g->bitmap.w - g->x, shrink_factor);i9 	/* include row zero with the positively numbered rows */1/ 	cols = g->y + 1; /* spare register variable */d 	g->y2 = cols / shrink_factor;% 	rows = cols - g->y2 * shrink_factor;e 	if (rows <= 0) {P 	    rows += shrink_factor; 
 	    --g->y2;c 	}' 	g->bitmap2.h = shrunk_height = g->y2 +u: 	    ROUNDUP((int) g->bitmap.h - cols, shrink_factor) + 1; 	alloc_bitmap(&g->bitmap2);{% 	old_ptr = (BMUNIT *) g->bitmap.bits;v& 	new_ptr = (BMUNIT *) g->bitmap2.bits;+ 	shrunk_bytes_wide = g->bitmap2.bytes_wide;  	rows_left = g->bitmap.h;,< 	bzero((char *) new_ptr, shrunk_bytes_wide * shrunk_height); 	while (rows_left) {, 	    if (rows > rows_left) rows = rows_left; 	    cols_left = g->bitmap.w;" #ifndef	MSBITFIRST 	    m = (1 << 0); #elses- 	    m = ((BMUNIT) 1 << (BITS_PER_BMUNIT-1));= #endif 	    cp = new_ptr; 	    cols = init_cols; 	    while (cols_left) {) 		if (cols > cols_left) cols = cols_left;-+ 		if (sample(old_ptr, g->bitmap.bytes_wide,p- 			(int) g->bitmap.w - cols_left, cols, rows)b 			>= min_sample)m 		    *cp |= m;  #ifndef	MSBITFIRST0 		if (m == ((BMUNIT)1 << (BITS_PER_BMUNIT-1))) { 		    m = (1 << 0);n 		    ++cp;b 		}- 		else m <<= 1;  #elseo 		if (m == (1 << 0)) {. 		    m = ((BMUNIT) 1 << (BITS_PER_BMUNIT-1)); 		    ++cp;b 		}, 		else m >>= 1;_ #endif 		cols_left -= cols; 		cols = shrink_factor;  	    }0 	    *((char **) &new_ptr) += shrunk_bytes_wide;: 	    *((char **) &old_ptr) += rows * g->bitmap.bytes_wide; 	    rows_left -= rows;x 	    rows = shrink_factor; 	} 	g->y2 = g->y / shrink_factor; 	if (debug & DBG_BITMAP) 	    print_bitmap(&g->bitmap2);w }    #ifdef	GREY	 static	void	 shrink_glyph_grey(g) 	register struct glyph *g; {u! 	int		rows_left, rows, init_cols;i 	int		cols_left; 	register int	cols;R 	int		x, y;  	long		thesample;o 	BMUNIT		*old_ptr; 	unsigned int	size;d  G 	/* These machinations ensure that the character is shrunk according to,= 	   its hot point, rather than its upper left-hand corner. *// 	g->x2 = g->x / shrink_factor;* 	init_cols = g->x - g->x2 * shrink_factor;0 	if (init_cols <= 0) init_cols += shrink_factor; 	else ++g->x2;I 	g->bitmap2.w = g->x2 + ROUNDUP((int) g->bitmap.w - g->x, shrink_factor);y9 	/* include row zero with the positively numbered rows */t/ 	cols = g->y + 1; /* spare register variable */h 	g->y2 = cols / shrink_factor;% 	rows = cols - g->y2 * shrink_factor;n 	if (rows <= 0) {( 	    rows += shrink_factor;R
 	    --g->y2;( 	}H 	g->bitmap2.h = g->y2 + ROUNDUP((int) g->bitmap.h - cols, shrink_factor)	 	    + 1;r  < 	g->image2 = XCreateImage(DISP, DefaultVisualOfScreen(SCRN),/ 				 (unsigned int) DefaultDepthOfScreen(SCRN),  				 ZPixmap, 0, (char *) NULL,;  				 g->bitmap2.w, g->bitmap2.h, 				 BITS_PER_BMUNIT, 0); 1 	size = g->image2->bytes_per_line * g->bitmap2.h;*= 	g->pixmap2 = g->image2->data = xmalloc(size != 0 ? size : 1,  			"character pixmap");   % 	old_ptr = (BMUNIT *) g->bitmap.bits;- 	rows_left = g->bitmap.h;r 	y = 0;  	while (rows_left) { 	    x = 0;r, 	    if (rows > rows_left) rows = rows_left; 	    cols_left = g->bitmap.w;a 	    cols = init_cols; 	    while (cols_left) {) 		if (cols > cols_left) cols = cols_left;<  3 		thesample = sample(old_ptr, g->bitmap.bytes_wide,m. 			(int) g->bitmap.w - cols_left, cols, rows);2 		XPutPixel(g->image2, x, y, pixeltbl[thesample]);   		cols_left -= cols; 		cols = shrink_factor;  		x++; 	    }: 	    *((char **) &old_ptr) += rows * g->bitmap.bytes_wide; 	    rows_left -= rows;o 	    rows = shrink_factor;	 	    y++;( 	}  ! 	while (y < (int) g->bitmap2.h) {V- 	    for (x = 0; x < (int) g->bitmap2.w; x++)a( 		XPutPixel(g->image2, x, y, *pixeltbl);	 	    y++;p 	}   	g->y2 = g->y / shrink_factor; }_ #endif	/* GREY */n   /*  *	Find font #n.  */i   static	voido change_font(n) 	unsigned long n;  {e 	register struct tn *tnp;s  C 	if (n < currinf.tn_table_len) currinf.fontp = currinf.tn_table[n];m 	else {r 	    currinf.fontp = NULL;> 	    for (tnp = currinf.tn_head; tnp != NULL; tnp = tnp->next) 		if (tnp->TeXnumber == n) {! 		    currinf.fontp = tnp->fontp;s 		    break; 		}r 	}B 	if (currinf.fontp == NULL) tell_oops("non-existent font #%d", n);" 	maxchar = currinf.fontp->maxchar;0 	currinf.set_char_p = currinf.fontp->set_char_p; }t     /*  *	Open a font file.  */    static	voidB open_font_file(fontp)  	struct font *fontp; {  	if (fontp->file == NULL) {_6 	    fontp->file = xfopen(fontp->filename, OPEN_MODE); 	    if (fontp->file == NULL) 6 		oops("Font file disappeared:  %s", fontp->filename); 	} }(   /*  *	Read special string.r  */   
 static	char *e read_special(nbytes)
 	long	nbytes;i {e 	static	char	*spcl	= NULL; 	static	long	spcl_len = -1;e	 	char	*p;    	if (spcl_len < nbytes) {=" 	    if (spcl != NULL) free(spcl);6 	    spcl = xmalloc((unsigned) nbytes + 1, "special"); 	    spcl_len = nbytes;t 	}
 	p = spcl; 	for (;;) {g' 	    int i = currinf.end - currinf.pos;i    	    if (i > nbytes) i = nbytes;' 	    bcopy((char *) currinf.pos, p, i);r 	    currinf.pos += i; 	    p += i; 	    nbytes -= i;> 	    if (nbytes == 0) break; 	    (void) xxone(); 	    --(currinf.pos);i 	} 	*p = '\0';"
 	return spcl;L }N   #if	PS   /*<  *	Size of page interval for "Scanning pages xx-xx" message.  */,   #ifndef	REPORT_INCRI #define	REPORT_INCR	50 #endif   /*@  *	Table used for scanning.  If >= 0, then skip that many bytes.;  *	-1 means end of page, -2 means special, -3 means FNTDEF,Z=  *	-4 means unrecognizable, and -5 means doesn't belong here.   */   ' static	_Xsigned char	scantable[256] = {X5 	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,	/* chars 0 - 127 */ ! 	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"! 	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,N! 	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,_! 	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,c! 	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,_! 	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,C! 	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,R 	1,-4,			/* SET1,- (128,129) */i9 			/* -,-,SETRULE,PUT1,-,-,-,PUTRULE,NOP,BOP (130-139) */  	-4,-4,8,1,-4,-4,-4,8,0,44,hA 	-1,0,0,1,2,3,4,0,1,2,	/* EOP,PUSH,POP,RIGHT1-4,W0-2 (140-149) */T7 	3,4,0,1,2,3,4,1,2,3,	/* W3-4,X0-4,DOWN1-3 (150-159) */ 5 	4,0,1,2,3,4,0,1,2,3,	/* DOWN4,Y0-4,Z0-3 (160-169) */6 	4,			/* Z4 (170) */= 	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,	/* change font 171 - 234 */*! 	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,n! 	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, ! 	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, ) 	1,2,3,4,-2,		/* FNT1-4,XXX1 (235-239) */ 5 			/* XXX2-4,FNTDEF1-4,PRE,POST,POSTPOST (240-249) */B 	-2,-2,-2,-3,-3,-3,-3,-5,-5,-5,t6 	0,0,-4,-4,-4,-4};	/* SREFL,EREFL,-,-,-,- (250-255) */   /*B  *	Prescanning routine for dvi file.  This looks for specials like  *	`header=' and `!'.M  */s   static	voidi	 prescan()e {i 	ubyte		ch;e 	_Xsigned char	n;S	 	long		a;b 	int		nextreportpage;I 	char		scanmsg[40];/   	if (!resource._postscript) {b  	    scanned_page = total_pages; 	    return; 	} 	nextreportpage = scanned_page;T 	++scanned_page;E 	(void) lseek(fileno(dvi_file), page_offset[scanned_page], SEEK_SET);i( 	currinf.pos = currinf.end = dvi_buffer; 	for (;;) {  	    if (debug & DBG_PS)- 		Printf("Scanning page %d\n", scanned_page);p) 	    if (scanned_page > nextreportpage) {)  		nextreportpage += REPORT_INCR;$ 		if (nextreportpage > current_page)$ 		    nextreportpage = current_page;* 		Sprintf(scanmsg, "Scanning pages %d-%d",$ 		    scanned_page + pageno_correct,' 		    nextreportpage + pageno_correct);  		showmessage(scanmsg);; 		XFlush(DISP);  	    } 	    for (;;) {} 		ch = xone(); 		n = scantable[ch];
 		if (n >= 0)r 		    while (--n >= 0) 			(void) xone();b, 		else if (n == -1) break;	/* end of page */ 		else switch (n) {t 		    case -2:	/* special */ 			a = xnum(ch - XXX1 + 1);_
 			if (a > 0) % 			    scan_special(read_special(a));k	 			break;h 		    case -3:	/* FNTDEF */ ) 			xskip((long) (12 + ch - FNTDEF1 + 1));a 			ch = xone();a$ 			xskip((long) ch + (long) xone());	 			break;u# 		    case -4:	/* unrecognizable */g' 			tell_oops("unknown op-code %d", ch); 	 			break;i# 		    case -5:	/* doesn't belong */_0 			tell_oops("shouldn't happen: %s encountered",% 				dvi_table2[ch - (FNTNUM0 + 64)]); 	 			break;i 		}c 	    }- 	    if (scanned_page >= current_page) break;e 	    ++scanned_page; 	}! 	scanned_page_bak = scanned_page;  	XClearWindow(DISP, mane.win); 	psp.endheader();2 }s   #endif	/* PS */    /*   *	Routines to print characters.  */    #ifndef	TEXXET #define	ERRVAL	0Lh #elsei #define	ERRVAL #endif   #ifndef	TEXXET long set_char(ch) #else  void set_char(cmd, ch)i 	wide_ubyte	cmd; #endif 	wide_ubyte	ch;i {v 	register struct glyph *g;
 #ifdef	TEXXETs 	long	dvi_h_sav; #endif  < 	if (ch > maxchar) realloc_font(currinf.fontp, WIDENINT ch);< 	if ((g = &currinf.fontp->glyph[ch])->bitmap.bits == NULL) { 	    if (g->addr == 0) { 		if (!hush_chars)B 		    Fprintf(stderr, "Character %d not defined in font %s\n", ch, 			currinf.fontp->fontname); 		g->addr = -1;E 		return ERRVAL; 	    } 	    if (g->addr == -1)l6 		return ERRVAL;	/* previously flagged missing char */# 	    open_font_file(currinf.fontp);a, 	    Fseek(currinf.fontp->file, g->addr, 0);4 	    (*currinf.fontp->read_char)(currinf.fontp, ch);7 	    if (debug & DBG_BITMAP) print_char((ubyte) ch, g);B4 	    currinf.fontp->timestamp = ++current_timestamp; 	}  
 #ifdef	TEXXET- 	dvi_h_sav = DVI_H;e* 	if (currinf.dir < 0) DVI_H -= g->dvi_adv; 	if (scan_frame == NULL) { #endif 	    if (shrink_factor == 1)5 		put_bitmap(&g->bitmap, PXL_H - g->x, PXL_V - g->y);t 	    else {  #ifdef	GREY* 		if (use_grey) {u 		    if (g->pixmap2 == NULL) {& 			shrink_glyph_grey(g); 		    }w9 		    put_image(g->image2, PXL_H - g->x2, PXL_V - g->y2); 
 		} else {$ 		    if (g->bitmap2.bits == NULL) { 			shrink_glyph(g);t 		    }g< 		    put_bitmap(&g->bitmap2, PXL_H - g->x2, PXL_V - g->y2); 		}) #elses  		if (g->bitmap2.bits == NULL) { 		    shrink_glyph(g); 		}i8 		put_bitmap(&g->bitmap2, PXL_H - g->x2, PXL_V - g->y2); #endif 	    } #ifndef	TEXXET 	return g->dvi_adv;d #else  	} 	if (cmd == PUT1)r 	    DVI_H = dvi_h_sav;h 	elsec. 	    if (currinf.dir > 0) DVI_H += g->dvi_adv; #endif }a     /* ARGSUSED */ #if	NeedFunctionPrototypes #ifndef	TEXXET static	longh set_empty_char(wide_ubyte ch)  #else_ static	voidk- set_empty_char(wide_ubyte cmd, wide_ubyte ch)  #endif	/* TEXXET */t# #else	/* !NeedFunctionPrototypes */n #ifndef	TEXXET static	longi set_empty_char(ch) #elsel static	void  set_empty_char(cmd, ch)e 	wide_ubyte	cmd; #endif	/* TEXXET */r 	wide_ubyte	ch;2# #endif	/* NeedFunctionPrototypes */( {  #ifndef	TEXXET
 	return 0; #elseg 	return; #endif }p     #ifndef	TEXXET long load_n_set_char(ch)  #elsef void load_n_set_char(cmd, ch) 	wide_ubyte	cmd; #endif 	wide_ubyte	ch;( {N3 	if (load_font(currinf.fontp)) {	/* if not found */ 9 	    Fputs("Character(s) will be left blank.\n", stderr);mE 	    currinf.set_char_p = currinf.fontp->set_char_p = set_empty_char;  #ifndef	TEXXET 	    return 0; #else- 	    return; #endif 	}" 	maxchar = currinf.fontp->maxchar;0 	currinf.set_char_p = currinf.fontp->set_char_p; #ifndef	TEXXET" 	return (*currinf.set_char_p)(ch); #else   	(*currinf.set_char_p)(cmd, ch); 	return; #endif }      #ifndef	TEXXET long set_vf_char(ch)  #elsel void set_vf_char(cmd, ch) 	wide_ubyte	cmd; #endif 	wide_ubyte	ch;< {  	register struct macro *m; 	struct drawinf	oldinfo; 	ubyte	oldmaxchar; 	static	ubyte	c;
 #ifdef	TEXXETt 	long	dvi_h_sav; #endif  ; 	if (ch > maxchar) realloc_virtual_font(currinf.fontp, ch);t4 	if ((m = &currinf.fontp->macro[ch])->pos == NULL) { 	    if (!hush_chars)d> 		Fprintf(stderr, "Character %d not defined in font %s\n", ch, 		    currinf.fontp->fontname);b 	    m->pos = m->end = &c; 	    return ERRVAL;p 	}
 #ifdef	TEXXETi 	dvi_h_sav = DVI_H;** 	if (currinf.dir < 0) DVI_H -= m->dvi_adv; 	if (scan_frame == NULL) { #endif 	    oldinfo = currinf;# 	    oldmaxchar = maxchar; 	    WW = XX = YY = ZZ = 0;n' 	    currinf.tn_table_len = VFTABLELEN; 0 	    currinf.tn_table = currinf.fontp->vf_table;/ 	    currinf.tn_head = currinf.fontp->vf_chain;L 	    currinf.pos = m->pos; 	    currinf.end = m->end;% 	    currinf.virtual = currinf.fontp;{6 	    draw_part(current_frame, currinf.fontp->dimconv);( 	    if (currinf.pos != currinf.end + 1)> 		tell_oops("virtual character macro does not end correctly"); 	    currinf = oldinfo;  	    maxchar = oldmaxchar; #ifndef	TEXXET 	return m->dvi_adv;  #elset 	} 	if (cmd == PUT1)e 	    DVI_H = dvi_h_sav;o 	else . 	    if (currinf.dir > 0) DVI_H += m->dvi_adv; #endif }o     #if	NeedFunctionPrototypes #ifndef	TEXXET static	long	 set_no_char(wide_ubyte ch) #elsef static	voide* set_no_char(wide_ubyte cmd, wide_ubyte ch) #endif	/* TEXXET */e# #else	/* !NeedFunctionPrototypes */i #ifndef	TEXXET static	longL set_no_char(ch)s #else  static	void	 set_no_char(cmd, ch)
 	ubyte			cmd;  #endif	/* TEXXET */f 	wide_ubyte	ch;s# #endif	/* NeedFunctionPrototypes */" {c 	if (currinf.virtual) {b1 	    currinf.fontp = currinf.virtual->first_font;c! 	    if (currinf.fontp != NULL) {i# 		maxchar = currinf.fontp->maxchar;y1 		currinf.set_char_p = currinf.fontp->set_char_p;  #ifndef	TEXXET# 		return (*currinf.set_char_p)(ch);  #elser! 		(*currinf.set_char_p)(cmd, ch);(	 		return;) #endif 	    } 	}7 	tell_oops("attempt to set character of unknown font");e 	/* NOTREACHED */p }s     /*=  *	Set rule.  Arguments are coordinates of lower left corner.   */f   static	voide set_rule(h, w)
 	int h, w; {h #ifndef	TEXXETD 	put_rule(PXL_H, PXL_V - h + 1, (unsigned int) w, (unsigned int) h); #else ? 	put_rule(PXL_H - (currinf.dir < 0 ? w - 1 : 0), PXL_V - h + 1, ) 	    (unsigned int) w, (unsigned int) h);0 #endif }0  6 #define	xspell_conv(n)	spell_conv0(n, current_dimconv)   static	void0$ draw_part(minframe, current_dimconv) 	struct frame	*minframe; 	double		current_dimconv;0 {0
 	ubyte ch;
 #ifdef	TEXXET0 	struct drawinf	oldinfo; 	ubyte	oldmaxchar; 	off_t	file_pos; 	int	refl_count; #endif   	currinf.fontp = NULL;" 	currinf.set_char_p = set_no_char;
 #ifdef	TEXXETN 	currinf.dir = 1; 6 	scan_frame = NULL;	/* indicates we're not scanning */ #endif 	for (;;) {- 	    ch = xone();T 	    if (debug & DBG_DVI)W 		print_dvi(ch);( 	    if (ch <= (ubyte) (SETCHAR0 + 127)) #ifndef	TEXXET% 		DVI_H += (*currinf.set_char_p)(ch);0 #else0  		(*currinf.set_char_p)(ch, ch); #endif< 	    else if (FNTNUM0 <= ch && ch <= (ubyte) (FNTNUM0 + 63)). 		change_font((unsigned long) (ch - FNTNUM0)); 	    else {4 		long a, b;   		switch (ch) {  		    case SET1: 		    case PUT1: #ifndef	TEXXET% 			a = (*currinf.set_char_p)(xone());  			if (ch != PUT1) DVI_H += a; #else,% 			(*currinf.set_char_p)(ch, xone());u #endif	 			break;    		    case SETRULE: , 			/* Be careful, dvicopy outputs rules with- 			   height = 0x80000000.  We don't want anyh 			   SIGFPE here. */t 			a = xsfour(); 			b = xspell_conv(xsfour());! #ifndef	TEXXET 			if (a > 0 && b > 0) #elseo, 			if (a > 0 && b > 0 && scan_frame == NULL) #endif, 			    set_rule(pixel_round(xspell_conv(a)), 				pixel_round(b)); 			DVI_H += DIR * b;	 			break;c   		    case PUTRULE:d 			a = xspell_conv(xsfour());  			b = xspell_conv(xsfour());f #ifndef	TEXXET 			if (a > 0 && b > 0) #else , 			if (a > 0 && b > 0 && scan_frame == NULL) #endif0 			    set_rule(pixel_round(a), pixel_round(b));	 			break;e   		    case NOP:e	 			break;	   		    case BOP:c 			xskip((long) 11 * 4); 			DVI_H = OFFSET_X; 			DVI_V = OFFSET_Y; 			PXL_V = pixel_conv(DVI_V);  			WW = XX = YY = ZZ = 0;		 			break;)   		    case EOP:r! 			if (current_frame != minframe)n+ 			    tell_oops("stack not empty at EOP");>
 			return;   		    case PUSH:% 			if (current_frame->next == NULL) { , 			    struct frame *newp = (struct frame *)1 				xmalloc(sizeof(struct frame), "stack frame"); " 			    current_frame->next = newp;" 			    newp->prev = current_frame; 			    newp->next = NULL;1 			}' 			current_frame = current_frame->next;x& 			current_frame->data = currinf.data;	 			break;    		    case POP:n! 			if (current_frame == minframe)p* 			    tell_oops("more POPs than PUSHes");& 			currinf.data = current_frame->data;' 			current_frame = current_frame->prev;_	 			break;   
 #ifdef	TEXXET  		    case SREFL:  			if (scan_frame == NULL) {1 			    /* we're not scanning:  save some info. */  			    oldinfo = currinf;_ 			    oldmaxchar = maxchar; 			    if (!currinf.virtual)" 				file_pos = xtell(currinf.pos);; 			    scan_frame = current_frame; /* now we're scanning */R 			    refl_count = 0;
 			    break;f 			} 			/* we are scanning */1 			if (current_frame == scan_frame) ++refl_count;t	 			break;d   		    case EREFL: 4 			if (scan_frame != NULL) {	/* if we're scanning */; 			    if (current_frame == scan_frame && --refl_count < 0). 			    {' 				/* we've hit the end of our scan */p 				scan_frame = NULL; 				/* first:  push */& 				if (current_frame->next == NULL) {- 				    struct frame *newp = (struct frame *)s" 					xmalloc(sizeof(struct frame), 					    "stack frame");# 				    current_frame->next = newp;r# 				    newp->prev = current_frame;s 				    newp->next = NULL; 				}e( 				current_frame = current_frame->next;' 				current_frame->data = currinf.data;c4 				/* next:  restore old file position, XX, etc. */ 				if (!currinf.virtual) {a* 				    off_t bgn_pos = xtell(dvi_buffer);  " 				    if (file_pos >= bgn_pos) { 					oldinfo.pos = dvi_bufferH  					    + (file_pos - bgn_pos); 					oldinfo.end = currinf.end;N	 				    }d 				    else {- 					(void) lseek(fileno(dvi_file), file_pos,H 					    SEEK_SET);) 					oldinfo.pos = oldinfo.end;		 				    }y 				}	 				currinf = oldinfo; 				maxchar = oldmaxchar;y+ 				/* and then:  recover position info. */L& 				DVI_H = current_frame->data.dvi_h;& 				DVI_V = current_frame->data.dvi_v;& 				PXL_V = current_frame->data.pxl_v;( 				/* and finally, reverse direction */ 				currinf.dir = -currinf.dir;- 			    }
 			    break;  			} 			/* we're not scanning, *// 			/* so just reverse direction and then pop */; 			currinf.dir = -currinf.dir;& 			currinf.data = current_frame->data;' 			current_frame = current_frame->prev; 	 			break;  #endif	/* TEXXET */    		    case RIGHT1: 		    case RIGHT2: 		    case RIGHT3: 		    case RIGHT4:6 			DVI_H += DIR * xspell_conv(xsnum(ch - RIGHT1 + 1));	 			break;_   		    case W1: 		    case W2: 		    case W3: 		    case W4:$ 			WW = xspell_conv(xsnum(ch - W0)); 		    case W0: 			DVI_H += DIR * WW;t	 			break;e   		    case X1: 		    case X2: 		    case X3: 		    case X4:$ 			XX = xspell_conv(xsnum(ch - X0)); 		    case X0: 			DVI_H += DIR * XX;i	 			break;s   		    case DOWN1:X 		    case DOWN2:s 		    case DOWN3:f 		    case DOWN4:E/ 			DVI_V += xspell_conv(xsnum(ch - DOWN1 + 1));o 			PXL_V = pixel_conv(DVI_V);b	 			break;e   		    case Y1: 		    case Y2: 		    case Y3: 		    case Y4:$ 			YY = xspell_conv(xsnum(ch - Y0)); 		    case Y0: 			DVI_V += YY;) 			PXL_V = pixel_conv(DVI_V);u	 			break;-   		    case Z1: 		    case Z2: 		    case Z3: 		    case Z4:$ 			ZZ = xspell_conv(xsnum(ch - Z0)); 		    case Z0: 			DVI_V += ZZ;r 			PXL_V = pixel_conv(DVI_V);-	 			break;;   		    case FNT1: 		    case FNT2: 		    case FNT3: 		    case FNT4:$ 			change_font(xnum(ch - FNT1 + 1));	 			break;i   		    case XXX1: 		    case XXX2: 		    case XXX3: 		    case XXX4: 			a = xnum(ch - XXX1 + 1);d
 			if (a > 0) - 			    applicationDoSpecial(read_special(a));l	 			break;y   		    case FNTDEF1:	 		    case FNTDEF2:E 		    case FNTDEF3:  		    case FNTDEF4:a) 			xskip((long) (12 + ch - FNTDEF1 + 1));c( 			xskip((long) xone() + (long) xone());	 			break;L   #ifndef	TEXXET 		    case SREFL:t 		    case EREFL:r #endif 		    case PRE:s 		    case POST: 		    case POSTPOST:0 			tell_oops("shouldn't happen: %s encountered",% 				dvi_table2[ch - (FNTNUM0 + 64)]);I	 			break;c   		    default:' 			tell_oops("unknown op-code %d", ch);L 		} /* end switch*/d2 	    } /* end else (ch not a SETCHAR or FNTNUM) */ 	} /* end for */ }n   #undef	xspell_conv   void draw_page()  { % 	/* Check for changes in dvi file. */a 	if (!check_dvi_file()) return;i   #if	PS, 	if (scanned_page < current_page) prescan(); #endif  - 	put_border(-currwin.base_x, -currwin.base_y,p2 	    ROUNDUP(unshrunk_paper_w, shrink_factor) + 2,; 	    ROUNDUP(unshrunk_paper_h, shrink_factor) + 2, highGC);(  E 	(void) lseek(fileno(dvi_file), page_offset[current_page], SEEK_SET);o  5 	bzero((char *) &currinf.data, sizeof(currinf.data));-# 	currinf.tn_table_len = TNTABLELEN;U 	currinf.tn_table = tn_table;  	currinf.tn_head = tn_head;>( 	currinf.pos = currinf.end = dvi_buffer; 	currinf.virtual = NULL; 	psfig_begun = False;c- 	draw_part(current_frame = &frame0, dimconv);t #if	PS 	psp.endpage();e #endif } 