 /*7  * Copyright (c) 1994 Paul Vojta.  All rights reserved.   *E  * Redistribution and use in source and binary forms, with or without E  * modification, are permitted provided that the following conditions   * are met: D  * 1. Redistributions of source code must retain the above copyrightC  *    notice, this list of conditions and the following disclaimer. G  * 2. Redistributions in binary form must reproduce the above copyright I  *    notice, this list of conditions and the following disclaimer in the J  *    documentation and/or other materials provided with the distribution.  *I  * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND H  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THEM  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE J  * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLEM  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL J  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODSH  * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)M  * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT L  * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAYI  * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF   * SUCH DAMAGE.   *  * NOTE:D  *	xdvi is based on prior work, as noted in the modification history
  *	in xdvi.c.   */    #include "xdvi.h"  #include "dvi.h" #include <sys/stat.h>    #ifdef	X_NOT_STDC_ENV  char	*realloc(); #endif  C #if	defined(macII) && !__STDC__	/* stdlib.h doesn't define these */  char	*realloc(); #endif /* macII */   #define	PK_PRE		247  #define	PK_ID		89 & #define	PK_MAGIC	(PK_PRE << 8) + PK_ID #define	GF_PRE		247  #define	GF_ID		131& #define	GF_MAGIC	(GF_PRE << 8) + GF_ID #define	VF_PRE		247  #define	VF_ID_BYTE	202+ #define	VF_MAGIC	(VF_PRE << 8) + VF_ID_BYTE   A #define	dvi_oops(str)	(dvi_oops_msg = (str), longjmp(dvi_env, 1))    static	struct stat fstatbuf;   static	Boolean	font_not_found;   /**  * DVI preamble and postamble information.  */  static	char	job_id[300];# static	long	numerator, denominator;    /*<  * Offset in DVI file of last page, set in read_postamble().  */  static	long	last_page_offset;      /*.  *	free_vf_chain frees the vf_chain structure.  */    static	void  free_vf_chain(tnp) 	struct tn *tnp; {  	while (tnp != NULL) {* 	    register struct tn *tnp1 = tnp->next; 	    free((char *) tnp); 	    tnp = tnp1; 	} }      /*.  *	Release all shrunken bitmaps for all fonts.  */    void
 reset_fonts()  {  	register struct font *f;  	register struct glyph *g;  , 	for (f = font_head; f != NULL; f = f->next)@ 	    if ((f->flags & FONT_LOADED) && !(f->flags & FONT_VIRTUAL))7 		for (g = f->glyph; g <= f->glyph + f->maxchar; ++g) {  		    if (g->bitmap2.bits) { 			free(g->bitmap2.bits);  			g->bitmap2.bits = NULL; 		    }  #ifdef	GREY  		    if (g->pixmap2) {  			XDestroyImage(g->image2); 			g->pixmap2 = NULL;  		    }  #endif 		}  }    /*E  *	realloc_font allocates the font structure to contain (newsize + 1)   *	characters.  */    void realloc_font(fontp, newsize) 	struct font	*fontp; 	wide_ubyte	newsize; {  	struct glyph *glyph;   G 	glyph = fontp->glyph = (struct glyph *) realloc((char *) fontp->glyph, : 	    ((unsigned int) newsize + 1) * sizeof(struct glyph));G 	if (glyph == NULL) oops("! Cannot reallocate space for glyph array.");  	if (newsize > fontp->maxchar)1 	    bzero((char *) (glyph + fontp->maxchar + 1), ; 		(int) (newsize - fontp->maxchar) * sizeof(struct glyph)); $ 	maxchar = fontp->maxchar = newsize; }      /*>  *	realloc_virtual_font does the same thing for virtual fonts.  */    void$ realloc_virtual_font(fontp, newsize) 	struct font	*fontp; 	wide_ubyte	newsize; {  	struct macro *macro;   G 	macro = fontp->macro = (struct macro *) realloc((char *) fontp->macro, : 	    ((unsigned int) newsize + 1) * sizeof(struct macro));G 	if (macro == NULL) oops("! Cannot reallocate space for macro array.");  	if (newsize > fontp->maxchar)1 	    bzero((char *) (macro + fontp->maxchar + 1), ; 		(int) (newsize - fontp->maxchar) * sizeof(struct macro)); $ 	maxchar = fontp->maxchar = newsize; }      /*G  *	load_font locates the raster file and reads the index of characters, G  *	plus whatever other preprocessing is done (depending on the format).   */    Boolean  load_font(fontp) 	struct font *fontp; {  	double	fsize	= fontp->fsize;  	int	dpi	= fsize + 0.5;  	char	*font_found; 	int	size_found; 	int	magic;  	Boolean	hushcs	= hush_chk;    	fontp->flags |= FONT_LOADED; 6 	fontp->file = font_open(fontp->fontname, &font_found,> 	    fsize, &size_found, fontp->magstepval, &fontp->filename); 	if (fontp->file == NULL) { I 	    Fprintf(stderr, "%s: can't find font %s.\n", prog, fontp->fontname);  	    return True;  	} 	--n_files_left; 	if (font_found != NULL) { 	    Fprintf(stderr,> 		    "%s: can't find font %s; using %s instead at %d dpi.\n",. 		    prog, fontp->fontname, font_found, dpi); 	    free(fontp->fontname); " 	    fontp->fontname = font_found; 	    hushcs = True;  	}5 	else if (size_found > (int) (1.002 * fsize + 0.5) || + 		size_found < (int) (0.998 * fsize + 0.5))  	    Fprintf(stderr,> 		"%s: can't find font %s at %d dpi; using %d dpi instead.\n",* 		prog, fontp->fontname, dpi, size_found); 	fontp->fsize = size_found; ( 	fontp->timestamp = ++current_timestamp;  	fontp->maxchar = maxchar = 255; 	fontp->set_char_p = set_char; 	magic = two(fontp->file);
 #ifdef	USE_PK > 	if (magic == PK_MAGIC) read_PK_index(fontp, WIDENINT hushcs); 	else  #endif
 #ifdef	USE_GF B 	    if (magic == GF_MAGIC) read_GF_index(fontp, WIDENINT hushcs); 	else  #endifB 	    if (magic == VF_MAGIC) read_VF_index(fontp, WIDENINT hushcs); 	else G 	    oops("Cannot recognize format for font file %s", fontp->filename);   # 	if (fontp->flags & FONT_VIRTUAL) { H 	    while (maxchar > 0 && fontp->macro[maxchar].pos == NULL) --maxchar; 	    if (maxchar < 255) 0 		realloc_virtual_font(fontp, WIDENINT maxchar); 	} 	else { F 	    while (maxchar > 0 && fontp->glyph[maxchar].addr == 0) --maxchar; 	    if (maxchar < 255) ( 		realloc_font(fontp, WIDENINT maxchar); 	} 	return False; }      /*C  *	MAGSTEPVALUE - If the given magnification is close to a \magstep @  *	or a \magstephalf, then return twice the number of \magsteps.  *	Otherwise return NOMAGSTP.   */    #define	NOMAGSTP (-29999)  #define	NOBUILD	29999   
 static	int magstepvalue(mag)  	float	*mag; {  	int	m	= 0;  	double	fmag	= *mag; 	double	xmag	= pixels_per_inch;  	float	margin	= fmag * 0.002;    	if (fmag < pixels_per_inch) 	    for (;;) { 8 		if (xmag - fmag < margin && -(xmag - fmag) < margin) { 		    *mag = xmag; 		    return m;  		}  		if (xmag < fmag) break;  		xmag *= 0.9128709292;  		--m; 	    } 	else  	    for (;;) { 8 		if (xmag - fmag < margin && -(xmag - fmag) < margin) { 		    *mag = xmag; 		    return m;  		}  		if (xmag > fmag) break;  		xmag *= 1.095445115; 		++m; 	    } 	return NOMAGSTP;  }      /*J  *	reuse_font recursively sets the flags for font structures being reused.  */    static	void  reuse_font(fontp)  	struct font *fontp; {  	struct font **fp; 	struct tn *tnp;  ( 	if (fontp->flags & FONT_IN_USE) return;   	fontp->flags |= FONT_IN_USE;  	if (list_fonts)8 	    Printf("(reusing) %s at %d dpi\n", fontp->fontname, 		(int) (fontp->fsize + 0.5));# 	if (fontp->flags & FONT_VIRTUAL) { H 	    for (fp = fontp->vf_table; fp < fontp->vf_table + VFTABLELEN; ++fp)# 		if (*fp != NULL) reuse_font(*fp); > 	    for (tnp = fontp->vf_chain; tnp != NULL; tnp = tnp->next) 		reuse_font(tnp->fontp);  	} }      /*J  *      define_font reads the rest of the fntdef command and then reads inM  *      the specified pixel file, adding it to the global linked-list holding )  *      all of the fonts used in the job.   */ 
 struct font * C define_font(file, cmnd, vfparent, tntable, tn_table_len, tn_headpp) 
 	FILE		*file;  	wide_ubyte	cmnd; = 	struct font	*vfparent;	/* vf parent of this font, or NULL */*6 	struct font	**tntable;	/* table for low TeXnumbers */@ 	unsigned int	tn_table_len;	/* length of table for TeXnumbers */@ 	struct tn	**tn_headpp;	/* addr of head of list of TeXnumbers */ {i 	int	TeXnumber;* 	struct font *fontp;
 	float	fsize;s 	double	scale_dimconv; 	long	checksum;t 	int	scale;e 	int	design; 	int	magstepval;	 	int	len;  	char	*fontname;
 	int	size;  1 	TeXnumber = num(file, (int) cmnd - FNTDEF1 + 1);h 	checksum = four(file);s 	scale = four(file); 	design = four(file);iF 	len = one(file); len += one(file); /* sequence point in the middle */5 	fontname = xmalloc((unsigned) len + 1, "font name");H* 	Fread(fontname, sizeof(char), len, file); 	fontname[len] = '\0'; 	if(debug & DBG_PK)N6 	    Printf("Define font \"%s\" scale=%d design=%d\n", 		fontname, scale, design);U 	if (vfparent == NULL) {F 	    fsize = 0.001 * scale / design * magnification * pixels_per_inch; 	    scale_dimconv = dimconv;, 	} 	else {M 	    /* G 	     *	The scaled size is given in units of vfparent->scale * 2 ** -20 H 	     *	SPELL units, so we convert it into SPELL units by multiplying by 	     *		vfparent->dimconv.CG 	     *	The design size is given in units of 2 ** -20 pt, so we convertA* 	     *	into SPELL units by multiplying by5 	     *		(pixels_per_inch * 2**16) / (72.27 * 2**20).O 	     */C 	    fsize = (72.27 * (1<<4)) * vfparent->dimconv * scale / design; ' 	    scale_dimconv = vfparent->dimconv;i 	}# 	magstepval = magstepvalue(&fsize);  	size = fsize + 0.5; 	/*  	 * reuse font if possible 	 */0 	for (fontp = font_head;; fontp = fontp->next) {: 	    if (fontp == NULL) {		/* if font doesn't exist yet */ 		if (list_fonts)*> 		    Printf("%s at %d dpi\n", fontname, (int) (fsize + 0.5));A 		fontp = (struct font *) xmalloc((unsigned) sizeof(struct font),n 		    "font structure"); 		fontp->fontname = fontname;P 		fontp->fsize = fsize;	! 		fontp->magstepval = magstepval;29 		fontp->file = NULL;	/* needed if it's a virtual font */v 		fontp->checksum = checksum;r 		fontp->flags = FONT_IN_USE;t3 		fontp->dimconv = scale * scale_dimconv / (1<<20);o& 		fontp->set_char_p = load_n_set_char;; 		if (vfparent == NULL) font_not_found |= load_font(fontp);u 		fontp->next = font_head; 		font_head = fontp; 		break; 	    }/ 	    if (strcmp(fontname, fontp->fontname) == 0g. 		    && size == (int) (fontp->fsize + 0.5)) { 			/* if font already in use */c 		reuse_font(fontp); 		free(fontname);n 		break; 	    } 	} 	if (TeXnumber < tn_table_len)  	    tntable[TeXnumber] = fontp; 	else {p 	    register struct tn *tnp; > 	    tnp = (struct tn *) xmalloc((unsigned) sizeof(struct tn), 		"TeXnumber structure");g 	    tnp->next = *tn_headpp; 	    *tn_headpp = tnp;  	    tnp->TeXnumber = TeXnumber; 	    tnp->fontp = fontp; 	} 	return fontp; }!     /*I  *      process_preamble reads the information in the preamble and stores /  *      it into global variables for later use.2  */) static	voidm process_preamble() {  	ubyte   k;E   	if (one(dvi_file) != PRE) 		dvi_oops("Not a DVI file");	 	if (one(dvi_file) != 2); 		dvi_oops("Wrong version of DVI output for this program");o  	numerator     = four(dvi_file);  	denominator   = four(dvi_file);  	magnification = four(dvi_file);0 	dimconv = (((double) numerator * magnification)$ 		/ ((double) denominator * 1000.));= 	dimconv = dimconv * (((long) pixels_per_inch)<<16) / 254000;(9 	tpic_conv = pixels_per_inch * magnification / 1000000.0;g 	k = one(dvi_file); 0 	Fread(job_id, sizeof(char), (int) k, dvi_file); 	job_id[k] = '\0'; }a   /*=  *      find_postamble locates the beginning of the postamblei?  *	and leaves the file ready to start reading at that location.>  */aA #define	TMPSIZ	516	/* 4 trailer bytes + 512 junk bytes allowed */n static	void  find_postamble() { 
 	long	pos; 	ubyte	temp[TMPSIZ];
 	ubyte	*p; 	ubyte	*p1;  	ubyte	byte;   	Fseek(dvi_file, (long) 0, 2);  	pos = ftell(dvi_file) - TMPSIZ; 	if (pos < 0) pos = 0; 	Fseek(dvi_file, pos, 0);uA 	p = temp + fread((char *) temp, sizeof(char), TMPSIZ, dvi_file);U 	for (;;) {a 	    p1 = p;. 	    while (p1 > temp && *(--p1) != TRAILER) ; 	    p = p1;, 	    while (p > temp && *(--p) == TRAILER) ;8 	    if (p <= p1 - 4) break;	/* found 4 TRAILER bytes */3 	    if (p <= temp) dvi_oops("DVI file corrupted");  	} 	pos += p - temp;t 	byte = *p;  	while (byte == TRAILER) { 	    Fseek(dvi_file, --pos, 0);h 	    byte = one(dvi_file); 	} 	if (byte != 2))> 	    dvi_oops("Wrong version of DVI output for this program"); 	Fseek(dvi_file, pos - 4, 0); % 	Fseek(dvi_file, sfour(dvi_file), 0);_ }n     /*>  *      read_postamble reads the information in the postamble,$  *	storing it into global variables.M  *      It also takes care of reading in all of the pixel files for the fontsa  *      used in the job.  */i static	voide read_postamble() {r 	ubyte   cmnd; 	struct font	*fontp; 	struct font	**fontpp;   	if (one(dvi_file) != POST)-3 	    dvi_oops("Postamble doesn't begin with POST");n# 	last_page_offset = four(dvi_file);t  	if (numerator != four(dvi_file)" 		|| denominator != four(dvi_file)% 		|| magnification != four(dvi_file))m2 	    dvi_oops("Postamble doesn't match preamble");) 		/* read largest box height and width */)B 	unshrunk_page_h = (spell_conv(sfour(dvi_file)) >> 16) + offset_y;( 	if (unshrunk_page_h < unshrunk_paper_h)( 	    unshrunk_page_h = unshrunk_paper_h;B 	unshrunk_page_w = (spell_conv(sfour(dvi_file)) >> 16) + offset_x;( 	if (unshrunk_page_w < unshrunk_paper_w)( 	    unshrunk_page_w = unshrunk_paper_w;+ 	(void) two(dvi_file);	/* max stack size */= 	total_pages = two(dvi_file);P 	font_not_found = False;= 	while ((cmnd = one(dvi_file)) >= FNTDEF1 && cmnd <= FNTDEF4)f= 	    (void) define_font(dvi_file, cmnd, (struct font *) NULL,N" 		tn_table, TNTABLELEN, &tn_head); 	if (cmnd != POSTPOST)7 	    dvi_oops("Non-fntdef command found in postamble");C 	if (font_not_found)0 	    dvi_oops("Not all pixel files were found"); 	/*l" 	 * free up fonts no longer in use 	 */ 	fontpp = &font_head;a" 	while ((fontp = *fontpp) != NULL)$ 	    if (fontp->flags & FONT_IN_USE) 		fontpp = &fontp->next; 	    else {e 		if (debug & DBG_PK)c2 		    Printf("Discarding font \"%s\" at %d dpi\n",0 			fontp->fontname, (int) (fontp->fsize + 0.5));0 		*fontpp = fontp->next;		/* remove from list */ 		free(fontp->fontname);# 		if (fontp->flags & FONT_LOADED) {\  		    if (fontp->file != NULL) { 			Fclose(fontp->file);r 			++n_files_left; 		    }r 		    free(fontp->filename);( 		    if (fontp->flags & FONT_VIRTUAL) { 			register struct macro *m;   			for (m = fontp->macro;i, 				m <= fontp->macro + fontp->maxchar; ++m)- 			    if (m->free_me) free((char *) m->pos);0 			free((char *) fontp->macro);c" 			free((char *) fontp->vf_table);" 			free_vf_chain(fontp->vf_chain); 		    }	 		    else { 			register struct glyph *g;   			for (g = fontp->glyph;m. 				g <= fontp->glyph + fontp->maxchar; ++g) {8 			    if (g->bitmap.bits != NULL) free(g->bitmap.bits);: 			    if (g->bitmap2.bits != NULL) free(g->bitmap2.bits); #ifdef	GREYf8 			    if (g->pixmap2 != NULL) XDestroyImage(g->image2); #endif 			} 			free((char *) fontp->glyph);s 		    }s 		    free((char *) fontp);s 		}g 	    } }*   static	voidi prepare_pages()n {  	int i;   F 	page_offset = (long *) xmalloc((unsigned) total_pages * sizeof(long), 	    "page directory");  	i = total_pages;F% 	page_offset[--i] = last_page_offset;i& 	Fseek(dvi_file, last_page_offset, 0); 	/*m7 	 * Follow back pointers through pages in the DVI file,O1 	 * storing the offsets in the page_offset table.< 	 */ 	while (i > 0) {, 	    Fseek(dvi_file, (long) (1+4+(9*4)), 1);; 	    Fseek(dvi_file, page_offset[--i] = four(dvi_file), 0);- 	} }    void init_page()t { : 	page_w = ROUNDUP(unshrunk_page_w, mane.shrinkfactor) + 2;: 	page_h = ROUNDUP(unshrunk_page_h, mane.shrinkfactor) + 2; }i   #ifndef	S_ISDIRe. #define	S_ISDIR(m)	(((m) & S_IFMT) == S_IFDIR) #endif   /*?  *	init_dvi_file is the main subroutine for reading the startupt;  *	information from the dvi file.  Returns True on success.b  */m   static	Boolean init_dvi_file()  {e+ 	(void) fstat(fileno(dvi_file), &fstatbuf);t 	if (S_ISDIR(fstatbuf.st_mode))r 	    return False; 	dvi_time = fstatbuf.st_mtime; 	process_preamble(); 	find_postamble(); 	read_postamble(); 	prepare_pages(); 
 	init_page();XA 	if (current_page >= total_pages) current_page = total_pages - 1;n 	hush_spec_now = hush_spec;a #if	PS
 	ps_newdoc();t #endif
 	return True;  }c   /**nA  **	open_dvi_file opens the dvi file and calls init_dvi_file() to   **	initialize it.  **/   void open_dvi_file(); {d 	int	n;o 	char	*file;  ) 	if (setjmp(dvi_env)) oops(dvi_oops_msg);    	n = strlen(dvi_name); 	file = dvi_name;u   	/*)B 	 * Try foo.dvi before foo, in case there's an executable foo with? 	 * documentation foo.tex.  Unless it already ends with ".dvi".n 	 */ 	if (n < sizeof(".dvi")d> 		|| strcmp(dvi_name + n - sizeof(".dvi") + 1, ".dvi") != 0) {H 	    dvi_name = xmalloc((unsigned) n + sizeof(".dvi"), "dvi file name"); 	    Strcpy(dvi_name, file); 	    Strcat(dvi_name, ".dvi");+ 	    dvi_file = fopen(dvi_name, OPEN_MODE);s- 	    if (dvi_file != NULL && init_dvi_file())n	 		return;o 	    free(dvi_name); 	    dvi_name = file;r 	}  G 	/* Then try `foo', in case the user likes DVI files without `.dvi'. */ 4 	if ((dvi_file = fopen(dvi_name, OPEN_MODE)) == NULL 		|| !init_dvi_file()) { 	    perror(dvi_name); #if	PS 	    ps_destroy(); #endif
 	    exit(1);a 	} }i   /** "  **	Check for changes in dvi file.  **/   Booleano check_dvi_file() {  	struct font *fontp;  @ 	if (dvi_file == NULL || fstat(fileno(dvi_file), &fstatbuf) != 0( 	    || fstatbuf.st_mtime != dvi_time) { 		if (dvi_file) {p 		    Fclose(dvi_file);o$ 		    if (list_fonts) Putchar('\n'); 		}  		free((char *) page_offset);n3 		bzero((char *) tn_table, (int) sizeof(tn_table));  		free_vf_chain(tn_head);t 		tn_head = NULL; = 		for (fontp = font_head; fontp != NULL; fontp = fontp->next)i# 		    fontp->flags &= ~FONT_IN_USE;a5 		if ((dvi_file = fopen(dvi_name, OPEN_MODE)) == NULLi 			|| !init_dvi_file())c* 		    dvi_oops("Cannot reopen dvi file.");
 		reconfig();t 		redraw_page(); 		return False;/ 	}
 	return True;- }t