 /*7  * Copyright (c) 1994 Paul Vojta.  All rights reserved.   *E  * Redistribution and use in source and binary forms, with or without E  * modification, are permitted provided that the following conditions   * are met: D  * 1. Redistributions of source code must retain the above copyrightC  *    notice, this list of conditions and the following disclaimer. G  * 2. Redistributions in binary form must reproduce the above copyright I  *    notice, this list of conditions and the following disclaimer in the J  *    documentation and/or other materials provided with the distribution.  *I  * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND H  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THEM  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE J  * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLEM  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL J  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODSH  * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)M  * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT L  * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAYI  * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF   * SUCH DAMAGE.   *  * NOTE:D  *	xdvi is based on prior work, as noted in the modification history
  *	in xdvi.c.   */    #include <ctype.h> #include "xdvi.h"   ) /* Xlib and Xutil are already included */  #ifdef	TOOLKIT #ifdef	OLD_X11_TOOLKIT #include <X11/Atoms.h> #else /* not OLD_X11_TOOLKIT */  #include <X11/Xatom.h> #include <X11/StringDefs.h>   #endif /* not OLD_X11_TOOLKIT */8 #include <X11/Shell.h>	/* needed for def. of XtNiconX */ #ifndef	XtSpecificationRelease  #define	XtSpecificationRelease	0 #endif #if	XtSpecificationRelease >= 4  #include <X11/Xaw/Viewport.h>  #ifdef	BUTTONS #include <X11/Xaw/Command.h> #endif& #else	/* XtSpecificationRelease < 4 */ #define	XtPointer caddr_t  #include <X11/Viewport.h>  #ifdef	BUTTONS #include <X11/Command.h> #endif# #endif	/* XtSpecificationRelease */  #else	/* !TOOLKIT */ typedef	int		Position;" #define	XtPending()	XPending(DISP) #endif	/* TOOLKIT */  
 #if	HAS_SIGIO  #include <signal.h>  #ifndef	FASYNC #undef	HAS_SIGIO #define	HAS_SIGIO 0  #endif #endif   #ifndef	X11HEIGHT 7 #define	X11HEIGHT	8	/* Height of server default font */  #endif  1 #define	MAGBORD	1	/* border size for magnifier */    /*  * Command line flags.  */   ' #define	fore_Pixel	resource._fore_Pixel ' #define	back_Pixel	resource._back_Pixel  #ifdef	TOOLKIT! extern	struct _resource	resource; ' #define	brdr_Pixel	resource._brdr_Pixel  #endif	/* TOOLKIT */   #define	clip_w	mane.width  #define	clip_h	mane.height static	Position main_x, main_y; 3 static	Position mag_x, mag_y, new_mag_x, new_mag_y; ! static	Boolean	mag_moved = False;    #ifdef	TOOLKIT #ifdef	BUTTONS( static	Widget	line_widget, panel_widget; #endifE static	Widget	x_bar, y_bar;	/* horizontal and vertical scroll bars */    static	Arg	resize_args[] = { 	{XtNwidth,	(XtArgVal) 0}, 	{XtNheight,	(XtArgVal) 0},  };  ( #define	XdviResizeWidget(widget, w, h)	\+ 		(resize_args[0].value = (XtArgVal) (w), \ * 		resize_args[1].value = (XtArgVal) (h), \; 		XtSetValues(widget, resize_args, XtNumber(resize_args)) )    #ifdef	BUTTONS   static	Arg	resizable_on[] = { ! 	{XtNresizable,	(XtArgVal) True},  };   static	Arg	resizable_off[] = {" 	{XtNresizable,	(XtArgVal) False}, };   static	Arg	line_args[] = { 	{XtNbackground,	(XtArgVal) 0},  	{XtNwidth,	(XtArgVal) 1}, 	{XtNheight,	(XtArgVal) 0}, ! 	{XtNfromHoriz,	(XtArgVal) NULL},   	{XtNborderWidth, (XtArgVal) 0},! 	{XtNtop,	(XtArgVal) XtChainTop}, ' 	{XtNbottom,	(XtArgVal) XtChainBottom}, $ 	{XtNleft,	(XtArgVal) XtChainRight},% 	{XtNright,	(XtArgVal) XtChainRight},  };   static	Arg	panel_args[] = { ! 	{XtNfromHoriz,	(XtArgVal) NULL}, ' 	{XtNwidth,	(XtArgVal) (XTRA_WID - 1)},  	{XtNheight,	(XtArgVal) 0},   	{XtNborderWidth, (XtArgVal) 0},! 	{XtNtop,	(XtArgVal) XtChainTop}, ' 	{XtNbottom,	(XtArgVal) XtChainBottom}, $ 	{XtNleft,	(XtArgVal) XtChainRight},% 	{XtNright,	(XtArgVal) XtChainRight},  };   static	struct {  	_Xconst	char	*label;  	_Xconst	char	*name;
 	int	closure;  	int	y_pos;  	} 	command_table[] = { 		{"Quit",	"quit",		'q',		50},) 		{"Shrink1",	"sh1",		1 << 8 | 's',	150}, ) 		{"Shrink2",	"sh2",		2 << 8 | 's',	200}, ) 		{"Shrink3",	"sh3",		3 << 8 | 's',	250}, ) 		{"Shrink4",	"sh4",		4 << 8 | 's',	300}, , 		{"Page-10",	"prev10",	10 << 8 | 'p',	400},) 		{"Page-5",	"prev5",	5 << 8 | 'p',	450},  		{"Prev",	"prev",		'p',		500},  		{"Next",	"next",		'n',		600}, ) 		{"Page+5",	"next5",	5 << 8 | 'n',	650}, , 		{"Page+10",	"next10",	10 << 8 | 'n',	700}, #if	PS' 		{"View PS",	"postscript",	'v',		750},  #endif };   static	void	handle_command();   ' static	XtCallbackRec	command_call[] = {  	{handle_command, NULL}, 	{NULL,		NULL},  };   static	Arg	command_args[] = {  	{XtNlabel,	(XtArgVal) NULL},  	{XtNx,		(XtArgVal) 6},  	{XtNy,		(XtArgVal) 0},  	{XtNwidth,	(XtArgVal) 64},  	{XtNheight,	(XtArgVal) 30},( 	{XtNcallback,	(XtArgVal) command_call}, };   void create_buttons(h)  	XtArgVal	h; {  	int i;   4 	line_args[0].value = (XtArgVal) resource._hl_Pixel; 	line_args[2].value = h;. 	line_args[3].value = (XtArgVal) vport_widget;F 	line_widget = XtCreateManagedWidget("line", widgetClass, form_widget," 		line_args, XtNumber(line_args));. 	panel_args[0].value = (XtArgVal) line_widget; 	panel_args[2].value = h; D 	panel_widget = XtCreateManagedWidget("panel", compositeWidgetClass,1 		form_widget, panel_args, XtNumber(panel_args));   1 	command_args[2].value = (XtArgVal) vport_widget; 0 	for (i = 0; i < XtNumber(command_table); ++i) {? 	    command_args[0].value = (XtArgVal) command_table[i].label; ? 	    command_args[2].value = (XtArgVal) command_table[i].y_pos; E 	    command_call[0].closure = (XtPointer) &command_table[i].closure; 8 	    (void) XtCreateManagedWidget(command_table[i].name,# 		commandWidgetClass, panel_widget, ( 		command_args, XtNumber(command_args)); 	} }  #endif	/* BUTTONS */   #else	/* !TOOLKIT */ static	Window	x_bar, y_bar; @ static	int	x_bgn, x_end, y_bgn, y_end;	/* scrollbar positions */ #endif	/* TOOLKIT */   /*F  *	Mechanism to keep track of the magnifier window.  The problems are,F  *	(a) if the button is released while the window is being drawn, thisB  *	could cause an X error if we continue drawing in it after it is  *	destroyed, and I  *	(b) creating and destroying the window too quickly confuses the window B  *	manager, which is avoided by waiting for an expose event before  *	destroying it.   */ 1 static	short	alt_stat;	/* 1 = wait for expose, */ " 				/* -1 = destroy upon expose */8 static	Boolean	alt_canit;	/* stop drawing this window */   /*  *	Data for buffered events.  */   & static	VOLATILE short	event_freq	= 70;  ) static	void	can_exposures(), keystroke();    #ifdef	GREY  #define	gamma	resource._gamma    void init_pix(warn) 	Boolean	warn; { % 	static	int	shrink_allocated_for = 0;  	static	float	oldgamma	= 0.0;  	int	i;    	if (gamma != oldgamma) { ! 	    static Pixel plane_masks[4];  	    static Pixel pixel; 	    XColor color, fc, bc; 	    XGCValues	values;   	    if (!copy) @ 		/* allocate 4 color planes for 16 colors (for GXor drawing) */0 		if (oldgamma == 0.0 && !XAllocColorCells(DISP,8 			DefaultColormapOfScreen(SCRN), False, plane_masks, 4, 			&pixel, 1)) 		    copy = warn = True;   E 	    /* get foreground and background RGB values for interpolating */  	    fc.pixel = fore_Pixel; ; 	    XQueryColor(DISP, DefaultColormapOfScreen(SCRN), &fc);  	    bc.pixel = back_Pixel; ; 	    XQueryColor(DISP, DefaultColormapOfScreen(SCRN), &bc);    	    for (i = 0; i < 16; ++i) {  		double	pow(); ; 		double	frac = gamma > 0 ? pow((double) i / 15, 1 / gamma) 0 		    : 1 - pow((double) (15 - i) / 15, -gamma);  9 		color.red = frac * ((double) fc.red - bc.red) + bc.red; A 		color.green = frac * ((double) fc.green - bc.green) + bc.green; = 		color.blue = frac * ((double) fc.blue - bc.blue) + bc.blue;    		color.pixel = pixel;) 		color.flags = DoRed | DoGreen | DoBlue;i   		if (!copy) {/ 		    if (i & 1) color.pixel |= plane_masks[0];e/ 		    if (i & 2) color.pixel |= plane_masks[1];*/ 		    if (i & 4) color.pixel |= plane_masks[2];e/ 		    if (i & 8) color.pixel |= plane_masks[3];i? 		    XStoreColor(DISP, DefaultColormapOfScreen(SCRN), &color);n 		    palette[i] = color.pixel;  		}i 		else {; 		    if (!XAllocColor(DISP, DefaultColormapOfScreen(SCRN),r 			&color)) ) 			palette[i] = (i * 100 >= density * 15)i! 			    ? fore_Pixel : back_Pixel;T
 		    else 			palette[i] = color.pixel; 		}R 	    }  C 	    /* Make sure fore_ and back_Pixel are a part of the palette */T 	    fore_Pixel = palette[15]; 	    back_Pixel = palette[0];F  	    if (mane.win != (Window) 0)3 		XSetWindowBackground(DISP, mane.win, palette[0]);O  J #define	MakeGC(fcn, fg, bg)	(values.function = fcn, values.foreground=fg,\ 		values.background=bg,\, 		XCreateGC(DISP, RootWindowOfScreen(SCRN),\2 			GCFunction|GCForeground|GCBackground, &values))  3 	    foreGC = ruleGC = MakeGC(copy ? GXcopy : GXor,W 		fore_Pixel, back_Pixel); 	    foreGC2 = NULL;   	    oldgamma = gamma;0 	    if (resource.copy == Maybe && copy && warn)9 		Puts("Note:  overstrike characters may be incorrect.");E 	}
 #undef	MakeGCF  $ 	if (mane.shrinkfactor == 1) return;  0 	if (shrink_allocated_for < mane.shrinkfactor) {3 	    if (pixeltbl != NULL) free((char *) pixeltbl); , 	    pixeltbl = (Pixel *) xmalloc((unsigned)> 		(mane.shrinkfactor * mane.shrinkfactor + 1) * sizeof(Pixel), 		"pixel table");i. 	    shrink_allocated_for = mane.shrinkfactor; 	}  = 	for (i = 0; i <= mane.shrinkfactor * mane.shrinkfactor; ++i)/ 	    pixeltbl[i] =: 		palette[(i * 30 + mane.shrinkfactor * mane.shrinkfactor)5 		    / (2 * mane.shrinkfactor * mane.shrinkfactor)];t }R #endif	/* GREY */i   /*  *	Event-handling routines  */e   static	voido expose(windowrec, x, y, w, h)e& 	register struct WindowRec *windowrec; 	int		x, y;n 	unsigned int	w, h;n {t0 	if (windowrec->min_x > x) windowrec->min_x = x; 	if (windowrec->max_x < x + w) 	    windowrec->max_x = x + w;0 	if (windowrec->min_y > y) windowrec->min_y = y; 	if (windowrec->max_y < y + h) 	    windowrec->max_y = y + h; }I   static	void_" clearexpose(windowrec, x, y, w, h) 	struct WindowRec *windowrec;f 	int		x, y;  	unsigned int	w, h;  {n5 	XClearArea(DISP, windowrec->win, x, y, w, h, False);  	expose(windowrec, x, y, w, h);n }A   static	voide scrollwindow(windowrec, x0, y0)*& 	register struct WindowRec *windowrec; 	int	x0, y0; {.
 	int	x, y; 	int	x2 = 0, y2 = 0; 	int	ww, hh;   	x = x0 - windowrec->base_x; 	y = y0 - windowrec->base_y; 	ww = windowrec->width - x;d 	hh = windowrec->height - y; 	windowrec->base_x = x0; 	windowrec->base_y = y0;% 	if (currwin.win == windowrec->win) {  	    currwin.base_x = x0;g 	    currwin.base_y = y0;  	} 	windowrec->min_x -= x;l0 	if (windowrec->min_x < 0) windowrec->min_x = 0; 	windowrec->max_x -= x;d) 	if (windowrec->max_x > windowrec->width)*) 	    windowrec->max_x = windowrec->width;  	windowrec->min_y -= y;=0 	if (windowrec->min_y < 0) windowrec->min_y = 0; 	windowrec->max_y -= y;	* 	if (windowrec->max_y > windowrec->height)* 	    windowrec->max_y = windowrec->height;
 	if (x < 0) {=
 	    x2 = -x;, 	    x = 0;l  	    ww = windowrec->width - x2; 	}
 	if (y < 0) { 
 	    y2 = -y;  	    y = 0;r! 	    hh = windowrec->height - y2;	 	} 	if (ww <= 0 || hh <= 0) {( 	    XClearWindow(DISP, windowrec->win);- 	    windowrec->min_x = windowrec->min_y = 0;]) 	    windowrec->max_x = windowrec->width;t* 	    windowrec->max_y = windowrec->height; 	} 	else {t4 	    XCopyArea(DISP, windowrec->win, windowrec->win,  		DefaultGCOfScreen(SCRN), x, y,0 		(unsigned int) ww, (unsigned int) hh, x2, y2); 	    if (x > 0)( 		clearexpose(windowrec, ww, 0,g+ 		    (unsigned int) x, windowrec->height);A 	    if (x2 > 0) 		clearexpose(windowrec, 0, 0,, 		    (unsigned int) x2, windowrec->height); 	    if (y > 0)( 		clearexpose(windowrec, 0, hh, * 		    windowrec->width, (unsigned int) y); 	    if (y2 > 0) 		clearexpose(windowrec, 0, 0,+ 		    windowrec->width, (unsigned int) y2);g 	} }A   #ifdef	TOOLKIT /*  *	routines for X11 toolkitc  */c   static	Arg	arg_wh[] = {	" 	{XtNwidth,	(XtArgVal) &window_w},# 	{XtNheight,	(XtArgVal) &window_h},, };  # static	Position	window_x, window_y;	 static	Arg	arg_xy[] = {" 	{XtNx,		(XtArgVal) &window_x},0 	{XtNy,		(XtArgVal) &window_y},8 };  C #define	get_xy()	XtGetValues(draw_widget, arg_xy, XtNumber(arg_xy))p   #define	mane_base_x	00 #define	mane_base_y	0"   static	void	
 home(scrl) 	Boolean	scrl; {, #if	PS 	psp.interrupt();, #endif) 	if (!scrl) XUnmapWindow(DISP, mane.win);	
 	get_xy(); 	if (x_bar != NULL) {<0 	    register int coord = (page_w - clip_w) / 2;, 	    if (coord > home_x / mane.shrinkfactor)% 		coord = home_x / mane.shrinkfactor;c* 	    XtCallCallbacks(x_bar, XtNscrollProc," 		(XtPointer) (window_x + coord)); 	} 	if (y_bar != NULL) {t0 	    register int coord = (page_h - clip_h) / 2;, 	    if (coord > home_y / mane.shrinkfactor)% 		coord = home_y / mane.shrinkfactor;0* 	    XtCallCallbacks(y_bar, XtNscrollProc," 		(XtPointer) (window_y + coord)); 	}
 	if (!scrl) {t  	    XMapWindow(DISP, mane.win);E 	    /* Wait for the server to catch up---this eliminates flicker. */u 	    XSync(DISP, False); 	} }n   static	Boolean	resized	= False;i   static	voids
 get_geom() { ) 	static	Dimension	new_clip_w, new_clip_h;a 	static	Arg	arg_wh_clip[] = {w% 		{XtNwidth,	(XtArgVal) &new_clip_w},n& 		{XtNheight,	(XtArgVal) &new_clip_h}, 	};m 	register int	old_clip_w;w  5 	XtGetValues(vport_widget, arg_wh, XtNumber(arg_wh));g> 	XtGetValues(clip_widget, arg_wh_clip, XtNumber(arg_wh_clip));8 	/* Note:  widgets may be destroyed but not forgotten */$ 	x_bar = page_w <= new_clip_w ? NULL2 	    : XtNameToWidget(vport_widget, "horizontal");$ 	y_bar = page_h <= new_clip_h ? NULL0 	    : XtNameToWidget(vport_widget, "vertical"); 	old_clip_w = clip_w;d# 			/* we need to do this because */W) 			/* sizeof(Dimension) != sizeof(int) */  	clip_w = new_clip_w;; 	clip_h = new_clip_h;T" 	if (old_clip_w == 0) home(False); 	resized = False;b }    static	voidb center(x, y)
 	int x, y; {cF /*	We use the clip widget here because it gives a more exact value. */ 	x -= clip_w/2;f 	y -= clip_h/2;pA 	if (x_bar) XtCallCallbacks(x_bar, XtNscrollProc, (XtPointer) x);bA 	if (y_bar) XtCallCallbacks(y_bar, XtNscrollProc, (XtPointer) y);i4 	XWarpPointer(DISP, None, None, 0, 0, 0, 0, -x, -y); }    /*  *	callback routines  */   
 	/*ARGSUSED*/o void( handle_resize(widget, junk, event, cont) 	Widget	widget;e 	XtPointer junk; 	XEvent	*event;t 	Boolean	*cont;		/* unused */f {e 	resized = True; }    #ifdef	BUTTONS
 	/*ARGSUSED*/B static	voidn0 handle_command(widget, client_data_p, call_data) 	Widget	widget;t 	XtPointer client_data_p;  	XtPointer call_data;  {t+ 	int	client_data	= * (int *) client_data_p;i  4 	keystroke((client_data) & 0xff, (client_data) >> 8,. 		((client_data) >> 8) != 0, (XEvent *) NULL); }a #endif	/* BUTTONS */   void
 reconfig() {0 #ifdef	BUTTONSC 	XtSetValues(vport_widget, resizable_off, XtNumber(resizable_off));  #endif/ 	XdviResizeWidget(draw_widget, page_w, page_h);C 	get_geom(); }    #else	/* !TOOLKIT */   /*!  *	brute force scrollbar routines   */d   static	voidf
 paint_x_bar(). {&8 	register int	new_x_bgn = mane.base_x * clip_w / page_w;C 	register int	new_x_end = (mane.base_x + clip_w) * clip_w / page_w;   A 	if (new_x_bgn >= x_end || x_bgn >= new_x_end) {	/* no overlap */*F 	    XClearArea(DISP, x_bar, x_bgn, 1, x_end - x_bgn, BAR_WID, False);( 	    XFillRectangle(DISP, x_bar, ruleGC,0 		new_x_bgn, 1, new_x_end - new_x_bgn, BAR_WID); 	}( 	else {		/* this stuff avoids flicker */ 	    if (x_bgn < new_x_bgn) 6 		XClearArea(DISP, x_bar, x_bgn, 1, new_x_bgn - x_bgn, 		    BAR_WID, False);	 	    else5% 		XFillRectangle(DISP, x_bar, ruleGC,r0 		    new_x_bgn, 1, x_bgn - new_x_bgn, BAR_WID); 	    if (new_x_end < x_end).: 		XClearArea(DISP, x_bar, new_x_end, 1, x_end - new_x_end, 		    BAR_WID, False);	 	    else % 		XFillRectangle(DISP, x_bar, ruleGC, , 		    x_end, 1, new_x_end - x_end, BAR_WID); 	} 	x_bgn = new_x_bgn;p 	x_end = new_x_end;] }    static	void)
 paint_y_bar()  {n8 	register int	new_y_bgn = mane.base_y * clip_h / page_h;C 	register int	new_y_end = (mane.base_y + clip_h) * clip_h / page_h;o  A 	if (new_y_bgn >= y_end || y_bgn >= new_y_end) {	/* no overlap */=F 	    XClearArea(DISP, y_bar, 1, y_bgn, BAR_WID, y_end - y_bgn, False);( 	    XFillRectangle(DISP, y_bar, ruleGC,0 		1, new_y_bgn, BAR_WID, new_y_end - new_y_bgn); 	}( 	else {		/* this stuff avoids flicker */ 	    if (y_bgn < new_y_bgn) ? 		XClearArea(DISP, y_bar, 1, y_bgn, BAR_WID, new_y_bgn - y_bgn,l
 		    False);f	 	    else % 		XFillRectangle(DISP, y_bar, ruleGC,[0 		    1, new_y_bgn, BAR_WID, y_bgn - new_y_bgn); 	    if (new_y_end < y_end)p' 		XClearArea(DISP, y_bar, 1, new_y_end,g) 		    BAR_WID, y_end - new_y_end, False);=	 	    elseu% 		XFillRectangle(DISP, y_bar, ruleGC,o, 		    1, y_end, BAR_WID, new_y_end - y_end); 	} 	y_bgn = new_y_bgn;u 	y_end = new_y_end;  }e   static	voidy scrollmane(x, y)
 	int	x, y; { ' 	register int	old_base_x = mane.base_x; ' 	register int	old_base_y = mane.base_y;y   #if	PS 	psp.interrupt();	 #endif6 	if (x > (int) (page_w - clip_w)) x = page_w - clip_w; 	if (x < 0) x = 0;6 	if (y > (int) (page_h - clip_h)) y = page_h - clip_h; 	if (y < 0) y = 0; 	scrollwindow(&mane, x, y);=7 	if (old_base_x != mane.base_x && x_bar) paint_x_bar();*7 	if (old_base_y != mane.base_y && y_bar) paint_y_bar();a }r   void
 reconfig() {  	int	x_thick = 0;  	int	y_thick = 0;e  ) 		/* determine existence of scrollbars */;, 	if (window_w < page_w) x_thick = BAR_THICK;6 	if (window_h - x_thick < page_h) y_thick = BAR_THICK; 	clip_w = window_w - y_thick;	* 	if (clip_w < page_w) x_thick = BAR_THICK; 	clip_h = window_h - x_thick;i  % 		/* process drawing (clip) window */ 5 	if (mane.win == (Window) 0) {	/* initial creation */e 	    XWindowAttributes attrs;   F 	    mane.win = XCreateSimpleWindow(DISP, top_level, y_thick, x_thick,3 			(unsigned int) clip_w, (unsigned int) clip_h, 0,w 			brdr_Pixel, back_Pixel); 0 	    XSelectInput(DISP, mane.win, ExposureMask |; 			ButtonPressMask | ButtonMotionMask | ButtonReleaseMask);I9 	    (void) XGetWindowAttributes(DISP, mane.win, &attrs);c) 	    backing_store = attrs.backing_store;s  	    XMapWindow(DISP, mane.win); 	} 	elsewI 	    XMoveResizeWindow(DISP, mane.win, y_thick, x_thick, clip_w, clip_h);t   		/* process scroll bars */c 	if (x_thick) {s 	    if (x_bar) {c  		XMoveResizeWindow(DISP, x_bar,. 		    y_thick - 1, -1, clip_w, BAR_THICK - 1); 		paint_x_bar(); 	    } 	    else { ? 		x_bar = XCreateSimpleWindow(DISP, top_level, y_thick - 1, -1,-, 				(unsigned int) clip_w, BAR_THICK - 1, 1, 				brdr_Pixel, back_Pixel); 		XSelectInput(DISP, x_bar, 7 			ExposureMask | ButtonPressMask | Button2MotionMask);} 		XMapWindow(DISP, x_bar); 	    }+ 	    x_bgn = mane.base_x * clip_w / page_w;n6 	    x_end = (mane.base_x + clip_w) * clip_w / page_w; 	} 	else  	    if (x_bar) {  		XDestroyWindow(DISP, x_bar); 		x_bar = (Window) 0;n 	    }   	if (y_thick) {c 	    if (y_bar) {o  		XMoveResizeWindow(DISP, y_bar,. 		    -1, x_thick - 1, BAR_THICK - 1, clip_h); 		paint_y_bar(); 	    } 	    else {=? 		y_bar = XCreateSimpleWindow(DISP, top_level, -1, x_thick - 1, , 				BAR_THICK - 1, (unsigned int) clip_h, 1, 				brdr_Pixel, back_Pixel); 		XSelectInput(DISP, y_bar, 7 			ExposureMask | ButtonPressMask | Button2MotionMask);  		XMapWindow(DISP, y_bar); 	    }+ 	    y_bgn = mane.base_y * clip_h / page_h;d6 	    y_end = (mane.base_y + clip_h) * clip_h / page_h; 	} 	else  	    if (y_bar) {n 		XDestroyWindow(DISP, y_bar); 		y_bar = (Window) 0;, 	    } }u   static	void,
 home(scrl) 	Boolean	scrl; {  	int	x = 0, y = 0;   	if (page_w > clip_w) {g 	    x = (page_w - clip_w) / 2;e( 	    if (x > home_x / mane.shrinkfactor)! 		x = home_x / mane.shrinkfactor;e 	} 	if (page_h > clip_h) {; 	    y = (page_h - clip_h) / 2;(( 	    if (y > home_y / mane.shrinkfactor)! 		y = home_y / mane.shrinkfactor;  	}
 	if (scrl) 	    scrollmane(x, y); 	else {e 	    mane.base_x = x;) 	    mane.base_y = y;f# 	    if (currwin.win == mane.win) {l 		currwin.base_x = x;g 		currwin.base_y = y;d 	    } 	    if (x_bar) paint_x_bar(); 	    if (y_bar) paint_y_bar(); 	} }P   #define	get_xy() #define	window_x 0 #define	window_y 0 #define	mane_base_x	mane.base_xt #define	mane_base_y	mane.base_y  #endif	/* TOOLKIT */   static	voidi compute_mag_pos(xp, yp)g 	int	*xp, *yp; {a 	register int t;  " 	t = mag_x + main_x - alt.width/2;; 	if (t > WidthOfScreen(SCRN) - (int) alt.width - 2*MAGBORD)d; 	    t = WidthOfScreen(SCRN) - (int) alt.width - 2*MAGBORD;i 	if (t < 0) t = 0;	 	*xp = t;s# 	t = mag_y + main_y - alt.height/2;;= 	if (t > HeightOfScreen(SCRN) - (int) alt.height - 2*MAGBORD)x= 	    t = HeightOfScreen(SCRN) - (int) alt.height - 2*MAGBORD;o 	if (t < 0) t = 0;	 	*yp = t;o })     #define	TRSIZE	100   #ifdef	TOOLKIT
 	/*ARGSUSED*/  void& handle_key(widget, junk, eventp, cont) 	Widget	widget;c 	XtPointer junk; 	XEvent	*eventp; 	Boolean	*cont;		/* unused */y #else	/* !TOOLKIT */ void handle_key(eventp) 	XEvent *eventp; #endif	/* TOOLKIT */ {o! 	static	Boolean	has_arg		= False;r 	static	int	number		= 0; 	static	int	sign		= 1;	 	char	ch;X 	Boolean	arg0;
 	int	number0;t 	char	trbuf[TRSIZE]; 	int	nbytes;  F 	nbytes = XLookupString(&eventp->xkey, trbuf, TRSIZE, (KeySym *) NULL, 	    (XComposeStatus *) NULL); 	if (nbytes == 0) return;c 	ch = '\0';X 	if (nbytes == 1) ch = *trbuf; 	if (ch >= '0' && ch <= '9') { 	    has_arg = True;. 	    number = number * 10 + sign * (ch - '0'); 	    return; 	} 	else if (ch == '-') { 	    has_arg = True; 	    sign = -1;b 	    number = 0; 	    return; 	} 	number0 = number; 	number = 0;
 	sign = 1; 	arg0 = has_arg; 	has_arg = False;"& 	keystroke(ch, number0, arg0, eventp); }    #ifdef	TOOLKIT
 	/*ARGSUSED*/  void% handle_button(widget, junk, ev, cont)e 	Widget	widget;b 	XtPointer junk; 	XEvent *ev; #define	event	(&(ev->xbutton)) 	Boolean	*cont;		/* unused */l #else	/* !TOOLKIT */ void handle_button(event) 	XButtonEvent *event;t #endif	/* TOOLKIT */ {i
 	int	x, y;< 	struct mg_size_rec	*size_ptr = mg_size + event->button - 1; 	XSetWindowAttributes attr;   I 	if (alt.win != (Window) 0 || mane.shrinkfactor == 1 || size_ptr->w <= 0)r 	    XBell(DISP, 20);a 	else {k 	    mag_x = event->x; 	    mag_y = event->y; 	    alt.width = size_ptr->w;  	    alt.height = size_ptr->h;$ 	    main_x = event->x_root - mag_x;$ 	    main_y = event->y_root - mag_y; 	    compute_mag_pos(&x, &y);X@ 	    alt.base_x = (event->x + mane_base_x) * mane.shrinkfactor - 		alt.width/2;@ 	    alt.base_y = (event->y + mane_base_y) * mane.shrinkfactor - 		alt.height/2;i 	    attr.save_under = True;$ 	    attr.border_pixel = brdr_Pixel;( 	    attr.background_pixel = back_Pixel;# 	    attr.override_redirect = True;k< 	    alt.win = XCreateWindow(DISP, RootWindowOfScreen(SCRN),( 			x, y, alt.width, alt.height, MAGBORD, 			0,	/* depth from parent */e* 			InputOutput, (Visual *) CopyFromParent,. 			CWSaveUnder | CWBorderPixel | CWBackPixel | 			CWOverrideRedirect, &attr);/ 	    XSelectInput(DISP, alt.win, ExposureMask);  	    XMapWindow(DISP, alt.win);*- 	    alt_stat = 1;	/* waiting for exposure */c 	} }    #ifdef	TOOLKIT #undef	event  
 	/*ARGSUSED*/e void% handle_motion(widget, junk, ev, cont)_ 	Widget	widget;e 	XtPointer junk; 	XEvent *ev; #define	event	(&(ev->xmotion)) 	Boolean	*cont;		/* unused */l {* 	new_mag_x = event->x;$ 	main_x = event->x_root - new_mag_x; 	new_mag_y = event->y;$ 	main_y = event->y_root - new_mag_y;8 	mag_moved = (new_mag_x != mag_x || new_mag_y != mag_y); }h   #undef	event #endif	/* TOOLKIT */   static	voidn
 movemag(x, y)a
 	int	x, y; {_ 	int	xx, yy;   	mag_x = x;	 	mag_y = y;FA 	if (mag_x == new_mag_x && mag_y == new_mag_y) mag_moved = False;e 	compute_mag_pos(&xx, &yy);,$ 	XMoveWindow(DISP, alt.win, xx, yy); 	scrollwindow(&alt,,? 	    (x + mane_base_x) * mane.shrinkfactor - (int) alt.width/2, A 	    (y + mane_base_y) * mane.shrinkfactor - (int) alt.height/2);  }_   #ifdef	TOOLKIT
 	/*ARGSUSED*/b void& handle_release(widget, junk, ev, cont) 	Widget	widget;n 	XtPointer junk; 	XEvent *ev; #define	event	(&(ev->xbutton)) 	Boolean	*cont;		/* unused */n #else	/* !TOOLKIT */ void handle_release() #endif	/* TOOLKIT */ {n 	if (alt.win != (Window) 0) ; 	    if (alt_stat) alt_stat = -1;	/* destroy upon expose */D 	    else {g  		XDestroyWindow(DISP, alt.win);/ 		if (currwin.win == alt.win) alt_canit = True;y 		alt.win = (Window) 0;e 		mag_moved = False; 		can_exposures(&alt); 	    } }n   #ifdef	TOOLKIT #undef	event  
 	/*ARGSUSED*/A void% handle_exp(widget, closure, ev, cont)  	Widget	widget;R 	XtPointer closure;  	register XEvent *ev;y #define	event	(&(ev->xexpose)) 	Boolean	*cont;		/* unused */p {	< 	struct WindowRec *windowrec = (struct WindowRec *) closure;   	if (windowrec == &alt)e4 	    if (alt_stat < 0) {	/* destroy upon exposure */ 		alt_stat = 0;n? 		handle_release(widget, (caddr_t) NULL, ev, (Boolean *) NULL); 	 		return;t 	    }	 	    elsee 		alt_stat = 0;;& 	expose(windowrec, event->x, event->y,@ 	    (unsigned int) event->width, (unsigned int) event->height); }r   #undef	event #endif	/* TOOLKIT */   void showmessage(message) 	_Xconst	char	*message;  { 
 	get_xy();) 	XDrawImageString(DISP, mane.win, foreGC, G 	    5 - window_x, 5 + X11HEIGHT - window_y, message, strlen(message));e }&   /* |||E  *	Currently the event handler does not coordinate XCopyArea requestsaG  *	with GraphicsExpose events.  This can lead to problems if the window	A  *	is partially obscured and one, for example, drags a scrollbar._  */    static	voidi$ keystroke(ch, number0, arg0, eventp)	 	char	ch;C
 	int	number0;i 	Boolean	arg0; 	XEvent	*eventp; {e 	int	next_page;_ #ifdef	TOOLKIT 	Window	ww;x #endif   	next_page = current_page; 	switch (ch) { 	    case 'q':! 	    case '\003':	/* control-C */e! 	    case '\004':	/* control-D */ 
 #ifdef	VMS! 	    case '\032':	/* control-Z */e #endif #if	PS 		ps_destroy();n #endif
 		exit(0);   	    case 'n': 	    case 'f': 	    case ' ': 	    case '\r':n 	    case '\n':n0 		/* scroll forward; i.e. go to relative page */2 		next_page = current_page + (arg0 ? number0 : 1); 		break; 	    case 'p': 	    case 'b': 	    case '\b':a 	    case '\177':	/* Del */a 		/* scroll backward */ 2 		next_page = current_page - (arg0 ? number0 : 1); 		break; 	    case 'g': 		/* go to absolute page */l0 		next_page = (arg0 ? number0 - pageno_correct : 		    total_pages - 1);  		break;* 	    case 'P':		/* declare current page */1 		pageno_correct = arg0 * number0 - current_page; 	 		return;l/ 	    case 'k':		/* toggle keep-position flag */u> 		resource.keep_flag = (arg0 ? number0 : !resource.keep_flag);	 		return;l 	    case '\f':b 		/* redisplay current page */ 		break; 	    case '^':
 		home(True);d	 		return;b #ifdef	TOOLKIT 	    case 'l': 		if (!x_bar) goto bad;n' 		XtCallCallbacks(x_bar, XtNscrollProc,l+ 		    (XtPointer) (-2 * (int) clip_w / 3)); 	 		return;y 	    case 'r': 		if (!x_bar) goto bad;0' 		XtCallCallbacks(x_bar, XtNscrollProc,y* 		    (XtPointer) (2 * (int) clip_w / 3));	 		return;_ 	    case 'u': 		if (!y_bar) goto bad;n' 		XtCallCallbacks(y_bar, XtNscrollProc, + 		    (XtPointer) (-2 * (int) clip_h / 3));t	 		return;  	    case 'd': 		if (!y_bar) goto bad; ' 		XtCallCallbacks(y_bar, XtNscrollProc,c* 		    (XtPointer) (2 * (int) clip_h / 3));	 		return;  	    case 'c':) 		center(eventp->xkey.x, eventp->xkey.y); 	 		return;= 	    case 'M':9 		(void) XTranslateCoordinates(DISP, eventp->xkey.window,p, 			mane.win, eventp->xkey.x, eventp->xkey.y,9 			&home_x, &home_y, &ww);	/* throw away last argument */  		home_x *= mane.shrinkfactor; 		home_y *= mane.shrinkfactor;	 		return;  #ifdef	BUTTONS 	    case 'x':8 		if (arg0 && resource.expert == (number0 != 0)) return;) 		XtSetValues(vport_widget, resizable_on,t 		    XtNumber(resizable_off));;- 		if (resource.expert) {	/* create buttons */>$ 		    XdviResizeWidget(vport_widget,# 			window_w -= XTRA_WID, window_h);s* 		    create_buttons((XtArgVal) window_h); 		    resource.expert = False; 		}= 		else {		/* destroy buttons */e$ 		    XtDestroyWidget(panel_widget);# 		    XtDestroyWidget(line_widget);x$ 		    XdviResizeWidget(vport_widget,# 			window_w += XTRA_WID, window_h);_ 		    resource.expert = True;n 		}d	 		return;f #endif	/* BUTTONS */ #else	/* !TOOLKIT */ 	    case 'l':! 		if (mane.base_x <= 0) goto bad;v> 		scrollmane(mane.base_x - 2 * (int) clip_w / 3, mane.base_y);	 		return;= 	    case 'r':/ 		if (mane.base_x >= page_w - clip_w) goto bad;n> 		scrollmane(mane.base_x + 2 * (int) clip_w / 3, mane.base_y);	 		return;- 	    case 'u':! 		if (mane.base_y <= 0) goto bad;m> 		scrollmane(mane.base_x, mane.base_y - 2 * (int) clip_h / 3);	 		return;e 	    case 'd':/ 		if (mane.base_y >= page_h - clip_h) goto bad;g> 		scrollmane(mane.base_x, mane.base_y + 2 * (int) clip_h / 3);	 		return;0+ 	    case 'c':	/* unchecked scrollmane() */d> 		scrollwindow(&mane, mane.base_x + eventp->xkey.x - clip_w/2,/ 		    mane.base_y + eventp->xkey.y - clip_h/2);s 		if (x_bar) paint_x_bar();  		if (y_bar) paint_y_bar();v, 		XWarpPointer(DISP, None, None, 0, 0, 0, 0,< 		    clip_w/2 - eventp->xkey.x, clip_h/2 - eventp->xkey.y);	 		return;	 	    case 'M':4 		home_x = (eventp->xkey.x - (y_bar ? BAR_THICK : 0)) 		    + mane.base_x) * mane.shrinkfactor;e4 		home_y = (eventp->xkey.y - (x_bar ? BAR_THICK : 0)) 		    + mane.base_y) * mane.shrinkfactor;e	 		return;  #endif	/* TOOLKIT */  ! 	    case '\020':	/* Control P */ 2 		Printf("Unit = %d, bitord = %d, byteord = %d\n",- 		    BitmapUnit(DISP), BitmapBitOrder(DISP),} 		    ImageByteOrder(DISP));	 		return;T 	    case 's': 		if (!arg0) { 		    int temp;t7 		    number0 = ROUNDUP(unshrunk_page_w, window_w - 2);a4 		    temp = ROUNDUP(unshrunk_page_h, window_h - 2);) 		    if (number0 < temp) number0 = temp;  		}G 		if (number0 <= 0) goto bad;i+ 		if (number0 == mane.shrinkfactor) return;P 		mane.shrinkfactor = number0; 		init_page();. 		if (number0 != 1 && number0 != bak_shrink) { 		    bak_shrink = number0;e #ifdef	GREY)$ 		    if (use_grey) init_pix(False); #endif 		    reset_fonts(); 		}g
 		reconfig();_ 		home(False); 		break; 	    case 'S': 		if (!arg0) goto bad; #ifdef	GREYn 		if (use_grey) {a< 		    float newgamma = number0 != 0 ? number0 / 100.0 : 1.0;  $ 		    if (newgamma == gamma) return; 		    gamma = newgamma;  		    init_pix(False);
 		    return;h 		}  #endif 		if (number0 < 0) goto bad;! 		if (number0 == density) return;- 		density = number0; 		reset_fonts();% 		if (mane.shrinkfactor == 1) return;  		break;   #ifdef	GREYk 	    case 'G':* 		use_grey = (arg0 ? number0 : !use_grey);  		if (use_grey) init_pix(False); 		reset_fonts(); 		break; #endif   #if	PS 	    case 'v':2 		if (!arg0 || resource._postscript != !number0) {3 		    resource._postscript = !resource._postscript; @ 		    if (resource._postscript) scanned_page = scanned_page_bak; 		    psp.toggle();t 		}B 		break; #endif   	    case 'R': 		/* reread DVI file */ 0 		--dvi_time;	/* then it will notice a change */ 		break;
 	    default:e 		goto bad;, 	}1 	if (0 <= next_page && next_page < total_pages) {)% 	    if (current_page != next_page) {  		current_page = next_page;o 		hush_spec_now = hush_spec;' 		if (!resource.keep_flag) home(False);e 	    } 	    canit = True; 	    XFlush(DISP);@ 	    return;	/* Don't use longjmp here:  it might be called from: 			 * within the toolkit, and we don't want to longjmp out 			 * of Xt routines. */ 	} 	bad:  XBell(DISP, 10);n }m   void read_events(wait)  	wide_bool	wait; {a 	XEvent	event;   	alt_canit = False;| 	for (;;) {=  	    event_counter = event_freq; 	    /*LB 	     * The above line clears the flag indicating that an event isE 	     * pending.  So if an event comes in right now, the flag will be_F 	     * set again needlessly, but we just end up making an extra call.D 	     * Also, be careful about destroying the magnifying glass while 	     * writing it.( 	     */B 	    if (!XtPending() && (!wait || canit || mane.min_x < MAXDIM ||) 		    alt.min_x < MAXDIM || mag_moved)) {*% 		if (!wait && (canit | alt_canit)) {e #if	PS 		    psp.interrupt(); #endif+ 		    if (allow_can) longjmp(canit_env, 1);t 		} 	 		return;o 	    } #ifdef	TOOLKIT 	    XtNextEvent(&event);d 	    if (resized) get_geom(); @ 	    if (event.xany.window == alt.win && event.type == Expose) {5 		handle_exp((Widget) NULL, (XtPointer) &alt, &event,r 		    (Boolean *) NULL); 		continue;. 	    }$ 	    (void) XtDispatchEvent(&event); #else	/* !TOOLKIT */   	    XNextEvent(DISP, &event);I 	    if (event.xany.window == mane.win || event.xany.window == alt.win) {a 		struct WindowRec *wr = &mane;t  % 		if (event.xany.window == alt.win) {  		    wr = &alt;9 		    /* check in case we already destroyed the window */ 5 		    if (alt_stat < 0) { /* destroy upon exposure */W 			alt_stat = 0; 			handle_release(); 			continue; 		    }s
 		    else 			alt_stat = 0; 		}  		switch (event.type) {a 		case GraphicsExpose: 		case Expose:2 		    expose(wr, event.xexpose.x, event.xexpose.y,. 			event.xexpose.width, event.xexpose.height); 		    break;   		case MotionNotify:" 		    new_mag_x = event.xmotion.x;" 		    new_mag_y = event.xmotion.y;= 		    mag_moved = (new_mag_x != mag_x || new_mag_y != mag_y);  		    break;   		case ButtonPress:I$ 		    handle_button(&event.xbutton); 		    break;   		case ButtonRelease:  		    handle_release();  		    break; 		}	/* end switch */, 	    }	/* end if window == {mane,alt}.win */  + 	    else if (event.xany.window == x_bar) {p 		if (event.type == Expose) ) 		    XFillRectangle(DISP, x_bar, ruleGC,a% 			x_bgn, 1, x_end - x_bgn, BAR_WID); & 		else if (event.type == MotionNotify)3 		    scrollmane(event.xmotion.x * page_w / clip_w,e 			mane.base_y);$ 		else switch (event.xbutton.button) 		{d
 		    case 1:e: 			scrollmane(mane.base_x + event.xbutton.x, mane.base_y);	 			break;c
 		    case 2: 0 			scrollmane(event.xbutton.x * page_w / clip_w, 			    mane.base_y);	 			break;e
 		    case 3:	: 			scrollmane(mane.base_x - event.xbutton.x, mane.base_y); 		}f 	    }  + 	    else if (event.xany.window == y_bar) {  		if (event.type == Expose)t) 		    XFillRectangle(DISP, y_bar, ruleGC,a% 			1, y_bgn, BAR_WID, y_end - y_bgn); & 		else if (event.type == MotionNotify) 		    scrollmane(mane.base_x,l& 			event.xmotion.y * page_h / clip_h);$ 		else switch (event.xbutton.button) 		{ 
 		    case 1:c: 			scrollmane(mane.base_x, mane.base_y + event.xbutton.y);	 			break; 
 		    case 2:: 			scrollmane(mane.base_x,* 			    event.xbutton.y * page_h / clip_h);	 			break;	
 		    case 3:=: 			scrollmane(mane.base_x, mane.base_y - event.xbutton.y); 		}t 	    }  - 	    else if (event.xany.window == top_level)0 		switch (event.type) {e 		case ConfigureNotify: + 		    if (event.xany.window == top_level && ) 			(event.xconfigure.width != window_w ||	* 			event.xconfigure.height != window_h)) {/ 			    register Window old_mane_win = mane.win;X  ) 			    window_w = event.xconfigure.width; * 			    window_h = event.xconfigure.height; 			    reconfig();3 			    if (old_mane_win == (Window) 0) home(False);  		    }r 		    break;  * 		case MapNotify:		/* if running w/o WM */# 		    if (mane.win == (Window) 0) {k 			reconfig(); 			home(False);X 		    }  		    break;   		case KeyPress: 		    handle_key(&event);( 		    break; 		}  #endif	/* TOOLKIT */ 	} }c   static	void  redraw(windowrec)( 	struct WindowRec *windowrec;  {    	currwin = *windowrec;( 	min_x = currwin.min_x + currwin.base_x;( 	min_y = currwin.min_y + currwin.base_y;( 	max_x = currwin.max_x + currwin.base_x;( 	max_y = currwin.max_y + currwin.base_y; 	can_exposures(windowrec);   	if (debug & DBG_EVENT) G 	    Printf("Redraw %d x %d at (%d, %d) (base=%d,%d)\n", max_x - min_x, ? 		max_y - min_y, min_x, min_y, currwin.base_x, currwin.base_y);=. 	XDefineCursor(DISP, mane.win, redraw_cursor); 	XFlush(DISP); 	if (setjmp(dvi_env)) {z" 	    XClearWindow(DISP, mane.win); 	    showmessage(dvi_oops_msg);d 	    if (dvi_file) { 		Fclose(dvi_file);= 		dvi_file = NULL; 	    } 	} 	else {o 	    draw_page();w 	    hush_spec_now = True; 	} };   void
 redraw_page()s {y8 	if (debug & DBG_EVENT) Fputs("Redraw page:  ", stdout); 	XClearWindow(DISP, mane.win);" 	if (backing_store != NotUseful) {! 	    mane.min_x = mane.min_y = 0;) 	    mane.max_x = page_w;  	    mane.max_y = page_h;e 	} 	else {N 	    get_xy(); 	    mane.min_x = -window_x;% 	    mane.max_x = -window_x + clip_w;o 	    mane.min_y = -window_y;% 	    mane.max_y = -window_y + clip_h;  	} 	redraw(&mane);( }e   /*B  *	Interrupt system for receiving events.  The program sets a flagE  *	whenever an event comes in, so that at the proper time (i.e., whensE  *	reading a new dvi item), we can check incoming events to see if we B  *	still want to go on printing this page.  This way, one can stopH  *	displaying a page if it is about to be erased anyway.  We try to readE  *	as many events as possible before doing anything and base the next   *	action on all events read._G  *	Note that the Xlib and Xt routines are not reentrant, so the most we_D  *	can do is set a flag in the interrupt routine and check it later.F  *	Also, sometimes the interrupts are not generated (some systems onlyJ  *	guarantee that SIGIO is generated for terminal files, and on the systemJ  *	I use, the interrupts are not generated if I use "(xdvi foo &)" insteadE  *	of "xdvi foo").  Therefore, there is also a mechanism to check theaD  *	event queue every 70 drawing operations or so.  This mechanism is8  *	disabled if it turns out that the interrupts do work.=  *	For a fuller discussion of some of the above, see xlife inO  *	comp.sources.x.  */B   static	void; can_exposures(windowrec) 	struct WindowRec *windowrec;e {t. 	windowrec->min_x = windowrec->min_y = MAXDIM;) 	windowrec->max_x = windowrec->max_y = 0;a }h  
 #if	HAS_SIGIO  /* ARGSUSED */ static	voidb handle_intr(signo) 	int	signo;  {0 	event_counter = 1;u% 	event_freq = -1;	/* forget Plan B */	 }e   static	void  enable_intr() {p% 	int	socket	= ConnectionNumber(DISP);=   #ifdef SA_RESTART D 	/* Subprocess handling, e.g., MakeTeXPK, fails on the Alpha withoutE 	   this, because SIGIO interrupts the call of system(3), since OSF/1;B 	   doesn't retry interrupted wait calls by default.  From code by 	   maj@cl.cam.ac.uk.  */a 	{ 	    struct sigaction a;  	    a.sa_handler = handle_intr; 	    sigemptyset(&a.sa_mask); " 	    sigaddset(&a.sa_mask, SIGIO); 	    a.sa_flags = SA_RESTART;   	    sigaction(SIGIO, &a, NULL); 	} #elseu# 	(void) signal(SIGIO, handle_intr);  #endif	/* SA_RESTART */(* 	(void) fcntl(socket, F_SETOWN, getpid());C 	(void) fcntl(socket, F_SETFL, fcntl(socket, F_GETFL, 0) | FASYNC);0 }! #endif	/* HAS_SIGIO */   void
 do_pages() {	 	if (debug & DBG_BATCH) {e #ifdef	TOOLKIT4 	    while (mane.min_x == MAXDIM) read_events(True); #else	/* !TOOLKIT */! 	    while (mane.min_x == MAXDIM)t 		if (setjmp(canit_env)) break;t 		else read_events(True);n #endif	/* TOOLKIT */I 	    for (current_page = 0; current_page < total_pages; ++current_page) {e #ifdef	__convex__	< 		/* convex C turns off optimization for the entire function+ 		   if setjmp return value is discarded.*/_) 		if (setjmp(canit_env))	/*optimize me*/;g #elsex 		(void) setjmp(canit_env);n #endif 		canit = False; 		redraw_page(); 	    } 	} 	else {	/* normal operation */
 #if	HAS_SIGIO= 	    enable_intr();I #endif #ifdef	__convex__ ? 	    /* convex C turns off optimization for the entire functionk. 	       if setjmp return value is discarded.*/, 	    if (setjmp(canit_env))	/*optimize me*/; #elseo 	    (void) setjmp(canit_env); #endif 	    for (;;) {n 		if (mane.win != (Window) 0)r2 		    XDefineCursor(DISP, mane.win, ready_cursor); 		read_events(True); 		if (canit) { 		    canit = False; 		    can_exposures(&mane);o 		    can_exposures(&alt); 		    redraw_page(); 		}  		else if (mag_moved) { 3 		    if (alt.win == (Window) 0) mag_moved = False;o' 		    else if (abs(new_mag_x - mag_x) >i 			2 * abs(new_mag_y - mag_y))! 			    movemag(new_mag_x, mag_y);(' 		    else if (abs(new_mag_y - mag_y) >I 			2 * abs(new_mag_x - mag_x))! 			    movemag(mag_x, new_mag_y);a) 		    else movemag(new_mag_x, new_mag_y);e 		}(, 		else if (alt.min_x < MAXDIM) redraw(&alt);. 		else if (mane.min_x < MAXDIM) redraw(&mane); 		XFlush(DISP);E 	    } 	} } 