 /*7  * Copyright (c) 1994 Paul Vojta.  All rights reserved.   *E  * Redistribution and use in source and binary forms, with or without E  * modification, are permitted provided that the following conditions   * are met: D  * 1. Redistributions of source code must retain the above copyrightC  *    notice, this list of conditions and the following disclaimer. G  * 2. Redistributions in binary form must reproduce the above copyright I  *    notice, this list of conditions and the following disclaimer in the J  *    documentation and/or other materials provided with the distribution.  *I  * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND H  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THEM  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE J  * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLEM  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL J  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODSH  * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)M  * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT L  * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAYI  * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF   * SUCH DAMAGE.   */    #ifndef	lint static	char	copyright[] = > "@(#) Copyright (c) 1994 Paul Vojta.  All rights reserved.\n"; #endif   #include "config.h"  #include <errno.h> #include <ctype.h> #include <memory.h>  #include <sys/types.h> #include <sys/wait.h>  #include <sys/stat.h>  #include <setjmp.h>    #ifdef	POSIX_DIRENT  #include <dirent.h> $ typedef	struct dirent	struct_dirent; #else	/* !POSIX */ #include <sys/dir.h>$ typedef	struct direct	struct_dirent; #endif  
 #ifndef	GS #define	GS	"gs"  #endif   #ifndef	atof double	atof(); #endif char	*getenv();    #ifdef	__GNUC__  #define	NORETURN	volatile  #else  #define	NORETURN	/* nothing */ #endif   #ifdef	I_STDARG  #define	NeedVarargsPrototypes	1  #include <stdarg.h>  #else  #define	NeedVarargsPrototypes	0  #include <varargs.h> #endif   typedef	char	Boolean;  #define	True	1 #define	False	0    #ifndef	MAXPATHLEN #define	MAXPATHLEN	256 #endif   #define	PK_PRE	(char) 247  #define	PK_ID	89 #define	PK_POST	(char) 245 #define	PK_NOP	(char) 246   % char	ident[]	= "gsftopk version 1.9";    typedef	unsigned char	byte;    FILE		*data_file;  FILE		*pk_file;  Boolean		quiet		= False;+ int		col		= 0;		/* current column number */    /*"  *	Information from the .tfm file.  */    int		tfm_lengths[12];  #define	lh	tfm_lengths[1]  #define	bc	tfm_lengths[2]  #define	ec	tfm_lengths[3]  #define	nw	tfm_lengths[4]    long		checksum; 
 long		design;  byte		width_index[256];  long		tfm_widths[256];   /*7  *	Information on the bitmap currently being worked on.   */    byte		*bitmap; int		width; 
 int		skip; int		height;
 int		hoff;
 int		voff; int		bytes_wide; unsigned int	bm_size;  byte		*bitmap_end; int		pk_len;   /*   *	Print error message and quit.  */    #if	NeedVarargsPrototypes 
 NORETURN void  oops(const char *message, ...) #else 
 /* VARARGS */ 
 NORETURN void  oops(va_alist) 	va_dcl  #endif {  #if	!NeedVarargsPrototypes 	const char *message;  #endif 	va_list	args;   #if	NeedVarargsPrototypes  	va_start(args, message);  #else  	va_start(args);& 	message = va_arg(args, const char *); #endif! 	vfprintf(stderr, message, args);  	va_end(args); 	putc('\n', stderr);	 	exit(1);  }    /*4  *	Either allocate storage or fail with explanation.  */    char * xmalloc(size, why) 	unsigned	size;  	const char	*why;  { # 	char *mem = (char *) malloc(size);    	if (mem == NULL) ; 	    oops("Cannot allocate %u bytes for %s.\n", size, why);  	return mem; }    /*6  *	Either reallocate storage or fail with explanation.  */    char * xrealloc(oldp, size, why) 
 	char		*oldp;  	unsigned	size;  	const char	*why;  {  	char	*mem;   + 	mem = oldp == NULL ? (char *) malloc(size) $ 	    : (char *) realloc(oldp, size); 	if (mem == NULL) = 	    oops("Cannot reallocate %u bytes for %s.\n", size, why);  	return mem; }    /*G  *	Here's the patch searching stuff.  First the typedefs and variables.   */   ' static	char	searchpath[MAXPATHLEN + 1];   ! #define	HUNKSIZE	(MAXPATHLEN + 2)   < struct spacenode {	/* used for storage of directory names */ 	struct spacenode	*next;1 	char			*sp_end;	/* end of data for this chunk */  	char			sp[HUNKSIZE];  }  	firstnode;    static	jmp_buf	found_env;  static	FILE	*searchfile; static	char	*searchname; static	int	searchnamelen;   
 static	char * * find_dbl_slash(char *sp_bgn, char *sp_end) { 	 	char *p;    	for (;;) { . 	    p = memchr(sp_bgn, '/', sp_end - sp_bgn);" 	    if (p == NULL) return sp_end; 	    if (p[1] == '/') return p;  	    sp_bgn = p + 1; 	} }    static	void J main_search_proc(char *matpos, char *sp_pos, char *sp_slash, char *sp_end,@ 	Boolean skip_subdirs, struct spacenode *space, char *spacenext) {  	char		*mp;  	struct stat	statbuf;  	DIR		*dir;  	struct_dirent	*entry; 	int		lenleft;
 	int		len; 	struct spacenode *space1; 	char		*spacenext1;   # 	mp = matpos + (sp_slash - sp_pos);  	/* check length */ G 	if (mp + searchnamelen >= searchpath + sizeof(searchpath) - 2) return; + 	memcpy(matpos, sp_pos, sp_slash - sp_pos); / 	if (sp_slash == sp_end) {	/* try for a file */  	    *mp = '/'; B 	    strcpy(mp + (mp == searchpath || mp[-1] != '/'), searchname);) 	    searchfile = fopen(searchpath, "r"); 6 	    if (searchfile != NULL) longjmp(found_env, True); 	}# 	else {/* try for a subdirectory */  	    *mp = '\0';G 	    if (stat(searchpath, &statbuf) == 0 && S_ISDIR(statbuf.st_mode)) {  		*mp++ = '/'; 		sp_slash += 2;B 		main_search_proc(mp, sp_slash, find_dbl_slash(sp_slash, sp_end),7 		    sp_end, statbuf.st_nlink <= 2, space, spacenext); 	 		return;  	    } 	} 	if (skip_subdirs) return; 	*matpos = '\0'; 	dir = opendir(searchpath);  	if (dir == NULL) return; 4 	lenleft = searchpath + sizeof(searchpath) - matpos; 	space1 = space; 	spacenext1 = spacenext; 	for (;;) {  	    entry = readdir(dir); 	    if (entry == NULL) break;% 	    len = strlen(entry->d_name) + 1; 0 	    if (len > lenleft) continue;	/* too long */# 	    strcpy(matpos, entry->d_name); B 	    if (*matpos == '.' && (matpos[1] == '\0' || (matpos[1] == '.' 		    && matpos[2] == '\0'))) " 		continue;		/* ignore . and .. */F 	    if (stat(searchpath, &statbuf) != 0 || !S_ISDIR(statbuf.st_mode))% 		continue;		/* if not a directory */ % 	    if (statbuf.st_nlink > 2) ++len; 4 	    if (spacenext1 + len > space1->sp + HUNKSIZE) { 		space1->sp_end = spacenext1; 		if (space1->next == NULL) {  		    space1->next =9 			(struct spacenode *) xmalloc(sizeof(struct spacenode), $ 			    "space for directory names");  		    space1->next->next = NULL; 		}  		space1 = space1->next; 		spacenext1 = space1->sp; 	    }  	    if (statbuf.st_nlink > 2) { 		*spacenext1++ = '/'; 		--len; 	    }, 	    memcpy(spacenext1, entry->d_name, len); 	    spacenext1 += len;  	} 	closedir(dir);  	for (;;) { ! 	    space1->sp_end = spacenext1; & 	    if (spacenext == space->sp_end) { 		if (space == space1) break;  		space = space->next; 		spacenext = space->sp; 	    } 	    skip_subdirs = True;  	    if (*spacenext == '/') {  		++spacenext; 		skip_subdirs = False;  	    } 	    len = strlen(spacenext); $ 	    memcpy(matpos, spacenext, len); 	    matpos[len] = '/'; A 	    main_search_proc(matpos + len + 1, sp_pos, sp_slash, sp_end, $ 		skip_subdirs, space1, spacenext1); 	    spacenext += len + 1; 	} }   
 static	FILE * . search(char *path, char *path_var, char *name) {  	char	*env_path	= NULL; 	 	FILE	*f;    	if (path_var != NULL) { 	    if (*name == '/') { 		strcpy(searchpath, name);   		return fopen(searchpath, "r"); 	    }! 	    env_path = getenv(path_var);  	} 	if (env_path == NULL) { 	    env_path = path;  	    path = NULL;  	} 	searchname = name;  	searchnamelen = strlen(name); 	for (;;) { 
 	    char *p;    	    p = strchr(env_path, ':');*4 	    if (p == NULL) p = env_path + strlen(env_path); 	    if (p == env_path) {  		if (path != NULL) {y# 		    f = search(path, NULL, name);t 		    if (f != NULL) return f; 		}f 	    } 	    else {  		if (setjmp(found_env)) 		    return searchfile; 		main_search_proc(searchpath,/ 		    env_path, find_dbl_slash(env_path, p), p,l& 		    True, &firstnode, firstnode.sp); 	    }! 	    if (*p == '\0') return NULL;o 	    env_path = p + 1; 	} }s   /*  *	Add to dlstring  */n   char		*dlstring	= NULL;  unsigned int	dls_len		= 0; unsigned int	dls_max		= 0;   void addtodls(char *s)O {A 	int	len	= strlen(s);U    	if (dls_len + len >= dls_max) {) 	    unsigned int newsize = dls_max + 80;L  ? 	    if (newsize <= dls_len + len) newsize = dls_len + len + 1;II 	    dlstring = xrealloc(dlstring, dls_max = newsize, "download string");  	} 	strcpy(dlstring + dls_len, s);I 	dls_len += len; }C       long getlong(FILE *f) {  	int	value;   & 	value = (int) ((byte) getc(f)) << 24;' 	value |= (int) ((byte) getc(f)) << 16;E& 	value |= (int) ((byte) getc(f)) << 8;! 	value |= (int) ((byte) getc(f));T 	return value; }U     char	line[82];   void expect(char *waitingfor) {S 	for (;;) {A6 	    if (fgets(line, sizeof(line), data_file) == NULL)  		oops("Premature end of file");C 	    if (memcmp(line, waitingfor, strlen(waitingfor)) == 0) return;A 	    fputs("gs: ", stdout);t 	    for (;;) {h 		fputs(line, stdout);= 		if (*line == '\0' || line[strlen(line) - 1] == '\n') break;u3 		if (fgets(line, sizeof(line), data_file) == NULL)>$ 		    oops("Premature end of file"); 	    } 	} }u   void whitespace(void) {y 	char	c;   	for (;;) {j 	    c = getc(data_file);N 	    if (c == '#')@ 		do c = getc(data_file); while (!feof(data_file) && c != '\n'); 	    else if (!isspace(c)) { 		ungetc(c, data_file);; 		break; 	    } 	} }d   intS getint(void) {  	char	c; 	int	i	= 0;o  , 	do c = getc(data_file); while (isspace(c));0 	if (c < '0' || c > '9') oops("digit expected"); 	do {/ 	    i = i * 10 + (c - '0'); 	    c = getc(data_file);a  	} while (c >= '0' && c <= '9');, 	if (!feof(data_file)) ungetc(c, data_file);
 	return i; }a  > static	byte	masks[]	= {0, 1, 3, 7, 017, 037, 077, 0177, 0377};  
 byte	flag;
 int	pk_dyn_f;N
 int	pk_dyn_g;T7 int	base;		/* cost of this character if pk_dyn_f = 0 */K? int	deltas[13];	/* cost of increasing pk_dyn_f from i to i+1 */    /*:  *	Add up statistics for putting out the given shift count  */    static	voidi tallyup(int n) {e 	int	m;a   	if (n > 208) {  	    ++base; 	    n -= 192;9 	    for (m = 0x100; m != 0 && m < n; m <<= 4) base += 2;*; 	    if (m != 0 && (m = (m - n) / 15) < 13) deltas[m] += 2;f 	}+ 	else if (n > 13) ++deltas[(208 - n) / 15];  	else --deltas[n - 1]; }    /*(  *	Routines for storing the shift counts  */e   static	Boolean	odd	= False;; static	byte	part;i   static	voidp pk_put_nyb(int n)r {  	if (odd) { % 	    *bitmap_end++ = (part << 4) | n;; 	    odd = False;	 	} 	else {v 	    part = n; 	    odd = True; 	} }i   static	voidt pk_put_long(int n) {  	if (n >= 16) {r 	    pk_put_nyb(0);  	    pk_put_long(n / 16);o 	} 	pk_put_nyb(n % 16); }c   static	voida pk_put_count(int n)V {R 	if (n > pk_dyn_f) { 	    if (n > pk_dyn_g)! 		pk_put_long(n - pk_dyn_g + 15);t 	    else {t2 		pk_put_nyb(pk_dyn_f + (n - pk_dyn_f + 15) / 16);& 		pk_put_nyb((n - pk_dyn_f - 1) % 16); 	    } 	} 	else pk_put_nyb(n); }s   static	voidr trim_bitmap(void)  {d	 	byte	*p;t 	byte	mask;s  ' 	/* clear out garbage bits in bitmap */t 	if (width % 8 != 0) {" 	    mask = ~masks[8 - width % 8];G 	    for (p = bitmap + bytes_wide - 1; p < bitmap_end; p += bytes_wide)e
 		*p &= mask;	 	}   	/* ( 	 *	Find the bounding box of the bitmap. 	 */   	/* trim top */p
 	skip = 0;
 	mask = 0; 	for (;;) {"9 	    if (bitmap >= bitmap_end) {	/* if bitmap is empty */e# 		width = height = hoff = voff = 0;*	 		return;* 	    } 	    p = bitmap + bytes_wide;l% 	    while (p > bitmap) mask |= *--p;y 	    if (mask) break;  	    ++skip; 	    bitmap += bytes_wide; 	} 	height -= skip; 	voff -= skip; #ifdef	DEBUG 	if (skip < 2 || skip > 3): 	    printf("Character has %d empty rows at top\n", skip); #endif   	/* trim bottom */
 	skip = 0;
 	mask = 0; 	for (;;) {a! 	    p = bitmap_end - bytes_wide;	) 	    while (p < bitmap_end) mask |= *p++;K 	    if (mask) break;  	    ++skip; 	    bitmap_end -= bytes_wide; 	} 	height -= skip; #ifdef	DEBUG 	if (skip < 2 || skip > 3)= 	    printf("Character has %d empty rows at bottom\n", skip);r #endif   	/* trim right */u
 	skip = 0;	 	--width;s 	for (;;) {t 	    mask = 0;B 	    for (p = bitmap + width / 8; p < bitmap_end; p += bytes_wide)
 		mask |= *p;c- 	    if (mask & (0x80 >> (width % 8))) break; 
 	    --width;p 	    ++skip; 	}	 	++width;  #ifdef	DEBUG 	if (skip < 2 || skip > 3)? 	    printf("Character has %d empty columns at right\n", skip);c #endif   	/* trim left */
 	skip = 0; 	for (;;) {c 	    mask = 0;A 	    for (p = bitmap + skip / 8; p < bitmap_end; p += bytes_wide)*
 		mask |= *p; , 	    if (mask & (0x80 >> (skip % 8))) break; 	    ++skip; 	} 	width -= skip;	 	hoff -= skip; #ifdef	DEBUG 	if (skip < 2 || skip > 3)> 	    printf("Character has %d empty columns at left\n", skip); #endif 	bitmap += skip / 8; 	skip = skip % 8;  }i   /*F  *	Pack the bitmap using the rll method.  (Return false if it's better  *	to just pack the bits.)  */    static	Boolean pk_rll_cvt(void) {s= 	static	int	*counts		= NULL;	/* area for saving bit counts */ 2 	static	int	maxcounts	= 0;	/* size of this area */4 	unsigned int	ncounts;		/* max to allow this time */) 	int	*nextcount;			/* next count value */=( 	int	*counts_end;			/* pointer to end */ 	byte	*rowptr;	 	byte	*p;t 	byte	mask;	/ 	byte	*rowdup;			/* last row checked for dup */c% 	byte	paint_switch;			/* 0 or 0xff */ ( 	int	bits_left;			/* bits left in row */
 	int	cost; 	int	i;)   	/*e" 	 *	Allocate space for bit counts. 	 */  $ 	ncounts = (width * height + 3) / 4; 	if (ncounts > maxcounts) {L& 	    if (counts != NULL) free(counts);: 	    counts = (int *) xmalloc((ncounts + 2) * sizeof(int), 		"array for bit counts"); 	    maxcounts = ncounts;  	} 	counts_end = counts + ncounts;=   	/*(* 	 *	Form bit counts and collect statistics 	 */
 	base = 0; 	bzero(deltas, sizeof(deltas));r5 	rowdup = NULL;	/* last row checked for duplicates */' 	p = rowptr = bitmap;' 	mask = 0x80 >> skip; 
 	flag = 0; 	paint_switch = 0; 	if (*p & mask) {i 	    flag = 8; 	    paint_switch = 0xff;D 	} 	bits_left = width;o 	nextcount = counts;; 	while (rowptr < bitmap_end) {	/* loop over shift counts */ ! 	    int shift_count = bits_left;N   	    for (;;) {> 		if (bits_left == 0) {f: 		    if ((p = rowptr += bytes_wide) >= bitmap_end) break; 		    mask = 0x80 >> skip; 		    bits_left = width; 		    shift_count += width;" 		}	/ 		if (((*p ^ paint_switch) & mask) != 0) break;s 		--bits_left;
 		mask >>= 1;a 		if (mask == 0) {
 		    ++p;4 		    while (*p == paint_switch && bits_left >= 8) { 			++p;  			bits_left -= 8; 		    }d 		    mask = 0x80; 		}e 	    }/ 	    if (nextcount >= counts_end) return False;a 	    shift_count -= bits_left;  	    *nextcount++ = shift_count; 	    tallyup(shift_count);# 	    /* check for duplicate rows */n2 	    if (rowptr != rowdup && bits_left != width) { 		byte	*p1	= rowptr;  		byte	*q	= rowptr + bytes_wide; 		int	repeat_count;   0 		while (q < bitmap_end && *p1 == *q) ++p1, ++q;, 		repeat_count = (p1 - rowptr) / bytes_wide; 		if (repeat_count > 0) {a# 		    *nextcount++ = -repeat_count;e$ 		    if (repeat_count == 1) --base; 		    else {
 			++base; 			tallyup(repeat_count);L 		    }r* 		    rowptr += repeat_count * bytes_wide; 		}c 		rowdup = rowptr; 	    }" 	    paint_switch = ~paint_switch; 	}   #ifdef	DEBUG 	/*  	 *	Dump the bitmapn 	 */  4 	for (p = bitmap; p < bitmap_end; p += bytes_wide) { 	    byte *p1	= p; 	    int j;e   	    mask = 0x80 >> skip;p" 	    for (j = 0; j < width; ++j) {" 		putchar(*p1 & mask ? '@' : '.');+ 		if ((mask >>= 1) == 0) mask = 0x80, ++p1;p 	    } 	    putchar('\n');h 	} 	putchar('\n');= #endif   	/*_ 	 *	Determine the best pk_dyn_f  	 */   	pk_dyn_f = 0;) 	cost = base += 2 * (nextcount - counts);N 	for (i = 1; i < 14; ++i) {N 	    base += deltas[i - 1];  	    if (base < cost) {p 		pk_dyn_f = i;  		cost = base; 	    } 	} 	/* last chance to bail out */- 	if (cost * 4 > width * height) return False;    	/*  	 *	Pack the bit counts; 	 */    	pk_dyn_g = 208 - 15 * pk_dyn_f; 	flag |= pk_dyn_f << 4;; 	bitmap_end = bitmap;t 	*nextcount = 0; 	nextcount = counts; 	while (*nextcount != 0) {2 	    if (*nextcount > 0) pk_put_count(*nextcount);	 	    elseA' 		if (*nextcount == -1) pk_put_nyb(15);+ 		else { 		    pk_put_nyb(14);   		    pk_put_count(-*nextcount); 		}  	    ++nextcount;  	} 	if (odd) {d 	    pk_put_nyb(0);  	    ++cost; 	}' 	if (cost != 2 * (bitmap_end - bitmap))a@ 	    printf("Cost miscalculation:  expected %d, got %d\n", cost, 		2 * (bitmap_end - bitmap));E 	pk_len = bitmap_end - bitmap;
 	return True;) }t   static	voidv pk_bm_cvt(void)y {  	byte	*rowptr;	 	byte	*p; $ 	int	blib1;		/* bits left in byte */& 	int	bits_left;	/* bits left in row */	 	byte	*q;  	int	blib2;; 	byte	nextbyte;c   	flag = 14 << 4; 	q = bitmap; 	blib2 = 8;e 	nextbyte = 0;C 	for (rowptr = bitmap; rowptr < bitmap_end; rowptr += bytes_wide) {  	    p = rowptr; 	    blib1 = 8 - skip; 	    bits_left = width;f 	    if (blib2 != 8) { 		int	n;   		if (blib1 < blib2) {( 		    nextbyte |= *p << (blib2 - blib1); 		    n = blib1; 		}k 		else {( 		    nextbyte |= *p >> (blib1 - blib2); 		    n = blib2; 		}t
 		blib2 -= n;" 		if ((bits_left -= n) < 0) {t 		    blib2 -= bits_left;  		    continue;  		}= 		if ((blib1 -= n) == 0) { 		    blib1 = 8;
 		    ++p; 		    if (blib2 > 0) {! 			nextbyte |= *p >> (8 - blib2);f 			blib1 -= blib2; 			bits_left -= blib2; 			if (bits_left < 0) {  			    blib2 = -bits_left; 			    continue; 			} 		    }e 		}t 		*q++ = nextbyte; 	    }, 	    /* fill up whole (destination) bytes */ 	    while (bits_left >= 8) { ! 		nextbyte = *p++ << (8 - blib1);)" 		*q++ = nextbyte | (*p >> blib1); 		bits_left -= 8;i 	    } 	    /* now do the remainder */a" 	    nextbyte = *p << (8 - blib1);6 	    if (bits_left > blib1) nextbyte |= p[1] >> blib1; 	    blib2 = 8 - bits_left;e 	}! 	if (blib2 != 8) *q++ = nextbyte;f 	pk_len = q - bitmap;] }*   static	voids putshort(short w)  {i 	putc(w >> 8, pk_file);t 	putc(w, pk_file); }t   static	voidt putmed(long w) {t 	putc(w >> 16, pk_file); 	putc(w >> 8, pk_file);2 	putc(w, pk_file); }    static	void  putlong(long w); {! 	putc(w >> 24, pk_file); 	putc(w >> 16, pk_file); 	putc(w >> 8, pk_file);3 	putc(w, pk_file); }    static	void3 putglyph(int cc) {/( 	static	Boolean	have_first_line = False; 	static	int	llx, lly, urx, ury;  	static	float	char_width;e 	static	byte	*area1	= NULL;	 	static unsigned int size1 = 0;b	 	long	dm;  	long	tfm_wid;	 	byte	*p;p 	int	i;(   	if (!quiet) {
 	    int wid;e 	    static char *s = "";   ( 	    wid = (cc >= 100) + (cc >= 10) + 4; 	    if (col + wid > 80) { 		s = "\n"; 
 		col = 0; 	    } 	    printf("%s[%d", s, cc); 	    fflush(stdout); 	    col += wid;
 	    s = " ";t 	} 	if (!have_first_line) { 	    expect("#^");3 	    if (sscanf(line, "#^ %d %d %d %d %d %f\n", &i, 0 		    &llx, &lly, &urx, &ury, &char_width) != 6)" 		oops("Cannot scanf first line"); 	}? 	if (i < cc) oops("Character %d received, %d expected", i, cc);r 	if (i > cc) {7 	    fprintf(stderr, "Character %d is missing.\n", cc);g 	    have_first_line = True; 	    return; 	} 	have_first_line = False;% 	hoff = -llx + 2;  	voff = ury + 2 - 1; 	expect("P4\n"); 	whitespace(); 	width = getint(); 	whitespace(); 	height = getint();  	(void) getc(data_file);7 	if (width != urx - llx + 4 || height != ury - lly + 4) 8 	    oops("Dimensions do not match:  %d %d %d %d %d %d",% 		llx, lly, urx, ury, width, height);e 	bytes_wide = (width + 7) / 8; 	bm_size = bytes_wide * height;i 	if (size1 < bm_size) { $ 	    if (area1 != NULL) free(area1);: 	    area1 = (byte *) xmalloc(bm_size, "original bitmap"); 	    size1 = bm_size;i 	}I 	for (p = area1 + (height - 1) * bytes_wide; p >= area1; p -= bytes_wide) : 	    if (fread(p, 1, bytes_wide, data_file) != bytes_wide)1 		oops("Cannot read bitmap of size %u", bm_size);i 	bitmap = area1; 	bitmap_end = bitmap + bm_size;b 	trim_bitmap();i/ 	if (height == 0 || !pk_rll_cvt()) pk_bm_cvt();=' 	tfm_wid = tfm_widths[width_index[cc]];i6 	dm = (long) (char_width + 0.5) - (char_width < -0.5);1 	if (pk_len + 8 < 4 * 256 && tfm_wid < (1<<24) && 7 		dm >= 0 && dm < 256 && width < 256 && height < 256 &&(= 		hoff >= -128 && hoff < 128 && voff >= -128 && voff < 128) {k/ 	    putc(flag | ((pk_len + 8) >> 8), pk_file);b 	    putc(pk_len + 8, pk_file);i 	    putc(cc, pk_file);f 	    putmed(tfm_wid);| 	    putc(dm, pk_file);C 	    putc(width, pk_file); 	    putc(height, pk_file);f 	    putc(hoff, pk_file);  	    putc(voff, pk_file);s 	} else 5 	if (pk_len + 13 < 3 * 65536L && tfm_wid < (1<<24) &&e@ 		dm >= 0 && dm < 65536L && width < 65536L && height < 65536L &&% 		hoff >= -65536L && hoff < 65536L &&	% 		voff >= -65536L && voff < 65536L) {i5 	    putc(flag | 4 | ((pk_len + 13) >> 16), pk_file);  	    putshort(pk_len + 13);e 	    putc(cc, pk_file);; 	    putmed(tfm_wid);i 	    putshort(dm); 	    putshort(width);t 	    putshort(height); 	    putshort(hoff); 	    putshort(voff); 	} 	else {o 	    putc(flag | 7, pk_file);a 	    putlong(pk_len + 28); 	    putlong(cc);  	    putlong(tfm_wid);H 	    putlong((long) (char_width * 65536.0 + 0.5) - (char_width < -0.5)); 	    putlong(0); 	    putlong(width); 	    putlong(height);  	    putlong(hoff);* 	    putlong(voff);b 	}$ 	fwrite(bitmap, 1, pk_len, pk_file); 	if (!quiet) { 	    putchar(']'); 	    fflush(stdout); 	} }h   int0 main(int argc, char **argv)	 {* 	FILE	*config_file;  	FILE	*tfm_file; 	float	dpi;  	char	*fontname;
 	int	fontlen;  	char	*configline; 	unsigned int	cflinelen;	 	char	*p;s 	char	*PSname		= NULL; 	char	*specinfo	= "";( 	char	*xfilename;t( 	char	charlist[10*2 + 90*3 + 156*4 + 1]; 	char	designstr[20]; 	char	dpistr[20];m	 	int	pid;n 	int	std_in[2];u 	int	std_out[2]; 	int	status; 	int	cc;	 	int	ppp;u 	int	i;o  . 	if (argc > 1 && strcmp(argv[1], "-q") == 0) { 	    ++argv; 	    --argc; 	    quiet = True; 	}  1 	if (argc != 3 || (dpi = atof(argv[2])) <= 0.0) { 9 	    fputs("Usage: gsftopk [-q] <font> <dpi>\n", stderr); 
 	    exit(1);f 	} 	fontname = argv[1]; 	fontlen = strlen(fontname);   	if (!quiet) puts(ident);   > 	config_file = search(CONFIGPATH, "TEXCONFIG", "psfonts.map");@ 	if (config_file == NULL) oops("Cannot find file psfonts.map.");  C 	configline = (char *) xmalloc(cflinelen = 80, "Config file line");  	do {a 	    int len	= 0;   ; 	    if (fgets(configline, cflinelen, config_file) == NULL)	8 		oops("Cannot find font %s in config file.", fontname); 	    for (;;) {1 		i = strlen(configline + len);;   		len += i;*/ 		if (len > 0 && configline[len - 1] == '\n') {  		    configline[--len] = '\0';  		    break; 		}e! 		if (len < cflinelen - 1) break;n4 		configline = xrealloc(configline, cflinelen += 80, 		    "config file line");8 		fgets(configline + len, cflinelen - len, config_file); 	    } 	}2 	while (memcmp(configline, fontname, fontlen) != 0H 	    || (configline[fontlen] != '\0' && !isspace(configline[fontlen]))); 	fclose(config_file);b   	/*n( 	 * Parse the line from the config file. 	 */2 	for (p = configline + fontlen; *p != '\0'; ++p) { 	    if (isspace(*p)) continue;u 	    if (*p == '<') {c 		char	*q	= ++p; 		char	endc;
 		FILE	*f;   		addtodls(" (");o) 		while (*p != '\0' && !isspace(*p)) ++p;u 		endc = *p; 		*p = '\0';, 		f = search(HEADERPATH, "DVIPSHEADERS", q);5 		if (f == NULL) oops("Cannot find font file %s", q);t% 		/* search() also sets searchpath */m 		addtodls(searchpath);{: 		addtodls((char) getc(f) == '\200' ? ") brun" : ") run"); 		fclose(f); 		if (endc == '\0') break; 		continue;  	    } 	    else if (*p == '"') {
 		char	*q;   		specinfo = ++p;  		q = strchr(p, '"');) 		if (q == NULL) break;  		p = q; 	    } 	    else {h
 		PSname = p; ) 		while (*p != '\0' && !isspace(*p)) ++p;  		if (*p == '\0') break; 	    } 	    *p = '\0';  	}   #ifdef	OLD_DVIPSB 	/* Parse lines like `Symbol-Slanted "/Symbol .167 SlantFont"'. */ 	if (*(p = specinfo) == '/') { 	    PSname = ++p;$ 	    while (*p && !isspace(*p)) ++p; 	    if (*p) *p++ = '\0';t 	    specinfo = p; 	} #endif	/* OLD_DVIPS */   	/*a 	 *	Start up GhostScript.a 	 */  < 	tfm_file = search(HEADERPATH, "DVIPSHEADERS", "render.ps"); 	if (tfm_file == NULL)7 	    oops("Cannot find PS driver file \"render.ps\".");	 	fclose(tfm_file);   	sprintf(dpistr, "%f", dpi);  / 	if (pipe(std_in) != 0 || pipe(std_out) != 0) {t 	    perror("pipe"); 	    return 1; 	}  0 	fflush(stderr);		/* to avoid double flushing */ 	pid = vfork();p 	if (pid == 0) { 	    close(std_in[1]); 	    dup2(std_in[0], 0); 	    close(std_in[0]); 	    close(std_out[0]);p 	    dup2(std_out[1], 1);; 	    close(std_out[1]);t0 	    execlp(GS, "gs", "-DNODISPLAY", "-q", "--", 		/* render.ps */ searchpath,s% 		PSname != NULL ? PSname : fontname,t< 		dlstring != NULL ? dlstring : "", specinfo, dpistr, NULL); 	    perror("gs");
 	    exit(1);b 	} 	if (pid == -1) {  	    perror("fork");
 	    exit(1);i 	}   	/*o@ 	 *	Open and read the tfm file.  If this takes a while, at least3 	 *	it can overlap with the startup of GhostScript.n 	 */   	fontlen = strlen(fontname);: 	xfilename = xmalloc(fontlen + 10, "name of tfm/pk file"); 	strcpy(xfilename, fontname);>% 	strcpy(xfilename + fontlen, ".tfm");	< 	tfm_file = search(TEXFONTS_DEFAULT, "TEXFONTS", xfilename);5 	if (tfm_file == NULL) oops("Cannot find tfm file.");- 	for (i = 0; i < 12; ++i) {; 	    int j;   , 	    j = (int) ((byte) getc(tfm_file)) << 8;8 	    tfm_lengths[i] = j | (int) ((byte) getc(tfm_file)); 	} 	checksum = getlong(tfm_file); 	design = getlong(tfm_file);" 	fseek(tfm_file, 4 * (lh + 6), 0); 	p = charlist;  	for (cc = bc; cc <= ec; ++cc) {- 	    width_index[cc] = (byte) getc(tfm_file);	  	    if (width_index[cc] != 0) { 		sprintf(p, "%d ", cc); 		p += strlen(p);f 	    } 	    (void) getc(tfm_file);r 	    (void) getc(tfm_file);  	    (void) getc(tfm_file);b 	}< 	for (i = 0; i < nw; ++i) tfm_widths[i] = getlong(tfm_file); 	fclose(tfm_file); 	p[-1] = '\n';  ; 	/* write the design size and character list to the file */o8 	sprintf(designstr, "%f\n", (float) design / (1 << 20));0 	write(std_in[1], designstr, strlen(designstr));* 	write(std_in[1], charlist, p - charlist); 	close(std_in[1]);   /*$  *	Read the output from GhostScript.  */t  5 	if ((data_file = fdopen(std_out[0], "r")) == NULL) {> 	    perror("GS_out");
 	    exit(1);  	}   /*%  *	Create pk file and write preamble.l  */a   	fflush(stdout);: 	sprintf(xfilename + fontlen, ".%dpk", (int) (dpi + 0.5));1 	if ((pk_file = fopen(xfilename, "w")) == NULL) {d 	    perror(xfilename);m
 	    exit(1);i 	} 	putc(PK_PRE, pk_file);i 	putc(PK_ID, pk_file); 	i = strlen(ident);r 	putc(i, pk_file); 	fwrite(ident, 1, i, pk_file); 	putlong(design);w 	putlong(checksum);"# 	ppp = dpi / 72.27 * 65536.0 + 0.5;% 	putlong(ppp);	/* hppp */( 	putlong(ppp);	/* vppp */    /*  *	Write the actual characters.n  */    	for (cc = bc; cc <= ec; ++cc) 	    if (width_index[cc] != 0) 		putglyph(cc);x 	fclose(data_file);c   	if (wait(&status) == -1) {t 	    perror("wait");
 	    exit(1);) 	} 	if (status != 0)e 	    if (status & 0377))9 		oops("Call to gs stopped by signal %d", status & 0177);iE 	    else oops("Call to gs returned nonzero status %d", status >> 8);_   	putc(PK_POST, pk_file);7 	while (ftell(pk_file) % 4 != 0) putc(PK_NOP, pk_file);i 	fclose(pk_file);= 	if (!quiet) putchar('\n');h
 	return 0; })