 /*7  * Copyright (c) 1994 Paul Vojta.  All rights reserved.   *E  * Redistribution and use in source and binary forms, with or without E  * modification, are permitted provided that the following conditions   * are met: D  * 1. Redistributions of source code must retain the above copyrightC  *    notice, this list of conditions and the following disclaimer. G  * 2. Redistributions in binary form must reproduce the above copyright I  *    notice, this list of conditions and the following disclaimer in the J  *    documentation and/or other materials provided with the distribution.  *I  * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND H  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THEM  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE J  * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLEM  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL J  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODSH  * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)M  * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT L  * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAYI  * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF   * SUCH DAMAGE.   *	  * NOTES: ;  *	This code was originally written by Ricardo Telichevesky 6  *	(ricardo@rle-vlsi-mit.edu) and Luis Miguel Silveira  *	(lms@rle-vlsi-mit.edu).?  *	It was largely influenced by similar code in the SeeTeX/XTeX 4  *	package by Dirk Grunwald (grunwald@colorado.edu).  */    #include "xdvi.h"  #include <errno.h> #include <signal.h>  #include <X11/X.h> #include <X11/Xlib.h>  #include <DPS/XDPSlib.h> #include <DPS/dpsXclient.h>  #include <DPS/dpsexcept.h> #include <DPS/dpsclient.h>   #ifdef	X_NOT_STDC_ENV  extern	int	errno;  #endif     		/*8 		 * This string reads chunks (delimited by %%xdvimark).? 		 * The first character of a chunk tells whether a given chunk . 		 * is to be done within save/restore or not.: 		 * The `H' at the end tells it that the first group is a# 		 * header; i.e., no save/restore.  		 */  #ifndef	SUNHACK  static	char	preamble[]	= "\  /xdvi$line 81 string def \; /xdvi$run {{$error null ne {$error /newerror false put}if \   currentfile cvx stopped \;  $error null eq {false} {$error /newerror get} ifelse and \ %  {handleerror} if} stopped pop} def \   /xdvi$dslen countdictstack def \' {currentfile read not {exit} if 72 eq \    {xdvi$run} \    {/xdvi$sav save def xdvi$run \G    clear countdictstack xdvi$dslen sub {end} repeat xdvi$sav restore} \ 	  ifelse \ 9  {(%%xdvimark) currentfile xdvi$line {readline} stopped \ +   {clear} {pop eq {exit} if} ifelse }loop \   (xdvi$Ack\n) print flush \ 
 }loop\nH"; #else	/* SUNHACK */  static	char	preamble[]	= "\  /xdvi$line 81 string def \; /xdvi$run {{$error null ne {$error /newerror false put}if \   currentfile cvx stopped \;  $error null eq {false} {$error /newerror get} ifelse and \ %  {handleerror} if} stopped pop} def \   /xdvi$dslen countdictstack def \C /xdvi$ack {{(%%xdvimark) currentfile xdvi$line {readline} stopped \ ,    {clear} {pop eq {exit} if} ifelse }loop \&   (xdvi$Ack\n) print flush} bind def \C errordict begin /interrupt{(xdvi$Int\n) print flush stop}bind def \  end \ ( {{currentfile read not {exit} if 72 eq \    {xdvi$run} \ !    {/xdvi$sav save def xdvi$run \ H     clear countdictstack xdvi$dslen sub {end} repeat xdvi$sav restore} \
   ifelse \  xdvi$ack \   }loop \
 xdvi$ack \
 }loop\nH"; #endif	/* SUNHACK */   extern	char	psheader[];  extern	int	psheaderlen;   ' #define	postscript	resource._postscript     ) /* global procedures (besides initDPS) */   # static	void	toggleDPS ARGS((void)); $ static	void	destroyDPS ARGS((void));& static	void	interruptDPS ARGS((void));$ static	void	endpageDPS ARGS((void));2 static	void	drawbeginDPS ARGS((int, int, char *));& static	void	drawrawDPS ARGS((char *));7 static	void	drawfileDPS ARGS((_Xconst char *, FILE *)); & static	void	drawendDPS ARGS((char *));( static	void	beginheaderDPS ARGS((void));& static	void	endheaderDPS ARGS((void));# static	void	newdocDPS ARGS((void));   # static	struct psprocs	dps_procs = {  	/* toggle */		toggleDPS,  	/* destroy */		destroyDPS,  	/* interrupt */		interruptDPS,  	/* endpage */		endpageDPS,  	/* drawbegin */		drawbeginDPS,  	/* drawraw */		drawrawDPS,  	/* drawfile */		drawfileDPS,  	/* drawend */		drawendDPS, " 	/* beginheader */	beginheaderDPS, 	/* endheader */		endheaderDPS,  	/* newdoc */		newdocDPS};  ! static	DPSContext DPS_ctx = NULL; ! static	DPSSpace DPS_space = NULL; 9 static	int	DPS_mag;		/* magnification currently in use */ < static	int	DPS_shrink;		/* shrink factor currently in use */9 static	Boolean	DPS_active;		/* if we've started a page */ > static	int	DPS_pending;		/* number of ack's we're expecting */> static	Boolean	DPS_in_header;		/* if we're sending a header */B static	Boolean	DPS_in_doc;		/* if we've sent header information */     #if	0 " static	void	DPSErrorProcHandler(); #else / #define	DPSErrorProcHandler	DPSDefaultErrorProc  #endif    $ static	char	ackstr[]	= "xdvi$Ack\n";$ static	char	intstr[]	= "xdvi$Int\n";   #define	LINELEN	81) #define	BUFLEN	(LINELEN + sizeof(ackstr))  static	char	line[BUFLEN + 1];  static	char	*linepos	= line;   static	void  TextProc(ctxt, buf, count) 	DPSContext	ctxt;  	char		*buf; 	unsigned long	count;  {  	int	i; 	 	char	*p; 
 	char	*p0;   	while (count > 0) {! 	    i = line + BUFLEN - linepos;  	    if (i > count) i = count;# 	    (void) bcopy(buf, linepos, i);  	    linepos += i; 	    buf += i; 	    count -= i; 	    p0 = line;  	    for (;;) {  		if (p0 >= linepos) { 		    linepos = line;  		    break; 		} % 		p = memchr(p0, '\n', linepos - p0);  		if (p == NULL) { 		    if (p0 != line) { ( 			(void) bcopy(p0, line, linepos - p0); 			linepos -= p0 - line; 		    } * 		    else if (linepos == line + BUFLEN) {
 			char	c;   			c = line[LINELEN];  			line[LINELEN] = '\0'; 			Printf("DPS: %s\n", line);  			line[LINELEN] = c;  			linepos -= LINELEN;6 			(void) bcopy(line + LINELEN, line, linepos - line); 		    }  		    break; 		} 5 		if (p >= p0 + 8 && memcmp(p - 8, ackstr, 9) == 0) {  		    --DPS_pending; 		    if (debug & DBG_PS) 5 			Printf("Got DPS ack; %d pending.\n", DPS_pending); 
 		    ++p;* 		    (void) bcopy(p, p - 9, linepos - p); 		    linepos -= 9;  		    continue;  		}  #ifdef	SUNHACK5 		if (p >= p0 + 8 && memcmp(p - 8, intstr, 9) == 0) {  		    DPS_pending = 1; 		    if (debug & DBG_PS)  			Puts("Got DPS int.");
 		    ++p;* 		    (void) bcopy(p, p - 9, linepos - p); 		    linepos -= 9;  		    continue;  		}  #endif	/* SUNHACK */ 		*p = '\0'; 		Printf("DPS: %s\n", p0);
 		p0 = p + 1;  	    } 	} }     N /*---------------------------------------------------------------------------*   waitack()      Arguments: none.     Returns: (void)      Description:M   Waits until the requisite number of acknowledgements has been received from    the context.  O +----------------------------------------------------------------------------*/    static	void 	 waitack()  {  	while (DPS_pending > 0) {2 	    (void) XEventsQueued(DISP, QueuedAfterFlush); 	    allow_can = False;  	    read_events(False); 	    allow_can = True;< 	    if (DPS_ctx == NULL) break;	/* if interrupt occurred */ 	} }     N /*---------------------------------------------------------------------------*   initDPS()      Arguments: (none)    Returns: (void) E   Side-Effects: DPS_ctx may be set as well as other static variables.      Description:I   Initializes variables from the application main loop.  Checks to see if /   a connection to the DPS server can be opened.   O +----------------------------------------------------------------------------*/    Boolean 	 initDPS()  { #   /* now try to create a context */ A   DPS_ctx = XDPSCreateSimpleContext(DISP, mane.win, ruleGC, 0, 0, - 				    TextProc, DPSDefaultErrorProc, NULL);    if (DPS_ctx == NULL)     return False;      DPS_mag = DPS_shrink = -1;   DPS_active = False;l   DPS_pending = 1;  +   DPS_space = DPSSpaceFromContext(DPS_ctx);u>   DPSWritePostScript(DPS_ctx, preamble, sizeof(preamble) - 1);5   DPSWritePostScript(DPS_ctx, psheader, psheaderlen);m>   DPSPrintf(DPS_ctx, "matrix setmatrix stop\n%%%%xdvimark\n");   DPSFlushContext(DPS_ctx);s     psp = dps_procs;   return True; }c    N /*---------------------------------------------------------------------------*
   toggleDPS()h     Arguments: none    Returns: (void)i)   Side-Effects: psp.drawbegin is changed.r     Description:>   Used to toggle the rendering of PostScript by the DPS server  O +----------------------------------------------------------------------------*/S   static	voidT toggleDPS()T {T5   if (debug & DBG_PS) Puts("Toggling DPS on or off");S/   if (postscript) psp.drawbegin = drawbeginDPS;N   else {     interruptDPS();O#     psp.drawbegin = drawbegin_none;C   }D }C    N /*---------------------------------------------------------------------------*   destroyDPS()     Arguments: noneE   Returns: (void)C8   Side-Effects: the context is nulled out and destroyed.     Description:K   Close the connection to the DPS server; used when rendering is terminatedY
   in any way.U  O +----------------------------------------------------------------------------*/E   static	voidE destroyDPS() {I   if (debug & DBG_PS) !     Puts("Calling destroyDPS()");o   if (linepos > line) {r     *linepos = '\0';     Printf("DPS: %s\n", line);   }g   DPSDestroySpace(DPS_space);m   psp = no_ps_procs;7   scanned_page = scanned_page_bak = scanned_page_reset;p }a    N /*---------------------------------------------------------------------------*   interruptDPS()     Arguments: nonee   Returns: (void)e<   Side-Effects: the context may be nulled out and destroyed.     Description:K   Close the connection to the DPS server; used when rendering is terminatede@   because of an interruption in the viewing of the current page.  O +----------------------------------------------------------------------------*/    static	void  interruptDPS() {a #ifdef	SUNHACK&   static Boolean interrupting = False; #endif     if (debug & DBG_PS)e#     Puts("Running interruptDPS()");i   #ifndef	SUNHACKt   if (DPS_pending > 0) #else	/* SUNHACK */g'   if (DPS_pending > 0 && !interrupting)r #endif	/* SUNHACK */   {      if (debug & DBG_PS)\N       Printf("interruptDPS: code is now %d\n", XDPSGetContextStatus(DPS_ctx));       /*K      * I would really like to use DPSInterruptContext() here, but (at leasti,      * on an RS6000) I can't get it to work.      */r   #ifdef	SUNHACK     /*J      * On the other hand, under OpenWindows 3.3 (at least), destroying andE      * re-creating contexts has a nasty habit of crashing the server.i      */e       interrupting = True;!     DPSInterruptContext(DPS_ctx);*     DPS_pending = 32767;)     DPSPrintf(DPS_ctx, "%%%%xdvimark\n");\     DPSFlushContext(DPS_ctx);e     DPS_active = False;i     waitack();     interrupting = False;u #else	/* SUNHACK */      DPSDestroyContext(DPS_ctx);a     DPS_ctx = NULL;d     DPS_active = False;      DPS_pending = 0; #endif	/* SUNHACK */   }r }t    N /*---------------------------------------------------------------------------*   endpageDPS()     Arguments: none\   Returns: (void)i3   Side-Effects: the DPS_active variable is cleared.n     Description:M   Should be called at the end of a page to end this chunk for the DPS server.   O +----------------------------------------------------------------------------*/l   static	void  endpageDPS() {i   if (DPS_active) {e     if (debug & DBG_PS)e&       Puts("Endpage sent to context");/     DPSPrintf(DPS_ctx, "stop\n%%%%xdvimark\n");      DPSFlushContext(DPS_ctx);i     DPS_active = False;c     waitack();   }( }d    N /*---------------------------------------------------------------------------*   drawbeginDPS  ()  J   Arguments: xul, yul - coordinates of the upper left corner of the figure8              cp - string with the bounding box line data   Returns: (void) E   Side-Effects: DPS_ctx is set is set and connection to DPS server isa                 opened.t     Description:G   Opens a connection to the DPS server and send in the preamble and thesH   bounding box information after correctly computing resolution factors.:   In case no rendering is to be done, outlines the figure.I   An outline is also generated whenever the a context cannot be allocated/  O +----------------------------------------------------------------------------*/n   static	void  drawbeginDPS(xul, yul, cp)   int xul, yul;n   char *cp;  {t$   /* static char faulty_display_vs[];    * ="DECWINDOWS DigitalEquipmentCorporation UWS4.2LA"; */c     if (debug & DBG_PS) =     Printf("Begin drawing at xul= %d, yul= %d.\n", xul, yul);   H   /* we assume that I cannot write the file to the postscript context */   if (DPS_ctx == NULL) {C     DPS_ctx = XDPSCreateSimpleContext(DISP, mane.win, ruleGC, 0, 0,i3 				     TextProc, DPSErrorProcHandler, DPS_space);v     if (DPS_ctx == NULL) {       psp = no_ps_procs;       draw_bbox();
       return;f     }E@     DPSWritePostScript(DPS_ctx, preamble, sizeof(preamble) - 1);!     /* it already has psheader */n@     DPSPrintf(DPS_ctx, "matrix setmatrix stop\n%%%%xdvimark\n");     DPS_mag = DPS_shrink = -1;     DPS_active = False;t     DPS_pending = 1;   }      if (!DPS_active) {(     /* send initialization to context */#     if (magnification != DPS_mag) { > 	DPSPrintf(DPS_ctx, "H TeXDict begin /DVImag %d 1000 div def \ end stop\n%%%%xdvimark\n", 	    DPS_mag = magnification); 	++DPS_pending;c     },*     if (mane.shrinkfactor != DPS_shrink) {4 	DPSPrintf(DPS_ctx, "H TeXDict begin %d %d div dup \ /Resolution X /VResolution X \ end stop\n%%%%xdvimark\n",6 	    pixels_per_inch, DPS_shrink = mane.shrinkfactor); 	++DPS_pending;{     } +     DPSPrintf(DPS_ctx, " TeXDict begin\n");      DPS_active = True;     ++DPS_pending;   }   1   DPSPrintf(DPS_ctx, "%d %d moveto\n", xul, yul);	!   DPSPrintf(DPS_ctx, "%s\n", cp);n }I    N /*---------------------------------------------------------------------------*     drawrawDPS()  I   Arguments: cp - the raw string to be sent to the postscript interpreter    Returns: (void)    Side-Effects: (none)     Description:E   If there is a valid postscript context, just send the string to thed   interpreter, else leave.  O +----------------------------------------------------------------------------*/    static	void	 drawrawDPS(cp)   char *cp;= {    if (!DPS_active)     return;=     if (debug & DBG_PS) 2     Printf("Sending raw PS to context: %s\n", cp);     read_events(False);     DPSPrintf(DPS_ctx,"%s\n", cp); }     N /*---------------------------------------------------------------------------*   drawfileDPS()"  :   Arguments: cp - string with the postscript file pathname" 	     psfile - opened file pointer   Returns: (void)-   Side-Effects: none     Description:M   Postscript file containing the figure is opened and sent to the DPS server.   O +----------------------------------------------------------------------------*/-   static	void- drawfileDPS(cp, psfile)-   _Xconst char *cp;t   FILE *psfile;( {    char buffer[1025];   int blen;      if (!DPS_active) {     Fclose(psfile);;     ++n_files_left;l     return;a   }n     if (debug & DBG_PS)n$     Printf("sending file %s\n", cp);   allow_can = False;   for (;;) {     read_events(False);-I     if (canit || !DPS_active) break;	/* alt_canit is not a factor here */ 5     blen = fread(buffer, sizeof(char), 1024, psfile);f     if (blen == 0) break; .     DPSWritePostScript(DPS_ctx, buffer, blen);   }    Fclose(psfile);e   ++n_files_left;i   allow_can = True;    if (canit) {     interruptDPS();      longjmp(canit_env, 1);   }- }-    N /*---------------------------------------------------------------------------*   drawendDPS()  B   Arguments: cp - string with indication of the end of the special   Returns: (void)u   Side-Effects: none     Description:<   Sends the indication of end of the figure PostScript code.  O +----------------------------------------------------------------------------*/    static	voidS drawendDPS(cp)   char *cp;  {W   if (!DPS_active)     return;      if (debug & DBG_PS)      Printf("End PS: %s\n", cp);d   read_events(False);P    DPSPrintf(DPS_ctx,"%s\n", cp); }o    N /*---------------------------------------------------------------------------*   beginheaderDPS()     Arguments: none-   Returns: (void)-     Description:A   Prepares the PostScript interpreter for receipt of header code.d  O +----------------------------------------------------------------------------*/t   static	void  beginheaderDPS() { 7   if (debug & DBG_PS) Puts("Running beginheaderDPS()");-     if (DPS_active) {-     if (!DPS_in_header) 4       oops("Internal error in beginheaderDPS().\n");     return;f   }      DPS_in_header = True;e   if (DPS_in_doc)N     DPSPrintf(DPS_ctx, "H");   else {5     DPSPrintf(DPS_ctx, "Hsave /xdvi$doc exch def\n");-     DPS_in_doc = True;   }-   DPS_active = True;   ++DPS_pending; }e    N /*---------------------------------------------------------------------------*   endheaderDPS()     Arguments: nonet   Returns: (void)o     Description:A   Prepares the PostScript interpreter for receipt of header code.-  O +----------------------------------------------------------------------------*/t   static	voido endheaderDPS() {e!   static	_Xconst	char	str[]	= "";e  5   if (debug & DBG_PS) Puts("Running endheaderDPS()");'     if (DPS_active) {%/     DPSPrintf(DPS_ctx, "stop\n%%%%xdvimark\n");m     DPS_active = False;      DPS_in_header = False;     DPSFlushContext(DPS_ctx);      waitack();   }- }-    N /*---------------------------------------------------------------------------*
   newdocDPS()      Arguments: nonei   Returns: (void)t     Description:7   Clears out headers stored from the previous document.i  O +----------------------------------------------------------------------------*/i   static	voidn newdocDPS()e {p2   if (debug & DBG_PS) Puts("Running newdocDPS()");     if (DPS_in_doc) {-B     DPSPrintf(DPS_ctx, "H xdvi$doc restore stop\n%%%%xdvimark\n");     ++DPS_pending;     DPS_mag = DPS_shrink = -1;     DPS_in_doc = False;u   }u }n