 /*7  * Copyright (c) 1994 Paul Vojta.  All rights reserved.   *E  * Redistribution and use in source and binary forms, with or without E  * modification, are permitted provided that the following conditions   * are met: D  * 1. Redistributions of source code must retain the above copyrightC  *    notice, this list of conditions and the following disclaimer. G  * 2. Redistributions in binary form must reproduce the above copyright I  *    notice, this list of conditions and the following disclaimer in the J  *    documentation and/or other materials provided with the distribution.  *I  * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND H  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THEM  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE J  * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLEM  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL J  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODSH  * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)M  * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT L  * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAYI  * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF   * SUCH DAMAGE.   *	  * NOTES: ;  *	This code was originally written by Ricardo Telichevesky 6  *	(ricardo@rle-vlsi-mit.edu) and Luis Miguel Silveira  *	(lms@rle-vlsi-mit.edu).?  *	It was largely influenced by similar code in the SeeTeX/XTeX 4  *	package by Dirk Grunwald (grunwald@colorado.edu).  */   
 /* ||| To do: "  *	ALWAYS_CLOSE_SERVER_CONNECTION?/  *	Is there some way of interrupting a process?   *	fork   *	extra bytes on input   */    #include "xdvi.h"  #include <memory.h>  #include <signal.h>  #include <X11/X.h> #include <X11/Xlib.h>  #include <NeWS/psio.h> #include <xvps/pscanvas.h>  8 /* if POSIX O_NONBLOCK is not available, use O_NDELAY */- #if !defined(O_NONBLOCK) && defined(O_NDELAY)  #define	O_NONBLOCK O_NDELAY  #endif  $ /* Condition for retrying a write */ #include <errno.h>   #ifdef	X_NOT_STDC_ENV  extern	int	errno;  #endif   #ifdef	EWOULDBLOCK
 #ifdef	EAGAIN A #define	AGAIN_CONDITION	(errno == EWOULDBLOCK || errno == EAGAIN)  #else	/* EAGAIN */. #define	AGAIN_CONDITION	(errno == EWOULDBLOCK) #endif	/* EAGAIN */  #else	/* EWOULDBLOCK */ 
 #ifdef	EAGAIN ) #define	AGAIN_CONDITION	(errno == EAGAIN)  #endif	/* EAGAIN */  #endif	/* EWOULDBLOCK */   #ifdef	STREAMSCONN #include <poll.h>  #endif  
 #if	HAS_SIGIO  #include <signal.h>  #ifndef	FASYNC #undef	HAS_SIGIO #define	HAS_SIGIO 0  #endif #endif   #if	NeedFunctionPrototypes% char	*strtok(char *, _Xconst char *);  #else  char	*strtok();  #endif   #define	Fprintf	(void) fprintf    H /* define ALWAYS_CLOSE_SERVER_CONNECTION if you want to close the server    connection all the time */ % #undef	ALWAYS_CLOSE_SERVER_CONNECTION      		/* 		 * Some setup code.  		 */  static	_Xconst	char	str0[]	= "\  /OW2? version cvi 2 eq def \ OW2? \ { /setlinewidth { pop } def} \& { /NeWS 3 0 findpackage beginpackage \&   /X11 3 0 findpackage beginpackage} \ ifelse \ currentcanvas /Color get \< currentcanvas /Colormap get getcubedescription null eq and \J    {8 {{currentcanvas /Colormap get 1 index dup dup dup newcube} stopped \)     {pop pop pop pop pop} {exit} ifelse \ -     2 div cvi dup 1 eq {exit} if} loop pop} \  if\n"; 		/*8 		 * This string reads chunks (delimited by %%xdvimark).? 		 * The first character of a chunk tells whether a given chunk . 		 * is to be done within save/restore or not.: 		 * The `H' at the end tells it that the first group is a# 		 * header; i.e., no save/restore.  		 */ # static	_Xconst	char	preamble[]	= "\  /xdvi$line 81 string def \; /xdvi$run {$error null ne {$error /newerror false put} if \   {currentfile cvx stopped \ ;  $error null eq {false} {$error /newerror get} ifelse and \ %  {handleerror} if} stopped pop} def \   /xdvi$dslen countdictstack def \' {currentfile read not {exit} if 72 eq \      {xdvi$run} \"     {/xdvi$sav save def xdvi$run \J       clear countdictstack xdvi$dslen sub {end} repeat xdvi$sav restore} \
   ifelse \:   {(%%xdvimark) currentfile xdvi$line {readline} stopped \N     {clear} {{eq {false exit} if} {true exit} ifelse} ifelse }loop {exit} if \   58 tagprint flush \ 
 }loop\nH";   extern	_Xconst	char	psheader[];  extern	int	psheaderlen;   8 static	_Xconst	char	preamble2[]	= " stop\n%%xdvimark\n"; #define	stopstring	preamble2  ' #define	postscript	resource._postscript     * /* global procedures (besides initNeWS) */  $ static	void	toggleNeWS ARGS((void));% static	void	destroyNeWS ARGS((void)); ' static	void	interruptNeWS ARGS((void)); % static	void	endpageNeWS ARGS((void)); 3 static	void	drawbeginNeWS ARGS((int, int, char *)); ' static	void	drawrawNeWS ARGS((char *)); 8 static	void	drawfileNeWS ARGS((_Xconst char *, FILE *));' static	void	drawendNeWS ARGS((char *)); ) static	void	beginheaderNeWS ARGS((void)); ' static	void	endheaderNeWS ARGS((void)); $ static	void	newdocNeWS ARGS((void));  $ static	struct psprocs	news_procs = { 	/* toggle */		toggleNeWS, 	/* destroy */		destroyNeWS,  	/* interrupt */		interruptNeWS, 	/* endpage */		endpageNeWS,  	/* drawbegin */		drawbeginNeWS, 	/* drawraw */		drawrawNeWS, 	/* drawfile */		drawfileNeWS, 	/* drawend */		drawendNeWS,# 	/* beginheader */	beginheaderNeWS,   	/* endheader */		endheaderNeWS, 	/* newdoc */		newdocNeWS};   - /* signal handler to hairy PostScript code */ # static void psio_sigpipe_handler();   # /* define local static variables */ : static	int	NeWS_mag;		/* magnification currently in use */= static	int	NeWS_shrink;		/* shrink factor currently in use */ B static	unsigned int	NeWS_page_w;	/* how big our current page is */  static	unsigned int	NeWS_page_h;> static	Boolean	NeWS_active;		/* if we've started a page yet */? static	int	NeWS_pending;		/* number of ack's we're expecting */ : static	int	NeWS_sending;		/* level of nesting in send() */? static	Boolean	NeWS_in_header;		/* if we're sending a header */ C static	Boolean	NeWS_in_doc;		/* if we've sent header information */ I static	Boolean	NeWS_pending_int;	/* if interrupt rec'd while in send() */ & static	Boolean	NeWS_destroyed	= False;     /*4  *	NeWS I/O code.  This should send PS code to NeWS,B  *	receive acknowledgements, and receive X events in the meantime.%  *	It also checks for SIGPIPE errors.   */    #ifndef	STREAMSCONN  static	int		numfds;  static	fd_set		readfds;  static	fd_set		writefds;* #define	XDVI_ISSET(a, b, c)	FD_ISSET(a, b) #else	/* STREAMSCONN */ ) struct pollfd		fds[3] = {{0, POLLOUT, 0},  				  {0, POLLIN, 0},  				  {0, POLLIN, 0}};, #define	XDVI_ISSET(a, b, c)	(fds[c].revents) #endif	/* STREAMSCONN */    N /*---------------------------------------------------------------------------*   psio_sigpipe_handler  ()  ;   Arguments: sig, code, scp, addr (see man page for signal)    Returns: (void) K   Side-Effects: SIGPIPE signal is flagged as sigpipe_error variable is set.      Description:H   Handler for SIGPIPE error generated by a broken pipe in the connectionJ   to the NeWS server; this may be duer to some abnormal condition, or someJ   hairy PostScript code containing commands not implemented by the server.  O +----------------------------------------------------------------------------*/   % static	Boolean	sigpipe_error = False;   4 static	struct sigaction psio_sigpipe_handler_struct;I 	/* initialized to {psio_sigpipe_handler, (sigset_t) 0, 0} in initNeWS */    /* ARGSUSED */ static	void * psio_sigpipe_handler(sig, code, scp, addr)
 	int		sig; 	int		code;  	struct sigcontext *scp;
 	char		*addr;  {  	sigpipe_error = True; }      /*H  *	read_from_NeWS - This does the actual retrieving of acknowledgements.-  *	If other bytes appear on the file - tough.   */    static	void  read_from_NeWS() {  	for (;;) {  	    int retval;  > 	    retval = ps_checkfor(PostScriptInput, PSIO_FIND_TAG, 58); 	    if (retval == 0) break; 	    if (retval < 0) {6 		Fprintf(stderr, "[xdvi] ps_checkfor: %d\n", retval);	 		return;l 	    }< 	    (void) ps_checkfor(PostScriptInput, PSIO_WAIT_TAG, 58); 	    --NeWS_pending; 	    if (debug & DBG_PS)6 		Printf("Got NeWS ack; %d pending.\n", NeWS_pending); 	} }*     /*  *	Clean up after send()  */u   static	voide post_send()e {p 	if (sigpipe_error) {h0 	    Fputs("NeWS died unexpectedly.\n", stderr); 	    destroyNeWS();i 	    draw_bbox();m 	}   	if (NeWS_pending_int) { 	    NeWS_pending_int = False; 	    interruptNeWS();w 	} }c     /*)  *	This actually sends the bytes to NeWS.t  */s   static	voidt
 send(cp, len). 	_Xconst	char	*cp;
 	int		len; {B 	struct sigaction orig;T #ifdef	STREAMSCONN 	int	retval; #endif  + 	if (PostScript == (PSFILE *) NULL) return;T   	if (!NeWS_sending) { D 	    (void) sigaction(SIGPIPE, &psio_sigpipe_handler_struct, &orig); 	    sigpipe_error = False;  	} 	++NeWS_sending;  
 #if	HAS_SIGIOR. 	(void) fcntl(ConnectionNumber(DISP), F_SETFL,: 	    fcntl(ConnectionNumber(DISP), F_GETFL, 0) & ~FASYNC); #endif   #ifndef	STREAMSCONNU 	FD_ZERO(&readfds);C 	FD_ZERO(&writefds); #endif   	for (;;) {S   #ifndef	STREAMSCONNV. 	    FD_SET(ConnectionNumber(DISP), &readfds);) 	    FD_SET(PostScript->file, &writefds);R- 	    FD_SET(PostScriptInput->file, &readfds);N  = 	    if (select(numfds, &readfds, &writefds, (fd_set *) NULL,T7 		    (struct timeval *) NULL) < 0 && errno != EINTR) {T$ 		perror("select (xdvi NeWS_send)"); 		break; 	    } #else	/* STREAMSCONN */t 	    for (;;) {g( 		retval = poll(fds, XtNumber(fds), -1);, 		if (retval >= 0 || errno != EAGAIN) break; 	    } 	    if (retval < 0) {" 		perror("poll (xdvi NeWS_send)"); 		break; 	    } #endif	/* STREAMSCONN */  8 	    if (XDVI_ISSET(PostScriptInput->file, &readfds, 1)) 		read_from_NeWS(); 6 	    if (XDVI_ISSET(PostScript->file, &writefds, 0)) { 		int	old_flags; 		int	bytes;  2 		old_flags = fcntl(PostScript->file, F_GETFL, 0); 		if (old_flags < 0) break;u 		/* set to be non-blocking */> 		if (fcntl(PostScript->file, F_SETFL, old_flags | O_NONBLOCK) 			< 0)) 		    break;+ 		bytes = write(PostScript->file, cp, len);f 		if (bytes == -1) {5 		    if (!AGAIN_CONDITION) perror("xdvi NeWS_send");S 		}N 		else { 		    cp += bytes; 		    len -= bytes;K 		}d= 		if (fcntl(PostScript->file, F_SETFL, old_flags) < 0) break;r' 		if (len == 0 || sigpipe_error) break;n 	    }; 	    if (XDVI_ISSET(ConnectionNumber(DISP), &readfds, 2)) {	 		allow_can = False; 		read_events(False);G 		allow_can = True;=E 		if (PostScript == (PSFILE *) NULL) break;	/* if timeout occurred */R 	    } 	}  
 #if	HAS_SIGIO . 	(void) fcntl(ConnectionNumber(DISP), F_SETFL,9 	    fcntl(ConnectionNumber(DISP), F_GETFL, 0) | FASYNC);d #endif   	if (--NeWS_sending == 0) {s/ 	    /* put back generic handler for SIGPIPE */ A 	    (void) sigaction(SIGPIPE, &orig, (struct sigaction *) NULL);d  & 	    if (!NeWS_in_header) post_send(); 	} }t   /*G  *	Wait for acknowledgement from NeWS.  With NeWS we have no choice butC  *	to wait (||| I think).S  */e   static	void*	 waitack()_ {n #ifdef	STREAMSCONN 	int	retval; #endif
 #if	HAS_SIGIO\ 	int	oldflags; #endif  + 	if (PostScript == (PSFILE *) NULL) return;\  
 #if	HAS_SIGIOp6 	oldflags = fcntl(ConnectionNumber(DISP), F_GETFL, 0);C 	(void) fcntl(ConnectionNumber(DISP), F_SETFL, oldflags & ~FASYNC);  #endif #ifndef	STREAMSCONN  	FD_ZERO(&readfds);u #endif 	while (NeWS_pending > 0) {p #ifndef	STREAMSCONNs. 	    FD_SET(ConnectionNumber(DISP), &readfds);- 	    FD_SET(PostScriptInput->file, &readfds);kC 	    if (select(numfds, &readfds, (fd_set *) NULL, (fd_set *) NULL,l7 		    (struct timeval *) NULL) < 0 && errno != EINTR) {r' 		perror("select (xdvi NeWS_waitack)");e 		break; 	    } #else	/* STREAMSCONN */e 	    for (;;) {r0 		retval = poll(fds + 1, XtNumber(fds) - 1, -1);, 		if (retval >= 0 || errno != EAGAIN) break; 	    } 	    if (retval < 0) {% 		perror("poll (xdvi NeWS_waitack)");p 		break; 	    } #endif	/* STREAMSCONN */    8 	    if (XDVI_ISSET(PostScriptInput->file, &readfds, 1)) 		read_from_NeWS();d; 	    if (XDVI_ISSET(ConnectionNumber(DISP), &readfds, 2)) {  		allow_can = False; 		read_events(False);n 		allow_can = True;dE 		if (PostScript == (PSFILE *) NULL) break;	/* if timeout occurred */  	    } 	}
 #if	HAS_SIGIOd9 	(void) fcntl(ConnectionNumber(DISP), F_SETFL, oldflags);  #endif }x    N /*---------------------------------------------------------------------------*   initNeWS()     Arguments: None.7   Returns: True if and only if initialization succeededp,   Side-Effects: Static variables may be set.     Description:6   Initializes variables for the application main loop.  O +----------------------------------------------------------------------------*/    Boolean)
 initNeWS() {	 	static	NeWStoken newstoken;  8 	/* now try to open the connection to the NeWS server */- 	if (ps_open_PostScript() == (PSFILE *) NULL)r 	    return False;   #ifndef	STREAMSCONNw! 	numfds = ConnectionNumber(DISP); : 	if (numfds < PostScript->file) numfds = PostScript->file;D 	if (numfds < PostScriptInput->file) numfds = PostScriptInput->file;
 	++numfds; #else	/* STREAMSCONN */) 	fds[0].fd = PostScript->file;# 	fds[1].fd = PostScriptInput->file;,$ 	fds[2].fd = ConnectionNumber(DISP); #endif	/* STREAMSCONN */  ? 	psio_sigpipe_handler_struct.sa_handler = psio_sigpipe_handler;/3 	sigemptyset(&psio_sigpipe_handler_struct.sa_mask);N  ( 	NeWS_active = NeWS_pending_int = False; 	NeWS_sending = 0; 	NeWS_in_header = True;/ 	NeWS_pending = 1;   	ps_flush_PostScript();  	send(str0, sizeof(str0) - 1);? 	/* get xid of window, then make this window the NeWS canvas */n0 	(void) ps_token_from_xid(mane.win, &newstoken); 	if (newstoken != -1) {t 	    ps_setcanvas(newstoken);h 	    ps_flush_PostScript();n* 	    send(preamble, sizeof(preamble) - 1);! 	    send(psheader, psheaderlen); , 	    send(preamble2, sizeof(preamble2) - 1); 	    NeWS_in_header = False; 	    post_send();e 	    waitack();N 	}  " 	if (NeWS_destroyed) return False;   	/* success */   	NeWS_mag = NeWS_shrink = -1;e 	NeWS_page_w = page_w; 	NeWS_page_h = page_h;   	psp = news_procs;= 	if (!postscript) toggleNeWS();	/* if we got a 'v' already */e  
 	return True;* }     N /*---------------------------------------------------------------------------*   toggleNeWS()     Arguments: none*   Returns: (void) (   Side-Effects: psp.drawbegin is changed     Description:?   Used to toggle the rendering of PostScript by the NeWS server   O +----------------------------------------------------------------------------*/	   static	voidt toggleNeWS() {d/ 	if (postscript) psp.drawbegin = drawbeginNeWS;e 	else {R 	    interruptNeWS();l$ 	    psp.drawbegin = drawbegin_none; 	} }O    N /*---------------------------------------------------------------------------*   destroyNeWS()N     Arguments: none-   Returns: (void)-6   Side-Effects: the pointer to the NeWS file is nulled     Description:L   Close the connection to the NeWS server; used when rendering is terminated
   in any way.E  O +----------------------------------------------------------------------------*/o   static	voido
 destroyNeWS()  {e 	psp = no_ps_procs;e 	NeWS_destroyed = True;t6 	scanned_page = scanned_page_bak = scanned_page_reset; },    N /*---------------------------------------------------------------------------*   interruptNeWS()-     Arguments: none-   Returns: void-     Description:L   Close the connection to the NeWS server; used when rendering is terminated@   because of an interruption in the viewing of the current page.L   ||| It would be nice if we could asynchronously ``wake up'' a NeWS processH   (preferably by sending something along the X socket); then we could do   better than just to wait.   O +----------------------------------------------------------------------------*/t   static	voido interruptNeWS()I {t5 	if (debug & DBG_PS) Puts("Running interruptNeWS()");v+ 	if (NeWS_sending) NeWS_pending_int = True;  	else {a 	    if (NeWS_active) {e+ 		send(stopstring, sizeof(stopstring) - 1);  		NeWS_active = False; 	    }F 	    psp.interrupt = NullProc;	/* prevent deep recursion in waitack */ 	    waitack(); # 	    psp.interrupt = interruptNeWS;i 	} },    N /*---------------------------------------------------------------------------*   endpageNeWS()i     Arguments: none;   Returns: (void)*4   Side-Effects: the NeWS_active variable is cleared.     Description:N   Should be called at the end of a page to end this chunk for the NeWS server.  O +----------------------------------------------------------------------------*/    static	voidt
 endpageNeWS()  {  	if (debug & DBG_PS)) 	    Puts("endpage sent to NeWS Server");t 	if (NeWS_active) {l. 	    send(stopstring, sizeof(stopstring) - 1); 	    NeWS_active = False;S 	    waitack();r 	} }     N /*---------------------------------------------------------------------------*   drawbeginNeWS  ()I  J   Arguments: xul, yul - coordinates of the upper left corner of the figure1 	     cp - string with the bounding box line data(   Returns: (void)S     Description:H   Opens a connection to the NeWS server and send in the preamble and theH   bounding box information after correctly computing resolution factors.I   In case no rendering is to be done, outlines the figure.  An outline issH   also generated whenever the PostScript code is too hairy and generates   a SIGPIPE signal.   O +----------------------------------------------------------------------------*/e   static	void0 drawbeginNeWS(xul, yul, cp)r 	int		xul, yul;N 	char		*cp;  {r 	char	buf[100];s0 	static	_Xconst	char	str[]	= " TeXDict begin\n";A 	static	_Xconst	char	str2[]	= "Hinitgraphics stop\n%%xdvimark\n";N   	if (debug & DBG_PS) {+ 	    Printf("xul= %d yul= %d\n", xul, yul);d% 	    Printf("String = < %s >\n", cp);M 	}   	/* catch up on the X side */c 	XSync(DISP, False);   	if (!NeWS_active) {- 	    /* send initialization to NeWS server */w8 	    if (NeWS_page_w < page_w || NeWS_page_h < page_h) { 		NeWS_page_w = page_w;i 		NeWS_page_h = page_h;l 		send(str2, sizeof(str2) - 1);  		++NeWS_pending;  	    }% 	    if (magnification != NeWS_mag) {s9 		Sprintf(buf, "H TeXDict begin /DVImag %d 1000 div def \t end stop\n%%%%xdvimark\n",  		    NeWS_mag = magnification); 		send(buf, strlen(buf));N 		++NeWS_pending;  	    }, 	    if (mane.shrinkfactor != NeWS_shrink) {/ 		Sprintf(buf, "H TeXDict begin %d %d div dup \a /Resolution X /VResolution X \ end stop\n%%%%xdvimark\n",8 		    pixels_per_inch, NeWS_shrink = mane.shrinkfactor); 		send(buf, strlen(buf));a 		++NeWS_pending;( 	    }  	    send(str, sizeof(str) - 1); 	    NeWS_active = True; 	    ++NeWS_pending; 	}  * 	Sprintf(buf, "%d %d moveto\n", xul, yul); 	send(buf, strlen(buf)); 	send(cp, strlen(cp)); }C    N /*---------------------------------------------------------------------------*   drawrawNeWS()a  M   Arguments: origcp - the raw string to be sent to the postscript interpreter    Returns: (void)d   Side-Effects: (none)     Description:L   If there is a valid connection to the NeWS server, just send the string to   the interpreter, else leave.  O +----------------------------------------------------------------------------*/d   static	voidI drawrawNeWS(origcp)e 	char	*origcp; {r 	char		*pt, *ptm1, *cp1, *ocp1;  	static	char	*cp;o 	static	unsigned int cplen = 0;D 	unsigned int	len; 	double		angle;n 	Boolean		found	= False;   	if (!NeWS_active) 	    return;   	if (debug & DBG_PS)6 	    Printf("Raw PS sent to context: <%s>\n", origcp);  A 	/* take a look at the string:  NeWS bums on certain rotations */  	len = strlen(origcp) + 4; 	if (cplen < len) {  	    if (cplen != 0) free(cp); 	    cplen = len;d2 	    cp = xmalloc(cplen, "string in drawrawNeWS"); 	} 	ocp1 = origcp; 
 	pt = origcp;t( 	while (*pt == ' ' || *pt == '\t') ++pt;
 	cp1 = cp; 	for (;;) {e 	    ptm1 = pt;r; 	    while (*pt != '\0' && *pt != ' ' && *pt != '\t') ++pt;v 	    if (*pt == '\0') break;, 	    while (*pt == ' ' || *pt == '\t') ++pt;& 	    if (strncmp(pt, "rotate", 6) == 0< 		    && (pt[6] == '\0' || pt[6] == ' ' || pt[6] == '\t')) {! 		/* found rotate; check angle */ ) 		if (sscanf(ptm1, "%lf", &angle) >= 1) {o 		    found = True;  		    while (angle > 360.0)  			angle -= 360; 		    while (angle < -360.0) 			angle += 360; 		    if (angle == 90.0) { 			angle = 89.999;) 			(void) memcpy(cp1, ocp1, ptm1 - ocp1);( 			cp1 += ptm1 - ocp1;! 			Strcpy(cp1, "89.999 rotate ");e 			cp1 += strlen(cp1);9 			while (*pt != '\0' && *pt != ' ' && *pt != '\t') ++pt;-* 			while (*pt == ' ' || *pt == '\t') ++pt;
 			ocp1 = pt;u" 		    } else if (angle == -90.0) { 			angle = -89.999;s) 			(void) memcpy(cp1, ocp1, ptm1 - ocp1);t 			cp1 += ptm1 - ocp1;" 			Strcpy(cp1, "-89.999 rotate "); 			cp1 += strlen(cp1);9 			while (*pt != '\0' && *pt != ' ' && *pt != '\t') ++pt; * 			while (*pt == ' ' || *pt == '\t') ++pt;
 			ocp1 = pt;   		    } else if (angle == 0.0) {) 			(void) memcpy(cp1, ocp1, ptm1 - ocp1);S 			cp1 += ptm1 - ocp1;9 			while (*pt != '\0' && *pt != ' ' && *pt != '\t') ++pt; * 			while (*pt == ' ' || *pt == '\t') ++pt;
 			ocp1 = pt;u 		    }s 		}p 	    } 	} 	Strcpy(cp1, ocp1);t! 	if ((debug & DBG_PS) && found) {u( 	    Printf("String is now <%s>\n", cp);C 	    Printf("Found rotate string.  Angle is %g degrees.\n", angle);i 	}   	len = strlen(cp); 	cp[len] = '\n'; 	send(cp, len + 1);  }     N /*---------------------------------------------------------------------------*   drawfileNeWS()  :   Arguments: cp - string with the postscript file pathname# 	     psfile - file, already opened    Returns: (void)d   Side-Effects: none     Description:N   Postscript file containing the figure is opened and sent to the NeWS server.B   Figure is outlined in case hairy code produces a SIGPIPE signal.  O +----------------------------------------------------------------------------*/n   static	voida drawfileNeWS(cp, psfile) 	_Xconst char	*cp; 	FILE		*psfile;  {  	char		buffer[1025]; 	int		blen;) 	int		bytes; 	struct sigaction orig;    	if (!NeWS_active) { 	    Fclose(psfile); 	    ++n_files_left; 	    return; 	}   	if (debug & DBG_PS)& 	    Printf("printing file %s\n", cp);@ 	/* some hairy PS code generates SIGPIPE signals; handle them */@ 	(void) sigaction(SIGPIPE, &psio_sigpipe_handler_struct, &orig); 	sigpipe_error = False;- 	NeWS_sending = 1; 	if (!sigpipe_error) 	    for (;;) {*3 		blen = fread(buffer, sizeof(char), 1024, psfile);o 		if (blen == 0) break;. 		send(buffer, blen);  		if (sigpipe_error) break;g 	    } 	Fclose(psfile); 	++n_files_left;   	--NeWS_sending;+ 	/* put back generic handler for SIGPIPE */-= 	(void) sigaction(SIGPIPE, &orig, (struct sigaction *) NULL);    	if (sigpipe_error) {n0 	    Fputs("NeWS died unexpectedly.\n", stderr); 	    destroyNeWS();n 	    draw_bbox();  	}   	if (NeWS_pending_int) { 	    NeWS_pending_int = False; 	    interruptNeWS();- 	} }e    N /*---------------------------------------------------------------------------*   drawendNeWS()i  B   Arguments: cp - string with indication of the end of the special   Returns: (void)g     Description:<   Sends the indication of end of the figure PostScript code.  O +----------------------------------------------------------------------------*/s   static	void_ drawendNeWS(cp)t
 	char	*cp; {  	if (!NeWS_active) 	    return;   	if (debug & DBG_PS)) 	    Puts("drawend sent to NeWS Server");- 	send(cp, strlen(cp)); 	send("\n", 1);W }-    N /*---------------------------------------------------------------------------*   beginheaderNeWS()e     Arguments: nonee   Returns: (void)      Description:A   Prepares the PostScript interpreter for receipt of header code.c  O +----------------------------------------------------------------------------*/a   static	voide beginheaderNeWS()o { : 	static	_Xconst	char	str[]	= "Hsave /xdvi$doc exch def\n";  7 	if (debug & DBG_PS) Puts("Running beginheaderNeWS()");c   	if (NeWS_active) {I 	    if (!NeWS_in_header)P1 		oops("Internal error in beginheaderNeWS().\n");) 	    return; 	}   	NeWS_in_header = True;  	if (NeWS_in_doc)	 	    send("H", 1); 	else {t  	    send(str, sizeof(str) - 1); 	    NeWS_in_doc = True; 	} 	NeWS_active = True; 	++NeWS_pending; }a    N /*---------------------------------------------------------------------------*   endheaderNeWS()-     Arguments: none-   Returns: (void)-     Description:A   Prepares the PostScript interpreter for receipt of header code.s  O +----------------------------------------------------------------------------*/    static	voido endheaderNeWS()o {h2 	static	_Xconst	char	str[]	= "stop\n%%xdvimark\n";  5 	if (debug & DBG_PS) Puts("Running endheaderNeWS()");v   	if (NeWS_active) {   	    send(str, sizeof(str) - 1); 	    NeWS_active = False;r 	    NeWS_in_header = False; 	    post_send();  	    waitack();) 	} }     N /*---------------------------------------------------------------------------*   newdocNeWS()     Arguments: none-   Returns: (void)r     Description:7   Clears out headers stored from the previous document.o  O +----------------------------------------------------------------------------*/(   static	voidc newdocNeWS() {  	static	_Xconst	char	str[]	=, 				"H xdvi$doc restore stop\n%%xdvimark\n";  2 	if (debug & DBG_PS) Puts("Running newdocNeWS()");   	send(str, sizeof(str) - 1); 	++NeWS_pending; 	NeWS_mag = NeWS_shrink = -1;i 	NeWS_in_doc = False;e }e