 /*7  * Copyright (c) 1994 Paul Vojta.  All rights reserved.   *E  * Redistribution and use in source and binary forms, with or without E  * modification, are permitted provided that the following conditions   * are met: D  * 1. Redistributions of source code must retain the above copyrightC  *    notice, this list of conditions and the following disclaimer. G  * 2. Redistributions in binary form must reproduce the above copyright I  *    notice, this list of conditions and the following disclaimer in the J  *    documentation and/or other materials provided with the distribution.  *I  * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND H  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THEM  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE J  * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLEM  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL J  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODSH  * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)M  * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT L  * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAYI  * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF   * SUCH DAMAGE.   *  * NOTE:5  *	This module is based on prior work as noted below.   */    /*.  * Support drawing routines for TeXsun and TeX  *7  *      Copyright, (C) 1987, 1988 Tim Morgan, UC Irvine 1  *	Adapted for xdvi by Jeffrey Lee, U. of Toronto   *H  * At the time these routines are called, the values of hh and vv shouldH  * have been updated to the upper left corner of the graph (the positionI  * the \special appears at in the dvi file).  Then the coordinates in the J  * graphics commands are in terms of a virtual page with axes oriented the0  * same as the Imagen and the SUN normally have:  *  *                      0,0 )  *                       +-----------> +x   *                       |  *                       |  *                       |  *                      \ /   *                       +y   *C  * Angles are measured in the conventional way, from +x towards +y. A  * Unfortunately, that reverses the meaning of "counterclockwise" &  * from what it's normally thought of.  *C  * A lot of floating point arithmetic has been converted to integer E  * arithmetic for speed.  In some places, this is kind-of kludgy, but   * it's worth it.   */    #include <math.h>  #include <ctype.h>   #include "xdvi.h"   3 extern	char	*strtok ARGS((char *, _Xconst char *));    #ifdef	X_NOT_STDC_ENV  #ifndef	atof* extern	double	atof ARGS((_Xconst char *)); #endif  + extern	char	*getenv ARGS((_Xconst char *));  #endif	/* X_NOT_STDC_ENV */    #if	PS #ifdef	_POSIX_SOURCE #include <limits.h>  #ifdef	PATH_MAX  #define	FILENAMESIZE	PATH_MAX  #endif #endif   #ifndef	FILENAMESIZE #define	FILENAMESIZE 512 #endif   #ifdef	VFORK #if	VFORK == include #include <vfork.h> #endif #else  #define	vfork	fork #endif   #include <sys/stat.h>  #include <sys/wait.h>  #include <errno.h>   #ifdef	X_NOT_STDC_ENV  extern	int	errno;  #endif #endif	/* PS */   0 #define	MAXPOINTS	300	/* Max points in a path */" #define	TWOPI		(3.14159265359*2.0)4 #define	MAX_PEN_SIZE	7	/* Max pixels of pen width */    C static	int	xx[MAXPOINTS], yy[MAXPOINTS];	/* Path in milli-inches */ 7 static	int	path_len = 0;	/* # points in current path */ 9 static	int	pen_size = 1;	/* Pixel width of lines drawn */    static	Boolean	whiten = False; static	Boolean	shade = False;  static	Boolean	blacken = False;   9 /* Unfortunately, these values also appear in dvisun.c */ 3 #define	xRESOLUTION	(pixels_per_inch/shrink_factor) 3 #define	yRESOLUTION	(pixels_per_inch/shrink_factor)      /*  *	Issue warning messages   */    static	void  Warning(fmt, msg)  	char	*fmt, *msg;  {  	Fprintf(stderr, "%s: ", prog);  	Fprintf(stderr, fmt, msg);  	(void) fputc('\n', stderr); }      /*  *	X drawing routines   */   $ #define	toint(x)	((int) ((x) + 0.5))= #define	xconv(x)	(toint(tpic_conv*(x))/shrink_factor + PXL_H) = #define	yconv(y)	(toint(tpic_conv*(y))/shrink_factor + PXL_V)    /*'  *	Draw a line from (fx,fy) to (tx,ty). !  *	Right now, we ignore pen_size.   */  static	void  line_btw(fx, fy, tx, ty) int fx, fy, tx, ty;  {  	register int	fcx = xconv(fx), 			tcx = xconv(tx),  			fcy = yconv(fy),  			tcy = yconv(ty);   F 	if ((fcx < max_x || tcx < max_x) && (fcx >= min_x || tcx >= min_x) &&D 	    (fcy < max_y || tcy < max_y) && (fcy >= min_y || tcy >= min_y))& 		XDrawLine(DISP, currwin.win, ruleGC,1 		    fcx - currwin.base_x, fcy - currwin.base_y, 2 		    tcx - currwin.base_x, tcy - currwin.base_y); }    /*  *	Draw a dot at (x,y)  */  static	void  dot_at(x, y)
 	int	x, y; {  	register int	cx = xconv(x), 			cy = yconv(y);   < 	if (cx < max_x && cx >= min_x && cy < max_y && cy >= min_y)* 	    XDrawPoint(DISP, currwin.win, ruleGC,, 		cx - currwin.base_x, cy - currwin.base_y); }    /*?  *	Apply the requested attributes to the last path (box) drawn.   *	Attributes are reset.  *	(Not currently implemented.)   */  	/* ARGSUSED */  static	void A do_attribute_path(last_min_x, last_max_x, last_min_y, last_max_y) 3 int last_min_x, last_max_x, last_min_y, last_max_y;  {  }    /*?  *	Set the size of the virtual pen used to draw in milli-inches   */    /* ARGSUSED */ static	void  set_pen_size(cp)
 	char	*cp; {  	int	ps;  $ 	if (sscanf(cp, " %d ", &ps) != 1) {3 	    Warning("illegal .ps command format: %s", cp);  	    return; 	}= 	pen_size = (ps * (xRESOLUTION + yRESOLUTION) + 1000) / 2000;   	if (pen_size < 1) pen_size = 1;; 	else if (pen_size > MAX_PEN_SIZE) pen_size = MAX_PEN_SIZE;  }      /*3  *	Print the line defined by previous path commands   */    static	void  flush_path() {  	register int i;4 	int	last_min_x, last_max_x, last_min_y, last_max_y;   	last_min_x = 30000; 	last_min_y = 30000; 	last_max_x = -30000;  	last_max_y = -30000; ! 	for (i = 1; i < path_len; i++) { 0 	    if (xx[i] > last_max_x) last_max_x = xx[i];0 	    if (xx[i] < last_min_x) last_min_x = xx[i];0 	    if (yy[i] > last_max_y) last_max_y = yy[i];0 	    if (yy[i] < last_min_y) last_min_y = yy[i];. 	    line_btw(xx[i], yy[i], xx[i+1], yy[i+1]); 	}: 	if (xx[path_len] > last_max_x) last_max_x = xx[path_len];: 	if (xx[path_len] < last_min_x) last_min_x = xx[path_len];: 	if (yy[path_len] > last_max_y) last_max_y = yy[path_len];: 	if (yy[path_len] < last_min_y) last_min_y = yy[path_len]; 	path_len = 0;C 	do_attribute_path(last_min_x, last_max_x, last_min_y, last_max_y);  }      /*>  *	Print a dashed line along the previously defined path, with  *	the dashes/inch defined.   */    static	void  flush_dashed(cp, dotted)
 	char	*cp; 	Boolean	dotted; {  	int	i; 
 	int	numdots;  	int	lx0, ly0, lx1, ly1; 	int	cx0, cy0, cx1, cy1; 	float	inchesperdash; 1 	double	d, spacesize, a, b, dx, dy, milliperdash;   / 	if (sscanf(cp, " %f ", &inchesperdash) != 1) { > 	    Warning("illegal format for dotted/dashed line: %s", cp); 	    return; 	}- 	if (path_len <= 1 || inchesperdash <= 0.0) { > 	    Warning("illegal conditions for dotted/dashed line", ""); 	    return; 	}' 	milliperdash = inchesperdash * 1000.0;  	lx0 = xx[1];	ly0 = yy[1]; 	lx1 = xx[2];	ly1 = yy[2]; 	dx = lx1 - lx0; 	dy = ly1 - ly0; 	if (dotted) {8 	    numdots = sqrt(dx*dx + dy*dy) / milliperdash + 0.5;# 	    if (numdots == 0) numdots = 1; % 	    for (i = 0; i <= numdots; i++) { " 		a = (float) i / (float) numdots; 		cx0 = lx0 + a * dx + 0.5;  		cy0 = ly0 + a * dy + 0.5;  		dot_at(cx0, cy0);  	    } 	} 	else {  	    d = sqrt(dx*dx + dy*dy); . 	    numdots = d / (2.0 * milliperdash) + 1.0; 	    if (numdots <= 1) 		line_btw(lx0, ly0, lx1, ly1);  	    else { ; 		spacesize = (d - numdots * milliperdash) / (numdots - 1); % 		for (i = 0; i < numdots - 1; i++) { - 		    a = i * (milliperdash + spacesize) / d;  		    b = a + milliperdash / d;  		    cx0 = lx0 + a * dx + 0.5;  		    cy0 = ly0 + a * dy + 0.5;  		    cx1 = lx0 + b * dx + 0.5;  		    cy1 = ly0 + b * dy + 0.5;j# 		    line_btw(cx0, cy0, cx1, cy1);d 		    b += spacesize / d;c 		}  		cx0 = lx0 + b * dx + 0.5;  		cy0 = ly0 + b * dy + 0.5;t 		line_btw(cx0, cy0, lx1, ly1);n 	    } 	} 	path_len = 0; }e     /*"  *	Add a point to the current path  */e   static	void  add_path(cp)
 	char	*cp; {i 	int	pathx, pathy;  6 	if (++path_len >= MAXPOINTS) oops("Too many points");0 	if (sscanf(cp, " %d %d ", &pathx, &pathy) != 2)$ 	    oops("Malformed path command"); 	xx[path_len] = pathx; 	yy[path_len] = pathy; }r     /*$  *	Draw to a floating point position  */T   static void  im_fdraw(x, y) 	double	x,y; {B: 	if (++path_len >= MAXPOINTS) oops("Too many arc points"); 	xx[path_len] = x + 0.5; 	yy[path_len] = y + 0.5; }E     /*9  *	Draw an ellipse with the indicated center and radices.D  */I   static	voidN draw_ellipse(xc, yc, xr, yr) 	int	xc, yc, xr, yr; {Y 	double	angle, theta;D 	int	n;E 	int	px0, py0, px1, py1;   	angle = (xr + yr) / 2.0;N 	theta = sqrt(1.0 / angle);E 	n = TWOPI / theta + 0.5;* 	if (n < 12) n = 12; 	else if (n > 80) n = 80;U 	n /= 2; 	theta = TWOPI / n;R  
 	angle = 0.0;Y! 	px0 = xc + xr;		/* cos(0) = 1 */N 	py0 = yc;		/* sin(0) = 0 */$ 	while ((angle += theta) <= TWOPI) {$ 	    px1 = xc + xr*cos(angle) + 0.5;$ 	    py1 = yc + yr*sin(angle) + 0.5;" 	    line_btw(px0, py0, px1, py1); 	    px0 = px1;T 	    py0 = py1;e 	}! 	line_btw(px0, py0, xc + xr, yc);  }*   /*  *	Draw an arc  */g   static	voide arc(cp, invis)
 	char	*cp; 	Boolean	invis;, {8 	int	xc, yc, xrad, yrad, n;A/ 	float	start_angle, end_angle, angle, theta, r;*+ 	double	xradius, yradius, xcenter, ycenter;h  > 	if (sscanf(cp, " %d %d %d %d %f %f ", &xc, &yc, &xrad, &yrad,# 		&start_angle, &end_angle) != 6) { 2 	    Warning("illegal arc specification: %s", cp); 	    return; 	}   	if (invis) return;n  E 	/* We have a specialized fast way to draw closed circles/ellipses */I0 	if (start_angle <= 0.0 && end_angle >= 6.282) {& 	    draw_ellipse(xc, yc, xrad, yrad); 	    return; 	} 	xcenter = xc; 	ycenter = yc; 	xradius = xrad; 	yradius = yrad; 	r = (xradius + yradius) / 2.0;  	theta = sqrt(1.0 / r);  	n = 0.3 * TWOPI / theta + 0.5;  	if (n < 12) n = 12; 	else if (n > 80) n = 80;a 	n /= 2; 	theta = TWOPI / n;t 	flush_path();/ 	im_fdraw(xcenter + xradius * cos(start_angle),o+ 	    ycenter + yradius * sin(start_angle));p 	angle = start_angle + theta;t1 	if (end_angle < start_angle) end_angle += TWOPI;l 	while (angle < end_angle) {- 	    im_fdraw(xcenter + xradius * cos(angle),h" 		ycenter + yradius * sin(angle)); 	    angle += theta; 	}- 	im_fdraw(xcenter + xradius * cos(end_angle),d) 	    ycenter + yradius * sin(end_angle));u 	flush_path(); }n     /*2  *	APPROXIMATE integer distance between two points  */)  : #define	dist(x0, y0, x1, y1)	(abs(x0 - x1) + abs(y0 - y1))     /*2  *	Draw a spline along the previously defined path  */P   static	voidf flush_spline() {	 	int	xp, yp; 	int	N;I 	int	lastx, lasty; 	Boolean	lastvalid = False;  	int	t1, t2, t3; 	int	steps;  	int	j;e 	register int i, w;o   #ifdef	linti 	lastx = lasty = -1; #endif 	N = path_len + 1; 	xx[0] = xx[1];  	yy[0] = yy[1];_ 	xx[N] = xx[N-1];r 	yy[N] = yy[N-1];f- 	for (i = 0; i < N - 1; i++) {	/* interval */t4 	    steps = (dist(xx[i], yy[i], xx[i+1], yy[i+1]) +1 		dist(xx[i+1], yy[i+1], xx[i+2], yy[i+2])) / 80; 6 	    for (j = 0; j < steps; j++) {	/* points within */ 		w = (j * 1000 + 500) / steps;_ 		t1 = w * w / 20; 		w -= 500;a 		t2 = (750000 - w * w) / 10;; 		w -= 500;t 		t3 = w * w / 20;= 		xp = (t1*xx[i+2] + t2*xx[i+1] + t3*xx[i] + 50000) / 100000;e= 		yp = (t1*yy[i+2] + t2*yy[i+1] + t3*yy[i] + 50000) / 100000; 0 		if (lastvalid) line_btw(lastx, lasty, xp, yp);
 		lastx = xp;e
 		lasty = yp;a 		lastvalid = True;L 	    } 	} 	path_len = 0; }a     /*)  *	Shade the last box, circle, or ellipse   */c   static	void( shade_last() {	 	blacken = whiten = False; 	shade = True; })     /*I  *	Make the last box, circle, or ellipse, white inside (shade with white)a  */r   static	void 
 whiten_last()( {( 	whiten = True;) 	blacken = shade = False;p }c     /*#  *	Make last box, etc, black insiden  */(   static	void* blacken_last() {+ 	blacken = True; 	whiten = shade = False; }(     /*0  *	Code for PostScript<tm> specials begins here.  */    #if	PS  0 static	void	ps_startup ARGS((int, int, char *));% static	void	ps_startup2 ARGS((void));t void	NullProc ARGS((void)) {}t /* ARGSUSED */% static	void	NullProc2 ARGS((char *));&  G struct psprocs	psp = {		/* used for lazy startup of the ps machinery */c 	/* toggle */		NullProc, 	/* destroy */		NullProc,i 	/* interrupt */		NullProc,u 	/* endpage */		NullProc,. 	/* drawbegin */		ps_startup,a 	/* drawraw */		NullProc2, 	/* drawfile */		NULL, 	/* drawend */		NullProc2, 	/* beginheader */	ps_startup2,  	/* endheader */		NullProc,  	/* newdoc */		NullProc};c  G struct psprocs	no_ps_procs = {		/* used if postscript is unavailable */P 	/* toggle */		NullProc, 	/* destroy */		NullProc,u 	/* interrupt */		NullProc,A 	/* endpage */		NullProc,e! 	/* drawbegin */		drawbegin_none,* 	/* drawraw */		NullProc2, 	/* drawfile */		NULL, 	/* drawend */		NullProc2, 	/* beginheader */	NullProc, 	/* endheader */		NullProc,a 	/* newdoc */		NullProc};    #endif	/* PS */x   static	Boolean		bbox_valid;  static	unsigned int	bbox_width;e  static	unsigned int	bbox_height; static	int		bbox_voffset;E   void draw_bbox()e {e 	if (bbox_valid) {' 	    put_border(PXL_H - currwin.base_x,"( 		PXL_V - currwin.base_y - bbox_voffset,# 		bbox_width, bbox_height, ruleGC);r 	    bbox_valid = False; 	} }U     #if	PS   static	void  actual_startup() {z	 	char	*p;s   	/*; 	 * First sort out the paths.S 	 */ 	p = getenv("XDVIFIGS");( 	if (p == NULL) p = getenv("TEXINPUTS"); 	if (p != NULL) {d( 	    figfind.auxpath = figfind.mainpath; 	    figfind.mainpath = p; 	}   	p = getenv("XDVIHEADERS");s) 	if (p == NULL) p = getenv("HEADERPATH");_ 	if (p != NULL) {a. 	    headerfind.auxpath = headerfind.mainpath; 	    headerfind.mainpath = p;  	}   	/*>@ 	 * Figure out what we want to use to display postscript figures1 	 * and set at most one of the following to True:_5 	 * resource.useGS, resource.useDPS, resource.useNeWS  	 *i? 	 * Choose DPS then NEWS then GhostScript if they are availablea 	 */ 	if (!(m
 #ifdef	PS_DPSx# 	    (resource.useDPS && initDPS()) & #if	defined(PS_NEWS) || defined(PS_GS) 	    ||a #endif #endif	/* PS_DPS */x   #ifdef	PS_NEWS% 	    (resource.useNeWS && initNeWS())m #ifdef	PS_GS 	    ||p #endif #endif	/* PS_NEWS */   #ifdef	PS_GS! 	    (resource.useGS && initGS())  #endif   	    ))i 	    psp = no_ps_procs;e }e   static	void  ps_startup(xul, yul, cp) 	int	xul, yul;
 	char	*cp; {v 	if (!resource._postscript) { ! 	    psp.toggle = actual_startup;i 	    draw_bbox();s 	    return; 	} 	actual_startup(); 	psp.drawbegin(xul, yul, cp);p }a   static	void,
 ps_startup2()b {x 	actual_startup(); 	psp.beginheader();  }"   /* ARGSUSED */ static	void 
 NullProc2(cp)a
 	char	*cp; {}   /* ARGSUSED */ void #if	NeedFunctionPrototypes* drawbegin_none(int xul, int yul, char *cp)# #else	/* !NeedFunctionPrototypes */t drawbegin_none(xul, yul, cp) 	int	xul, yul;
 	char	*cp;# #endif	/* NeedFunctionPrototypes */] {y
 	draw_bbox();1 }x     /* |||E  *	This routine is just a stopgap measure.  My next major project forsF  *	xdvi is to upgrade the file searching routines so that they conform1  *	to the standard TeX Directory Structure (TDS).   */    #ifndef	VMSo #define	PATH_SEP	':' #else	/* VMS */5 #define	PATH_SEP	'/' #endif	/* VMS */  
 static	FILE * 1 pathfopen(filename, buffer, pathlist1, pathlist2)  	_Xconst char	*filename; 	char		*buffer;. 	_Xconst char	*pathlist1;  	_Xconst char	*pathlist2;y { 
 	FILE		*f; 	_Xconst char	*p;d
 	char		*q;   	for (;;) {/$ 	    p = index(pathlist1, PATH_SEP);6 	    if (p == NULL) p = pathlist1 + strlen(pathlist1); 	    if (p == pathlist1) { 		f = NULL;d 		if (pathlist2 != NULL) {7 		    f = pathfopen(filename, buffer, pathlist2, NULL);x 		    pathlist2 = NULL;  		}  	    } 	    else { * 		bcopy(pathlist1, buffer, p - pathlist1); 		q = buffer + (p - pathlist1); 
 		*q++ = '/';+ 		Strcpy(q, filename);> 		if (debug & DBG_OPEN) Printf("Trying PS file %s\n", buffer);  		f = xfopen(buffer, OPEN_MODE); 	    } 	    if (f != NULL) return f;c! 	    if (*p == '\0') return NULL;i 	    pathlist1 = p + 1;i 	} }t     struct tickrec { 	struct tickrec	*next;
 	int		pageno;  	char	*command;, 	_Xconst char	*tmpname;( };  D static	struct tickrec	*tickhead	= NULL;	/* head of linked list of */ 						/* cached information */6 static	int		nticks		= 0;	/* number of records total */   #ifndef	TICKCACHESIZEp #define	TICKCACHESIZE	3s #endif   #ifndef	TICKTMPx #define	TICKTMP		"/tmp"y #endif   static	struct tickrec * ! cachetick(filename, pathinfo, fp)e 	_Xconst char	*filename; 	struct findrec	*pathinfo; 	FILE		**fp; {y 	struct tickrec	**linkp; 	struct tickrec	*tikp; 	struct tickrec	**freerecp;p   	linkp = &tickhead;r 	freerecp = NULL;e, 	for (;;) {		/* see if we have it already */ 	    tikp = *linkp;n- 	    if (tikp == NULL) {	/* if end of list */t4 		if (nticks >= TICKCACHESIZE && freerecp != NULL) { 		    tikp = *freerecp;= 		    *freerecp = tikp->next;( 		    free(tikp->command); 		}  		else { 		    tikp = (struct tickrec *)=5 			xmalloc(sizeof(struct tickrec), "tick list node");,/ 		    tikp->tmpname = tempnam(TICKTMP, "xdvi");l 		    tikp->pageno = -1;" 		    if (tikp->tmpname == NULL) {4 			Fputs("Cannot create temporary file.\n", stderr); 			free(tikp); 			return NULL;, 		    }A 		    ++nticks;g 		}n: 		tikp->command = xmalloc((unsigned) strlen(filename) + 1, 		    "tick list data");" 		Strcpy(tikp->command, filename);
 		*fp = NULL;, 		break; 	    }? 	    if (strcmp(filename, tikp->command) == 0) {	/* found it */"& 		*linkp = tikp->next;	/* unlink it */) 		*fp = xfopen(tikp->tmpname, OPEN_MODE);w) 		if (*fp == NULL) perror(tikp->tmpname);  		break; 	    }8 	    if (tikp->pageno != current_page) freerecp = linkp; 	    linkp = &tikp->next;  	}) 	tikp->next = tickhead;		/* link it in */; 	tickhead = tikp; < 	tikp->pageno = pathinfo != &headerfind ? current_page : -1;
 	return tikp;/ }e   #ifndef	UNCOMPRESS #define	UNCOMPRESS	"uncompress"  #endif   #ifndef	GUNZIP #define	GUNZIP		"gunzip" #endif   static	voidr sendfile(filename, pathinfo) 	_Xconst char	*filename; 	struct findrec	*pathinfo; {t
 	FILE		*f; 	char		buffer[FILENAMESIZE];8 	static _Xconst char *argv[]	= {NULL, "-c", NULL, NULL}; 	_Xconst char	*bufp; 	struct tickrec	*tikp;
 	char		*p;
 	int		len; 	char		magic2;  " 	if (psp.drawfile == NULL) return;   	if (filename[0] == '`') {! 	    if (!resource.allow_shell) {d 		if (!hush_spec_now)( 		    Fprintf(stderr,O6 			"%s: shell escape disallowed for special \"%s\"\n", 			prog, filename);y	 		return;- 	    }  . 	    tikp = cachetick(filename, pathinfo, &f); 	    if (tikp == NULL)	 		return;t 	    if (f == NULL) {): 		Sprintf(buffer, "%s > %s", filename + 1, tikp->tmpname); 		(void) system(buffer);' 		f = xfopen(tikp->tmpname, OPEN_MODE);s 		if (f == NULL) { 		    perror(tikp->tmpname);
 		    return;= 		}_ 	    } 	    bufp = tikp->tmpname; 	} 	else {[ 	    if (filename[0] == '/') {@ 		if (debug & DBG_OPEN) Printf("Trying PS file %s\n", filename);" 		f = xfopen(filename, OPEN_MODE); 		bufp = filename; 	    } 	    else {i/ 		/* first try the same path as the dvi file *// 		p = rindex(dvi_name, '/');! 		if (p == NULL) bufp = filename;w 		else {. 		    bcopy(dvi_name, buffer, ++p - dvi_name);" 		    p = buffer + (p - dvi_name); 		    Strcpy(p, filename); 		    bufp = buffer; 		}e< 		if (debug & DBG_OPEN) Printf("Trying PS file %s\n", bufp); 		f = xfopen(bufp, OPEN_MODE);  / 		/* if no luck, try a search over the paths */a 		if (f == NULL) {9 		    f = pathfopen(filename, buffer, pathinfo->mainpath,s 			pathinfo->auxpath); 		    bufp = buffer; 		}h 	    }  % 	    /* if still no luck, complain */e 	    if (f == NULL) {*4 		Fprintf(stderr, "%s: cannot find PS file `%s'.\n", 		    prog, filename); 		draw_bbox();	 		return;s 	    }  % 	    /* check for compressed files */l 	    len = strlen(filename);: 	    if ((len > 2 && strcmp(filename + len - 2, ".Z") == 09 		      && (argv[0] = UNCOMPRESS, magic2 = '\235', True)) ; 		    || (len > 3 && strcmp(filename + len - 3, ".gz") == 0 8 		      && (argv[0] = GUNZIP, magic2 = '\213', True))) {4 		if (getc(f) != '\037' || (char) getc(f) != magic2) 		    rewind(f); 		else { 		    Fclose(f); 		    ++n_files_left;*/ 		    tikp = cachetick(filename, pathinfo, &f);s 		    if (tikp == NULL)y
 			return; 		    if (f == NULL) {
 			pid_t	pid;l 			int	handle; 			int	status;   			argv[2] = bufp;; 			handle = open(tikp->tmpname, O_RDWR | O_CREAT | O_TRUNC,u 			    S_IRUSR | S_IWUSR); 			if (handle == -1) { 			    perror(tikp->tmpname);_ 			    return; 			}. 			Fflush(stderr);	/* avoid double flushing */ 			pid = vfork();_! 			if (pid == 0) {	/* if child */  			    (void) dup2(handle, 1);. 			    (void) execvp(argv[0], (char **) argv);: 			    Fprintf(stderr, "Execvp of %s failed.\n", argv[0]); 			    Fflush(stderr); 			    _exit(1); 			} 			(void) close(handle);
 			for (;;) {n1 			    if (waitpid(pid, &status, 0) != -1) break; $ 			    if (errno == EINTR) continue;  			    perror("[xdvi] waitpid"); 			    return; 			}( 			f = xfopen(tikp->tmpname, OPEN_MODE); 			if (f == NULL) {n 			    perror(tikp->tmpname);x 			    return; 			} 		    }e 		    bufp = tikp->tmpname;  		}b 	    } 	}   	/* Success! */ @ 	psp.drawfile(bufp, f);	/* this is supposed to close the file */ }r     void ps_newdoc()i {  	struct tickrec	*tikp;  7 	scanned_page = scanned_page_bak = scanned_page_reset =;) 	    resource.prescan ? -1 : total_pages;=7 	for (tikp = tickhead; tikp != NULL; tikp = tikp->next)T 	    tikp->pageno = -1;  	psp.newdoc(); }h     void ps_destroy() {f 	struct tickrec	*tikp;   	psp.destroy();V7 	for (tikp = tickhead; tikp != NULL; tikp = tikp->next) # 	    if (unlink(tikp->tmpname) < 0)u 		perror(tikp->tmpname); }    #endif	/* PS */n     static	void  psfig_special(cp)t
 	char	*cp; {o 	char	*filename; 	int	raww, rawh;  ' 	if (strncmp(cp, ":[begin]", 8) == 0) { 
 	    cp += 8;o 	    bbox_valid = False;3 	    if (sscanf(cp,"%d %d\n", &raww, &rawh) >= 2) {t 		bbox_valid = True;, 		bbox_width = pixel_conv(spell_conv(raww));- 		bbox_height = pixel_conv(spell_conv(rawh));e 		bbox_voffset = 0;i 	    }! 	    if (currwin.win == mane.win)D #if	PS? 		psp.drawbegin(PXL_H - currwin.base_x, PXL_V - currwin.base_y,P
 		    cp); #elsed 		draw_bbox(); #endif 	    psfig_begun = True;1 	} else if (strncmp(cp, " plotfile ", 10) == 0) {  	    cp += 10; 	    while (isspace(*cp)) cp++;t. 	    for (filename = cp; !isspace(*cp); ++cp); 	    *cp = '\0'; #if	PS? 	    if (currwin.win == mane.win) sendfile(filename, &figfind);  #endif, 	} else if (strncmp(cp, ":[end]", 6) == 0) {
 	    cp += 6;a #if	PS2 	    if (currwin.win == mane.win) psp.drawend(cp); #endif 	    bbox_valid = False; 	    psfig_begun = False;r 	} else if (*cp == ':') { 7 	    /* I am going to send some raw postscript stuff */i 	    ++cp;	/* skip the colon */) #if	PS2 	    if (currwin.win == mane.win) psp.drawraw(cp); #endif	 	} else { : 	    /* also raw PostScript, but no extra colon to skip */ #if	PS# 	    if (currwin.win == mane.win) {n# 		if (psfig_begun) psp.drawraw(cp);  		else {+ 		    psp.drawbegin(PXL_H - currwin.base_x,c 			PXL_V - currwin.base_y, cp);m 		    psp.drawend(""); 		}c 	    } #endif 	} }      /*	Keys for epsf specials */    static	char	*keytab[]	= {"clip",
 				   "llx",e
 				   "lly", 
 				   "urx", 
 				   "ury",e
 				   "rwi",a
 				   "rhi",s 				   "hsize",a 				   "vsize",a 				   "hoffset",n 				   "voffset",  				   "hscale", 				   "vscale", 				   "angle"};   #define	KEY_LLX	keyval[0]r #define	KEY_LLY	keyval[1]t #define	KEY_URX	keyval[2]  #define	KEY_URY	keyval[3]  #define	KEY_RWI	keyval[4]  #define	KEY_RHI	keyval[5]U  . #define	NKEYS	(sizeof(keytab)/sizeof(*keytab)) #define	N_ARGLESS_KEYS 1   static	void  epsf_special(cp)
 	char	*cp; {  	char	*filename; 	static	char		*buffer;  	static	unsigned int	buflen	= 0; 	unsigned int		len; 	 	char	*q;' 	int	flags	= 0;i 	double	keyval[6];   	filename = cp;f! 	if (*cp == '\'' || *cp == '"') {	
 	    do ++cp;e- 	    while (*cp != '\0' && *cp != *filename);u 	    ++filename; 	} 	elser; 	    while (*cp != '\0' && *cp != ' ' && *cp != '\t') ++cp;c 	if (*cp != '\0') *cp++ = '\0';i( 	while (*cp == ' ' || *cp == '\t') ++cp; 	len = strlen(cp) + NKEYS + 30;c 	if (buflen < len) {# 	    if (buflen != 0) free(buffer);	 	    buflen = len;- 	    buffer = xmalloc(buflen, "epsf buffer");  	}! 	Strcpy(buffer, "@beginspecial");Z 	q = buffer + strlen(buffer);e 	while (*cp != '\0') { 	    char *p1 = cp;t 	    int keyno;t  = 	    while (*p1 != '=' && !isspace(*p1) && *p1 != '\0') ++p1;n  	    for (keyno = 0;; ++keyno) { 		if (keyno >= NKEYS) {; 		    if (!hush_spec_now)k 			Fprintf(stderr,B 			    "%s: unknown keyword (%*s) in \\special will be ignored\n"," 			    prog, (int) (p1 - cp), cp); 		    break; 		} 0 		if (memcmp(cp, keytab[keyno], p1 - cp) == 0) {$ 		    if (keyno >= N_ARGLESS_KEYS) { 			while (isspace(*p1)) ++p1;N 			if (*p1 == '=') { 			    ++p1;! 			    while (isspace(*p1)) ++p1;  			}$ 			if (keyno < N_ARGLESS_KEYS + 6) {1 			    keyval[keyno - N_ARGLESS_KEYS] = atof(p1);t0 			    flags |= (1 << (keyno - N_ARGLESS_KEYS)); 			} 			*q++ = ' ';5 			while (!isspace(*p1) && *p1 != '\0') *q++ = *p1++;n 		    }L 		    *q++ = ' ';n 		    *q++ = '@';  		    Strcpy(q, keytab[keyno]);; 		    q += strlen(q);  		    break; 		}s 	    }
 	    cp = p1;n/ 	    while (!isspace(*cp) && *cp != '\0') ++cp;  	    while (isspace(*cp)) ++cp;k 	} 	Strcpy(q, " @setspecial\n");L   	bbox_valid = False;I 	if ((flags & 0x30) == 0x30 || ((flags & 0x30) && (flags & 0xf) == 0xf)){t 	    bbox_valid = True;/1 	    bbox_width = 0.1 * ((flags & 0x10) ? KEY_RWI(8 		: KEY_RHI * (KEY_URX - KEY_LLX) / (KEY_URY - KEY_LLY))" 		* dimconv / shrink_factor + 0.5;A 	    bbox_voffset = bbox_height = 0.1 * ((flags & 0x20) ? KEY_RHIi8 		: KEY_RWI * (KEY_URY - KEY_LLY) / (KEY_URX - KEY_LLX))" 		* dimconv / shrink_factor + 0.5; 	}   	if (currwin.win == mane.win) {i #if	PSB 	    psp.drawbegin(PXL_H - currwin.base_x, PXL_V - currwin.base_y,
 		buffer);1 	    /* talk directly with the DPSHandler here */l" 	    sendfile(filename, &figfind);! 	    psp.drawend(" @endspecial");  #elseL 	    draw_bbox();e #endif 	} 	bbox_valid = False; }r     static	void  quote_special(cp) 
 	char	*cp; {b 	bbox_valid = False;   #if	PS 	if (currwin.win == mane.win) {cB 	    psp.drawbegin(PXL_H - currwin.base_x, PXL_V - currwin.base_y,  		"@beginspecial @setspecial ");1 	    /* talk directly with the DPSHandler here */O 	    psp.drawraw(cp + 1);l! 	    psp.drawend(" @endspecial");o 	} #endif  / 	/* nothing else to do--there's no bbox here */e }e   #if	PS   static	void  scan_header(cp)	
 	char	*cp; {i 	char	*filename;   	filename = cp;%! 	if (*cp == '\'' || *cp == '"') {e
 	    do ++cp;s- 	    while (*cp != '\0' && *cp != *filename);M 	    *cp = '\0'; 	    ++filename; 	}   	psp.beginheader(); ! 	sendfile(filename, &headerfind);  }p   static	void 
 scan_bang(cp)i
 	char	*cp; {= 	psp.beginheader();  	psp.drawraw(cp + 1);i }P   #endif	/* PS */a   /*J  *	The following copyright message applies to the rest of this file.  --PV  */*   /*E  *	This program is Copyright (C) 1987 by the Board of Trustees of the	;  *	University of Illinois, and by the author Dirk Grunwald.a  *?  *	This program may be freely copied, as long as this copyright @  *	message remaines affixed. It may not be sold, although it may;  *	be distributed with other software which is sold. If thebC  *	software is distributed, the source code must be made available.   *B  *	No warranty, expressed or implied, is given with this software.9  *	It is presented in the hope that it will prove useful.   *>  *	Hacked in ignorance and desperation by jonah@db.toronto.edu  */    /*G  *      The code to handle the \specials generated by tpic was modified	L  *      by Dirk Grunwald using the code Tim Morgan at Univ. of Calif, Irvine  *      wrote for TeXsun.   */i  
 static	char *r endofcommand(cp)
 	char	*cp; {0 	while (isspace(*cp)) ++cp;P 	if (*cp != '=') return NULL;  	do ++cp; while (isspace(*cp));a 	return cp;  }z  " #define	CMD(x, y)	((x) << 8 | (y))   void applicationDoSpecial(cp)
 	char	*cp; {0	 	char	*p;r 	/* PostScript specials */   	if (*cp == '"') { 	    quote_special(cp);+ 	    return; 	}" 	if (memicmp(cp, "ps:", 3) == 0) { 	    psfig_special(cp + 3);  	    return; 	}" 	if (memicmp(cp, "psfile", 6) == 0* 		&& (p = endofcommand(cp + 6)) != NULL) { 	    epsf_special(p);l 	    return; 	}  % 	/* these should have been scanned */    	if (*cp == '!';" 		|| memicmp(cp, "header", 6) == 0$ 		&& endofcommand(cp + 6) != NULL) { #if	PS; 	    if (resource._postscript && scanned_page_reset >= 0) {), 		/* turn on scanning and redraw the page */< 		scanned_page = scanned_page_bak = scanned_page_reset = -1; 		psp.interrupt(); 		canit = True;x 		longjmp(canit_env, 1); 	    } #endif 	    return; 	}   	/* tpic specials */  @ 	if (*cp >= 'a' && *cp <= 'z' && cp[1] >= 'a' && cp[1] <= 'z' &&& 		(isspace(cp[2]) || cp[2] == '\0')) { 	    switch (CMD(*cp, cp[1])) {o2 		case CMD('p','n'): set_pen_size(cp + 2); return;* 		case CMD('f','p'): flush_path(); return;9 		case CMD('d','a'): flush_dashed(cp + 2, False); return; 8 		case CMD('d','t'): flush_dashed(cp + 2, True); return;. 		case CMD('p','a'): add_path(cp + 2); return;0 		case CMD('a','r'): arc(cp + 2, False); return;/ 		case CMD('i','a'): arc(cp + 2, True); return; , 		case CMD('s','p'): flush_spline(); return;* 		case CMD('s','h'): shade_last(); return;+ 		case CMD('w','h'): whiten_last(); return;N, 		case CMD('b','k'): blacken_last(); return;: 		case CMD('i','p'): /* throw away the path -- jansteen */ 		    path_len = 0; return;r 	    } 	}   	if (!hush_spec_now)H 	    Fprintf(stderr, "%s:  special \"%s\" not implemented\n", prog, cp); }t  
 #undef	CMD   #if	PS void scan_special(cp)
 	char	*cp; {_	 	char	*p;t   	if (debug & DBG_PS), 	    Printf("Scanning special `%s'.\n", cp);   	if (*cp == '!') scan_bang(cp); ' 	else if (memicmp(cp, "header", 6) == 0 ( 		&& (p = endofcommand(cp + 6)) != NULL) 	    scan_header(p); }  #endif	/* PS */x