 /*7  * Copyright (c) 1994 Paul Vojta.  All rights reserved.   *E  * Redistribution and use in source and binary forms, with or without E  * modification, are permitted provided that the following conditions   * are met: D  * 1. Redistributions of source code must retain the above copyrightC  *    notice, this list of conditions and the following disclaimer. G  * 2. Redistributions in binary form must reproduce the above copyright I  *    notice, this list of conditions and the following disclaimer in the J  *    documentation and/or other materials provided with the distribution.  *I  * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND H  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THEM  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE J  * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLEM  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL J  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODSH  * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)M  * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT L  * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAYI  * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF   * SUCH DAMAGE.   *  * NOTE:K  *	xdvi is based on prior work as noted in the modification history, below.   */    /*  * DVI previewer for X.   *$  * Eric Cooper, CMU, September 1985.  *"  * Code derived from dvi-imagen.c.  *  * Modification history:5  * 1/1986	Modified for X.10	--Bob Scheifler, MIT LCS. .  * 7/1988	Modified for X.11	--Mark Eichin, MIT6  * 12/1988	Added 'R' option, toolkit, magnifying glass!  *					--Paul Vojta, UC Berkeley. 8  * 2/1989	Added tpic support	--Jeffrey Lee, U of TorontoC  * 4/1989	Modified for System V	--Donald Richardson, Clarkson Univ. 8  * 3/1990	Added VMS support	--Scott Allendorf, U of IowaD  * 7/1990	Added reflection mode	--Michael Pak, Hebrew U of JerusalemD  * 1/1992	Added greyscale code	--Till Brychcy, Techn. Univ. Muenchen"  *					  and Lee Hetherington, MIT)  * 4/1994	Added DPS support, bounding box   *					--Ricardo Telichevesky +  *					  and Luis Miguel Silveira, MIT RLE.   *  *	Compilation options:   *	SYSV	compile for System V  *	VMS	compile for VMS!  *	NOTOOL	compile without toolkit I  *	BUTTONS	compile with buttons on the side of the window (needs toolkit) F  *	MSBITFIRST	store bitmaps internally with most significant bit first3  *	BMSHORT	store bitmaps in shorts instead of bytes 1  *	BMLONG	store bitmaps in longs instead of bytes &  *	ALTFONT	default for -altfont option  *	A4	use European size paper B  *	TEXXET	support reflection dvi codes (right-to-left typesetting)'  *	GREY	use grey levels to shrink fonts B  *	PS_DPS	use display postscript to render pictures/bounding boxes@  *	PS_NEWS	use the NeWS server to render pictures/bounding boxes:  *	PS_GS	use Ghostscript to render pictures/bounding boxes6  *	GS_PATH	path to call the Ghostscript interpreter by  */    #ifndef	lint static	char	copyright[] = > "@(#) Copyright (c) 1994 Paul Vojta.  All rights reserved.\n"; #endif   #ifndef	ALTFONT  #define	ALTFONT	"cmr10"  #endif  ' #if	defined(PS_GS) && !defined(GS_PATH)  #define	GS_PATH	"gs" #endif  
 #ifndef	A4 #define	DEFAULT_PAPER		"us"  #else  #define	DEFAULT_PAPER		"a4"  #endif   #define	EXTERN #define	INIT(x)	=x  ' #include <math.h>	/* includes atof() */  #include <ctype.h> #include "xdvi.h"    #include "patchlevel.h" , static	_Xconst	struct {char	a[24], b, c, d;}> 	version = {"This is xdvi patchlevel ", '0' + PATCHLEVEL / 10, 		'0' + PATCHLEVEL % 10, 0};   #ifdef	X_NOT_STDC_ENV  #ifndef	atof* extern	double	atof ARGS((_Xconst char *)); #endif #endif  ) /* Xlib and Xutil are already included */  #include <X11/cursorfont.h>  #include <X11/keysym.h>  #include "xdvi.icon"   #ifdef	TOOLKIT #ifdef	OLD_X11_TOOLKIT #include <X11/Atoms.h> #else /* not OLD_X11_TOOLKIT */  #include <X11/Xatom.h> #include <X11/StringDefs.h>   #endif /* not OLD_X11_TOOLKIT */8 #include <X11/Shell.h>	/* needed for def. of XtNiconX */ #ifndef	XtSpecificationRelease  #define	XtSpecificationRelease	0 #endif #if	XtSpecificationRelease >= 4  #include <X11/Xaw/Viewport.h>  #ifdef	BUTTONS #include <X11/Xaw/Command.h> #endif& #else	/* XtSpecificationRelease < 4 */ #define	XtPointer caddr_t  #include <X11/Viewport.h>  #ifdef	BUTTONS #include <X11/Command.h> #endif# #endif	/* XtSpecificationRelease */  #if	XtSpecificationRelease < 5 typedef	caddr_t	XPointer;  #endif #else	/* !TOOLKIT */ typedef	int		Position; #endif	/* TOOLKIT */  
 #ifdef	VMS /*  * Magnifying glass cursor  *&  * Developed by Tom Sawyer, April 1990-  * Contibuted by Hunter Goatley, January 1991   *  */    #define mag_glass_width 16 #define mag_glass_height 16  #define mag_glass_x_hot 6  #define mag_glass_y_hot 6   static char mag_glass_bits[] = {H 	0xf8, 0x03, 0x0c, 0x06, 0xe2, 0x09, 0x13, 0x1a, 0x01, 0x14, 0x01, 0x14,H 	0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x03, 0x10, 0x02, 0x18, 0x0c, 0x34,/ 	0xf8, 0x6f, 0x00, 0xd8, 0x00, 0xb0, 0x00, 0xe0  };D #include <decw$cursor.h>	/* Include the DECWindows cursor symbols */F static	int	DECWCursorFont;	/* Space for the DECWindows cursor font  */H static	Pixmap	MagnifyPixmap;	/* Pixmap to hold our special mag-glass  */E #include <X11/Xresource.h>      /* Motif apparently needs this one */  #endif	/* VMS */   /*  * Command line flags.  */    static	Dimension	bwidth	= 2;  ' #define	fore_Pixel	resource._fore_Pixel ' #define	back_Pixel	resource._back_Pixel  #ifdef	TOOLKIT struct _resource	resource;' #define	brdr_Pixel	resource._brdr_Pixel # #define	hl_Pixel	resource._hl_Pixel # #define	cr_Pixel	resource._cr_Pixel  #else	/* TOOLKIT */ ! static	Pixel		hl_Pixel, cr_Pixel;  #endif	/* TOOLKIT */  D struct	mg_size_rec	mg_size[5]	= {{200, 150}, {400, 250}, {700, 500},# 					   {1000, 800}, {1200, 1200}};    static	char	*curr_page;   J struct WindowRec mane	= {(Window) 0, 3, 0, 0, 0, 0, MAXDIM, 0, MAXDIM, 0};I struct WindowRec alt	= {(Window) 0, 1, 0, 0, 0, 0, MAXDIM, 0, MAXDIM, 0}; = /*	currwin is temporary storage except for within redraw() */ M struct WindowRec currwin = {(Window) 0, 3, 0, 0, 0, 0, MAXDIM, 0, MAXDIM, 0};    #ifdef	lint  #ifdef	TOOLKIT- WidgetClass	viewportWidgetClass, widgetClass;  #ifdef	BUTTONSF WidgetClass	formWidgetClass, compositeWidgetClass, commandWidgetClass; #endif	/* BUTTONS */ #endif	/* TOOLKIT */ #endif	/* lint */    /*  *	Data for options processing  */   @ static	_Xconst	char	silent[] = " ";	/* flag value for usage() */  ; static	_Xconst	char	subst[]	= "x";	/* another flag value */   6 static	_Xconst char	*subst_val[] = {"-mgs[n] <size>"};   #ifdef	TOOLKIT  % static	XrmOptionDescRec	options[] = { : {"-s",		".shrinkFactor", XrmoptionSepArg,	(caddr_t) NULL}, #ifndef	VMS < {"-S",		".densityPercent", XrmoptionSepArg,	(caddr_t) NULL}, #endifA {"-density",	".densityPercent", XrmoptionSepArg,	(caddr_t) NULL},  #ifdef	GREY 7 {"-nogrey",	".grey",	XrmoptionNoArg,		(caddr_t) "off"}, 6 {"+nogrey",	".grey",	XrmoptionNoArg,		(caddr_t) "on"},6 {"-gamma",	".gamma",	XrmoptionSepArg,	(caddr_t) NULL}, #endif; {"-p",		".pixelsPerInch", XrmoptionSepArg,	(caddr_t) NULL}, 9 {"-margins",	".Margin",	XrmoptionSepArg,	(caddr_t) NULL}, @ {"-sidemargin",	".sideMargin",	XrmoptionSepArg,	(caddr_t) NULL},> {"-topmargin",	".topMargin",	XrmoptionSepArg,	(caddr_t) NULL},9 {"-offsets",	".Offset",	XrmoptionSepArg,	(caddr_t) NULL}, : {"-xoffset",	".xOffset",	XrmoptionSepArg,	(caddr_t) NULL},: {"-yoffset",	".yOffset",	XrmoptionSepArg,	(caddr_t) NULL},6 {"-paper",	".paper",	XrmoptionSepArg,	(caddr_t) NULL},: {"-altfont",	".altFont",	XrmoptionSepArg,	(caddr_t) NULL},
 #ifdef	MAKEPK ; {"-nomakepk",	".makePk",	XrmoptionNoArg,		(caddr_t) "off"}, : {"+nomakepk",	".makePk",	XrmoptionNoArg,		(caddr_t) "on"}, #endif8 {"-mfmode",	".mfMode",	XrmoptionSepArg,	(caddr_t) NULL},7 {"-l",		".listFonts",	XrmoptionNoArg,		(caddr_t) "on"}, 8 {"+l",		".listFonts",	XrmoptionNoArg,		(caddr_t) "off"}, #ifdef	BUTTONS8 {"-expert",	".expert",	XrmoptionNoArg,		(caddr_t) "on"},9 {"+expert",	".expert",	XrmoptionNoArg,		(caddr_t) "off"},c #endif< {"-mgs",	".magnifierSize1",XrmoptionSepArg,	(caddr_t) NULL},= {"-mgs1",	".magnifierSize1",XrmoptionSepArg,	(caddr_t) NULL},i= {"-mgs2",	".magnifierSize2",XrmoptionSepArg,	(caddr_t) NULL}, = {"-mgs3",	".magnifierSize3",XrmoptionSepArg,	(caddr_t) NULL}, = {"-mgs4",	".magnifierSize4",XrmoptionSepArg,	(caddr_t) NULL}, = {"-mgs5",	".magnifierSize5",XrmoptionSepArg,	(caddr_t) NULL},w4 {"-hush",	".Hush",	XrmoptionNoArg,		(caddr_t) "on"},5 {"+hush",	".Hush",	XrmoptionNoArg,		(caddr_t) "off"},IC {"-hushspecials", ".hushSpecials", XrmoptionNoArg,	(caddr_t) "on"}, D {"+hushspecials", ".hushSpecials", XrmoptionNoArg,	(caddr_t) "off"},A {"-hushchars",	".hushLostChars", XrmoptionNoArg,	(caddr_t) "on"},IB {"+hushchars",	".hushLostChars", XrmoptionNoArg,	(caddr_t) "off"},E {"-hushchecksums", ".hushChecksums", XrmoptionNoArg,	(caddr_t) "on"},LF {"+hushchecksums", ".hushChecksums", XrmoptionNoArg,	(caddr_t) "off"},6 {"-safer",	".safer",	XrmoptionNoArg,		(caddr_t) "on"},7 {"+safer",	".safer",	XrmoptionNoArg,		(caddr_t) "off"},H9 {"-fg",		".foreground",	XrmoptionSepArg,	(caddr_t) NULL},N@ {"-foreground",	".foreground",	XrmoptionSepArg,	(caddr_t) NULL},9 {"-bg",		".background",	XrmoptionSepArg,	(caddr_t) NULL},A@ {"-background",	".background",	XrmoptionSepArg,	(caddr_t) NULL},8 {"-hl",		".highlight",	XrmoptionSepArg,	(caddr_t) NULL},: {"-cr",		".cursorColor",	XrmoptionSepArg,	(caddr_t) NULL},B {"-icongeometry",".iconGeometry",XrmoptionSepArg,	(caddr_t) NULL},; {"-keep",	".keepPosition",XrmoptionNoArg,		(caddr_t) "on"},	< {"+keep",	".keepPosition",XrmoptionNoArg,		(caddr_t) "off"},4 {"-copy",	".copy",	XrmoptionNoArg,		(caddr_t) "on"},5 {"+copy",	".copy",	XrmoptionNoArg,		(caddr_t) "off"},U< {"-thorough",	".thorough",	XrmoptionNoArg,		(caddr_t) "on"},= {"+thorough",	".thorough",	XrmoptionNoArg,		(caddr_t) "off"},C #if	PSB {"-nopostscript",".postscript",	XrmoptionNoArg,		(caddr_t) "off"},A {"+nopostscript",".postscript",	XrmoptionNoArg,		(caddr_t) "on"}, : {"-noscan",	".prescan",	XrmoptionNoArg,		(caddr_t) "off"},9 {"+noscan",	".prescan",	XrmoptionNoArg,		(caddr_t) "on"},e@ {"-allowshell",	".allowShell",	XrmoptionNoArg,		(caddr_t) "on"},A {"+allowshell",	".allowShell",	XrmoptionNoArg,		(caddr_t) "off"},s
 #ifdef	PS_DPSp6 {"-nodps",	".dps",		XrmoptionNoArg,		(caddr_t) "off"},5 {"+nodps",	".dps",		XrmoptionNoArg,		(caddr_t) "on"},n #endif #ifdef	PS_NEWS7 {"-nonews",	".news",	XrmoptionNoArg,		(caddr_t) "off"},w6 {"+nonews",	".news",	XrmoptionNoArg,		(caddr_t) "on"}, #endif #ifdef	PS_GSC {"-noghostscript",".ghostscript", XrmoptionNoArg,	(caddr_t) "off"},TB {"+noghostscript",".ghostscript", XrmoptionNoArg,	(caddr_t) "on"},A {"-interpreter",".interpreter",	XrmoptionSepArg,	(caddr_t) NULL},E= {"-nogssafer",	".gsSafer",	XrmoptionNoArg,		(caddr_t) "off"},c< {"+nogssafer",	".gsSafer",	XrmoptionNoArg,		(caddr_t) "on"},< {"-gspalette",	".palette",	XrmoptionSepArg,	(caddr_t) NULL}, #endif #endif	/* PS *//; {"-debug",	".debugLevel",	XrmoptionSepArg,	(caddr_t) NULL},p: {"-version",	".version",	XrmoptionNoArg,		(caddr_t) "on"},; {"+version",	".version",	XrmoptionNoArg,		(caddr_t) "off"},; };  9 #define	offset(field)	XtOffsetOf(struct _resource, field)   = static	int	basedpi	= BDPI;		/* default value for -p option */e  : static	char	XtRBool3[]	= "Bool3";	/* resource for Bool3 */  - static	XtResource	application_resources[] = {N5 {"shrinkFactor", "ShrinkFactor", XtRInt, sizeof(int),t(   offset(shrinkfactor), XtRString, "3"},9 {"densityPercent", "DensityPercent", XtRInt, sizeof(int),c%   offset(_density), XtRString, "40"},  #ifdef	GREYl+ {"gamma", "Gamma", XtRFloat, sizeof(float),L"   offset(_gamma), XtRString, "1"}, #endif7 {"pixelsPerInch", "PixelsPerInch", XtRInt, sizeof(int),e8   offset(_pixels_per_inch), XtRInt, (caddr_t) &basedpi},3 {"sideMargin", "Margin", XtRString, sizeof(char *),h1   offset(sidemargin), XtRString, (caddr_t) NULL},O2 {"topMargin", "Margin", XtRString, sizeof(char *),0   offset(topmargin), XtRString, (caddr_t) NULL},0 {"xOffset", "Offset", XtRString, sizeof(char *),.   offset(xoffset), XtRString, (caddr_t) NULL},0 {"yOffset", "Offset", XtRString, sizeof(char *),.   offset(yoffset), XtRString, (caddr_t) NULL},- {"paper", "Paper", XtRString, sizeof(char *),/5   offset(paper), XtRString, (caddr_t) DEFAULT_PAPER},.1 {"altFont", "AltFont", XtRString, sizeof(char *), 3   offset(_alt_font), XtRString, (caddr_t) ALTFONT}, 
 #ifdef	MAKEPKS1 {"makePk", "MakePk", XtRBoolean, sizeof(Boolean),c%   offset(makepk), XtRString, "true"},o #endif/ {"mfMode", "MfMode", XtRString, sizeof(char *),*#   offset(mfmode), XtRString, NULL}, 7 {"listFonts", "ListFonts", XtRBoolean, sizeof(Boolean),s+   offset(_list_fonts), XtRString, "false"},i= {"reverseVideo", "ReverseVideo", XtRBoolean, sizeof(Boolean), '   offset(reverse), XtRString, "false"},a5 {"hushSpecials", "Hush", XtRBoolean, sizeof(Boolean), *   offset(_hush_spec), XtRString, "false"},6 {"hushLostChars", "Hush", XtRBoolean, sizeof(Boolean),+   offset(_hush_chars), XtRString, "false"},,6 {"hushChecksums", "Hush", XtRBoolean, sizeof(Boolean),)   offset(_hush_chk), XtRString, "false"},0/ {"safer", "Safer", XtRBoolean, sizeof(Boolean), %   offset(safer), XtRString, "false"},t5 {"foreground", "Foreground", XtRPixel, sizeof(Pixel),tB   offset(_fore_Pixel), XtRPixel, (caddr_t) &resource._fore_Pixel},7 {"foreground", "Foreground", XtRString, sizeof(char *),r1   offset(fore_color), XtRString, (caddr_t) NULL},*5 {"background", "Background", XtRPixel, sizeof(Pixel), B   offset(_back_Pixel), XtRPixel, (caddr_t) &resource._back_Pixel},7 {"background", "Background", XtRString, sizeof(char *),s1   offset(back_color), XtRString, (caddr_t) NULL},d7 {"borderColor", "BorderColor", XtRPixel, sizeof(Pixel),uB   offset(_brdr_Pixel), XtRPixel, (caddr_t) &resource._brdr_Pixel},9 {"borderColor", "BorderColor", XtRString, sizeof(char *),	1   offset(brdr_color), XtRString, (caddr_t) NULL},03 {"highlight", "Highlight", XtRPixel, sizeof(Pixel), >   offset(_hl_Pixel), XtRPixel, (caddr_t) &resource._hl_Pixel},5 {"highlight", "Highlight", XtRString, sizeof(char *), 1   offset(high_color), XtRString, (caddr_t) NULL},p7 {"cursorColor", "CursorColor", XtRPixel, sizeof(Pixel),o>   offset(_cr_Pixel), XtRPixel, (caddr_t) &resource._cr_Pixel},9 {"cursorColor", "CursorColor", XtRString, sizeof(char *),g1   offset(curs_color), XtRString, (caddr_t) NULL},	; {"iconGeometry", "IconGeometry", XtRString, sizeof(char *),e4   offset(icon_geometry), XtRString, (caddr_t) NULL},= {"keepPosition", "KeepPosition", XtRBoolean, sizeof(Boolean),c)   offset(keep_flag), XtRString, "false"},  #if	PS9 {"postscript", "Postscript", XtRBoolean, sizeof(Boolean),l*   offset(_postscript), XtRString, "true"},3 {"prescan", "Prescan", XtRBoolean, sizeof(Boolean),p&   offset(prescan), XtRString, "true"},9 {"allowShell", "AllowShell", XtRBoolean, sizeof(Boolean), +   offset(allow_shell), XtRString, "false"},	
 #ifdef	PS_DPS,+ {"dps", "DPS", XtRBoolean, sizeof(Boolean),o%   offset(useDPS), XtRString, "true"},G #endif #ifdef	PS_NEWS- {"news", "News", XtRBoolean, sizeof(Boolean),e&   offset(useNeWS), XtRString, "true"}, #endif #ifdef	PS_GS; {"ghostscript", "Ghostscript", XtRBoolean, sizeof(Boolean),i$   offset(useGS), XtRString, "true"},9 {"interpreter", "Interpreter", XtRString, sizeof(char *),_1   offset(gs_path), XtRString, (caddr_t) GS_PATH},n1 {"gsSafer", "Safer", XtRBoolean, sizeof(Boolean),n'   offset(gs_safer), XtRString, "true"},o1 {"palette", "Palette", XtRString, sizeof(char *),}4   offset(gs_palette), XtRString, (caddr_t) "Color"}, #endif #endif	/* PS */y) {"copy", "Copy", XtRBool3, sizeof(Bool3), $   offset(copy), XtRString, "maybe"},5 {"thorough", "Thorough", XtRBoolean, sizeof(Boolean),A(   offset(thorough), XtRString, "false"},7 {"debugLevel", "DebugLevel", XtRString, sizeof(char *), 0   offset(debug_arg), XtRString, (caddr_t) NULL},3 {"version", "Version", XtRBoolean, sizeof(Boolean),A,   offset(version_flag), XtRString, "false"}, #ifdef	BUTTONS1 {"expert", "Expert", XtRBoolean, sizeof(Boolean),A&   offset(expert), XtRString, "false"}, #endif> {"magnifierSize1", "MagnifierSize", XtRString, sizeof(char *),0   offset(mg_arg[0]), XtRString, (caddr_t) NULL},> {"magnifierSize2", "MagnifierSize", XtRString, sizeof(char *),0   offset(mg_arg[1]), XtRString, (caddr_t) NULL},> {"magnifierSize3", "MagnifierSize", XtRString, sizeof(char *),0   offset(mg_arg[2]), XtRString, (caddr_t) NULL},> {"magnifierSize4", "MagnifierSize", XtRString, sizeof(char *),0   offset(mg_arg[3]), XtRString, (caddr_t) NULL},> {"magnifierSize5", "MagnifierSize", XtRString, sizeof(char *),0   offset(mg_arg[4]), XtRString, (caddr_t) NULL}, #ifdef	GREYo- {"grey", "Grey", XtRBoolean, sizeof(Boolean),u(   offset(_use_grey), XtRString, "true"}, #endif };
 #undef	offsetu  # static	_Xconst	char	*usagestr[] = {" 	/* shrinkFactor */	"shrink",s #ifndef	VMSp 	/* S */			"density",n 	/* density */		silent,s #elsea 	/* density */		"density", #endif #ifdef	GREYe 	/* gamma */		"g", #endif 	/* p */			"pixels", 	/* margins */		"dimen", 	/* sidemargin */	"dimen", 	/* topmargin */		"dimen", 	/* offsets */		"dimen", 	/* xoffset */		"dimen", 	/* yoffset */		"dimen", 	/* paper */		"papertype", 	/* altfont */		"font",g 	/* mfmode */		"mode-def", 	/* rv */		"^-l", "-rv", 	/* mgs */		subst, 	/* msg1 */		silent, 	/* msg2 */		silent, 	/* msg3 */		silent, 	/* msg4 */		silent, 	/* msg5 */		silent, 	/* fg */		"color",p 	/* foreground */	silent,, 	/* bg */		"color",t 	/* background */	silent,t 	/* hl */		"color",c! 	/* bd */		"^-hl", "-bd <color>",r 	/* cr */		"color",o! 	/* bw */		"^-cr", "-bw <width>",A #ifndef VMS 2 	/* display */		"^-cr", "-display <host:display>", #else)3 	/* display */		"^-cr", "-display <host::display>",( #endif0 	/* geometry */		"^-cr", "-geometry <geometry>", 	/* icongeometry */	"geometry",X+ 	/* iconic */		"^-icongeometry", "-iconic",g #ifdef	BUTTONS. 	/* font */		"^-icongeometry", "-font <font>", #endif #ifdef	PS_GS 	/* interpreter */	"path",/ 	/* gspalette */		"monochrome|grayscale|color",o #endif 	/* debug */		"bitmask", 	/* [dummy] */		"z"p };   #ifdef	NOQUERY# #define	drawWidgetClass	widgetClassa #elseo   /* ARGSUSED */ static	XtGeometryResult	$ QueryGeometry(w, constraints, reply)
 	Widget	w;' 	XtWidgetGeometry *constraints, *reply;r {	* 	reply->request_mode = CWWidth | CWHeight; 	reply->width = page_w;d 	reply->height = page_h; 	return XtGeometryAlmost;r }t   #include <X11/IntrinsicP.h>" #include <X11/CoreP.h>   #ifdef	lintd WidgetClassRec	widgetClassRec; #endif  F 	/* if the following gives you trouble, just compile with -DNOQUERY */, static	WidgetClassRec	drawingWidgetClass = {   {f0     /* superclass         */    &widgetClassRec,'     /* class_name         */    "Draw",i2     /* widget_size        */    sizeof(WidgetRec),%     /* class_initialize   */    NULL,t%     /* class_part_initialize*/  NULL,f&     /* class_inited       */    FALSE,%     /* initialize         */    NULL,,%     /* initialize_hook    */    NULL,g1     /* realize            */    XtInheritRealize,U%     /* actions            */    NULL,g"     /* num_actions        */    0,%     /* resources          */    NULL,n"     /* num_resources      */    0,*     /* xrm_class          */    NULLQUARK,&     /* compress_motion    */    FALSE,%     /* compress_exposure  */    TRUE,e&     /* compress_enterleave*/    FALSE,&     /* visible_interest   */    FALSE,%     /* destroy            */    NULL, 0     /* resize             */    XtInheritResize,0     /* expose             */    XtInheritExpose,%     /* set_values         */    NULL,o%     /* set_values_hook    */    NULL,,9     /* set_values_almost  */    XtInheritSetValuesAlmost,)%     /* get_values_hook    */    NULL,a5     /* accept_focus       */    XtInheritAcceptFocus,m*     /* version            */    XtVersion,%     /* callback_offsets   */    NULL,)6     /* tm_table           */    XtInheritTranslations,.     /* query_geometry       */  QueryGeometry,<     /* display_accelerator  */  XtInheritDisplayAccelerator,$     /* extension            */  NULL   }( };  + #define	drawWidgetClass	&drawingWidgetClass    #endif	/* NOQUERY */   static	Arg	vport_args[] = {, #ifdef	BUTTONS  	{XtNborderWidth, (XtArgVal) 0},! 	{XtNtop,	(XtArgVal) XtChainTop},z' 	{XtNbottom,	(XtArgVal) XtChainBottom},g# 	{XtNleft,	(XtArgVal) XtChainLeft},,% 	{XtNright,	(XtArgVal) XtChainRight},p #endif" 	{XtNallowHoriz,	(XtArgVal) True},! 	{XtNallowVert,	(XtArgVal) True},  };   static	Arg	draw_args[] = { 	{XtNwidth,	(XtArgVal) 0}, 	{XtNheight,	(XtArgVal) 0},a #ifdef	GREYk 	{XtNbackground,	(XtArgVal) 0},  #endif 	{XtNx,		(XtArgVal) 0},e 	{XtNy,		(XtArgVal) 0}," 	{XtNlabel,	(XtArgVal) ""},a };   #ifdef	BUTTONS static	Arg	form_args[] = {$ 	{XtNdefaultDistance, (XtArgVal) 0}, }; #endif   #else	/* !TOOLKIT */   static	char	*display;  static	char	*geometry; static	char	*margins;z static	char	*offsets;t static	Boolean	hush; static	Boolean	iconic	= False;  % #define	ADDR(x)	(caddr_t) &resource.xs   static	struct option { 	_Xconst	char	*name; 	_Xconst	char	*resource;, 	enum {FalseArg, TrueArg, StickyArg, SepArg} 			argclass;< 	enum {BooleanArg, Bool3Arg, StringArg, NumberArg, FloatArg} 			argtype;h 	int		classcount;f 	_Xconst	char	*usagestr; 	caddr_t		address; }	options[] = {f& {"+",		NULL,		StickyArg, StringArg, 1,   NULL,		(caddr_t) &curr_page},,- {"-s",		"shrinkFactor", SepArg, NumberArg, 1,e%   "shrink",	(caddr_t)&shrink_factor}," #ifndef VMS"$ {"-S",		NULL,		SepArg, NumberArg, 2,   "density",	ADDR(_density)},r4 {"-density",	"densityPercent", SepArg, NumberArg, 1,   silent,	ADDR(_density)}, #else_4 {"-density",	"densityPercent", SepArg, NumberArg, 1,   "density",	ADDR(_density)},, #endif #ifdef	GREYa+ {"-nogrey",	NULL,		FalseArg, BooleanArg, 2,d   NULL,		ADDR(_use_grey)},, {"+nogrey",	"grey",		TrueArg, BooleanArg, 1,   NULL,		ADDR(_use_grey)},( {"-gamma",	"gamma",	SepArg,	FloatArg, 1,   "g",		ADDR(_gamma)}, #endif. {"-p",		"pixelsPerInch", SepArg, NumberArg, 1,$   "pixels",	ADDR(_pixels_per_inch)},, {"-margins",	"Margin",	SepArg,	StringArg, 3,   "dimen",	(caddr_t) &margins},d3 {"-sidemargin",	"sideMargin",	SepArg,	StringArg, 1,,   "dimen",	ADDR(sidemargin)}, 1 {"-topmargin",	"topMargin",	SepArg,	StringArg, 1,"   "dimen",	ADDR(topmargin)},, {"-offsets",	"Offset",	SepArg,	StringArg, 3,   "dimen",	(caddr_t) &offsets},r- {"-xoffset",	"xOffset",	SepArg,	StringArg, 1,i   "dimen",	ADDR(xoffset)},- {"-yoffset",	"yOffset",	SepArg,	StringArg, 1,"   "dimen",	ADDR(yoffset)},) {"-paper",	"paper",	SepArg,	StringArg, 1,o   "papertype",	ADDR(paper)},- {"-altfont",	"altFont",	SepArg,	StringArg, 1,R   "font",	ADDR(_alt_font)}, 
 #ifdef	MAKEPKg0 {"-nomakepk",	"makePk",	FalseArg, BooleanArg, 2,   NULL,		ADDR(makepk)},s/ {"+nomakepk",	"makePk",	TrueArg, BooleanArg, 1,g   NULL,		ADDR(makepk)},P #endif+ {"-mfmode",	"mfMode",	SepArg,	StringArg, 1,c   "mode-def",	ADDR(mfmode)},& {"-l",		NULL,		TrueArg, BooleanArg, 2,   NULL,		ADDR(_list_fonts)},- {"+l",		"listFonts",	FalseArg, BooleanArg, 1,    NULL,		ADDR(_list_fonts)},' {"-rv",		NULL,		TrueArg, BooleanArg, 2,n   NULL,		ADDR(reverse)},1 {"+rv",		"reverseVideo",	FalseArg, BooleanArg, 1,l   NULL,		ADDR(reverse)},% {"-mgs",	NULL,		SepArg, StringArg, 2,_   subst,	ADDR(mg_arg[0])},0 {"-mgs1",	"magnifierSize1",SepArg, StringArg, 1,   silent,	ADDR(mg_arg[0])},n0 {"-mgs2",	"magnifierSize2",SepArg, StringArg, 1,   silent,	ADDR(mg_arg[1])},t0 {"-mgs3",	"magnifierSize3",SepArg, StringArg, 1,   silent,	ADDR(mg_arg[2])}, 0 {"-mgs4",	"magnifierSize4",SepArg, StringArg, 1,   silent,	ADDR(mg_arg[3])},e0 {"-mgs5",	"magnifierSize5",SepArg, StringArg, 1,   silent,	ADDR(mg_arg[4])},d( {"-hush",	NULL,		TrueArg, BooleanArg, 6,   NULL,		(caddr_t) &hush},+ {"+hush",	"Hush",		FalseArg, BooleanArg, 5,u   NULL,		(caddr_t) &hush},0 {"-hushspecials", NULL,		TrueArg, BooleanArg, 2,   NULL,		ADDR(_hush_spec)},X: {"+hushspecials", "hushSpecials", FalseArg, BooleanArg, 1,   NULL,		ADDR(_hush_spec)}, - {"-hushchars",	NULL,		TrueArg, BooleanArg, 2,s   NULL,		ADDR(_hush_chars)},8 {"+hushchars",	"hushLostChars", FalseArg, BooleanArg, 1,   NULL,		ADDR(_hush_chars)},0 {"-hushchecksums", NULL,	TrueArg, BooleanArg, 2,   NULL,		ADDR(_hush_chk)},; {"+hushchecksums","hushChecksums", FalseArg, BooleanArg, 1,r   NULL,		ADDR(_hush_chk)},) {"-safer",	NULL,		TrueArg, BooleanArg, 2,*   NULL,		ADDR(safer)},, {"+safer",	"safer",	FalseArg, BooleanArg, 1,   NULL,		ADDR(safer)},5 {"-borderwidth", "borderWidth",	SepArg,	NumberArg, 1,    silent,	(caddr_t) &bwidth},z% {"-fg",		NULL,		SepArg,	StringArg, 2,(   "color",	ADDR(fore_color)},X3 {"-foreground",	"foreground",	SepArg,	StringArg, 1,f   silent,	ADDR(fore_color)},% {"-bg",		NULL,		SepArg,	StringArg, 2,    "color",	ADDR(back_color)}, 3 {"-background",	"background",	SepArg,	StringArg, 1,s   silent,	ADDR(back_color)},+ {"-hl",		"highlight",	SepArg,	StringArg, 1,c   "color",	ADDR(high_color)}, % {"-bd",		NULL,		SepArg,	StringArg, 2,p   "color",	ADDR(brdr_color)},e4 {"-bordercolor","borderColor",	SepArg,	StringArg, 1,   silent,	ADDR(brdr_color)},- {"-cr",		"cursorColor",	SepArg,	StringArg, 1,    "color",	ADDR(curs_color)},a% {"-bw",		NULL,		SepArg,	NumberArg, 2,m   "width",	(caddr_t) &bwidth}, #ifndef VMS/) {"-display",	NULL,		SepArg,	StringArg, 1,a&   "host:display", (caddr_t) &display}, #else ) {"-display",	NULL,		SepArg,	StringArg, 1,"'   "host::display", (caddr_t) &display},	 #endif/ {"-geometry",	"geometry",	SepArg,	StringArg, 1, #   "geometry",	(caddr_t) &geometry},,8 {"-icongeometry","iconGeometry",StickyArg, StringArg, 1,#   "geometry",	ADDR(icon_geometry)},e* {"-iconic",	NULL,		TrueArg, BooleanArg, 2,   NULL,		(caddr_t) &iconic},. {"+iconic",	"iconic",	FalseArg, BooleanArg, 1,   NULL,		(caddr_t) &iconic},( {"-keep",	NULL,		TrueArg, BooleanArg, 2,   NULL,		ADDR(keep_flag)},2 {"+keep",	"keepPosition",	FalseArg, BooleanArg, 1,   NULL,		ADDR(keep_flag)},& {"-copy",	NULL,		TrueArg, Bool3Arg, 2,   NULL,		ADDR(copy)},e) {"+copy",	"copy",		FalseArg, Bool3Arg, 1,o   NULL,		ADDR(copy)},,, {"-thorough",	NULL,		TrueArg, BooleanArg, 2,   NULL,		ADDR(thorough)},s2 {"+thorough",	"thorough",	FalseArg, BooleanArg, 1,   NULL,		ADDR(thorough)},/ #if	PS1 {"-nopostscript", NULL,		FalseArg, BooleanArg, 2,t   NULL,		ADDR(_postscript)},7 {"+nopostscript", "postscript",	TrueArg, BooleanArg, 1,,   NULL,		ADDR(_postscript)},+ {"-noscan", NULL,		FalseArg, BooleanArg, 2,    NULL,		ADDR(prescan)},. {"+noscan",	"prescan",	TrueArg, BooleanArg, 1,   NULL,		ADDR(prescan)},. {"-allowshell",	NULL,		TrueArg, BooleanArg, 2,   NULL,		ADDR(allow_shell)},6 {"+allowshell",	"allowShell",	FalseArg, BooleanArg, 1,   NULL,		ADDR(allow_shell)},
 #ifdef	PS_DPSo* {"-nodps",	NULL,		FalseArg, BooleanArg, 2,   NULL,		ADDR(useDPS)},d* {"+nodps",	"dps",		TrueArg, BooleanArg, 1,   NULL,		ADDR(useDPS)},  #endif #ifdef	PS_NEWS+ {"-nonews",	NULL,		FalseArg, BooleanArg, 2,/   NULL,		ADDR(useNeWS)},, {"+nonews",	"news",		TrueArg, BooleanArg, 1,   NULL,		ADDR(useNeWS)}, #endif #ifdef	PS_GS1 {"-noghostscript",NULL,		FalseArg, BooleanArg, 2,/   NULL,		ADDR(useGS)},8 {"+noghostscript","ghostscript", TrueArg, BooleanArg, 1,   NULL,		ADDR(useGS)},5 {"-interpreter", "interpreter",	SepArg,	StringArg, 1,s   "path",	ADDR(gs_path)},s. {"-nogssafer",	NULL,		FalseArg, BooleanArg, 2,   NULL,		ADDR(gs_safer)},m1 {"+nogssafer",	"gsSafer",	TrueArg, BooleanArg, 1,o   NULL,		ADDR(gs_safer)},*/ {"-gspalette",	"palette",	SepArg,	StringArg, 1,_2   "monochrome|grayscale|color",	ADDR(gs_palette)}, #endif #endif	/* PS */y. {"-debug",	"debugLevel",	SepArg,	StringArg, 1,   "bitmask",	ADDR(debug_arg)},+ {"-version",	NULL,		TrueArg, BooleanArg, 2,    NULL,		ADDR(version_flag)}, 0 {"+version",	"version",	FalseArg, BooleanArg, 1,   NULL,		ADDR(version_flag)},t };   #endif	/* !TOOLKIT */    static	NORETURN void	 usage() {  #ifdef	TOOLKIT 	XrmOptionDescRec *opt;A$ 	_Xconst	char	**usageptr = usagestr; #else  	struct option	*opt; #endif 	_Xconst char	**sv	= subst_val;a 	_Xconst char	*str1; 	_Xconst char	*str2; 	int		col	= 23;e 	int		n;  * 	Fputs("Usage: xdvi [+[<page>]]", stderr);@ 	for (opt = options; opt < options + XtNumber(options); ++opt) { #ifdef	TOOLKIT 	    str1 = opt->option;  	    if (*str1 != '-') continue; 	    str2 = NULL;t* 	    if (opt->argKind != XrmoptionNoArg) { 		str2 = *usageptr++;a 		if (str2 == silent) continue;a 		if (str2 == subst) { 		    str1 = *sv++;o 		    str2 = NULL; 		}l 	    } 	    for (;;) {g 		n = strlen(str1) + 3;h* 		if (str2 != NULL) n += strlen(str2) + 3;& 		if (col + n < 80) Putc(' ', stderr); 		else { 		    Fputs("\n\t", stderr); 		    col = 8 - 1; 		}{ 		if (str2 == NULL) $ 		    Fprintf(stderr, "[%s]", str1); 		else/ 		    Fprintf(stderr, "[%s <%s>]", str1, str2);	 		col += n;} 		if (**usageptr != '^')6 			 || strcmp(*usageptr + 1, opt->option) != 0) break;
 		++usageptr;i 		str1 = *usageptr++;  		str2 = NULL; 	    } #else	/* !TOOLKIT */ 	    str1 = opt->name; 	    str2 = opt->usagestr;2 	    if (*str1 != '-' || str2 == silent) continue; 	    if (str2 == subst) {	 		str1 = *sv++;n 		str2 = NULL; 	    } 	    n = strlen(str1) + 3;- 	    if (str2 != NULL) n += strlen(str2) + 3;s) 	    if (col + n < 80) Putc(' ', stderr);, 	    else {a 		Fputs("\n\t", stderr); 		col = 8 - 1; 	    } 	    if (str2 == NULL)  		Fprintf(stderr, "[%s]", str1);	 	    else	+ 		Fprintf(stderr, "[%s <%s>]", str1, str2);  	    col += n; #endif 	}% 	if (col + 9 < 80) Putc(' ', stderr);r 	else Fputs("\n\t", stderr); 	Fputs("dvi_file\n", stderr);s	 	exit(1);d }t  
 static	int atopix(arg)  	_Xconst	char	*arg;S {r 	int		len	= strlen(arg); 	_Xconst char	*arg_end = arg;i 	char		tmp[11];e  @ 	while ((*arg_end >= '0' && *arg_end <= '9') || *arg_end == '.')6 	    if (arg_end >= arg + XtNumber(tmp) - 1) return 0; 	    else ++arg_end;  	bcopy(arg, tmp, arg_end - arg); 	tmp[arg_end - arg] = '\0';r  @ 	return (len > 2 && arg[len - 2] == 'c' && arg[len - 1] == 'm' ?8 		1.0 / 2.54 : 1.0) * atof(tmp) * pixels_per_inch + 0.5; }	   /**	  **	Main programs start here.m  **/   #ifdef	TOOLKIT   static	Arg	temp_args1[] = {g 	{XtNiconX,	(XtArgVal) 0}, 	{XtNiconY,	(XtArgVal) 0}, };  = static	Arg	temp_args2 = {XtNborderWidth,	(XtArgVal) &bwidth};"   static	Pixmap	icon_pm;   static	Arg	temp_args3[] = {m& 	{XtNiconPixmap,	(XtArgVal) &icon_pm}, };   static	Arg	temp_args4[] = {" 	{XtNtitle,	(XtArgVal) 0}, 	{XtNiconName,	(XtArgVal) 0},r 	{XtNinput,	(XtArgVal) True},a };   static	Arg	set_wh_args[] = { 	{XtNwidth,	(XtArgVal) 0}, 	{XtNheight,	(XtArgVal) 0},, };   /*?  *	Convert string to yes/no/maybe.  Adapted from the X toolkit.,  */p   /*ARGSUSED*/L Boolean XtCvtStringToBool3(dpy, args, num_args, fromVal, toVal, closure_ret) 	Display		*dpy;, 	XrmValuePtr	args; 	Cardinal	*num_args; 	XrmValuePtr	fromVal;	 	XrmValuePtr	toVal;o 	XtPointer	*closure_ret; {a% 	String		str	= (String)fromVal->addr;r 	static Bool3	value;  $ 	if (   memicmp(str, "true", 5) == 0# 	    || memicmp(str, "yes", 4) == 0 " 	    || memicmp(str, "on", 3) == 00 	    || memicmp(str, "1", 2) == 0)	value = True;  ' 	else if (memicmp(str, "false", 6) == 0,$ 	    ||   memicmp(str, "no", 3) == 0% 	    ||   memicmp(str, "off", 4) == 0e3 	    ||   memicmp(str, "0", 2) == 0)	value = False;s  7 	else if (memicmp(str, "maybe", 6) == 0)	value = Maybe;,   	else {N< 	    XtDisplayStringConversionWarning(dpy, str, XtRBoolean); 	    return False; 	}   	if (toVal->addr != NULL) {	' 	    if (toVal->size < sizeof(Bool3)) {i 		toVal->size = sizeof(Bool3); 		return False;[ 	    }% 	    *(Bool3 *)(toVal->addr) = value;n 	}& 	else toVal->addr = (XPointer) &value;   	toVal->size = sizeof(Bool3);r
 	return True;i }t   #else	/* !TOOLKIT */   struct _resource	resource = {S 	/* density		*/	40,t #ifdef	GREY[ 	/* gamma		*/	1.0, #endif 	/* pixels_per_inch	*/	BDPI, 	/* sidemargin		*/	NULL, 	/* topmargin		*/	NULL,o 	/* xoffset		*/	NULL,( 	/* yoffset		*/	NULL,s 	/* paper		*/	DEFAULT_PAPER, 	/* alt_font		*/	ALTFONT,(
 #ifdef	MAKEPK  	/* makepk		*/	True, #endif 	/* mfmode		*/	NULL, 	/* list_fonts		*/	False,_ 	/* reverse		*/	False, 	/* hush_spec		*/	False, 	/* hush_chars		*/	False,_ 	/* hush_chk		*/	False," 	/* safer		*/	False, 	/* fore_color		*/	NULL, 	/* back_color		*/	NULL, 	/* brdr_color		*/	NULL, 	/* high_color		*/	NULL, 	/* curs_color		*/	NULL, 	/* fore_Pixel		*/	(Pixel) 0,, 	/* back_Pixel		*/	(Pixel) 0,U 	/* icon_geometry	*/	NULL, 	/* keep_flag		*/	False, 	/* copy			*/	Maybe, 	/* thorough		*/	False,, #if	PS 	/* postscript		*/	True, 	/* prescan		*/	True,, 	/* allow_shell		*/	Maybe,
 #ifdef	PS_DPSu 	/* useDPS		*/	True, #endif #ifdef	PS_NEWS 	/* useNeWS		*/	True,	 #endif #ifdef	PS_GS 	/* useGS		*/	True,} 	/* gs_path		*/	GS_PATH, 	/* gs_safer		*/	True, 	/* gs_palette		*/	"Color",o #endif #endif	/* PS */e 	/* debug_arg		*/	NULL,c 	/* version_flag		*/	False,". 	/* mg_arg		*/	{NULL, NULL, NULL, NULL, NULL}, #ifdef	GREY	 	/* use_grey		*/	True, #endif };   static	Pixel5 string_to_pixel(strp)		/* adapted from the toolkit */N
 	char	**strp;t {g 	char	*str = *strp;A 	Status	status;e 	XColor	color, junk;  + 	if (*str == '#') {	/* an rgb definition */R> 	    status = XParseColor(DISP, DefaultColormapOfScreen(SCRN), 		str, &color);u 	    if (status != 0)N; 		status = XAllocColor(DISP, DefaultColormapOfScreen(SCRN),  		    &color); 	} 	else	/* a name */C 	    status = XAllocNamedColor(DISP, DefaultColormapOfScreen(SCRN),d 		str, &color, &junk); 	if (status == 0) {sI 	    Fprintf(stderr, "Cannot allocate colormap entry for \"%s\"\n", str);g 	    *strp = NULL; 	    return (Pixel) 0; 	} 	return color.pixel; }"   /*E  *	Process the option table.  This is not guaranteed for all possible 5  *	option tables, but at least it works for this one.a  */)   static	voidi parse_options(argc, argv) 
 	int argc;
 	char **argv;a {_ 	char	**arg; 	char	**argvend = argv + argc; 	char	*optstring;A 	caddr_t	addr;* 	struct option *opt, *lastopt, *candidate; 	int	len1, len2, matchlen;   	/*,* 	 * Step 1.  Process command line options. 	 */- 	for (arg = argv + 1; arg < argvend; ++arg) {o 	    len1 = strlen(*arg);o 	    candidate = NULL; 	    matchlen = 0;D 	    for (opt = options; opt < options + XtNumber(options); ++opt) { 		len2 = strlen(opt->name);A# 		if (opt->argclass == StickyArg) {r@ 		    if (matchlen <= len2 && !strncmp(*arg, opt->name, len2)) { 			candidate = opt;  			matchlen = len2;, 		    }r 		},. 		else if (len1 <= len2 && matchlen <= len1 &&( 		    !strncmp(*arg, opt->name, len1)) { 		    if (len1 == len2) {p 			candidate = opt;l	 			break;  		    }A+ 		    if (matchlen < len1) candidate = opt;g= 		    else if (candidate && candidate->argclass != StickyArg)	 			candidate = NULL; 		    matchlen = len1; 		}D 	    } 	    if (candidate == NULL) {d( 		if (**arg == '-' || dvi_name) usage(); 		else { 		    dvi_name = *arg; 		    continue;o 		}A 	    }) 		/* flag it for subsequent processing */_. 	    candidate->resource = (char *) candidate; 		/* store the value */) 	    addr = candidate->address; # 	    switch (candidate->argclass) {)7 		case FalseArg:	*((Boolean *) addr) = False; continue;r5 		case TrueArg:	*((Boolean *) addr) = True; continue;c= 		case StickyArg:	optstring = *arg + strlen(candidate->name);G 		    break; 		case SepArg: 		    ++arg;" 		    if (arg >= argvend) usage(); 		    optstring = *arg;N 		    break; 	    }" 	    switch (candidate->argtype) {7 		case StringArg:	*((char **) addr) = optstring; break;U; 		case NumberArg:	*((int *) addr) = atoi(optstring); break;i= 		case FloatArg:  *((float *) addr) = atof(optstring); break; 
 		default:  ;/ 	    } 	} 	/*gF 	 * Step 2.  Propagate classes for command line arguments.  Backwards. 	 */C 	for (opt = options + XtNumber(options) - 1; opt >= options; --opt) ) 	    if (opt->resource == (char *) opt) {A 		addr = opt->address;" 		lastopt = opt + opt->classcount;; 		for (candidate = opt; candidate < lastopt; ++candidate) { ( 		    if (candidate->resource != NULL) { 			switch (opt->argtype) { 			    case BooleanArg:e0 			    case Bool3Arg:	/* same type as Boolean */' 				*((Boolean *) candidate->address) =o 				    *((Boolean *) addr);
 				break; 			    case StringArg:% 				*((char **) candidate->address) =N 				    *((char **) addr);
 				break; 			    case NumberArg:4 				*((int *) candidate->address) = *((int *) addr);
 				break; 			    case FloatArg:i% 				*((float *) candidate->address) =f 				    *((float *) addr);
 				break; 			} 			candidate->resource = NULL; 		    }= 		}; 	    }  , 	if ((DISP = XOpenDisplay(display)) == NULL)  	    oops("Can't open display");% 	SCRN = DefaultScreenOfDisplay(DISP);' 	/*t2 	 * Step 3.  Handle resources (including classes). 	 */> 	for (opt = options; opt < options + XtNumber(options); ++opt) 	    if (opt->resource &&p> 		    ((optstring = XGetDefault(DISP, prog, opt->resource)) ||> 		    (optstring = XGetDefault(DISP, "XDvi", opt->resource)))) 		{a& 		    lastopt = opt + opt->classcount;= 		    for (candidate = opt; candidate < lastopt; ++candidate)p; 			if (candidate->resource != NULL) switch (opt->argtype) {| 			    case Bool3Arg:u3 				if (       memicmp(optstring, "maybe", 6) == 0)t 				{L/ 				    * (Bool3 *) candidate->address = Maybe;s 				    break; 				}n1 				/* otherwise, fall through; the underlying */r2 				/* types of Bool3 and Boolean are the same. */ 			    case BooleanArg: & 				* (Boolean *) candidate->address =- 				    (  memicmp(optstring, "true", 5) == 0s, 				    || memicmp(optstring, "yes", 4) == 0+ 				    || memicmp(optstring, "on", 3) == 0s, 				    || memicmp(optstring, "1", 2) == 0);
 				break; 			    case StringArg:/ 				* (char **) candidate->address = optstring;t
 				break; 			    case NumberArg:3 				* (int *) candidate->address = atoi(optstring);n
 				break; 			    case FloatArg:g$ 				* (float *) candidate->address = 				    atof(optstring); 			} 		}e }    #endif	/* TOOLKIT */  & static	_Xconst	char	*paper_types[] = { 	"us",		"8.5x11",  	"usr",		"11x8.5", 	"legal",	"8.5x14",n# 	"foolscap",	"13.5x17.0",	/* ??? */     	/* ISO `A' formats, Portrait */ 	"a1",		"59.4x84.0cm", 	"a2",		"42.0x59.4cm", 	"a3",		"29.7x42.0cm", 	"a4",		"21.0x29.7cm", 	"a5",		"14.85x21.0cm",) 	"a6",		"10.5x14.85cm",a 	"a7",		"7.42x10.5cm",  ! 	/* ISO `A' formats, Landscape */V 	"a1r",		"84.0x59.4cm",P 	"a2r",		"59.4x42.0cm",A 	"a3r",		"42.0x29.7cm",t 	"a4r",		"29.7x21.0cm",i 	"a5r",		"21.0x14.85cm", 	"a6r",		"14.85x10.5cm", 	"a7r",		"10.5x7.42cm",t    	/* ISO `B' formats, Portrait */ 	"b1",		"70.6x100.0cm",; 	"b2",		"50.0x70.6cm", 	"b3",		"35.3x50.0cm", 	"b4",		"25.0x35.3cm", 	"b5",		"17.6x25.0cm", 	"b6",		"13.5x17.6cm", 	"b7",		"8.8x13.5cm",e  ! 	/* ISO `B' formats, Landscape */S 	"b1r",		"100.0x70.6cm", 	"b2r",		"70.6x50.0cm",r 	"b3r",		"50.0x35.3cm",r 	"b4r",		"35.3x25.0cm",  	"b5r",		"25.0x17.6cm",i 	"b6r",		"17.6x13.5cm",P 	"b7r",		"13.5x8.8cm",    	/* ISO `C' formats, Portrait */ 	"c1",		"64.8x91.6cm", 	"c2",		"45.8x64.8cm", 	"c3",		"32.4x45.8cm", 	"c4",		"22.9x32.4cm", 	"c5",		"16.2x22.9cm", 	"c6",		"11.46x16.2cm",  	"c7",		"8.1x11.46cm",  ! 	/* ISO `C' formats, Landscape */  	"c1r",		"91.6x64.8cm",  	"c2r",		"64.8x45.8cm",a 	"c3r",		"45.8x32.4cm",  	"c4r",		"32.4x22.9cm",0 	"c5r",		"22.9x16.2cm"," 	"c6r",		"16.2x11.46cm", 	"c7r",		"11.46x8.1cm",) };   static	Boolean set_paper_type() { 	_Xconst	char	*arg, *arg1; 	char	temp[21];N 	_Xconst	char	**p;	 	char	*q;n  = 	if (strlen(resource.paper) > sizeof(temp) - 1) return False;V 	arg = resource.paper;
 	q = temp;' 	for (;;) {	/* convert to lower case */  	    char c = *arg++;u0 	    if (c >= 'A' && c <= 'Z') c ^= ('a' ^ 'A'); 	    *q++ = c; 	    if (c == '\0') break; 	} 	arg = temp; 	/* perform substitutions */G 	for (p = paper_types; p < paper_types + XtNumber(paper_types); p += 2) ! 	    if (strcmp(temp, *p) == 0) { 
 		arg = p[1];. 		break; 	    } 	arg1 = index(arg, 'x');  	if (arg1 == NULL) return False;  	unshrunk_paper_w = atopix(arg);% 	unshrunk_paper_h = atopix(arg1 + 1);	9 	return (unshrunk_paper_w != 0 && unshrunk_paper_h != 0);P }    /*  *	main programe  */    into main(argc, argv)
 	int argc;
 	char **argv;  {e   #ifndef	TOOLKIT  	XSizeHints	size_hints;  	XWMHints	wmhints; #endif	/* TOOLKIT */ 	Dimension	screen_w, screen_h; 	char		*title_name;, 	char		*icon_name; 	unsigned	baselen; 	int	i;L   #ifndef	VMSl 	prog = rindex(*argv, '/');	 #else, 	prog = rindex(*argv, ']');0 #endif- 	if (prog != NULL) ++prog; else prog = *argv;/  
 #ifdef	VMS8 	if (index(prog, '.') != NULL) *index(prog, '.') = '\0'; #endif  . 	/* This has to be a special case, for now. */  3 	if (argc == 2 && (strcmp(argv[1], "-version") == 0/* 		|| strcmp(argv[1], "--version") == 0)) {% 	    Puts((_Xconst char *) &version);P
 	    exit(0);	 	}   #ifdef	TOOLKITC 	top_level = XtInitialize(prog, "XDvi", options, XtNumber(options),  		&argc, argv);  	while (--argc > 0) {* 	    if (*(*++argv) == '+')/! 		if (curr_page != NULL) usage();L 		else curr_page = *argv + 1;E( 	    else if (dvi_name != NULL) usage(); 		else dvi_name = *argv; 	}  < 	XtSetTypeConverter(XtRString, XtRBool3, XtCvtStringToBool3,! 	    NULL, 0, XtCacheNone, NULL);   < 	XtGetApplicationResources(top_level, (XtPointer) &resource,< 	    application_resources, XtNumber(application_resources), 	    (ArgList) NULL, 0); 	DISP = XtDisplay(top_level);s 	SCRN = XtScreen(top_level);' 	shrink_factor = resource.shrinkfactor;}   #else	/* !TOOLKIT */   	parse_options(argc, argv);S 	if (resource.fore_color)S8 	    fore_Pixel = string_to_pixel(&resource.fore_color); 	if (resource.back_color)l8 	    back_Pixel = string_to_pixel(&resource.back_color); 	if (resource.brdr_color);8 	    brdr_Pixel = string_to_pixel(&resource.brdr_color); 	if (resource.high_color)n6 	    hl_Pixel = string_to_pixel(&resource.high_color); 	if (resource.curs_color))6 	    cr_Pixel = string_to_pixel(&resource.curs_color);   #endif	/* TOOLKIT */  B 	if (shrink_factor <= 0 || density <= 0 || pixels_per_inch <= 0 || 		dvi_name == NULL) usage();4 	if (shrink_factor != 1) bak_shrink = shrink_factor;# 	mane.shrinkfactor = shrink_factor;n  	if (resource.debug_arg != NULL)D 	    debug = isdigit(*resource.debug_arg) ? atoi(resource.debug_arg) 		: DBG_ALL;? 	if (resource.sidemargin) home_x = atopix(resource.sidemargin);m= 	if (resource.topmargin) home_y = atopix(resource.topmargin);-7 	offset_x = resource.xoffset ? atopix(resource.xoffset)  	    : pixels_per_inch; 7 	offset_y = resource.yoffset ? atopix(resource.yoffset)  	    : pixels_per_inch;n 	if (!set_paper_type())l; 	    oops("Don't recognize paper type %s", resource.paper);e 	for (i = 0; i < 5; ++i)& 	    if (resource.mg_arg[i] != NULL) {
 		char	*s;  9 		mg_size[i].w = mg_size[i].h = atoi(resource.mg_arg[i]);d% 		s = index(resource.mg_arg[i], 'x');a 		if (s != NULL) {! 		    mg_size[i].h = atoi(s + 1);i. 		    if (mg_size[i].h <= 0) mg_size[i].w = 0; 		}a 	    } #if	PS 	if (resource.safer) {" 	    resource.allow_shell = False; #ifdef	PS_GS 	    resource.gs_safer = True; #endif 	} #endif	/* PS */( #ifdef	PS_GS 	{% 	    _Xconst char *CGMcgm = "CGMcgm";  	    _Xconst char *cgmp;  2 	    cgmp = index(CGMcgm, resource.gs_palette[0]); 	    if (cgmp == NULL)0 		oops("Illegal value %s for gs palette option", 		    resource.gs_palette);iB 	    if (cgmp >= CGMcgm + 3) resource.gs_palette[0] = *(cgmp - 3); 	} #endif< 	if (resource.version_flag) Puts((_Xconst char *) &version);   	/* $ 	 *	Open the dvi file and set titles 	 */   	init_font_open(); 	open_dvi_file();	 	if (curr_page) { B 		current_page = (*curr_page ? atoi(curr_page) : total_pages) - 1;? 		if (current_page < 0 || current_page >= total_pages) usage();g 	}# 	icon_name = rindex(dvi_name, '/');/? 	if (icon_name != NULL) ++icon_name; else icon_name = dvi_name;a 	baselen = strlen(icon_name);i 	if (baselen >= sizeof(".dvi")= 		&& strcmp(icon_name + baselen - sizeof(".dvi") + 1, ".dvi")A  		== 0) {		/* remove the .dvi */
 	    char *p;c  # 	    baselen -= sizeof(".dvi") - 1;d+ 	    p = xmalloc(baselen + 1, "icon name");a1 	    (void) strncpy(p, icon_name, (int) baselen);p 	    p[baselen] = '\0';A 	    icon_name = p;l 	}A 	title_name = xmalloc(baselen + sizeof("Xdvi:  "), "title name");  	Strcpy(title_name, "Xdvi:  ");  	Strcat(title_name, icon_name);:   	/*(
 	 *	Colors 	 */   	if (resource.reverse) {E 	    if (!resource.fore_color) fore_Pixel = WhitePixelOfScreen(SCRN);dE 	    if (!resource.back_color) back_Pixel = BlackPixelOfScreen(SCRN);	 	    /* Set them nonzero */eC 	    resource.fore_color = resource.back_color = (char *) &version;e	 	} else {LE 	    if (!resource.fore_color) fore_Pixel = BlackPixelOfScreen(SCRN);LE 	    if (!resource.back_color) back_Pixel = WhitePixelOfScreen(SCRN);S 	}   #ifdef	GREYp% 	if (DefaultDepthOfScreen(SCRN) == 1)s 	    use_grey = False; #endif   	copy = resource.copy; 	if (copy == Maybe)i #ifdef	GREYr, 	    copy = (!resource.thorough && !use_grey% 		&& DefaultDepthOfScreen(SCRN) > 1);i #elsee 	    copy = (!resource.thoroughr% 		&& DefaultDepthOfScreen(SCRN) > 1);- #endif   #ifdef	GREY 3 	if (resource._gamma == 0.0) resource._gamma = 1.0;  	if (use_grey) 	    init_pix(True); 	elsep #endif 	{ 	    XGCValues	values;9 	    Pixel	set_bits = (Pixel) (fore_Pixel & ~back_Pixel);	9 	    Pixel	clr_bits = (Pixel) (back_Pixel & ~fore_Pixel);	  J #define	MakeGC(fcn, fg, bg)	(values.function = fcn, values.foreground=fg,\ 		values.background=bg,\, 		XCreateGC(DISP, RootWindowOfScreen(SCRN),\2 			GCFunction|GCForeground|GCBackground, &values))  ( 	    if (copy || (set_bits && clr_bits))2 		ruleGC = MakeGC(GXcopy, fore_Pixel, back_Pixel); 	    if (copy) foreGC = ruleGC;	- 	    else if (!resource.thorough && ruleGC) {	 		foreGC = ruleGC;9 		Puts("Note:  overstrike characters may be incorrect.");t 	    } 	    else {c3 		if (set_bits) foreGC = MakeGC(GXor, set_bits, 0);o 		if (clr_bits || !set_bits)& 		    *(foreGC ? &foreGC2 : &foreGC) =& 			MakeGC(GXandInverted, clr_bits, 0); 		if (!ruleGC) ruleGC = foreGC;  	    } 	}   	{ 	    XGCValues	values;   	    highGC = ruleGC;1 	    if (resource.high_color)a0 		highGC = MakeGC(GXcopy, hl_Pixel, back_Pixel); 	}  3 	if (!resource.brdr_color) brdr_Pixel = fore_Pixel;m1 	if (!resource.high_color) hl_Pixel = fore_Pixel;    #ifndef	VMS92 	ready_cursor = XCreateFontCursor(DISP, XC_cross);3 	redraw_cursor = XCreateFontCursor(DISP, XC_watch);, #elsea1 	DECWCursorFont = XLoadFont(DISP, "DECW$CURSOR");.( 	XSetFont(DISP, foreGC, DECWCursorFont);I 	redraw_cursor = XCreateGlyphCursor(DISP, DECWCursorFont, DECWCursorFont,"- 		decw$c_wait_cursor, decw$c_wait_cursor + 1,r. 		&resource.fore_color, &resource.back_color);G 	MagnifyPixmap = XCreateBitmapFromData (DISP, RootWindowOfScreen(SCRN),55 		mag_glass_bits, mag_glass_width, mag_glass_height); G 	ready_cursor = XCreatePixmapCursor(DISP, MagnifyPixmap, MagnifyPixmap,"- 		&resource.back_color, &resource.fore_color,"$ 		mag_glass_x_hot, mag_glass_y_hot); #endif	/* VMS */  / 	if (!resource.curs_color) cr_Pixel = hl_Pixel;C 	{ 	    XColor bg_Color, cr_Color;x  ! 	    bg_Color.pixel = back_Pixel;3A 	    XQueryColor(DISP, DefaultColormapOfScreen(SCRN), &bg_Color);  	    cr_Color.pixel = cr_Pixel;	A 	    XQueryColor(DISP, DefaultColormapOfScreen(SCRN), &cr_Color);6> 	    XRecolorCursor(DISP, ready_cursor, &cr_Color, &bg_Color);? 	    XRecolorCursor(DISP, redraw_cursor, &cr_Color, &bg_Color);2 	}   #ifdef	TOOLKIT   	/*. 	 *	Windows (toolkit)o 	 */  / 		/* The following code is lifted from Xterm */a& 	if (resource.icon_geometry != NULL) { 	    int scr, junk;e    	    for(scr = 0;	/* yyuucchh */% 		SCRN != ScreenOfDisplay(DISP, scr);q	 		scr++);f  < 	    (void) XGeometry(DISP, scr, resource.icon_geometry, "", 			0, 0, 0, 0, 0,&  			(int *) &temp_args1[0].value,/ 			(int *) &temp_args1[1].value, &junk, &junk);=> 	    XtSetValues(top_level, temp_args1, XtNumber(temp_args1)); 	} 		/* Set icon pixmap */_: 	XtGetValues(top_level, temp_args3, XtNumber(temp_args3)); 	if (icon_pm == (Pixmap) 0) {gB 	    temp_args3[0].value = (XtArgVal) (XCreateBitmapFromData(DISP,7 		RootWindowOfScreen(SCRN), (_Xconst char *) xdvi_bits,) 		xdvi_width, xdvi_height));> 	    XtSetValues(top_level, temp_args3, XtNumber(temp_args3)); 	}- 	temp_args4[0].value = (XtArgVal) title_name;r, 	temp_args4[1].value = (XtArgVal) icon_name;: 	XtSetValues(top_level, temp_args4, XtNumber(temp_args4));   #ifdef	BUTTONS= 	form_widget = XtCreateManagedWidget("form", formWidgetClass,e- 		top_level, form_args, XtNumber(form_args));r   #else	/* !BUTTONS */B #define	form_widget	top_level	/* for calls to XtAddEventHandler */ #endif	/* BUTTONS */C 	vport_widget = XtCreateManagedWidget("vport", viewportWidgetClass,f1 		form_widget, vport_args, XtNumber(vport_args)); 4 	clip_widget = XtNameToWidget(vport_widget, "clip");( 	draw_args[0].value = (XtArgVal) page_w;( 	draw_args[1].value = (XtArgVal) page_h; #ifdef	GREY), 	draw_args[2].value = (XtArgVal) back_Pixel; #endif@ 	draw_widget = XtCreateManagedWidget("drawing", drawWidgetClass,0 		vport_widget, draw_args, XtNumber(draw_args));  	{	/* set default window size */ #ifdef	BUTTONS3 	    int xtra_wid = resource.expert ? 0 : XTRA_WID;( #elsel #define	xtra_wid	0 #endif" 	    XtWidgetGeometry constraints; 	    XtWidgetGeometry reply;  C 	    XtGetValues(top_level, &temp_args2, 1);	/* get border width */ < 	    screen_w = WidthOfScreen(SCRN) - 2 * bwidth - xtra_wid;2 	    screen_h = HeightOfScreen(SCRN) - 2 * bwidth;7 	    constraints.request_mode = reply.request_mode = 0;;  	    constraints.width = page_w; 	    if (page_w > screen_w) {/% 		constraints.request_mode = CWWidth;r 		constraints.width = screen_w;i 	    }! 	    constraints.height = page_h;; 	    if (page_h > screen_h) { & 		constraints.request_mode = CWHeight;  		constraints.height = screen_h; 	    }& 	    if (constraints.request_mode != 0: 		    && constraints.request_mode != (CWWidth | CWHeight))= 		(void) XtQueryGeometry(vport_widget, &constraints, &reply);c) 	    if (!(reply.request_mode & CWWidth))s" 		reply.width = constraints.width;? 	    set_wh_args[0].value = (XtArgVal) ((reply.width < screen_wn* 				? reply.width : screen_w) + xtra_wid);* 	    if (!(reply.request_mode & CWHeight))$ 		reply.height = constraints.height;? 	    set_wh_args[1].value = (XtArgVal) (reply.height < screen_he  					? reply.height : screen_h);@ 	    XtSetValues(top_level, set_wh_args, XtNumber(set_wh_args)); #ifdef	BUTTONS& 	    set_wh_args[0].value -= xtra_wid;C 	    XtSetValues(vport_widget, set_wh_args, XtNumber(set_wh_args));i@ 	    if (!resource.expert) create_buttons(set_wh_args[1].value); #endif	/* BUTTONS */ 	} 	if (resource.fore_color) {e: 	    static Arg fore_args = {XtNforeground, (XtArgVal) 0};  " 	    fore_args.value = fore_Pixel;- 	    XtSetValues(draw_widget, &fore_args, 1);a 	} 	if (resource.back_color) {	: 	    static Arg back_args = {XtNbackground, (XtArgVal) 0};  " 	    back_args.value = back_Pixel;- 	    XtSetValues(draw_widget, &back_args, 1); - 	    XtSetValues(clip_widget, &back_args, 1);. 	}@ 	XtAddEventHandler(form_widget, KeyPressMask, False, handle_key, 		(caddr_t) NULL);< 	XtAddEventHandler(vport_widget, StructureNotifyMask, False,! 		handle_resize, (caddr_t) NULL); @ 	XtAddEventHandler(draw_widget, ExposureMask, False, handle_exp, 		(caddr_t) &mane);mF 	XtAddEventHandler(draw_widget, ButtonPressMask, False, handle_button, 		(caddr_t) NULL);G 	XtAddEventHandler(draw_widget, ButtonMotionMask, False, handle_motion,u 		(caddr_t) NULL);I 	XtAddEventHandler(draw_widget, ButtonReleaseMask, False, handle_release,  		(caddr_t) NULL); 	XtRealizeWidget(top_level);  0 	currwin.win = mane.win = XtWindow(draw_widget);   	{ 	    XWindowAttributes attrs;e  9 	    (void) XGetWindowAttributes(DISP, mane.win, &attrs);u) 	    backing_store = attrs.backing_store;e 	}   #else	/* !TOOLKIT */   	/*e 	 *	Windows (non toolkit)o 	 */  + 	screen_w = WidthOfScreen(SCRN) - 2*bwidth;e, 	screen_h = HeightOfScreen(SCRN) - 2*bwidth; 	size_hints.flags = PMinSize;m3 	size_hints.min_width = size_hints.min_height = 50; ! 	size_hints.x = size_hints.y = 0;  	if (geometry != NULL) {F 	    int flag = XParseGeometry(geometry, &size_hints.x, &size_hints.y, 		&window_w, &window_h);  " 	    if (flag & (XValue | YValue))! 		size_hints.flags |= USPosition;l+ 	    if (flag & (WidthValue | HeightValue))" 		size_hints.flags |= USSize;r? 	    if (flag & XNegative) size_hints.x += screen_w - window_w; ? 	    if (flag & YNegative) size_hints.y += screen_h - window_h;o 	}$ 	if (!(size_hints.flags & USSize)) { 	    int x_thick = 0;  	    int y_thick = 0;b0 	    if (screen_w < page_w) x_thick = BAR_THICK;: 	    if (screen_h < page_h + x_thick) y_thick = BAR_THICK;! 	    window_w = page_w + y_thick;s 	    if (window_w > screen_w) {o 		x_thick = BAR_THICK; 		window_w = screen_w; 	    }! 	    window_h = page_h + x_thick;t2 	    if (window_h > screen_h) window_h = screen_h; 	    size_hints.flags |= PSize;  	} 	size_hints.width = window_w;p 	size_hints.height = window_h;@ 	top_level = XCreateSimpleWindow(DISP, RootWindowOfScreen(SCRN),9 		size_hints.x, size_hints.y, window_w, window_h, bwidth,p 		brdr_Pixel, back_Pixel);? 	XSetStandardProperties(DISP, top_level, title_name, icon_name, ' 		(Pixmap) 0, argv, argc, &size_hints);=  8 	wmhints.flags = InputHint | StateHint | IconPixmapHint;= 	wmhints.input = True;	/* window manager must direct input */r< 	wmhints.initial_state = iconic ? IconicState : NormalState;2 	wmhints.icon_pixmap = XCreateBitmapFromData(DISP,: 	    RootWindowOfScreen(SCRN), (_Xconst char *) xdvi_bits, 	    xdvi_width, xdvi_height);& 	if (resource.icon_geometry != NULL) { 	    int junk;  ' 	    wmhints.flags |= IconPositionHint;|H 	    (void) XGeometry(DISP, DefaultScreen(DISP), resource.icon_geometry,6 		"", 0, 0, 0, 0, 0, &wmhints.icon_x, &wmhints.icon_y, 		&junk, &junk); 	}( 	XSetWMHints(DISP, top_level, &wmhints);  C 	XSelectInput(DISP, top_level, KeyPressMask | StructureNotifyMask);f 	XMapWindow(DISP, top_level);r 	XFlush(DISP);   #endif	/* TOOLKIT */  = #define	rebindkey(ks, str)	XRebindKeysym(DISP, (KeySym) ks, \v/ 		(KeySym *) NULL, 0, (_Xconst ubyte *) str, 1)e 	rebindkey(XK_Home, "^");  	rebindkey(XK_Left, "l");h 	rebindkey(XK_Up, "u");  	rebindkey(XK_Right, "r"); 	rebindkey(XK_Down, "d");x 	rebindkey(XK_Prior, "b"); 	rebindkey(XK_Next, "f");_ #ifdef	XK_KP_Leftm 	rebindkey(XK_KP_Home, "^"); 	rebindkey(XK_KP_Left, "l"); 	rebindkey(XK_KP_Up, "u"); 	rebindkey(XK_KP_Right, "r");; 	rebindkey(XK_KP_Down, "d"); 	rebindkey(XK_KP_Prior, "b");a 	rebindkey(XK_KP_Next, "f"); #endif	/* XK_KP_Left */X #undef	rebindkey  H 	image = XCreateImage(DISP, DefaultVisualOfScreen(SCRN), 1, XYBitmap, 0,0 			     (char *)NULL, 0, 0, BITS_PER_BMUNIT, 0);& 	image->bitmap_unit = BITS_PER_BMUNIT; #ifndef	MSBITFIRST$ 	image->bitmap_bit_order = LSBFirst; #elsea$ 	image->bitmap_bit_order = MSBFirst; #endif 	{- 	    short endian = MSBFirst << 8 | LSBFirst;y- 	    image->byte_order = *((char *) &endian);a 	}   	do_pages();= 	return 0;	/* do_pages() returns if DBG_BATCH is specified */o }m