8 .\" Copyright (c) 1994 Paul Vojta.  All rights reserved. .\" F .\" Redistribution and use in source and binary forms, with or withoutF .\" modification, are permitted provided that the following conditions .\" are met:E .\" 1. Redistributions of source code must retain the above copyright D .\"    notice, this list of conditions and the following disclaimer.H .\" 2. Redistributions in binary form must reproduce the above copyrightJ .\"    notice, this list of conditions and the following disclaimer in theK .\"    documentation and/or other materials provided with the distribution.  .\" J .\" THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' ANDI .\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE N .\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSEK .\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE N .\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIALK .\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS I .\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) N .\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICTM .\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY J .\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF .\" SUCH DAMAGE. .\" > .if t .ds Te T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X .if n .ds Te TeX2 '	# small and boldface (not all -man's provide it) .de SB \&\fB\s-1\&\\$1 \\$2\s0\fR ..) .TH XDVI 1 "28 April 1995" "X Version 11"  .SH NAME- xdvi \- DVI Previewer for the X Window System  .SH SYNOPSIS .B xdvi  .nh H [\fB+\fP[\fIpage\fP]] [\fB\-s\fP \fIshrink\fP] [\fB\-S\fP \fIdensity\fP] #ifgrey ( [\fB\-nogrey\fP] [\fB\-gamma\fP \fIg\fP] #endif [\fB\-p\fP \fIpixels\fP] [\fB\-margins\fP \fIdimen\fP] @ [\fB\-sidemargin\fP \fIdimen\fP] [\fB\-topmargin\fP \fIdimen\fP] [\fB\-offsets\fP \fIdimen\fP] ; [\fB\-xoffset\fP \fIdimen\fP] [\fB\-yoffset\fP \fIdimen\fP] < [\fB\-paper\fP \fIpapertype\fP] [\fB\-altfont\fP \fIfont\fP]	 #ifmakepk  [\fB\-nomakepk\fP] #endif [\fB\-mfmode\fP \fImode-def\fP]  [\fB\-l\fP]  [\fB\-rv\fP]
 #ifbuttons [\fB\-expert\fP] #endif! [\fB\-mgs\fP[\fIn\fP] \fIsize\fP]  [\fB\-hush\fP]B [\fB\-hushspecials\fP] [\fB\-hushchars\fP] [\fB\-hushchecksums\fP] [\fB\-safer\fP] J [\fB\-fg\fP \fIcolor\fP] [\fB\-bg\fP \fIcolor\fP] [\fB\-hl\fP \fIcolor\fP]1 [\fB\-bd\fP \fIcolor\fP] [\fB\-cr\fP \fIcolor\fP]  [\fB\-bw\fP \fIwidth\fP]F [\fB\-display\fP \fIhost:display\fP] [\fB\-geometry\fP \fIgeometry\fP]6 [\fB\-icongeometry\fP \fIgeometry\fP] [\fB\-iconic\fP]
 #ifbuttons [\fB\-font\fP \fIfont\fP]  #endif0 [\fB\-keep\fP] [\fB\-copy\fP] [\fB\-thorough\fP] #ifps  [\fB\-nopostscript\fP] [\fB\-noscan\fP] [\fB\-allowshell\fP] #endif #ifdps [\fB\-nodps\fP]  #endif #ifnews  [\fB\-nonews\fP] #endif #ifghost [\fB\-noghostscript\fP]   [\fB\-interpreter\fP \fIpath\fP] [\fB\-nogssafer\fP] ! [\fB\-gspalette\fP \fIpalette\fP]  #endif/ [\fB\-debug\fP \fIbitmask\fP] [\fB\-version\fP]  .I dvi_file  .hy  .SH DESCRIPTION  .B xdvi H is a program which runs under the X window system. It is used to preview .I dvi files, such as are produced by .BR tex (1). .PP G This program has the capability of showing the file shrunken by various G (integer) factors, and also has a ``magnifying glass'' which allows one 6 to see a small part of the unshrunk image momentarily. .PP C Before displaying any page or part thereof, it checks to see if the  .I dviL file has changed since the last time it was displayed.  If this is the case, then .B xdvi $ will reinitialize itself for the new .I dvi- file.  For this reason, exposing parts of the  .B xdvi K window while \*(Te\& is running should be avoided.  This feature allows you 7 to preview many versions of the same file while running  .B xdvi 
 only once.
 #ifbuttons .PP 8 In addition to using keystrokes to move within the file, .B xdvi F provides buttons on the right side of the window, which are synonymous% with various sequences of keystrokes.  #endif #ifps  .PP  .B xdvi 9 can show PostScript<tm> specials by any of three methods. C It will try first to use Display PostScript<tm>, then NeWS, then it G will try to use Ghostscript to render the images.  All of these options F depend on additional software to work properly; moreover, some of them% may not be compiled into this copy of 
 .BR xdvi . .PP  For performance reasons, .B xdvi < does not render PostScript specials in the magnifying glass. #endif .SH OPTIONS  In addition to specifying the  .I dvi file (with or without the  .B .dvi  extension),  .B xdvi I supports the following command line options.  If the option begins with a 	 .RB ` + '  instead of a .RB ` \- ', K the option is restored to its default value.  By default, these options can H be set via the resource names given in parentheses in the description of each option. .TP 
 .BI + page% Specifies the first page to show.  If  .B +F is given without a number, the last page is assumed; the first page is the default. #ifps  .TP  .B \-allowshell  .RB ( .allowShell ) < This option enables the shell escape in PostScript specials.; (For security reasons, shell escapes are usually disabled.) K This option should be rarely used; in particular it should not be used just I to uncompress files: that function is done automatically if the file name  ends in  .B .Z  or	 .BR .gz . * Shell escapes are always turned off if the
 .B \-safer option is used.  #endif .TP  .BI \-altfont " font"  .RB ( .altFont )3 Declares a default font to use when the font in the  .I dviO file cannot be found.  This is useful, for example, with PostScript <tm> fonts.  .TP  .BI \-background " color"  .RB ( .background ) 0 Determines the color of the background.  Same as	 .BR -bg .  .TP  .BI \-bd " color"  .RB ( .borderColor )* Determines the color of the window border. .TP  .BI \-bg " color"  .RB ( .background ) ' Determines the color of the background.  .TP  .BI \-bordercolor " color" Same as 	 .BR -bd .  .TP  .BI \-borderwidth " width" .RB ( .borderWidth )9 Specifies the width of the border of the window.  Same as 	 .BR -bw .  .TP  .BI \-bw " width"  .RB ( .borderWidth )0 Specifies the width of the border of the window. .TP 	 .B \-copy 
 .RB ( .copy )  Always use the .I copy 1 operation when writing characters to the display. J This option may be necessary for correct operation on a color display, but( overstrike characters will be incorrect. #ifgrey ) If greyscale anti-aliasing is in use, the 	 .B \-copy G operation will disable the use of colorplanes and make overstrikes come  out incorrectly. #endif See also .BR \-thorough . .TP  .BI \-cr " color"  .RB ( .cursorColor )I Determines the color of the cursor.  The default is the color of the page  border.  .TP  .BI \-debug " bitmask" .RB ( .debugLevel ) G If nonzero, prints additional debugging information on standard output. H The bitmask should be given as a decimal number.  The values of the bits are defined in the source file .BR xdvi.h . .TP  .BI \-density " density" .RB ( .densityPercent ) = Determines the density used when shrinking bitmaps for fonts. J A higher value produces a lighter font.  The default value is 40.  Same as	 .BR \-S .  .TP  .BI \-display " host" : display ; Specifies the host and screen to be used for displaying the  .I dvi@ file.  By default this is obtained from the environment variable .SB DISPLAY.
 #ifbuttons .TP  .B \-expert  .RB ( .expert ) 1 Prevent the buttons from appearing.  See also the 	 .RB ` x ' 
 keystroke. #endif .TP  .BI \-fg " color"  .RB ( .foreground ) . Determines the color of the text (foreground). .TP  .BI \-foreground " color"  Same as 	 .BR -fg . 
 #ifbuttons .TP  .BI \-font " font"
 .RB ( *font ) % Sets the font for use in the buttons.  #endif #ifgrey  .TP  .BI \-gamma " gamma" .RB ( .gamma )I Controls the interpolation of colors in the greyscale anti-aliasing color ( palette.  Default value is 1.0.  For 0 < .I gammaB < 1, the fonts will be lighter (more like the background), and for .I gammaC > 1, the fonts will be darker (more like the foreground).  NegativerC values behave the same way, but use a slightly different algorithm.a #endif .TPn .BI \-geometry " geometry" .RB ( *geometry )o- Specifies the initial geometry of the window.h #ifghost .TPc .BI \-gspalette " palette" .RB ( .palette )E Specifies the palette to be used when using Ghostscript for renderingo) PostScript specials.  Possible values areo .BR Color ,t .BR Greyscale ,l and  .BR Monochrome . The default is .BR Color .i #endif .TPw .BI \-hl " color"n .RB ( .highlight )N Determines the color of the page border.  The default is the foreground color. .TPI	 .B \-hushA
 .RB ( .Hush )G Causes .B xdvi & to suppress all suppressible warnings. .TPB .B \-hushchars .RB ( .hushLostChars ) Causes .B xdviAI to suppress warnings about references to characters which are not defined  in the font. .TPN .B \-hushchecksums .RB ( .hushChecksums ) Causes .B xdviI: to suppress warnings about checksum mismatches between the .I dvi file and the font file.  .TP  .B \-hushspecialsN .RB ( .hushSpecials )  Causes .B xdviD to suppress warnings about .B \especial strings that it cannot process.  .TP( .BI \-icongeometry " geometry" .RB ( .iconGeometry ) , Specifies the initial position for the icon. .TPD .B \-iconicB .RB ( .iconic )H
 Causes the .B xdvi F window to start in the iconic state.  The default is to start with the window open. #ifghost .TPo .BI \-interpreter " filename"B .RB ( .interpreter ) UseR .I filenameI3 as the Ghostscript interpreter.  By default it uses  .BR %%gspath%% . #endif .TPS	 .B \-keep  .RB ( .keepPosition )  Sets a flag to indicate that .B xdvihM should not move to the home position when moving to a new page.  See also thef	 .RB ` k 'd
 keystroke. .TPI .B \-l .RB ( .listFonts )0 Causes the names of the fonts used to be listed. .TPt .BI \-margins " dimen" .RB ( .Margin )P: Specifies the size of both the top margin and side margin.6 This should be a decimal number optionally followed by
 .RB `` cm '',o
 .IR e.g. , .B 1.5 or	 .BR 3cm ,f. giving a measurement in inches or centimeters.D It determines the ``home'' position of the page within the window as follows.  If the entirePH page fits in the window, then the margin settings are ignored.  If, evenJ after removing the margins from the left, right, top, and bottom, the pageL still cannot fit in the window, then the page is put in the window such thatN the top and left margins are hidden, and presumably the upper left-hand cornerL of the text on the page will be in the upper left-hand corner of the window.8 Otherwise, the text is centered in the window.  See also# .BR \-sidemargin ", " \-topmargin ,f and the keystrokeo
 .RB ` M .' .TP\ .BI \-mfmode " mode-def" .RB ( .mfMode )f Specifies aB .I mode-def J string, which can be used in searching for fonts (see ENVIRONMENT, below).	 #ifmakepkn It is also passed to .B metafonts# during automatic creation of fonts.e #endif .TPd .BI \-mgs " size"\ Same as\ .BR \-mgs1 . .TPP .BI "\-mgs\fR[\fIn\fR]" " size"I" .RB ( .magnifierSize\fR[\fIn\fR] )H Specifies the size of the window to be used for the ``magnifying glass''
 for Button .IR n . I The size may be given as an integer (indicating that the magnifying glassu0 is to be square), or it may be given in the form .IR width x height .G See the MOUSE ACTIONS section.  Defaults are 200x150, 400x250, 700x500,. 1000x800, and 1200x1200. #ifdps .TPa
 .B \-nodps .RB ( .dps )H Inhibits the use of Display PostScript<tm> for displaying PostScript<tm>J specials.  Other forms of PostScript emulation, if installed, will be used instead.F (For this option, the logic of the corresponding resource is reversed:
 .B \-nodps corresponds to
 .BR dps:off ;f	 .B +nodpsw to
 .BR dps:on .)m #endif #ifghost .TPe .B \-noghostscript .RB ( .ghostscript )G Inhibits the use of Ghostscript for displaying PostScript<tm> specials.lF (For this option, the logic of the corresponding resource is reversed: .B \-noghostscript corresponds to .BR ghostscript:off ;f .B +noghostscriptx to .BR ghostscript:on .)m #endif #ifgrey  .TPr .B \-nogrey 
 .RB ( .grey )sL Turns off the use of greyscale anti-aliasing when printing shrunken bitmaps.F (For this option, the logic of the corresponding resource is reversed: .B \-nogreyr corresponds to .BR grey:off ;
 .B +nogrey to .BR grey:on .) See also the	 .RB ` G 'P
 keystroke. #endif #ifghost .TPv .B \-nogssafer .RB ( .gsSafer )O Normally, if Ghostscript is used to render PostScript specials, the Ghostscripth" interpreter is run with the option .BR \-dSAFER . Theo .B \-nogssafer option runs Ghostscript withoutn .BR \-dSAFER . Thet .B \-dSAFERt; option in Ghostscript disables PostScript operators such ase .BR deletefile ,I to prevent possibly malicious PostScript programs from having any effect.i If the
 .B \-saferM option is specified, then this option has no effect; in that case Ghostscriptt is always run with .BR \-dSAFER . (For the .B \-nogssafer< option, the logic of the corresponding resource is reversed: .B \-nogssafer corresponds to .BR gsSafer:off ;b
 .B +nogssafers to .BR gsSafer:on .)i #endif	 #ifmakepk  .TPn
 .B \-nomakepks .RB ( .makePk )bJ Turns off automatic generation of font files that cannot be found by other means.F (For this option, the logic of the corresponding resource is reversed:
 .B \-nomakepk  corresponds to .BR makePk:off ; .B +nomakepk to .BR makePK:on .) #endif #ifnewsi .TPd .B \-nonewsT
 .RB ( .news )nD Inhibits the use of NeWS<tm> for displaying PostScript<tm> specials.B Ghostscript, if enabled by the installation, will be used instead.F (For this option, the logic of the corresponding resource is reversed: .B \-nonewsn corresponds to .BR news:off ; .B +news to .BR news:on .) #endif #ifps  .TP" .B \-nopostscriptr .RB ( .postscript )sJ Turns off rendering of PostScript<tm> specials.  Bounding boxes, if known,D will be displayed instead.  This option can also be toggled with the	 .RB ` v ' 
 keystroke.F (For this option, the logic of the corresponding resource is reversed: .B \-nopostscripte corresponds to .BR postscript:off ; .B +postscript to .BR postscript:on .) #endif #ifpsp .TPe .B \-noscanf .RB ( .prescan )+ Normally, when PostScript<tm> is turned on,l .B xdvit! will do a preliminary scan of theg .I dviD file, in order to send any necessary header files before sending theL PostScript code that requires them.  This option turns off such prescanning.. (It will be automatically be turned back on if .B xdvi 5 detects any specials that require headers.)  (For theo .B \-noscanm< option, the logic of the corresponding resource is reversed: .B \-noscanc corresponds to .BR prescan:off ;m
 .B +noscan to .BR prescan:on .)d #endif .TP  .BI \-offsets " dimen" .RB ( .Offset )-E Specifies the size of both the horizontal and vertical offsets of theeK output on the page.  This should be a decimal number optionally followed byc
 .RB `` cm '',h
 .IR e.g. , .B 1.5 or	 .BR 3cm ,n. giving a measurement in inches or centimeters.M By decree of the Stanford \*(Te\& Project, the default \*(Te\& page origin isnD always 1 inch over and down from the top-left page corner, even whenB non-American paper sizes are used.  Therefore, the default offsets are 1.0 inch. See also .B \-xoffset ande .BR \-yoffset .d .TPy .BI \-p " pixels"i .RB ( .pixelsPerInch )> Defines the size of the fonts to use, in pixels per inch.  The default value is %%bdpi%%. .TPr .BI \-paper " papertype" .RB ( .paper )@ Specifies the size of the printed page.  This may be of the formB \fIwidth\fBx\fIheight\fR (or \fIwidth\fBx\fIheight\fBcm\fR), where .I width" is the width in inches (or cm) and	 .I height . is the height in inches (or cm), respectively.* There are also synonyms which may be used: .B us 	 (8.5x11),i .B usr	 (11x8.5),- .B legal	 (8.5x14),  .B foolscapt
 (13.5x17), as well as the ISO sizes
 .BR a1 - a7 ,i
 .BR b1 - b7 , 
 .BR c1 - c7 ,a
 .BR a1r - a7r0
 .RB ( a1 - a7g8 rotated), etc.  The default size is %%defaultpagesize%%. .TP, .B \-rv  .RB ( .reverseVideo )sL Causes the page to be displayed with white characters on a black background, instead of vice versa. .TPe .BI \-s " shrink"e .RB ( .shrinkFactor )t; Defines the initial shrink factor.  The default value is 3.m .TPo .BI \-S " density" .RB ( .densityPercent )t= Determines the density used when shrinking bitmaps for fonts.dA A higher value produces a lighter font.  The default value is 40.b Same as  .BR \-density .t .TP 
 .B \-safer .RB ( .safer )P This option turns on all available security options; it is designed for use when .B xdvi)% is called by a browser that obtains ae .I dvi" or \*(Te\& file from another site. #ifps\( In the present case, this option selects #endif #ifghost
 .B +nogssaferi and  #endif #ifpsc .BR +allowshell .s #endif #ifnops E In the present case, this option is accepted but has no effect, since  .B xdvie: has been compiled without support for PostScript specials. #endif .TPs .BI \-sidemargin " dimen"n .RB ( .sideMargin )i Specifies the side margin (see .BR \-margins ). .TP 
 .B \-thoroughs .RB ( .thorough )s .B xdvi 5 will usually try to ensure that overstrike characterss .RI ( e.g. ,
 .BR \enotin )tG are printed correctly.  On monochrome displays, this is always possible " with one logical operation, either .I and or .IR or .H On color displays, however, this may take two operations, one to set theH appropriate bits and one to clear other bits.  If this is the case, then
 by default .B xdvi  will instead use the .I copy)= operation, which does not handle overstriking correctly.  Thel
 .B \-thorough < option chooses the slower but more correct choice.  See also .BR \-copy . .TPd .BI \-topmargin " dimen" .RB ( .topMargin )) Specifies the top and bottom margins (seee .BR \-margins ). .TP 
 .BI \-versionI# Print information on the version oft
 .BR xdvi . .TPo .BI \-xoffset " dimen" .RB ( .xOffset )K Specifies the size of the horizontal offset of the output on the page.  Seei .BR \-offsets .s .TP  .BI \-yoffset " dimen" .RB ( .yOffset )I Specifies the size of the vertical offset of the output on the page.  Seei .BR -offsets . .SH KEYSTROKES .B xdvih= recognizes the following keystrokes when typed in its window. I Each may optionally be preceded by a (positive or negative) number, whosee7 interpretation will depend on the particular keystroke.iO Also, the ``Home'', ``Prior'', ``Next'', and arrow cursor keys are synonyms forp
 .RB ` ^ ',
 .RB ` b ',
 .RB ` f ',
 .RB ` l ',
 .RB ` r ',
 .RB ` u ', andl	 .RB ` d '  keys, respectively.t .TPx .B q> Quits the program.  Control-C and control-D will do this, too. .TPs .B n! Moves to the next page (or to thee .IR n th. next page if a number is given).  Synonyms are
 .RB ` f ', Space, Return, and Line Feed.d .TP" .B p# Moves to the previous page (or backe .I n pages).  Synonyms are 
 .RB ` b ', control-H, and Delete. .TPb .B gN Moves to the page with the given number.  Initially, the first page is assumed5 to be page number 1, but this can be changed with the 	 .RB ` P 'TM keystroke, below.  If no page number is given, then it goes to the last page.f .TPh .B P ``This is page numbere	 .IR n .''` This can be used to make the	 .RB ` g ' H keystroke refer to actual page numbers instead of absolute page numbers. .TPt	 Control-L) Redisplays the current page. .TPI .B ^F Move to the ``home'' position of the page.  This is normally the upperJ left-hand corner of the page, depending on the margins as described in the .B \-margins option, above. .TPo .B u% Moves up two thirds of a window-full.p .TPs .B d' Moves down two thirds of a window-full.a .TP  .B l' Moves left two thirds of a window-full.o .TPf .B r( Moves right two thirds of a window-full. .TP  .B cI Moves the page so that the point currently beneath the cursor is moved to N the middle of the window.  It also (gasp!) warps the cursor to the same place. .TPi .B MJ Sets the margins so that the point currently under the cursor is the upperM left-hand corner of the text in the page.  Note that this command itself doesfH not move the image at all.  For details on how the margins are used, see theB .B \-margins option.  .TPu .B sJ Changes the shrink factor to the given number.  If no number is given, theJ smallest factor that makes the entire page fit in the window will be used.* (Margins are ignored in this computation.) .TPo .B SG Sets the density factor to be used when shrinking bitmaps.  This should I be a number between 0 and 100; higher numbers produce lighter characters.r #ifgreypJ If greyscaling mode is in effect, this changes the value of gamma instead.J The new value of gamma is the given number divided by 100; negative values are allowed. #endif .TPn .B R
 Forces the .I dviH file to be reread.  This allows you to preview many versions of the same file while running .B xdvih
 only once. .TPi .B k
 Normally when  .B xdvi ; switches pages, it moves to the home position as well.  Thes	 .RB ` k 'aC keystroke toggles a `keep-position' flag which, when set, will keep 2 the same position when moving between pages.  Also
 .RB ` 0k ' andr
 .RB ` 1k '4 clear and set this flag, respectively.  See also the	 .B \-keepf option.p
 #ifbuttons .TPm .B x? Toggles expert mode (in which the buttons do not appear).  Alsot
 .RB ` 0x ' andn
 .RB ` 1x '6 clear and reset this mode, respectively.  See also the .B \-expertr option.  #endif #ifgreyo .TPo .B GK This key toggles the use of greyscale anti-aliasing for displaying shrunkend( bitmaps.  In addition, the key sequences
 .RB ` 0G ' and>
 .RB ` 1G '4 clear and set this flag, respectively.  See also the .B \-nogreyl option.l #endif #ifpsa .TPF .B vH This key toggles the rendering of PostScript<tm> specials.  If rendering@ is turned off, then bounding boxes are displayed when available. In addition the key sequencess
 .RB ` 0v ' andp
 .RB ` 1v '4 clear and set this flag, respectively.  See also the .B \-nopostscriptw option.b #endif .SH MOUSE ACTIONSoG If the shrink factor is set to any number other than one, then clickingiL any mouse button will pop up a ``magnifying glass'' which shows the unshrunkI image in the vicinity of the mouse click.  This subwindow disappears when N the mouse button is released.  Different mouse buttons produce different sized windows, as indicated by the .B \-mgsF option.  Moving the cursor while holding the button down will move the magnifying glass.o .PPnO Also, the scrollbars (if present) behave in the standard way:  pushing Button 2nH in a scrollbar moves the top or left edge of the scrollbar to that point and optionally drags it;O pushing Button 1 moves the image up or right by an amount equal to the distance J from the button press to the upper left-hand corner of the window; pushing9 Button 3 moves the image down or left by the same amount." .SH ENVIRONMENT- The environment variable .SB DISPLAYn0 specifies which bit map display terminal to use. .PPT The environment variable
 .SB XDVIFONTS # determines the path(s) searched for.J fonts in the following manner.  The string consists of one or more strings8 separated by colons.  In each such string, the substring .B %fg is changed to the font name; .B %dd$ is changed to the magnification; and .B %p " is changed to the font file format
 .RB (`` pk ''d or .RB `` gf ''). If noh .B %fl& appears in the string, then the string .RB `` /%f.%d%p ''3 is added on the end.  For example, if the string ish .RB `` /usr/local/tex/fonts '' and the font is  .B cmr10* at 300 dots per inch, then it searches for# .B /usr/local/tex/fonts/cmr10.300pkh andn& .BR /usr/local/tex/fonts/cmr10.300gf ,* in that order.  An extra colon anywhere in
 .SB XDVIFONTSeN causes the system default paths to be tried at that point.  If the font is not found in the desired size, thenr .B xdvio will	 #ifmakepkaN invoke Metafont to create the font in the correct size.  Failing that, it will #endif try to find the nearest size.s( If the font cannot be found at all, then .B xdviaE will try to vary the point size of the font (within a certain range),%G and if this fails, then it will use the font specified as the alternateg	 font (cf.p .BR \-altfont ). .PPt In addition, a .B %Fn+ specifier is available; it is a synonym forh .BR %f ,* but it does not inhibit putting the string .RB `` /%f.%d%p '' at the end.  A .B %boL specifier is available; it is converted to the current resolution being used .RI ( i.e. , the value of the .B \-p parameter or the .B .pixelsperinche# resource).  And finally, the string  .B %mt will be changed to the .I mode-def) specified in the .B \-mfmodel argument or thei
 .B .mfMode	 resource.  #iftexfontsx .PP 0 For compatibility with \*(Te\&, you may also use .SB TEXFONTS in place ofs .SB XDVIFONTS,9 although in that case the variable should not include anyB .RB `` % '' ' specifiers.  The reason for recognizing  .SB TEXFONTSI is that certain versions of \*(Te\& also support the convention regarding L an extra colon in the font path; therefore, users who create their own fonts can put both their	 .RI . tfmn- and raster files in the same directory and doi" .RB `` "setenv TEXFONTS :MFdir" '' or" .RB `` "setenv TEXFONTS MFdir:" ''  in order to get both \*(Te\& and .B xdvieN to search their directory in addition to the system standard directories.  The
 .SB XDVIFONTSs variable overrides the .SB TEXFONTS& variable, so that on those sites where .SB TEXFONTSE must be set explicitly, and therefore this feature is not useful, thet
 .SB XDVIFONTSt& variable may be set to an empty string .RI ( i.e. , .RB  `` "setenv XDVIFONTS" '') to cause .B xdvir	 to ignoreh
 .SB TEXFONTS.e .PPs .B xdvio also recognizes thet .SB PKFONTSi ando
 .SB TEXPKS" variables, which are checked after
 .SB XDVIFONTS.
 but before
 .SB TEXFONTS.i #endif	 #ifmakepkg .PP D The script used to create fonts may be controlled by the environment variable .SB XDVIMAKEPK.t= Usually this variable would be set to the name of the script."= In that case the script is called with the following options: A (1) the font name, (2) the requested resolution in dots per inch,fL (3) the base resolution in dots per inch, and (4) a (possibly more accurate)= indication of the magnification using magsteps (if possible).B/ Optionally, the variable may include specifierst
 .RB `` %n ,''d
 .RB `` %d ,''o
 .RB `` %b ,''e and  .RB `` %m ''6 to indicate each of the above arguments, respectively. It is possible to specify the  .I mode-defoJ that Metafont is to use when creating the fonts.  This is specified by the .B \-mfmode,$ argument on the command line, or the	 .B mfMode  resource.  If a  .RB `` %o '' specifier appears in the .SB XDVIMAKEPK' string, it will be changed to the given  .I mode-defo name, or to the string
 .B default if no  .I mode-defa was given.  If no  .RB `` %o '' specifier appears and a, .I mode-defdC was given, then the mode will be appended to the end of the string.S; This is compatible with the font creation mechanism used in  .BR dvips (1). By default,v .SB XDVIMAKEPK equals .BR %%mkpk%% . #endif	 #ifsubdire .PPeE You can also enable recursive searching in the font path by using theI .RB `` * ''b and  .RB `` ** ''' specifiers.  At this point in the path,h .B xdvie will recursivelyI search subdirectories of the given directory in order to find font files.eO A single asterisk limits the search to one level; a double asterisk will searche: through an arbitrary number of levels.  Also, the variable .SB TEXFONTS_SUBDIRyP can be used to give a colon-separated list of directories to recursively search.5 This is equivalent to including the specifiers with ap .RB `` * ''fK after each; the usual conventions regarding extra colons applies here, too, L relative to a default subdirectory path.  Asterisks may not be preceded by a .RB `` % ''d  specifier in any path component. #endif .PPe Thet
 .SB XDVISIZESaC variable may be set to indicate which sizes of fonts are available.)? It should consist of a list of numbers separated by colons.  IfsI the list begins with a colon, the system default sizes are used, as well.r: Sizes are expressed in dots per inch and must be integers.; The current default set of sizes is %%DEFAULT_FONT_SIZES%%.s .B xdvi,O will also try the actual size of the font before trying any of the given sizes.g .PPn* Virtual fonts are also supported, although .B xdvihN does not have any built-in fonts to which they can refer.  The search path for .RB . vf4 files can be specified with the environment variable .SB XDVIVFSi# in a similar manner to that for them
 .SB XDVIFONTSn	 variable.e #iftexfontsd .B xdvie will also check thee .SB VFFONTSa variable if thef
 .SB XDVIFONTSg variable is not set. #endifE Virtual fonts are searched for immediately after looking for the fonta- as a normal font in the exact size specified.t #ifpsd .PPi The  .SB XDVIFIGS andl .SB XDVIHEADERSwG variables determine the search strategy for PostScript figure files andi" header files, respectively.  First .B xdvig) will look in the directory containing the  .I dviI file.  If no file is found, then it will look in the directories given bye theh .SB XDVIFIGS or .SB XDVIHEADERS C environment variable, for PostScript figure files and header files,rL respectively.  These variables should contain lists of directories separatedF by colons.  As usual, an extra colon anywhere in either of these pathsF causes the default compiled-in list to be checked at that point in the path list.  Customarily, .SB XDVIFIGS0 will be the same as the \*(Te\& input directory. If .SB XDVIFIGS or .SB XDVIHEADERSn is not set, then .B xdvi, will also check theR
 .SB TEXINPUTS  or .SB HEADERPATH5 environment variables; this is for compatibility withe .BR dvips (1). .PP H There are two exceptions to the above strategy.  First, if the file name begins with a slashs
 .RB ( / ),I then the file name is treated as an absolute path, and is searched for asuE given, without using the above strategy.  Or, if the file name beginsv with a backticke
 .RB ( ` ),9 then the following characters give a shell command (oftenn
 .BR zcat )H which is executed; its standard output is then sent to be interpreted asJ PostScript.  Note that there is some potential for security problems here; see theu .B \-allowshelluP command-line option.  It is better to use compressed files directly (see below). .PPe8 If a file name is given (as opposed to a shell command), if that file name ends inw .B .Zl or	 .BR .gz , K and if the first two bytes of the file indicate that it was compressed witht .BR compress (1) or
 .BR gzip (1),g6 respectively, then the file is first uncompressed with .B uncompress \-ch or .BR "gunzip \-c" ,J respectively.  This is preferred over using a backtick to call the command* directly, since you do not have to specify .B \-allowshelld' and since it allows for path searching.m #endif #ifpsd .SH LIMITATIONSe .B xdviuA accepts many but not all types of PostScript specials accepted byc .BR dvips .i) It does accept most specials generated byn .B epsf  andb .BR psfig ,O+ for example.  It does not, however, supporto .BR bop\-hook ,i; nor does it do the ``NEAT'' or rotated ``A'' example in thea .B dvips4 manual.  These restrictions are due to the design of
 .BR xdvi ;* in all likelihood they will always remain. .PPtD La\*(Te\&2e color and rotation specials are not currently supported. #endif	 .SH FILES  .PD 0  .TP 40) %%DEFAULT_FONT_PATH%%   Font pixel files. ) %%DEFAULT_VF_PATH%%   Virtual font files.x #ifpsiA %%DEFAULT_FIG_PATH%%   Directories containing PostScript figures. I %%DEFAULT_HEADER_PATH%%   Directories containing PostScript header files.t #endif .PDh .SH "SEE ALSO"
 .BR X (1). .SH AUTHORS0< Eric Cooper, CMU, did a version for direct output to a QVSS. Modified for X bye3 Bob Scheifler, MIT Laboratory for Computer Science.n* Modified for X11 by Mark Eichin, MIT SIPB.' Additional enhancements by many others.n