 #module    GloBldFil    "1-001"  /*H  ***********************************************************************H  *                                                                     *H  * The software was developed at the Monsanto Company and is provided  *H  * "as-is".  Monsanto Company and the auther disclaim all warranties   *H  * on the software, including without limitation, all implied warran-  *H  * ties of merchantabilitiy and fitness.                               *H  *                                                                     *H  * This software does not contain any technical data or information    *H  * that is proprietary in nature.  It may be copied, modified, and     *H  * distributed on a non-profit basis and with the inclusion of this    *H  * notice.                                                             *H  *                                                                     *H  ***********************************************************************  */    /*+   * Module Name:	GloBldFil   *5  * Author:	R L Aurbach	CR&DS MIS Group    22-Aug-1986   *  * Function:  *	Build the output file.   *  * Modification History:  *,  * Version     Initials	   Date		DescriptionK  * ------------------------------------------------------------------------ &  * 1-001	RLA	22-Aug-1986	Original Code -*/    /*:  * Module GloBldFil - Module-Wide Data Description Section  *  * Include Files:   */  #include	descrip #include	stdio #include	"GloDef.H"    /*  * Module Definitions:  */    /*  * Global Declarations:   */    /*  * Static Declarations:   */    /*  * External References:   */      extern char		infile[256];      extern NODE_PTR	root;      extern int		flag;    /*  * Functions Called:  */    /*+ 2  * Function Glo_Build_File - Documentation Section  *  * Discussion:H  *	Create the output file which will be included into the final document  *	to create the glossary.  *  * Calling Synopsis:  *	status = Glo_Build_File ()   *
  * Inputs:  *	none   *  * Outputs:   *	none   *  * Return Value:@  *	status	    ->	is a boolean integer which indicates success or
  *			failure.   *  * Global Data: -  *	root	    ->	the data structure is scanned.   *D  *	flag	    ->	the flag is used to control the format of the output.  *B  *	infile	    ->	the input filespec is used to generate the output  *			filespec.  *  * Files Used:B  *	An output file is generated.  The output file specification is B  *	constructed using "SYS$DISK:[].GLS" as the file spec and infile  *	as the default filespec.   *  * Assumed Entry State:   *	none   *  * Normal Exit State:   *	status == TRUE	    success.  *  * Error Conditions:  *	status == FALSE	    failure.   *
  * Algorithm: <  *	A. Construct the filename of the output file and open it.3  *	B. Build a style-dependent preamble to the file.    *	C. For each node in the root,,  *	    1. Generate a data line for the item.#  *	    2. For each definition line, /  *		a. Generate a data line for the definition.   *	D. Close the file.   *  * Special Notes:   *	none  -*/    /*)  * Function Glo_Build_File - Code Section   */    int	Glo_Build_File ()  {  /*  * Local Declarations   */      NODE_PTR	    node;     STRING_PTR	    string;     char	    dna[256];     FILE	    f;  /*  * Module Body  */   " if (root == 0)	    return (FALSE);    /* Open the output file.						*/  ! sprintf(dna, "dna = %s", infile); @ f = fopen("sys$disk:[].gls", "w", dna, "rat = cr", "rfm = var");" if (f == NULL)	    return (FALSE);  5 /* Write the style dependent header information.			*/    if (flag != NONE)      { G     fprintf(f,"\\newdimen\\infomapmargin  \\newdimen\\infomapwidth\n"); ?     fprintf(f,"\\infomapmargin 115pt  \\infomapwidth 103pt\n"); A     fprintf(f,"\\def\\infomaplabel#1{\\raisebox{0pt}[1em][0pt]"); /     fprintf(f,"{\\makebox[\\labelwidth][l]\n"); B     fprintf(f,"    {\\parbox[t]{\\infomapwidth}{\\bf #1}}}}\n\n");     }  if (flag == ARTICLE)     { :     fprintf(f,"\\def\\theglossary{\\section{Glossary}\n");     }  if (flag == REPORT)      { N     fprintf(f,"\\def\\theglossary{\\chapter*{Glossary\\markboth{Glossary}\n");M     fprintf(f,"    {Glossary}} \\addcontentsline{toc}{chapter}{Glossary}\n");      }  if (flag != NONE)      { P     fprintf(f,"   \\typeout{Glossary.} \\list{}{\\leftmargin\\infomapmargin\n");O     fprintf(f,"   \\labelwidth\\leftmargin\\advance\\labelwidth-\\labelsep\n"); 7     fprintf(f,"   \\let\\makelabel\\infomaplabel}}\n"); 4     fprintf(f,"\\let\\endtheglossary\\endlist\n\n");     }   - /* Begin the actual glossary code.					    */   & fprintf(f,"\\begin{theglossary}\n\n");  4 /* Process each node in the data structure				    */   node = root; while (node != 0)      { 8     fprintf(f,"\\item[%.*s] ", node->item.dsc$w_length, $ 						    node->item.dsc$a_pointer);     string = node->hdr;      while (string != 0)  	{# 	if (string->desc.dsc$w_length > 0)  	    {5 	    fprintf(f, "%.*s\n", string->desc.dsc$w_length,  " 						string->desc.dsc$a_pointer); 	    } 	else  	    { 	    fprintf(f,"\n");  	    } 	string = string->next;  	}     fprintf(f,"\n");     node = node->next;     }    /* Done.								    */  $ fprintf(f,"\\end{theglossary}\n\n");  
 fclose(f);
 return(TRUE);  } 