 #module    GloBldLab    "1-002"  /*H  ***********************************************************************H  *                                                                     *H  * The software was developed at the Monsanto Company and is provided  *H  * "as-is".  Monsanto Company and the auther disclaim all warranties   *H  * on the software, including without limitation, all implied warran-  *H  * ties of merchantabilitiy and fitness.                               *H  *                                                                     *H  * This software does not contain any technical data or information    *H  * that is proprietary in nature.  It may be copied, modified, and     *H  * distributed on a non-profit basis and with the inclusion of this    *H  * notice.                                                             *H  *                                                                     *H  ***********************************************************************  */    /*+   * Module Name:	GloBldLab   *5  * Author:	R L Aurbach	CR&DS MIS Group    18-Aug-1986   *  * Function:D  *	Build the list of labels seen in the input file.  Also, if a file)  *	entry is seen, add it to the filelist.   *  * Modification History:  *,  * Version     Initials	   Date		DescriptionK  * ------------------------------------------------------------------------ &  * 1-001	RLA	18-Aug-1986	Original Code:  * 1-002	RLA	26-Aug-1986	Fix problem with duplicate label   *					  detection.  -*/    /*:  * Module GloBldLab - Module-Wide Data Description Section  *  * Include Files:   */  #include	descrip #include	stdio #include	"GloDef.H"    /*  * Module Definitions:  */    /*  * Global Declarations:   */    /*  * Static Declarations:   */ 5     static struct dsc$descriptor    str_dyn = STRDYN;    /*  * External References:   */ !     extern char		    infile[256]; !     extern STRING_PTR	    labels; #     extern STRING_PTR	    filelist;    /*  * Functions Called:  */    /*+ 4  * Function Glo_Build_LabLst - Documentation Section  *  * Discussion:I  *	Read the input file and use its contents to build a list of labels for F  *	which glossary entries are needed.  If a file specification is seen7  *	during this operation, add the file to the filelist.   *  * Calling Synopsis:  *	status = Glo_Build_LabLst ()   *
  * Inputs:  *	none   *  * Outputs:   *	none   *  * Return Value:E  *	status	    ->	is a status code for the operation.  It is a boolean 5  *			integer, passed by value.  If TRUE, the routine  6  *			completed normally.  If FALSE, an error occurred.  *  * Global Data: ?  *	labels	    ->	the list of labels is created by this routine.   *H  *	filelist    ->	if one or more files are seen by the routine, they are  *			added to the file list.  *  * Files Used:  *	The input file is read.  *  * Assumed Entry State:   *	none   *  * Normal Exit State: .  *	status = TRUE	normal successful completion.  *  * Error Conditions:I  *	status = FALSE	an error occurred.  The reason for the error is written   *			to SYS$OUTPUT.     *
  * Algorithm:   *	A. Open the input file."  *	B. For each record in the file,"  *	    1. If it is an \indexentry,  *		a. Parse out the label. >  *		b. If the label does not already appear in the label list,/  *		    1. Build a STRING to contain the label. (  *		    2. Chain it into the label list.  *	    2. If it is a \glofile,!  *		a. For each file in the list, ,  *		    1. Parse out the file specification.<  *		    2. Build a STRING to contain the file specification.'  *		    3. Chain it into the file list.   *	    3. Else,   *		a. Ignore the record.   *	C. Close the input file.   *  * Special Notes:   *	none  -*/    /*+  * Function Glo_Build_LabLst - Code Section   */    int	Glo_Build_LabLst ()  {  /*  * Local Declarations   */      int		    status;     FILE	    file;     char	    linebf[linesz];     char	    label[linesz];      int		    found;      STRING_PTR	    new;      STRING_PTR	    old;      char	    spec[linesz];     int		    len;      int		    ptr;      void	    glo_get_token();  /*  * Module Body  */   # /* Open the input file							    */   A if ((file = fopen(infile, "r", "dna = sys$disk:[].glo")) == NULL)      { .     printf("Could not open the input file\n");     return (FALSE);      }   + /* For each record in the file,						    */    status = TRUE;( while (fgets(linebf, linesz, file) != 0)     {    /*K  * If the record begins with \indexentry, then it is a record containing a  L  * label.  Process the label by parsing it out, checking for duplicates, and1  * if unique, building a label list entry for it.   */   2     if (strncmp(linebf, "\\indexentry{", 12) == 0) 	{$ 	glo_get_token(&linebf[12], &label);& 	if (strlen(label) == 0)	    continue; 	old = labels; 	found = FALSE;  	while (old != 0)  	    {1 	    if (strlen(label) == old->desc.dsc$w_length)  		{ . 		if (strncmp(label, old->desc.dsc$a_pointer, 2 			    old->desc.dsc$w_length) == 0)	found = TRUE; 		}  	    if (old->next == 0)	break;  	    old = old->next;  	    } 	if (!found) 	    {/ 	    new = (STRING_PTR) malloc(sizeof(STRING));  	    if (new == 0)	continue; 	    new->next = 0;  	    new->desc = str_dyn;  	    len = strlen(label); ) 	    str$copy_r(&new->desc, &len, label);  	    if (old == 0) 		{  		labels = new;  		} 	 	    else  		{  		old->next = new; 		}  	    } 	}   /*L  * If the record begins with \glofile, then it is a record containing one orO  * more glossary definition file specifications.  For each specification, parse -  * it out and build a file list entry for it.   */   3     else if (strncmp(linebf, "\\glofile{", 9) == 0)  	{" 	glo_get_token(&linebf[9], label);& 	if (strlen(label) == 0)	    continue;	 	ptr = 0; 2 	while (glo_get_next_file(label, &ptr, spec) != 0) 	    {/ 	    new = (STRING_PTR) malloc(sizeof(STRING));  	    if (new == 0)	continue; 	    new->next = 0;  	    new->desc = str_dyn;  	    len = strlen(spec);( 	    str$copy_r(&new->desc, &len, spec); 	    old = filelist; 	    if (old == 0) 		{  		filelist = new;  		} 	 	    else  		{ ) 		while (old->next != 0)	old = old->next;  		old->next = file;  		}  	    } 	}   /*6  * If the record begins with anything else, ignore it.  */        else 	{
 	continue; 	}     }   
 fclose(file);  return (status); }    /*+ 1  * Function Glo_Get_Token - Documentation Section   *  * Discussion:F  *	Parse a token from the command line.  The token begins at the first8  *	character position in the buffer and ends with a "}".  *  * Calling Synopsis:%  *	Call Glo_Get_Token (buffer, token)   *
  * Inputs:E  *	buffer	    ->	is an ASCIZ string containing the token to be found.   *  * Outputs: B  *	token	    ->	is an ASCIZ string into which the token is copied.  *  * Return Value:  *	none   *  * Global Data:   *	none   *  * Files Used:  *	none   *  * Assumed Entry State:   *	none   *  * Normal Exit State:   *	The token is returned.     *  * Error Conditions:  *	none   *
  * Algorithm: /  *	A. Locate the trailing "}" or end of string. G  *	B. Copy the substring starting at the beginning of the buffer to the   *	   end found to the token.    *	C. Null terminate the string.  *  * Special Notes:   *	none  -*/    /*(  * Function Glo_Get_Token - Code Section  */   ) static void	glo_get_token (buffer, token)        char	    *buffer;      char	    *token; {  /*  * Local Declarations   */ 8     int		    len;	    /* Length of the substring		    */ /*  * Module Body  */    len = strcspn(buffer, "}");  strncpy(token, buffer, len); token[len] = '\0'; }    /*+ 5  * Function Glo_Get_Next_File - Documentation Section   *  * Discussion:F  *	Parse the next file specification out of the token list.  Files are@  *	separated by commas.  Return the length of the specification.  *  * Calling Synopsis:0  *	length = Glo_Get_Next_File (token, ptr, spec)  *
  * Inputs:@  *	token	    ->	is an ASCIZ string containing the list of files.  *?  *	ptr	    ->	is an integer (passed by reference) which is the  7  *			starting index in the token string for the search.   *  * Outputs: @  *	spec	    ->	is an ASCIZ string containing the next file spec.  *  * Return Value:A  *	length	    ->	is the length of the spec string.  A value of 0  *  *			indicates that there is no file spec.  *  * Global Data:   *	none   *  * Files Used:  *	none   *  * Assumed Entry State:   *	none   *  * Normal Exit State: B  *	length != 0	spec contains a file spec.  ptr is updated to point/  *			to the starting place for the next search. !  *	length == 0	no spec was found.   *  * Error Conditions:  *	none   *
  * Algorithm: &  *	A. Find the next "," in the string.2  *	B. Copy the substring into the output variable.  *	C. Adjust the pointer. &  *	D. Return the length of the string.  *  * Special Notes:   *	none  -*/    /*,  * Function Glo_Get_Next_File - Code Section  */   / static int	glo_get_next_file (token, ptr, spec)        char	    *token;     int		    *ptr;     char	    *spec;  {  /*  * Local Declarations   */      int		    length; /*  * Module Body  */   % length = strcspn (&token[*ptr], ",");  if (length != 0)     { )     strncpy (spec, &token[*ptr], length);      spec[length] = 0;      (*ptr) += length; %     if (token[*ptr] == ',') (*ptr)++;      }  return (length); } 