 #module    GloCmd    "1-001" /*H  ***********************************************************************H  *                                                                     *H  * The software was developed at the Monsanto Company and is provided  *H  * "as-is".  Monsanto Company and the auther disclaim all warranties   *H  * on the software, including without limitation, all implied warran-  *H  * ties of merchantabilitiy and fitness.                               *H  *                                                                     *H  * This software does not contain any technical data or information    *H  * that is proprietary in nature.  It may be copied, modified, and     *H  * distributed on a non-profit basis and with the inclusion of this    *H  * notice.                                                             *H  *                                                                     *H  ***********************************************************************  */    /*+   * Module Name:	GloCmd  *5  * Author:	R L Aurbach	CR&DS MIS Group    18-Aug-1986   *  * Function:G  *	This routine parses the GloTeX Command Line, and returns the name of H  *	the input file, a flag which specifies the style of treatment for theK  *	output file, and optionally, a list of files for the glossary definition   *	file.  *  * Modification History:  *,  * Version     Initials	   Date		DescriptionK  * ------------------------------------------------------------------------ &  * 1-001	RLA	18-Aug-1986	Original Code -*/    /*7  * Module GloCmd - Module-Wide Data Description Section   *  * Include Files:   */  #include	descrip #include	"GloDef.H"    /*  * Module Definitions:  */    /*  * Global Declarations:   */    /*  * Static Declarations:   */ 0     static $DESCRIPTOR		    (prefix, "GloTeX ");:     static struct dsc$descriptor    command_line = STRDYN;3     static struct dsc$descriptor    temp	 = STRDYN; 6     static struct dsc$descriptor    str_dyn	 = STRDYN;)     static $DESCRIPTOR		    (p1, "File"); -     static $DESCRIPTOR		    (style, "STYLE"); 3     static $DESCRIPTOR		    (glossary, "GLOSSARY");    /*  * External References:   */      globalref int		    glotbl;%     globalref int		    lib$get_input; '     globalref int		    lib$sig_to_stop;   $     extern STRING_PTR		    filelist;     extern int			    flag;"     extern char			    infile[256];   /*  * Functions Called:  */ !     int				    lib$get_foreign();      int				    cli$dcl_parse();      int				    str$prefix();     int				    lib$establish();    /*+ /  * Function Glo_Command - Documentation Section   *  * Discussion:B  *	This routine uses lib$get_foreign to read the command line.  ItE  *	prefixes the command line with "GloTeX ", so that the CLI routines E  *	will have the appropriate information on which to operate. It then I  *	parses the command line and returns the appropriate information to the   *	program.   *H  *	Since the routine establishes LIB$SIG_TO_STOP as a condition handler,E  *	syntax errors detected during processing result in program exit.     *  * Calling Synopsis:  *	Call Glo_Command ()  *
  * Inputs:  *	none   *  * Outputs:   *	none   *  * Return Value:  *	none   *  * Global Data: H  *	infile	    ->	contains the name of the input file as an ASCIZ string.  *;  *	flag	    ->	indicates the value of the /STYLE qualifier.   *F  *	filelist    ->	is updated to contain a list of file specifications.  *  * Files Used:  *	none   *  * Assumed Entry State: .  *	GloTeX is invoked as a foreign DCL command.  *  * Normal Exit State: F  *	The routine returns to the caller.  The global variables are set up  *	appropriately.   *  * Error Conditions:E  *	For the majority of the processing of the routine, LIB$SIG_TO_STOP H  *	is established as the condition handler.  Therefore, any errors cause  *	an immediate exit.       *
  * Algorithm: 8  *	A. Call Lib$Get_Foreign to retrieve the command line.4  *	B. Prefix the command line with the command verb.3  *	C. Call Cli$DCL_Parse to parse the command line.   *	D. Process the file name.  *	    1. Get the file name.(  *	    2. Convert it to an ASCIZ string.#  *	E. Process the /STYLE qualifier. &  *	F. Process the /GLOSSARY qualifier.  *  * Special Notes: D  *	This routine is based on the LIB_PARSE_FOREIGN routine, suitably   *	modified. -*/    /*&  * Function Glo_Command - Code Section  */    void	Glo_Command ()  {  /*  * Local Declarations   */      int		status;     STRING_PTR	file;     STRING_PTR	old;  /*  * Module Body  */     lib$establish(&lib$sig_to_stop);  $ /* Get the command line							    */  ( status = lib$get_foreign(&command_line);- if (!(status & TRUE))	    lib$signal(status);   # str$prefix(&command_line, &prefix);   % /* Parse the command line						    */   6 cli$dcl_parse(&command_line, &glotbl, &lib$get_input);  & /* Get the filename string						    */   cli$get_value(&p1, &temp);7 strncpy(infile, temp.dsc$a_pointer, temp.dsc$w_length); ! infile[temp.dsc$w_length] = '\0';   + /* Process the /STYLE qualifier						    */    flag = NONE; if (cli$present(&style) & TRUE)      { !     cli$get_value(&style, &temp); 6     if (temp.dsc$a_pointer[0] == 'A')  flag = ARTICLE;5     if (temp.dsc$a_pointer[0] == 'R')  flag = REPORT;      }     - /* Process the /GLOSSARY qualifier					    */   " if (cli$present(&glossary) & TRUE)     {      while (TRUE) 	{- 	file = (STRING_PTR) malloc (sizeof(STRING));  	if (file == 0)	break; 	file->next = 0; 	file->desc = str_dyn;0 	status = cli$get_value(&glossary, &file->desc); 	if (!(status & TRUE))	return; 	old = filelist; 	if (filelist == 0)  	    { 	    filelist = file;  	    } 	else  	    {, 	    while (old->next != 0)	old = old->next; 	    old->next = file; 	    } 	}     }  } 