 #module    GloMiss    "1-001"  /*H  ***********************************************************************H  *                                                                     *H  * The software was developed at the Monsanto Company and is provided  *H  * "as-is".  Monsanto Company and the auther disclaim all warranties   *H  * on the software, including without limitation, all implied warran-  *H  * ties of merchantabilitiy and fitness.                               *H  *                                                                     *H  * This software does not contain any technical data or information    *H  * that is proprietary in nature.  It may be copied, modified, and     *H  * distributed on a non-profit basis and with the inclusion of this    *H  * notice.                                                             *H  *                                                                     *H  ***********************************************************************  */    /*+   * Module Name:	GloMiss   *5  * Author:	R L Aurbach	CR&DS MIS Group    22-Aug-1986   *  * Function:=  *	Report those labels for which no glossary entry was found.   *  * Modification History:  *,  * Version     Initials	   Date		DescriptionK  * ------------------------------------------------------------------------ &  * 1-001	RLA	22-Aug-1986	Original Code -*/    /*8  * Module GloMiss - Module-Wide Data Description Section  *  * Include Files:   */  #include	    descrip #include	    stdio #include	    "GloDef.H"    /*  * Module Definitions:  */    /*  * Global Declarations:   */    /*  * Static Declarations:   */    /*  * External References:   */ !     extern STRING_PTR	    labels; !     extern char		    infile[256];    /*  * Functions Called:  */    /*+ 6  * Function Glo_Report_Missing - Documentation Section  *  * Discussion:B  *	Report the labels for which no definition has been found in anyG  *	glossary definition file.  The report is made both to SYS$OUTPUT and &  *	to a glossary log file (.glg file).  *  * Calling Synopsis:!  *	status = Glo_Report_Missing ()   *
  * Inputs:  *	none   *  * Outputs:   *	none   *  * Return Value:?  *	status	    ->	is a boolean integer.  It indicates success or   *			failure of the operation.  *  * Global Data:   *	none   *  * Files Used:  *	none   *  * Assumed Entry State:   *	none   *  * Normal Exit State:   *	status == TRUE	    success.  *  * Error Conditions:  *	status == FALSE	    failure  *
  * Algorithm:   *	A. Open the output file. '  *	B. For each leaf in the labels list, (  *	    1. Report the value of the label.  *  * Special Notes:   *	none  -*/    /*-  * Function Glo_Report_Missing - Code Section   */    int	Glo_Report_Missing ()  {  /*  * Local Declarations   */      STRING_PTR	    token;      char	    dna[256];     FILE	    f;  /*  * Module Body  */    if (labels == 0)	return(TRUE);  $ /* Open the output file							    */  ! sprintf(dna, "dna = %s", infile); @ f = fopen("sys$disk:[].glg", "w", dna, "rat = cr", "rfm = var"); if (f == NULL)		return (FALSE);   ! fprintf(f,"GloTeX Log File\n\n"); 6 fprintf(f,"Processing input file \'%s\'\n\n", infile);   token = labels;  while (token != 0)     { %     if (token->desc.dsc$w_length > 0)  	{8 	printf("The label \'%.*s\' ", token->desc.dsc$w_length,$ 					    token->desc.dsc$a_pointer);; 	printf("was not found in any glossary definition file\n");   ; 	fprintf(f,"The label \'%.*s\' ", token->desc.dsc$w_length, $ 					    token->desc.dsc$a_pointer);> 	fprintf(f,"was not found in any glossary definition file\n"); 	}     token = token->next;     }   
 fclose(f); return (TRUE); } 