 #module    GloTeX    "1-002" /*H  ***********************************************************************H  *                                                                     *H  * The software was developed at the Monsanto Company and is provided  *H  * "as-is".  Monsanto Company and the auther disclaim all warranties   *H  * on the software, including without limitation, all implied warran-  *H  * ties of merchantabilitiy and fitness.                               *H  *                                                                     *H  * This software does not contain any technical data or information    *H  * that is proprietary in nature.  It may be copied, modified, and     *H  * distributed on a non-profit basis and with the inclusion of this    *H  * notice.                                                             *H  *                                                                     *H  ***********************************************************************  */    /*+   * Module Name:	GloTeX  *5  * Author:	R L Aurbach	CR&DS MIS Group    17-Aug-1986   *  * Function:G  *	Main Line for the GloTeX program.  This program processes .glo files F  *	produced by LaTeX and generates files which will produce a properlyC  *	formatted glossary, using definitions extracted from one or more   *	glossary definition files.   *  * Modification History:  *,  * Version     Initials	   Date		DescriptionK  * ------------------------------------------------------------------------ &  * 1-001	RLA	17-Aug-1986	Original Code=  * 1-001	RLA	25-Aug-1986	Improve handling of error when there #  *					  is no gdf file to process.  -*/    /*7  * Module GloTeX - Module-Wide Data Description Section   *  * Include Files:   */  #include	    descrip #include	    stdio #include	    "GloDef.H"    /*  * Module Definitions:  */    /*  * Global Declarations:   */ H     STRING_PTR	    filelist = 0;   /* Listhead for glossary filespecs	*/>     NODE_PTR	    root = 0;	    /* Listhead for definitions		*/3     int		    flag = 0;	    /* /TOC options flag		*/ 9     char	    infile[256];    /* Input filespec string		*/ =     STRING_PTR	    labels = 0;	    /* Listhead for labels		*/    /*  * Static Declarations:   */    /*  * External References:   */    /*  * Functions Called:  */    /*+ *  * Function GloTeX - Documentation Section  *  * Discussion:1  *	This is the main line of the GloTeX program.     *E  *	It reads the input file and creates from it a list of items to be  
  *	defined.     *F  *	It then reads one or more glossary definition files, searching for I  *	definitions which match the items specified.  If it finds an item, it  I  *	copies the definition into an internal data structure and removes the  F  *	item from the list.  In this way, the first definition seen for an   *	item is always used.   *D  *	Once the list of definition files is exhausted, the internal dataK  *	structures hold a complete list of all definitions.  Any items remaining H  *	in the item list represent items for which no definitions were found.  *	These are reported.  *F  *	Finally, the internal data structures are used to build a text file=  *	which will be processed by LaTeX to generate the glossary.   *  * Calling Synopsis:"  *	$ GloTeX :== $Crl_Public:GloTeX;  *	$ GloTeX filespec [/STYLE:{ARTICLE | REPORT | SPECIAL}]  &  *			    [/GLOSSARY=(file1,file2,...)]  *
  * Inputs:F  *	filespec    ->	Name of the input file to be processed.  The default7  *			filespec SYS$DISK:[].GLO is processed against this 8  *			specification.  This is the file generated by LaTeX"  *			by the \makeglossary command.  *I  *	/STYLE	    ->  The /STYLE qualifier indicates the type of document for 9  *			which the glossary is to be generated.  Options are: =  *			    * ARTICLE - a standard LaTeX "article" documentstyle 8  *			    * REPORT  - a standard LaTeX "report" or "book"  *					documentstyle<  *			    * SPECIAL - any of the CR&DS special documentstyles;  *			If the qualifier is not specified, SPECIAL is assumed.   *G  *	/GLOSSARY   ->	The /GLOSSARY qualifier defines one or more glossary  :  *			definition files.  Each value in the list is the file8  *			specification of a glossary definition file.  These7  *			files are the basis for the list of glossary files   *			managed by the program.    *9  *			If using a document style which does not define the  ;  *			\glossaryfile command (i.e., a standard LaTeX document 3  *			style), then this qualifier is the only means  7  *			available to specify the files to be searched for    *			definitions.       *:  *			If using a CR&DS document style, then this qualifier 8  *			is used to specify definition files to be searched 9  *			before any specified by the \glossaryfile command.     *7  *			The qualifier is optional.  However, at least one  6  *			definition file must be specified to the program.  *  * Outputs: C  *	filespec    ->	The program produces an output file which is the  ;  *			resultant filespec from processing .GLS as the primary 6  *			file specification and the fully-qualified input   *			filespec as the default.   *  * Return Value:  *	returns SUCCESS  *  * Global Data: G  *	All commonly-used data structures, such as the file list, the label  4  *	list, the node list, etc., are declared globally.  *  * Files Used:K  *	reads the specified input file and one or more glossary definition files 0  *	as described above.  Produces an output file.  *  * Assumed Entry State:   *	Called from DCL level  *  * Normal Exit State:   *	Returns to DCL level   *  * Error Conditions:E  *	Error messages are generated for all errors.  Any significant ones 9  *	cause the program to exit with an appropriate message.   *
  * Algorithm:   *	A. Process the command line.   *	B. Process the input file. 6  *	    1. Glossary label entries are placed on a list.;  *	    2. Glossary file entries are added to the file list. %  *	C. For each file in the file list, G  *	    1. Scan the glossary file for definitions which match a label in   *	       the label list.   *	    2. If found, ;  *		a. Copy the definition to a node in the data structure. <  *	D. For any labels for which the definition was not found,  *	    1. Report it.  *	E. Generate the output file.   *  * Special Notes:   *	none  -*/    /*!  * Function GloTeX - Code Section   */    main() {  /*  * Local Declarations   */      int		    status;     STRING_PTR	    file; /*  * Module Body  */   @ /* Process the command line.  The routine will exit on error		*/   glo_command();  N printf("\nGloTeX, the automatic glossary processor for LaTeX, version 1.0\n");   /*.  * Process the list of definitions referenced:  *  Open the input file.&  *  For each entry record in the file,.  *      Build a label entry in the label list.%  *  For each file record in the file, '  *	Build a file entry in the file list.   *  Close the input file.   */    status = glo_build_lablst(); if (!(status & TRUE))      { C     printf("\nFatal error processing the input file...aborting\n");      exit();      }    if (labels == 0)     { I     printf("\nFatal error.  No glossary entries found in the .glo file");      printf("...aborting\n");     exit();      }    /*"  * For each file in the file list,I  *  Scan the file for entries which match labels with label list entries. 9  *  For each one, build a node containing the definition.   */    if (filelist == 0)     {      glo_report_missing(); D     printf("\nNo glossary definition files specified...aborting\n");     exit();      }    file = filelist; while (file != 0)      { !     status = glo_scan_file(file);      if (!(status & TRUE))  	{H 	printf("\nFatal error scanning glossary definition file...aborting\n"); 	exit(); 	}     file = file->next;     }    /*9  * Report all labels for which no definitions were found. (  *  Write the information to SYS$OUTPUT.1  *  Write the information to a glossary log file.   */    status = glo_report_missing(); if (!(status & TRUE))      { H     printf("\nFatal error while reporting the list of undefined terms");     printf("...aborting\n");     exit();      }    /*?  * Generate a formatted output file containing the definitions. K  * The file format will be dependent on whether the glossary is being built I  *  for a LaTeX "article", a LaTeX "report" or "book", or a CR&DS defined   *  documentstyle.  */    status = glo_build_file(); if (!(status & TRUE))      { =     printf("\nFatal error while building the output file/n");      }    exit();  } 