 #module    IdxBuild    "2-005" /*H  ***********************************************************************H  *                                                                     *H  * The software was developed at the Monsanto Company and is provided  *H  * "as-is".  Monsanto Company and the auther disclaim all warranties   *H  * on the software, including without limitation, all implied warran-  *H  * ties of merchantabilitiy and fitness.                               *H  *                                                                     *H  * This software does not contain any technical data or information    *H  * that is proprietary in nature.  It may be copied, modified, and     *H  * distributed on a non-profit basis and with the inclusion of this    *H  * notice.                                                             *H  *                                                                     *H  ***********************************************************************  */    /*+   * Module Name:	IdxBuild  *5  * Author:	R L Aurbach	CR&DS MIS Group    27-Apr-1986   *  * Function:&  *	Build the Index Tree data structure  *  * Modification History:  *,  * Version     Initials	   Date		DescriptionK  * ------------------------------------------------------------------------ &  * 1-001	RLA	27-Apr-1986	Original Code=  * 1-002	RLA	03-May-1986	Add support for page-no highlighting .  *					  and move spell-string processing to a  *					  separate module. @  * 2-003	RLA	09-Apr-1987	Add support for volumes (used in master  *					  index processing). 4  * 2-004	RLA	14-Apr-1987	Add new page highlight flag:  * 2-005	RLA	15-Apr-1987	Add support for cross-referencing -*/    /*9  * Module IdxBuild - Module-Wide Data Description Section   *  * Include Files:   */  #include	    descrip #include	    stdio #include	    ctype #include	    "IdxDef.H"    /*  * Module Definitions:  */  #define		    TRUE	1  #define		    FALSE	0   #define		    linebfsize	133    /*  * Global Declarations:   */    /*  * Static Declarations:   */ .     static struct dsc$descriptor   dyn_str  = , 					{ 0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0 };.     static struct dsc$descriptor   page_ref = , 					{ 0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0 };/     static struct dsc$descriptor   tok_spell =  , 					{ 0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0 };/     static struct dsc$descriptor   see_spell =  , 					{ 0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0 };   /*  * External References:   */ ;     extern TREE_PTR	root;		/* root of the Index Tree	    */    /*  * Functions Called:  */    /*+ 2  * Function Idx_Build_Tree - Documentation Section  *  * Discussion:K  *	This routine uses the information parsed by Idx_Parse to build the Index   *	Tree.  *  * Calling Synopsis:F  *	Call Idx_Build_Tree (token_1, token_2, token_3, page_no, token_ct,   *								    vol, flag)  *
  * Inputs:F  *	token_1	    ->	is the top level item token.  ASCIZ string passed by  *			reference.   *I  *	token_2	    ->	is the second level item token.  ASCIZ string passed by   *			reference.   *H  *	token_3	    ->	is the third level item token.  ASCIZ string passed by  *			reference.   *D  *	page_no	    ->	is the page number token.  ASCIZ string passed by   *			reference.   *D  *	token_ct    ->	is the number of tokens seen for this index entry.  *			integer passed by value.   *A  *	vol	    ->	is a pointer to the string descriptor for a volume  -  *			string.  The pointer is passed by value.   *C  *	flag	    ->	is a boolean flag.  If TRUE, the page_no variable is %  *			really a cross-reference string.   *  * Outputs:   *	none   *  * Return Value:  *	none   *  * Global Data:   *	The Index Tree is updated.   *  * Files Used:  *	none   *  * Assumed Entry State:   *	none   *  * Normal Exit State:   *	Tree is updated.   *  * Error Conditions:I  *	The only expected error is a memory allocation failure.  In this case, 1  *	a message is printed and the entry is ignored.     *
  * Algorithm: ,  *	A. Check for a page-no highlighting flag.:  *	B. Check for a valid set of input data.  Ignore if not.2  *	C. Build a Spell String for the top-level item.,  *	D. Locate the top-level item in the tree.  *	    1. If it does not exist, *  *		A. Allocate a new node and link it in.  *	E. If token_ct == 1, "  *	    1. Add page number to list.  *	F. Else, 9  *	    1. Build a Spell String for the second-level item. 3  *	    2. Locate the second-level item in the tree.   *		A. If it does not exist,.  *		    1. Allocate a new node and link it in.  *	    3. If token_ct == 2,   *		A. Add page number to list.   *	    4. Else, 5  *		A. Build a Spell String for the third-level item. /  *		B. Locate the third-level item in the tree.    *		    1. If it does not exist,+  *			a. Allocate a new node and link it in.   *		C. Add page number to list.   *  * Special Notes: F  *	The first character of token_1 may be a special character.  SpecialG  *	characters are used to indicate special highlighting to be performed D  *	on the page-no for this index entry.  The special characters are:  *	    ^	use boldface   *	    ~	use italic   *	    _	use underliningB  *	Only one type of highlighting is supported for each page entry. -*/    /*)  * Function Idx_Build_Tree - Code Section   */   M void	idx_build_tree (token_1, token_2, token_3, page_no, token_ct, vol, flag)        char		    *token_1;      char		    *token_2;      char		    *token_3;      char		    *page_no;      char		    token_ct; !     struct dsc$descriptor   *vol;      int			    flag;  {  /*  * Local Declarations   */ O     struct dsc$descriptor   spell_str = { 0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0 };      TREE_PTR		    node; '     void		    idx_build_spell_string(); $     TREE_PTR		    idx_locate_node();!     void		    idx_add_page_ref();      int			    test_char;     char		    *real_token_1;     char		    highlight;"     void		    idx_add_cross_ref(); /*  * Module Body  */   - /* Check for page-no highlighting flag					*/    if (token_ct == 0)				return; " if (token_1[0] == '\0')				return; real_token_1 = &token_1[1];  test_char = token_1[0];  switch (test_char)     { 2     case '_' :	highlight = IDX_K_UNDERLINE;	break;  /     case '~' :	highlight = IDX_K_ITALIC;	break;   .     case '^' :	highlight = IDX_K_BOLD;		break;  /     case '#' :	highlight = IDX_K_FOLLOW;	break;   &     default  :	highlight = IDX_K_NONE; 		real_token_1 = &token_1[0];  		break;     }   ) /* Check out the item for validity					*/   & if (real_token_1[0] == '\0')			return;3 if ((token_ct > 1) && (token_2[0] == '\0'))	return; 3 if ((token_ct > 2) && (token_3[0] == '\0'))	return;  if (token_ct > 3)				return;" if (page_no[0] == '\0')				return;  ' /* First level token processing						*/   2 idx_build_spell_string (real_token_1, &spell_str);9 node = idx_locate_node (&root, real_token_1, &spell_str);  if (node == 0)     { =     printf("Error processing index item %s\n", real_token_1);      return;      }  if (token_ct == 1)     { I     if (!flag)	idx_add_page_ref (&node->pghead, page_no, highlight, vol); E     else	idx_add_cross_ref (&node->seehead, page_no, highlight, vol);      }   ' /* Second level token processing					*/    else     { 1     idx_build_spell_string (token_2, &spell_str); A     node = idx_locate_node (&node->subhead, token_2, &spell_str);      if (node == 0) 	{8 	printf("Error processing index subitem %s\n", token_2); 	return; 	}     if (token_ct == 2) 	{H 	if (!flag)   idx_add_page_ref (&node->pghead, page_no, highlight, vol);F 	else	    idx_add_cross_ref (&node->seehead, page_no, highlight, vol); 	}  ' /* Third level token processing						*/        else 	{. 	idx_build_spell_string (token_3, &spell_str);> 	node = idx_locate_node (&node->subhead, token_3, &spell_str); 	if (node == 0)  	    {? 	    printf("Error processing index subsubitem %s\n", token_3);  	    return; 	    }G 	if (!flag)  idx_add_page_ref (&node->pghead, page_no, highlight, vol); F 	else	    idx_add_cross_ref (&node->seehead, page_no, highlight, vol); 	}     }  }    /*+ 3  * Function Idx_Locate_Node - Documentation Section   *  * Discussion:E  *	This routine scans the list of nodes (starting from the listhead), B  *	looking for one which has a spell-string identical to the givenK  *	spell string.  If it doesn't find one, it adds a node in the right place /  *	in the chain to maintain alphabetical order.   *  * Calling Synopsis:-  *	node = Idx_Locate_Node (head, token, desc)   *
  * Inputs:?  *	head	    ->	is the address of the listhead of the list to be 4  *			scanned.  As such, it is a TREE_PTR, passed by   *			reference.   *B  *	token	    ->	is the token to be located or entered in the list.&  *			ASCIZ string passed by reference.  *9  *	desc	    ->	is the spell string, passed by descriptor.   *  * Outputs:   *	none   *  * Return Value:E  *	node	    ->	is the address of the tree leaf for the current token. <  *			It is a TREE_PTR, passed by value.  If the leaf did not;  *			already exist and if the system was unable to allocate $  *			one, the node is returned as 0.  *  * Global Data: D  *	The list specified by the listhead will be modified if it is not -  *	possible to add a new leaf when necessary.   *  * Files Used:  *	none   *  * Assumed Entry State:    *	An empty listhead contains 0.  *  * Normal Exit State:   *	The node is returned.  *  * Error Conditions:"  *	Allocation failure -- node = 0.    *
  * Algorithm:   *	A. If the list is empty, )  *	    1. Allocate a node and link it in.   *	B. Else, (  *	    1. Beginning with the first node,+  *		a. If spell-string < node-spell-string,   *		    1. Get next node. +  *		b. If spell-string = node-spell-string,   *		    1. Return node pointer. +  *		c. If spell-string > node-spell-string, *  *		    1. Allocate a node and link it in.  *  * Special Notes: J  *	Although this algorithm isn't a very efficient way to alphatize things,F  *	it has the tremendous virtue of being easy to implement.  Since theG  *	program is not run often (typically a couple of times per document), %  *	the inefficiency is not important.  -*/    /**  * Function Idx_Locate_Node - Code Section  */   , TREE_PTR	idx_locate_node (head, token, desc)       TREE_PTR			*head;      char			*token;      struct dsc$descriptor	*desc; {  /*  * Local Declarations   */      TREE_PTR			node;     TREE_PTR			old_node;     TREE_PTR			new_node;     int				status;#     TREE_PTR			idx_allocate_node();  /*  * Module Body  */   ; /* Chain through the list, looking for the right place			*/   
 old_node = 0;  new_node = *head;  while (new_node != 0)      { 1     status = str$compare(&new_node->spell, desc);      if (status < 0)  	{ 	old_node = new_node;  	new_node = new_node->link; 
 	continue; 	}     if (status == 0) 	{ 	return (new_node);  	}     if (status > 0)  	{( 	node = idx_allocate_node (token, desc); 	if (old_node == 0)  	    { 	    *head = node; 	    } 	else  	    { 	    old_node->link = node;  	    } 	node->link = new_node;  	return (node);  	}     }   < /* If the list is exhausted, allocate a node immediately		*/  ' node = idx_allocate_node (token, desc);  if (old_node == 0)     {      *head = node;      }  else     {      old_node->link = node;     }  return (node); }    /*+ 5  * Function Idx_Allocate_Node - Documentation Section   *  * Discussion:4  *	Allocate and initialize a leaf of the Index Tree.  *  * Calling Synopsis:)  *	node = Idx_Allocate_Node (token, desc)   *
  * Inputs:@  *	token	    ->	token string.  ASCIZ string passed by reference.  *D  *	desc	    ->	spell string.  Character string passed by descriptor.  *  * Outputs:   *	none   *  * Return Value:B  *	node	    ->	Address of the allocated node.  TREE_PTR passed by   *			value.   *  * Global Data:   *	none   *  * Files Used:  *	none   *  * Assumed Entry State:   *	none   *  * Normal Exit State:   *	node is allocated.   *  * Error Conditions:/  *	allocation failure -- node is returned == 0.   *
  * Algorithm: +  *	A. Allocate virtual memory for the node. $  *	B. Initialize the node structure.  *  * Special Notes:   *	none  -*/    /*,  * Function Idx_Allocate_Node - Code Section  */   ( TREE_PTR	idx_allocate_node (token, desc)       char		    *token; "     struct dsc$descriptor   *desc; {  /*  * Local Declarations   */      int			    token_length;      TREE_PTR		    node;  /*  * Module Body  */   ( node = (TREE_PTR) malloc (sizeof(TREE)); if (node != 0)     {      node->link    = 0;     node->spell   = dyn_str;     node->item    = dyn_str;     node->subhead = 0;     node->pghead  = 0;     node->seehead = 0;$     str$copy_dx(&node->spell, desc);!     token_length = strlen(token); 2     str$copy_r(&node->item, &token_length, token);     }    return (node); }    /*+ 4  * Function Idx_Add_Page_Ref - Documentation Section  *  * Discussion:F  *	If the specified page reference is not already in the current list,!  *	add it to the end of the list.   *  * Calling Synopsis:8  *	Call Idx_Add_Page_Ref (pghead, token, highlight, vol)  *
  * Inputs:I  *	pghead	    ->	the address of the listhead for the page reference list. '  *			a PGNODE_PTR, passed by reference.   *F  *	token	    ->	the page reference.  ASCIZ string passed by reference.  *E  *	highlight   ->	a flag indicating what sort of highlighting to give ;  *			this particular page reference.  char passed by value.   *A  *	vol	    ->	is a pointer to a character string descriptor which !  *			describes the volume string.   *  * Outputs:   *	none   *  * Return Value:  *	none   *  * Global Data: B  *	If a new page reference needs to be added, the list is updated.  *  * Files Used:  *	none   *  * Assumed Entry State:   *	none   *  * Normal Exit State: C  *	If the page reference already exists, nothing happens.  If a new H  *	page reference needs to be added, it is allocated and appended to the  *	end of the list.   *  * Error Conditions:F  *	If there is an allocation failure, the page reference is not added.    *
  * Algorithm: 0  *	A. Put the page_no token in a dynamic string.   *	B. For all nodes in the list,@  *	    1. If the page-no in the list does not match the page-no,  *		a. Get next node.   *	    2. Else,   *		a. Return.  *	C. If the list is exhausted,   *	    1. Allocate a new node.  *	    2. Fill it in. *  *	    3. Chain it to the end of the list.  *  * Special Notes: G  *	This routine assumes that page-no references are always in numerical D  *	order.  This assumption is necessary, because the variety of pageG  *	numbering (perhaps within the document) makes it impossible to check 
  *	for order.  -*/    /*+  * Function Idx_Add_Page_Ref - Code Section   */   5 void	idx_add_page_ref (pghead, token, highlight, vol)        PGNODE_PTR		    *pghead;     char		    *token;      char		    highlight;!     struct dsc$descriptor   *vol;  {  /*  * Local Declarations   */      int		    token_length;     PGNODE_PTR	    node;'     PGNODE_PTR	    last_node = *pghead; )     PGNODE_PTR	    idx_allocate_pgnode();  /*  * Module Body  */    token_length = strlen(token); , str$copy_r(&page_ref, &token_length, token);   while (last_node != 0)     { >     if ((str$compare(&last_node->page_dsc, &page_ref) == 0) && 	(last_node->vol == vol))  	{% 	if (highlight == IDX_K_NONE)	return; " 	last_node->highlight = highlight; 	return; 	}(     if (last_node->link == 0)	    break;      last_node = last_node->link;     }   7 node = idx_allocate_pgnode (vol, &page_ref, highlight);  if (node != 0)     {      if (last_node == 0)  	{ 	*pghead = node; 	}     else 	{ 	last_node->link = node; 	}     }  }    /*+ 5  * Function Idx_Add_Cross_Ref - Documentation Section   *  * Discussion:J  *	Parse and build a cross reference string.  If the string is not alreadyA  *	on the current list, add it to the list in alphabetical order.   *  * Calling Synopsis::  *	Call Idx_Add_Cross_Ref (seehead, token, highlight, vol)  *
  * Inputs:F  *	seehead	    ->	the address of the listhead for the cross-reference 
  *			list.  *C  *	token	    ->	the cross-reference string.  ASCIZ string passed by   *			reference.   *E  *	hightlight  ->	a flag indicating what sort of highlighting to give"<  *			this particular cross-reference.  char passed by value.  *A  *	vol	    ->	is a pointer to a character string descriptor which !  *			describes the volume string.f  *  * Outputs:e  *	noneM  *  * Return Value:  *	none   *  * Global Data:aC  *	If a new cross-reference needs to be added, the list is updated.t  *  * Files Used:  *	nonea  *  * Assumed Entry State:   *	nonef  *  * Normal Exit State:sD  *	If the cross-reference already exists, nothing happens.  If a newE  *	page reference needs to be added, it is allocated and added to thei  *	list.  *  * Error Conditions:F  *	If there is an allocation failure, the page reference is not added.    *
  * Algorithm:o+  *	A. Parse the page reference into tokens.fK  *	B. Build the cross-reference text string and put it in a dynamic string. "  *	C. Build a spell string for it.%  *	D. Chain the string into the list.   *  * Special Notes:*  *	none* -*/* * /*,  * Function Idx_Add_Cross_Ref - Code Section  */d  7 void	idx_add_cross_ref (seehead, token, highlight, vol)o       PGNODE_PTR		    *seehead;o     char		    *token;T     char		    highlight;!     struct dsc$descriptor   *vol;i {  /*  * Local Declarationsp  */      int			    length;-     PGNODE_PTR		    node;-!     PGNODE_PTR		    old_node = 0;R(     PGNODE_PTR		    new_node = *seehead;      char		    tok_1[linebfsize];      char		    tok_2[linebfsize];      char		    tok_3[linebfsize];      char		    dummy[linebfsize];     int			    tok_ct;p     int			    flag;d'     void		    idx_build_spell_string(); *     PGNODE_PTR		    idx_allocate_pgnode(); /*  * Module Body  */-   /*D  * Parse the cross-reference string into its tokens using Idx_Parse.G  * Then combine the results to build a token string and write it to thei6  * page_ref dynamic string.  Compute its spell string.  */i  > idx_parse (token, tok_1, tok_2, tok_3, dummy, &tok_ct, &flag); if (tok_ct == 0)			return;! if (strlen(tok_1) == 0)			return;	- if (tok_ct > 1 && strlen(tok_2) == 0)	return;*- if (tok_ct > 2 && strlen(tok_3) == 0)	return;r  & length = sprintf (dummy, "%s", tok_1);B if (tok_ct > 1)	length += sprintf (&dummy[length], ", %s", tok_2);B if (tok_ct > 2) length += sprintf (&dummy[length], ", %s", tok_3);  & str$copy_r(&page_ref, &length, dummy);  * idx_build_spell_string(dummy, &tok_spell);   /*G  * Now scan the list of cross-references to find where to put this one.C  */A   while (new_node != 0)r     {e5     strncpy(dummy, new_node->page_dsc.dsc$a_pointer, h* 					    new_node->page_dsc.dsc$w_length);2     dummy[new_node->page_dsc.dsc$w_length] = '\0';.     idx_build_spell_string(dummy, &see_spell);/     flag = str$compare(&see_spell, &tok_spell);e     if (flag < 0)  	{ 	old_node = new_node;S 	new_node = new_node->link;r
 	continue; 	}     if (flag == 0) 	return;     if (flag > 0)  	{7 	node = idx_allocate_pgnode(vol, &page_ref, highlight);l 	if (node != 0)I 	    {( 	    if (old_node == 0)	*seehead = node;! 	    else		old_node->link = node;t 	    node->link = new_node;  	    } 	return; 	}     }k  < /* If the list is exhausted, allocate a node immediately		*/  6 node = idx_allocate_pgnode(vol, &page_ref, highlight); if (node != 0)     {n+     if (old_node == 0)	    *seehead = node;c$     else		    old_node->link = node;     }  }e n /*+ 7  * Function Idx_Allocate_PgNode - Documentation Sectioni  *  * Discussion:+  *	Allocate and initialize a new page node.o  *  * Calling Synopsis:/  *	node = Idx_Allocate_PgNode (vol, dsc, hlite)   *
  * Inputs:=  *	vol	    ->	is the address of the volume string descriptor.s  *?  *	dsc	    ->	is the address of the page ref string descriptor.*  *%  *	hlite	    ->	is the highlight flagU  *  * Outputs:*  *	nonem  *  * Return Value::  *	node	    ->	is the address of the newly allocated node.  *  * Global Data:   *	nonel  *  * Files Used:  *	nonea  *  * Assumed Entry State:a  *	nonea  *  * Normal Exit State:   *	nonei  *  * Error Conditions:2  *	if the allocation failed, node is returned = 0.  *
  * Algorithm:   *	A. Allocate the node.  *	B. If successful,  *	    1. Initialize it.  *  * Special Notes:D  *	nonet -*/p v /*.  * Function Idx_Allocate_PgNode - Code Section  */*  0 PGNODE_PTR	idx_allocate_pgnode (vol, dsc, hlite)  !     struct dsc$descriptor   *vol;m!     struct dsc$descriptor   *dsc;1     char		    hlite; {r /*  * Local Declarations*  */2     PGNODE_PTR		    node;t /*  * Module Body  */I  , node = (PGNODE_PTR) malloc (sizeof(PGNODE));   if (node != 0)     {      node->link	    = 0;      node->vol	    = vol;     node->page_dsc  = dyn_str;     node->highlight = hlite;&     str$copy_dx(&node->page_dsc, dsc);     }e   return (node); } 