 #module	IdxCmd		"2-002"  /*H  ***********************************************************************H  *                                                                     *H  * The software was developed at the Monsanto Company and is provided  *H  * "as-is".  Monsanto Company and the auther disclaim all warranties   *H  * on the software, including without limitation, all implied warran-  *H  * ties of merchantabilitiy and fitness.                               *H  *                                                                     *H  * This software does not contain any technical data or information    *H  * that is proprietary in nature.  It may be copied, modified, and     *H  * distributed on a non-profit basis and with the inclusion of this    *H  * notice.                                                             *H  *                                                                     *H  ***********************************************************************  */    /*+   * Module Name:	IdxCmd  *6  * Author:	R L Aurbach	CR&DS MIS Group	    13-Jun-1986  *  * Function:  *G  *	This routine parses the IdxTeX Command Line, and returns the name of G  *	the input file and a flag which indicates whether to add an entry to '  *	the table of contents for the Index.   *  * Modification History:  *,  * Version     Initials	   Date		DescriptionK  * ------------------------------------------------------------------------ <  * 1-001	RLA	13-Jun-1986	Original Code, based on the CRDVLIB(  *					Library routine LIB_PARSE_FOREIGN>  * 2-002	RLA	09-Apr-1987	Add support for the /MASTER qualifier -*/    /*7  * Module IdxCmd - Module-Wide Data Description Section   *  * Include Files:   */  #include descrip #include "IdxDef.H"    /*  * Module Definitions:  */ % #define TRUE		1		/* Success value		*/ & #define FALSE		0		/* Failure value		*/7 #define str_dyn		{ 0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0 }    /*  * Global Declarations:   */    /*  * Static Declarations:   */ +     static $DESCRIPTOR	(prefix, "IdxTeX "); ;     static struct dsc$descriptor    command_line = str_dyn; 8     static struct dsc$descriptor    file_desc = str_dyn;8     static struct dsc$descriptor    toc_value = str_dyn;$     static $DESCRIPTOR	(p1, "File");$     static $DESCRIPTOR	(toc, "TOC");*     static $DESCRIPTOR	(master, "MASTER");   /*  * External References:   */      globalref int	idxtex_table;       globalref int	lib$get_input;"     globalref int	lib$sig_to_stop;   /*  * Functions Called:  */ :     int		lib$get_foreign();	/* Get foreign command line	*/8     int		cli$dcl_parse();	/* Parse a DCL command line	*/.     int		str$prefix();		/* Prefix a string		*/<     int		lib$establish();	/* Establish a condition handler*/   /*+ 0  * Function Idx_Commmand - Documentation Section  *  * Discussion:C  *	This routine uses lib$get_foreign to read the command line.  It  E  *	prefixes the command line with "IdxTeX ", so that the CLI routines F  *	will have the appropriate information on which to operate.  It thenI  *	parses the command line and returns the appropriate information to the   *	program.   *I  *	Since this routine establishes LIB$SIG_TO_STOP as a condition handler, C  *	syntax errors detected during processing result in program exit.   *  * Calling Synopsis:.  *	Call Idx_Command (file, toc_flag, mst_flag)  *
  * Inputs:  *	none   *  * Outputs: E  *	file	    ->	is the input file specified in the command line.  This 8  *			is a required parameter.  This variable is an ASCIZ8  *			string passed by reference.  The calling program is5  *			responsible for allocating a sufficiently large  #  *			string (i.e., char file[256]).   *E  *	toc_flag    ->	indicates whether the /TOC qualifier was specified.   *			Values returned are: ,  *			    IDX_K_NONE    - /TOC not specified.0  *			    IDX_K_ARTICLE - /TOC:ARTICLE specified./  *			    IDX_K_REPORT  - /TOC:REPORT specified.   *H  *	mst_flag    ->	indicates whether the /MASTER qualifier was specified.  *			Returns a boolean result.  *  * Return Value:  *	none   *  * Global Data:   *	none   *  * Files Used:  *	none   *  * Assumed Entry State: .  *	IdxTeX is invokes as a Foreign DCL command.  *  * Normal Exit State: E  *	Routine returns to caller.  The "file", "toc_flag", and "mst_flag" "  *	variables are set up correctly.  *  * Error Conditions:J  *	Since the routine establishes LIB$SIG_TO_STOP as its exception handler,H  *	syntax and parsing errors detected by the CLI$ routines (which signalE  *	errors) cause the program to exit.  That is, all syntax errors are 	  *	fatal.     *
  * Algorithm: 8  *	A. Call Lib$Get_Foreign to retrieve the command line.4  *	B. Prefix the command line with the command verb.3  *	C. Call Cli$DCL_Parse to parse the command line.   *	D. Process the file name.  *	    1. Get the file name.(  *	    2. Convert it to an ASCIZ string.!  *	E. Process the /TOC qualifier. #  *	    1. If /TOC is not specified,   *		a. toc_flag = IDX_K_NONE. $  *	    2. If /TOC:ARTICLE specified,   *		a. toc_flag = IDX_K_ARTICLE.#  *	    3. If /TOC:REPORT specified.   *		a. toc_flag = IDX_K_REPORT. $  *	F. Process the /MASTER qualifier.  *  * Special Notes: C  *	This routine is based on the LIB_PARSE_FOREIGN routine, suitably   *	modified. -*/    /*&  * Function Idx_Command - Code Section  */   + void	idx_command (file, toc_flag, mst_flag)   ,     char	*file;			/* File name parameter		*/&     int		*toc_flag;		/* /TOC flag			*/)     int		*mst_flag;		/* /MASTER flag			*/  {  /*  * Local Declarations:  */ '     int		status;			/* return status		*/  /*  * Module Body:   */   ' /* Establish a condition handler					*/     lib$establish(&lib$sig_to_stop);    /* Get the command line							*/  ( status = lib$get_foreign(&command_line);  if (!status)	lib$signal(status);  # str$prefix(&command_line, &prefix);   ! /* Parse the command line						*/   < cli$dcl_parse(&command_line, &idxtex_table, &lib$get_input);  " /* Get the filename string						*/   cli$get_value(&p1,&file_desc);@ strncpy (file, file_desc.dsc$a_pointer, file_desc.dsc$w_length);$ file[file_desc.dsc$w_length] = '\0';  % /* Process the /TOC qualifier						*/    *toc_flag = IDX_K_NONE; $ if ((cli$present(&toc) & TRUE) != 0)     { $     cli$get_value(&toc, &toc_value);F     if (toc_value.dsc$a_pointer[0] == 'A')  *toc_flag = IDX_K_ARTICLE;E     if (toc_value.dsc$a_pointer[0] == 'R')  *toc_flag = IDX_K_REPORT;      }   ' /* Process the /MASTER qualifier					*/    *mst_flag = FALSE;= if ((cli$present(&master) & TRUE) != 0)	    *mst_flag = TRUE;  } 