 #module    IdxGen    "2-008" /*H  ***********************************************************************H  *                                                                     *H  * The software was developed at the Monsanto Company and is provided  *H  * "as-is".  Monsanto Company and the auther disclaim all warranties   *H  * on the software, including without limitation, all implied warran-  *H  * ties of merchantabilitiy and fitness.                               *H  *                                                                     *H  * This software does not contain any technical data or information    *H  * that is proprietary in nature.  It may be copied, modified, and     *H  * distributed on a non-profit basis and with the inclusion of this    *H  * notice.                                                             *H  *                                                                     *H  ***********************************************************************  */    /*+   * Module Name:	IdxGen  *5  * Author:	R L Aurbach	CR&DS MIS Group    28-Apr-1986   *  * Function:C  *	Generate the text file used to actually generate the index text.   *  * Modification History:  *,  * Version     Initials	   Date		DescriptionK  * ------------------------------------------------------------------------ &  * 1-001	RLA	28-Apr-1986	Original Code=  * 1-002	RLA	03-May-1986	Add support for page-no highlighting ;  * 1-003	RLA	14-Jun-1986	Add support for the /TOC qualifier =  * 2-004	RLA	10-Apr-1987	Enhance the visual appearance of the +  *					  index and add support of a master    *					  index. =  * 2-005	RLA	11-Apr-1987	Fix spacing around each new group by '  *					  defining the \indexhead macro. >  * 2-006	RLA	14-Apr-1987	Support new page-no highlight option.:  * 2-007	RLA	16-Apr-1987	Add support for cross references.6  * 2-008	RLA	20-Apr-1987	Final formatting enhancements -*/    /*7  * Module IdxGen - Module-Wide Data Description Section   *  * Include Files:   */  #include	    descrip #include	    stdio #include	    ctype #include	    "IdxDef.H"    /*  * Module Definitions:  */  #define		    TRUE	1  #define		    FALSE	0   /*  * Global Declarations:   */    /*  * Static Declarations:   */    /*  * External References:   */      extern TREE_PTR	root;    /*  * Functions Called:  */    /*+ 0  * Function Idx_Generate - Documentation Section  *  * Discussion:J  *	Generate the output file containing the appropriate LaTeX command lines  *	to generate the index.   *  * Calling Synopsis:/  *	Call Idx_Generate (file, toc_flag, mst_flag)   *
  * Inputs:B  *	file	    ->	is the file descriptor for the current output file.  *			It is a pointer to FILE.   *G  *	toc_flag    ->	is a flag indicating what kind of treatment should be ;  *			applied to for table-of-contents processing.  It is an +  *			integer, passed by value.  Values are: #  *			    IDX_K_NONE	  - Do nothing. 9  *			    IDX_K_ARTICLE - Add a section-oriented toc entry 9  *			    IDX_K_REPORT  - Add a chapter-oriented toc entry   *E  *	mst_flag    ->	is a flag which specifies whether a master index is 8  *			being generated.  Volume labels are printed for the  *			master index.  *  * Outputs:   *	none   *  * Return Value:  *	none   *  * Global Data: $  *	The Index Tree is used read-only.  *  * Files Used:&  *	The current output file is written.  *  * Assumed Entry State: ;  *	The output file pointed to by the file variable is open.   *  * Normal Exit State: !  *	Output is written to the file.   *  * Error Conditions:D  *	Errors are ignored, in the sense that they don't generate output.  *
  * Algorithm: "  *	A. Write pre-amble information.(  *	B. For each item in the primary list,3  *	    1. If the first letter of the entry changed, -  *		a. Output special formatting information. 0  *	    2. Process the information for this item.  *	    3. For each subitem, ,  *		a. Process information for this subitem.  *		b. For each subsubitem, 3  *		    1. Process information for this subsubitem. #  *	C. Write post-amble information.   *  * Special Notes:   *	none  -*/    /*'  * Function Idx_Generate - Code Section   */   , void	idx_generate (file, toc_flag, mst_flag)       FILE	    *file;      int		    toc_flag;     int		    mst_flag; {  /*  * Local Declarations   */      TREE_PTR	    node_1;     TREE_PTR	    node_2;     TREE_PTR	    node_3;     char	    first_letter;         int		    item_count = 0;     int		    subitem_count = 0; "     int		    subsubitem_count = 0;     void	    idx_preamble();     void	    idx_new_group();      void	    idx_write();      void	    idx_postamble();  /*  * Module Body  */     /* Write the pre-amble.							*/   idx_preamble(file, toc_flag);    node_1 = root; first_letter = '+';   , /* For each node of the primary tree,					*/   while (node_1 != 0)      { /     idx_new_group(&first_letter, node_1, file); 1     idx_write (node_1, "\\item", file, mst_flag);      item_count++;      node_2 = node_1->subhead;      while (node_2 != 0)  	{1 	idx_write (node_2, "\\subitem", file, mst_flag);  	subitem_count++;  	node_3 = node_2->subhead; 	while (node_3 != 0) 	    {8 	    idx_write (node_3, "\\subsubitem", file, mst_flag); 	    subsubitem_count++; 	    node_3 = node_3->link;  	    } 	node_2 = node_2->link;  	}     node_1 = node_1->link;     }   - /* Report the total counts of entries.					*/   + printf("\nIndex processing statistics:\n"); / printf("    Items:        %d\n",   item_count); 2 printf("    Subitems:     %d\n",   subitem_count);5 printf("    Subsubitems:  %d\n\n", subsubitem_count);     /* Write the post-amble							*/   idx_postamble(file); }    /*+ 0  * Function Idx_PreAmble - Documentation Section  *  * Discussion:6  *	Write the pre-amble information to the output file.  *  * Calling Synopsis:%  *	Call Idx_PreAmble (file, toc_flag)   *
  * Inputs::  *	file	    ->	is the file descriptor for the output file.  *E  *	toc_flag    ->	is a flag used to indicate what treatment should be 7  *			performed for table-of-contents processing.  It is -  *			an integer passed by value.  Values are: %  *			    IDX_K_NONE     - Do nothing. ;  *			    IDX_K_ARTICLE  - Add a section-oriented toc entry. ;  *			    IDX_K_REPORT   - Add a chapter-oriented toc entry.   *  * Outputs:   *	none   *  * Return Value:  *	none   *  * Global Data:   *	none   *  * Files Used:+  *	The file described by "file" is written.   *  * Assumed Entry State:   *	none   *  * Normal Exit State:   *	none   *  * Error Conditions:  *	none   *
  * Algorithm: "  *	A. Write pre-amble information.  *  * Special Notes:   *	none  -*/    /*'  * Function Idx_PreAmble - Code Section   */   " void	idx_preamble (file, toc_flag)     FILE	    *file;      int		    toc_flag; {  /*  * Local Declarations   */  /*  * Module Body  *  * Define the \indexhead macro: 1  *  \indexhead{BEFORESKIP}{AFTERSKIP}{HEADING} ==   *	BEGIN  *	    \par   *	    IF @nobreak = TRUE   *		THEN \everypar == null"  *		ELSE \addpenalty{\@secpanalty}  *		     \addvspace{BEFORESKIP} 	  *	    FI   *	    \begingroup  *		\sl HEADING\par   *	    \endgroup  *	    \@xsect{AFTERSKIP}   *	END  */   # fprintf (file, "\\makeatletter\n"); P fprintf (file, "\\def\\indexhead#1#2#3{\\par\\if@nobreak \\everypar{}\\else\n");E fprintf (file, "  \\addpenalty{\\@secpenalty}\\addvspace{#1}\\fi\n"); P fprintf (file, "  \\begingroup \\large\\bf \\hfil #3 \\hfil\\par \\endgroup\n");$ fprintf (file, "  \\@xsect{#2}}\n");" fprintf (file, "\\makeatother\n");   /*!  * Define the \indexindent macro:   *  \indexindent == '  *	\par \hangindent 50pt \hspace*{40pt}   */   N fprintf (file, "\\def\\indexindent{\\par\\hangindent 50pt\\hspace*{40pt}}\n");   /* Start the index							*/   4 fprintf (file, "\\begin{theindex} \\raggedright\n");  # if (toc_flag == IDX_K_NONE)	return;    if (toc_flag == IDX_K_ARTICLE)O     fprintf (file,"\\addcontentsline{toc}{section}{Index}\\typeout{Index.}\n");    if (toc_flag == IDX_K_REPORT) O     fprintf (file,"\\addcontentsline{toc}{chapter}{Index}\\typeout{Index.}\n");   D printf("\nA Table of Contents entry will be made for the Index.\n"); }    /*+ 1  * Function Idx_New_Group - Documentation Section   *  * Discussion:E  *	Handle special processing at the boundaries between index entries  &  *	which begin with different letters.  *  * Calling Synopsis:-  *	Call Idx_New_Group (test_char, node, file)   *
  * Inputs:A  *	test_char	    ->	is the character which is the first character 0  *				of the current group. Passed by reference.  *5  *	node		    ->	is the TREE_PTR for the current node.   *6  *	file		    ->	is a file pointer for the output file.  *  * Outputs: B  *	test_char	    ->	if a new group is declared, the test character  *				is updated.   *  * Return Value:  *	none   *  * Global Data:   *	The Index Tree is read.  *  * Files Used:F  *	If a new group is declared, records are written to the output file.  *  * Assumed Entry State:   *	none   *  * Normal Exit State:   *	none   *  * Error Conditions:  *	none   *
  * Algorithm: D  *	A. Current_Char is the first character of the Spell String of theF  *	   current node, or a space if the first character is not a letter.#  *	B. If Current_Char != Test_Char,   *	    1. Generate commands.#  *	    2. Test_Char = Current_Char.   *  * Special Notes:   *	none  -*/    /*(  * Function Idx_New_Group - Code Section  */   * void	idx_new_group (test_char, node, file)       char	    *test_char;     TREE_PTR	    node;     FILE	    *file;  {  /*  * Local Declarations   */       char	    current_char = ' '; /*  * Module Body  */   P if (node->spell.dsc$w_length > 0)   current_char = node->spell.dsc$a_pointer[0];7 if (isalpha(current_char) == 0)	    current_char = ' '; & current_char = _toupper(current_char);   if (*test_char != current_char)      {      if (current_char == ' ')< 	fprintf (file, "\\indexhead{2em}{1em}{--- Symbols ---}\n");     elseE 	fprintf (file, "\\indexhead{2em}{1em}{--- %c ---}\n", current_char);      *test_char = current_char;     }  }    /*+ -  * Function Idx_Write - Documentation Section   *  * Discussion:3  *	Write the basic text line for the current entry.   *  * Calling Synopsis:3  *	Call Idx_Write (node, intro_str, file, mst_flag)   *
  * Inputs:A  *	node	    ->	TREE_PTR of the node whose data is to be reported.   *E  *	intro_str   ->	introductory character string, ASCIZ passed by ref.   *,  *	file	    ->	file pointer for output file.  *F  *	mst_flag    ->	flag indicates if a master index is being generated.  *  * Outputs:   *	none   *  * Return Value:  *	none   *  * Global Data:   *	none   *  * Files Used:  *	The output file is written.  *  * Assumed Entry State:   *	none   *  * Normal Exit State:   *	none   *  * Error Conditions:  *	none   *
  * Algorithm: >  *	A. Print the first part of the string, containing the item.5  *	B. If there is at least one page number specified, E  *	    1. Print the first page number (which is formatted specially). )  *	    2. For all remaining page numbers,   *		a. Print them.9  *	C. If there is at least one cross reference specified, -  *	    1. Print the "see" or "see also" line. #  *	    2. For all cross references,   *		a. Print them.!  *	D. Print the record trailer. *   *  * Special Notes: C  *	When printing page numbers, allow for page-no highlighting.  The F  *	highlight code is specified in the pgnode list element.  Recognized  *	values are:'  *	    IDX_K_NONE	    - No highlighting 2  *	    IDX_K_UNDERLINE - Underline the page number2  *	    IDX_K_ITALIC    - Italicize the page number0  *	    IDX_K_BOLD	    - Boldface the page number3  *	    IDX_K_FOLLOW    - ff follows the page number  -*/    /*$  * Function Idx_Write - Code Section  */   0 void	idx_write (node, intro_str, file, mst_flag)       TREE_PTR	    node;     char	    *intro_str;     FILE	    *file;      int		    mst_flag; {  /*  * Local Declarations   */      char		    string[256];     int			    length;      PGNODE_PTR		    pgnode;      int			    highlight;%     struct dsc$descriptor   *old_vol;  /*  * Module Body  */   H length = sprintf (string, "%s{%.*s", intro_str, node->item.dsc$w_length,$ 						    node->item.dsc$a_pointer);   if (node->pghead != 0)     {      idx_build_range(node);     pgnode = node->pghead;       if (mst_flag)  	{% 	length += sprintf (&string[length],  / 	    "}\\indexindent{$\\bullet$ {\\sl %.*s}, ", < 	    pgnode->vol->dsc$w_length, pgnode->vol->dsc$a_pointer); 	old_vol = pgnode->vol;  	}     else+ 	length += sprintf (&string[length], ", ");   "     highlight = pgnode->highlight;     switch (highlight) 	{ 	case IDX_K_UNDERLINE : ) 	    length += sprintf (&string[length],  B 		"\\mbox{\\rm\\underline{%.*s}}", pgnode->page_dsc.dsc$w_length, " 		pgnode->page_dsc.dsc$a_pointer); 	    break;  	case IDX_K_ITALIC :> 	    length += sprintf (&string[length], "\\mbox{\\em %.*s}", A 		pgnode->page_dsc.dsc$w_length, pgnode->page_dsc.dsc$a_pointer);  	    break;  	case IDX_K_BOLD :> 	    length += sprintf (&string[length], "\\mbox{\\bf %.*s}", A 		pgnode->page_dsc.dsc$w_length, pgnode->page_dsc.dsc$a_pointer);  	    break;  	case IDX_K_FOLLOW :D 	    length += sprintf (&string[length], "\\mbox{\\rm %.*s\\sf ff}",A 		pgnode->page_dsc.dsc$w_length, pgnode->page_dsc.dsc$a_pointer);  	    break; 
 	default :> 	    length += sprintf (&string[length], "\\mbox{\\rm %.*s}", A 		pgnode->page_dsc.dsc$w_length, pgnode->page_dsc.dsc$a_pointer);  	    break;  	}  (     while ((pgnode = pgnode->link) != 0) 	{ 	if (length > 62)  	    {& 	    fprintf (file, "%s%%\n", string); 	    length = 0; 	    }   	if (mst_flag) 	    {  	    if (old_vol != pgnode->vol) 		{ & 		length += sprintf (&string[length], / 		    "}\\indexindent{$\\bullet$ {\\sl %.*s} ", = 		    pgnode->vol->dsc$w_length, pgnode->vol->dsc$a_pointer);  		old_vol = pgnode->vol; 		} 	 	    else , 		length += sprintf (&string[length], ", "); 	    } 	else / 	    length += sprintf (&string[length], ", ");    	highlight = pgnode->highlight;  	switch (highlight)  	    { 	    case IDX_K_UNDERLINE : & 		length += sprintf (&string[length], ' 		    "\\mbox{\\rm\\underline{%.*s}}",  % 		    pgnode->page_dsc.dsc$w_length,  0 		    pgnode->page_dsc.dsc$a_pointer);    break; 	    case IDX_K_ITALIC :; 		length += sprintf (&string[length], "\\mbox{\\em %.*s}",  % 		    pgnode->page_dsc.dsc$w_length,  0 		    pgnode->page_dsc.dsc$a_pointer);    break; 	    case IDX_K_BOLD :; 		length += sprintf (&string[length], "\\mbox{\\bf %.*s}",  % 		    pgnode->page_dsc.dsc$w_length,  0 		    pgnode->page_dsc.dsc$a_pointer);    break; 	    case IDX_K_FOLLOW :A 		length += sprintf (&string[length], "\\mbox{\\rm %.*s\\sf ff}", % 		    pgnode->page_dsc.dsc$w_length,  0 		    pgnode->page_dsc.dsc$a_pointer);    break; 	    default :; 		length += sprintf (&string[length], "\\mbox{\\rm %.*s}",  % 		    pgnode->page_dsc.dsc$w_length,  0 		    pgnode->page_dsc.dsc$a_pointer);    break; 	    } 	}     }    if (node->seehead != 0)      {      pgnode = node->seehead;        if (mst_flag)  	{ 	if (node->pghead == 0) ; 	    fprintf (file, "%s}\n\\indexindent{\\em see", string);  	else @ 	    fprintf (file, "%s}\n\\indexindent{\\em see also", string); 	}     else 	{ 	if (node->pghead == 0) 0 	    fprintf (file, "%s, {\\em see}\n", string); 	else 5 	    fprintf (file, "%s; {\\em see also}\n", string);  	}     length = 0;        while (pgnode != 0)  	{ 	if (length > 62)  	    {& 	    fprintf (file, "%s%%\n", string); 	    length = 0; 	    } 	highlight = pgnode->highlight;  	switch(highlight) 	    { 	    case IDX_K_UNDERLINE : % 		length += sprintf (&string[length], ; 		    "}\\indexindent{\\ $\\bullet$ \\rm\\underline{%.*s}", $ 		    pgnode->page_dsc.dsc$w_length,- 		    pgnode->page_dsc.dsc$a_pointer);	break;    	    case IDX_K_ITALIC :% 		length += sprintf (&string[length], 1 		    "}\\indexindent{\\ $\\bullet$ {\\em %.*s}", $ 		    pgnode->page_dsc.dsc$w_length,- 		    pgnode->page_dsc.dsc$a_pointer);	break;    	    case IDX_K_BOLD :% 		length += sprintf (&string[length], 1 		    "}\\indexindent{\\ $\\bullet$ {\\bf %.*s}", $ 		    pgnode->page_dsc.dsc$w_length,- 		    pgnode->page_dsc.dsc$a_pointer);	break;* * 	    default :% 		length += sprintf (&string[length], 1 		    "}\\indexindent{\\ $\\bullet$ {\\rm %.*s}",T$ 		    pgnode->page_dsc.dsc$w_length,- 		    pgnode->page_dsc.dsc$a_pointer);	break;n 	    } 	pgnode=pgnode->link;s 	}     }a  fprintf (file, "%s}\n", string); }l n /*+h1  * Function Idx_PostAmble - Documentation Sectionm  *  * Discussion:6  *	Write the lines which occur at the end of the file.  *  * Calling Synopsis:  *	Call Idx_PostAmble (file);*  *
  * Inputs:7  *	file	    ->	is the file pointer for the output file.*  *  * Outputs:r  *	none   *  * Return Value:  *	nonef  *  * Global Data:s  *	noneo  *  * Files Used:  *	Output file is written.  *  * Assumed Entry State:   *	none   *  * Normal Exit State:   *	none   *  * Error Conditions:  *	none   *
  * Algorithm:   *	A. Write the end-matter.*  *  * Special Notes:*  *	none* -*/* * /*(  * Function Idx_PostAmble - Code Section  */e   void	idx_postamble (file)A       FILE	*file;o {  /*  * Local Declarationst  */    /*  * Module Body  */s  $ fprintf (file, "\\end{theindex}\n"); }*