 #module    IdxMaster    "1-002"  /*H  ***********************************************************************H  *                                                                     *H  * The software was developed at the Monsanto Company and is provided  *H  * "as-is".  Monsanto Company and the auther disclaim all warranties   *H  * on the software, including without limitation, all implied warran-  *H  * ties of merchantabilitiy and fitness.                               *H  *                                                                     *H  * This software does not contain any technical data or information    *H  * that is proprietary in nature.  It may be copied, modified, and     *H  * distributed on a non-profit basis and with the inclusion of this    *H  * notice.                                                             *H  *                                                                     *H  ***********************************************************************  */    /*+   * Module Name:	IdxMaster   *5  * Author:	R L Aurbach	CR&DS MIS Group    09-Apr-1987   *  * Function:&  *	File processing routines for IdxTex  *  * Modification History:  *,  * Version     Initials	   Date		DescriptionK  * ------------------------------------------------------------------------ &  * 1-001	RLA	09-Apr-1987	Original Code:  * 1-002	RLA	15-Apr-1987	Add support for cross-referencing -*/    /*:  * Module IdxMaster - Module-Wide Data Description Section  *  * Include Files:   */  #include	descrip #include	stdio #include	"IdxDef.H"    /*  * Module Definitions:  */  #define		TRUE	    1  #define		FALSE	    0  < #define		linebfsize  133		/* Maximum line buffer size	    */   /*  * Global Declarations:   */    /*  * Static Declarations:   */ P     static struct dsc$descriptor str_dyn = {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};   /*  * External References:   */    /*  * Functions Called:  */    /*+ 4  * Function Idx_Process_File - Documentation Section  *  * Discussion:?  *	Process an input file, building the internal tree structure.   *  * Calling Synopsis:(  *	call Idx_Process_File (filename, vol)  *
  * Inputs:I  *	filename    ->	is a character string containing the file specification !  *			of the file to be processed.   *C  *	vol	    ->	is a pointer to a character string descriptor for the <  *			volume name string of this volume.  Used for processing  *			master indices.  *  * Outputs:   *	none   *  * Return Value:  *	none   *  * Global Data:   *	none   *  * Files Used:$  *	The specified input file is read.  *  * Assumed Entry State:   *	none   *  * Normal Exit State:   *	none   *  * Error Conditions:3  *	If the file does not exist, the file is ignored.   *
  * Algorithm:   *	A. Open the file."  *	B. For all records in the file,  *	    1. Read the next record. 9  *	    2. Call Idx_Parse to parse the record into tokens. K  *	    3. Call Idx_Build_Tree to enter the information into the Index Tree.   *	C. Close the file.   *  * Special Notes:   *	none  -*/    /*+  * Function Idx_Process_File - Code Section   */   $ int	idx_process_file (filename, vol)  /     char		    *filename;	/* Filename string		*/ =     struct dsc$descriptor   *vol;	/* Volume string pointer	*/  {  /*  * Local Declarations   */ ,     FILE		    *file;		    /* File pointer	*/;     char		    linebf[linebfsize];	    /* I/O line buffer	*/ 4     char		    tok_1[linebfsize];	    /* 1st token	*/4     char		    tok_2[linebfsize];	    /* 2nd token	*/4     char		    tok_3[linebfsize];	    /* 3rd token	*/:     char		    pg_no[linebfsize];	    /* Page number ref	*/,     int			    tok_ct;		    /* Token count	*/(     int			    flag;		    /* Xref flag	*/ /*  * Module Body  */   C if ((file = fopen(filename, "r", "dna = sys$disk:[].idx")) == NULL)      { G     printf("Could not open input file %s -- File ignored\n", filename);      return;      } , while (fgets(linebf, linebfsize, file) != 0)     { C     idx_parse (linebf, tok_1, tok_2, tok_3, pg_no, &tok_ct, &flag); C     idx_build_tree (tok_1, tok_2, tok_3, pg_no, tok_ct, vol, flag);      } 
 fclose(file);  }    /*+ 4  * Function Idx_Parse_Master - Documentation Section  *  * Discussion:E  *	Parse a line of the Master Index file and return a flag indicating +  *	whether a valid line of input was found.   *  * Calling Synopsis:5  *	ok = Idx_Parse_Master (linebf, filename, vol_ptr);   *
  * Inputs:E  *	linebf	    ->	is the input line buffer, passed as an ASCIZ string.   *  * Outputs: C  *	filename    ->	is the file specification of the input file to be *  *			processed, passed as an ASCIZ string.  *E  *	vol_ptr	    ->	is a pointer to a character string descriptor which :  *			describes the label associated with this file, passed  *			by reference.  *  * Return Value:  *	ok	    ->	is a boolean flag  *  * Global Data:   *	none   *  * Files Used:G  *	In practice, the source of the input linebf is a file.  However, the #  *	routine does no file I/O itself.   *  * Assumed Entry State:   *	none   *  * Normal Exit State: .  *	ok = TRUE	A valid line was seen and parsed.C  *	ok = FALSE	The line was not valid -- it is treated as a comment.   *  * Error Conditions:  *	none   *
  * Algorithm: ?  *	A. Verify that the line has the form "\usefile{label}{file}" )  *	B. Parse "label" as the volume string. #  *	C. Parse "file" as the filename.   *  * Special Notes:   *	none  -*/    /*+  * Function Idx_Parse_Master - Code Section   */   0 int	idx_parse_master (linebf, filename, vol_ptr)  /     char			*linebf;	/* Input line buffer	    */ /     char			*filename;	/* Filename string	    */ C     struct dsc$descriptor	**vol_ptr;	/* Volume string pointer    */  {  /*  * Local Declarations   */ -     int				i;		/* Start of String index    */ +     int				len;		/* Length of string	    */ 0     int				next;		/* next substring index	    */   /*  * Module Body  */   : if (strncmp(linebf, "\\usefile{", 9) != 0)	return (FALSE);  @ *vol_ptr = (struct dsc$descriptor *) malloc (sizeof(**vol_ptr));% if (*vol_ptr == 0)				return (FALSE);  **vol_ptr = str_dyn;   i = 8;% next = idx_extract(linebf, &i, &len); 4 if (len > 0)	str$copy_r(*vol_ptr, &len, &linebf[i]);  	 i = next; % next = idx_extract(linebf, &i, &len); ! if (len == 0)					return (FALSE); $ strncpy (filename, &linebf[i], len); filename[len] = '\0';  return (TRUE); } 