 #module    IdxParse    "2-004" /*H  ***********************************************************************H  *                                                                     *H  * The software was developed at the Monsanto Company and is provided  *H  * "as-is".  Monsanto Company and the auther disclaim all warranties   *H  * on the software, including without limitation, all implied warran-  *H  * ties of merchantabilitiy and fitness.                               *H  *                                                                     *H  * This software does not contain any technical data or information    *H  * that is proprietary in nature.  It may be copied, modified, and     *H  * distributed on a non-profit basis and with the inclusion of this    *H  * notice.                                                             *H  *                                                                     *H  ***********************************************************************  */    /*+   * Module Name:	IdxParse  *5  * Author:	R L Aurbach	CR&DS MIS Group    26-Apr-1986   *  * Function:J  *	Parse an input line produced by LaTeX \index command into a form usable,  *	for the generation of an automatic index.  *  * Modification History:  *,  * Version     Initials	   Date		DescriptionK  * ------------------------------------------------------------------------ &  * 1-001	RLA	26-Apr-1986	Original CodeA  * 2-002	RLA	10-Apr-1987	Add support for the Idx_Extract routine. :  * 2-003	RLA	15-Apr-1987	Add support for cross-referencing?  * 2-004	RLA	20-Apr-1987	Change the cross reference symbol to &  -*/    /*9  * Module IdxParse - Module-Wide Data Description Section   *  * Include Files:   */  #include	    descrip #include	    stdio #include	    "IdxDef.H"    /*  * Module Definitions:  */  #define		    TRUE	1  #define		    FALSE	0   /*  * Global Declarations:   */    /*  * Static Declarations:   */    /*  * External References:   */    /*  * Functions Called:  */    /*+ -  * Function Idx_Parse - Documentation Section   *  * Discussion:3  *	Parse an input line which is of the general form 4  *	    \indexentry{token_1>token_2>token_3}{page_no}B  *	into tokens for "token_1", "token_2", "token_3", and "page_no".?  *	Handle missing tokens and allow for imbedded LaTeX commands.   *  * Calling Synopsis:I  *	Call Idx_Parse (linebf, token_1, token_2, token_3, page_no, token_ct,    *									flag)  *
  * Inputs:D  *	linebf	    ->	is the input string containing the line to parse.  &  *			ASCIZ string passed by reference.  *  * Outputs: 3  *	token_1	    ->	is the first token seen (if any). &  *			ASCIZ string passed by reference.  *4  *	token_2	    ->	is the second token seen (if any).&  *			ASCIZ string passed by reference.  *3  *	token_3	    ->	is the third token seen (if any). &  *			ASCIZ string passed by reference.  *F  *	page_no	    ->	is the page number token (should always be present).%  *			ASCIZ string passed by refernce.   */  *	token_ct    ->	is the number of tokens seen. !  *			Integer passed by reference.   *D  *	flag	    ->	indicates if the page reference is a cross-reference.!  *			Boolean passed by reference.   *  * Return Value:  *	none   *  * Global Data:   *	none   *  * Files Used:  *	none   *  * Assumed Entry State:   *	none   *  * Normal Exit State: %  *	returns with the record processed.   *  * Error Conditions:  *	none     *
  * Algorithm:   *	A. Initialize variables. 3  *	B. Verify that the line begins with \indexentry. '  *	C. Extract the index item substring.   *	D. Parse it into tokens. +  *	E. Extract the page reference substring.   *  * Special Notes:   *	This logic is designed to: E  *	    * copy sequences such as \{, \}, and $>$ from the input stream B  *	      into tokens without recognizing them as token delimiters.H  *	    * allow sequences such as {\bf text} in token without recognizing.  *	      the special characters as delimiters.D  *	    * allow up to three levels of index and one level of page-no,A  *	      ignoring all other characters (which shouldn't exist...)  -*/    /*$  * Function Idx_Parse - Code Section  */   K void	idx_parse (linebf, token_1, token_2, token_3, page_no, token_ct, flag)   5     char	*linebf;	    /* Input string to be parsed	*/ 0     char	*token_1;	    /* First token string		*/1     char	*token_2;	    /* Second token string		*/ 0     char	*token_3;	    /* Third token string		*/6     char	*page_no;	    /* Page number token string		*/8     int		*token_ct;	    /* Number of item tokens seen	*/0     int		*flag;		    /* Cross-Reference flag		*/ {  /*  * Local Declarations   */ '     int		i;		    /* linebf counter			*/ 5     int		next;		    /* beginning of next substring	*/ -     int		len;		    /* length of substring		*/ 3     int		math_mode = FALSE;  /* math-mode flag			*/ 2     char	*ptr;		    /* pointer to token buffer		*/3     int		index;		    /* index into token buffer		*/ +     int		end;		    /* end of substring			*/  /*  * Module Body  */   3 /* Initialize assorted variables, flags, etc.				*/    token_1[0] = '\0'; token_2[0] = '\0'; token_3[0] = '\0'; page_no[0] = '\0'; *token_ct  = 0;  *flag	   = FALSE;    ptr = token_1;
 index = 0;  : /* Verify that the string begins with \indexentry			    */  : if (strncmp(linebf, "\\indexentry{", 12) != 0)	    return;  * /* Locate the first substring.						    */   i = 11; % next = idx_extract(linebf, &i, &len);  if (len == 0)					    return;  *token_ct = 1; end = i + len;  E /* For all characters in the substring, parse out the tokens.		    */    for ( ; i < end; i++)      {      switch (linebf[i]) 	{% 	case '$' :  if (linebf[i-1] != '\\')  			{% 			if (math_mode)  math_mode = FALSE;  			else		math_mode = TRUE; 			} 		    ptr[index++] = linebf[i];  		    break;  6 	case '>' :  if (math_mode)  ptr[index++] = linebf[i];
 		    else 			{ 			if (index == 0)	break;  			ptr[index] = '\0'; 
 			index = 0;  			switch (*token_ct)  			    {5 			    case 1 :	ptr = token_2;  *token_ct = 2; break; 5 			    case 2 :	ptr = token_3;  *token_ct = 3; break;  			    } 			} 		    break;  % 	case '&' :  if (linebf[i-1] == '\\')  			{ 			ptr[index++] = linebf[i];	 			break;  			} 		    ptr[index] = '\0';/ 		    sprintf(page_no, "\\indexentry{%.*s}{}",   						    end-i, &linebf[++i]);  		    *flag = TRUE; 
 		    return;   - 	default :   ptr[index++] = linebf[i]; break;  	}     }  ptr[index] = '\0';  F /* Now parse the second substring and copy it to the page-ref.		    */  	 i = next; % next = idx_extract(linebf, &i, &len); # strncpy (page_no, &linebf[i], len);  page_no[len] = '\0'; }    /*+ /  * Function Idx_Extract - Documentation Section   *  * Discussion:J  *	Extract a string contained within a {} pair, which may contain imbedded  *	LaTeX commands.  *  * Calling Synopsis:-  *	next = Idx_Extract (string, start, length)   *
  * Inputs:F  *	string	    ->	is an ASCIZ string containing a substring enclosed in  *			matching braces ({}).  *A  *	start	    ->	is the string index of the first character of the 7  *			string to be searched.  It is passed by reference.   *  * Outputs: A  *	start	    ->	is the string index of the first character of the $  *			substring, passed by reference.  *H  *	length	    ->	is the number of characters in the substring, passed by  *			reference.   *  * Return Value:C  *	next	    ->	is the string index of the first character after the :  *			'}' which terminates the substring.  If the substring:  *			is not terminated by '}', next is the string index of  *			the '\0' character.  *  * Global Data:   *	none   *  * Files Used:  *	none   *  * Assumed Entry State:   *	none   *  * Normal Exit State:   *	none   *  * Error Conditions:  *	none     *
  * Algorithm: (  *	A. Scan the string for the first '{'.2  *	B. For all succeeding characters in the string,:  *	    1. If the character is '{' (not preceeded by '\\'),!  *		a. Increment the brace count. :  *	    2. If the character is '}' (not preceeded by '\\'),!  *		a. Decrement the brace count.   *		b. If the brace count = 0,8  *		    1. Return the start and length of the substring.  *  * Special Notes:   *	none  -*/    /*&  * Function Idx_Extract - Code Section  */   ' int	idx_extract (string, start, length)        char	    *string;      int		    *start;     int		    *length;  {  /*  * Local Declarations   */ )     int		    i;		    /* string index			*/ 0     int		    brace_ct = 0;   /* brace count			*/ /*  * Module Body  */    /*K  * Scan the string for the first occurrence of a '{' character which is not G  * preceeded by a '\\'.  The next character marks the beginning of the    * substring to be extracted.   */   ( for (i = *start; string[i] != '\0'; i++)     { '     if (string[i] != '{')	    continue;      if (i > 0) 	{& 	if (string[i-1] == '\\')    continue; 	}     *start = i + 1;      brace_ct++; 
     break;     }    /*G  * If brace_ct == 0, no leading { was found.  This is an error.  Return /  * start = next = end-of-string and length = 0.   */    if (brace_ct == 0)     {      *start = sizeof(string);     *length = 0;     return (sizeof(string));     }    /**  * Now search the string for a matching }.  */   ( for (i = *start; string[i] != '\0'; i++)     { D     if ((string[i] == '{') && (string[i-1] != '\\'))	    brace_ct++;4     if ((string[i] == '}') && (string[i-1] != '\\')) 	{ 	brace_ct--; 	if (brace_ct == 0)  	    { 	    *length = i - *start; 	    return (i + 1); 	    } 	}     }    /*H  * If we get here, no closing } was found.  Treat the end of string as a  * matching }.  */   " *length = sizeof(string) - *start; return (sizeof(string)); } 