 #module    IdxRange    "1-002" /*H  ***********************************************************************H  *                                                                     *H  * The software was developed at the Monsanto Company and is provided  *H  * "as-is".  Monsanto Company and the auther disclaim all warranties   *H  * on the software, including without limitation, all implied warran-  *H  * ties of merchantabilitiy and fitness.                               *H  *                                                                     *H  * This software does not contain any technical data or information    *H  * that is proprietary in nature.  It may be copied, modified, and     *H  * distributed on a non-profit basis and with the inclusion of this    *H  * notice.                                                             *H  *                                                                     *H  ***********************************************************************  */    /*+   * Module Name:	IdxRange  *5  * Author:	R L Aurbach	CR&DS MIS Group    07-Apr-1987   *  * Function:A  *	Examine the list of page references to build range references.   *  * Modification History:  *,  * Version     Initials	   Date		DescriptionK  * ------------------------------------------------------------------------ &  * 1-001	RLA	07-Apr-1987	Original Code<  * 1-002	RLA	14-Apr-1987	Fix algorithm for processing ranges"  *					  which contain highlights. -*/    /*9  * Module IdxRange - Module-Wide Data Description Section   *  * Include Files:   */  #include	descrip #include	"IdxDef.H"  /*  * Module Definitions:  */ + #define		IDX_K_START	1	/* Start of range	*/ - #define		IDX_K_MIDDLE	2	/* Middle of range	*/ ( #define		IDX_K_END	3	/* End of range		*/- #define		IDX_K_SIMPLE	0	/* Simple page-ref	*/ / #define		IDX_K_COMPLEX	1	/* Complex page-ref	*/    #define		TRUE	    1  #define		FALSE	    0   typedef struct     { 9     struct dsc$descriptor   *vol;	/* Volume string ptr	*/ ;     struct dsc$descriptor   page_dsc;	/* Page-ref string	*/ -     char		    highlight;	/* Highlight flag	*/ ,     char		    adjacent;	/* Adjacency flag	*/)     char		    flag;	/* Range type flag	*/ ,     char		    type;	/* Page-ref type flag	*/)     int			    start;	/* Start of range	*/      } TABLE, *TABLE_PTR; typedef struct     { 9     struct dsc$descriptor   *vol;	/* Volume string ptr	*/ 9     struct dsc$descriptor   chapter;	/* Chapter string	*/ &     int			    page;	/* Page number		*/,     char		    type;	/* Page-ref type flag	*/     } CMP, *CMP_PTR; /*  * Global Declarations:   */    /*  * Static Declarations:   */ P     static struct dsc$descriptor str_dyn = {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};'     static $DESCRIPTOR	    (dash,	"-"); *     static $DESCRIPTOR	    (simple,	"--");-     static $DESCRIPTOR	    (complex,	" to ");  /*  * External References:   */    /*  * Functions Called:  */    /*+ 3  * Function Idx_Build_Range - Documentation Section   *  * Discussion:E  *	Examine a list of page references.  If the list contains any pages F  *	which are in consecutive order, build a new list of page references2  *	which contain one or more range specifications.  *  * Calling Synopsis:  *	Call Idx_Build_Range (node)  *
  * Inputs:<  *	node	    ->	pointer to the current node of the item tree.  *  * Outputs: <  *	none	    ->	pointer to the current node of the item tree.  *  * Return Value:  *	none   *  * Global Data:   *	none   *  * Files Used:  *	none   *  * Assumed Entry State:   *	none   *  * Normal Exit State:   *	none   *  * Error Conditions:  *	none     *
  * Algorithm: >  *	A. Count the number of page references in the current list.1  *	    1. If less than 2, there is nothing to do. G  *	B. Allocate a TABLE structure big enough to hold all the references.   *	C. For each reference, "  *	    1. Fill in the TABLE entry.G  *	    2. Call Idx_Page_Parse to parse the page reference and place the D  *	       results of the parse operation in the "new" CMP structure.F  *	    3. Call Idx_Is_Adjacent to compare the information in the "old"E  *	       and "new" CMP structures to determine if the page number is '  *	       adjacent to the previous one.   *	    4. If it is, 0  *		a. Set the adjacent flag in the TABLE entry.#  *		b. Set the "ranges_found" flag.   *	D. If no ranges were found,  *	    1. Deallocate the TABLE.   *	    2. Return.   *	E. Else, D  *	    1. Process the TABLE to set up the "flag" and "start" fields.E  *	    2. Call Idx_Deallocate_PgList to deallocate the old page-refs. D  *	    3. Call Idx_Build_New_PgList to allocate a new page-ref list.  *	    4. Deallocate the TABLE.   *  * Special Notes:   *	none  -*/    /**  * Function Idx_Build_Range - Code Section  */    int	idx_build_range (node)  -     TREE_PTR		node;		/* Current tree node		*/  {  /*  * Local Declarations   */ 1     PGNODE_PTR		pgnode;		/* Current page node		*/ 1     int			ref_ct = 0;	/* Number of page nodes		*/ 4     TABLE_PTR		table;		/* Local structure pointer	*/7     int			ranges_found = FALSE;	/* Ranges found flag	*/ /     CMP			old;		/* Parse struct for prev ref	*/ /     CMP			new;		/* Parse struct for curr ref	*/ $     int			i, j;		/* Table index			*/C     struct dsc$descriptor   temp;	/* Temporary string descriptor	*/  /*  * Module Body  */    /*A  * Count the number of page references for the current tree node. N  * If there are less than 2, there is nothing to do -- no ranges are possible.  */    pgnode = node->pghead; while (pgnode != 0)      { 
     ref_ct++;      pgnode = pgnode->link;     }  if (ref_ct < 2)	    return;    /*K  * Allocate an internal data table sufficiently large to contain all of the #  * existing page reference entries.   */   4 table = (TABLE_PTR) malloc (ref_ct * sizeof(TABLE)); if (table == 0)	    return;    /*B  * Initialize the previous page reference parse structure to null.  */    old.vol	    = 0; old.chapter = str_dyn; old.page    = 0; old.type    = IDX_K_SIMPLE;    pgnode	    = node->pghead;   /*H  * For each page reference in the page reference list, we must build theF  * appropriate entry in the internal data table.  To do this, we first1  * initialize the entry using the available data.   */    for (i = 0; i < ref_ct; i++)     { %     table[i].vol       = pgnode->vol; *     table[i].page_dsc  = pgnode->page_dsc;+     table[i].highlight = pgnode->highlight;      table[i].adjacent  = FALSE; $     table[i].flag      = IDX_K_NONE;&     table[i].type      = IDX_K_SIMPLE;     table[i].start     = 0; !     pgnode	       = pgnode->link;    /*H  * Now we parse the page descriptor and fill out the data structure usedI  * for comparison and compare it against the previous page reference.  If N  * the pages are consecutive, we flag the table entry and set the ranges_foundL  * flag.  Finally, we copy the new structure to the old structure to prepare  * for the next iteration.  */   %     idx_page_parse (&table[i], &new); %     if (idx_is_adjacent (&new, &old))  	{ 	table[i].adjacent = TRUE; 	ranges_found = TRUE;  	}       str$free1_dx(&old.chapter);      old = new;     }    /*H  * Since we are now done with the "old" and "new" structures, deallocateB  * the dynamic strings they reference.  (So that we don't forget).  */   < str$free1_dx(&old.chapter);	    /* Just once, please!	    */   /*L  * If we haven't found any ranges, then all of this analysis was for nought.H  * We just deallocate the table and leave, with the initial list intact.  */    if (!ranges_found)     {      free(&table);      return;      }    /*K  * At this point, we know we have found at least one range, so we have work M  * to do.  First, we need to process the table so that the "flag" and "start"   * fields are set up correctly.   */    for (i = 1; i < ref_ct; i++)     {  /*M  * If the current entry is part of a range and has the FOLLOW highlight, then D  * make sure that every element of the range has the same highlight.  */ @     if (table[i].adjacent && table[i].highlight == IDX_K_FOLLOW) 	{I 	if (table[i-1].flag == IDX_K_NONE)  table[i-1].highlight = IDX_K_FOLLOW;  	else + 	    for (j = table[i-1].start; j < i; j++) $ 		table[j].highlight = IDX_K_FOLLOW; 	} /*O  * If the current entry is part of a range which has the FOLLOW highlight, then &  * it should have that highlight also.  */ B     if (table[i].adjacent && table[i-1].highlight == IDX_K_FOLLOW)# 	table[i].highlight = IDX_K_FOLLOW;  /*J  * If the current entry is part of a range, then update the flag and start  * values in the table.   */ J     if (table[i].adjacent && (table[i].highlight == table[i-1].highlight)) 	{# 	if (table[i-1].flag == IDX_K_NONE)  	    {$ 	    table[i-1].flag  = IDX_K_START; 	    table[i-1].start = i-1; 	    }! 	table[i].flag    = IDX_K_MIDDLE; % 	table[i].start   = table[i-1].start;  	} /*M  * If the entry is not part of a range, then if the preceeding entry was part 9  * of a range, it was the end of that range.  Mark it so.   */      else 	{E 	if (table[i-1].flag == IDX_K_MIDDLE)    table[i-1].flag = IDX_K_END;  	}     }  /*O  * If the last entry in the table was part of a range, it hasn't been correctly #  * marked that way yet.  Do so now.   */   ) if (table[ref_ct-1].flag == IDX_K_MIDDLE) %     table[ref_ct-1].flag = IDX_K_END;    /*K  * At this point, we know we are going to create a new page-ref list, so we M  * can deallocate the old list.  Note that we don't need to free any strings, 6  * because they are all contained in the data table...  */    idx_deallocate_pglist (node);    /*J  * Now we use the information in the table to build the new page-ref list.  */   + idx_build_new_pglist (node, table, ref_ct);    /*I  * We are done.  To clean up correctly, we must deallocate the table.  To K  * do this, we first deallocate any strings which are defined in the table, H  * then deallocate the table.  This should clean up virtual memory usage
  * nicely.  */   > for (i = 0; i < ref_ct; i++)	str$free1_dx(&table[i].page_dsc); free (&table); }    /*+ 2  * Function Idx_Page_Parse - Documentation Section  *  * Discussion:0  *	Parse a page number into its component parts.  *  * Calling Synopsis:"  *	call Idx_Page_Parse (elem, cmp)  *
  * Inputs:?  *	elem	    ->	is an element of the table array, describing the 8  *			current page reference.  It is passed by reference.  *  * Outputs: ?  *	elem	    ->	is an element of the table array, describing the 8  *			current page reference.  It is passed by reference.   *			The "type" flag is updated.  *B  *	cmp	    ->	is the comparison data structure into which the data8  *			for this page reference is parsed.  It is passed by  *			reference.   *  * Return Value:  *	none   *  * Global Data:   *	none   *  * Files Used:  *	none   *  * Assumed Entry State:   *	none   *  * Normal Exit State:   *	none   *  * Error Conditions:  *	none   *
  * Algorithm: +  *	A. Initialize the output data structure. )  *	B. If the input string contains a '-', E  *	    1. Copy the characters prior to the '-' to the chapter string. <  *	    2. Set the flags to mark this page number as complex.  *	C. Skip over any '-'s. 3  *	D. Convert the rest of the string to an integer.   *  * Special Notes:   *	none  -*/    /*)  * Function Idx_Page_Parse - Code Section   */    int	idx_page_parse (elem, cmp)  4     TABLE_PTR		elem;		/* Pointer to a table entry	*/3     CMP_PTR		cmp;		/* Pointer to a CMP structure	*/  {  /*  * Local Declarations   */ &     int			    i;		/* String Index			*/H     struct dsc$descriptor   temp = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0}; /*  * Module Body  */   ' /* Initialize the cmp structure.					*/    cmp->vol     = elem->vol;  cmp->chapter = str_dyn;  cmp->page    = 0;  cmp->type    = IDX_K_SIMPLE;   /*K  * This routine assumes that the chapter string is delimited by one or more J  * "-" characters.  Determine if the page reference string contains such aI  * delimiter.  If it does, then copy the chapter portion of the string to ?  * the output string and set the "type" field to IDX_K_COMPLEX.   */   ) i = str$position(&elem->page_dsc, &dash);  if (i != 0)      {      i--;@     str$copy_r(&cmp->chapter, &i, elem->page_dsc.dsc$a_pointer);     cmp->type  = IDX_K_COMPLEX;      elem->type = IDX_K_COMPLEX;      }   $ /* Skip all dash characters.						*/  7 while (elem->page_dsc.dsc$a_pointer[i] == '-')	    i++;   . /* Convert the page number to an integer				*/  5 temp.dsc$w_length  = elem->page_dsc.dsc$w_length - i; 6 temp.dsc$a_pointer = &elem->page_dsc.dsc$a_pointer[i];  ots$cvt_ti_l(&temp, &cmp->page); }    /*+ 3  * Function Idx_Is_Adjacent - Documentation Section   *  * Discussion:E  *	Compare two page references and determine if the first is adjacent   *	to the second.   *  * Calling Synopsis:)  *	boolean = Idx_Is_Adjacent (curr, prev)   *
  * Inputs:B  *	curr	    ->	is the CMP data structure for the current page ref,  *			passed by reference.   *C  *	prev	    ->	is the CMP data structure for the previous page ref,   *			passed by reference.   *  * Outputs:   *	none   *  * Return Value:7  *	boolean	    ->	is a boolean result, passed by value.   *  * Global Data:   *	none   *  * Files Used:  *	none   *  * Assumed Entry State:   *	none   *  * Normal Exit State: ,  *	boolean = TRUE	    Pages are consecutive.1  *	boolean = FALSE	    Pages are not consecutive.   *  * Error Conditions:  *	none   *
  * Algorithm: >  *	A. If the page refs don't have the same type, return FALSE.H  *	B. If the page refs don't have the same vol-string ptr, return FALSE.&  *	C. If the page ref type is COMPLEX,D  *	    1. If the two chapter strings are not the same, return FALSE.<  *	D. If the page numbers are not consecutive, return FALSE.  *	E. Return TRUE.  *  * Special Notes:   *	none  -*/    /**  * Function Idx_Is_Adjacent - Code Section  */     int	idx_is_adjacent (curr, prev)  4     CMP_PTR		curr;		/* Current page-ref structure	*/5     CMP_PTR		prev;		/* Previous page-ref structure	*/  {  /*  * Local Declarations   */  /*  * Module Body  */   1 if (curr->type != prev->type)	    return (FALSE);   / if (curr->vol != prev->vol)	    return (FALSE);     if (curr->type == IDX_K_COMPLEX)     { M     if (str$compare_eql(&curr->chapter, &prev->chapter) != 0)	return (FALSE);      }   3 if (curr->page != (prev->page + 1)) return (FALSE);    return (TRUE); }    /*+ 9  * Function Idx_Deallocate_PgList - Documentation Section   *  * Discussion::  *	Deallocate the old page list for the current tree node.  *  * Calling Synopsis:$  *	call Idx_Deallocate_PgList (node)  *
  * Inputs:7  *	node	    ->	is the current tree node, passed by ref.   *  * Outputs: 7  *	node	    ->	is the current tree node, passed by ref.   *  * Return Value:  *	none   *  * Global Data:   *	none   *  * Files Used:  *	none   *  * Assumed Entry State:   *	none   *  * Normal Exit State:   *	none   *  * Error Conditions:  *	none   *
  * Algorithm: +  *	A. While the page listhead is not empty, -  *	    1. Unlink the current top of the list.   *	    2. Deallocate it.  *  * Special Notes:   *	none  -*/    /*0  * Function Idx_Deallocate_PgList - Code Section  */     int	idx_deallocate_pglist (node)       TREE_PTR		node;  {  /*  * Local Declarations   */ /     PGNODE_PTR		curr;		/* Current page node		*/  /*  * Module Body  */    while (node->pghead != 0)      {      curr = node->pghead;     node->pghead = curr->link;     free (curr);     }  }    /*+ 8  * Function Idx_Build_New_PgList - Documentation Section  *  * Discussion:2  *	Use the data table to construct a new pagelist.  *  * Calling Synopsis:0  *	call Idx_Build_New_PgList (node, table, size)  *
  * Inputs:=  *	node	    ->	is the current tree node, passed by reference.   *7  *	table	    ->	is the data table, passed by reference.   *G  *	size	    ->	is the number of elements in the table, passed by value.   *  * Outputs: B  *	node	    ->	is the current tree node, passed by reference.  The+  *			new page list is linked to the pghead.   *  * Return Value:  *	none   *  * Global Data:   *	none   *  * Files Used:  *	none   *  * Assumed Entry State: &  *	The tree node has a null page list.  *  * Normal Exit State:*  *	none*  *  * Error Conditions:  *	none* *  *
  * Algorithm:*"  *	A. For each entry in the table,.  *	    1. If the entry is not part of a range,0  *		a. Allocate a new element for the page list.  *		b. Fill it out.*3  *	    2. If the entry is the beginning of a range,l0  *		a. Allocate a new element for the page list./  *		b. Begin filling out the page list element. 0  *	    3. If the entry is the middle of a range,  *		a. Ignore it. -  *	    4. If the entry is the end of a range, 2  *		a. Complete filling out the page list element.  *  * Special Notes:o  *	nonet -*/    /*/  * Function Idx_Build_New_PgList - Code Sectionm  */e  , int	idx_build_new_pglist (node, table, size)       TREE_PTR		node;o     TABLE_PTR		table;c     int			size;  {  /*  * Local Declarations   */ 3     PGNODE_PTR		ptr = 0;	/* New PageRef Pointer		*/ (     int			i;		/* Current table entry		*/!     int			j;		/* Range index			*/* /*  * Module Body  */    for (i = 0; i < size; i++)     {e     switch (table[i].flag) 	{ 	case IDX_K_NONE:A) 	    idx_allocate_new_pgnode(&ptr, node);l 	    ptr->vol = table[i].vol; 6 	    str$copy_dx (&ptr->page_dsc, &table[i].page_dsc);) 	    ptr->highlight = table[i].highlight;  	    break;-   	case IDX_K_START:) 	    idx_allocate_new_pgnode(&ptr, node);* 	    ptr->vol = table[i].vol; 6 	    str$copy_dx (&ptr->page_dsc, &table[i].page_dsc);F 	    if ((ptr->highlight = table[i].highlight) == IDX_K_FOLLOW)	break;' 	    if (table[i].type == IDX_K_SIMPLE)e' 		str$append (&ptr->page_dsc, &simple);c	 	    elsep( 		str$append (&ptr->page_dsc, &complex); 	    break;    	case IDX_K_MIDDLE:1 	    break;r   	case IDX_K_END:( 	    if (ptr->highlight != IDX_K_FOLLOW)2 		str$append (&ptr->page_dsc, &table[i].page_dsc); 	    break;S 	}     }r }*   /*+n;  * Function Idx_Allocate_New_PgNode - Documentation Section   *  * Discussion:?  *	Allocate and link a new page-ref node into the current list.l  *  * Calling Synopsis:*  *	call Idx_Allocate_New_PgNode(ptr, node)  *
  * Inputs:B  *	ptr	    ->	is the current page-ref node pointer, passed by ref.  *0  *	node	    ->	is the current tree-node pointer.  *  * Outputs: ?  *	ptr	    ->	is the new page-ref pointer, passed by reference.r  *  * Return Value:  *	none   *  * Global Data:y  *	noneu  *  * Files Used:  *	nones  *  * Assumed Entry State:i  *	none   *  * Normal Exit State:   *	none;  *  * Error Conditions:  *	none   *
  * Algorithm:b  *	A. Allocate a new pgnode.7  *	B. Link it into the chain after the current pointer.a  *  * Special Notes:   *	noneS -*/  l /*2  * Function Idx_Allocate_New_PgNode - Code Section  */{  ' int	idx_allocate_new_pgnode (ptr, node)t  2     PGNODE_PTR		*ptr;		/* Page-Ref Node Pointer	*/)     TREE_PTR		node;		/* Node pointer			*/I {R /*  * Local Declarations*  */E1     PGNODE_PTR		new;		/* New Page-Ref Node Ptr	*/e /*  * Module Body  */n  * new = (PGNODE_PTR) malloc(sizeof(PGNODE));   new->link      = 0;* new->vol       = 0;g new->page_dsc  = str_dyn;c new->highlight = IDX_K_NONE;   if ((*ptr) == 0)     {i     node->pghead = new;e     }  else     {a     (*ptr)->link = new;i     }n   *ptr = new;i }S