 #module    IdxSpell	"2-005"  /*H  ***********************************************************************H  *                                                                     *H  * The software was developed at the Monsanto Company and is provided  *H  * "as-is".  Monsanto Company and the auther disclaim all warranties   *H  * on the software, including without limitation, all implied warran-  *H  * ties of merchantabilitiy and fitness.                               *H  *                                                                     *H  * This software does not contain any technical data or information    *H  * that is proprietary in nature.  It may be copied, modified, and     *H  * distributed on a non-profit basis and with the inclusion of this    *H  * notice.                                                             *H  *                                                                     *H  ***********************************************************************  */    /*+   * Module Name:	IdxSpell  *5  * Author:	R L Aurbach	CR&DS MIS Group    07-May-1986   *  * Function:D  *	Build the Spell String for an index term, properly handling LaTeX  *	syntax and commands.   *  * Modification History:  *,  * Version     Initials	   Date		DescriptionK  * ------------------------------------------------------------------------ &  * 1-001	RLA	07-May-1986	Original Code(  * 1-002	RLA	17-Mar-1987	Fix \verb error6  * 1-003	RLA	06-Apr-1987	Fix error processing emphasis@  * 2-004	RLA	16-Apr-1987	Honor the \verb environment in spelling/  * 2-005	RLA	20-Apr-1987	Enhance at-sign string  -*/    /*9  * Module IdxSpell - Module-Wide Data Description Section   *  * Include Files:   */  #include	    descrip #include	    ctype #include	    "IdxDef.H"    /*  * Module Definitions:  */  #define		    TRUE	1  #define		    FALSE	0  H #define		    str_lit(a)	{ sizeof(a)-1, DSC$K_DTYPE_T, DSC$K_CLASS_S, a }   /*  * Global Declarations:   */    /*  * Static Declarations:   */ 7     static $DESCRIPTOR	(accent_set, "`'^\"~=.uvHtcdb"); & #define	   emphasis_array_count	    18K     static struct dsc$descriptor   emphasis_array[emphasis_array_count] = {  					str_lit("\\rm"),  					str_lit("\\em"),  					str_lit("\\bf"),  					str_lit("\\it"),  					str_lit("\\sf"),  					str_lit("\\sl"),  					str_lit("\\sc"),  					str_lit("\\tt"),  					str_lit("\\normalsize"),  					str_lit("\\small"), 					str_lit("\\tiny"),  					str_lit("\\footnotesize"),  					str_lit("\\large"), 					str_lit("\\Large"), 					str_lit("\\LARGE"), 					str_lit("\\huge"),  					str_lit("\\Huge"),  					str_lit("\\cal")  }; -     static $DESCRIPTOR	    (at_sign, "@~~~"); ,     static $DESCRIPTOR	    (verb, "\\verb");   /*  * External References:   */    /*  * Functions Called:  */    /*+ :  * Function Idx_Build_Spell_String - Documentation Section  *  * Discussion:H  *	Create a string which can be used to put the token in the right placeD  *	in a list of tokens.  The string will be UPPERCASE, will exclude I  *	internal LaTeX commands which are included for emphasis, and will have +  *	whitespace collapsed into single spaces.   *  * Calling Synopsis:,  *	Call Idx_Build_Spell_String (token, desc)  *
  * Inputs:E  *	token	    ->	is the token to be processed.  ASCIZ string passed by   *			reference.   *  * Outputs: E  *	desc	    ->	is the "Spell String", properly formulated.  Passed by   *			dynamic string descriptor.   *  * Return Value:  *	none   *  * Global Data:   *	none   *  * Files Used:  *	none   *  * Assumed Entry State:   *	none   *  * Normal Exit State:   *	none   *  * Error Conditions:  *	none   *
  * Algorithm: +  *	A. Copy the token into a dynamic string. ,  *	B. Process Accent commands in the string..  *	C. Process emphasis commands in the string./  *	D. Remove grouping characters in the string. '  *	E. Remove backslashes in the string. +  *	F. Process \verb commands in the string.   *	G. Clean up the string.#  *	    1. Convert it to upper case. G  *	    2. Collapse the string -- i.e., remove non-essential whitespace. 3  *	    3. If the string begins with a \, remove it. F  *	    4. Make sure that all strings beginning with symbols are in the  *	       right place.  *  * Special Notes:   *	none  -*/    /*1  * Function Idx_Build_Spell_String - Code Section   */   ) void	idx_build_spell_string (token, desc)        char		    *token; "     struct dsc$descriptor   *desc; {  /*  * Local Declarations   */      int			    token_length; #     void		    idx_replace_string(); $     void		    idx_collapse_string();#     void		    idx_process_accent(); #     void		    idx_process_groups(); &     void		    idx_process_backslash();%     void		    idx_process_emphasis();      int			    i; /*  * Module Body  */   A /* Copy the token string into a dynamic string for processing		*/    token_length = strlen(token); ' str$copy_r(desc, &token_length, token);   ! /* Process accent strings						*/    idx_process_accent(desc);   $ /* Process emphasis commands						*/   idx_process_emphasis(desc);   % /* Remove grouping characters						*/    idx_process_groups(desc);    /* Remove backslashes							*/   idx_process_backslash(desc);  ! /* Process \verb commands						*/   $ while (idx_process_verb(desc))	    ;   /* Clean up the string							*/    str$upcase(desc, desc);    idx_collapse_string (desc);   J if (desc->dsc$a_pointer[0] == '\\')	    idx_replace_string(desc, 1, 1, 0);  A if (desc->dsc$a_pointer[0] > 'Z')	    str$prefix(desc, &at_sign);  }    /*+ 6  * Function Idx_Replace_String - Documentation Section  *  * Discussion:H  *	This function replaces a specified substring in a dynamic string with"  *	a specified replacement string.  *  * Calling Synopsis:;  *	Call Idx_Replace_String (string, start, length, replace)   *
  * Inputs:F  *	string	    ->	is the string to be updated.  The string is a dynamic"  *			string, passed by descriptor.  *B  *	start	    ->	is the starting position in the string.  The first:  *			position in the string is position 1.  Integer passed  *			by value.  *C  *	length	    ->	is the number of characters in the substring to be (  *			replaced.  Integer passed by value.  *C  *	replace	    ->	is the replacement text.  ASCIZ string passed by    *			reference.   *  * Outputs: G  *	string	    ->	is the updated string.  It is a dynamic string, passed   *			by descriptor.   *  * Return Value:  *	none   *  * Global Data:   *	none   *  * Files Used:  *	none   *  * Assumed Entry State:   *	none   *  * Normal Exit State:   *	none   *  * Error Conditions:  *	none   *
  * Algorithm: G  *	A. Copy the characters up to the first character in the substring to *  *	   be replaced into a temporary string.<  *	B. Copy the replacement string into the temporary string.I  *	C. Copy the remainder of the initial string into the temporary string.    *	D. Update the initial string.  *  * Special Notes: B  *	It is assumed that the updated string will be no more than 132   *	characters long.  -*/    /*-  * Function Idx_Replace_String - Code Section   */   8 void	idx_replace_string (string, start, length, replace)  $     struct dsc$descriptor   *string;     int			    start;     int			    length;      char		    *replace;  {  /*  * Local Declarations   */ <     int			    new_length;	    /* length of new string	    */@     int			    rpl_length;	    /* length of the replace string */:     int			    left;	    /* number of characters left    */8     char		    temp[133];	    /* temporary string		    */ /*  * Module Body  */    new_length = 0;  if (start > 1)     { 3     strncpy (temp, string->dsc$a_pointer, start-1);      new_length = start-1;      }    if (replace != 0)      { !     rpl_length = strlen(replace);      if (rpl_length > 0)  	{2 	strncpy (&temp[new_length], replace, rpl_length); 	new_length += rpl_length; 	}     }   3 left = string->dsc$w_length - (start - 1) - length; 
 if (left > 0)      { N     strncpy (&temp[new_length], &string->dsc$a_pointer[start+length-1], left);     new_length += left;      }   ' str$copy_r (string, &new_length, temp);  }    /*+ 7  * Function Idx_Collapse_String - Documentation Section   *  * Discussion:J  *	Replace the string with a new string which as all extraneous whitespaceG  *	removed.  That is, there is no whitespace at the beginning or end of I  *	the string and every internal occurrence of whitespace is collapsed to   *	a single space character.  *  * Calling Synopsis:$  *	Call Idx_Collapse_String (string)  *
  * Inputs:H  *	string	    ->	is the input string.  It is a dynamic string, passed by  *			descriptor.  *  * Outputs: I  *	string	    ->	is the output string.  It is a dynamic string, passed by   *			descriptor.  *  * Return Value:  *	none   *  * Global Data:   *	none   *  * Files Used:  *	none   *  * Assumed Entry State:   *	none   *  * Normal Exit State:   *	none   *  * Error Conditions:  *	none   *
  * Algorithm: -  *	A. For all characters in the input string, )  *	    1. If the character is whitespace, .  *		a. If no characters have been transferred,  *		    1. Ignore it. 9  *		b. If the previous character transferred was a space,   *		    1. Ignore it.   *		c. Else,-  *		    1. Copy a space to the output string.   *	    2. Else, /  *		a. Copy the character to the output string. <  *	B. If the last character in the output string is a space,  *	    1. Remove it.   *	C. Update the dynamic string.  *  * Special Notes: D  *	It is assumed that the collapsed string will be no more than 132   *	characters long.  -*/    /*.  * Function Idx_Collapse_String - Code Section  */   ! void	idx_collapse_string (string)   $     struct dsc$descriptor   *string; {  /*  * Local Declarations   */ <     char		    temp[133];	    /* Working output string	    */3     char		    copy;	    /* Working character	    */ 8     int			    i;		    /* Array index in input string  */8     int			    j;		    /* Array index in temp string   */ /*  * Module Body  */   1 for (i = 0, j = 0; i < string->dsc$w_length; i++)      { $     copy = string->dsc$a_pointer[i];     if (isspace(copy) != 0)  	{ 	if (j == 0)   	    { 	    continue; 	    } 	else  	    { 	    if (temp[j-1] == ' ') 		{  		continue;  		} 	 	    else  		{  		temp[j++] = ' '; 		}  	    } 	}     else 	{ 	temp[j++] = copy; 	}     }   F /* Check to see if the temporary string is terminated by whitespace	*/  ' if ((j > 0) && (temp[j-1] == ' '))	j--;   1 /* Now copy the result to the output string				*/    str$copy_r (string, &j, temp); }    /*+ 7  * Function Idx_Process_Accents - Documentation Section   *  * Discussion:G  *	This routine processes the spell string to remove all LaTeX commands G  *	which generate accents, without changing the spelling.  For example, D  *	the string "se\~{n}or" is translated to "senor".  Without specialI  *	accent processing, the spell-string algorithm would produce "se n or", J  *	which might not appear in the proper place in the alphabetical listing.  *  * Calling Synopsis:$  *	call Idx_Process_Accents (string)  *
  * Inputs:F  *	string	    ->	is the spell-string to be processed.  It is a dynamic"  *			string, passed by descriptor.  *  * Outputs: H  *	string	    ->	is the resultant spell-string.  It is a dynamic string,  *			passed by descriptor.  *  * Return Value:  *	none   *  * Global Data:   *	none   *  * Files Used:  *	none   *  * Assumed Entry State:   *	none   *  * Normal Exit State:   *	none   *  * Error Conditions:  *	none   *
  * Algorithm: .  *	A. Search the string for an accent pattern:4  *	    1. The first character in the pattern is "\".G  *	    2. The next character in the pattern is one of the characters in   *	       the accent_set. 3  *	    3. The next character in the pattern is "{". 4  *	B. Mark the pattern and find the terminating "}".D  *	C. Replace the pattern with the string located within the braces.  *  * Special Notes:   *	none  -*/    /*-  * Function Idx_Process_Accent - Code Section   */     void	idx_process_accent (string)  $     struct dsc$descriptor   *string; {  /*  * Local Declarations   */ P     struct dsc$descriptor   accent_str = { 1, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0 };;     int			    start;	    /* Start of string to replace   */ 8     char		    *replace;	    /* Replacement string	    */+     int			    i;		    /* Loop index		    */ 6     int			    ctx = 0;	    /* context variable		    */ /*  * Module Body  */   * for (i = 0; i < string->dsc$w_length; i++)     { 3     if (string->dsc$a_pointer[i] != '\\')	continue;      start = ++i;9     accent_str.dsc$a_pointer = &string->dsc$a_pointer[i]; L     if (str$find_first_in_set (&accent_str, &accent_set) == 0)	    continue;4     if (string->dsc$a_pointer[++i] != '{')	continue;4     if (idx_is_verbatim(string, &ctx, &i))	continue;*     replace = &string->dsc$a_pointer[++i];$     while (i < string->dsc$w_length) 	{1 	if (string->dsc$a_pointer[i++] != '}')	continue; # 	string->dsc$a_pointer[i-1] = '\0';  	break;  	};     idx_replace_string (string, start, i-start+1, replace);      }  }    /*+ 6  * Function Idx_Process_Groups - Documentation Section  *  * Discussion:I  *	Process the characters which delimit groups ('{', '}', and '$') in the E  *	spell string.  These characters are removed unless they are quoted *  *	(e.g., "{" is removed but "\{" is not).  *  * Calling Synopsis:#  *	Call Idx_Process_Groups (String)   *
  * Inputs:G  *	string	    ->	is the spell string.  It is a dynamic string passed by   *			descriptor.  *  * Outputs: G  *	string	    ->	is the spell string.  It is a dynamic string passed by   *			descriptor.  *  * Return Value:  *	none   *  * Global Data:   *	none   *  * Files Used:  *	none   *  * Assumed Entry State:   *	none   *  * Normal Exit State: /  *	returns with spell string possibly modified.   *  * Error Conditions:  *	none   *
  * Algorithm: -  *	A. For all characters in the spell string, A  *	    1. If the character is '{', '}', or '$' and the preceeding !  *	       character is not a '\',   *		a. Remove the character.  *  * Special Notes:   *	none  -*/    /*-  * Function Idx_Process_Groups - Code Section   */     void	idx_process_groups (string)  $     struct dsc$descriptor   *string; {  /*  * Local Declarations   */ (     int			    i;		/* Loop index			    */2     int			    ctx = 0;	/* Context variable		    */ /*  * Module Body  */   * for (i = 0; i < string->dsc$w_length; i++)     { .     if ( (string->dsc$a_pointer[i] == '{')  ||' 	 (string->dsc$a_pointer[i] == '}')  || % 	 (string->dsc$a_pointer[i] == '$') )  	{6 	if ((i == 0) || (string->dsc$a_pointer[i-1] != '\\')) 	    {6 	    if (idx_is_verbatim(string, &ctx, &i))  continue;+ 	    idx_replace_string(string, i+1, 1, 0); 	 	    i--;  	    } 	}     }  }    /*+ 4  * Function Idx_Process_Verb - Documentation Section  *  * Discussion:H  *	Process LaTeX \verb and \verb* commands in the spell string.  This is<  *	done by removing the \verb command from the spell string.  *  * Calling Synopsis:%  *	status = Idx_Process_Verb (string)   *
  * Inputs:F  *	string	    ->	Spell string.  A dynamic string passed by descriptor.  *  * Outputs: F  *	string	    ->	Spell string.  A dynamic string passed by descriptor.  *  * Return Value:D  *	status	    ->	is a boolean integer passed by value.  It indicates:  *			whether or not a \verb command was found in the spell  *			string.  *  * Global Data:   *	none   *  * Files Used:  *	none   *  * Assumed Entry State:   *	none   *  * Normal Exit State: =  *	status = TRUE	A \verb command was processed in the string. 1  *	status = FALSE	No \verb command was processed.   *  * Error Conditions:  *	none   *
  * Algorithm: ,  *	A. Search the string for a \verb command:,  *	    1. \verb [optionally followed by a *]*  *	    2. Next character is not alphabetic:  *	B. Mark the pattern and find the terminating character.,  *	C. Replace the pattern with its argument.  *  * Special Notes:   *	none  -*/    /*+  * Function Idx_Process_Verb - Code Section   */    int	idx_process_verb (string)   $     struct dsc$descriptor   *string; {  /*  * Local Declarations   */ (     int			    i;		/* Loop index			    */0     int			    start;	/* Start of pattern		    */3     char		    delim;	/* Delimiter character		    */ >     char		    *replace;	/* Pointer to replacement string    */ /*  * Module Body  */   1 if (string->dsc$w_length < 7)	    return (FALSE);p, for (i = 0; i < string->dsc$w_length-7; i++)     { H     if (strncmp (&string->dsc$a_pointer[i], "\\verb", 5) != 0)	continue;     start = i + 1;     i += 5;.0     if (string->dsc$a_pointer[i] == '*')    i++;'     delim = string->dsc$a_pointer[i++]; +     if (isalpha(delim) != 0)		    continue;t(     replace = &string->dsc$a_pointer[i];$     while (i < string->dsc$w_length) 	{6 	if (string->dsc$a_pointer[i++] != delim)    continue;# 	string->dsc$a_pointer[i-1] = '\0';  	break;  	};     idx_replace_string (string, start, i-start+1, replace);      return (TRUE);     }  return (FALSE);  }    /*+ 9  * Function Idx_Process_Backslash - Documentation Section*  *  * Discussion:  *	Remove all '\' characters.   *  * Calling Synopsis:&  *	Call Idx_Process_Backslash (string)  *
  * Inputs:D  *	string	    ->	Spell String.  Dynamic string passed by descriptor.  *  * Outputs:LD  *	string	    ->	Spell String.  Dynamic string passed by descriptor.  *  * Return Value:  *	nones  *  * Global Data:-  *	none-  *  * Files Used:  *	none-  *  * Assumed Entry State:1  *	none0  *  * Normal Exit State:*
  *	returns  *  * Error Conditions:  *	none3  *
  * Algorithm:x-  *	A. For all characters in the spell string,-$  *	    1. If the character is a '\',  *		a. Remove it.A  *  * Special Notes:-  *	nonen -*/*   /*0  * Function Idx_Process_Backslash - Code Section  */e  # void	idx_process_backslash (string)i  $     struct dsc$descriptor   *string; {c /*  * Local Declarations   */d(     int			    i;		/* Loop index			    */2     int			    ctx = 0;	/* Context variable		    */ /*  * Module Body  */E  * for (i = 0; i < string->dsc$w_length; i++)     { )     if (string->dsc$a_pointer[i] == '\\')  	{5 	if (idx_is_verbatim(string, &ctx, &i))	    continue; ' 	idx_replace_string(string, i+1, 1, 0);  	i--;c 	}     }$ }c t /*+e8  * Function Idx_Process_Emphasis - Documentation Section  *  * Discussion:E  *	Remove the normal LaTeX emphasis strings (\rm, \em, \bf, \it, \sf,tG  *	\sl, \tt, \normalsize, \small, \tiny, \footnotesize, \large, \Large,"  *	\LARGE, \huge, \Huge, \cal).i  *  * Calling Synopsis:%  *	call Idx_Process_Emphasis (string)s  *
  * Inputs:D  *	string	    ->	Spell string.  Dynamic string passed by descriptor.  *  * Outputs:,D  *	string	    ->	Spell string.  Dynamic string passed by descriptor.  *  * Return Value:  *	noneT  *  * Global Data:~  *	none   *  * Files Used:  *	none   *  * Assumed Entry State:   *	nones  *  * Normal Exit State:s  *	none   *  * Error Conditions:  *	nonel  *
  * Algorithm:c.  *	A. For each of the listed special commands,G  *	    1. For each occurence of the string which is not part of a word,   *		a. Remove it.e  *  * Special Notes:S  *	nonex -*/  * /*/  * Function Idx_Process_Emphasis - Code Sections  */n  " void	idx_process_emphasis (string)  $     struct dsc$descriptor   *string; {i /*  * Local Declarations_  */g1     int			    i;		/* emphasis_array index		    */t1     int			    start;	/* starting position		    */ 4     int			    length;	/* length of substring		    */.     int			    ctx;	/* context variable		    */-     int			    index;	/* string index			    */R=     int			    rpl_start;	/* start of string to replace	    */F /*  * Module Body  */   * for (i = 0; i < emphasis_array_count; i++)     {t     ctx = 0;     start = 1;K     while ((start = str$position(string, &emphasis_array[i], &start)) != 0)a 	{ 	rpl_start = start;s 	index = start - 1;t) 	length = emphasis_array[i].dsc$w_length;  	start += length;D) 	if (((start) <= string->dsc$w_length) && ? 	    (isalpha(string->dsc$a_pointer[start-1]) != 0))  continue;o6 	if (idx_is_verbatim(string, &ctx, &index))  continue;3 	idx_replace_string (string, rpl_start, length, 0);t 	}     }- }e r /*+ 3  * Function Idx_Is_Verbatim - Documentation Sectione  *  * Discussion:E  *	Deterimine if the current string index is within a \verb or \verb* 	  *	range.   *  * Calling Synopsis:/  *	boolean = Idx_Is_Verbatim (desc, ctx, index)t  *
  * Inputs:B  *	desc	    ->	is the character string descriptor being processed.  *@  *	ctx	    ->	is a context variable, passed by ref.  Internally,5  *			it is the current starting value for the search.   *1  *	index	    ->	is the string index being tested.   *  * Outputs:o?  *	ctx	    ->	is the value of the first character to follow the	  *			\verb or \verb* string.  *C  *	index	    ->	is the new value of the string index.  If the index)7  *			is not in a verbatim, then the value is unchanged. 9  *			If it is in the string, then the index is updated to #  *			the end of the verbatim range.$  *  * Return Value:%  *	boolean	    ->	is a boolean value.i  *  * Global Data:r  *	nonee  *  * Files Used:  *	nonea  *  * Assumed Entry State:r  *	noneh  *  * Normal Exit State:rD  *	boolean = TRUE	    Input index is within the range of a verbatim./  *			    Index is updated.  Ctx may be updated.cJ  *	boolean = FALSE	    Input string is not within the range of a verbatim.%  *			    Index and Ctx are unchanged.*  *  * Error Conditions:  *	noned  *
  * Algorithm:d@  *	A. If index < ctx, then we know that we aren't in a verbatim.  *	    1. Return FALSE.(D  *	B. Find the next verbatim range.  Save the start and end (= ctx).  *	C. If index < start,e  *	    1. Return FALSE,i  *	D. Else,*  *	    1. Index = end of range.n  *	    2. Return TRUE.  *  * Special Notes:r  *	none  -*/s i /**  * Function Idx_Is_Verbatim - Code Section  */*  & int	idx_is_verbatim (desc, ctx, index)  "     struct dsc$descriptor   *desc;     int			    *ctx;t     int			    *index;e {r /*  * Local Declarationsn  */s     int			    start;     int			    i;     char		    delim; /*  * Module Body  */r  " if (*index < *ctx)	return (FALSE);   /*N  * Find the next verbatim range.  If there are less than seven characters leftJ  * in the string, then the remainder of the string cannot contain a \verb L  * command (because there isn't room).  Set the ctx variable to point to theB  * end of the string and report that we are not within a verbatim.  */s  $ if ((desc->dsc$w_length - *ctx) < 7)     {      *ctx = desc->dsc$w_length;     return (FALSE);      }n   /*M  * Search for the next \verb string.  Note that the STR$POSITION routine usesaO  * the convention that the first character of the string is position 1 (not 0). O  * If no string was found, then set the ctx to the end of the string and reporte   * that we aren't in a verbatim.  */B  
 i = *ctx + 1;e' start = str$position (desc, &verb, &i);* if (start == 0)i     {      *ctx = desc->dsc$w_length;     return (FALSE);      }t i /*M  * There may be a verbatim in the string.  Its potential starting position islK  * "start" (adjusted to index the string from 0 rather than 1).  If this ise?  * the case, then the delimiter character will not be an alpha.r  */s   start--; i = start + 5;( if (desc->dsc$a_pointer[i] == '*')  i++; delim = desc->dsc$a_pointer[i];g   /*M  * If the delimiter is an alpha, then we have not found a verbatim string (iteN  * is something else).  If the index we are checking is within the range we'veL  * looked at, then we know that it isn't in a verbatim and we can so report.  *L  * On the other hand, if we haven't gotten far enough into the string yet toO  * know, we must keep looking.  We do this by calling this routine recursively.r  */d   if (isalpha(delim) != 0)     {e
     *ctx = i;      if (*index < i)c 	return (FALSE);     else, 	return (idx_is_verbatim(desc, ctx, index));     }{   /*@  * We have found a real verbatim string.  We search for its end.  */t   while (i < desc->dsc$w_length)     {n1     if (desc->dsc$a_pointer[++i] == delim)	break;      }t *ctx = ++i;n   /*L  * Now we can check to see if we're ok.  If the index is before the start ofI  * the verbatim string, we aren't in it.  If it is in the middle, we are.tH  * If it's after the end, we still don't know and have to call ourselves  * recursively to find out.s  */   # if (*index < start)	return (FALSE);r if (*index < *ctx)     {n     *index = *ctx - 1;     return (TRUE);     }r else/     return (idx_is_verbatim(desc, ctx, index));a }d