 #module    IdxTeX    "2-004" /*H  ***********************************************************************H  *                                                                     *H  * The software was developed at the Monsanto Company and is provided  *H  * "as-is".  Monsanto Company and the auther disclaim all warranties   *H  * on the software, including without limitation, all implied warran-  *H  * ties of merchantabilitiy and fitness.                               *H  *                                                                     *H  * This software does not contain any technical data or information    *H  * that is proprietary in nature.  It may be copied, modified, and     *H  * distributed on a non-profit basis and with the inclusion of this    *H  * notice.                                                             *H  *                                                                     *H  ***********************************************************************  */    /*+   * Module Name:	IdxTeX  *5  * Author:	R L Aurbach	CR&DS MIS Group    26-Apr-1986   *  * Function:F  *	Main Line of the IdxTeX program.  This program processes .idx filesF  *	produced by LaTeX and generates files which will produce a properly  *	formatted index.   *  * Modification History:  *,  * Version     Initials	   Date		DescriptionK  * ------------------------------------------------------------------------ &  * 1-001	RLA	26-Apr-1986	Original Code7  * 1-002	RLA	13-Jun-1986	Add support for /TOC qualifier @  * 1-003	RLA	06-Apr-1987	Change version number to 1.2 to reflect-  *					  corrections with spelling processing <  * 2-004	RLA	07-Apr-1987	Add range and master index support. -*/    /*7  * Module IdxTeX - Module-Wide Data Description Section   *  * Include Files:   */  #include	    descrip #include	    stdio #include	    "IdxDef.H"    /*  * Module Definitions:  */  #define		    TRUE	1  #define		    FALSE	05 #define		    linebfsize	133	/* Max size of a line		*/    /*  * Global Declarations:   */ 8     TREE_PTR	    root = 0;		/* Root of the Index Tree	*/   /*  * Static Declarations:   */    /*  * External References:   */    /*  * Functions Called:  */    /*+ *  * Function IdxTeX - Documentation Section  *  * Discussion:I  *	This is the main line of the IdxTeX program.  It reads the input file, F  *	parsing the information, and generates an output file based on the #  *	information from the input file.   *  * Calling Synopsis:"  *	$ IdxTeX :== $Crl_Public:IdxTeX8  *	$ IdxTeX filespec [/TOC:{ARTICLE | REPORT}] [/MASTER]  *
  * Inputs:?  *	filespec	    ->	Name of the input file to be processed.  The 3  *				default filespec SYS$DISK:[].IDX is processed 1  *				against this specification.  If the /MASTER 4  *				qualifier is present, the default file type is  *				.MDX.   *  * Outputs: ?  *	filespec	    ->	The program produces an output file which is 4  *				the resultant filespec from processing .IND as3  *				the primary file specification and the fully- .  *				qualified input filespec as the default.  *  * Return Value:  *	returns SUCCESS  *  * Global Data:   *	none   *  * Files Used:*  *	reads an input file as specified above..  *	produces an output file as specified above.  *  * Assumed Entry State:   *	Called from DCL level.   *  * Normal Exit State:   *	Returns to DCL level.  *  * Error Conditions:>  *	Input file not found	-- program issues a message and exits   *				    immediately.I  *	Input file format error -- program ignores any lines of the input file '  *				    which it does not understand.     *
  * Algorithm: 3  *	A. Call Idx_Command to process the command line. #  *	B. If processing a master index, +  *	    1. Open the Master Index input file. &  *	    2. For all records in the file,  *		a. Read the next record.+  *		b. Call Idx_Process_File to process it. ,  *	    3. Close the Master Index input file.  *	C. Else, :  *	    1. Call Idx_Process_File to process the input file.  *	D. Open the output file. 4  *	E. Call Idx_Generate to generate the output file.  *	F. Close the output file.  *  * Special Notes:   *	none  -*/    /*!  * Function IdxTeX - Code Section   */    main() {  /*  * Local Declarations   */ &     FILE	*file;			/* file pointer			*//     char	dna[133];		/* Default filename arg		*/ 3     char	linebf[linebfsize];	/* I/O line buffer		*/ /     char	filename[256];		/* Input file name		*/ .     int		toc_flag;		/* /TOC qualifier flag		*/0     int		mst_flag;		/* /MASTER qualifier flag	*//     FILE	*mst_file;		/* master file pointer		*/ H     struct dsc$descriptor   *vol = 0;	/* volume string descriptor ptr	*/1     int		ok;			/* valid master file record flg	*/ 3     char	*outfile;		/* output file specification	*/  /*  * Module Body  */   F /* Process the command line.  The routine will force exit on error.	*/  , idx_command(filename, &toc_flag, &mst_flag);# sprintf(dna, "dna = %s", filename);   K printf("\nIdxTeX, the automatic index generator for LaTeX, version 2.0\n");    /*  $  * If doing master index processing,"  *  A. Open the master index file.#  *  B. For all records in the file,   *	1. Read the next record. *  *	2. Call Idx_Process_File to process it.  *  C. Close the file.  *
  * Otherwise, 1  *  A. Call Idx_Process_File to process the file.   */   
 if (mst_flag)      { K     if ((mst_file = fopen(filename, "r", "dna = sys$disk:[].mdx")) == NULL)  	{, 	printf("Could not open the master file\n"); 	exit(); 	}6     printf("\nProcessing Master File %s\n", filename);4     while (fgets(linebf, linebfsize, mst_file) != 0) 	{/ 	if (idx_parse_master (linebf, filename, &vol))  	    {6 	    printf("\tProcessing index file %s\n", filename);% 	    idx_process_file(filename, vol);  	    } 	}     fclose(mst_file);       outfile = "sys$disk:[].mnd";     }    else     { $     idx_process_file(filename, vol);      outfile = "sys$disk:[].ind";     }   ) /* Now generate the output file...					*/   C if ((file = fopen(outfile, "w", "rat=cr", "rfm=var", dna)) == NULL)      { /     printf("Could not open the output file\n");      exit();      } ( idx_generate (file, toc_flag, mst_flag);
 fclose(file);    exit();  } 