 /*  *  *  This file is part ofA  *	MakeIndex - A formatter and format independent index processor   *2  *  This file is public domain software donated by*  *  Nelson Beebe (beebe@science.utah.edu).  *  */    /*M  * qsort.c: Our own version of the system qsort routine which is faster by an M  * average of 25%, with lows and highs of 10% and 50%. The THRESHold below is M  * the insertion sort threshold, and has been adjusted for records of size 48 B  * bytes. The MTHREShold is where we stop finding a better median.  */   1 /* #include <stdio.h> -- mkind.h includes this */ > #include    "mkind.h"		       /* only for type declarations */  7 #define THRESH  4		       /* threshold for insertion */ 4 #define MTHRESH 6		       /* threshold for median */  2 static int qsz;			       /* size of each record */3 static int thresh;		       /* THRESHold in chars */ 5 static int mthresh;		       /* MTHRESHold in chars */   D static int	(*qcmp) ARGS((char*,char*)); /* the comparison routine */. static void	qst ARGS((char *base, char *max)); /*H  * qqsort: First, set up some global parameters for qst to share.  Then,L  * quicksort with qst(), and then a cleanup insertion sort ourselves.  Sound  * simple? It's not...  */    void #if STDCF qqsort(char *base, int n, int size, int (*compar) ARGS((char*,char*))) #else  qqsort(base, n, size, compar) 
 char   *base; 
 int     n;
 int     size; & int     (*compar) ARGS((char*,char*)); #endif {      register char *i;      register char *j;      register char *lo;     register char *hi;     register char *min;      register char c;     char   *max;       if (n <= 1)  	return;     qsz = size;      qcmp = compar;     thresh = qsz * THRESH;     mthresh = qsz * MTHRESH;     max = base + n * qsz;      if (n >= THRESH) { 	qst(base, max); 	hi = base + thresh;     } else {
 	hi = max;     }      /*L      * First put smallest element, which must be in the first THRESH, in theH      * first position as a sentinel.  This is done just by searching theM      * first THRESH elements (or the first n if n < THRESH), finding the min, /      * and swapping it into the first position.       */ ,     for (j = lo = base; (lo += qsz) < hi;) { 	if ((*qcmp) (j, lo) > 0)  	    j = lo;     } 4     if (j != base) {		       /* swap j into place */+ 	for (i = base, hi = base + qsz; i < hi;) {  	    c = *j; 	    *j++ = *i;  	    *i++ = c; 	}     }      /*F      * With our sentinel in place, we now run the following hyper-fastJ      * insertion sort. For each remaining element, min, from [1] to [n-1],M      * set hi to the index of the element AFTER which this one goes. Then, do K      * the standard insertion sort shift on a character at a time basis for        * each element in the frob.      */ 0     for (min = base; (hi = min += qsz) < max;) {& 	while ((*qcmp) (hi -= qsz, min) > 0); 	if ((hi += qsz) != min) {) 	    for (lo = min + qsz; --lo >= min;) { 
 		c = *lo;+ 		for (i = j = lo; (j -= qsz) >= hi; i = j)  		    *i = *j;	 		*i = c;  	    } 	}     }  }        /*L  * qst: Do a quicksort.  First, find the median element, and put that one inK  * the first place as the discriminator.  (This "median" is just the median J  * of the first, last and middle elements).  (Using this median instead ofJ  * the first element is a big win). Then, the usual partitioning/swapping,K  * followed by moving the discriminator into the right place.  Then, figure L  * out the sizes of the two partions, do the smaller one recursively and theK  * larger one via a repeat of this code.  Stopping when there are less than L  * THRESH elements in a partition and cleaning up with an insertion sort (inG  * our caller) is a huge win. All data swaps are done in-line, which is L  * space-losing but time-saving. (And there are only three places where this  * is done).  */    static void  #if STDC qst(char *base, char *max) #else  qst(base, max)
 char   *base;  char   *max; #endif {      register char *i;      register char *j;      register char *jj;     register char *mid;      register int ii;     register char c;     char   *tmp;     int     lo;      int     hi;   >     lo = (int)(max - base);		/* number of elements as chars */     do { 	/* F 	 * At the top here, lo is the number of characters of elements in theE 	 * current partition.  (Which should be max - base). Find the median C 	 * of the first, last, and middle element and make that the middle E 	 * element.  Set j to largest of first and middle.  If max is larger E 	 * than that guy, then it's that guy, else compare max with loser of C 	 * first and take larger.  Things are set up to prefer the middle, # 	 * then the first in case of ties.  	 */5 	mid = i = base + qsz * ((unsigned) (lo / qsz) >> 1);  	if (lo >= mthresh) { 1 	    j = ((*qcmp) ((jj = base), i) > 0 ? jj : i); . 	    if ((*qcmp) (j, (tmp = max - qsz)) > 0) { 		/* switch to first loser */  		j = (j == jj ? i : jj);  		if ((*qcmp) (j, tmp) < 0)  		    j = tmp; 	    } 	    if (j != i) { 		ii = qsz;  		do {
 		    c = *i;  		    *i++ = *j; 		    *j++ = c;  		} while (--ii);  	    } 	}4 	/* Semi-standard quicksort partitioning/swapping */" 	for (i = base, j = max - qsz;;) {- 	    while (i < mid && (*qcmp) (i, mid) <= 0)  		i += qsz;  	    while (j > mid) { 		if ((*qcmp) (mid, j) <= 0) { 		    j -= qsz;  		    continue;  		} 3 		tmp = i + qsz;	       /* value of i after swap */ 6 		if (i == mid) {	       /* j <-> mid, new mid is j */ 		    mid = jj = j;  		} else {	       /* i <-> j */ 
 		    jj = j;  		    j -= qsz;  		}  		goto swap; 	    } 	    if (i == mid) { 		break;3 	    } else {		       /* i <-> mid, new mid is i */  		jj = mid; 3 		tmp = mid = i;	       /* value of i after swap */  		j -= qsz;  	    }	     swap:  	    ii = qsz;	 	    do { 	 		c = *i; 
 		*i++ = *jj;  		*jj++ = c; 	    } while (--ii);
 	    i = tmp;  	} 	/* D 	 * Look at sizes of the two partitions, do the smaller one first byD 	 * recursion, then do the larger one by making sure lo is its size,C 	 * base and max are update correctly, and branching back. But only B 	 * repeat (recursively or by branching) if the partition is of at 	 * least size THRESH. 	 */ 	i = (j = mid) + qsz; 7 	if ((lo = (int)(j - base)) <= (hi = (int)(max - i))) {  	    if (lo >= thresh) 		qst(base, j);  	    base = i;
 	    lo = hi; 	 	} else {  	    if (hi >= thresh) 		qst(i, max);
 	    max = j;  	}     } while (lo >= thresh);  } 