 /* epsffit.c  * AJCD 6 Dec 90&  * fit epsf file into constrained size	  * Usage: ;  *       epsffit [-c] [-r] [-a] [-s] llx lly urx ury [file] ?  *               -c centres the image in the bounding box given B  *               -r rotates the image by 90 degrees anti-clockwiseC  *               -a alters the aspect ratio to fit the bounding box ;  *               -s adds a showpage at the end of the image   *5  * Added filename spec (from Larry Weissman) 5 Feb 93 L  * Accepts double %%BoundingBox input, outputs proper BB, 4 Jun 93. (I don'tO  * like this; developers should read the Big Red Book before writing code which   * outputs PostScript.  */    #include <stdio.h> #include <ctype.h> #include "patchlevel.h"   ( #define min(x,y) ((x) > (y) ? (y) : (x))( #define max(x,y) ((x) > (y) ? (x) : (y))   static char *prog;   void usage() { O    fprintf(stderr, "%s release %d patchlevel %d\n", prog, RELEASE, PATCHLEVEL); L    fprintf(stderr, "Usage: %s [-c] [-r] [-a] [-s] llx lly urx ury [file]\n",
 	   prog);    exit(1);  }    main(argc, argv)      int argc;      char **argv;  { ;    int bbfound = 0;              /* %%BoundingBox: found */     int urx, ury, llx, lly;    int furx, fury, fllx, flly;F    int showpage = 0, centre = 0, rotate = 0, aspect = 0, maximise = 0;    char buf[BUFSIZ];    FILE *input = stdin;       prog = *argv++; argc--;  *    while (argc > 0 && argv[0][0] == '-') {       switch (argv[0][1]) { "       case 'c': centre = 1; break;$       case 's': showpage = 1; break;"       case 'r': rotate = 1; break;"       case 'a': aspect = 1; break;$       case 'm': maximise = 1; break;       case 'v':        default:  usage();       } 
       argc--; 
       argv++;     }      if (argc < 4) usage();     fllx = atoi(argv[0]);    flly = atoi(argv[1]);    furx = atoi(argv[2]);    fury = atoi(argv[3]);      if (argc > 4) {)       if(!(input = fopen(argv[4],"r"))) { 9 	 fprintf(stderr, "%s: Cannot open %s\n", prog, argv[4]); 
 	 exit(1);       }     }  &    while (fgets(buf, BUFSIZ, input)) {>       if (buf[0] == '%' && (buf[1] == '%' || buf[1] == '!')) {  	 /* still in comment section */, 	 if (!strncmp(buf, "%%BoundingBox:", 14)) {? 	    double illx, illy, iurx, iury;	/* input bbox parameters */ 9 	    if (sscanf(buf, "%%%%BoundingBox:%lf %lf %lf %lf\n", , 		       &illx, &illy, &iurx, &iury) == 4) { 	       bbfound = 1;A 	       llx = (int)illx;	/* accept doubles, but convert to int */  	       lly = (int)illy; 	       urx = (int)(iurx+0.5); 	       ury = (int)(iury+0.5); 	    }2 	 } else if (!strncmp(buf, "%%EndComments", 13)) {8 	    strcpy(buf, "\n"); /* don't repeat %%EndComments */ 	    break;  	 } else fputs(buf,stdout);        } else break;     }  ;    if (bbfound) { /* put BB, followed by scale&translate */        int fwidth, fheight;       double xscale, yscale;,       double xoffset = fllx, yoffset = flly;/       double width = urx-llx, height = ury-lly;          if (maximise) 2 	 if ((width > height && fury-flly > furx-fllx) ||1 	     (width < height && fury-flly < furx-fllx))   	    rotate = 1;         if (rotate) {  	 fwidth = fury - flly;  	 fheight = furx - fllx;       } else { 	 fwidth = furx - fllx;  	 fheight = fury - flly;       }          xscale = fwidth/width;       yscale = fheight/height;  8       if (!aspect) {       /* preserve aspect ratio ? */' 	 xscale = yscale = min(xscale,yscale);        } F       width *= xscale;     /* actual width and height after scaling */       height *= yscale;        if (centre) {  	 if (rotate) { % 	    xoffset += (fheight - height)/2; # 	    yoffset += (fwidth - width)/2; 
 	 } else {# 	    xoffset += (fwidth - width)/2; % 	    yoffset += (fheight - height)/2;  	 }        } J       printf("%%%%BoundingBox: %d %d %d %d\n", (int)xoffset, (int)yoffset,/ 	     (int)(xoffset+(rotate ? height : width)), 0 	     (int)(yoffset+(rotate ? width : height)));>       if (rotate) {  /* compensate for original image shift */D 	 xoffset += height + lly * yscale;  /* displacement for rotation */ 	 yoffset -= llx * xscale;       } else { 	 xoffset -= llx * xscale; 	 yoffset -= lly * yscale;       }        puts("%%EndComments");       if (showpage) = 	 puts("save /showpage{}def /copypage{}def /erasepage{}def"); 
       else& 	 puts("%%BeginProcSet: epsffit 1 0");       puts("gsave");:       printf("%.3lf %.3lf translate\n", xoffset, yoffset);       if (rotate)  	 puts("90 rotate");4       printf("%.3lf %.3lf scale\n", xscale, yscale);       if (!showpage) 	 puts("%%EndProcSet");     }    do {        fputs(buf,stdout);'    } while (fgets(buf, BUFSIZ, input));     if (bbfound) {        puts("grestore");        if (showpage) . 	 puts("restore showpage"); /* just in case */    } else { 9       fprintf(stderr, "%s: no %%%%BoundingBox:\n", prog);        exit(1);    }    exit(0);  } 