/*
  This is mf-math.c as of 16-September-1993
  Produced by Christian Spieler as a C replacement for MF-EXTRA.MAR for
  DEC Alpha AXP (Open VMS), where the Macro32 routines do not compile
  correctly. Comparison of the generated code from the C version with
  the macro64 code from the Macro32 compiler seems to indicate, that
  the C version is better optimized for the Alpha architecture. Therefore,
  it one might continue to use this C version even when the EDIV bug
  of the Macro32 compiler gets fixed in the future.
  

  Composed of routines contributed by John Lavagnino (Brandeis University)
  and Ned Freed (Innosoft International)
        .TITLE  MF_EXTRA    Math functions and extra routines for MF
        .IDENT  /1.0/
 
        If not replaced, the standard versions of these functions account
        for over 30% of the processing time used by METAFONT. These
        assembly-language versions are much faster because they can use
        extended-precision arithmetic to make the calculations directly,
        rather than by the iterative method used for portability in
        standard METAFONT.

        function makefraction(p, q: integer): fraction;
                { Calculate the function floor( (p * 2^28) / q + 0.5 )  }
                { if both p and q are positive.  If not, then the value }
                { of makefraction is calculated as though both *were*   }
                { positive, then the result sign adjusted.              }
                { (e.g. makefraction ALWAYS rounds away from zero)      }
                { In case of an overflow, return the largest possible   }
                { value (2^31-1) with the correct sign, and set global  }
                { variable "aritherror" to 1.  Note that -2^31 is       }
                { considered to be an illegal product for this type of  }
                { arithmetic!                                           }

        function makescaled(p, q: integer): scaled;
                { Calculate the function floor( (p * 2^16) / q + 0.5 )  }
                { Rounding same as in makefraction().                   }

        function takefraction(q: integer  f: fraction): integer;
                { Calculate the function floor( (q * f) / 2^28 + 0.5 )  }
                { Rounding same as in makefraction().                   }

        function takescaled(q: integer  f: scaled): integer;
                { Calculate the function floor( (q * f) / 2^16 + 0.5 )  }
                { Rounding same as in makefraction().                   }


     Passes the TRAP test, version of December 4, 1989, with MF 2.0 ---
   though that test doesn't claim to exercise these fully.  Also checked
   by generating a few CM fonts and comparing them with output from the
   unmodified program  and by comparison with the results of a C
   version of the standard routines on several million random pairs of
   integers.
  
   John Lavagnino, Department of English, Brandeis University, June 1990.
 */


#if defined (__ALPHA) && __ALPHA

#include <stddef.h>
#include <limits.h>
#include <ints.h>

 
#ifdef TRUE
#undef TRUE
#endif
#define TRUE	1			/* value for aritherror */
 
#define EL_GORDO	0x7fffffff	/* 2^31-1 */
#define FRACTION_ONE	0x10000000	/* 2^28 */
#define UNITY		0x10000		/* 2^16 */
 

typedef long	fraction;
typedef long	scaled;

extern int aritherror;		/* set on overflow */

extern fraction makefraction (long *p, long *q);
extern scaled makescaled (long *p, long *q);
extern long takefraction (long *q, fraction *f);
extern long takescaled (long *q, scaled *f);

#define DOCALC(arg1,arg2,arg3)						\
    divident = ((uint64) (arg2)) * ((uint64) (arg3));			\
    result = divident / ((uint64) (arg1));				\
    if ( ((divident - (result * (uint64) (arg1))) << 1)			\
	 >= (uint64) (arg1))						\
      ++result;								\
    if (result > EL_GORDO)						\
      {									\
      	aritherror = TRUE;						\
      	result = EL_GORDO;						\
      }
    

fraction
makefraction (long *p, long *q)
{
  long numer = *p;
  long denom = *q;
  uint64 divident, result;
  int negate = 0;
  
  if (numer < 0)
    {
      numer = -numer;
      negate = !negate;
    }
  if (denom < 0)
    {
      denom = -denom;
      negate = !negate;
    }

  DOCALC (denom, numer, FRACTION_ONE);

  return (fraction) (negate ? -result : result);
}

scaled
makescaled (long *p, long *q)
{
  long numer = *p;
  long denom = *q;
  uint64 divident, result;
  int negate = 0;
  
  if (numer < 0)
    {
      numer = -numer;
      negate = !negate;
    }
  if (denom < 0)
    {
      denom = -denom;
      negate = !negate;
    }

  DOCALC (denom, numer, UNITY); 

  return (scaled) (negate ? -result : result);
}

long
takefraction (long *q, fraction *f)
{
  long divisor = *q;
  fraction frac = *f;
  uint64 divident, result;
  int negate = 0;
  
  if (divisor < 0)
    {
      divisor = -divisor;
      negate = !negate;
    }
  if (frac < 0)
    {
      frac = -frac;
      negate = !negate;
    }

  DOCALC (FRACTION_ONE, divisor, frac); 

  return (long) (negate ? -result : result);
}

long
takescaled (long *q, scaled *f)
{
  long divisor = *q;
  scaled frac = *f;
  uint64 divident, result;
  int negate = 0;
  
  if (divisor < 0)
    {
      divisor = -divisor;
      negate = !negate;
    }
  if (frac < 0)
    {
      frac = -frac;
      negate = !negate;
    }

  DOCALC (UNITY, divisor, frac); 

  return (long) (negate ? -result : result);
}

#else /* not __ALPHA */

assert "You loose, this code is specific for DEC C AXP under OpenVMS!!!"

#endif /* ? __ALPHA */
