#
# This is the DESCRIP.MMS that we use at RMCS for building TeXware 
# automatically.  It normally resides in [TEX.SOURCES.TEXWARE], along with all
# the .WEB and .CH files for WEAVE, TEX, etc.
#
! I've added some annotation so that you might be able to follow how MMS uses
! the file, and what effects it has.
! Note that comments can be introduced by ! or by #, but the latter can only
# introduce a comment if it appears in column 1.
#
#
! This creates a MMS symbol, similar in concept to a DCL symbol.  All such
! assignments always take place; there's no concept of `program flow' 
! governing their execution.  Such symbols get expanded and substituted by
! being enclosed between $( and ).

CWSO	    =	IF NO_LOGICALS THEN $ WRITE SYS$OUTPUT

# .FIRST introduces a series of actions that will be obeyed once (and only
# once) if MMS decides that a target needs updating.  The action lines will
# then be obeyed before any of the action lines involved in updating that
# (or any subsequent) target.
#
# In this instance we use them to ensure that a couple of logical names, which
# get referenced in various dependency rules, have been defined before those
# rules get applied.  Since the rules will already have been applied without 
# the logical name definitions, this section terminates MMS abnormally.
#
# The action lines themselves consist of DCL commands, which are executed in
# the context of a subprocess.  Only one subprocess gets created each time
# MMS is invoked, and the necessary commands into, and responses out of, the
# subprocess are passed through a mailbox.
#
# The prefix @ before the DCL command prevents it being echoed to the
# screen when it is obeyed.
.FIRST
    @ SET COMMAND TEX.TEST_CLD
    @ NO_LOGICALS = "N"
    @ IF F$TRNLNM("TEX$NEWEXE") .EQS. "" THEN $ NO_LOGICALS = "Y"
    @ IF F$TRNLNM("TEX$NEWFORMATS") .EQS. "" THEN $ NO_LOGICALS = "Y"
    @ $(CWSO) "Logical names necessary to the execution of MMS are not"
    @ $(CWSO) "defined.  MMS will therefore now define them, but it will"
    @ $(CWSO) "be necessary to crash out of MMS.  Please then re-activate"
    @ $(CWSO) "MMS manually."
    @ CURRENT_DIRECTORY = F$PARSE("SYS$DISK:[]")-".;"
    @ IF NO_LOGICALS THEN -
      $DEFINE/JOB TEX$NEWFORMATS  'CURRENT_DIRECTORY',-
                                  'F$TRNLNM("TEX$FORMATS")
    @ IF NO_LOGICALS THEN -
       $DEFINE/JOB TEX$NEWEXE     'CURRENT_DIRECTORY',-
                                  'F$TRNLNM("TEX$EXE")
    @ $(CWSO) "Causing deliberate exit..."
    @ IF NO_LOGICALS THEN $ STOP
	
#
############################################################################
# Here's some more symbols.  By default, the Pascal compiler applies PFLAGS
# as a qualifier, and similarly with LINK and LINKFLAGS.  By defining these
# as DCL symbols before MMS is invoked, and telling the latter (by use of the
# /OVERRIDE qualifier) to use DCL symbols in preference to MMS ones, we can,
# for example, compile and link with /DEBUG, etc.
#
# The target_list_n symbols provide a convenient way to make (and list) a
# number of different targets.
############################################################################
PFLAGS		=	/NODEBUG/OPTIM/CHECK=OVERFLOW/LIST/SHOW=(NONE,STAT)
LINKFLAGS	=	/NODEBUG/NOTRACEBACK/SYSSHARE
WSO		=	WRITE SYS$OUTPUT
WCF		=	WRITE COMMAND_FILE
exe_dir		=	TEX$EXE:
pool_dir	=	TEX$FORMATS:
format_dir	=	TEX$FORMATS:

target_list_1	= tex, initex, trip_initex, bigtex, biginitex, big_trip
target_list_2	= tangle, weave, dvitype, pltotf, tftopl, pooltype
target_list_3	= tex.ln3, bigtex.ln3, weave.ln3, tangle.ln3, dvitype.ln3
target_list_4	= pooltype.ln3, pltotf.ln3, tftopl.ln3, profile.ln3
target_list_5	= plain, lplain, mzlplain, splain
target_list_6   = big_plain, big_lplain, big_mzlplain, big_splain

#
############################################################################
# The next line makes MMS forget about any preconceptions it may have 
# regarding the order in which rules shall be applied, and the one after that
# tells it a new order of preference.
############################################################################
.SUFFIXES	:	;
.SUFFIXES	:	.exe .obj .pas .c .ln3 .dvi .tex .web .ch

# Here is an example of a default rule: is says that, given a file ending in
# .DVI, then a .LN3 file can be generated from it by applyin the (DCL) action
# lines that follow it.  The prefix - tells MMS to ignore any warnings or
# errors that may be given by DVILN03.  
.dvi.ln3
	- DVILN03 $(MMS$SOURCE)
	@ SOURCE = F$SEARCH("$(MMS$TARGET)")
	@ CREATED = F$FILE_ATTRIBUTES(SOURCE,"CDT")
	@ $(WSO) "$(MMS$TARGET) built at ''F$TIME()'."
	@ $(WSO) "(in file ''SOURCE',"
	@ $(WSO) "         created at ''CREATED')"
	@ $(WSO) " "

# Another default transformation.  Shan't bother to tell you about any more
# of these.
.tex.dvi
	TEX /BATCH $(MMS$SOURCE) 

.pas.obj
	PASCAL $(PFLAGS) $(MMS$SOURCE)
	@ LIST_FILE==F$PARSE(".LIS",,"$(MMS$SOURCE)")
	@- TYPE 'LIST_FILE
	- DELETE/LOG 'LIST_FILE'*

.c.obj
	CC/NODEBUG $(MMS$SOURCE)

#
############################################################################
# This rule tells MMS what to do if it is invoked without any list of targets.
# We just tell the user what he/she COULD do.
############################################################################
default	:
	@ $(WSO) "You must specify which target to make. Valid targets are:"
	@ $(WSO) " "
	@ $(WSO) "Programs:"
	@ $(WSO) "    $(target_list_1)"
	@ $(WSO) "    $(target_list_2)"
	@ $(WSO) " "
	@ $(WSO) "Documentation: "
	@ $(WSO) "    $(target_list_3)"
	@ $(WSO) "    $(target_list_4)"
	@ $(WSO) " "
	@ $(WSO) "Dumped Format files"
	@ $(WSO) "    FORMATS, $(target_list_5)"
	@ $(WSO) "    BIGFORMATS, $(target_list_6)"
	@ $(WSO) " "
	@ $(WSO) "EXES                  - make all executables"
	@ $(WSO) "DOCS                  - make all .LN3 files"
	@ $(WSO) "PRINTDOCS             - print and delete any .LN3 files"
	@ $(WSO) "ALLFORMATS            - make all .FMT files"
	@ $(WSO) "INSTALL               - move executables to $(exe_dir)"
	@ $(WSO) "                        and formats to $(format_dir)"
	@ $(WSO) "CLEAN                 - delete all rebuildable files"

#
############################################################################
# These are the actions to be performed if the `target' is the word 
# ``install''.  We move files to directories as appropriate.
############################################################################
install :
	@ IF F$SEARCH("*.EXE;-1") .NES. "" THEN $ PURGE/LOG *.EXE
	@ IF F$SEARCH("*.FMT;-1") .NES. "" THEN $ PURGE/LOG *.FMT
	@ IF F$SEARCH("*.POO*;-1") .NES. "" THEN $ PURGE/LOG *.POO*
	@ IF F$SEARCH("*.INITEX_LIS;-1") .NES. "" THEN $ PURGE/LOG *.INITEX_LIS
	@ IF F$SEARCH("*.EXE") .NES. "" THEN -
	    $ RENAME/LOG *.EXE; $(exe_dir)*.*;0
	@ IF F$SEARCH("*.POO*") .NES. "" THEN -
	    $ RENAME/LOG *.POO*; $(pool_dir)*.*;0
	@ IF F$SEARCH("*.FMT") .NES. "" THEN -
	    $ RENAME/LOG *.FMT; $(format_dir)*.*;0
	@ IF F$SEARCH("*.INITEX_LIS") .NES. "" THEN -
	    $ RENAME/LOG *.INITEX_LIS; $(format_dir)*.*;0

#
############################################################################
# And here's another target to get rid of anything that can be regenerated.
############################################################################
clean :
	@ PURGE/LOG
	@ IF F$SEARCH("*_*.CH") .NES. "" THEN $ DELETE/LOG *_*.CH;*
	@ IF F$SEARCH("BIGTEX.CH") .NES. "" THEN $ DELETE/LOG BIGTEX.CH;*
	@ IF F$SEARCH("INITEX.CH") .NES. "" THEN $ DELETE/LOG INITEX.CH;*
	@ IF F$SEARCH("BIGINITEX.CH") .NES. "" THEN $ DELETE/LOG BIGINITEX.CH;*
	@ IF F$SEARCH("*.TEX") .NES. "" THEN $ DELETE/LOG *.TEX;*
	@ IF F$SEARCH("*.DVI") .NES. "" THEN $ DELETE/LOG *.DVI;*
	@ IF F$SEARCH("*.LN3") .NES. "" THEN $ DELETE/LOG *.LN3;*
	@ IF F$SEARCH("*.PAS") .NES. "" THEN $ DELETE/LOG *.PAS;*
	@ IF F$SEARCH("*.OBJ") .NES. "" THEN $ DELETE/LOG *.OBJ;*
	@ IF F$SEARCH("*.EXE") .NES. "" THEN $ DELETE/LOG *.EXE;*
	@ IF F$SEARCH("*.POO*") .NES. "" THEN $ DELETE/LOG *.POO*;*
	@ IF F$SEARCH("*.TYP") .NES. "" THEN $ DELETE/LOG *.TYP;*
	@ IF F$SEARCH("*.LIS") .NES. "" THEN $ DELETE/LOG *.LIS;*
	@ IF F$SEARCH("MAKE_*_FMT.COM") .NES. "" THEN $ DELETE/LOG MAKE_*_FMT.COM;*

	
#
############################################################################
############################################################################
PRINTDOCS :
	@ IF F$SEARCH("*.LN3") .NES. "" THEN -
	    $ TEXPRINT */DELETE/NOTIFY
	    
#
############################################################################
# Note here that we are using the mnemonic DEPENDS_ON instead of ` : '.  The
# latter form must be used where there is a null dependency (as in clean : 
# above).  However, the form used here is more visible.  What this rule says
# is that to build the target `EXES', we have to have built everything in
# the target_list_1 and target_list_2.
############################################################################
exes		DEPENDS_ON	$(target_list_1) $(target_list_2)
	@ $(WSO) "$(MMS$TARGET_NAME) built at ''F$TIME()'."
	@ $(WSO) " "

#
############################################################################
# Similarly to build the documentation.
############################################################################
docs		DEPENDS_ON	$(target_list_3) $(target_list_4)
	@ $(WSO) "$(MMS$TARGET_NAME) built at ''F$TIME()'."
	@ $(WSO) " "

#
############################################################################
# Here's where we can go ahead and build all the FMT files, or just those
# for TeX or BigTeX.
############################################################################
ALLFORMATS	DEPENDS_ON	$(target_list_5) $(target_list_6)
	@ $(WSO) "$(MMS$TARGET_NAME) built at ''F$TIME()'."
	@ $(WSO) " "

FORMATS		DEPENDS_ON	$(target_list_5)
	@ $(WSO) "$(MMS$TARGET_NAME) built at ''F$TIME()'."
	@ $(WSO) " "

BIGFORMATS	DEPENDS_ON	$(target_list_6)
	@ $(WSO) "$(MMS$TARGET_NAME) built at ''F$TIME()'."
	@ $(WSO) " "

#
############################################################################
# If the user asks for target TANGLE, MMS checks to see whether the file
# TEX$NEWEXE:TANGLE.EXE is up to date.  If there isn't one in this directory,
# it's going to check the date of that in TEX$EXE.
############################################################################
tangle		DEPENDS_ON	TEX$NEWEXE:tangle.exe
	@ SOURCE = F$SEARCH("$(MMS$SOURCE)")
	@ CREATED = F$FILE_ATTRIBUTES(SOURCE,"CDT")
	@ $(WSO) "$(MMS$TARGET_NAME) built at ''F$TIME()'."
	@ $(WSO) "(in file ''SOURCE',"
	@ $(WSO) "         created at ''CREATED')"
	@ $(WSO) " "

# Similarly for WEAVE and the rest.
#
weave		DEPENDS_ON	TEX$NEWEXE:weave.exe
	@ SOURCE = F$SEARCH("$(MMS$SOURCE)")
	@ CREATED = F$FILE_ATTRIBUTES(SOURCE,"CDT")
	@ $(WSO) "$(MMS$TARGET_NAME) built at ''F$TIME()'."
	@ $(WSO) "(in file ''SOURCE',"
	@ $(WSO) "         created at ''CREATED')"
	@ $(WSO) " "

initex		DEPENDS_ON	TEX$NEWEXE:initex.exe
	@ SOURCE = F$SEARCH("$(MMS$SOURCE)")
	@ CREATED = F$FILE_ATTRIBUTES(SOURCE,"CDT")
	@ $(WSO) "$(MMS$TARGET_NAME) built at ''F$TIME()'."
	@ $(WSO) "(in file ''SOURCE',"
	@ $(WSO) "         created at ''CREATED')"
	@ $(WSO) " "

trip_initex	DEPENDS_ON	TEX$NEWEXE:trip_initex.exe
	@ SOURCE = F$SEARCH("$(MMS$SOURCE)")
	@ CREATED = F$FILE_ATTRIBUTES(SOURCE,"CDT")
	@ $(WSO) "$(MMS$TARGET_NAME) built at ''F$TIME()'."
	@ $(WSO) "(in file ''SOURCE',"
	@ $(WSO) "         created at ''CREATED')"
	@ $(WSO) " "

big_trip	DEPENDS_ON	TEX$NEWEXE:big_trip.exe
	@ SOURCE = F$SEARCH("$(MMS$SOURCE)")
	@ CREATED = F$FILE_ATTRIBUTES(SOURCE,"CDT")
	@ $(WSO) "$(MMS$TARGET_NAME) built at ''F$TIME()'."
	@ $(WSO) "(in file ''SOURCE',"
	@ $(WSO) "         created at ''CREATED')"
	@ $(WSO) " "

tex		DEPENDS_ON	TEX$NEWEXE:tex.exe
	@ SOURCE = F$SEARCH("$(MMS$SOURCE)")
	@ CREATED = F$FILE_ATTRIBUTES(SOURCE,"CDT")
	@ $(WSO) "$(MMS$TARGET_NAME) built at ''F$TIME()'."
	@ $(WSO) "(in file ''SOURCE',"
	@ $(WSO) "         created at ''CREATED')"
	@ $(WSO) " "

bigtex		DEPENDS_ON	TEX$NEWEXE:bigtex.exe
	@ SOURCE = F$SEARCH("$(MMS$SOURCE)")
	@ CREATED = F$FILE_ATTRIBUTES(SOURCE,"CDT")
	@ $(WSO) "$(MMS$TARGET_NAME) built at ''F$TIME()'."
	@ $(WSO) "(in file ''SOURCE',"
	@ $(WSO) "         created at ''CREATED')"
	@ $(WSO) " "

biginitex	DEPENDS_ON	TEX$NEWEXE:biginitex.exe
	@ SOURCE = F$SEARCH("$(MMS$SOURCE)")
	@ CREATED = F$FILE_ATTRIBUTES(SOURCE,"CDT")
	@ $(WSO) "$(MMS$TARGET_NAME) built at ''F$TIME()'."
	@ $(WSO) "(in file ''SOURCE',"
	@ $(WSO) "         created at ''CREATED')"
	@ $(WSO) " "

dvitype		DEPENDS_ON	TEX$NEWEXE:dvitype.exe
	@ SOURCE = F$SEARCH("$(MMS$SOURCE)")
	@ CREATED = F$FILE_ATTRIBUTES(SOURCE,"CDT")
	@ $(WSO) "$(MMS$TARGET_NAME) built at ''F$TIME()'."
	@ $(WSO) "(in file ''SOURCE',"
	@ $(WSO) "         created at ''CREATED')"
	@ $(WSO) " "

pltotf		DEPENDS_ON	TEX$NEWEXE:pltotf.exe
	@ SOURCE = F$SEARCH("$(MMS$SOURCE)")
	@ CREATED = F$FILE_ATTRIBUTES(SOURCE,"CDT")
	@ $(WSO) "$(MMS$TARGET_NAME) built at ''F$TIME()'."
	@ $(WSO) "(in file ''SOURCE',"
	@ $(WSO) "         created at ''CREATED')"
	@ $(WSO) " "

tftopl		DEPENDS_ON	TEX$NEWEXE:tftopl.exe
	@ SOURCE = F$SEARCH("$(MMS$SOURCE)")
	@ CREATED = F$FILE_ATTRIBUTES(SOURCE,"CDT")
	@ $(WSO) "$(MMS$TARGET_NAME) built at ''F$TIME()'."
	@ $(WSO) "(in file ''SOURCE',"
	@ $(WSO) "         created at ''CREATED')"
	@ $(WSO) " "

pooltype		DEPENDS_ON	TEX$NEWEXE:pooltype.exe
	@ SOURCE = F$SEARCH("$(MMS$SOURCE)")
	@ CREATED = F$FILE_ATTRIBUTES(SOURCE,"CDT")
	@ $(WSO) "$(MMS$TARGET_NAME) built at ''F$TIME()'."
	@ $(WSO) "(in file ''SOURCE',"
	@ $(WSO) "         created at ''CREATED')"
	@ $(WSO) " "

#
############################################################################
# This rule is for building the WMERGE utility, which is used to make
# change files for IniTeX etc from the master TeX.ch
############################################################################
wmerge		DEPENDS_ON	TEX$NEWEXE:wmerge.EXE
	@ SOURCE = F$SEARCH("$(MMS$SOURCE)")
	@ CREATED = F$FILE_ATTRIBUTES(SOURCE,"CDT")
	@ $(WSO) "$(MMS$TARGET_NAME) built at ''F$TIME()'."
	@ $(WSO) "(in file ''SOURCE',"
	@ $(WSO) "         created at ''CREATED')"
	@ $(WSO) " "

#
############################################################################
# Now we introduce a dependency such that if TEX$NEWEXE:TEX.EXE is older than
# TEX.OBJ (in this directory) then the action rule will be obeyed to link it.
############################################################################
TEX$NEWEXE:tex.exe	    DEPENDS_ON	tex.obj
	LINK $(LINKFLAGS) tex.obj

TEX$NEWEXE:initex.exe	    DEPENDS_ON	initex.obj
	LINK $(LINKFLAGS) initex.obj

TEX$NEWEXE:bigtex.exe	    DEPENDS_ON	bigtex.obj
	LINK $(LINKFLAGS) bigtex.obj

TEX$NEWEXE:biginitex.exe    DEPENDS_ON	biginitex.obj
	LINK $(LINKFLAGS) biginitex.obj

TEX$NEWEXE:trip_initex.exe  DEPENDS_ON	trip_initex.obj
	LINK $(LINKFLAGS) trip_initex.obj

TEX$NEWEXE:big_trip.exe  DEPENDS_ON	big_trip.obj
	LINK $(LINKFLAGS) big_trip.obj

TEX$NEWEXE:weave.exe	DEPENDS_ON  weave.obj
	LINK $(LINKFLAGS) weave.obj
	
TEX$NEWEXE:tangle.exe	DEPENDS_ON  tangle.obj
	LINK $(LINKFLAGS) tangle.obj
	
TEX$NEWEXE:dvitype.exe	DEPENDS_ON  dvitype.obj
	LINK $(LINKFLAGS) dvitype.obj
	
TEX$NEWEXE:pltotf.exe	DEPENDS_ON  pltotf.obj
	LINK $(LINKFLAGS) pltotf.obj
	
TEX$NEWEXE:tftopl.exe	DEPENDS_ON  tftopl.obj
	LINK $(LINKFLAGS) tftopl.obj
	
TEX$NEWEXE:pooltype.exe	DEPENDS_ON  pooltype.obj
	LINK $(LINKFLAGS) pooltype.obj
	
TEX$NEWEXE:wmerge.exe	DEPENDS_ON	wmerge.obj,wmerge_link_options.opt
	LINK $(LINKFLAGS) wmerge.obj,WMERGE_LINK_OPTIONS.OPT/OPTION

#
##############################################################################
# This rule used to be needed to generate TEX_LINK_OPTIONS.OPT if it didn't
# already exist; this was required to link LSESHR with the image for TeX, but
# is now redundant because TeX links the image at run-time if necessary.
##############################################################################
tex_link_options.opt :
	OPEN/WRITE tlo_file TEX_LINK_OPTIONS.OPT
	WRITE tlo_file "SYS$SHARE:LSESHR.EXE/SHAREABLE"
	CLOSE tlo_file
#
############################################################################
# This creates the options for linking to the VAX-C RTL
############################################################################
wmerge_link_options.opt :
	OPEN/WRITE wlo_file WMERGE_LINK_OPTIONS.OPT
	WRITE wlo_file "SYS$SHARE:VAXCRTL.EXE/SHAREABLE"
	CLOSE wlo_file
#
############################################################################
# Now we say how to make the .PAS sources from the .WEB and .CH.  If either
# of the latter files has been revised since the .PAS was created (or always,
# if the latter doesn't exist), then the action rules will be obeyed to 
# generate a new .PAS (and .POOL, where appropriate).  
############################################################################

weave.pas	DEPENDS_ON	weave.web  weave.ch
	TANGLE weave

tangle.pas	DEPENDS_ON	tangle.web  tangle.ch
	TANGLE tangle

dvitype.pas	DEPENDS_ON	dvitype.web  dvitype.ch
	TANGLE dvitype

pltotf.pas	DEPENDS_ON	pltotf.web  pltotf.ch
	TANGLE pltotf

tftopl.pas	DEPENDS_ON	tftopl.web  tftopl.ch
	TANGLE tftopl

pooltype.pas	DEPENDS_ON	pooltype.web  pooltype.ch
	TANGLE pooltype

#
##############################################################################
# Here, because we cannot provide TANGLE with file names interactively, we
# ensure that INITEX.WEB exists (by entering the file as a synonym for TEX.WEB)
# before invoking TANGLE, and remove the synonym afterwards.  Similarly for
# all the other variants, which all get built from the same TEX.WEB but using
# different change files.
##############################################################################

initex.pas	DEPENDS_ON	tex.web  initex.ch
	SET FILE/ENTER=initex.web tex.web
	- TANGLE initex
	SET FILE/REMOVE initex.web;*
	DELETE/LOG initex.poo*;

biginitex.pas	DEPENDS_ON	tex.web  biginitex.ch
	SET FILE/ENTER=biginitex.web tex.web
	- TANGLE biginitex
	SET FILE/REMOVE biginitex.web;*
	DELETE/LOG biginitex.poo*;

trip_initex.pas	DEPENDS_ON	tex.web  trip_initex.ch
	SET FILE/ENTER=trip_initex.web tex.web
	- TANGLE trip_initex
	SET FILE/REMOVE trip_initex.web;*
	DELETE/LOG trip_initex.poo*;

big_trip.pas	DEPENDS_ON	tex.web  big_trip.ch
	SET FILE/ENTER=big_trip.web tex.web
	- TANGLE big_trip
	SET FILE/REMOVE big_trip.web;*
	DELETE/LOG big_trip.poo*;

tex.pas		DEPENDS_ON	tex.web  tex.ch
	TANGLE tex

bigtex.pas	DEPENDS_ON	tex.web  bigtex.ch
	SET FILE/ENTER=bigtex.web tex.web
	- TANGLE bigtex
	SET FILE/REMOVE bigtex.web;*
	DELETE/LOG bigtex.poo*;

#
############################################################################
# Here's where we make use of a program called WEBMERGE (which I can let you
# have, if you'd prefer to adopt this approach).  We use this to make the
# change files for the various variants by applying changes to the master
# changefile TEX.CH.
############################################################################
initex.ch	DEPENDS_ON	tex.ch tex-initex.ch wmerge
	DEFINE/USER_MODE TEX$EXE TEX$NEWEXE
	@TEX$COM:WEBMERGE tex.ch tex-initex
	PURGE tex.merged
	RENAME/LOG tex.merged initex.ch

trip_initex.ch	DEPENDS_ON	tex.ch tex-trip.ch wmerge
	DEFINE/USER_MODE TEX$EXE TEX$NEWEXE
	@TEX$COM:WEBMERGE tex.ch tex-trip
	PURGE tex.merged
	RENAME/LOG tex.merged trip_initex.ch

big_trip.ch	DEPENDS_ON	bigtex.ch big-trip.ch wmerge
	DEFINE/USER_MODE TEX$EXE TEX$NEWEXE
	@TEX$COM:WEBMERGE bigtex.ch big-trip
	PURGE bigtex.merged
	RENAME/LOG bigtex.merged big_trip.ch

bigtex.ch	DEPENDS_ON	tex.ch tex-bigtex.ch wmerge
	DEFINE/USER_MODE TEX$EXE TEX$NEWEXE
	@TEX$COM:WEBMERGE tex.ch tex-bigtex
	PURGE tex.merged
	RENAME/LOG tex.merged bigtex.ch
	
biginitex.ch	DEPENDS_ON	bigtex.ch tex-initex.ch wmerge
	DEFINE/USER_MODE TEX$EXE TEX$NEWEXE
	@TEX$COM:WEBMERGE bigtex.ch tex-initex
	PURGE bigtex.merged
	RENAME/LOG bigtex.merged biginitex.ch

#
############################################################################
# Here are the rules for producing a woven WEB.
############################################################################
weave.tex	DEPENDS_ON	weave.web  weave.ch
	WEAVE weave

tangle.tex	DEPENDS_ON	tangle.web  tangle.ch
	WEAVE tangle

dvitype.tex	DEPENDS_ON	dvitype.web  dvitype.ch
	WEAVE dvitype

pltotf.tex	DEPENDS_ON	pltotf.web  pltotf.ch
	WEAVE pltotf

tftopl.tex	DEPENDS_ON	tftopl.web  tftopl.ch
	WEAVE tftopl

profile.tex     DEPENDS_ON      profile.web profile.ch
        WEAVE profile

pooltype.tex	DEPENDS_ON	pooltype.web  pooltype.ch
	WEAVE pooltype

initex.tex	DEPENDS_ON	tex.web  initex.ch
	SET FILE/ENTER=initex.web tex.web
	WEAVE initex
	SET FILE/REMOVE initex.web;

tex.tex		DEPENDS_ON	tex.web  tex.ch
	WEAVE tex

bigtex.tex	DEPENDS_ON	tex.web  bigtex.ch
	SET FILE/ENTER=bigtex.web tex.web
	WEAVE bigtex
	SET FILE/REMOVE bigtex.web;

#
############################################################################
# Now for the mind-blowing bit: generating the .FMT files.  We start by 
# telling MMS upon what .FMT file it's going to check the date.  Note that
# if we haven't made any in this directory, it'll look at the old ones in
# TEX$FORMATS.  If these pre-date the TEX.EXE and INITEX.EXE images, then
# we're going to have to use INITEX and dump the revised format files.
############################################################################
plain		DEPENDS_ON	TEX$NEWFORMATS:plain.fmt
	@ SOURCE = F$SEARCH("$(MMS$SOURCE)")
	@ CREATED = F$FILE_ATTRIBUTES(SOURCE,"CDT")
	@ $(WSO) "$(MMS$TARGET_NAME) built at ''F$TIME()'."
	@ $(WSO) "(in file ''SOURCE',"
	@ $(WSO) "         created at ''CREATED')"
	@ $(WSO) " "

lplain		DEPENDS_ON	TEX$NEWFORMATS:lplain.fmt
	@ SOURCE = F$SEARCH("$(MMS$SOURCE)")
	@ CREATED = F$FILE_ATTRIBUTES(SOURCE,"CDT")
	@ $(WSO) "$(MMS$TARGET_NAME) built at ''F$TIME()'."
	@ $(WSO) "(in file ''SOURCE',"
	@ $(WSO) "         created at ''CREATED')"
	@ $(WSO) " "

mzlplain	DEPENDS_ON	TEX$NEWFORMATS:mzlplain.fmt
	@ SOURCE = F$SEARCH("$(MMS$SOURCE)")
	@ CREATED = F$FILE_ATTRIBUTES(SOURCE,"CDT")
	@ $(WSO) "$(MMS$TARGET_NAME) built at ''F$TIME()'."
	@ $(WSO) "(in file ''SOURCE',"
	@ $(WSO) "         created at ''CREATED')"
	@ $(WSO) " "

splain		DEPENDS_ON	TEX$NEWFORMATS:splain.fmt
	@ SOURCE = F$SEARCH("$(MMS$SOURCE)")
	@ CREATED = F$FILE_ATTRIBUTES(SOURCE,"CDT")
	@ $(WSO) "$(MMS$TARGET_NAME) built at ''F$TIME()'."
	@ $(WSO) "(in file ''SOURCE',"
	@ $(WSO) "         created at ''CREATED')"
	@ $(WSO) " "

big_plain	DEPENDS_ON	TEX$NEWFORMATS:big_plain.fmt
	@ SOURCE = F$SEARCH("$(MMS$SOURCE)")
	@ CREATED = F$FILE_ATTRIBUTES(SOURCE,"CDT")
	@ $(WSO) "$(MMS$TARGET_NAME) built at ''F$TIME()'."
	@ $(WSO) "(in file ''SOURCE',"
	@ $(WSO) "         created at ''CREATED')"
	@ $(WSO) " "

big_lplain	DEPENDS_ON	TEX$NEWFORMATS:big_lplain.fmt
	@ SOURCE = F$SEARCH("$(MMS$SOURCE)")
	@ CREATED = F$FILE_ATTRIBUTES(SOURCE,"CDT")
	@ $(WSO) "$(MMS$TARGET_NAME) built at ''F$TIME()'."
	@ $(WSO) "(in file ''SOURCE',"
	@ $(WSO) "         created at ''CREATED')"
	@ $(WSO) " "

big_mzlplain	DEPENDS_ON	TEX$NEWFORMATS:big_mzlplain.fmt
	@ SOURCE = F$SEARCH("$(MMS$SOURCE)")
	@ CREATED = F$FILE_ATTRIBUTES(SOURCE,"CDT")
	@ $(WSO) "$(MMS$TARGET_NAME) built at ''F$TIME()'."
	@ $(WSO) "(in file ''SOURCE',"
	@ $(WSO) "         created at ''CREATED')"
	@ $(WSO) " "

big_splain	DEPENDS_ON	TEX$NEWFORMATS:big_splain.fmt
	@ SOURCE = F$SEARCH("$(MMS$SOURCE)")
	@ CREATED = F$FILE_ATTRIBUTES(SOURCE,"CDT")
	@ $(WSO) "$(MMS$TARGET_NAME) built at ''F$TIME()'."
	@ $(WSO) "(in file ''SOURCE',"
	@ $(WSO) "         created at ''CREATED')"
	@ $(WSO) " "
#
##############################################################################
# This is the list of things that need to be compared with the date on the 
# existing .FMT file --- not just the sources of the format (which don't seem
# to change very often) but also if the .EXE files have been revised.  MMS is
# clever enough to go off and rebuild the EXEs at this point, if necessary, 
# if it hasn't already done so.
# The DEFINE/USER is so that INITEX.EXE, when it tries to read its pool file
# (from TEX$FORMATS.TEX.POOL) will get hold of the one that's been newly
# created by TANGLE in this directory, if the files haven't been moved to
# their target directories.
# We have to write out an appropriate DCL command procedure to do the work,
# because we have to fool INITEX into thinking it's getting its input 
# interactively.
##############################################################################

TEX$NEWFORMATS:plain.fmt	DEPENDS_ON	TEX$INPUTS:plain.tex -
				   TEX$INPUTS:hyphen.tex -
                                   TEX$NEWEXE:initex.exe TEX$NEWEXE:tex.exe
	OPEN/WRITE command_file MAKE_PLAIN_FMT.COM
	@ $(WCF) "$ DEFINE/USER_MODE TEX$FORMATS TEX$NEWFORMATS"
	@ $(WCF) "$ TEX/INITEX/LOG=.INITEX_LIS "
	@ $(WCF) "plain"
	@ $(WCF) "\dump"
	@ $(WCF) "$!--END OF MAKE_PLAIN_FMT.COM-------------------------------"
	CLOSE command_file
	@MAKE_PLAIN_FMT.COM
	DELETE MAKE_PLAIN_FMT.COM;*

#	
##############################################################################
# For LaTeX, we also redefine TEX$INPUTS, so that it will firstly look in 
# TEX$LATEX for lplain,lfonts and latex.tex, but also find hyphen.tex in
# TEX$INPUTS (the usual definition).
##############################################################################
TEX$NEWFORMATS:lplain.fmt	DEPENDS_ON	TEX$LATEX:lplain.tex -
				   TEX$INPUTS:hyphen.tex -
                                   TEX$LATEX:latex.tex -
				   TEX$LATEX:lfonts.tex -
                                   TEX$NEWEXE:initex.exe TEX$NEWEXE:tex.exe
	OPEN/WRITE command_file MAKE_LPLAIN_FMT.COM
	@ $(WCF) "$ DEFINE/USER_MODE TEX$FORMATS TEX$NEWFORMATS"
	@ $(WCF) "$ DEFINE/USER_MODE TEX$INPUTS ''F$TRNLNM(""TEX$INPUTS"")', -"
	@ $(WCF) "                              ''F$TRNLNM(""TEX$LATEX"")'"
	@ $(WCF) "$ TEX/INITEX/LOG=.INITEX_LIS "
	@ $(WCF) "lplain"
	@ $(WCF) "\dump"
	@ $(WCF) "$!--END OF MAKE_LPLAIN_FMT.COM------------------------------"
	CLOSE command_file
	@MAKE_LPLAIN_FMT.COM
	DELETE MAKE_LPLAIN_FMT.COM;*
#
##############################################################################
# And for this one (Mainz LPLAIN, for Schoepf & Mittelbach's new font coding
# scheme) we need to find files in any of three different directories.  Aren't
# DEC's search lists wonderful?
##############################################################################
	
TEX$NEWFORMATS:mzlplain.fmt	DEPENDS_ON	TEX$LATEX:lplain.tex -
		       TEX$INPUTS:hyphen.tex -
                       TEX$DISK:[TEX.LATEX.MITTELBACH]mzlplain.tex -
                       TEX$DISK:[TEX.LATEX.MITTELBACH]lfonts.tex -
                       TEX$DISK:[TEX.LATEX.MITTELBACH]fam.tex -
                       TEX$DISK:[TEX.LATEX.MITTELBACH]fontdef.tex -
                       TEX$DISK:[TEX.LATEX.MITTELBACH]preload.tex -
                       TEX$DISK:[TEX.LATEX.MITTELBACH]setsize.tex -
                       TEX$DISK:[TEX.LATEX.MITTELBACH]XXXlfont.sty -
                       TEX$DISK:[TEX.LATEX.MITTELBACH]latint.tex -
		       TEX$LATEX:latex.tex -
                                   TEX$NEWEXE:initex.exe TEX$NEWEXE:tex.exe
	OPEN/WRITE command_file MAKE_MZLPLAIN_FMT.COM
	@ $(WCF) "$ DEFINE/USER_MODE TEX$FORMATS TEX$NEWFORMATS"
	@ $(WCF) "$ DEFINE/USER_MODE TEX$INPUTS ''F$TRNLNM(""TEX$INPUTS"")', -"
	@ $(WCF) "                TEX$DISK:[TEX.LATEX.MITTELBACH], -"
	@ $(WCF) "                              ''F$TRNLNM(""TEX$LATEX"")'"
	@ $(WCF) "$ TEX/INITEX/LOG=.INITEX_LIS "
	@ $(WCF) "mzlplain"
	@ $(WCF) "\dump"
	@ $(WCF) "$!--END OF MAKE_MZLPLAIN_FMT.COM------------------------------"
	CLOSE command_file
	@MAKE_MZLPLAIN_FMT.COM
	DELETE MAKE_MZLPLAIN_FMT.COM;*
	
TEX$NEWFORMATS:splain.fmt	DEPENDS_ON	TEX$LATEX:splain.tex -
				   TEX$INPUTS:hyphen.tex -
                                   TEX$LATEX:latex.tex -
				   TEX$LATEX:sfonts.tex -
				   TEX$LATEX:slitex.tex -
                                   TEX$NEWEXE:initex.exe TEX$NEWEXE:tex.exe
	OPEN/WRITE command_file MAKE_SPLAIN_FMT.COM
	@ $(WCF) "$ DEFINE/USER_MODE TEX$FORMATS TEX$NEWFORMATS"
	@ $(WCF) "$ DEFINE/USER_MODE TEX$INPUTS ''F$TRNLNM(""TEX$INPUTS"")', -"
	@ $(WCF) "                              ''F$TRNLNM(""TEX$LATEX"")'"
	@ $(WCF) "$ TEX/INITEX/LOG=.INITEX_LIS "
	@ $(WCF) "splain"
	@ $(WCF) "\dump"
	@ $(WCF) "$!--END OF MAKE_SPLAIN_FMT.COM-----------------------------"
	CLOSE command_file
	@MAKE_SPLAIN_FMT.COM
	DELETE MAKE_SPLAIN_FMT.COM;*
#
##############################################################################
# When it comes to using BigTeX, it will have different format files (because
# of the larger memeory sizes dumped), so we have to use the Big version of
# IniTeX in generating them.
##############################################################################
	
TEX$NEWFORMATS:big_plain.fmt	DEPENDS_ON	TEX$INPUTS:big_plain.tex -
                             TEX$INPUTS:plain.tex -
			     TEX$INPUTS:hyphen.tex -
                             TEX$NEWEXE:biginitex.exe TEX$NEWEXE:bigtex.exe
	OPEN/WRITE command_file MAKE_BIG_PLAIN_FMT.COM
	@ $(WCF) "$ DEFINE/USER_MODE TEX$FORMATS TEX$NEWFORMATS"
	@ $(WCF) "$ TEX/BIG/INITEX/LOG=.INITEX_LIS "
	@ $(WCF) "big_plain"
	@ $(WCF) "\dump"
	@ $(WCF) "$!--END OF MAKE_BIG_PLAIN_FMT.COM-------------------------------"
	CLOSE command_file
	@MAKE_BIG_PLAIN_FMT.COM
	DELETE MAKE_BIG_PLAIN_FMT.COM;*

TEX$INPUTS:big_plain.tex :
	OPEN/WRITE command_file TEX$INPUTS:BIG_PLAIN.TEX
	@ $(WCF) "\input plain"
	CLOSE command_file
	
TEX$NEWFORMATS:big_lplain.fmt	DEPENDS_ON	TEX$LATEX:big_lplain.tex -
                             TEX$LATEX:lplain.tex -
			     TEX$INPUTS:hyphen.tex -
			     TEX$LATEX:latex.tex -
			     TEX$LATEX:lfonts.tex -
                             TEX$NEWEXE:biginitex.exe TEX$NEWEXE:bigtex.exe
	OPEN/WRITE command_file MAKE_BIG_LPLAIN_FMT.COM
	@ $(WCF) "$ DEFINE/USER_MODE TEX$FORMATS TEX$NEWFORMATS"
	@ $(WCF) "$ DEFINE/USER_MODE TEX$INPUTS ''F$TRNLNM(""TEX$INPUTS"")', -"
	@ $(WCF) "                              ''F$TRNLNM(""TEX$LATEX"")'"
	@ $(WCF) "$ TEX/BIG/INITEX/LOG=.INITEX_LIS "
	@ $(WCF) "big_lplain"
	@ $(WCF) "\dump"
	@ $(WCF) "$!--END OF MAKE_BIG_LPLAIN_FMT.COM------------------------------"
	CLOSE command_file
	@MAKE_BIG_LPLAIN_FMT.COM
	DELETE MAKE_BIG_LPLAIN_FMT.COM;*
	
TEX$LATEX:big_lplain.tex :
	OPEN/WRITE command_file TEX$LATEX:BIG_LPLAIN.TEX
	@ $(WCF) "\input lplain"
	CLOSE command_file
	
TEX$NEWFORMATS:big_mzlplain.fmt	DEPENDS_ON	-
                       TEX$DISK:[TEX.LATEX.MITTELBACH]big_mzlplain.tex -
                       TEX$DISK:[TEX.LATEX.MITTELBACH]mzlplain.tex -
                       TEX$LATEX:lplain.tex -
		       TEX$INPUTS:hyphen.tex -
                       TEX$DISK:[TEX.LATEX.MITTELBACH]lfonts.tex -
                       TEX$DISK:[TEX.LATEX.MITTELBACH]fam.tex -
                       TEX$DISK:[TEX.LATEX.MITTELBACH]fontdef.tex -
                       TEX$DISK:[TEX.LATEX.MITTELBACH]preload.tex -
                       TEX$DISK:[TEX.LATEX.MITTELBACH]setsize.tex -
                       TEX$DISK:[TEX.LATEX.MITTELBACH]XXXlfont.sty -
                       TEX$DISK:[TEX.LATEX.MITTELBACH]latint.tex -
		       TEX$LATEX:latex.tex -
		       TEX$NEWEXE:biginitex.exe TEX$NEWEXE:bigtex.exe
	OPEN/WRITE command_file MAKE_BIGMZLPLAIN_FMT.COM
	@ $(WCF) "$ DEFINE/USER_MODE TEX$FORMATS TEX$NEWFORMATS"
	@ $(WCF) "$ DEFINE/USER_MODE TEX$INPUTS ''F$TRNLNM(""TEX$INPUTS"")', -"
	@ $(WCF) "                TEX$DISK:[TEX.LATEX.MITTELBACH], -"
	@ $(WCF) "                              ''F$TRNLNM(""TEX$LATEX"")'"
	@ $(WCF) "$ TEX/INITEX/LOG=.INITEX_LIS "
	@ $(WCF) "big_mzlplain"
	@ $(WCF) "\dump"
	@ $(WCF) "$!--END OF MAKE_BIGMZLPLAIN_FMT.COM------------------------------"
	CLOSE command_file
	@MAKE_BIGMZLPLAIN_FMT.COM
	DELETE MAKE_BIGMZLPLAIN_FMT.COM;*
	
TEX$DISK:[TEX.LATEX.MITTELBACH]big_mzlplain.tex :
	OPEN/WRITE command_file TEX$DISK:[TEX.LATEX.MITTELBACH]BIG_MZLPLAIN.TEX
	@ $(WCF) "\input mzlplain"
	CLOSE command_file
	
TEX$NEWFORMATS:big_splain.fmt	DEPENDS_ON	TEX$LATEX:big_splain.tex -
                             TEX$LATEX:splain.tex -
			     TEX$INPUTS:hyphen.tex -
			     TEX$LATEX:latex.tex -
			     TEX$LATEX:sfonts.tex -
			     TEX$LATEX:slitex.tex -
                             TEX$NEWEXE:biginitex.exe TEX$NEWEXE:bigtex.exe
	OPEN/WRITE command_file MAKE_BIG_SPLAIN_FMT.COM
	@ $(WCF) "$ DEFINE/USER_MODE TEX$FORMATS TEX$NEWFORMATS"
	@ $(WCF) "$ DEFINE/USER_MODE TEX$INPUTS ''F$TRNLNM(""TEX$INPUTS"")', -"
	@ $(WCF) "                              ''F$TRNLNM(""TEX$LATEX"")'"
	@ $(WCF) "$ TEX/BIG/INITEX/LOG=.INITEX_LIS "
	@ $(WCF) "big_splain"
	@ $(WCF) "\dump"
	@ $(WCF) "$!--END OF MAKE_BIG_SPLAIN_FMT.COM-----------------------------"
	CLOSE command_file
	@MAKE_BIG_SPLAIN_FMT.COM
	DELETE MAKE_BIG_SPLAIN_FMT.COM;*
	
TEX$LATEX:big_splain.tex :
	OPEN/WRITE command_file TEX$LATEX:BIG_SPLAIN.TEX
	@ $(WCF) "\input splain"
	CLOSE command_file
	
