/* WMERGE.C */

#define buf_size 100 \

#define max_include_depth 10 \

#define max_file_name_length 60
#define cur_file file[include_depth]
#define cur_file_name file_name[include_depth]
#define cur_line line[include_depth]
#define web_file file[0]
#define web_file_name file_name[0] \

#define lines_dont_match (change_limit-change_buffer!=limit-buffer|| \
strncmp(buffer,change_buffer,limit-buffer)) \

#define max_modules 2000 \
 \

#define spotless 0
#define harmless_message 1
#define error_message 2
#define fatal_message 3
#define mark_harmless {if(history==spotless)history= harmless_message;}
#define mark_error history= error_message \

#define fatal(s1,s2){ \
fprintf(stderr,s1);err_print(s2); \
history= fatal_message;wrap_up(); \
} \

#define confusion(s)fatal("! This can't happen: ",s) \
 \

#define overflow(s){ \
fprintf(stderr,"! Sorry, capacity exceeded: ");fatal("",s); \
} \
 \

#define update_terminal fflush(stdout) \


#include <stdio.h>
#if __STDC__ || defined (VMS) || defined (__VMS) || defined (MSDOS)
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#endif /* __STDC__ || ... */

typedef short   boolean;
typedef char unsigned eight_bits;
typedef char    ASCII;


ASCII           buffer[buf_size];
ASCII          *buffer_end = buffer + buf_size - 2;
ASCII          *limit;
ASCII          *loc;


int             include_depth;
FILE           *file[max_include_depth];
FILE           *change_file;
char            file_name[max_include_depth][max_file_name_length];

char            change_file_name[max_file_name_length];
int             line[max_include_depth];
int             change_line;
boolean         input_has_ended;
boolean         changing;


ASCII           change_buffer[buf_size];
ASCII          *change_limit;


typedef unsigned short sixteen_bits;
sixteen_bits    module_count;
boolean         changed_module[max_modules];
boolean         print_where = 0;


int             history = spotless;

void	prime_the_change_buffer ();
void	check_change ();
void	reset_input ();
void	put_line ();
void	check_complete ();
void	err_print ();
void	wrap_up ();
void	scan_args ();


int
input_ln (fp)
    FILE           *fp;
{
    register int    c;
    register ASCII *k;

    if (feof (fp))
	return (0);
    limit = k = buffer;
    while (k <= buffer_end && (c = getc (fp)) != EOF && c != '\n')
	if ((*(k++) = c) != ' ')
	    limit = k;
    if (k > buffer_end)
	if ((c = getc (fp)) != EOF && c != '\n')
	{
	    ungetc (c, fp);
	    loc = buffer;
	    err_print ("\n! Input line too long");

	}
    if (c == EOF && limit == buffer)
	return (0);

    return (1);
}

int next_is_xyz( c )
char *c;
{
  switch (*c)
  {
      case 'x':
      case 'y':
      case 'z':
      case 'X':
      case 'Y':
      case 'Z':
	  return 1;
      default:
	  return 0;
  }
}

void undouble_ats( b, n)
char *b, *n;
{
    char *k,*l;

    k = l = b;
    while (l <= n)
    {
	if ( (*k++ = *l++) == '@' )
	{
	    if (*l == '@')
	    {
		if ( (l < n) && next_is_xyz(l+1) )
		    l++;
	    }
	}
    }
    limit = k-1;
}  

void
prime_the_change_buffer ()
{
    change_limit = change_buffer;
    
    while (1)
    {
	change_line++;
	if (!input_ln (change_file))
	    return;
	if (limit < buffer + 2)
	    continue;
	if (buffer[0] != '@')
	    continue;
	
	if (buffer[1] >= 'X' && buffer[1] <= 'Z' || buffer[1] == 'I')
	    buffer[1] += 'z' - 'Z';

	;
	{
	    if (buffer[1] == 'i')
	    {
		loc = buffer + 2;
		err_print ("! No includes allowed in change file");

	    }
	}

	;
	if (buffer[1] == 'x')
	    break;
	if (buffer[1] == 'y' || buffer[1] == 'z')
	{
	    loc = buffer + 2;
	    err_print ("! Where is the matching @x?");

	}
    }

    ;

    do
    {
	change_line++;
	if (!input_ln (change_file))
	{
	    err_print ("! Change file ended after @x");

	    return;
	}
    } while (limit == buffer);

    ;

    {
	undouble_ats(buffer,limit);
	change_limit = change_buffer - buffer + limit;
	strncpy (change_buffer, buffer, limit - buffer + 1);
    }

    ;
}


void
check_change ()
{
    int             n = 0;

    if (lines_dont_match)
	return;
    while (1)
    {
	changing = 1;
	print_where = 1;
	change_line++;
	if (!input_ln (change_file))
	{
	    err_print ("! Change file ended before @y");

	    change_limit = change_buffer;
	    changing = 0;
	    print_where = 1;
	    return;
	}
	if (limit > buffer + 1 && buffer[0] == '@')
	{
	    if (buffer[1] == 'i')
	    {
		loc = buffer + 2;
		err_print ("! No includes allowed in change file");

	    }
	}
	;

	if (limit > buffer + 1 && buffer[0] == '@')
	{

	    if (buffer[1] >= 'X' && buffer[1] <= 'Z' || buffer[1] == 'I')
		buffer[1] += 'z' - 'Z';

	    ;
	    if (buffer[1] == 'x' || buffer[1] == 'z')
	    {
		loc = buffer + 2;
		err_print ("! Where is the matching @y?");

	    } else if (buffer[1] == 'y')
	    {
		if (n > 0)
		{
		    loc = buffer + 2;
		    err_print ("! Hmm... some of the preceding lines failed to match");

		}
		return;
	    }
	}
	;

	{
	    undouble_ats(buffer,limit);
	    change_limit = change_buffer - buffer + limit;
	    strncpy (change_buffer, buffer, limit - buffer + 1);
	}

	;
	changing = 0;
	print_where = 1;
	cur_line++;
	while (!input_ln (cur_file))
	{
	    if (include_depth == 0)
	    {
		err_print ("! WEB file ended during a change");

		input_has_ended = 1;
		return;
	    }
	    include_depth--;
	    print_where = 1;
	    cur_line++;
	}
	if (lines_dont_match)
	    n++;
    }
}


void
reset_input ()
{
    limit = buffer;
    loc = buffer + 1;
    buffer[0] = ' ';

    if ((web_file = fopen (web_file_name, "r")) == NULL)
	fatal ("! Cannot open input file", web_file_name);
    if ((change_file = fopen (change_file_name, "r")) == NULL)
	fatal ("! Cannot open change file", change_file_name);

    ;
    cur_line = 0;
    change_line = 0;
    include_depth = 0;
    changing = 1;
    prime_the_change_buffer ();
    changing = !changing;
    limit = buffer;
    loc = buffer + 1;
    buffer[0] = ' ';
    input_has_ended = 0;
}


int
get_line ()
{
restart:
    if (changing)
	changed_module[module_count] = 1;
    else			
    {
	cur_line++;
	while (!input_ln (cur_file))
	{
	    print_where = 1;
	    if (include_depth == 0)
	    {
		input_has_ended = 1;
		break;
	    } else
	    {
		include_depth--;
		cur_line++;
	    }
	}
	if (!input_has_ended)
	    if (limit == change_limit - change_buffer + buffer)
		if (buffer[0] == change_buffer[0])
		    if (change_limit > change_buffer)
			check_change ();
    }

    ;
    if (changing)
    {
	{
	    change_line++;
	    if (!input_ln (change_file))
	    {
		err_print ("! Change file ended without @z");

		buffer[0] = '@';
		buffer[1] = 'z';
		limit = buffer + 2;
	    }
	    if (limit > buffer + 1)
		if (buffer[0] == '@')
		{

		    if (buffer[1] >= 'X' && buffer[1] <= 'Z' || buffer[1] == 'I')
			buffer[1] += 'z' - 'Z';

		    ;
		    {
			if (buffer[1] == 'i')
			{
			    loc = buffer + 2;
			    err_print ("! No includes allowed in change file");

			}
		    }

		    ;
		    if (buffer[1] == 'x' || buffer[1] == 'y')
		    {
			loc = buffer + 2;
			err_print ("! Where is the matching @z?");

		    } else if (buffer[1] == 'z')
		    {
			prime_the_change_buffer ();
			changing = !changing;
			print_where = 1;
		    }
		}
	}

	;
	if (!changing)
	{
	    changed_module[module_count] = 1;
	    goto restart;
	}
	undouble_ats(buffer,limit);
    }
    loc = buffer;
    *limit = ' ';
    if (*buffer == '@' && (*(buffer + 1) == 'i' || *(buffer + 1) == 'I'))
    {
	ASCII          *k,
	               *j;

	loc = buffer + 2;
	while (loc <= limit && (*loc == ' ' || *loc == '\t' || *loc == '"'))
	    loc++;
	if (loc >= limit)
	    err_print ("! Include file name not given");

	else
	{
	    if (++include_depth < max_include_depth)
	    {
		k = cur_file_name;
		j = loc;
		while (*loc != ' ' && *loc != '\t' && *loc != '"')
		    *k++ = *loc++;
		*k = '\0';
		if ((cur_file = fopen (cur_file_name, "r")) == NULL)
		{
		    loc = j;
		    include_depth--;
		    err_print ("! Cannot open include file");

		} else
		{
		    cur_line = 0;
		    print_where = 1;
		}
	    } else
	    {
		include_depth--;
		err_print ("! Too many nested includes");

	    }
	}
	goto restart;
    }
    ;
    return (!input_has_ended);
}

void
put_line ()
{
    char           *ptr = buffer;

    while (ptr < limit)
	putchar (*ptr++);
    putchar ('\n');
}


void
check_complete ()
{
    if (change_limit != change_buffer)
    {
	strncpy (buffer, change_buffer, change_limit - change_buffer + 1);
	limit = change_limit - change_buffer + buffer;
	changing = 1;
	loc = change_limit;
	err_print ("! Change file entry did not match");

    }
}


void       
err_print (s)
    char           *s;
{
    ASCII          *k,
                   *l;

    fprintf (stderr, "\n%s", s);

    if (changing)
	fprintf (stderr, ". (l. %d of change file)\n", change_line);
    else if (include_depth == 0)
	fprintf (stderr, ". (l. %d)\n", cur_line);
    else
	fprintf (stderr, ". (l. %d of include file %s)\n", cur_line, cur_file_name);
    l = (loc >= limit ? limit : loc);
    if (l > buffer)
    {
	for (k = buffer; k < l; k++)
	    if (*k == '\t')
		putc (' ', stderr);
	    else
		putc (*k, stderr);
	putc ('\n', stderr);
	for (k = buffer; k < l; k++)
	    putc (' ', stderr);
    }
    for (k = l; k < limit; k++)
	putc (*k, stderr);
    if (*limit == '|')
	putc ('|', stderr);
    putc (' ', stderr);

    ;
    fflush (stdout);
    mark_error;
}


void
wrap_up ()
{
    check_complete ();
    putc ('\n', stderr);

    switch (history)
    {
    case spotless:
	fprintf (stderr, "(No errors were found.)\n");
	break;
    case harmless_message:
	fprintf (stderr, "(Did you see the warning message above?)\n");
	break;
    case error_message:
	fprintf (stderr, "(Pardon me, but I think I spotted something wrong.)\n");
	break;
    case fatal_message:
	fprintf (stderr, "(That was a fatal error, my friend.)\n");
    }

    ;
    if (history > harmless_message)
	exit (2);
    else
	exit (1);
}


void
scan_args (argc, argv)
    char          **argv;
{
    char           *dot_pos,
                   *strchr ();
    boolean         found_web = 0,
                    found_change = 0;

    while (--argc > 0)
    {
	++argv;
	if (!found_web)		

	{
	    if (strlen (*argv) > max_file_name_length - 5)
		fatal ("! Filename %s too long\n", *argv);

	    ;
	    if ((dot_pos = strchr (*argv, '.')) == NULL)
		sprintf (web_file_name, "%s.web", *argv);
	    else
	    {
		sprintf (web_file_name, "%s", *argv);
		*dot_pos = 0;
	    }
	    found_web = 1;
	}

	else if (!found_change)	

	{
	    if (strlen (*argv) > max_file_name_length - 5)
		fatal ("! Filename %s too long\n", *argv);

	    ;
	    if ((dot_pos = strchr (*argv, '.')) == NULL)
		sprintf (change_file_name, "%s.ch", *argv);
	    else
		sprintf (change_file_name, "%s", *argv);
	    found_change = 1;
	}

	else			

	{
	    fprintf(stderr,
		"! Usage: wmerge webfile[.web] [changefile[.ch]]\n");
	    exit(2);
	}

	;
    }
    if (!found_web)		

    {
	fprintf(stderr,"! Usage: wmerge webfile[.web] [changefile[.ch]]\n");
	exit(2);
    }
    ;
    if (!found_change)		
#if defined (VMS) || defined (__VMS)
	strcpy (change_file_name, "NL:");
#else
	strcpy (change_file_name, "/dev/null");
#endif

    ;
}

main (argc, argv)
    char          **argv;
{
    scan_args (argc, argv);
    reset_input ();
    while (get_line ())
	put_line ();
    wrap_up ();
}

