P /*##############################################################################   FUNNNELWEB COPYRIGHT ====================7 FunnelWeb is a literate-programming macro preprocessor.   $ Copyright (C) 1992 Ross N. Williams.      Ross N. Williams     ross@spam.adelaide.edu.au5    16 Lerwick Avenue, Hazelwood Park 5066, Australia.   D This program is free software; you can redistribute it and/or modifyD it under the terms of Version 2 of the GNU General Public License as* published by the Free Software Foundation.  J This program is distributed WITHOUT ANY WARRANTY; without even the implied@ warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.A See Version 2 of the GNU General Public License for more details.   F You should have received a copy of Version 2 of the GNU General PublicE License along with this program. If not, you can FTP the license from ? prep.ai.mit.edu/pub/gnu/COPYING-2 or write to the Free Software 9 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   C Section 2a of the license requires that all changes to this file be B recorded prominently in this file. Please record all changes here.   Programmers:3    RNW  Ross N. Williams  ross@spam.adelaide.edu.au    Changes:C    07-May-1992  RNW  Program prepared for release under GNU GPL V2.   P ##############################################################################*/    P /******************************************************************************/P /*                                      AS.H                                  */P /******************************************************************************/P /*                                                                            */P /* ASSERTION PACKAGE                                                          */P /* =================                                                          */P /* This package contains macros and functions that support assertions. An     */P /* assertion is a boolean condition that is supposed always to be true at a   */P /* particular point during program execution. An assertion statement tests    */P /* such a condition and bombs the program if it is false; better to be        */P /* alerted to such a condition rather than suffer and erroneous execution.    */P /*                                                                            */P /* Standard C supports asertions with the <assert.h> header file providing    */P /* the "assert" macro. Unfortunately, this does not meet the needs of         */P /* FunnelWeb for two reasons:                                                 */P /*                                                                            */P /* 1) Portability is emphasised in FunnelWeb and the assert macro is fairly   */P /*    recent. Its only argument is the boolean condition, which means that    */P /*    without the ANSI macros __FILE__ and __LINE__, the macro would be       */P /*    unable to indicate where an assertion failure occurred, in a non-ANSI   */P /*    environment.                                                            */P /*                                                                            */P /* 2) There is only one assert macro and it can be either on or off, the      */P /*    implication being that in production code, it should be turned off. In  */P /*    contrast, the execution speed of the assert macro will usually matter   */P /*    only in a small portion of the code as, in most programs, a small       */P /*    portion of the code accounts for most of the execution time. By having  */P /*    two categories of assertion, we can leave most of the assertions turned */P /*    on in the production program.                                           */P /*                                                                            */P /* This reasoning leads to the slightly different assertion facilty provided  */P /* by this package. Here, there are two assertion routines/macros, HOT        */P /* assertions for HOT code (code in a program hot spot) and COLD assertions   */P /* for COLD code (not in a hot spot). Only the HOT assertions can be turned   */P /* off.                                                                       */P /*                                                                            */P /******************************************************************************/  P /* Ensure that the body of this header file is included at most once.         */ #ifndef DONE_AS  #define DONE_AS   P /******************************************************************************/   #include "style.h"  P /******************************************************************************/  P /* The following #define determines whether hot assertions are to be turned   */P /* on or off. Set to 0 for OFF and 1 for ON.                                  */P /* Note: I have left hot assertions on in the production version as FunnelWeb */P /*       doesn't go slowly enough to make me want to turn it off.             */ #define AS_DOHOT 1  P /******************************************************************************/  ! EXPORT void as_bomb P_((char *)); P /* This function writes out its argument string and then bombs the program.   */P /* It should be called at any point where it has been determined that an      */P /* illegal condition has been detected. The other assertion routines/macros   */P /* call this function.                                                        */  P /* The following two macros define hot and cold assertions. Be sure never to  */P /* call them with arguments with side effects!                                */, #define as_cold(e,s) {if (!(e)) as_bomb(s);}   #if AS_DOHOT. #define as_hot(e,s)    {if (!(e)) as_bomb(s);} #define AS_HCODE(CODE) {CODE}  #else ! #define as_hot(e,s)    ((void) 0) ! #define AS_HCODE(CODE) ((void) 0)  #endif  P /******************************************************************************/  P /* For #ifndef preventing multiple inclusion of the body of this header file. */ #endif  P /******************************************************************************/P /*                                     AS.H                                   */P /******************************************************************************/