P /*##############################################################################   FUNNNELWEB COPYRIGHT ====================7 FunnelWeb is a literate-programming macro preprocessor.   $ Copyright (C) 1992 Ross N. Williams.      Ross N. Williams     ross@spam.adelaide.edu.au5    16 Lerwick Avenue, Hazelwood Park 5066, Australia.   D This program is free software; you can redistribute it and/or modifyD it under the terms of Version 2 of the GNU General Public License as* published by the Free Software Foundation.  J This program is distributed WITHOUT ANY WARRANTY; without even the implied@ warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.A See Version 2 of the GNU General Public License for more details.   F You should have received a copy of Version 2 of the GNU General PublicE License along with this program. If not, you can FTP the license from ? prep.ai.mit.edu/pub/gnu/COPYING-2 or write to the Free Software 9 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   C Section 2a of the license requires that all changes to this file be B recorded prominently in this file. Please record all changes here.   Programmers:3    RNW  Ross N. Williams  ross@spam.adelaide.edu.au    Changes:C    07-May-1992  RNW  Program prepared for release under GNU GPL V2.   P ##############################################################################*/    P /******************************************************************************/P /*                                  CLOCK.H                                   */P /******************************************************************************/P /*                                                                            */P /* This package implements a clock abstraction that is used to generate       */P /* timing statistics which are useful for performance tuning. The package     */P /* allows the measurement of both real and CPU time. This package gets its    */P /* raw information from the tim_cpu() and tim_real() functions of the machine */P /* dependent module "machin".                                                 */P /*                                                                            */P /******************************************************************************/  P /* Ensure that the body of this header file is included at most once.         */ #ifndef DONE_CLOCK #define DONE_CLOCK  P /******************************************************************************/   #include "style.h"  P /******************************************************************************/  P /* The following clock type is supposed to be an ADT so don't frob any of its */P /* fields manually!                                                           */ typedef struct   { P    ulong ck_mhead; /* Magic number helps detect corruptions.                  */P    bool  ck_run;   /* TRUE iff the clock is running.                          */P    float ck_csum;  /* Accumulated CPU time.                                   */P    float ck_rsum;  /* Accumulated real time.                                  */P    float ck_csta;  /* ck_run => CPU  time when clock was started.             */P    float ck_rsta;  /* ck_run => Real time when clock was started.             */P    ulong ck_mtail; /* Magic number helps detect corruptions.                  */	   } ck_t;    typedef ck_t *p_ck_t;   P /******************************************************************************/    EXPORT void ck_ini P_((p_ck_t));P /* Initializes the clock. After this call, the argument clock will be in the  */P /* STOPPED state and all its registers will be zero.  A clock must be         */P /* initialized before any other operations are performed on it.               */  " EXPORT void ck_start P_((p_ck_t));P /* Changes the clock from the STOPPED state to the RUNNING state. Starts      */P /* accumulating real time and CPU time on its registers.                      */P /* Raises an error if the clock is not in the STOPPED state.                  */  ! EXPORT void ck_stop P_((p_ck_t)); P /* Changes the clock from the RUNNING state to the STOPPED state. Stops       */P /* accumulating real time and CPU time on its registers.                      */P /* Raises an error if the clock is not in the RUNNING state.                  */  ! EXPORT float ck_cpu P_((p_ck_t)); P /* Returns the number of seconds of CPU time accumulated on the clock.        */P /* Raises an error if the clock is not in the STOPPED state.                  */  " EXPORT float ck_real P_((p_ck_t));P /* Returns the number of seconds of real time accumulated on the clock.       */P /* Raises an error if the clock is not in the STOPPED state.                  */  P /******************************************************************************/  P /* For #ifndef preventing multiple inclusion of the body of this header file. */ #endif  P /******************************************************************************/P /*                              End of CLOCK.H                                */P /******************************************************************************/