P /*##############################################################################   FUNNNELWEB COPYRIGHT ====================7 FunnelWeb is a literate-programming macro preprocessor.   $ Copyright (C) 1992 Ross N. Williams.      Ross N. Williams     ross@spam.adelaide.edu.au5    16 Lerwick Avenue, Hazelwood Park 5066, Australia.   D This program is free software; you can redistribute it and/or modifyD it under the terms of Version 2 of the GNU General Public License as* published by the Free Software Foundation.  J This program is distributed WITHOUT ANY WARRANTY; without even the implied@ warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.A See Version 2 of the GNU General Public License for more details.   F You should have received a copy of Version 2 of the GNU General PublicE License along with this program. If not, you can FTP the license from ? prep.ai.mit.edu/pub/gnu/COPYING-2 or write to the Free Software 9 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   C Section 2a of the license requires that all changes to this file be B recorded prominently in this file. Please record all changes here.   Programmers:3    RNW  Ross N. Williams  ross@spam.adelaide.edu.au    Changes:C    07-May-1992  RNW  Program prepared for release under GNU GPL V2.   P ##############################################################################*/    P /******************************************************************************/P /*                                    DATA.H                                  */P /******************************************************************************/P /*                                                                            */P /* This package (data.h, data.c) contains ALL of the global variables in      */P /* FunnelWeb. Some of the FunnelWeb packages (e.g. the lister) harbour hidden */P /* static state variables which could be considered to be a global variable,  */P /* but, these aside, this package contains all the variables that are used    */P /* directly by more than one package. In many programs, it would likely be    */P /* appropriate to have a separate package for each distinct group of shared   */P /* data so that only those packages needing a particular group of data need   */P /* see it. However, in FunnelWeb's case, the variables are so few, and their  */P /* use so widespread that they are clustered here in one package for all to   */P /* see.                                                                       */P /*                                                                            */P /* This package also contains type definitions for the central FunnelWeb data */P /* structures.                                                                */P /*                                                                            */P /******************************************************************************/  P /* Ensure that the body of this header file is included at most once.         */ #ifndef DONE_DATA  #define DONE_DATA   P /******************************************************************************/   #include <stdio.h> #include <stdlib.h>  #include <limits.h>  #include "style.h" #include "clock.h" #include "list.h"  #include "table.h" #include "option.h"  #include "section.h" #include "writfile.h"   P /******************************************************************************/P /*                                                                            */P /* DATA TYPES                                                                 */P /* ==========                                                                 */P /* The following section contains all the data types of the global variables. */P /*                                                                            */P /******************************************************************************/  P /* The following structure defines a position in the global listing of the    */P /* input data by storing a line number and a column number. The line number   */P /* is a global line number meaning that it increases continuously through     */P /* the lines of included files. The first line is line number 1. The first    */P /* (leftmost) column is column number 1.                                      */ typedef 	    struct       {       ulong ps_line;       ulong ps_column;
      } ps_t ;   B typedef ps_t *p_ps_t;  /* A pointer to a position is handy too! */  P /******************************************************************************/  > /* A macro name is represented simply as a character array. */ #define NAME_MAX 80   typedef char name_t[NAME_MAX+1]; typedef name_t *p_name_t;   P /******************************************************************************/  P /* SC stands for SCrap of text. A scrap of text is a contiguous group of      */P /* printable bytes in memory. The following structure defines such a group by */P /* storing a pointer to the first and last character of the scrap.            */P /* The scrap must contain at least one character (i.e. sc_last>=sc_first).    */ typedef 	    struct       {P       char *sc_first; /* Pointer to the first byte of the scrap.              */P       char *sc_last;  /* Pointer to the last  byte of the scrap.              */P       bool  sc_white; /* TRUE iff the scrap consists entirely of whitespace.  */      } sc_t;   typedef sc_t *p_sc_t;   P /******************************************************************************/  P /* LN stands for LiNe. This record holds global and local line numbers as     */P /* well as a scrap that points to the line in question. The scanner (which    */P /* generates this list) guarantees that the last character of the line scrap  */P /* is an EOL.                                                                 */ typedef 	    struct       {P       sc_t  ln_body;    /* Scrap pointing to the line. Line ends in EOL.      */P       ulong ln_global;  /* Global line number of this line.                   */P       ulong ln_local;   /* Local  line number of this line.                   */      } ln_t;  P /* The global line list is simply a list of lines of the following type.      */ typedef p_ls_t p_lnls_t;  P /******************************************************************************/  6 /* The following enumerated type identifies a font. */ #define FT_NORM 1  #define FT_TITL 2  #define FT_STIT 3   F /* The following enumerated type identifies a horizontal alignment. */ #define LR_LEFT 1  #define LR_RIGH 2  #define LR_CENT 3   P /* We want to pack a font and an alignment into the tk_gen byte of the token  */P /* record (we could create a new field, but as none of the other token kinds  */P /* require an extra field, we choose to pack instead. The formula is this:    */P /* Packed byte=LRFT_PACK*FONT+ALIGNMENT.                                      */ #define LRFT_PACK 10  P /******************************************************************************/  C /* The following enumerated type identifies the kind of a token. */ 6 #define TK_TEXT  1   /*      Text segment.          */6 #define TK_NSEC  2   /*  @A..New section.           */6 #define TK_MDEF  3   /*  @$  Macro definition.      */6 #define TK_FDEF  4   /*  @F  File definition.       */6 #define TK_ONAM  5   /*  @<  Open name.             */6 #define TK_CNAM  6   /*  @>  Close name.            */6 #define TK_ODEF  7   /*  @{  Open definition.       */6 #define TK_CDEF  8   /*  @}  Close definition.      */6 #define TK_OPAR  9   /*  @(  Open parameter list.   */6 #define TK_CPAR 10   /*  @)  Close parameter list.  */6 #define TK_COMA 11   /*  @,  Comma.                 */6 #define TK_QUOT 12   /*  @"  Quote.                 */6 #define TK_PARM 13   /*  @1  Parameter.             */6 #define TK_ZERO 14   /*  @Z  Zero calls allowed.    */6 #define TK_MANY 15   /*  @M  Many calls allowed.    */6 #define TK_NAME 16   /*  @#  Self contained name.   */6 #define TK_EMPH 17   /*  @/  Emphasize text.        */6 #define TK_NPAG 18   /*  @t..Newpage.               */6 #define TK_TOCS 19   /*  @t..Table of contents.     */6 #define TK_SKIP 20   /*  @t..Vertical skip.         */6 #define TK_TITL 21   /*  @t..Title text.            */6 #define TK_EOF  22   /*      End of file.           */ typedef ubyte tk_k_t;   P /* The following structure conveys all the information about a single token.  */P /* As well as the kind of token, the parser needs to know where the token is  */P /* in the input file and what the text of the token is if it is a text token. */P /* Some other tokens have a numeric attribute associated with them and the    */P /* tk_gen field provides a place for this. The attributes are:                */P /*    TK_PARM - The number of the parameter [1,9].                            */P /*    TK_NAME - The number of the character forming the name [0,255].         */P /*    TK_NSEC - The level of the section [0,5]. 0=@*, 1=@A, 2=@B,..,5=@E.     */P /*    TK_SKIP - Number of millimetres to skip vertically [0,255].             */P /*    TK_TITL - Font and alignment packed into byte as specified earlier.     */P /*              tk_sc is the text to be set as a title.                       */ typedef 	    struct       {P       tk_k_t tk_kind;  /* Kind of this token.                                 */P       ps_t   tk_ps;    /* Position of the first character of this token.      */P       sc_t   tk_sc;    /* Scrap constituting token.                           */P       ubyte  tk_gen;   /* General token attribute.                            */      } tk_t;  1 typedef p_ls_t p_tkls_t;  /* A list of tokens. */   P /******************************************************************************/  P typedef p_ls_t p_scls_t;  /* List of scraps.                                  */P typedef p_ls_t p_scll_t;  /* List of list of scraps =TEXT.                    */  P typedef p_ls_t p_ells_t;  /* List of pointers to elements = EXPRESSION.       */P typedef p_ls_t p_elll_t;  /* List of list of pointers to elements.            */P typedef p_ls_t p_ell3_t;  /* List of list of list of pointers to elements.    */  P /******************************************************************************/  P /* This structure's signature is BP for Body Part. FunnelWeb macros can       */P /* be defined in a series of "+=" definitions scattered through the input     */P /* file. The definition of the macro is the concatenation of all the parts.   */P /* The contributory part of a part consists of a single expression.           */P /* Throughout the document, body parts (definition parts) are numbered        */P /* sequentially by a sequence number.                                         */ typedef 	    struct      { P      p_ells_t bp_ex;  /* Expression that is logically appended to definition. */P      ulong    bp_seq; /* Sequence number of body part.                        */P      ps_t     bp_ps;  /* Position at which the definition appears.            */     } bp_t;    typedef bp_t *p_bp_t;   @ /* A list of body parts constitutes the full body of a macro. */ typedef p_ls_t p_bpls_t;  P /******************************************************************************/  P /* The following structure summarizes a macro CALL. Each macro table entry    */P /* contains a field ma_calls which contains a list of these structures. The   */P /* list is used to generate diagnostics (e.g. if a call has the wrong number  */P /* of parameters) and also to give cross reference information in the typeset */P /* documentation.                                                             */ typedef 	    struct       {P       ulong mc_seq;   /* Sequence number of body part containing call.        */P       ps_t  mc_ps;    /* Position at which the call occurred.                 */P       ulong mc_npar;  /* Number of parameters in call.                        */      } mc_t;   typedef mc_t *p_mc_t;   P /* A list of calls summarizes the entire usage of a macro in a document.      */ typedef p_ls_t p_mcls_t;  P /******************************************************************************/  P /* This structure stores the definition of a single macro. The first field    */P /* md_isdef indicates whether a definition for this macro has so far been     */P /* seen. If it has, md_isdef=TRUE and the remaining fields are well defined.  */ typedef 	    struct       {P       bool     md_isdef;  /* TRUE iff the macro is defined.                   */P       ps_t     md_ps;     /* isdef=> Position of first definition part.       */P       ubyte    md_npar;   /* isdef=> Number of params specified in defn.      */P       bool     md_isadd;  /* isdef=> TRUE iff additively defined.             */P       bool     md_iszer;  /* isdef=> TRUE iff zero calls allowed.             */P       bool     md_isman;  /* isdef=> TRUE iff many calls allowed.             */P       bool     md_isfil;  /* isdef=> TRUE iff macro is bound to an outp file. */P       p_bpls_t md_body;   /* isdef=> Body of the macro (list of parts).       */      } md_t;  P /******************************************************************************/  P /* The following structure contains the full information about a macro.       */ typedef 	    struct       {P       name_t   ma_name;   /* Name of the macro.                               */P       p_mcls_t ma_calls;  /* List of calls of this macro in the document.     */P       md_t     ma_defn;   /* Definition of this macro.                        */P       p_ell3_t ma_actn;   /* Used by tangle. List of actual parameter lists.  */P       uword    ma_level;  /* Used by analyser. Depth of deepest call.         */      } ma_t;  P /* A pointer to the comprehensive macro structure defined above is the way    */P /* that FunnelWeb refers to macros internally.                                */ typedef ma_t *p_ma_t;   P /******************************************************************************/  P /* An expression consists of a sequence of ELEMENTS each of which can         */P /* be one of three kinds:                                                     */P /*                                                                            */P /*    1. A block of text.                                                     */P /*    2. An invocation of another macro.                                      */P /*    3. A parameter of the current macro.                                    */P /*                                                                            */P /* The following enumerated type identifies one of these three alternatives.  */ #define EL_TEXT 1  #define EL_INVC 2  #define EL_PARM 3  typedef ubyte el_k_t;   P /* The following rather messy structure contains information about a single   */P /* element. As mentioned above, an element can be one of three kinds and the  */P /* following structure should, strictly speaking, be defined as a C union so  */P /* as to emphasize the mutually exclusive nature of most of its fields.       */P /* At one stage this structure did contain a union, however, it introduced    */P /* more mess than it brought clarity (because of the extra two subnames) and  */P /* was eventually dropped.                                                    */P /* A few fields deserve some explanation:                                     */P /*    el_pretx and el_postx hold the exact whitespace appearing between       */P /*       actual parameters in a macro call. This enables the call to be       */P /*       formatted properly in the typeset output.                            */P /*    el_which is part of the macro parameter element (e.g. @1) and points to */P /*       the macro within which the @1 appears. Strictly speaking this should */P /*       not be necessary, but it is convenient for the tangler to have this  */P /*       information when it is half way through expanding an expression.     */ typedef 	    struct       {P       el_k_t   el_kind;  /* Indicates what kind of element structure holds.   */  P       p_scls_t el_text;  /* EL_TEXT => List of scraps forming a text chunk.   */  P       p_ma_t   el_p_mac; /* EL_INVC => Pointer to macro being invoked.        */P       p_elll_t el_parls; /* EL_INVC => List of actual parameters.             */P       p_scll_t el_pretx; /* EL_INVC => Text before each parameter.            */P       p_scll_t el_postx; /* EL_INVC => Text after  each parameter.            */  P       p_ma_t   el_which; /* EL_PARM => Macro in which this element appears.   */P       ubyte    el_parno; /* EL_PARM => Parameter number of this actual param. */      } el_t;   typedef el_t *p_el_t;d  P /******************************************************************************/  P /* A document component (represented by the DC_ data structures (see below)   */P /* can be one of three things: a lump of text, a typesetter-generic           */P /* typesetting directive, or a macro definition. The second of these consists */P /* of a whole collection of typesetting commands and so rather than           */P /* cluttering up the dc_ record, they have been separated out here.           */P #define TY_NSEC 1   /* New section.                                           */P #define TY_OLIT 2   /* Open  literal.                                         */P #define TY_CLIT 3   /* Close literal.                                         */P #define TY_OEMP 4   /* Open  emphasise.                                       */P #define TY_CEMP 5   /* Close emphasise.                                       */P #define TY_NPAG 6   /* New page.                                              */P #define TY_TOCS 7   /* Table of contents.                                     */P #define TY_SKIP 8   /* Skip vertical.                                         */P #define TY_TITL 9   /* Title.                                                 */ typedef ubyte ty_k_t;    typedef 	    struct       {P       ty_k_t   ty_kind;  /* Kind of this typesetting directive.               */P       sn_t     ty_sn;    /* TY_NSEC=> Hierarchical section number.            */P       bool     ty_isnam; /* TY_NSEC=> TRUE iff the section is named.          */P       name_t   ty_name;  /* TY_NSEC=> ty_isnam=> Name of section.             */  P       uword    ty_mm;    /* TY_SKIP=> Millimetres to skip.                    */  P       ubyte    ty_font;  /* TY_TITL=> Font in which to write title.           */P       ubyte    ty_align; /* TY_TITL=> Alignment with which to write title.    */P       sc_t     ty_sc;    /* TY_TITL=> Scrap that is title text.               */      } ty_t;   typedef ty_t *p_ty_t;   P /******************************************************************************/  P /* The document list contains a representation of the input document in the   */P /* form in which it was fed to FunnelWeb. This structured representation of   */P /* the input is used by the weaver to generate the typeset output.            */P /* Here, a document is represented by a list of DOCUMENT COMPONENTs (DC) each */P /* of which contains information about a major chunk of the document. The     */P /* following enumerated type dc_k_t (document component kind type) is used to */P /* indicate which kind of component each list element contains.               */P #define DC_TEXT 1   /* Text component consists of a block of text.            */P #define DC_TYPE 2   /* Typesettting component affecting document typesetting. */P #define DC_MACR 3   /* A MACRo definition.                                    */ typedef ubyte dc_k_t;i  P /* The following structure stores a single document component. Like the el_t  */P /* type, the dc_t type should really be a union type, but a union construct   */P /* has been avoided to make the naming simpler.                               */ typedef 	    struct       {P       ps_t     dc_ps;    /* Position of this component.                       */P       dc_k_t   dc_kind;  /* Kind of this component.                           */  P       p_scls_t dc_text;  /* DC_TEXT=> Text segment constituting this compnt.  */  P       ty_t     dc_ty;    /* DC_TYPE=> Typesetting object record.              */  P       p_ma_t   dc_p_ma;  /* DC_MACR=> Pointer to the macro defined.           */P       ulong    dc_part;  /* DC_MACR=> Part number of this part of macro defn. */      } dc_t;   typedef dc_t *p_dc_t;   P /* A list of document components constitutes the global document list         */P /* declared later.                                                            */ typedef p_ls_t p_dcls_t;  P /******************************************************************************/  P /* This enumerated type identifies a typesetter.                              */P /*    TR_NONE - No specific typesetter specified.                             */P /*    TR_TEX  - The TeX typesetter.                                           */ #define TR_NONE 1y #define TR_TEX  2M& /* Add more typesetters here later. */ typedef ubyte tr_k_t;e    P /******************************************************************************/P /*                                                                            */P /* VARIABLES                                                                  */P /* =========                                                                  */P /* This section contains external declarations of the global variables.       */P /* The global variables themselves appear in DATA.C.                          */P /*                                                                            */P /******************************************************************************/  P /* This #ifndef is part of a mechanism that makes the following definitions   */P /* visible to other modules declared as "extern", and visible to data.c       */P /* declared as ordinary declarations. This prevents inconsistencies.          */ #ifndef EXTERN #define EXTERN externi #endif  P /* This global options variable holds the options that were transmitted to    */P /* FunnelWeb proper through the command line.                                 */ EXTERN GLOVAR op_t option;  P /* The following option variable is set by the scanner and is used by the     */P /* tangler. It determines whether the tangler will use natural indenting.     */P /* TRUE => Tangler should use space indenting. FALSE=>No indenting.           */ EXTERN GLOVAR bool tgindent;  P /* The following option variable is set by the scanner and is used by the     */P /* tangler. It sets a limit on the length of the lines of the product files   */P /* generated by tangle. A value of TGMAXINF indicates that no checking need   */P /* be performed.                                                              */ #define TGMAXINF (ULONG_MAX) EXTERN GLOVAR ulong tglinmax;t  P /* The following variable is written by the scanner and read by weave. It     */P /* stores the typesetter format possibly specified by the user in the input.  */ EXTERN GLOVAR tr_k_t tr_codes;  P /* The following five lists and tables constitute the major data structures   */P /* that are communicated between the major components of FunnelWeb.           */P /* The TOKEN_LIST contains a tokenized representation of the input file.      */P /* The LINE_LIST contains a list of the lines of the input file.              */P /* The DOCUMENT_LIST contains a structured representation of the input file.  */P /* The MACRO_TABLE describes the macros defined in the input file.            */P /* The FILE_TABLE identifies macros that are connected to product files.      */P /*                                        Created By  Used By                 */P /*                                        ----------  -------                 */P EXTERN GLOVAR p_tkls_t token_list;     /*    Scanner  Parser                  */P EXTERN GLOVAR p_lnls_t line_list;      /*    Scanner  Lister                  */P EXTERN GLOVAR p_dcls_t document_list;  /*     Parser  Weaver                  */P EXTERN GLOVAR p_tb_t   macro_table;    /*     Parser  Tangler, Weaver         */P EXTERN GLOVAR p_tb_t   file_table;     /*     Parser  Tangler, Weaver         */  P /* Three output streams are accessible globally.                              */P /* The SCREEN FILE is connected to standard output (the user screen).         */P /* The JOURNAL FILE logs FunnelWeb command language transactions.             */P /* The LISTING FILE is created by an single invocation of FunnelWeb proper.   */, EXTERN GLOVAR wf_t f_s;  /* Screen  file. */, EXTERN GLOVAR wf_t f_j;  /* Journal file. */, EXTERN GLOVAR wf_t f_l;  /* Listing file. */  P /* Many of the FunnelWeb IO functions accept a single string as a parameter.  */P /* This means that sprintf and a temporary string must be used in order to    */P /* produce parameterized formatted output. Rather than declare temporary      */P /* strings in each local function, we declare them globally.                  */  EXTERN GLOVAR char linet1[2000];  P /* Definitions of Diagnostic Levels                                           */P /* --------------------------------                                           */P /* A WARNING has no effect except to cause a message to be issued.            */P /* An ERROR causes FunnelWeb to abort to the shell at the end of the phase.   */P /*    Example: An error during scanning means that the FunnelWeb run will     */P /*    terminate to the shell at the end of the scanning phase.                */P /* A SEVERE ERROR causes FunnelWeb to abort to the shell immediately.         */P /* A FATAL ERROR causes FunnelWeb to abort to the OS immediately.             */  P /* The following variables count diagnostics over a single FunnelWeb run.     */P EXTERN GLOVAR ulong num_war;  /* Number of      warnings.                     */P EXTERN GLOVAR ulong num_err;  /* Number of        errors.                     */P EXTERN GLOVAR ulong num_sev;  /* Number of severe errors.                     */  P /* The following variables count diagnostics over multiple FunnelWeb runs.    */P EXTERN GLOVAR ulong sum_war;  /* Number of      warnings.                     */P EXTERN GLOVAR ulong sum_err;  /* Number of        errors.                     */P EXTERN GLOVAR ulong sum_sev;  /* Number of severe errors.                     */P EXTERN GLOVAR ulong sum_fat;  /* Number of fatal  errors.                     */  P /******************************************************************************/  P /* For #ifndef preventing multiple inclusion of the body of this header file. */ #endif  P /******************************************************************************/P /*                                 End of DATA.H                              */P /******************************************************************************/