P /*##############################################################################   FUNNNELWEB COPYRIGHT ====================7 FunnelWeb is a literate-programming macro preprocessor.   $ Copyright (C) 1992 Ross N. Williams.      Ross N. Williams     ross@spam.adelaide.edu.au5    16 Lerwick Avenue, Hazelwood Park 5066, Australia.   D This program is free software; you can redistribute it and/or modifyD it under the terms of Version 2 of the GNU General Public License as* published by the Free Software Foundation.  J This program is distributed WITHOUT ANY WARRANTY; without even the implied@ warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.A See Version 2 of the GNU General Public License for more details.   F You should have received a copy of Version 2 of the GNU General PublicE License along with this program. If not, you can FTP the license from ? prep.ai.mit.edu/pub/gnu/COPYING-2 or write to the Free Software 9 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   C Section 2a of the license requires that all changes to this file be B recorded prominently in this file. Please record all changes here.   Programmers:3    RNW  Ross N. Williams  ross@spam.adelaide.edu.au    Changes:C    07-May-1992  RNW  Program prepared for release under GNU GPL V2.   P ##############################################################################*/    P /******************************************************************************/P /*                                   ENVIRON.H                                */P /******************************************************************************/P /*                                                                            */P /* WARNING: DO NOT ADD ANY PROGRAM-DEPENDENT DEFINITIONS.                     */P /*                                                                            */P /* This header file environ.h contains definitions and objects whose values   */P /* depends directly on the compilation and execution environment, but are     */P /* otherwise independent of any particular computer program.                  */P /*                                                                            */P /* This is one of two machine-dependent, program-independent modules. The     */P /* other module is machin (machin.h,machin.c). This "environ" module contains */P /* definitions and objects that are considered essential. The "machin" module */P /* contains less essential definitions. Motivation for the division came from */P /* the fact that style.h (used by almost every module) includes environ.h     */P /* (this file), and from the need for the stuff in style.h by some            */P /* environment-dependent definitions.                                         */P /*                                                                            */P /* There seems to be two ways to organize a module such as this one. The      */P /* first is to have a different version of this module for each target        */P /* environment. The second is to have a single file that uses #defines and    */P /* #ifs to select between code for each target environment. I have chosen the */P /* latter method as this allows many different environments to share the same */P /* definitions.                                                               */P /*                                                                            */P /******************************************************************************/  P /* Ensure that the body of this header file is included at most once.         */ #ifndef DONE_ENVIRON #define DONE_ENVIRON  P /******************************************************************************/  P /* Select An Environment                                                      */P /* ---------------------                                                      */P /* Choose the environment in which the program will be compiled and executed. */P /* This may be the only change you need to make to get FunnelWeb to compile.  */P /*                                                                            */P /* If your exact environment is not listed, try one that is close.            */P /* If problems arise, an attempt should be made to solve them                 */P /* without creating a new environment definition.  However, if this is not    */P /* possible, define a new environment below and "implement" it by going       */P /* through environ.h and machin.h and machin.c and adding appropriate         */P /* definitions.                                                               */P /*                                                                            */P /* The following table lists real/defined environment pairs under which       */P /* FunnelWeb is known to compile cleanly.                                     */P /*                                                                            */P /* Symbol = Processor  Machine       OS            Compiler                   */P /* ------   ---------  -------       --            --------                   */P /*    MAC = 68000      Macintosh-SE  Mac           THINK-C V4.0.5             */P /*    SUN = SPARC      SUN ELC       Unix(SunOS)   GNUC                       */P /*    VMS = VAX        VAXStation    VMS           VAXC                       */P /*     PC = 386        IBM PC Clone  MSDOS5.0      Borland C++                */P /*                                                                            */P /* Set exactly one of the following environments to 1, the others to 0.       */  
 #define MAC 0 
 #define SUN 0 
 #define VMS 1 
 #define PC  0   P /* Ensure that exactly one environment has been selected.                     */ #if MAC+SUN+VMS+PC != 1 B    #error Error: You must choose exactly one machine in ENVIRON.H. #endif  P /******************************************************************************/  P /* Establish Presence or Absence of __STDC__                                  */P /* -----------------------------------------                                  */P /* The __STDC__ symbol is very useful for determining if the compiler is      */P /* ANSI. However, some "nearly ANSI" compilers don't set this symbol, and     */P /* experience shows that things turn out better if it is set.                 */P /* This section decides if __STDC__ should be defined.                        */  P /* The Macintosh THINK C compiler seems to be ANSI standard but, strangely    */P /* does not define the standard preprocessor symbol __STDC__ that indicates   */P /* this. Instead it defines THINK_C. Here, we execute the link manually.      */P /* For more information see the THINK C User's Manual, Chapter 57: "Language  */P /* Reference", Section 12.10, p.442.                                          */ #ifdef THINK_C #define __STDC__ 1 #endif  0 /* The problem seems to exist with VAX C too. */ #if VMS  #define __STDC__ 1 #endif  P /******************************************************************************/  P /* Switch From Definedness to Boolean Symbols                                 */P /* ------------------------------------------                                 */P /* Use of the definedness of a preprocessor symbol to detect a condition is   */P /* convenient if it is desired that only one condition be tested at a time.   */P /* However, if we want to OR conditions, it is more convenient to use defined */P /* symbols that are either 0 or 1. This section contains ifdefs that do this. */   #ifdef __STDC__  #define STDC 1 #else  #define STDC 0 #endif  ? /* Note: If THINK_C is predefined, it is predefined to be 1. */  #ifndef THINK_C  #define THINK_C 0  #endif  P /******************************************************************************/  P /* Void                                                                       */P /* ----                                                                       */P /* Define void if necessary and define pointer to void.                       */P /* This idea from the book "Portable C", p.41.                                */P /* If necessary, add a boolean condition to cover your environment.           */P /* Note: The "| SUN" is a last minute desperate hack.                         */ #if STDC | SUN typedef void   *p_void;  #else  typedef int       void;  typedef char   *p_void;  #endif  P /* The following function is here solely to act as a first tripping point for */P /* environments with no "void" so that the users trying to port this code     */P /* will look here first instead of starting to delete voids in the program.   */ extern void test_void();  P /******************************************************************************/  P /* Const                                                                      */P /* -----                                                                      */P /* It's useful to be able to specify that certain objects are constants.      */P /* Unfortunately, the "const" construct is only available in ANSI C and so we */P /* have to have a macro so as to cope with non-ANSI compilers.                */P /* Note: THINK-C is nearly ANSI, but does not support "const".                */ #if STDC & !THINK_C  #define CONST const  #else 
 #define CONST  #endif  P /******************************************************************************/  P /* Prototypes                                                                 */P /* ----------                                                                 */P /* Define a macro to wrap around prototype parameter lists so as to support   */P /* compilers with and without prototypes.                                     */P /* This idea came from the book "Portable C", S3.1, p.32.                     */ #if STDC #define P_(A) A  #else  #define P_(A) () #endif  P /******************************************************************************/  P /* Structure Assignments                                                      */P /* ---------------------                                                      */P /* Structure assignments are not supported on some of the older compilers and */P /* so we use a macro to perform such operations.                              */P /* This idea came from the book "Portable C", S8.2.2, p.184.                  */ #if STDC #define ASSIGN(a,b) ((a)=(b))  #else A #define ASSIGN(a,b) (memcpy((char *)&(a),(char *)&(b),sizeof(a)))  #endif  P /******************************************************************************/   /* VMS EXIT STATUS */  /* --------------- */ O /* The VAX C compiler I used doesn't seem to be ANSI. This means that the    */ O /* exit symbols aren't set up properly. Furthermore, the sensible defaults   */ O /* in the style.h file don't work for VMS. The upshot is that we have to do  */ O /* a special case. Note: The top bit set in a VMS exit status means suppress */ O /* diagnostic message. Even status means failure. Odd means success.         */  #if VMS  #undef  EXIT_SUCCESS #undef  EXIT_FAILURE #define EXIT_SUCCESS 1! #define EXIT_FAILURE (0x10000002)  #endif  P /******************************************************************************/  P /* For #ifndef preventing multiple inclusion of the body of this header file. */ #endif  P /******************************************************************************/P /*                                End of ENVIRON.H                            */P /******************************************************************************/