P /*##############################################################################   FUNNNELWEB COPYRIGHT ====================7 FunnelWeb is a literate-programming macro preprocessor.   $ Copyright (C) 1992 Ross N. Williams.      Ross N. Williams     ross@spam.adelaide.edu.au5    16 Lerwick Avenue, Hazelwood Park 5066, Australia.   D This program is free software; you can redistribute it and/or modifyD it under the terms of Version 2 of the GNU General Public License as* published by the Free Software Foundation.  J This program is distributed WITHOUT ANY WARRANTY; without even the implied@ warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.A See Version 2 of the GNU General Public License for more details.   F You should have received a copy of Version 2 of the GNU General PublicE License along with this program. If not, you can FTP the license from ? prep.ai.mit.edu/pub/gnu/COPYING-2 or write to the Free Software 9 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   C Section 2a of the license requires that all changes to this file be B recorded prominently in this file. Please record all changes here.   Programmers:3    RNW  Ross N. Williams  ross@spam.adelaide.edu.au    Changes:C    07-May-1992  RNW  Program prepared for release under GNU GPL V2.   P ##############################################################################*/    P /******************************************************************************/P /*                                   HELP.C                                   */P /******************************************************************************/P /*                                                                            */P /* REPRESENTING MESSAGES AS C CODE                                            */P /* ===============================                                            */P /* Experience has shown that it is much more reliable to code text messages   */P /* into a program than to expect the program to track down text files         */P /* containing the messages at run time. Worthwhile for smallish files (such   */P /* as these help messages) at least. For this reason, most the messages in    */P /* this module are represented by code (e.g. as in printf statements).        */P /*                                                                            */P /* The only exception is the 18K Gnu license message which is a bit too big   */P /* to be done by hand. It has been moved to the help_gnu module.              */P /*                                                                            */P /******************************************************************************/   #include <ctype.h> #include "style.h"   #include "as.h"  #include "help.h"  #include "help_gnu.h"  #include "misc.h"  #include "option.h"   P /******************************************************************************/  P /* This module contains many many output statements that call an output       */P /* function. To neaten up all these calls, we define a global variable to     */P /* hold a pointer to the function and simple macro to write output using      */P /* the function.                                                              */ LOCVAR void (*pf) P_((char *));    #define WX(STR) (*pf)(STR)  P /******************************************************************************/   LOCAL void hel_men P_((void)); LOCAL void hel_men ()  { 
  WX("\n");!  WX("FunnelWeb Help Messages\n"); !  WX("-----------------------\n"); 4  WX("Introduction  - Introduction to FunnelWeb.\n");@  WX("DOcumentation - How to obtain FunnelWeb documentation.\n");/  WX("Options       - Command line options.\n"); 7  WX("DEfoptions    - Default command line options.\n"); /  WX("COMmands      - Interactive commands.\n"); L  WX("Registration  - How to register as an \"official\" FunnelWeb user.\n");I  WX("Support       - How you can help support FunnelWeb development.\n"); +  WX("COPyright     - Copyright notice.\n"); V  WX("License       - The license under which this software is distributed (long).\n");S  WX("Nowarranty    - Extract from the GNU license concerning lack of warranty.\n"); O  WX("DIstribution  - Extract from the GNU license concerning distribution.\n"); N  WX("MOdification  - Read this message if you intend to modify FunnelWeb.\n");C  WX("Versions      - A list of existing versions of FunnelWeb.\n"); Q  WX("Acknowledge   - Thanks to people who helped with FunnelWeb development.\n"); Q  WX("MEnu          - The message you are reading (the default help message).\n"); 
  WX("\n");Y  WX("To display a message, give its (optionally abbreviated) name in a help command.\n"); W  WX("To capture a message to a file, add +J<filename> to the fw command. Examples:\n"); 
  WX("\n");W  WX("          fw +Hintroduction +Jintro.txt   -- From the operating system level.\n"); W  WX("          help introduction               -- From FunnelWeb interactive mode.\n");  }   P /******************************************************************************/   LOCAL void hel_int P_((void)); LOCAL void hel_int ()  { 
  WX("\n");   WX("FunnelWeb Introduction\n");   WX("----------------------\n");J  WX("Welcome to FunnelWeb, a literate-programming macro preprocessor.\n");
  WX("\n");W  WX("Traditional computer programs are primarily written for computers and consist\n"); S  WX("of code laced with comments. In contrast, literate programs are primarily\n"); X  WX("written for humans and consist of comments laced with code.  While simple, the\n");W  WX("effect of this inversion can be so profound as to change one's whole approach\n"); X  WX("to programming.  The literate programmer focuses on conveying meaning to other\n");V  WX("intelligent beings rather than merely convincing the computer to behave in a\n");V  WX("particular way. It is the difference between performing and exposing a magic\n");  WX("trick.\n");
  WX("\n");U  WX("FunnelWeb is a production-quality literate-programming tool that emphasises\n"); V  WX("simplicity and reliability. It provides a macro facility, and assists in the\n");V  WX("production of typeset documentation. FunnelWeb runs on most popular machines\n");P  WX("(Sun, VAX, Mac, PC) and its highly portable source code in C is freely\n");(  WX("available under a GNU license.\n");
  WX("\n");X  WX("To get started with FunnelWeb, obtain a printed copy of the \"FunnelWeb User's\n");[  WX("Manual\" (see the \"DOCUMENTATION\" help message). Read the introduction and work\n"); P  WX("through the tutorial. The manual contains an overview of FunnelWeb, an\n");N  WX("introductory tutorial, and a comprehensive reference manual. Try it!\n"); }   P /******************************************************************************/   LOCAL void hel_opt P_((void)); LOCAL void hel_opt ()  { 
  WX("\n");(  WX("FunnelWeb Command Line Options\n");(  WX("------------------------------\n");N  WX("Options are of the form (\"+\" | \"=\" | \"-\") <letter> [<string>].\n");R  WX("+ turns on an option. - turns it off. = doesn't affect it's onoffedness.\n");E  WX("The case (e.g. upper or lower) of <letter> does not matter.\n"); N  WX("<string> is usually a filename or directory, but sometimes a number.\n");H  WX("Convention: f=filename, n=decimal number, h=help message name.\n");
  WX("\n");B  WX("Example: fw sloth +L +Jaardvark.xxx +W80 -Q =Twalrus.tex\n");
  WX("\n");V  WX("Action options: (choose at least one when you invoke FunnelWeb from the OS).\n");U  WX("If you choose more than one, they will be executed in the order given here.\n"); 6  WX("   +Xf   Execute specified Funnelweb script.\n");0  WX("   +Ff   Process specified input file.\n");2  WX("   +Hh   Display specified help message.\n");6  WX("   +K    Invoke FunnelWeb's interative mode.\n");
  WX("\n");  WX("Other options:\n");K  WX("   +B1   Diagnostic: Dump image of input file    to listing file.\n"); K  WX("   +B2   Diagnostic: Dump scanner's line list    to listing file.\n"); K  WX("   +B3   Diagnostic: Dump scanner's token list   to listing file.\n"); K  WX("   +B4   Diagnostic: Dump parser's macro table   to listing file.\n"); K  WX("   +B5   Diagnostic: Dump parser's document list to listing file.\n"); K  WX("   +B6   Diagnostic: Dump time breakdown report  to listing file.\n"); A  WX("   +B7   Diagnostic: Suppress non-deterministic output.\n"); Q  WX("   +Cn   Number of lines of context around diagnostics in listing file.\n"); M  WX("   +D    Delete each output file identical to its previous version.\n"); @  WX("   +If   Default file specification for include files.\n");F  WX("   +Jf   Generate journal file.  Default file specification.\n");F  WX("   +Lf   Generate listing file.  Default file specification.\n");F  WX("   +Of   Generate product files. Default file specification.\n");S  WX("   +Q    Quiet mode. Only really important messages displayed on console.\n"); H  WX("   +Tf   Generate typesetter file. Default file specification.\n");T  WX("   +Sn   Send errors to console with specified number of lines of context.\n");@  WX("   +Wn   Set maximum length of lines in product files.\n");
  WX("\n");K  WX("If an option appears more than once, the rightmost one dominates.\n"); N  WX("For more detailed information, refer to the FunnelWeb User's Manual.\n");F  WX("For default values refer to the \"DEFOPTIONS\" help message.\n"); }   P /******************************************************************************/   LOCAL void hel_dop P_((void)); LOCAL void hel_dop ()  {   op_t defop;  
  WX("\n");+  WX("FunnelWeb Default Option Settings\n"); +  WX("---------------------------------\n"); :  WX("These are the settings FunnelWeb STARTS UP with.\n");  op_ini(&defop);
  WX("\n");  op_wri(&defop,pf); 
  WX("\n");P  WX("See the OPTIONS help message for a brief description of these options.\n");N  WX("For more detailed information, refer to the FunnelWeb User's Manual.\n"); }   P /******************************************************************************/   LOCAL void hel_com P_((void)); LOCAL void hel_com ()  { 
  WX("\n");(  WX("FunnelWeb Interactive Commands\n");(  WX("------------------------------\n");T  WX("   !                       - Comment. Ignores the whole line.             \n");T  WX("   ABSENT fn               - Aborts if specified file exists.             \n");T  WX("   CODIFY ftext fC         - Convert text file into C code to write text. \n");T  WX("   COMPARE f1 f2           - Aborts if two files are different.           \n");V  WX("   DEFINE n \"text\"         - Defines $n to translate to text.             \n");T  WX("   DIFF f1 f2 logf [ABORT] - Writes differences between f1 and f2 to logf.\n");T  WX("                           - Severe if different and ABORT is present.    \n");T  WX("   DIFFSUMMARY             - Summary of differences done since DIFFZERO.  \n");T  WX("   DIFFZERO                - Zeros differences counters.                  \n");T  WX("   ENEO fn                 - Establish Non Existence Of file.             \n");T  WX("   EXECUTE fn              - Execute commands in specified file.          \n");T  WX("   EXISTS fn               - Aborts if file does not exist.               \n");T  WX("   FIXEOLS fn [outf]       - Fixes up EOL markers in specified file.      \n");T  WX("   FW options              - Invoke FunnelWeb-proper once.                \n");T  WX("   HELP [name]             - Displays specified help message.             \n");T  WX("   HERE                    - Terminates effect of SKIPTO command.         \n");T  WX("   QUIT                    - Quits FunnelWeb.                             \n");T  WX("   SET options             - Sets options.                                \n");T  WX("   SHOW                    - Displays currently active options.           \n");T  WX("   SKIPTO                  - Ignore commands until HERE command.          \n");T  WX("   STATUS                  - Write out status and diagnostic counts.      \n");T  WX("   STATUS [Sn] [En] [Wn]   - Aborts if status is not as specified.        \n");T  WX("   TOLERATE                - Don't abort script if next commmand gens err.\n");T  WX("   TRACE ON | OFF          - Turns command tracing ON or OFF.             \n");V  WX("   WRITE \"text\"            - Writes specified text to screen and journal. \n");V  WX("   WRITEU \"text\"           - Same as WRITE but underlines text.           \n");
  WX("\n");P  WX("More detailed information can be found in the FunnelWeb User's Manual.\n");
  WX("\n");O  WX("Most of these commands were created to support regression testing and\n"); T  WX("can be ignored by most users. In fact most users will never need to invoke\n");N  WX("FunnelWeb's interactive mode at all. If you are just getting started\n");P  WX("with FunnelWeb, it's probably best to run FunnelWeb directly from your\n");J  WX("command interface and ignore the +K command line option for now.\n"); }   P /******************************************************************************/   LOCAL void hel_doc P_((void)); LOCAL void hel_doc ()  { 
  WX("\n");!  WX("FunnelWeb Documentation\n"); !  WX("-----------------------\n"); =  WX("The following FunnelWeb documentation is available:\n"); 
  WX("\n");N  WX("   \"FunnelWeb User's   Manual\": Tutorial, Hints, Reference Manual.\n");O  WX("   \"FunnelWeb Hacker's Manual\": Notes on Design and Implementation.\n"); 
  WX("\n");I  WX("Everyone involved with FunnelWeb should read the User's Manual.\n"); H  WX("It contains everything you need to learn how to use FunnelWeb.\n");
  WX("\n");L  WX("The Hacker's Manual is for those who want to install, modify, fix,\n");F  WX("fiddle with, and generally hack the FunnelWeb C source code.\n");
  WX("\n");K  WX("Both of these manuals are shipped with the FunnelWeb distribution\n"); P  WX("kit, and should be available on your machine in the form of LaTeX text\n");J  WX("files. If you cannot find them, you can obtain them by FTP from:\n");
  WX("\n");F  WX("    Machine  : sirius.itd.adelaide.edu.au [IP=129.127.40.3].\n");L  WX("    Directory: ~pub/funnelweb/   (or a directory of similar name).\n");
  WX("\n"); }   P /******************************************************************************/   LOCAL void hel_reg P_((void)); LOCAL void hel_reg ()  {    WX("FunnelWeb Registration\n");   WX("----------------------\n");O  WX("If you install or use FunnelWeb, please fill in and return this form:\n"); 
  WX("\n");V  WX("   +----------------------FunnelWeb Registration Form----------------------+\n");V  WX("   | 1. Date:                                                              |\n");V  WX("   | 2. Title and name:                                                    |\n");V  WX("   | 3. Internet email address:                                            |\n");V  WX("   | 4. Snail mail address:                                                |\n");V  WX("   | 5. Work phone number (country,area,number):                           |\n");V  WX("   | 6. Which category of FunnelWeb user best describes you?               |\n");V  WX("   |       Latent    - Installed FunnelWeb, but don't intend to use it.    |\n");V  WX("   |       Beginner  - Haven't used FunnelWeb much yet; have an open mind. |\n");V  WX("   |       Casual    - Use FunnelWeb occasionally.                         |\n");V  WX("   |       Convert   - Use FunnelWeb to do most programming.               |\n");V  WX("   |       Fanatic   - FunnelWeb has become a way of life.                 |\n");V  WX("   | 7. What changes or new features would you like to see in FunnelWeb?   |\n");V  WX("   | 8. Do you want to be kept informed of new FunnelWeb developments?     |\n");X  WX("   | 9. Email this form to \"ross@spam.adelaide.edu.au\", OR snail mail to   |\n");V  WX("   |    Ross Williams, 16 Lerwick Avenue, Hazelwood Park 5066, Australia.  |\n");V  WX("   +-----------------------------------------------------------------------+\n");G  WX("To write this form to a file, use \"fw +hreg +jregform.txt\".\n"); M  WX("You may wish to make a contribution when you register. See SUPPORT.\n");  }   P /******************************************************************************/   LOCAL void hel_cop P_((void)); LOCAL void hel_cop ()  { 
  WX("\n");  WX("FunnelWeb Copyright\n");   WX("-------------------\n"); +  WX("Copyright (C) 1992 Ross Williams.\n");#
  WX("\n");U  WX("However, FunnelWeb has been released by the author and copyright owner Ross\n");=X  WX("Williams (ross@spam.adelaide.edu.au) under Version 2 of the GNU General Public\n");T  WX("License published by the Free Software Foundation. This means that you can\n");Q  WX("redistribute FunnelWeb and/or modify it under the terms of the license.\n");r
  WX("\n");R  WX("Note: This program is distributed WITHOUT ANY WARRANTY; without even the\n");R  WX("implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n");
  WX("\n");B  WX("The following help messages provide further information:\n");
  WX("\n");Y  WX("   License       - The license under which this software is distributed (long).\n");hR  WX("   DIstribution  - Extract from the GNU license concerning distribution.\n");V  WX("   Nowarranty    - Extract from the GNU license concerning lack of warranty.\n");Q  WX("   MOdification  - Read this message if you intend to modify FunnelWeb.\n"); O  WX("   Registration  - How to register as an \"official\" FunnelWeb user.\n");d
  WX("\n"); }   P /******************************************************************************/   LOCAL void hel_now P_((void)); LOCAL void hel_now ()  { 
  WX("\n");*  WX("FunnelWeb Comes With No Warranty\n");*  WX("--------------------------------\n");W  WX("Here is an extract from the GNU General Public License Version 2, under which\n");*V  WX("FunnelWeb is distributed. See help message \"LICENSE\" for the full license.\n");
  WX("\n");W  WX("     11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY\n");*U  WX("   FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN\n");*S  WX("   OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES\n");=Y  WX("   PROVIDE THE PROGRAM \"AS IS\" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED\n");aQ  WX("   OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF\n"); V  WX("   MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS\n");S  WX("   TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE\n");aU  WX("   PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,\n"); "  WX("   REPAIR OR CORRECTION.\n");
  WX("\n");X  WX("     12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING\n");P  WX("   WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR\n");W  WX("   REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,\n"); X  WX("   INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING\n");V  WX("   OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED\n");U  WX("   TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY\n");iW  WX("   YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER\n");*R  WX("   PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE\n");)  WX("   POSSIBILITY OF SUCH DAMAGES.\n");t }u  P /******************************************************************************/   LOCAL void hel_dis P_((void)); LOCAL void hel_dis ()* {e
  WX("\n");   WX("FunnelWeb Distribution\n");   WX("----------------------\n");T  WX("The following is an extract from the GNU General Public License Version 2,\n");/  WX("under which FunnelWeb is distributed.\n");*
  WX("\n");N  WX("     1. You may copy and distribute verbatim copies of the Program's\n");L  WX("   source code as you receive it, in any medium, provided that you\n");P  WX("   conspicuously and appropriately publish on each copy an appropriate\n");M  WX("   copyright notice and disclaimer of warranty; keep intact all the\n");fS  WX("   notices that refer to this License and to the absence of any warranty;\n");mP  WX("   and give any other recipients of the Program a copy of this License\n");$  WX("   along with the Program.\n");
  WX("\n");R  WX("   You may charge a fee for the physical act of transferring a copy, and\n");T  WX("   you may at your option offer warranty protection in exchange for a fee.\n");
  WX("\n");Q  WX("The license also allows you other freedoms.  For more information refer\n");rJ  WX("to the full text of the license in the help message \"LICENSE\".\n"); }d  P /******************************************************************************/   LOCAL void hel_ack P_((void)); LOCAL void hel_ack ()  {(
  WX("\n");$  WX("FunnelWeb Acknowledgements\n");$  WX("--------------------------\n");O  WX("The following people assisted with the preparation of FunnelWeb V3.0.\n");\
  WX("\n");Y  WX("Many thanks go to DAVID HULSE (dave@cs.adelaide.edu.au) who translated the 1986\n");TW  WX("version of FunnelWeb (V1) written in Ada into a public domain C version (V2).\n");\R  WX("The C code written by David formed the basis of V3 of FunnelWeb, but was\n");R  WX("entirely rewritten during the intensive refinement and feature-injection\n");Q  WX("period leading up to this release (V3 is about 3 times the size of V2).\n");*
  WX("\n");R  WX("Thanks go to SIMON HACKETT (simon@internode.com.au) of Internode Systems\n");P  WX("Pty Ltd for the use of his Sun, Mac, and PC, for assistance in porting\n");C  WX("FunnelWeb to the Sun and PC, and for helpful discussions.\n");"
  WX("\n");O  WX("Thanks go to JEREMY BEGG (jeremy@vsm.com.au) of VSM Software Services\n"); P  WX("for the use of his VAX, and for assistance with the VMS-specific code.\n");
  WX("\n");A  WX("Ross Williams (ross@spam.adelaide.edu.au), 12 May 1992.\n");p }   P /******************************************************************************/   LOCAL void hel_ver P_((void)); LOCAL void hel_ver ()m { 
  WX("\n");  WX("FunnelWeb Versions\n");  WX("------------------\n");Q  WX("FunnelWeb was created in 1986 and was used extensively by Ross Williams\n"); W  WX("(ross@spam.adelaide.edu.au) for three years. However, Version 1.0 was written\n");"X  WX("in Ada and was not very portable (it was fairly VAX/VMS specific). David Hulse\n");X  WX("(dave@cs.adelaide.edu.au) took the first step towards a release by translating\n");Y  WX("the Ada code into C. Ross Williams then extensively reworked the C code, making\n");(V  WX("it robust and portable, adding new features, and polishing it to its current\n");  WX("form.\n");l
  WX("\n");X  WX("Vers  Lang  Created  Released   Author          Copyright      Licensing      \n");X  WX("----  ----  -------  --------   --------------  -------------  ---------      \n");X  WX("V1.0  Ada   1986     Never      Ross  Williams  Ross Williams                 \n");X  WX("V2.0  C     1989     Never      David Hulse     Public domain  No restriction.\n");X  WX("V3.0  C     1992     May-1992   Ross  Williams  Ross Williams  GNU release.   \n");
  WX("\n");S  WX("This is FunnelWeb Version 3.0. Unless otherwise specified, all references\n");nP  WX("in this release to \"FunnelWeb\" refer either to the abstract identity\n");B  WX("of FunnelWeb, or to this version, FunnelWeb Version 3.0.\n"); }   P /******************************************************************************/   LOCAL void hel_sup P_((void)); LOCAL void hel_sup ()W {<
  WX("\n");  WX("FunnelWeb Support\n");y  WX("-----------------\n");;T  WX("FunnelWeb is released \"as is\" under a GNU license, and no formal support\n");R  WX("is available. You have the right to make changes to FunnelWeb and to use\n");O  WX("the modified versions created by random programmers. However, this is\n");":  WX("discouraged (see the MODIFICATION help message).\n");
  WX("\n");S  WX("In fact the support that is most needed is your financial support for the\n");FU  WX("FunnelWeb developers! It has taken MONTHS of full-time UNPAID work to bring\n");"S  WX("FunnelWeb to you in its current form. I don't want to inconvenience users\n");tV  WX("who install FunnelWeb, play with it, and then hardly ever use it. If you are\n");T  WX("in this category, please register, but don't bother contributing. However,\n");Y  WX("if you find that FunnelWeb has become a useful programming tool, a contribution\n");oB  WX("of some positive multiple of US$50 would be appreciated.\n");
  WX("\n");Q  WX("To make a contribution, send payment with a completed registration form\n");u1  WX("(see the REGISTRATION help message) to:\n");W
  WX("\n");)  WX("   Renaissance Software Pty Ltd\n");u-  WX("   Email: ross@spam.adelaide.edu.au\n");eF  WX("   Snail: 16 Lerwick Avenue, Hazelwood Park 5066, Australia.\n");
  WX("\n");R  WX("Payment can be by personal or bank cheque to any bank in the world or by\n");Q  WX("Visa or Mastercard. Please give the card name, number, expiry date, and\n");aT  WX("the amount to be paid in US dollars. All contributions will be appreciated\n");S  WX("and will encourage further FunnelWeb development. However, no undertaking\n");u>  WX("is made whatsoever about how the money will be used.\n");
  WX("\n");A  WX("Ross Williams (ross@spam.adelaide.edu.au), 12 May 1992.\n");  }(  P /******************************************************************************/   LOCAL void hel_mod P_((void)); LOCAL void hel_mod ()\ {;
  WX("\n");!  WX("FunnelWeb Modifications\n");a!  WX("-----------------------\n");.V  WX("FunnelWeb is distributed under a GNU license, and you are free to modify the\n");T  WX("source code and distribute modified copies (see the help message LICENSE).\n");J  WX("However, there are good reasons why you should avoid doing this.\n");
  WX("\n");U  WX("   1) If you distribute modified versions of FunnelWeb, you run the risk of\n");WR  WX("   creating a version that will diverge from the \"official\" version of\n");2  WX("   FunnelWeb which I intend to maintain.\n");
  WX("\n");T  WX("   2) If you release a version of FunnelWeb with a changed input language,\n");Q  WX("   users of your modified version will create source files that will no\n");iR  WX("   longer work on other versions of FunnelWeb. The result will be chaos.\n");
  WX("\n");U  WX("For these reasons I request that you do not distribute modified versions of\n");lY  WX("FunnelWeb, particularly versions with a modified language. However, if you must\n");-U  WX("distribute a version with a modified language, PLEASE CHANGE ITS NAME (i.e.\n"); Z  WX("from \"FunnelWeb\" to something else). Please also allocate a new file extension\n");V  WX("to replace \".fw\" as the extension for source files written in the modified\n");Q  WX("language. For more information, refer to the FunnelWeb Hacker's Manual.\n"); 
  WX("\n");A  WX("Ross Williams (ross@spam.adelaide.edu.au), 12 May 1992.\n");  }   P /******************************************************************************/  & LOCAL bool prefeq P_((char *,char *));# LOCAL bool prefeq (p_pref,p_target) P /* Returns TRUE iff string p_pref is a case insensitive prefix of p_target.   */
 char *p_pref;O char *p_target;  {F  char *p,*q;  '  if (strlen(p_pref) > strlen(p_target))      return FALSE;(  
  p=p_pref;  q=p_target;  while (*p != EOS)    {1     if (toupper(*p) != toupper(*q)) return FALSE;      p++;     q++;    }
  return TRUE;i }   P /******************************************************************************/   EXPORT uword hel_num (p_name) 
 char *p_name;  {i  uword matches = 0;   uword messnum;   P  /* We want to be fairly lenient on the user here as the user is trying to    */P  /* obtain help and will probably get annoyed and give up if it doesn't work, */P  /* so we perform case insensitive prefix matching.  However, we don't want   */P  /* to match if the user inputs a prefix that matches two message names. This */P  /* means we can't just return when we find a match; we have to see if there  */P  /* are any others as well.                                                   */  A  if (prefeq(p_name,"MENU"         )) {messnum=HL_MEN; matches++;}oA  if (prefeq(p_name,"INTRODUCTION" )) {messnum=HL_INT; matches++;} A  if (prefeq(p_name,"OPTIONS"      )) {messnum=HL_OPT; matches++;}WA  if (prefeq(p_name,"DEFOPTIONS"   )) {messnum=HL_DOP; matches++;}dA  if (prefeq(p_name,"COMMANDS"     )) {messnum=HL_COM; matches++;}tA  if (prefeq(p_name,"DOCUMENTATION")) {messnum=HL_DOC; matches++;} A  if (prefeq(p_name,"REGISTRATION" )) {messnum=HL_REG; matches++;}"A  if (prefeq(p_name,"LICENSE"      )) {messnum=HL_GNU; matches++;}"A  if (prefeq(p_name,"COPYRIGHT"    )) {messnum=HL_COP; matches++;}sA  if (prefeq(p_name,"NOWARRANTY"   )) {messnum=HL_NOW; matches++;}cA  if (prefeq(p_name,"DISTRIBUTION" )) {messnum=HL_DIS; matches++;}MA  if (prefeq(p_name,"ACKNOWLEDGE"  )) {messnum=HL_ACK; matches++;}dA  if (prefeq(p_name,"VERSIONS"     )) {messnum=HL_VER; matches++;}nA  if (prefeq(p_name,"SUPPORT"      )) {messnum=HL_SUP; matches++;} A  if (prefeq(p_name,"MODIFICATION" )) {messnum=HL_MOD; matches++;}b  !  if (matches != 1) return HL_ERR;r    return messnum; }a  P /******************************************************************************/  # EXPORT void hel_wri (p_outf,messno)* void (*p_outf) P_((char *));
 uword messno;l {c?  as_cold(     1 <= messno, "hel_wri: Message number is zero.");WN  as_cold(messno <= HL_MAX, "hel_wri: Message number is greater than HL_MAX.");  .  /* Set the global output function pointer. */  pf=p_outf;     switch(messno)     {"     case HL_MEN: hel_men(); break;"     case HL_INT: hel_int(); break;"     case HL_OPT: hel_opt(); break;"     case HL_DOP: hel_dop(); break;"     case HL_COM: hel_com(); break;"     case HL_DOC: hel_doc(); break;"     case HL_REG: hel_reg(); break;F     case HL_GNU: hel_gnu(p_outf); break; /* Calling another module. */"     case HL_COP: hel_cop(); break;"     case HL_NOW: hel_now(); break;"     case HL_DIS: hel_dis(); break;"     case HL_ACK: hel_ack(); break;"     case HL_VER: hel_ver(); break;"     case HL_SUP: hel_sup(); break;"     case HL_MOD: hel_mod(); break;7     default    : as_bomb("hel_wri: switch defaulted.");s    } }c  P /******************************************************************************/P /*                               End of HELP.C                                */P /******************************************************************************/