P /*##############################################################################   FUNNNELWEB COPYRIGHT ====================7 FunnelWeb is a literate-programming macro preprocessor.   $ Copyright (C) 1992 Ross N. Williams.      Ross N. Williams     ross@spam.adelaide.edu.au5    16 Lerwick Avenue, Hazelwood Park 5066, Australia.   D This program is free software; you can redistribute it and/or modifyD it under the terms of Version 2 of the GNU General Public License as* published by the Free Software Foundation.  J This program is distributed WITHOUT ANY WARRANTY; without even the implied@ warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.A See Version 2 of the GNU General Public License for more details.   F You should have received a copy of Version 2 of the GNU General PublicE License along with this program. If not, you can FTP the license from ? prep.ai.mit.edu/pub/gnu/COPYING-2 or write to the Free Software 9 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   C Section 2a of the license requires that all changes to this file be B recorded prominently in this file. Please record all changes here.   Programmers:3    RNW  Ross N. Williams  ross@spam.adelaide.edu.au    Changes:C    07-May-1992  RNW  Program prepared for release under GNU GPL V2.   P ##############################################################################*/    P /******************************************************************************/P /*                                   HELP.H                                   */P /******************************************************************************/P /*                                                                            */P /* HELP PACKAGE                                                               */P /* ============                                                               */P /* As I came closer and closer to completing the release version of           */P /* FunnelWeb, I noticed that the online help was a bit of a mess. I had       */P /* random commands and command line options here and there to provide bits of */P /* information. After a close look and some thought, I decided to centralize  */P /* all of FunnelWeb's help messages into one module, and provide a clean and  */P /* consistent interface to the help messages, both in the command line, and   */P /* in interactive mode.                                                       */P /*                                                                            */P /* The result is that all of the help messages have been  moved to            */P /* this module. Each help message has a name consisting of a string. One      */P /* particular message has the name "MENU" and is the root help message (the   */P /* "menu message"). It contains a list of all the help messages available and */P /* their names.                                                               */P /*                                                                            */P /* The command line connects to help by providing a single command line       */P /* option called +Hx which has the effect of displaying the help message      */P /* called x. The default is -Hmenu. The "-" means that help is not invoked by */P /* default, but that if the user specifies +H, the menu message will be       */P /* printed. If the user specifies (say) +Hsloth, message SLOTH will be        */P /* displayed. The menu message is printed if the user invokes FunnelWeb with  */P /* no actions. The +H option is classified as an action option.               */P /*                                                                            */P /* Interactive mode connects to help through the HELP command. In the spirit  */P /* of the command line interface, if no argument is given, the menu message   */P /* is displayed. If an argument is given, the specified message is written    */P /* out.                                                                       */P /*                                                                            */P /* This module contributes two things to this process:                        */P /*    1) Provides a mapping from message names to messages.                   */P /*    2) Acts as a repository for the messages themselves.                    */P /*                                                                            */P /******************************************************************************/  P /* Ensure that the body of this header file is included at most once.         */ #ifndef DONE_HELP  #define DONE_HELP   P /******************************************************************************/   #include "style.h"  P /******************************************************************************/  P /* Place a bound on help name length, and define an array type to hold them.  */ #define HL_NMLEN 20  typedef char hn_t[HL_NMLEN+1];  P /******************************************************************************/  P /* Each of the messages has a unique symbol and number. The reason for        */P /* defining these symbols instead of just using the message names in the code */P /* is that doing it this way allows us to change the exact message names      */P /* without having to track down all their occurences in the code, or getting  */P /* nasty surprises later down the track at run time (the compiler will tell   */P /* you in a call containing HL_SLT that the symbol doesn't exist, but it      */P /* won't complain about a string argument that just happens not to be the     */P /* name of a message anymore).                                                */  ) /* HL_ERR is the non-existent message. */  #define HL_ERR 0  ) /* HL_MEN - Help messages.             */ ) /* HL_INT - Introduction to FunnelWeb. */ ) /* HL_OPT - Command line options.      */ ) /* HL_DOP - Option defaults.           */ ) /* HL_COM - Interactive commands.      */ ) /* HL_DOC - Documentation.             */ ) /* HL_REG - Registration.              */ ) /* HL_LIC - The GNU License.           */ ) /* HL_COP - Copyright notice.          */ ) /* HL_NOW - No Warranty notice.        */ ) /* HL_DIS - Distribution notice.       */ ) /* HL_ACK - Acknowledgements.          */ ) /* HL_VER - Versions.                  */ ) /* HL_SUP - Support.                   */ ) /* HL_MOD - Modifications.             */  #define HL_MEN  1  #define HL_INT  2  #define HL_OPT  3  #define HL_DOP  4  #define HL_COM  5  #define HL_DOC  6  #define HL_REG  7  #define HL_GNU  8  #define HL_COP  9  #define HL_NOW 10  #define HL_DIS 11  #define HL_ACK 12  #define HL_VER 13  #define HL_SUP 14  #define HL_MOD 15   P /* The following symbol does not represent a message. It is the number of     */P /* messages. This is useful for range checking and possibly in for loops.     */ #define HL_MAX 15   P /******************************************************************************/  " EXPORT uword hel_num P_((char *));P /* Accepts a character string that is supposed to be the name of a message    */P /* and returns the number of the message, or HL_ERR if the string does not    */P /* correspond to any defined message. A match will occur if the argument      */P /* string is the same (with case independent matching) as the prefix (of      */P /* corresponding length) of exactly one message name.                         */  1 EXPORT void hel_wri P_((void (*)(char *),uword)); P /* Accepts a message number and writes the message using the function         */P /* provided in the first argument. Bombs the program if the message number in */P /* the second argument is not in the range [1,HL_MAX].                        */  P /******************************************************************************/  P /* For #ifndef preventing multiple inclusion of the body of this header file. */ #endif  P /******************************************************************************/P /*                               End of HELP.H                                */P /******************************************************************************/