P /*##############################################################################   FUNNNELWEB COPYRIGHT ====================7 FunnelWeb is a literate-programming macro preprocessor.   $ Copyright (C) 1992 Ross N. Williams.      Ross N. Williams     ross@spam.adelaide.edu.au5    16 Lerwick Avenue, Hazelwood Park 5066, Australia.   D This program is free software; you can redistribute it and/or modifyD it under the terms of Version 2 of the GNU General Public License as* published by the Free Software Foundation.  J This program is distributed WITHOUT ANY WARRANTY; without even the implied@ warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.A See Version 2 of the GNU General Public License for more details.   F You should have received a copy of Version 2 of the GNU General PublicE License along with this program. If not, you can FTP the license from ? prep.ai.mit.edu/pub/gnu/COPYING-2 or write to the Free Software 9 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   C Section 2a of the license requires that all changes to this file be B recorded prominently in this file. Please record all changes here.   Programmers:3    RNW  Ross N. Williams  ross@spam.adelaide.edu.au    Changes:C    07-May-1992  RNW  Program prepared for release under GNU GPL V2.   P ##############################################################################*/    P /******************************************************************************/P /*                                 HELP_GNU.C                                 */P /******************************************************************************/P /*                                                                            */P /* REPRESENTING MESSAGES AS C CODE                                            */P /* ===============================                                            */P /* Experience has shown that it is much more reliable to code text messages   */P /* into a program than to expect the program to track down text files         */P /* containing the messages at run time. Worthwhile for smallish files (such   */P /* as these help messages) at least. For this reason, all the messages in     */P /* this module are represented by code (e.g. as in printf statements).        */P /*                                                                            */P /* There is no difficulty turning a short message into code; simply place it  */P /* in output statements. However, large messages (e.g. the GNU license) are   */P /* more tedious, and also present more of a problem if it is necessary to     */P /* change them substantially at a later date. This problem has been solved in */P /* FunnelWeb by writing a small program that reads a text file and writes out */P /* C code that writes the text file. The files involved are:                  */P /*                                                                            */P /*    help_gnu.mes - The original message.                                    */P /*    help_gnu.c   - C code to write out the original message.                */P /*                                                                            */P /* To turn help_gnu.mes into help_gnu.c, give the following command in        */P /* FunnelWeb interactive mode: codify help_gnu.txt help_gnu.c                 */P /*                                                                            */P /******************************************************************************/   #include "style.h"   #include "help_gnu.h"   P /******************************************************************************/  P /* This module contains many many output statements that call an output       */P /* function. To neaten up all these calls, we define a global variable to     */P /* hold a pointer to the function and simple macro to write output using      */P /* the function.                                                              */ LOCVAR void (*pf) P_((char *));   & #define WX(STR) (*pf)(STR);(*pf)("\n") #define WY(STR) (*pf)(STR)  P /******************************************************************************/   EXPORT void hel_gnu (p_outf) void (*p_outf) P_((char *)); {   pf=p_outf; 
  WY("\n");  WY("FunnelWeb License\n");   WY("-----------------\n"); ?  WY("FunnelWeb is distributed under the following license.\n"); 
  WY("\n");$  WY("--<Start of GNU License>--\n"); #include "help_gnu.ctx" "  WY("--<End of GNU License>--\n");
  WY("\n");P  WY("If all that scrolled off your screen too quickly, don't worry. You can\n");K  WY("capture this message (or any other FunnelWeb output) in a file by\n"); J  WY("specifying the +J option when you invoke FunnelWeb. For example:\n");
  WY("\n");*  WY("       fw +hlicense +jresult.txt\n");
  WY("\n"); }   P /******************************************************************************/P /*                             End of HELP_GNU.C                              */P /******************************************************************************/